/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.protocol.sdk.properties;

import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.protocol.sdk.constants.ConsoleItemType;
import org.openspcoop2.protocol.sdk.constants.ConsoleItemValueType;
import org.openspcoop2.protocol.sdk.properties.AbstractConsoleItem;
import org.openspcoop2.protocol.sdk.properties.BaseConsoleItem;
import org.openspcoop2.protocol.sdk.properties.BinaryConsoleItem;
import org.openspcoop2.protocol.sdk.properties.BinaryProperty;
import org.openspcoop2.protocol.sdk.properties.BooleanConsoleItem;
import org.openspcoop2.protocol.sdk.properties.BooleanProperty;
import org.openspcoop2.protocol.sdk.properties.NumberConsoleItem;
import org.openspcoop2.protocol.sdk.properties.NumberProperty;
import org.openspcoop2.protocol.sdk.properties.StringConsoleItem;
import org.openspcoop2.protocol.sdk.properties.StringProperty;
import org.openspcoop2.protocol.sdk.properties.SubtitleConsoleItem;
import org.openspcoop2.protocol.sdk.properties.TitleConsoleItem;
import org.openspcoop2.utils.sql.LikeConfig;

public class ProtocolPropertiesFactory {
    private ProtocolPropertiesFactory() {
    }

    public static BaseConsoleItem newTitleItem(String id, String label) throws ProtocolException {
        return new TitleConsoleItem(id, label);
    }

    public static BaseConsoleItem newSubTitleItem(String id, String label) throws ProtocolException {
        return new SubtitleConsoleItem(id, label);
    }

    public static BaseConsoleItem newNoteItem(String id, String label) throws ProtocolException {
        return new BaseConsoleItem(id, label, ConsoleItemType.NOTE);
    }

    public static AbstractConsoleItem<?> newConsoleItem(ConsoleItemType itemType, String id, String label) throws ProtocolException {
        return ProtocolPropertiesFactory.newConsoleItem(ConsoleItemValueType.STRING, itemType, id, label);
    }

    public static AbstractConsoleItem<?> newConsoleItem(ConsoleItemValueType type, ConsoleItemType itemType, String id, String label) throws ProtocolException {
        switch (type) {
            case STRING: {
                return new StringConsoleItem(id, label, itemType);
            }
            case NUMBER: {
                return new NumberConsoleItem(id, label, itemType);
            }
            case BOOLEAN: {
                return new BooleanConsoleItem(id, label, itemType);
            }
            case BINARY: {
                return new BinaryConsoleItem(id, label, itemType);
            }
        }
        throw new ProtocolException("Type [" + type + "] unsupported");
    }

    public static AbstractConsoleItem<?> newBinaryConsoleItem(ConsoleItemType itemType, String id, String label, String fileName, String fileId) throws ProtocolException {
        return new BinaryConsoleItem(id, label, itemType, fileName, fileId);
    }

    public static BinaryProperty newProperty(String id, byte[] value, String fileName, String fileId) {
        return new BinaryProperty(id, value, fileName, fileId);
    }

    public static NumberProperty newProperty(String id, Long value) {
        return new NumberProperty(id, value);
    }

    public static NumberProperty newProperty(String id, Integer value) {
        return new NumberProperty(id, value != null ? Long.valueOf(value.longValue()) : null);
    }

    public static BooleanProperty newProperty(String id, Boolean value) {
        return new BooleanProperty(id, value);
    }

    public static StringProperty newProperty(String id, String value) {
        return new StringProperty(id, value);
    }

    public static StringProperty newProperty(String id, String value, LikeConfig searchWithLike) {
        return new StringProperty(id, value, searchWithLike);
    }
}

