/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.protocol.sdk.archive;

import org.openspcoop2.core.config.ServizioApplicativo;
import org.openspcoop2.core.id.IDServizioApplicativo;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.protocol.sdk.archive.ArchiveIdCorrelazione;
import org.openspcoop2.protocol.sdk.archive.IArchiveObject;

public class ArchiveServizioApplicativo
implements IArchiveObject {
    private IDSoggetto idSoggettoProprietario;
    private IDServizioApplicativo idServizioApplicativo;
    private ServizioApplicativo servizioApplicativo;
    private ArchiveIdCorrelazione idCorrelazione;

    public static String buildKey(String tipoSoggetto, String nomeSoggetto, String nomeSA) throws ProtocolException {
        if (tipoSoggetto == null) {
            throw new ProtocolException("tipoSoggetto non fornito");
        }
        if (nomeSoggetto == null) {
            throw new ProtocolException("nomeSoggetto non fornito");
        }
        if (nomeSA == null) {
            throw new ProtocolException("nomeSA non fornito");
        }
        StringBuilder bf = new StringBuilder();
        bf.append("ServizioApplicativo_");
        bf.append(tipoSoggetto);
        bf.append("/");
        bf.append(nomeSoggetto);
        bf.append("_");
        bf.append(nomeSA);
        return bf.toString();
    }

    @Override
    public String key() throws ProtocolException {
        return ArchiveServizioApplicativo.buildKey(this.idSoggettoProprietario.getTipo(), this.idSoggettoProprietario.getNome(), this.idServizioApplicativo.getNome());
    }

    public ArchiveServizioApplicativo(IDSoggetto idSoggettoProprietario, ServizioApplicativo servizioApplicativo, ArchiveIdCorrelazione idCorrelazione) throws ProtocolException {
        this(ArchiveServizioApplicativo.injectProprietario(idSoggettoProprietario, servizioApplicativo), idCorrelazione, false);
    }

    public ArchiveServizioApplicativo(IDSoggetto idSoggettoProprietario, ServizioApplicativo servizioApplicativo, ArchiveIdCorrelazione idCorrelazione, boolean informationMissingManagementEnabled) throws ProtocolException {
        this(ArchiveServizioApplicativo.injectProprietario(idSoggettoProprietario, servizioApplicativo), idCorrelazione, informationMissingManagementEnabled);
    }

    public ArchiveServizioApplicativo(ServizioApplicativo servizioApplicativo, ArchiveIdCorrelazione idCorrelazione) throws ProtocolException {
        this(servizioApplicativo, idCorrelazione, false);
    }

    public ArchiveServizioApplicativo(ServizioApplicativo servizioApplicativo, ArchiveIdCorrelazione idCorrelazione, boolean informationMissingManagementEnabled) throws ProtocolException {
        this.update(servizioApplicativo, informationMissingManagementEnabled);
        this.idCorrelazione = idCorrelazione;
    }

    private static ServizioApplicativo injectProprietario(IDSoggetto idSoggettoProprietario, ServizioApplicativo servizioApplicativo) throws ProtocolException {
        if (servizioApplicativo == null) {
            throw new ProtocolException("ServizioApplicativo non fornito");
        }
        if (idSoggettoProprietario == null) {
            throw new ProtocolException("idSoggettoProprietario non fornito");
        }
        if (idSoggettoProprietario.getTipo() == null) {
            throw new ProtocolException("idSoggettoProprietario.tipo non definito");
        }
        if (idSoggettoProprietario.getNome() == null) {
            throw new ProtocolException("idSoggettoProprietario.nome non definito");
        }
        servizioApplicativo.setTipoSoggettoProprietario(idSoggettoProprietario.getTipo());
        servizioApplicativo.setNomeSoggettoProprietario(idSoggettoProprietario.getNome());
        return servizioApplicativo;
    }

    public void update() throws ProtocolException {
        this.update(this.servizioApplicativo, false);
    }

    public void update(ServizioApplicativo servizioApplicativo) throws ProtocolException {
        this.update(servizioApplicativo, false);
    }

    public void update(ServizioApplicativo servizioApplicativo, boolean informationMissingManagementEnabled) throws ProtocolException {
        if (servizioApplicativo == null) {
            throw new ProtocolException("ServizioApplicativo non fornito");
        }
        if (servizioApplicativo.getNome() == null) {
            throw new ProtocolException("ServizioApplicativo.nome non definito");
        }
        this.servizioApplicativo = servizioApplicativo;
        if (!informationMissingManagementEnabled) {
            if (this.servizioApplicativo.getTipoSoggettoProprietario() == null) {
                throw new ProtocolException("ServizioApplicativo.tipoSoggettoProprietario non definito");
            }
            if (this.servizioApplicativo.getNomeSoggettoProprietario() == null) {
                throw new ProtocolException("ServizioApplicativo.nomeSoggettoProprietario non definito");
            }
            this.idSoggettoProprietario = new IDSoggetto(this.servizioApplicativo.getTipoSoggettoProprietario(), this.servizioApplicativo.getNomeSoggettoProprietario());
            this.idServizioApplicativo = new IDServizioApplicativo();
            this.idServizioApplicativo.setIdSoggettoProprietario(this.idSoggettoProprietario);
            this.idServizioApplicativo.setNome(this.servizioApplicativo.getNome());
        }
    }

    public IDSoggetto getIdSoggettoProprietario() {
        return this.idSoggettoProprietario;
    }

    public IDServizioApplicativo getIdServizioApplicativo() {
        return this.idServizioApplicativo;
    }

    public ServizioApplicativo getServizioApplicativo() {
        return this.servizioApplicativo;
    }

    public ArchiveIdCorrelazione getIdCorrelazione() {
        return this.idCorrelazione;
    }
}

