/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.protocol.basic.validator;

import javax.xml.soap.SOAPFault;
import org.openspcoop2.message.OpenSPCoop2Message;
import org.openspcoop2.message.OpenSPCoop2SoapMessage;
import org.openspcoop2.message.constants.ServiceBinding;
import org.openspcoop2.protocol.basic.BasicStateComponentFactory;
import org.openspcoop2.protocol.sdk.Busta;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.protocol.sdk.config.IProtocolVersionManager;
import org.openspcoop2.protocol.sdk.config.ITraduttore;
import org.openspcoop2.protocol.sdk.constants.MessaggiFaultErroreCooperazione;
import org.openspcoop2.protocol.sdk.state.IState;
import org.openspcoop2.protocol.sdk.validator.IValidatoreErrori;
import org.openspcoop2.protocol.sdk.validator.ProprietaValidazioneErrori;

public class ValidatoreErrori
extends BasicStateComponentFactory
implements IValidatoreErrori {
    private ITraduttore costanti;

    public ValidatoreErrori(IProtocolFactory<?> protocolFactory, IState state) throws ProtocolException {
        super(protocolFactory, state);
        this.costanti = protocolFactory.createTraduttore();
    }

    @Override
    public boolean isBustaErrore(Busta busta, OpenSPCoop2Message msg, ProprietaValidazioneErrori proprietaValidazioneErrori) {
        boolean eccezioneProcessamento = false;
        try {
            OpenSPCoop2SoapMessage soapMessage;
            if (msg != null && ServiceBinding.SOAP.equals((Object)msg.getServiceBinding()) && (soapMessage = msg.castAsSoap()).hasSOAPFault()) {
                SOAPFault soapFault = soapMessage.getSOAPBody().getFault();
                String faultS = soapFault.getFaultString();
                if (faultS != null) {
                    faultS = faultS.trim();
                }
                eccezioneProcessamento = this.costanti.toString(MessaggiFaultErroreCooperazione.FAULT_STRING_PROCESSAMENTO).equals(faultS) || this.costanti.toString(MessaggiFaultErroreCooperazione.FAULT_STRING_VALIDAZIONE).equals(faultS);
            }
        }
        catch (Exception e) {
            this.log.error("Errore durante l'analisi per comprendere se un msg e' una busta Errore: " + e.getMessage(), (Throwable)e);
        }
        if (eccezioneProcessamento) {
            return true;
        }
        IProtocolVersionManager pManager = null;
        try {
            pManager = this.protocolFactory.createProtocolVersionManager(proprietaValidazioneErrori.getVersioneProtocollo());
        }
        catch (Exception e) {
            this.log.error("Errore durante la createProtocolManager: " + e.getMessage(), (Throwable)e);
        }
        if (pManager != null && pManager.isIgnoraEccezioniLivelloNonGrave() || proprietaValidazioneErrori.isIgnoraEccezioniNonGravi()) {
            return busta.containsEccezioniGravi();
        }
        return busta.sizeListaEccezioni() > 0;
    }

    @Override
    public boolean isBustaErroreProcessamento(Busta busta, OpenSPCoop2Message msg, ProprietaValidazioneErrori proprietaValidazioneErrori) {
        boolean eccezioneProcessamento = false;
        try {
            OpenSPCoop2SoapMessage soapMessage;
            if (msg != null && ServiceBinding.SOAP.equals((Object)msg.getServiceBinding()) && (soapMessage = msg.castAsSoap()).hasSOAPFault()) {
                SOAPFault soapFault = soapMessage.getSOAPBody().getFault();
                String faultS = soapFault.getFaultString();
                if (faultS != null) {
                    faultS = faultS.trim();
                }
                if (this.costanti.toString(MessaggiFaultErroreCooperazione.FAULT_STRING_PROCESSAMENTO).equals(faultS)) {
                    eccezioneProcessamento = true;
                }
            }
        }
        catch (Exception e) {
            this.log.error("Errore durante l'analisi per comprendere se un msg e' una busta Errore: " + e.getMessage(), (Throwable)e);
        }
        return eccezioneProcessamento;
    }

    @Override
    public boolean isBustaErroreIntestazione(Busta busta, OpenSPCoop2Message msg, ProprietaValidazioneErrori proprietaValidazioneErrori) {
        boolean eccezioneProcessamento = false;
        try {
            OpenSPCoop2SoapMessage soapMessage;
            if (msg != null && ServiceBinding.SOAP.equals((Object)msg.getServiceBinding()) && (soapMessage = msg.castAsSoap()).hasSOAPFault()) {
                SOAPFault soapFault = soapMessage.getSOAPBody().getFault();
                String faultS = soapFault.getFaultString();
                if (faultS != null) {
                    faultS = faultS.trim();
                }
                if (this.costanti.toString(MessaggiFaultErroreCooperazione.FAULT_STRING_VALIDAZIONE).equals(faultS)) {
                    return true;
                }
                if (this.costanti.toString(MessaggiFaultErroreCooperazione.FAULT_STRING_PROCESSAMENTO).equals(faultS)) {
                    eccezioneProcessamento = true;
                }
            }
        }
        catch (Exception e) {
            this.log.error("Errore durante l'analisi per comprendere se un msg e' una busta Errore: " + e.getMessage(), (Throwable)e);
        }
        if (eccezioneProcessamento) {
            return false;
        }
        IProtocolVersionManager pManager = null;
        try {
            pManager = this.protocolFactory.createProtocolVersionManager(proprietaValidazioneErrori.getVersioneProtocollo());
        }
        catch (Exception e) {
            this.log.error("Errore durante la createProtocolManager: " + e.getMessage(), (Throwable)e);
        }
        if (pManager != null && pManager.isIgnoraEccezioniLivelloNonGrave() || proprietaValidazioneErrori.isIgnoraEccezioniNonGravi()) {
            return busta.containsEccezioniGravi();
        }
        return busta.sizeListaEccezioni() > 0;
    }
}

