/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.protocol.basic.tracciamento;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.openspcoop2.core.constants.TipoPdD;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.protocol.basic.ProtocolliRegistrati;
import org.openspcoop2.protocol.basic.tracciamento.TracciaSearchType;
import org.openspcoop2.protocol.sdk.Allegato;
import org.openspcoop2.protocol.sdk.Busta;
import org.openspcoop2.protocol.sdk.Eccezione;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.Riscontro;
import org.openspcoop2.protocol.sdk.Trasmissione;
import org.openspcoop2.protocol.sdk.config.ITraduttore;
import org.openspcoop2.protocol.sdk.constants.CodiceErroreCooperazione;
import org.openspcoop2.protocol.sdk.constants.ContestoCodificaEccezione;
import org.openspcoop2.protocol.sdk.constants.EsitoElaborazioneMessaggioTracciatura;
import org.openspcoop2.protocol.sdk.constants.Inoltro;
import org.openspcoop2.protocol.sdk.constants.LivelloRilevanza;
import org.openspcoop2.protocol.sdk.constants.ProfiloDiCollaborazione;
import org.openspcoop2.protocol.sdk.constants.RuoloMessaggio;
import org.openspcoop2.protocol.sdk.constants.SubCodiceErrore;
import org.openspcoop2.protocol.sdk.constants.TipoOraRegistrazione;
import org.openspcoop2.protocol.sdk.tracciamento.DriverTracciamentoException;
import org.openspcoop2.protocol.sdk.tracciamento.DriverTracciamentoNotFoundException;
import org.openspcoop2.protocol.sdk.tracciamento.EsitoElaborazioneMessaggioTracciato;
import org.openspcoop2.protocol.sdk.tracciamento.FiltroRicercaTracce;
import org.openspcoop2.protocol.sdk.tracciamento.FiltroRicercaTracceConPaginazione;
import org.openspcoop2.protocol.sdk.tracciamento.InformazioniProtocollo;
import org.openspcoop2.protocol.sdk.tracciamento.Traccia;
import org.openspcoop2.utils.StringWrapper;
import org.openspcoop2.utils.date.DateUtils;
import org.openspcoop2.utils.jdbc.JDBCUtilities;
import org.openspcoop2.utils.sql.ISQLQueryObject;
import org.openspcoop2.utils.sql.SQLObjectFactory;
import org.openspcoop2.utils.sql.SQLQueryObjectException;
import org.slf4j.Logger;

public class TracciaDriverUtilities {
    private TracciaDriverUtilities() {
    }

    public static ISQLQueryObject getSQLQueryObject(String tipoDatabase) throws SQLQueryObjectException {
        ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDatabase);
        return sqlQueryObject;
    }

    public static ISQLQueryObject createSQLQueryObj_searchTracce(FiltroRicercaTracceConPaginazione filter, String tipoDatabase) throws SQLQueryObjectException {
        return TracciaDriverUtilities.createSQLQueryObj(filter, tipoDatabase, TracciaSearchType.TRACCE);
    }

    public static ISQLQueryObject createSQLQueryObj_countTracce(FiltroRicercaTracce filter, String tipoDatabase) throws SQLQueryObjectException {
        return TracciaDriverUtilities.createSQLQueryObj(filter, tipoDatabase, TracciaSearchType.COUNT_TRACCE);
    }

    public static ISQLQueryObject createSQLQueryObj_deleteTracce(FiltroRicercaTracce filter, String tipoDatabase) throws SQLQueryObjectException {
        ISQLQueryObject from = TracciaDriverUtilities.createSQLQueryObj(filter, tipoDatabase, TracciaSearchType.DELETE_TRACCE);
        ISQLQueryObject sqlQueryObjectDelete = SQLObjectFactory.createSQLQueryObject((String)tipoDatabase);
        sqlQueryObjectDelete.addDeleteTable("tracce");
        sqlQueryObjectDelete.addWhereINSelectSQLCondition(false, "id", from);
        return sqlQueryObjectDelete;
    }

    private static ISQLQueryObject createSQLQueryObj(FiltroRicercaTracce filtro, String tipoDatabase, TracciaSearchType tipoRicerca) throws SQLQueryObjectException {
        int i;
        ISQLQueryObject sqlQueryObject = TracciaDriverUtilities.getSQLQueryObject(tipoDatabase);
        sqlQueryObject.addFromTable("tracce");
        boolean distinct = true;
        switch (tipoRicerca) {
            case TRACCE: {
                sqlQueryObject.setSelectDistinct(distinct);
                sqlQueryObject.addSelectAliasField("tracce.id", "idTraccia");
                sqlQueryObject.addSelectField("tracce.gdo");
                break;
            }
            case COUNT_TRACCE: {
                sqlQueryObject.addSelectCountField("tracce.id", "countTracce", distinct);
                break;
            }
            case DELETE_TRACCE: {
                sqlQueryObject.setSelectDistinct(distinct);
                sqlQueryObject.addSelectAliasField("tracce.id", "idTraccia");
            }
        }
        sqlQueryObject.setANDLogicOperator(true);
        if (TracciaDriverUtilities.isDefined(filtro.getMinDate())) {
            sqlQueryObject.addWhereCondition("gdo>=?");
        }
        if (TracciaDriverUtilities.isDefined(filtro.getMaxDate())) {
            sqlQueryObject.addWhereCondition("gdo<=?");
        }
        if (TracciaDriverUtilities.isDefined(filtro.getIdTransazione())) {
            sqlQueryObject.addWhereCondition("id_transazione=?");
        }
        if (TracciaDriverUtilities.isDefined(filtro.getTipoTraccia())) {
            sqlQueryObject.addWhereCondition("tipo_messaggio=?");
        }
        if (TracciaDriverUtilities.isDefined(filtro.getTipoPdD())) {
            sqlQueryObject.addWhereCondition("pdd_ruolo=?");
        }
        if (TracciaDriverUtilities.isDefined(filtro.getDominio())) {
            if (TracciaDriverUtilities.isDefined(filtro.getDominio().getCodicePorta())) {
                sqlQueryObject.addWhereCondition("pdd_codice=?");
            }
            if (TracciaDriverUtilities.isDefined(filtro.getDominio().getTipo())) {
                sqlQueryObject.addWhereCondition("pdd_tipo_soggetto=?");
            }
            if (TracciaDriverUtilities.isDefined(filtro.getDominio().getNome())) {
                sqlQueryObject.addWhereCondition("pdd_nome_soggetto=?");
            }
        }
        if (TracciaDriverUtilities.isDefined(filtro.getIdBusta()) && (TracciaDriverUtilities.isDefined(filtro.getIdBustaRichiesta()) || TracciaDriverUtilities.isDefined(filtro.getIdBustaRisposta()))) {
            throw new SQLQueryObjectException("Non \u00e8 possibile definire sia il filtro idBusta che uno dei filtri su richiesta e/o risposta)");
        }
        if (TracciaDriverUtilities.isDefined(filtro.getIdBusta())) {
            sqlQueryObject.addWhereCondition("id_messaggio=?");
        } else if (TracciaDriverUtilities.isDefined(filtro.getIdBustaRichiesta()) && TracciaDriverUtilities.isDefined(filtro.getIdBustaRisposta())) {
            if (TracciaDriverUtilities.isDefined(filtro.getTipoTraccia())) {
                throw new SQLQueryObjectException("Non \u00e8 possibile definire il filtro sul tipo di traccia se si impostano entrambi gli identificativi di richiesta e risposta");
            }
            sqlQueryObject.addWhereCondition(false, new String[]{"tipo_messaggio=? AND id_messaggio=?", "tipo_messaggio=? AND id_messaggio=?"});
        } else if (TracciaDriverUtilities.isDefined(filtro.getIdBustaRichiesta())) {
            if (TracciaDriverUtilities.isDefined(filtro.getTipoTraccia())) {
                if (RuoloMessaggio.RISPOSTA.equals(filtro.getTipoTraccia())) {
                    throw new SQLQueryObjectException("Non \u00e8 possibile definire il filtro sul tipo di traccia a '" + RuoloMessaggio.RISPOSTA.getTipo() + "' ed il filtro sull'identificativo di richiesta");
                }
                sqlQueryObject.addWhereCondition("id_messaggio=?");
            } else {
                sqlQueryObject.addWhereCondition("tipo_messaggio=? AND id_messaggio=?");
            }
        } else if (TracciaDriverUtilities.isDefined(filtro.getIdBustaRisposta())) {
            if (TracciaDriverUtilities.isDefined(filtro.getTipoTraccia())) {
                if (RuoloMessaggio.RICHIESTA.equals(filtro.getTipoTraccia())) {
                    throw new SQLQueryObjectException("Non \u00e8 possibile definire il filtro sul tipo di traccia a '" + RuoloMessaggio.RICHIESTA.getTipo() + "' ed il filtro sull'identificativo di risposta");
                }
                sqlQueryObject.addWhereCondition("id_messaggio=?");
            } else {
                sqlQueryObject.addWhereCondition("tipo_messaggio=? AND id_messaggio=?");
            }
        }
        if (TracciaDriverUtilities.isDefined(filtro.getRiferimentoMessaggio())) {
            sqlQueryObject.addWhereCondition("rif_messaggio=?");
        }
        if (filtro.isRicercaSoloBusteErrore()) {
            ISQLQueryObject sqlQueryObjectBusteErrore = TracciaDriverUtilities.getSQLQueryObject(tipoDatabase);
            sqlQueryObjectBusteErrore.addFromTable("tracce_eccezioni");
            sqlQueryObjectBusteErrore.addSelectField("idtraccia");
            sqlQueryObjectBusteErrore.addWhereCondition("tracce.id=tracce_eccezioni.idtraccia");
            sqlQueryObject.addWhereExistsCondition(false, sqlQueryObjectBusteErrore);
        }
        if (TracciaDriverUtilities.isDefined(filtro.getInformazioniProtocollo())) {
            if (TracciaDriverUtilities.isDefined(filtro.getInformazioniProtocollo().getMittente())) {
                if (TracciaDriverUtilities.isDefined(filtro.getInformazioniProtocollo().getMittente().getTipo())) {
                    sqlQueryObject.addWhereCondition("tracce.tipo_mittente=?");
                }
                if (TracciaDriverUtilities.isDefined(filtro.getInformazioniProtocollo().getMittente().getNome())) {
                    sqlQueryObject.addWhereCondition("tracce.mittente=?");
                }
                if (TracciaDriverUtilities.isDefined(filtro.getInformazioniProtocollo().getMittente().getCodicePorta())) {
                    sqlQueryObject.addWhereCondition("tracce.idporta_mittente=?");
                }
            }
            if (TracciaDriverUtilities.isDefined(filtro.getInformazioniProtocollo().getDestinatario())) {
                if (TracciaDriverUtilities.isDefined(filtro.getInformazioniProtocollo().getDestinatario().getTipo())) {
                    sqlQueryObject.addWhereCondition("tracce.tipo_destinatario=?");
                }
                if (TracciaDriverUtilities.isDefined(filtro.getInformazioniProtocollo().getDestinatario().getNome())) {
                    sqlQueryObject.addWhereCondition("tracce.destinatario=?");
                }
                if (TracciaDriverUtilities.isDefined(filtro.getInformazioniProtocollo().getDestinatario().getCodicePorta())) {
                    sqlQueryObject.addWhereCondition("tracce.idporta_destinatario=?");
                }
            }
            if (TracciaDriverUtilities.isDefined(filtro.getInformazioniProtocollo().getTipoServizio())) {
                sqlQueryObject.addWhereCondition("tracce.tipo_servizio=?");
            }
            if (TracciaDriverUtilities.isDefined(filtro.getInformazioniProtocollo().getServizio())) {
                sqlQueryObject.addWhereCondition("tracce.servizio=?");
            }
            if (TracciaDriverUtilities.isDefined(filtro.getInformazioniProtocollo().getVersioneServizio())) {
                sqlQueryObject.addWhereCondition("tracce.versione_servizio=?");
            }
            if (TracciaDriverUtilities.isDefined(filtro.getInformazioniProtocollo().getAzione())) {
                sqlQueryObject.addWhereCondition("tracce.azione=?");
            }
            if (TracciaDriverUtilities.isDefined(filtro.getInformazioniProtocollo().getProfiloCollaborazioneProtocollo())) {
                sqlQueryObject.addWhereCondition("tracce.profilo_collaborazione=?");
            }
            if (TracciaDriverUtilities.isDefined(filtro.getInformazioniProtocollo().getProfiloCollaborazioneEngine())) {
                sqlQueryObject.addWhereCondition("tracce.profilo_collaborazione_meta=?");
            }
            if (filtro.getInformazioniProtocollo().sizeProprietaProtocollo() > 0) {
                String[] nomi = filtro.getInformazioniProtocollo().getProprietaProtocolloNames();
                for (i = 0; i < nomi.length; ++i) {
                    String aliasExtInfo = "tr_ext_" + i;
                    sqlQueryObject.addFromTable("tracce_ext_protocol_info", aliasExtInfo);
                    sqlQueryObject.addWhereCondition("tracce.id=" + aliasExtInfo + ".idtraccia");
                    sqlQueryObject.addWhereCondition(aliasExtInfo + ".name=?");
                    sqlQueryObject.addWhereLikeCondition(aliasExtInfo + ".value", filtro.getInformazioniProtocollo().getProprietaProtocollo(nomi[i]), false, false);
                }
            }
        }
        if (TracciaDriverUtilities.isDefined(filtro.getServizioApplicativoFruitore())) {
            sqlQueryObject.addWhereCondition("sa_fruitore=?");
        }
        if (TracciaDriverUtilities.isDefined(filtro.getServizioApplicativoErogatore())) {
            sqlQueryObject.addWhereCondition("sa_erogatore=?");
        }
        if (TracciaDriverUtilities.isDefined(filtro.getIdCorrelazioneApplicativa()) && TracciaDriverUtilities.isDefined(filtro.getIdCorrelazioneApplicativaRisposta())) {
            sqlQueryObject.addWhereCondition(!filtro.isIdCorrelazioneApplicativaOrMatch(), new String[]{"tracce.correlazione_applicativa=?", "tracce.correlazione_risposta=?"});
        } else if (TracciaDriverUtilities.isDefined(filtro.getIdCorrelazioneApplicativa())) {
            sqlQueryObject.addWhereCondition("tracce.correlazione_applicativa=?");
        } else if (TracciaDriverUtilities.isDefined(filtro.getIdCorrelazioneApplicativaRisposta())) {
            sqlQueryObject.addWhereCondition("tracce.correlazione_risposta=?");
        }
        if (TracciaDriverUtilities.isDefined(filtro.getProtocollo())) {
            sqlQueryObject.addWhereCondition("protocollo=?");
        }
        if (filtro.getPropertiesNames() != null && filtro.getPropertiesNames().length > 0) {
            String[] names = filtro.getPropertiesNames();
            for (i = 0; i < names.length; ++i) {
                sqlQueryObject.addWhereCondition(names[i] + "=?");
            }
        }
        switch (tipoRicerca) {
            case TRACCE: {
                FiltroRicercaTracceConPaginazione f = (FiltroRicercaTracceConPaginazione)filtro;
                if (f.getLimit() > 0) {
                    sqlQueryObject.setLimit(f.getLimit());
                }
                if (f.getOffset() > 0) {
                    sqlQueryObject.setOffset(f.getOffset());
                }
                sqlQueryObject.addOrderBy("gdo");
                sqlQueryObject.setSortType(f.isAsc());
                break;
            }
            case COUNT_TRACCE: {
                break;
            }
        }
        return sqlQueryObject;
    }

    public static int setValuesSearch(Object object, FiltroRicercaTracce filtro, int startIndex) throws SQLException {
        int i;
        SimpleDateFormat dateformat = DateUtils.getSimpleDateFormatMs();
        PreparedStatement pstmt = null;
        StringWrapper query = null;
        if (object instanceof PreparedStatement) {
            pstmt = (PreparedStatement)object;
        } else if (object instanceof StringWrapper) {
            query = (StringWrapper)object;
        } else {
            throw new SQLException("Tipo di parametro [" + object.getClass().getName() + "] non gestito");
        }
        if (TracciaDriverUtilities.isDefined(filtro.getMinDate())) {
            if (pstmt != null) {
                pstmt.setTimestamp(startIndex++, new Timestamp(filtro.getMinDate().getTime()));
            }
            if (query != null) {
                query.replaceFirst("\\?", "'" + dateformat.format(filtro.getMinDate()) + "'");
            }
        }
        if (TracciaDriverUtilities.isDefined(filtro.getMaxDate())) {
            if (pstmt != null) {
                pstmt.setTimestamp(startIndex++, new Timestamp(filtro.getMaxDate().getTime()));
            }
            if (query != null) {
                query.replaceFirst("\\?", "'" + dateformat.format(filtro.getMaxDate()) + "'");
            }
        }
        if (TracciaDriverUtilities.isDefined(filtro.getIdTransazione())) {
            if (pstmt != null) {
                pstmt.setString(startIndex++, filtro.getIdTransazione());
            }
            if (query != null) {
                query.replaceFirst("\\?", "'" + filtro.getIdTransazione() + "'");
            }
        }
        if (TracciaDriverUtilities.isDefined(filtro.getTipoTraccia())) {
            if (pstmt != null) {
                pstmt.setString(startIndex++, filtro.getTipoTraccia().getTipo());
            }
            if (query != null) {
                query.replaceFirst("\\?", "'" + filtro.getTipoTraccia().getTipo() + "'");
            }
        }
        if (TracciaDriverUtilities.isDefined(filtro.getTipoPdD())) {
            if (pstmt != null) {
                pstmt.setString(startIndex++, filtro.getTipoPdD().getTipo());
            }
            if (query != null) {
                query.replaceFirst("\\?", "'" + filtro.getTipoPdD().getTipo() + "'");
            }
        }
        if (TracciaDriverUtilities.isDefined(filtro.getDominio())) {
            if (TracciaDriverUtilities.isDefined(filtro.getDominio().getCodicePorta())) {
                if (pstmt != null) {
                    pstmt.setString(startIndex++, filtro.getDominio().getCodicePorta());
                }
                if (query != null) {
                    query.replaceFirst("\\?", "'" + filtro.getDominio().getCodicePorta() + "'");
                }
            }
            if (TracciaDriverUtilities.isDefined(filtro.getDominio().getTipo())) {
                if (pstmt != null) {
                    pstmt.setString(startIndex++, filtro.getDominio().getTipo());
                }
                if (query != null) {
                    query.replaceFirst("\\?", "'" + filtro.getDominio().getTipo() + "'");
                }
            }
            if (TracciaDriverUtilities.isDefined(filtro.getDominio().getNome())) {
                if (pstmt != null) {
                    pstmt.setString(startIndex++, filtro.getDominio().getNome());
                }
                if (query != null) {
                    query.replaceFirst("\\?", "'" + filtro.getDominio().getNome() + "'");
                }
            }
        }
        if (TracciaDriverUtilities.isDefined(filtro.getIdBusta())) {
            if (pstmt != null) {
                pstmt.setString(startIndex++, filtro.getIdBusta());
            }
            if (query != null) {
                query.replaceFirst("\\?", "'" + filtro.getIdBusta() + "'");
            }
        } else if (TracciaDriverUtilities.isDefined(filtro.getIdBustaRichiesta()) && TracciaDriverUtilities.isDefined(filtro.getIdBustaRisposta())) {
            if (pstmt != null) {
                pstmt.setString(startIndex++, RuoloMessaggio.RICHIESTA.getTipo());
            }
            if (query != null) {
                query.replaceFirst("\\?", "'" + RuoloMessaggio.RICHIESTA.getTipo() + "'");
            }
            if (pstmt != null) {
                pstmt.setString(startIndex++, filtro.getIdBustaRichiesta());
            }
            if (query != null) {
                query.replaceFirst("\\?", "'" + filtro.getIdBustaRichiesta() + "'");
            }
            if (pstmt != null) {
                pstmt.setString(startIndex++, RuoloMessaggio.RISPOSTA.getTipo());
            }
            if (query != null) {
                query.replaceFirst("\\?", "'" + RuoloMessaggio.RISPOSTA.getTipo() + "'");
            }
            if (pstmt != null) {
                pstmt.setString(startIndex++, filtro.getIdBustaRisposta());
            }
            if (query != null) {
                query.replaceFirst("\\?", "'" + filtro.getIdBustaRisposta() + "'");
            }
        } else if (TracciaDriverUtilities.isDefined(filtro.getIdBustaRichiesta())) {
            if (TracciaDriverUtilities.isDefined(filtro.getTipoTraccia())) {
                if (pstmt != null) {
                    pstmt.setString(startIndex++, filtro.getIdBustaRichiesta());
                }
                if (query != null) {
                    query.replaceFirst("\\?", "'" + filtro.getIdBustaRichiesta() + "'");
                }
            } else {
                if (pstmt != null) {
                    pstmt.setString(startIndex++, RuoloMessaggio.RICHIESTA.getTipo());
                }
                if (query != null) {
                    query.replaceFirst("\\?", "'" + RuoloMessaggio.RICHIESTA.getTipo() + "'");
                }
                if (pstmt != null) {
                    pstmt.setString(startIndex++, filtro.getIdBustaRichiesta());
                }
                if (query != null) {
                    query.replaceFirst("\\?", "'" + filtro.getIdBustaRichiesta() + "'");
                }
            }
        } else if (TracciaDriverUtilities.isDefined(filtro.getIdBustaRisposta())) {
            if (TracciaDriverUtilities.isDefined(filtro.getTipoTraccia())) {
                if (pstmt != null) {
                    pstmt.setString(startIndex++, filtro.getIdBustaRisposta());
                }
                if (query != null) {
                    query.replaceFirst("\\?", "'" + filtro.getIdBustaRisposta() + "'");
                }
            } else {
                if (pstmt != null) {
                    pstmt.setString(startIndex++, RuoloMessaggio.RISPOSTA.getTipo());
                }
                if (query != null) {
                    query.replaceFirst("\\?", "'" + RuoloMessaggio.RISPOSTA.getTipo() + "'");
                }
                if (pstmt != null) {
                    pstmt.setString(startIndex++, filtro.getIdBustaRisposta());
                }
                if (query != null) {
                    query.replaceFirst("\\?", "'" + filtro.getIdBustaRisposta() + "'");
                }
            }
        }
        if (TracciaDriverUtilities.isDefined(filtro.getRiferimentoMessaggio())) {
            if (pstmt != null) {
                pstmt.setString(startIndex++, filtro.getRiferimentoMessaggio());
            }
            if (query != null) {
                query.replaceFirst("\\?", "'" + filtro.getRiferimentoMessaggio() + "'");
            }
        }
        if (TracciaDriverUtilities.isDefined(filtro.getInformazioniProtocollo())) {
            if (TracciaDriverUtilities.isDefined(filtro.getInformazioniProtocollo().getMittente())) {
                if (TracciaDriverUtilities.isDefined(filtro.getInformazioniProtocollo().getMittente().getTipo())) {
                    if (pstmt != null) {
                        pstmt.setString(startIndex++, filtro.getInformazioniProtocollo().getMittente().getTipo());
                    }
                    if (query != null) {
                        query.replaceFirst("\\?", "'" + filtro.getInformazioniProtocollo().getMittente().getTipo() + "'");
                    }
                }
                if (TracciaDriverUtilities.isDefined(filtro.getInformazioniProtocollo().getMittente().getNome())) {
                    if (pstmt != null) {
                        pstmt.setString(startIndex++, filtro.getInformazioniProtocollo().getMittente().getNome());
                    }
                    if (query != null) {
                        query.replaceFirst("\\?", "'" + filtro.getInformazioniProtocollo().getMittente().getNome() + "'");
                    }
                }
                if (TracciaDriverUtilities.isDefined(filtro.getInformazioniProtocollo().getMittente().getCodicePorta())) {
                    if (pstmt != null) {
                        pstmt.setString(startIndex++, filtro.getInformazioniProtocollo().getMittente().getCodicePorta());
                    }
                    if (query != null) {
                        query.replaceFirst("\\?", "'" + filtro.getInformazioniProtocollo().getMittente().getCodicePorta() + "'");
                    }
                }
            }
            if (TracciaDriverUtilities.isDefined(filtro.getInformazioniProtocollo().getDestinatario())) {
                if (TracciaDriverUtilities.isDefined(filtro.getInformazioniProtocollo().getDestinatario().getTipo())) {
                    if (pstmt != null) {
                        pstmt.setString(startIndex++, filtro.getInformazioniProtocollo().getDestinatario().getTipo());
                    }
                    if (query != null) {
                        query.replaceFirst("\\?", "'" + filtro.getInformazioniProtocollo().getDestinatario().getTipo() + "'");
                    }
                }
                if (TracciaDriverUtilities.isDefined(filtro.getInformazioniProtocollo().getDestinatario().getNome())) {
                    if (pstmt != null) {
                        pstmt.setString(startIndex++, filtro.getInformazioniProtocollo().getDestinatario().getNome());
                    }
                    if (query != null) {
                        query.replaceFirst("\\?", "'" + filtro.getInformazioniProtocollo().getDestinatario().getNome() + "'");
                    }
                }
                if (TracciaDriverUtilities.isDefined(filtro.getInformazioniProtocollo().getDestinatario().getCodicePorta())) {
                    if (pstmt != null) {
                        pstmt.setString(startIndex++, filtro.getInformazioniProtocollo().getDestinatario().getCodicePorta());
                    }
                    if (query != null) {
                        query.replaceFirst("\\?", "'" + filtro.getInformazioniProtocollo().getDestinatario().getCodicePorta() + "'");
                    }
                }
            }
            if (TracciaDriverUtilities.isDefined(filtro.getInformazioniProtocollo().getTipoServizio())) {
                if (pstmt != null) {
                    pstmt.setString(startIndex++, filtro.getInformazioniProtocollo().getTipoServizio());
                }
                if (query != null) {
                    query.replaceFirst("\\?", "'" + filtro.getInformazioniProtocollo().getTipoServizio() + "'");
                }
            }
            if (TracciaDriverUtilities.isDefined(filtro.getInformazioniProtocollo().getServizio())) {
                if (pstmt != null) {
                    pstmt.setString(startIndex++, filtro.getInformazioniProtocollo().getServizio());
                }
                if (query != null) {
                    query.replaceFirst("\\?", "'" + filtro.getInformazioniProtocollo().getServizio() + "'");
                }
            }
            if (TracciaDriverUtilities.isDefined(filtro.getInformazioniProtocollo().getVersioneServizio())) {
                if (pstmt != null) {
                    pstmt.setInt(startIndex++, filtro.getInformazioniProtocollo().getVersioneServizio());
                }
                if (query != null) {
                    query.replaceFirst("\\?", "'" + filtro.getInformazioniProtocollo().getVersioneServizio() + "'");
                }
            }
            if (TracciaDriverUtilities.isDefined(filtro.getInformazioniProtocollo().getAzione())) {
                if (pstmt != null) {
                    pstmt.setString(startIndex++, filtro.getInformazioniProtocollo().getAzione());
                }
                if (query != null) {
                    query.replaceFirst("\\?", "'" + filtro.getInformazioniProtocollo().getAzione() + "'");
                }
            }
            if (TracciaDriverUtilities.isDefined(filtro.getInformazioniProtocollo().getProfiloCollaborazioneProtocollo())) {
                if (pstmt != null) {
                    pstmt.setString(startIndex++, filtro.getInformazioniProtocollo().getProfiloCollaborazioneProtocollo());
                }
                if (query != null) {
                    query.replaceFirst("\\?", "'" + filtro.getInformazioniProtocollo().getProfiloCollaborazioneProtocollo() + "'");
                }
            }
            if (TracciaDriverUtilities.isDefined(filtro.getInformazioniProtocollo().getProfiloCollaborazioneEngine())) {
                if (pstmt != null) {
                    pstmt.setString(startIndex++, filtro.getInformazioniProtocollo().getProfiloCollaborazioneEngine().getEngineValue());
                }
                if (query != null) {
                    query.replaceFirst("\\?", "'" + filtro.getInformazioniProtocollo().getProfiloCollaborazioneEngine().getEngineValue() + "'");
                }
            }
            if (filtro.getInformazioniProtocollo().sizeProprietaProtocollo() > 0) {
                String[] nomi = filtro.getInformazioniProtocollo().getProprietaProtocolloNames();
                for (i = 0; i < nomi.length; ++i) {
                    if (pstmt != null) {
                        pstmt.setString(startIndex++, nomi[i]);
                    }
                    if (query == null) continue;
                    query.replaceFirst("\\?", "'" + nomi[i] + "'");
                }
            }
        }
        if (TracciaDriverUtilities.isDefined(filtro.getServizioApplicativoFruitore())) {
            if (pstmt != null) {
                pstmt.setString(startIndex++, filtro.getServizioApplicativoFruitore());
            }
            if (query != null) {
                query.replaceFirst("\\?", "'" + filtro.getServizioApplicativoFruitore() + "'");
            }
        }
        if (TracciaDriverUtilities.isDefined(filtro.getServizioApplicativoErogatore())) {
            if (pstmt != null) {
                pstmt.setString(startIndex++, filtro.getServizioApplicativoErogatore());
            }
            if (query != null) {
                query.replaceFirst("\\?", "'" + filtro.getServizioApplicativoErogatore() + "'");
            }
        }
        if (TracciaDriverUtilities.isDefined(filtro.getIdCorrelazioneApplicativa()) && TracciaDriverUtilities.isDefined(filtro.getIdCorrelazioneApplicativaRisposta())) {
            if (pstmt != null) {
                pstmt.setString(startIndex++, filtro.getIdCorrelazioneApplicativa());
            }
            if (query != null) {
                query.replaceFirst("\\?", "'" + filtro.getIdCorrelazioneApplicativa() + "'");
            }
            if (pstmt != null) {
                pstmt.setString(startIndex++, filtro.getIdCorrelazioneApplicativaRisposta());
            }
            if (query != null) {
                query.replaceFirst("\\?", "'" + filtro.getIdCorrelazioneApplicativaRisposta() + "'");
            }
        } else if (TracciaDriverUtilities.isDefined(filtro.getIdCorrelazioneApplicativa())) {
            if (pstmt != null) {
                pstmt.setString(startIndex++, filtro.getIdCorrelazioneApplicativa());
            }
            if (query != null) {
                query.replaceFirst("\\?", "'" + filtro.getIdCorrelazioneApplicativa() + "'");
            }
        } else if (TracciaDriverUtilities.isDefined(filtro.getIdCorrelazioneApplicativaRisposta())) {
            if (pstmt != null) {
                pstmt.setString(startIndex++, filtro.getIdCorrelazioneApplicativaRisposta());
            }
            if (query != null) {
                query.replaceFirst("\\?", "'" + filtro.getIdCorrelazioneApplicativaRisposta() + "'");
            }
        }
        if (TracciaDriverUtilities.isDefined(filtro.getProtocollo())) {
            if (pstmt != null) {
                pstmt.setString(startIndex++, filtro.getProtocollo());
            }
            if (query != null) {
                query.replaceFirst("\\?", "'" + filtro.getProtocollo() + "'");
            }
        }
        if (filtro.getPropertiesNames() != null && filtro.getPropertiesNames().length > 0) {
            String[] names = filtro.getPropertiesNames();
            for (i = 0; i < names.length; ++i) {
                String value = filtro.getProperty(names[i]);
                if (pstmt != null) {
                    pstmt.setString(startIndex++, value);
                }
                if (query == null) continue;
                query.replaceFirst("\\?", "'" + value + "'");
            }
        }
        return startIndex;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Traccia getTraccia(Connection con, String tipoDatabase, Logger log, Long id, List<String> properties, ProtocolliRegistrati protocolli) throws DriverTracciamentoException, DriverTracciamentoNotFoundException, SQLQueryObjectException {
        Traccia traccia;
        if (log != null) {
            // empty if block
        }
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        PreparedStatement pstmtLista = null;
        ResultSet rsLista = null;
        Traccia tr = null;
        try {
            ISQLQueryObject sqlQueryObject = TracciaDriverUtilities.getSQLQueryObject(tipoDatabase);
            sqlQueryObject.addFromTable("tracce");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("id=?");
            pstmt = con.prepareStatement(sqlQueryObject.toString());
            pstmt.setLong(1, id);
            rs = pstmt.executeQuery();
            if (rs.next()) {
                tr = new Traccia();
                tr.setGdo(rs.getTimestamp("gdo"));
                tr.setIdTransazione(rs.getString("id_transazione"));
                IDSoggetto idSoggetto = new IDSoggetto();
                idSoggetto.setTipo(rs.getString("pdd_tipo_soggetto"));
                idSoggetto.setNome(rs.getString("pdd_nome_soggetto"));
                idSoggetto.setCodicePorta(rs.getString("pdd_codice"));
                tr.setTipoPdD(TipoPdD.toTipoPdD((String)rs.getString("pdd_ruolo")));
                tr.setIdSoggetto(idSoggetto);
                String t = rs.getString("tipo_messaggio");
                if (t != null) {
                    tr.setTipoMessaggio(RuoloMessaggio.toTipoTraccia(t));
                }
                EsitoElaborazioneMessaggioTracciato esitoTraccia = new EsitoElaborazioneMessaggioTracciato();
                esitoTraccia.setEsito(EsitoElaborazioneMessaggioTracciatura.valueOf(rs.getString("esito_elaborazione")));
                esitoTraccia.setDettaglio(rs.getString("dettaglio_esito_elaborazione"));
                tr.setEsitoElaborazioneMessaggioTracciato(esitoTraccia);
                tr.setCorrelazioneApplicativa(rs.getString("correlazione_applicativa"));
                tr.setCorrelazioneApplicativaRisposta(rs.getString("correlazione_risposta"));
                tr.setLocation(rs.getString("location"));
                tr.setProtocollo(rs.getString("protocollo"));
                if (properties != null) {
                    for (int i = 0; i < properties.size(); ++i) {
                        String key = properties.get(i);
                        tr.addProperty(key, rs.getString(key));
                    }
                }
                Busta busta = new Busta(tr.getProtocollo());
                if (rs.getString("tipo_mittente") != null && !"".equals(rs.getString("tipo_mittente"))) {
                    busta.setTipoMittente(rs.getString("tipo_mittente"));
                }
                if (rs.getString("mittente") != null && !"".equals(rs.getString("mittente"))) {
                    busta.setMittente(rs.getString("mittente"));
                }
                if (rs.getString("idporta_mittente") != null && !"".equals(rs.getString("idporta_mittente"))) {
                    busta.setIdentificativoPortaMittente(rs.getString("idporta_mittente"));
                }
                if (rs.getString("indirizzo_mittente") != null && !"".equals(rs.getString("indirizzo_mittente"))) {
                    busta.setIndirizzoMittente(rs.getString("indirizzo_mittente"));
                }
                if (rs.getString("tipo_destinatario") != null && !"".equals(rs.getString("tipo_destinatario"))) {
                    busta.setTipoDestinatario(rs.getString("tipo_destinatario"));
                }
                if (rs.getString("destinatario") != null && !"".equals(rs.getString("destinatario"))) {
                    busta.setDestinatario(rs.getString("destinatario"));
                }
                if (rs.getString("idporta_destinatario") != null && !"".equals(rs.getString("idporta_destinatario"))) {
                    busta.setIdentificativoPortaDestinatario(rs.getString("idporta_destinatario"));
                }
                if (rs.getString("indirizzo_destinatario") != null && !"".equals(rs.getString("indirizzo_destinatario"))) {
                    busta.setIndirizzoDestinatario(rs.getString("indirizzo_destinatario"));
                }
                if (rs.getString("sa_fruitore") != null && !"".equals(rs.getString("sa_fruitore"))) {
                    busta.setServizioApplicativoFruitore(rs.getString("sa_fruitore"));
                }
                if (rs.getString("sa_erogatore") != null && !"".equals(rs.getString("sa_erogatore"))) {
                    busta.setServizioApplicativoErogatore(rs.getString("sa_erogatore"));
                }
                if (rs.getString("profilo_collaborazione") != null && !"".equals(rs.getString("profilo_collaborazione"))) {
                    busta.setProfiloDiCollaborazioneValue(rs.getString("profilo_collaborazione"));
                }
                if (rs.getString("profilo_collaborazione_meta") != null && !"".equals(rs.getString("profilo_collaborazione_meta"))) {
                    busta.setProfiloDiCollaborazione(ProfiloDiCollaborazione.toProfiloDiCollaborazione(rs.getString("profilo_collaborazione_meta")));
                }
                Integer versioneServizioCorrelato = rs.getInt("versione_servizio_correlato");
                if (rs.wasNull()) {
                    versioneServizioCorrelato = null;
                }
                if (versioneServizioCorrelato != null) {
                    busta.setVersioneServizioCorrelato(versioneServizioCorrelato);
                }
                if (rs.getString("servizio_correlato") != null && !"".equals(rs.getString("servizio_correlato"))) {
                    busta.setServizioCorrelato(rs.getString("servizio_correlato"));
                }
                if (rs.getString("tipo_servizio_correlato") != null && !"".equals(rs.getString("tipo_servizio_correlato"))) {
                    busta.setTipoServizioCorrelato(rs.getString("tipo_servizio_correlato"));
                }
                if (rs.getString("collaborazione") != null && !"".equals(rs.getString("collaborazione"))) {
                    busta.setCollaborazione(rs.getString("collaborazione"));
                }
                Integer versioneServizio = rs.getInt("versione_servizio");
                if (rs.wasNull()) {
                    versioneServizio = null;
                }
                if (versioneServizio != null) {
                    busta.setVersioneServizio(versioneServizio);
                }
                if (rs.getString("servizio") != null && !"".equals(rs.getString("servizio"))) {
                    busta.setServizio(rs.getString("servizio"));
                }
                if (rs.getString("tipo_servizio") != null && !"".equals(rs.getString("tipo_servizio"))) {
                    busta.setTipoServizio(rs.getString("tipo_servizio"));
                }
                if (rs.getString("azione") != null && !"".equals(rs.getString("azione"))) {
                    busta.setAzione(rs.getString("azione"));
                }
                if (rs.getString("id_messaggio") != null && !"".equals(rs.getString("id_messaggio"))) {
                    busta.setID(rs.getString("id_messaggio"));
                }
                if (rs.getTimestamp("ora_registrazione") != null) {
                    busta.setOraRegistrazione(rs.getTimestamp("ora_registrazione"));
                }
                if (rs.getString("tipo_ora_reg") != null && !"".equals(rs.getString("tipo_ora_reg"))) {
                    busta.setTipoOraRegistrazioneValue(rs.getString("tipo_ora_reg"));
                }
                if (rs.getString("tipo_ora_reg_meta") != null && !"".equals(rs.getString("tipo_ora_reg_meta"))) {
                    busta.setTipoOraRegistrazione(TipoOraRegistrazione.toTipoOraRegistrazione(rs.getString("tipo_ora_reg_meta")), busta.getTipoOraRegistrazioneValue());
                }
                if (rs.getString("rif_messaggio") != null && !"".equals(rs.getString("rif_messaggio"))) {
                    busta.setRiferimentoMessaggio(rs.getString("rif_messaggio"));
                }
                if (rs.getTimestamp("scadenza") != null) {
                    busta.setScadenza(rs.getTimestamp("scadenza"));
                }
                if (rs.getString("inoltro") != null && !"".equals(rs.getString("inoltro"))) {
                    busta.setInoltroValue(rs.getString("inoltro"));
                }
                if (rs.getString("inoltro_meta") != null && !"".equals(rs.getString("inoltro_meta"))) {
                    busta.setInoltro(Inoltro.toInoltro(rs.getString("inoltro_meta")), busta.getInoltroValue());
                }
                busta.setConfermaRicezione(rs.getInt("conferma_ricezione") == 1);
                if (rs.getLong("sequenza") > 0L) {
                    busta.setSequenza(rs.getLong("sequenza"));
                }
                busta.setDigest(rs.getString("digest"));
                String headerProtocollo = rs.getString("soap_element");
                if (headerProtocollo != null) {
                    tr.setBustaAsString(headerProtocollo);
                }
                long idTraccia = rs.getLong("id");
                tr.setId(idTraccia);
                tr.addProperty("@@@@@-----@@@@-----IDTRACCIA-DB----@@@@@-----@@@@", "" + idTraccia);
                IProtocolFactory<?> protocolFactory = protocolli.getProtocolFactory(tr.getProtocollo());
                ITraduttore traduttoreProtocollo = protocolFactory.createTraduttore();
                sqlQueryObject = TracciaDriverUtilities.getSQLQueryObject(tipoDatabase);
                sqlQueryObject.addFromTable("tracce_trasmissioni");
                sqlQueryObject.addSelectField("*");
                sqlQueryObject.addWhereCondition("idtraccia=?");
                sqlQueryObject.setANDLogicOperator(true);
                pstmtLista = con.prepareStatement(sqlQueryObject.toString());
                pstmtLista.setLong(1, idTraccia);
                rsLista = pstmtLista.executeQuery();
                while (rsLista.next()) {
                    Trasmissione trtr = new Trasmissione();
                    if (rsLista.getString("origine") != null && !"".equals(rsLista.getString("origine"))) {
                        trtr.setOrigine(rsLista.getString("origine"));
                    }
                    if (rsLista.getString("tipo_origine") != null && !"".equals(rsLista.getString("tipo_origine"))) {
                        trtr.setTipoOrigine(rsLista.getString("tipo_origine"));
                    }
                    if (rsLista.getString("indirizzo_origine") != null && !"".equals(rsLista.getString("indirizzo_origine"))) {
                        trtr.setIndirizzoOrigine(rsLista.getString("indirizzo_origine"));
                    }
                    if (rsLista.getString("idporta_origine") != null && !"".equals(rsLista.getString("idporta_origine"))) {
                        trtr.setIdentificativoPortaOrigine(rsLista.getString("idporta_origine"));
                    }
                    if (rsLista.getString("destinazione") != null && !"".equals(rsLista.getString("destinazione"))) {
                        trtr.setDestinazione(rsLista.getString("destinazione"));
                    }
                    if (rsLista.getString("tipo_destinazione") != null && !"".equals(rsLista.getString("tipo_destinazione"))) {
                        trtr.setTipoDestinazione(rsLista.getString("tipo_destinazione"));
                    }
                    if (rsLista.getString("indirizzo_destinazione") != null && !"".equals(rsLista.getString("indirizzo_destinazione"))) {
                        trtr.setIndirizzoDestinazione(rsLista.getString("indirizzo_destinazione"));
                    }
                    if (rsLista.getString("idporta_destinazione") != null && !"".equals(rsLista.getString("idporta_destinazione"))) {
                        trtr.setIdentificativoPortaDestinazione(rsLista.getString("idporta_destinazione"));
                    }
                    if (rsLista.getTimestamp("ora_registrazione") != null) {
                        trtr.setOraRegistrazione(rsLista.getTimestamp("ora_registrazione"));
                    }
                    if (rsLista.getString("tipo_ora_reg") != null && !"".equals(rsLista.getString("tipo_ora_reg"))) {
                        trtr.setTempoValue(rsLista.getString("tipo_ora_reg"));
                    }
                    if (rsLista.getString("tipo_ora_reg_meta") != null && !"".equals(rsLista.getString("tipo_ora_reg_meta"))) {
                        trtr.setTempo(TipoOraRegistrazione.toTipoOraRegistrazione(rsLista.getString("tipo_ora_reg_meta")));
                    }
                    busta.addTrasmissione(trtr);
                }
                rsLista.close();
                pstmtLista.close();
                sqlQueryObject = TracciaDriverUtilities.getSQLQueryObject(tipoDatabase);
                sqlQueryObject.addFromTable("tracce_eccezioni");
                sqlQueryObject.addSelectField("*");
                sqlQueryObject.addWhereCondition("idtraccia=?");
                sqlQueryObject.setANDLogicOperator(true);
                pstmtLista = con.prepareStatement(sqlQueryObject.toString());
                pstmtLista.setLong(1, idTraccia);
                rsLista = pstmtLista.executeQuery();
                while (rsLista.next()) {
                    Eccezione trec = Eccezione.newEccezione();
                    String contestoCodifica = rsLista.getString("contesto_codifica");
                    String contestoCodificaMeta = rsLista.getString("contesto_codifica_meta");
                    String codiceEccezione = rsLista.getString("codice_eccezione");
                    int codiceEccezioneMeta = rsLista.getInt("codice_eccezione_meta");
                    int subCodiceEccezioneMeta = rsLista.getInt("subcodice_eccezione_meta");
                    String rilevanza = rsLista.getString("rilevanza");
                    String rilevanzaMeta = rsLista.getString("rilevanza_meta");
                    String posizione = rsLista.getString("posizione");
                    if (contestoCodifica != null && !"".equals(contestoCodifica)) {
                        trec.setContestoCodificaValue(contestoCodifica);
                    } else if (contestoCodificaMeta != null && !"".equals(contestoCodificaMeta)) {
                        trec.setContestoCodificaValue(traduttoreProtocollo.toString(ContestoCodificaEccezione.toContestoCodificaEccezione(contestoCodificaMeta)));
                    }
                    if (contestoCodificaMeta != null && !"".equals(contestoCodificaMeta)) {
                        trec.setContestoCodifica(ContestoCodificaEccezione.toContestoCodificaEccezione(contestoCodificaMeta));
                    } else if (contestoCodifica != null && !"".equals(contestoCodifica)) {
                        trec.setContestoCodifica(traduttoreProtocollo.toContestoCodificaEccezione(contestoCodifica));
                    }
                    CodiceErroreCooperazione cod = CodiceErroreCooperazione.toCodiceErroreCooperazione(codiceEccezioneMeta);
                    SubCodiceErrore subCodiceErrore = null;
                    if (subCodiceEccezioneMeta >= 0) {
                        subCodiceErrore = new SubCodiceErrore();
                        subCodiceErrore.setSubCodice(subCodiceEccezioneMeta);
                    }
                    if (codiceEccezione != null && !"".equals(codiceEccezione)) {
                        trec.setCodiceEccezioneValue(codiceEccezione);
                    } else {
                        trec.setCodiceEccezioneValue(traduttoreProtocollo.toString(cod, subCodiceErrore));
                    }
                    if (CodiceErroreCooperazione.UNKNOWN.equals(cod)) {
                        if (codiceEccezione != null && !"".equals(codiceEccezione)) {
                            trec.setCodiceEccezione(traduttoreProtocollo.toCodiceErroreCooperazione(codiceEccezione));
                        }
                    } else {
                        trec.setCodiceEccezione(cod);
                    }
                    if (subCodiceErrore != null) {
                        trec.setSubCodiceEccezione(subCodiceErrore);
                    }
                    if (rilevanza != null && !"".equals(rilevanza)) {
                        trec.setRilevanzaValue(rilevanza);
                    } else if (rilevanzaMeta != null && !"".equals(rilevanzaMeta)) {
                        trec.setRilevanzaValue(traduttoreProtocollo.toString(LivelloRilevanza.toLivelloRilevanza(rilevanzaMeta)));
                    }
                    if (rilevanzaMeta != null && !"".equals(rilevanzaMeta)) {
                        trec.setRilevanza(LivelloRilevanza.toLivelloRilevanza(rilevanzaMeta));
                    } else if (rilevanza != null && !"".equals(rilevanza)) {
                        trec.setRilevanza(traduttoreProtocollo.toLivelloRilevanza(rilevanza));
                    }
                    if (posizione != null && !"".equals(posizione)) {
                        trec.setDescrizione(posizione);
                    }
                    busta.addEccezione(trec);
                }
                rsLista.close();
                pstmtLista.close();
                sqlQueryObject = TracciaDriverUtilities.getSQLQueryObject(tipoDatabase);
                sqlQueryObject.addFromTable("tracce_riscontri");
                sqlQueryObject.addSelectField("*");
                sqlQueryObject.addWhereCondition("idtraccia=?");
                sqlQueryObject.setANDLogicOperator(true);
                pstmtLista = con.prepareStatement(sqlQueryObject.toString());
                pstmtLista.setLong(1, idTraccia);
                rsLista = pstmtLista.executeQuery();
                while (rsLista.next()) {
                    Riscontro trris = new Riscontro();
                    if (rsLista.getString("riscontro") != null && !"".equals(rsLista.getString("riscontro"))) {
                        trris.setID(rsLista.getString("riscontro"));
                    }
                    if (rsLista.getString("ricevuta") != null && !"".equals(rsLista.getString("ricevuta"))) {
                        trris.setRicevuta(rsLista.getString("ricevuta"));
                    }
                    if (rsLista.getTimestamp("ora_registrazione") != null) {
                        trris.setOraRegistrazione(rsLista.getTimestamp("ora_registrazione"));
                    }
                    if (rsLista.getString("tipo_ora_reg") != null && !"".equals(rsLista.getString("tipo_ora_reg"))) {
                        trris.setTipoOraRegistrazioneValue(rsLista.getString("tipo_ora_reg"));
                    }
                    if (rsLista.getString("tipo_ora_reg_meta") != null && !"".equals(rsLista.getString("tipo_ora_reg_meta"))) {
                        trris.setTipoOraRegistrazione(TipoOraRegistrazione.toTipoOraRegistrazione(rsLista.getString("tipo_ora_reg_meta")));
                    }
                    busta.addRiscontro(trris);
                }
                rsLista.close();
                pstmtLista.close();
                sqlQueryObject = TracciaDriverUtilities.getSQLQueryObject(tipoDatabase);
                sqlQueryObject.addFromTable("tracce_allegati");
                sqlQueryObject.addSelectField("*");
                sqlQueryObject.addWhereCondition("idtraccia=?");
                sqlQueryObject.setANDLogicOperator(true);
                pstmtLista = con.prepareStatement(sqlQueryObject.toString());
                pstmtLista.setLong(1, idTraccia);
                rsLista = pstmtLista.executeQuery();
                while (rsLista.next()) {
                    Allegato allegato = new Allegato();
                    allegato.setContentId(rsLista.getString("content_id"));
                    allegato.setContentLocation(rsLista.getString("content_location"));
                    allegato.setContentType(rsLista.getString("content_type"));
                    allegato.setDigest(rsLista.getString("digest"));
                    tr.addAllegato(allegato);
                }
                rsLista.close();
                pstmtLista.close();
                sqlQueryObject = TracciaDriverUtilities.getSQLQueryObject(tipoDatabase);
                sqlQueryObject.addFromTable("tracce_ext_protocol_info");
                sqlQueryObject.addSelectField("*");
                sqlQueryObject.addWhereCondition("idtraccia=?");
                sqlQueryObject.setANDLogicOperator(true);
                pstmtLista = con.prepareStatement(sqlQueryObject.toString());
                pstmtLista.setLong(1, idTraccia);
                rsLista = pstmtLista.executeQuery();
                while (rsLista.next()) {
                    busta.addProperty(rsLista.getString("name"), rsLista.getString("value"));
                }
                rsLista.close();
                pstmtLista.close();
                tr.setBusta(busta);
            }
            rs.close();
            pstmt.close();
            if (tr == null) {
                throw new DriverTracciamentoNotFoundException("Traccia non trovata (id:" + id + ")");
            }
            traccia = tr;
        }
        catch (DriverTracciamentoNotFoundException d) {
            try {
                throw d;
                catch (Exception e) {
                    throw new DriverTracciamentoException("Tracciamento exception: " + e.getMessage(), e);
                }
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(rsLista, pstmtLista);
                JDBCUtilities.closeResources(rs, pstmt);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources(rsLista, pstmtLista);
        JDBCUtilities.closeResources((ResultSet)rs, (PreparedStatement)pstmt);
        return traccia;
    }

    protected static boolean isDefined(String v) {
        return v != null && !"".equals(v);
    }

    protected static boolean isDefined(Date v) {
        return v != null;
    }

    protected static boolean isDefined(RuoloMessaggio v) {
        return v != null;
    }

    protected static boolean isDefined(TipoPdD v) {
        return v != null;
    }

    protected static boolean isDefined(IDSoggetto v) {
        return v != null;
    }

    protected static boolean isDefined(InformazioniProtocollo v) {
        return v != null;
    }

    protected static boolean isDefined(Integer v) {
        return v != null;
    }

    protected static boolean isDefined(ProfiloDiCollaborazione v) {
        return v != null;
    }
}

