/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.protocol.basic.registry;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.openspcoop2.core.config.constants.CostantiConfigurazione;
import org.openspcoop2.core.id.IDAccordo;
import org.openspcoop2.core.id.IDAccordoAzione;
import org.openspcoop2.core.id.IDAccordoCooperazione;
import org.openspcoop2.core.id.IDFruizione;
import org.openspcoop2.core.id.IDGruppo;
import org.openspcoop2.core.id.IDPortType;
import org.openspcoop2.core.id.IDPortTypeAzione;
import org.openspcoop2.core.id.IDResource;
import org.openspcoop2.core.id.IDRuolo;
import org.openspcoop2.core.id.IDScope;
import org.openspcoop2.core.id.IDServizio;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.core.registry.AccordoCooperazione;
import org.openspcoop2.core.registry.AccordoServizioParteComune;
import org.openspcoop2.core.registry.AccordoServizioParteSpecifica;
import org.openspcoop2.core.registry.Azione;
import org.openspcoop2.core.registry.Operation;
import org.openspcoop2.core.registry.PortType;
import org.openspcoop2.core.registry.PortaDominio;
import org.openspcoop2.core.registry.Resource;
import org.openspcoop2.core.registry.Soggetto;
import org.openspcoop2.core.registry.constants.PddTipologia;
import org.openspcoop2.core.registry.driver.DriverRegistroServiziNotFound;
import org.openspcoop2.core.registry.driver.FiltroRicerca;
import org.openspcoop2.core.registry.driver.FiltroRicercaAccordi;
import org.openspcoop2.core.registry.driver.FiltroRicercaAzioni;
import org.openspcoop2.core.registry.driver.FiltroRicercaFruizioniServizio;
import org.openspcoop2.core.registry.driver.FiltroRicercaGruppi;
import org.openspcoop2.core.registry.driver.FiltroRicercaOperations;
import org.openspcoop2.core.registry.driver.FiltroRicercaPortTypes;
import org.openspcoop2.core.registry.driver.FiltroRicercaProtocolPropertyRegistry;
import org.openspcoop2.core.registry.driver.FiltroRicercaResources;
import org.openspcoop2.core.registry.driver.FiltroRicercaRuoli;
import org.openspcoop2.core.registry.driver.FiltroRicercaScope;
import org.openspcoop2.core.registry.driver.FiltroRicercaServizi;
import org.openspcoop2.core.registry.driver.FiltroRicercaSoggetti;
import org.openspcoop2.core.registry.driver.IDAccordoFactory;
import org.openspcoop2.core.registry.driver.IDriverRegistroServiziCRUD;
import org.openspcoop2.core.registry.driver.IDriverRegistroServiziGet;
import org.openspcoop2.core.registry.driver.db.DriverRegistroServiziDB;
import org.openspcoop2.core.registry.rest.AccordoServizioWrapper;
import org.openspcoop2.protocol.registry.RegistroServizi;
import org.openspcoop2.protocol.sdk.constants.InformationApiSource;
import org.openspcoop2.protocol.sdk.registry.IRegistryReader;
import org.openspcoop2.protocol.sdk.registry.IRegistryReaderInUso;
import org.openspcoop2.protocol.sdk.registry.ProtocolFiltroRicercaAccordi;
import org.openspcoop2.protocol.sdk.registry.ProtocolFiltroRicercaAccordoAzioni;
import org.openspcoop2.protocol.sdk.registry.ProtocolFiltroRicercaFruizioniServizio;
import org.openspcoop2.protocol.sdk.registry.ProtocolFiltroRicercaGruppi;
import org.openspcoop2.protocol.sdk.registry.ProtocolFiltroRicercaPortType;
import org.openspcoop2.protocol.sdk.registry.ProtocolFiltroRicercaPortTypeAzioni;
import org.openspcoop2.protocol.sdk.registry.ProtocolFiltroRicercaRisorse;
import org.openspcoop2.protocol.sdk.registry.ProtocolFiltroRicercaRuoli;
import org.openspcoop2.protocol.sdk.registry.ProtocolFiltroRicercaScope;
import org.openspcoop2.protocol.sdk.registry.ProtocolFiltroRicercaServizi;
import org.openspcoop2.protocol.sdk.registry.ProtocolFiltroRicercaSoggetti;
import org.openspcoop2.protocol.sdk.registry.RegistryException;
import org.openspcoop2.protocol.sdk.registry.RegistryNotFound;
import org.openspcoop2.protocol.utils.ProtocolUtils;
import org.openspcoop2.utils.UtilsRuntimeException;
import org.openspcoop2.utils.certificate.CertificateInfo;
import org.openspcoop2.utils.crypt.CryptConfig;
import org.openspcoop2.utils.resources.Loader;
import org.slf4j.Logger;

public class RegistryReader
implements IRegistryReader {
    private IDriverRegistroServiziGet driverRegistroServiziGET;
    private IDriverRegistroServiziCRUD driverRegistroServiziCRUD;
    private RegistroServizi registroServiziWithoutCache;
    private IRegistryReaderInUso inUsoDriver = null;
    private Logger log;

    public RegistryReader(IDriverRegistroServiziGet driverRegistroServizi, Logger log) throws ClassNotFoundException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        this.driverRegistroServiziGET = driverRegistroServizi;
        if (this.driverRegistroServiziGET instanceof IDriverRegistroServiziCRUD) {
            this.driverRegistroServiziCRUD = (IDriverRegistroServiziCRUD)this.driverRegistroServiziGET;
        }
        this.log = log;
        Loader loader = new Loader();
        this.inUsoDriver = (IRegistryReaderInUso)loader.newInstance("org.openspcoop2.protocol.engine.registry.RegistryReaderInUso");
        this.inUsoDriver.init(this.driverRegistroServiziGET, log);
    }

    private synchronized void initRegistroServiziWithoutCache() throws RegistryException {
        try {
            if (this.registroServiziWithoutCache == null) {
                this.registroServiziWithoutCache = new RegistroServizi(this.driverRegistroServiziGET, this.log, true, CostantiConfigurazione.REGISTRO_DB.getValue());
            }
        }
        catch (Exception e) {
            throw new RegistryException(e.getMessage(), e);
        }
    }

    public RegistroServizi getRegistroServiziWithoutCache() throws RegistryException {
        if (this.registroServiziWithoutCache == null) {
            this.initRegistroServiziWithoutCache();
        }
        return this.registroServiziWithoutCache;
    }

    @Override
    public boolean existsPortaDominio(String nome) {
        try {
            if (this.driverRegistroServiziCRUD != null) {
                return this.driverRegistroServiziCRUD.existsPortaDominio(nome);
            }
            return this.driverRegistroServiziGET.getPortaDominio(nome) != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public PortaDominio getPortaDominio(String nome) throws RegistryNotFound, RegistryException {
        try {
            return this.driverRegistroServiziGET.getPortaDominio(nome);
        }
        catch (DriverRegistroServiziNotFound de) {
            throw new RegistryNotFound(de.getMessage(), de);
        }
        catch (Exception e) {
            throw new RegistryException(e.getMessage(), e);
        }
    }

    @Override
    public List<String> findIdPorteDominio(Boolean operativo) throws RegistryNotFound, RegistryException {
        try {
            FiltroRicerca filtroRicerca = new FiltroRicerca();
            if (operativo != null) {
                if (operativo.booleanValue()) {
                    filtroRicerca.setTipo(PddTipologia.OPERATIVO.toString());
                } else {
                    filtroRicerca.setTipo(PddTipologia.ESTERNO.toString());
                }
            }
            return this.driverRegistroServiziGET.getAllIdPorteDominio(filtroRicerca);
        }
        catch (DriverRegistroServiziNotFound de) {
            throw new RegistryNotFound(de.getMessage(), de);
        }
        catch (Exception e) {
            throw new RegistryException(e.getMessage(), e);
        }
    }

    @Override
    public boolean existsSoggettoByCodiceIPA(String codiceIPA) {
        try {
            if (this.driverRegistroServiziGET instanceof DriverRegistroServiziDB) {
                return ((DriverRegistroServiziDB)this.driverRegistroServiziGET).existsSoggetto(codiceIPA);
            }
            throw new UtilsRuntimeException("Not Implemented");
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public boolean existsSoggetto(IDSoggetto idSoggetto) {
        try {
            if (this.driverRegistroServiziCRUD != null) {
                return this.driverRegistroServiziCRUD.existsSoggetto(idSoggetto);
            }
            return this.driverRegistroServiziGET.getSoggetto(idSoggetto) != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public IDSoggetto getIdSoggettoByCodiceIPA(String codiceIPA) throws RegistryNotFound, RegistryException {
        try {
            if (this.driverRegistroServiziGET instanceof DriverRegistroServiziDB) {
                Soggetto s = ((DriverRegistroServiziDB)this.driverRegistroServiziGET).getSoggetto(codiceIPA);
                return new IDSoggetto(s.getTipo(), s.getNome(), s.getIdentificativoPorta());
            }
            throw new UtilsRuntimeException("Not Implemented");
        }
        catch (DriverRegistroServiziNotFound de) {
            throw new RegistryNotFound(de.getMessage(), de);
        }
        catch (Exception e) {
            throw new RegistryException(e.getMessage(), e);
        }
    }

    @Override
    public IDSoggetto getIdSoggettoDefault(String tipoSoggettoDefault) throws RegistryNotFound, RegistryException {
        try {
            if (this.driverRegistroServiziGET instanceof DriverRegistroServiziDB) {
                List list = ((DriverRegistroServiziDB)this.driverRegistroServiziGET).getSoggettiDefault();
                if (list != null && !list.isEmpty()) {
                    for (IDSoggetto idSoggetto : list) {
                        if (!idSoggetto.getTipo().equals(tipoSoggettoDefault)) continue;
                        return idSoggetto;
                    }
                }
                throw new DriverRegistroServiziNotFound("Soggetto di default per il tipo '" + tipoSoggettoDefault + "' non trovato");
            }
            throw new UtilsRuntimeException("Not Implemented");
        }
        catch (DriverRegistroServiziNotFound de) {
            throw new RegistryNotFound(de.getMessage(), de);
        }
        catch (Exception e) {
            throw new RegistryException(e.getMessage(), e);
        }
    }

    @Override
    public String getCodiceIPA(IDSoggetto idSoggetto) throws RegistryNotFound, RegistryException {
        try {
            if (this.driverRegistroServiziGET instanceof DriverRegistroServiziDB) {
                return ((DriverRegistroServiziDB)this.driverRegistroServiziGET).getCodiceIPA(idSoggetto);
            }
            throw new UtilsRuntimeException("Not Implemented");
        }
        catch (DriverRegistroServiziNotFound de) {
            throw new RegistryNotFound(de.getMessage(), de);
        }
        catch (Exception e) {
            throw new RegistryException(e.getMessage(), e);
        }
    }

    @Override
    public String getDominio(IDSoggetto idSoggetto) throws RegistryNotFound, RegistryException {
        try {
            return this.getSoggetto(idSoggetto).getIdentificativoPorta();
        }
        catch (RegistryNotFound de) {
            throw de;
        }
        catch (Exception e) {
            throw new RegistryException(e.getMessage(), e);
        }
    }

    @Override
    public Soggetto getSoggetto(IDSoggetto idSoggetto) throws RegistryNotFound, RegistryException {
        try {
            return this.driverRegistroServiziGET.getSoggetto(idSoggetto);
        }
        catch (DriverRegistroServiziNotFound de) {
            throw new RegistryNotFound(de.getMessage(), de);
        }
        catch (Exception e) {
            throw new RegistryException(e.getMessage(), e);
        }
    }

    @Override
    public boolean existsSoggettoByCredenzialiBasic(String username, String password, CryptConfig cryptConfig) {
        try {
            return this.driverRegistroServiziGET.getSoggettoByCredenzialiBasic(username, password, cryptConfig) != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public Soggetto getSoggettoByCredenzialiBasic(String username, String password, CryptConfig cryptConfig) throws RegistryNotFound, RegistryException {
        try {
            return this.driverRegistroServiziGET.getSoggettoByCredenzialiBasic(username, password, cryptConfig);
        }
        catch (DriverRegistroServiziNotFound de) {
            throw new RegistryNotFound(de.getMessage(), de);
        }
        catch (Exception e) {
            throw new RegistryException(e.getMessage(), e);
        }
    }

    @Override
    public boolean existsSoggettoByCredenzialiSsl(String subject, String issuer) {
        try {
            return this.driverRegistroServiziGET.getSoggettoByCredenzialiSsl(subject, issuer) != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public Soggetto getSoggettoByCredenzialiSsl(String subject, String issuer) throws RegistryNotFound, RegistryException {
        try {
            return this.driverRegistroServiziGET.getSoggettoByCredenzialiSsl(subject, issuer);
        }
        catch (DriverRegistroServiziNotFound de) {
            throw new RegistryNotFound(de.getMessage(), de);
        }
        catch (Exception e) {
            throw new RegistryException(e.getMessage(), e);
        }
    }

    @Override
    public boolean existsSoggettoByCredenzialiSsl(CertificateInfo certificate, boolean strictVerifier) {
        try {
            return this.driverRegistroServiziGET.getSoggettoByCredenzialiSsl(certificate, strictVerifier) != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public Soggetto getSoggettoByCredenzialiSsl(CertificateInfo certificate, boolean strictVerifier) throws RegistryNotFound, RegistryException {
        try {
            return this.driverRegistroServiziGET.getSoggettoByCredenzialiSsl(certificate, strictVerifier);
        }
        catch (DriverRegistroServiziNotFound de) {
            throw new RegistryNotFound(de.getMessage(), de);
        }
        catch (Exception e) {
            throw new RegistryException(e.getMessage(), e);
        }
    }

    @Override
    public boolean existsSoggettoByCredenzialiPrincipal(String principal) {
        try {
            return this.driverRegistroServiziGET.getSoggettoByCredenzialiPrincipal(principal) != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public Soggetto getSoggettoByCredenzialiPrincipal(String principal) throws RegistryNotFound, RegistryException {
        try {
            return this.driverRegistroServiziGET.getSoggettoByCredenzialiPrincipal(principal);
        }
        catch (DriverRegistroServiziNotFound de) {
            throw new RegistryNotFound(de.getMessage(), de);
        }
        catch (Exception e) {
            throw new RegistryException(e.getMessage(), e);
        }
    }

    @Override
    public List<IDSoggetto> findIdSoggetti(ProtocolFiltroRicercaSoggetti filtro) throws RegistryNotFound, RegistryException {
        try {
            List<FiltroRicercaProtocolPropertyRegistry> listPP;
            FiltroRicercaSoggetti filtroDriver = new FiltroRicercaSoggetti();
            if (filtro.getTipo() != null) {
                filtroDriver.setTipo(filtro.getTipo());
            }
            if (filtro.getNome() != null) {
                filtroDriver.setNome(filtro.getNome());
            }
            if (filtro.getNomePdd() != null) {
                filtroDriver.setNomePdd(filtro.getNomePdd());
            }
            if ((listPP = ProtocolUtils.convert(filtro.getProtocolProperties())) != null && !listPP.isEmpty()) {
                filtroDriver.setProtocolProperties(listPP);
            }
            if (filtro.getProprieta() != null && !filtro.getProprieta().isEmpty()) {
                filtroDriver.setProprieta(filtro.getProprieta());
            }
            return this.driverRegistroServiziGET.getAllIdSoggetti(filtroDriver);
        }
        catch (DriverRegistroServiziNotFound de) {
            throw new RegistryNotFound(de.getMessage(), de);
        }
        catch (Exception e) {
            throw new RegistryException(e.getMessage(), e);
        }
    }

    @Override
    public boolean inUso(IDSoggetto idSoggetto, boolean verificaRuoli) throws RegistryException {
        return this.inUsoDriver.inUso(idSoggetto, verificaRuoli);
    }

    @Override
    public String getDettagliInUso(IDSoggetto idSoggetto, boolean verificaRuoli) throws RegistryException {
        return this.inUsoDriver.getDettagliInUso(idSoggetto, verificaRuoli);
    }

    @Override
    public AccordoServizioParteComune getAccordoServizioParteComune(IDAccordo idAccordo) throws RegistryNotFound, RegistryException {
        try {
            return this.driverRegistroServiziGET.getAccordoServizioParteComune(idAccordo);
        }
        catch (DriverRegistroServiziNotFound de) {
            throw new RegistryNotFound(de.getMessage(), de);
        }
        catch (Exception e) {
            throw new RegistryException(e.getMessage(), e);
        }
    }

    @Override
    public AccordoServizioParteComune getAccordoServizioParteComune(IDAccordo idAccordo, boolean readAllegati, boolean readDatiRegistro) throws RegistryNotFound, RegistryException {
        try {
            if (this.driverRegistroServiziGET instanceof DriverRegistroServiziDB) {
                return ((DriverRegistroServiziDB)this.driverRegistroServiziGET).getAccordoServizioParteComune(idAccordo, readAllegati, readDatiRegistro);
            }
            return this.getAccordoServizioParteComune(idAccordo);
        }
        catch (DriverRegistroServiziNotFound de) {
            throw new RegistryNotFound(de.getMessage(), de);
        }
        catch (Exception e) {
            throw new RegistryException(e.getMessage(), e);
        }
    }

    @Override
    public List<IDAccordo> findIdAccordiServizioParteComune(ProtocolFiltroRicercaAccordi filtro) throws RegistryNotFound, RegistryException {
        try {
            List<FiltroRicercaProtocolPropertyRegistry> listPP;
            FiltroRicercaAccordi filtroDriver = new FiltroRicercaAccordi();
            if (filtro.getNome() != null) {
                filtroDriver.setNomeAccordo(filtro.getNome());
            }
            if (filtro.getVersione() != null) {
                filtroDriver.setVersione(filtro.getVersione());
            }
            if (filtro.getSoggetto() != null) {
                if (filtro.getSoggetto().getTipo() != null) {
                    filtroDriver.setTipoSoggettoReferente(filtro.getSoggetto().getTipo());
                }
                if (filtro.getSoggetto().getNome() != null) {
                    filtroDriver.setNomeSoggettoReferente(filtro.getSoggetto().getNome());
                }
            }
            if (filtro.getServiceBinding() != null) {
                filtroDriver.setServiceBinding(filtro.getServiceBinding());
            }
            if (filtro.getIdGruppo() != null) {
                filtroDriver.setIdGruppo(filtro.getIdGruppo());
            }
            if ((listPP = ProtocolUtils.convert(filtro.getProtocolProperties())) != null && !listPP.isEmpty()) {
                filtroDriver.setProtocolPropertiesAccordo(listPP);
            }
            if (filtro.getEscludiServiziComposti() != null) {
                filtroDriver.setServizioComposto(Boolean.valueOf(filtro.getEscludiServiziComposti() == false));
            }
            if (filtro.getEscludiServiziNonComposti() != null) {
                filtroDriver.setServizioComposto(filtro.getEscludiServiziNonComposti());
            }
            return this.driverRegistroServiziGET.getAllIdAccordiServizioParteComune(filtroDriver);
        }
        catch (DriverRegistroServiziNotFound de) {
            throw new RegistryNotFound(de.getMessage(), de);
        }
        catch (Exception e) {
            throw new RegistryException(e.getMessage(), e);
        }
    }

    @Override
    public org.openspcoop2.core.registry.wsdl.AccordoServizioWrapper getAccordoServizioParteComuneSoap(IDServizio idService, InformationApiSource infoWsdlSource, boolean buildSchema, boolean readDatiRegistro) throws RegistryNotFound, RegistryException {
        try {
            RegistroServizi registro = this.getRegistroServiziWithoutCache();
            return registro.getWsdlAccordoServizio(null, null, idService, infoWsdlSource, buildSchema, readDatiRegistro);
        }
        catch (DriverRegistroServiziNotFound de) {
            throw new RegistryNotFound(de.getMessage(), de);
        }
        catch (Exception e) {
            throw new RegistryException(e.getMessage(), e);
        }
    }

    @Override
    public AccordoServizioWrapper getAccordoServizioParteComuneRest(IDServizio idService, InformationApiSource infoWsdlSource, boolean buildSchema, boolean processIncludeForOpenApi, boolean readDatiRegistro) throws RegistryNotFound, RegistryException {
        try {
            RegistroServizi registro = this.getRegistroServiziWithoutCache();
            return registro.getRestAccordoServizio(null, null, idService, infoWsdlSource, buildSchema, processIncludeForOpenApi, readDatiRegistro);
        }
        catch (DriverRegistroServiziNotFound de) {
            throw new RegistryNotFound(de.getMessage(), de);
        }
        catch (Exception e) {
            throw new RegistryException(e.getMessage(), e);
        }
    }

    @Override
    public boolean inUso(IDAccordo idAccordo) throws RegistryException {
        return this.inUsoDriver.inUso(idAccordo);
    }

    @Override
    public String getDettagliInUso(IDAccordo idAccordo) throws RegistryException {
        return this.inUsoDriver.getDettagliInUso(idAccordo);
    }

    @Override
    public PortType getPortType(IDPortType id) throws RegistryNotFound, RegistryException {
        try {
            AccordoServizioParteComune as = this.driverRegistroServiziGET.getAccordoServizioParteComune(id.getIdAccordo());
            for (PortType pt : as.getPortTypeList()) {
                if (!pt.getNome().equals(id.getNome())) continue;
                return pt;
            }
            throw new DriverRegistroServiziNotFound("PortType [" + id.getNome() + "] non trovato nell'accordo [" + IDAccordoFactory.getInstance().getUriFromIDAccordo(id.getIdAccordo()) + "]");
        }
        catch (DriverRegistroServiziNotFound de) {
            throw new RegistryNotFound(de.getMessage(), de);
        }
        catch (Exception e) {
            throw new RegistryException(e.getMessage(), e);
        }
    }

    @Override
    public List<IDPortType> findIdPortType(ProtocolFiltroRicercaPortType filtro) throws RegistryNotFound, RegistryException {
        try {
            List<FiltroRicercaProtocolPropertyRegistry> listPP;
            List<FiltroRicercaProtocolPropertyRegistry> listPPportTypes;
            FiltroRicercaPortTypes filtroDriver = new FiltroRicercaPortTypes();
            if (filtro.getNomePortType() != null) {
                filtroDriver.setNomePortType(filtro.getNomePortType());
            }
            if ((listPPportTypes = ProtocolUtils.convert(filtro.getProtocolPropertiesPortType())) != null && !listPPportTypes.isEmpty()) {
                filtroDriver.setProtocolPropertiesPortType(listPPportTypes);
            }
            if (filtro.getNome() != null) {
                filtroDriver.setNomeAccordo(filtro.getNome());
            }
            if (filtro.getVersione() != null) {
                filtroDriver.setVersione(filtro.getVersione());
            }
            if (filtro.getSoggetto() != null) {
                if (filtro.getSoggetto().getTipo() != null) {
                    filtroDriver.setTipoSoggettoReferente(filtro.getSoggetto().getTipo());
                }
                if (filtro.getSoggetto().getNome() != null) {
                    filtroDriver.setNomeSoggettoReferente(filtro.getSoggetto().getNome());
                }
            }
            if (filtro.getServiceBinding() != null) {
                filtroDriver.setServiceBinding(filtro.getServiceBinding());
            }
            if (filtro.getIdGruppo() != null) {
                filtroDriver.setIdGruppo(filtro.getIdGruppo());
            }
            if ((listPP = ProtocolUtils.convert(filtro.getProtocolProperties())) != null && !listPP.isEmpty()) {
                filtroDriver.setProtocolPropertiesAccordo(listPP);
            }
            if (filtro.getEscludiServiziComposti() != null) {
                filtroDriver.setServizioComposto(Boolean.valueOf(filtro.getEscludiServiziComposti() == false));
            }
            if (filtro.getEscludiServiziNonComposti() != null) {
                filtroDriver.setServizioComposto(filtro.getEscludiServiziNonComposti());
            }
            return this.driverRegistroServiziGET.getAllIdPortType(filtroDriver);
        }
        catch (DriverRegistroServiziNotFound de) {
            throw new RegistryNotFound(de.getMessage(), de);
        }
        catch (Exception e) {
            throw new RegistryException(e.getMessage(), e);
        }
    }

    @Override
    public boolean inUso(IDPortType id) throws RegistryException {
        return this.inUsoDriver.inUso(id);
    }

    @Override
    public String getDettagliInUso(IDPortType id) throws RegistryException {
        return this.inUsoDriver.getDettagliInUso(id);
    }

    @Override
    public Operation getAzionePortType(IDPortTypeAzione id) throws RegistryNotFound, RegistryException {
        PortType portType = this.getPortType(id.getIdPortType());
        for (Operation opCheck : portType.getAzioneList()) {
            if (!opCheck.getNome().equals(id.getNome())) continue;
            return opCheck;
        }
        String uriAccordo = null;
        try {
            uriAccordo = IDAccordoFactory.getInstance().getUriFromIDAccordo(id.getIdPortType().getIdAccordo());
        }
        catch (Exception e) {
            uriAccordo = id.getIdPortType().getIdAccordo().toString();
        }
        throw new RegistryNotFound("Azione [" + id.getNome() + "] non trovata all'interno del PortType [" + id.getIdPortType().getNome() + "] dell'accordo [" + uriAccordo + "]");
    }

    @Override
    public List<IDPortTypeAzione> findIdAzionePortType(ProtocolFiltroRicercaPortTypeAzioni filtro) throws RegistryNotFound, RegistryException {
        try {
            List<FiltroRicercaProtocolPropertyRegistry> listPP;
            List<FiltroRicercaProtocolPropertyRegistry> listPPportTypes;
            List<FiltroRicercaProtocolPropertyRegistry> listPPazioni;
            FiltroRicercaOperations filtroDriver = new FiltroRicercaOperations();
            if (filtro.getNomeAzione() != null) {
                filtroDriver.setNomeAzione(filtro.getNomeAzione());
            }
            if ((listPPazioni = ProtocolUtils.convert(filtro.getProtocolPropertiesAzione())) != null && !listPPazioni.isEmpty()) {
                filtroDriver.setProtocolPropertiesAzione(listPPazioni);
            }
            if (filtro.getNomePortType() != null) {
                filtroDriver.setNomePortType(filtro.getNomePortType());
            }
            if ((listPPportTypes = ProtocolUtils.convert(filtro.getProtocolPropertiesPortType())) != null && !listPPportTypes.isEmpty()) {
                filtroDriver.setProtocolPropertiesPortType(listPPportTypes);
            }
            if (filtro.getNome() != null) {
                filtroDriver.setNomeAccordo(filtro.getNome());
            }
            if (filtro.getVersione() != null) {
                filtroDriver.setVersione(filtro.getVersione());
            }
            if (filtro.getSoggetto() != null) {
                if (filtro.getSoggetto().getTipo() != null) {
                    filtroDriver.setTipoSoggettoReferente(filtro.getSoggetto().getTipo());
                }
                if (filtro.getSoggetto().getNome() != null) {
                    filtroDriver.setNomeSoggettoReferente(filtro.getSoggetto().getNome());
                }
            }
            if (filtro.getServiceBinding() != null) {
                filtroDriver.setServiceBinding(filtro.getServiceBinding());
            }
            if (filtro.getIdGruppo() != null) {
                filtroDriver.setIdGruppo(filtro.getIdGruppo());
            }
            if ((listPP = ProtocolUtils.convert(filtro.getProtocolProperties())) != null && !listPP.isEmpty()) {
                filtroDriver.setProtocolPropertiesAccordo(listPP);
            }
            if (filtro.getEscludiServiziComposti() != null) {
                filtroDriver.setServizioComposto(Boolean.valueOf(filtro.getEscludiServiziComposti() == false));
            }
            if (filtro.getEscludiServiziNonComposti() != null) {
                filtroDriver.setServizioComposto(filtro.getEscludiServiziNonComposti());
            }
            return this.driverRegistroServiziGET.getAllIdAzionePortType(filtroDriver);
        }
        catch (DriverRegistroServiziNotFound de) {
            throw new RegistryNotFound(de.getMessage(), de);
        }
        catch (Exception e) {
            throw new RegistryException(e.getMessage(), e);
        }
    }

    @Override
    public boolean inUso(IDPortTypeAzione id) throws RegistryException {
        return this.inUsoDriver.inUso(id);
    }

    @Override
    public String getDettagliInUso(IDPortTypeAzione id) throws RegistryException {
        return this.inUsoDriver.getDettagliInUso(id);
    }

    @Override
    public Azione getAzioneAccordo(IDAccordoAzione id) throws RegistryNotFound, RegistryException {
        AccordoServizioParteComune as = this.getAccordoServizioParteComune(id.getIdAccordo());
        for (Azione azCheck : as.getAzioneList()) {
            if (!azCheck.getNome().equals(id.getNome())) continue;
            return azCheck;
        }
        String uriAccordo = null;
        try {
            uriAccordo = IDAccordoFactory.getInstance().getUriFromIDAccordo(id.getIdAccordo());
        }
        catch (Exception e) {
            uriAccordo = id.getIdAccordo().toString();
        }
        throw new RegistryNotFound("Azione [" + id.getNome() + "] non trovata all'interno dell'accordo [" + uriAccordo + "]");
    }

    @Override
    public List<IDAccordoAzione> findIdAzioneAccordo(ProtocolFiltroRicercaAccordoAzioni filtro) throws RegistryNotFound, RegistryException {
        try {
            List<FiltroRicercaProtocolPropertyRegistry> listPP;
            List<FiltroRicercaProtocolPropertyRegistry> listPPazioni;
            FiltroRicercaAzioni filtroDriver = new FiltroRicercaAzioni();
            if (filtro.getNomeAzione() != null) {
                filtroDriver.setNomeAzione(filtro.getNomeAzione());
            }
            if ((listPPazioni = ProtocolUtils.convert(filtro.getProtocolPropertiesAzione())) != null && !listPPazioni.isEmpty()) {
                filtroDriver.setProtocolPropertiesAzione(listPPazioni);
            }
            if (filtro.getNome() != null) {
                filtroDriver.setNomeAccordo(filtro.getNome());
            }
            if (filtro.getVersione() != null) {
                filtroDriver.setVersione(filtro.getVersione());
            }
            if (filtro.getSoggetto() != null) {
                if (filtro.getSoggetto().getTipo() != null) {
                    filtroDriver.setTipoSoggettoReferente(filtro.getSoggetto().getTipo());
                }
                if (filtro.getSoggetto().getNome() != null) {
                    filtroDriver.setNomeSoggettoReferente(filtro.getSoggetto().getNome());
                }
            }
            if (filtro.getServiceBinding() != null) {
                filtroDriver.setServiceBinding(filtro.getServiceBinding());
            }
            if (filtro.getIdGruppo() != null) {
                filtroDriver.setIdGruppo(filtro.getIdGruppo());
            }
            if ((listPP = ProtocolUtils.convert(filtro.getProtocolProperties())) != null && !listPP.isEmpty()) {
                filtroDriver.setProtocolPropertiesAccordo(listPP);
            }
            if (filtro.getEscludiServiziComposti() != null) {
                filtroDriver.setServizioComposto(Boolean.valueOf(filtro.getEscludiServiziComposti() == false));
            }
            if (filtro.getEscludiServiziNonComposti() != null) {
                filtroDriver.setServizioComposto(filtro.getEscludiServiziNonComposti());
            }
            return this.driverRegistroServiziGET.getAllIdAzioneAccordo(filtroDriver);
        }
        catch (DriverRegistroServiziNotFound de) {
            throw new RegistryNotFound(de.getMessage(), de);
        }
        catch (Exception e) {
            throw new RegistryException(e.getMessage(), e);
        }
    }

    @Override
    public Resource getResourceAccordo(IDResource id) throws RegistryNotFound, RegistryException {
        AccordoServizioParteComune as = this.getAccordoServizioParteComune(id.getIdAccordo());
        for (Resource resourceCheck : as.getResourceList()) {
            if (!resourceCheck.getNome().equals(id.getNome())) continue;
            return resourceCheck;
        }
        String uriAccordo = null;
        try {
            uriAccordo = IDAccordoFactory.getInstance().getUriFromIDAccordo(id.getIdAccordo());
        }
        catch (Exception e) {
            uriAccordo = id.getIdAccordo().toString();
        }
        throw new RegistryNotFound("Risorsa [" + id.getNome() + "] non trovata all'interno dell'accordo [" + uriAccordo + "]");
    }

    @Override
    public List<IDResource> findIdResourceAccordo(ProtocolFiltroRicercaRisorse filtro) throws RegistryNotFound, RegistryException {
        try {
            List<FiltroRicercaProtocolPropertyRegistry> listPP;
            List<FiltroRicercaProtocolPropertyRegistry> listPPresources;
            FiltroRicercaResources filtroDriver = new FiltroRicercaResources();
            if (filtro.getNomeRisorsa() != null) {
                filtroDriver.setResourceName(filtro.getNomeRisorsa());
            }
            if ((listPPresources = ProtocolUtils.convert(filtro.getProtocolPropertiesRisorsa())) != null && !listPPresources.isEmpty()) {
                filtroDriver.setProtocolPropertiesResources(listPPresources);
            }
            if (filtro.getNome() != null) {
                filtroDriver.setNomeAccordo(filtro.getNome());
            }
            if (filtro.getVersione() != null) {
                filtroDriver.setVersione(filtro.getVersione());
            }
            if (filtro.getSoggetto() != null) {
                if (filtro.getSoggetto().getTipo() != null) {
                    filtroDriver.setTipoSoggettoReferente(filtro.getSoggetto().getTipo());
                }
                if (filtro.getSoggetto().getNome() != null) {
                    filtroDriver.setNomeSoggettoReferente(filtro.getSoggetto().getNome());
                }
            }
            if (filtro.getServiceBinding() != null) {
                filtroDriver.setServiceBinding(filtro.getServiceBinding());
            }
            if (filtro.getIdGruppo() != null) {
                filtroDriver.setIdGruppo(filtro.getIdGruppo());
            }
            if ((listPP = ProtocolUtils.convert(filtro.getProtocolProperties())) != null && !listPP.isEmpty()) {
                filtroDriver.setProtocolPropertiesAccordo(listPP);
            }
            if (filtro.getEscludiServiziComposti() != null) {
                filtroDriver.setServizioComposto(Boolean.valueOf(filtro.getEscludiServiziComposti() == false));
            }
            if (filtro.getEscludiServiziNonComposti() != null) {
                filtroDriver.setServizioComposto(filtro.getEscludiServiziNonComposti());
            }
            return this.driverRegistroServiziGET.getAllIdResource(filtroDriver);
        }
        catch (DriverRegistroServiziNotFound de) {
            throw new RegistryNotFound(de.getMessage(), de);
        }
        catch (Exception e) {
            throw new RegistryException(e.getMessage(), e);
        }
    }

    @Override
    public boolean inUso(IDResource id) throws RegistryException {
        return this.inUsoDriver.inUso(id);
    }

    @Override
    public String getDettagliInUso(IDResource id) throws RegistryException {
        return this.inUsoDriver.getDettagliInUso(id);
    }

    @Override
    public AccordoServizioParteSpecifica getAccordoServizioParteSpecifica(IDServizio idServizio) throws RegistryNotFound, RegistryException {
        try {
            return this.driverRegistroServiziGET.getAccordoServizioParteSpecifica(idServizio);
        }
        catch (DriverRegistroServiziNotFound de) {
            throw new RegistryNotFound(de.getMessage(), de);
        }
        catch (Exception e) {
            throw new RegistryException(e.getMessage(), e);
        }
    }

    @Override
    public AccordoServizioParteSpecifica getAccordoServizioParteSpecifica(IDServizio idServizio, boolean readAllegati) throws RegistryNotFound, RegistryException {
        try {
            if (this.driverRegistroServiziGET instanceof DriverRegistroServiziDB) {
                return ((DriverRegistroServiziDB)this.driverRegistroServiziGET).getAccordoServizioParteSpecifica(idServizio, readAllegati);
            }
            return this.getAccordoServizioParteSpecifica(idServizio);
        }
        catch (DriverRegistroServiziNotFound de) {
            throw new RegistryNotFound(de.getMessage(), de);
        }
        catch (Exception e) {
            throw new RegistryException(e.getMessage(), e);
        }
    }

    @Override
    public List<IDServizio> findIdAccordiServizioParteSpecifica(ProtocolFiltroRicercaServizi filtro) throws RegistryNotFound, RegistryException {
        try {
            List<FiltroRicercaProtocolPropertyRegistry> listPP;
            FiltroRicercaServizi filtroDriver = new FiltroRicercaServizi();
            if (filtro.getIdAccordoServizioParteComune() != null) {
                filtroDriver.setIdAccordoServizioParteComune(filtro.getIdAccordoServizioParteComune());
            }
            if (filtro.getTipoServizio() != null) {
                filtroDriver.setTipo(filtro.getTipoServizio());
            }
            if (filtro.getNomeServizio() != null) {
                filtroDriver.setNome(filtro.getNomeServizio());
            }
            if (filtro.getVersioneServizio() != null) {
                filtroDriver.setVersione(filtro.getVersioneServizio());
            }
            if (filtro.getSoggettoErogatore() != null) {
                if (filtro.getSoggettoErogatore().getTipo() != null) {
                    filtroDriver.setTipoSoggettoErogatore(filtro.getSoggettoErogatore().getTipo());
                }
                if (filtro.getSoggettoErogatore().getNome() != null) {
                    filtroDriver.setNomeSoggettoErogatore(filtro.getSoggettoErogatore().getNome());
                }
            }
            if (filtro.getPortType() != null) {
                filtroDriver.setPortType(filtro.getPortType());
            }
            if ((listPP = ProtocolUtils.convert(filtro.getProtocolPropertiesServizi())) != null && !listPP.isEmpty()) {
                filtroDriver.setProtocolProperties(listPP);
            }
            return this.driverRegistroServiziGET.getAllIdServizi(filtroDriver);
        }
        catch (DriverRegistroServiziNotFound de) {
            throw new RegistryNotFound(de.getMessage(), de);
        }
        catch (Exception e) {
            throw new RegistryException(e.getMessage(), e);
        }
    }

    @Override
    public List<IDFruizione> findIdFruizioni(ProtocolFiltroRicercaFruizioniServizio filtro) throws RegistryNotFound, RegistryException {
        try {
            List<FiltroRicercaProtocolPropertyRegistry> listPP;
            List<FiltroRicercaProtocolPropertyRegistry> listPPfruitore;
            FiltroRicercaFruizioniServizio filtroDriver = new FiltroRicercaFruizioniServizio();
            if (filtro.getSoggettoFruitore() != null) {
                if (filtro.getSoggettoFruitore().getTipo() != null) {
                    filtroDriver.setTipoSoggettoFruitore(filtro.getSoggettoFruitore().getTipo());
                }
                if (filtro.getSoggettoFruitore().getNome() != null) {
                    filtroDriver.setNomeSoggettoFruitore(filtro.getSoggettoFruitore().getNome());
                }
            }
            if ((listPPfruitore = ProtocolUtils.convert(filtro.getProtocolPropertiesFruizione())) != null && !listPPfruitore.isEmpty()) {
                filtroDriver.setProtocolPropertiesFruizione(listPPfruitore);
            }
            if (filtro.getIdAccordoServizioParteComune() != null) {
                filtroDriver.setIdAccordoServizioParteComune(filtro.getIdAccordoServizioParteComune());
            }
            if (filtro.getTipoServizio() != null) {
                filtroDriver.setTipo(filtro.getTipoServizio());
            }
            if (filtro.getNomeServizio() != null) {
                filtroDriver.setNome(filtro.getNomeServizio());
            }
            if (filtro.getVersioneServizio() != null) {
                filtroDriver.setVersione(filtro.getVersioneServizio());
            }
            if (filtro.getSoggettoErogatore() != null) {
                if (filtro.getSoggettoErogatore().getTipo() != null) {
                    filtroDriver.setTipoSoggettoErogatore(filtro.getSoggettoErogatore().getTipo());
                }
                if (filtro.getSoggettoErogatore().getNome() != null) {
                    filtroDriver.setNomeSoggettoErogatore(filtro.getSoggettoErogatore().getNome());
                }
            }
            if (filtro.getPortType() != null) {
                filtroDriver.setPortType(filtro.getPortType());
            }
            if ((listPP = ProtocolUtils.convert(filtro.getProtocolPropertiesServizi())) != null && !listPP.isEmpty()) {
                filtroDriver.setProtocolProperties(listPP);
            }
            return this.driverRegistroServiziGET.getAllIdFruizioniServizio(filtroDriver);
        }
        catch (DriverRegistroServiziNotFound de) {
            throw new RegistryNotFound(de.getMessage(), de);
        }
        catch (Exception e) {
            throw new RegistryException(e.getMessage(), e);
        }
    }

    @Override
    public AccordoCooperazione getAccordoCooperazione(IDAccordoCooperazione idAccordo) throws RegistryNotFound, RegistryException {
        try {
            return this.driverRegistroServiziGET.getAccordoCooperazione(idAccordo);
        }
        catch (DriverRegistroServiziNotFound de) {
            throw new RegistryNotFound(de.getMessage(), de);
        }
        catch (Exception e) {
            throw new RegistryException(e.getMessage(), e);
        }
    }

    @Override
    public AccordoCooperazione getAccordoCooperazione(IDAccordoCooperazione idAccordo, boolean readAllegati) throws RegistryNotFound, RegistryException {
        try {
            if (this.driverRegistroServiziGET instanceof DriverRegistroServiziDB) {
                return ((DriverRegistroServiziDB)this.driverRegistroServiziGET).getAccordoCooperazione(idAccordo, readAllegati);
            }
            return this.getAccordoCooperazione(idAccordo);
        }
        catch (DriverRegistroServiziNotFound de) {
            throw new RegistryNotFound(de.getMessage(), de);
        }
        catch (Exception e) {
            throw new RegistryException(e.getMessage(), e);
        }
    }

    @Override
    public List<IDAccordoCooperazione> findIdAccordiCooperazione(ProtocolFiltroRicercaAccordi filtro) throws RegistryNotFound, RegistryException {
        try {
            List<FiltroRicercaProtocolPropertyRegistry> listPP;
            FiltroRicercaAccordi filtroDriver = new FiltroRicercaAccordi();
            if (filtro.getNome() != null) {
                filtroDriver.setNomeAccordo(filtro.getNome());
            }
            if (filtro.getVersione() != null) {
                filtroDriver.setVersione(filtro.getVersione());
            }
            if (filtro.getSoggetto() != null) {
                if (filtro.getSoggetto().getTipo() != null) {
                    filtroDriver.setTipoSoggettoReferente(filtro.getSoggetto().getTipo());
                }
                if (filtro.getSoggetto().getNome() != null) {
                    filtroDriver.setNomeSoggettoReferente(filtro.getSoggetto().getNome());
                }
            }
            if (filtro.getServiceBinding() != null) {
                filtroDriver.setServiceBinding(filtro.getServiceBinding());
            }
            if (filtro.getIdGruppo() != null) {
                filtroDriver.setIdGruppo(filtro.getIdGruppo());
            }
            if ((listPP = ProtocolUtils.convert(filtro.getProtocolProperties())) != null && !listPP.isEmpty()) {
                filtroDriver.setProtocolPropertiesAccordo(listPP);
            }
            if (filtro.getEscludiServiziComposti() != null) {
                filtroDriver.setServizioComposto(Boolean.valueOf(filtro.getEscludiServiziComposti() == false));
            }
            if (filtro.getEscludiServiziNonComposti() != null) {
                filtroDriver.setServizioComposto(filtro.getEscludiServiziNonComposti());
            }
            return this.driverRegistroServiziGET.getAllIdAccordiCooperazione(filtroDriver);
        }
        catch (DriverRegistroServiziNotFound de) {
            throw new RegistryNotFound(de.getMessage(), de);
        }
        catch (Exception e) {
            throw new RegistryException(e.getMessage(), e);
        }
    }

    @Override
    public List<IDGruppo> findIdGruppi(ProtocolFiltroRicercaGruppi filtro) throws RegistryNotFound, RegistryException {
        try {
            FiltroRicercaGruppi filtroDriver = new FiltroRicercaGruppi();
            if (filtro.getMinDate() != null) {
                filtroDriver.setMinDate(filtro.getMinDate());
            }
            if (filtro.getMaxDate() != null) {
                filtroDriver.setMaxDate(filtro.getMaxDate());
            }
            filtroDriver.setOrdinaDataRegistrazione(filtro.isOrdinaDataRegistrazione());
            if (filtro.getNome() != null) {
                filtroDriver.setNome(filtro.getNome());
            }
            if (filtro.getTipo() != null) {
                filtroDriver.setTipo(filtro.getTipo());
            }
            if (filtro.getServiceBinding() != null) {
                filtroDriver.setServiceBinding(filtro.getServiceBinding());
            }
            if (filtro.getProtocollo() != null) {
                filtroDriver.setProtocollo(filtro.getProtocollo());
            }
            if (filtro.getProtocolli() != null) {
                filtroDriver.setProtocolli(filtro.getProtocolli());
            }
            return this.driverRegistroServiziGET.getAllIdGruppi(filtroDriver);
        }
        catch (DriverRegistroServiziNotFound de) {
            throw new RegistryNotFound(de.getMessage(), de);
        }
        catch (Exception e) {
            throw new RegistryException(e.getMessage(), e);
        }
    }

    @Override
    public List<IDRuolo> findIdRuoli(ProtocolFiltroRicercaRuoli filtro) throws RegistryNotFound, RegistryException {
        try {
            FiltroRicercaRuoli filtroDriver = new FiltroRicercaRuoli();
            if (filtro.getMinDate() != null) {
                filtroDriver.setMinDate(filtro.getMinDate());
            }
            if (filtro.getMaxDate() != null) {
                filtroDriver.setMaxDate(filtro.getMaxDate());
            }
            if (filtro.getNome() != null) {
                filtroDriver.setNome(filtro.getNome());
            }
            if (filtro.getTipo() != null) {
                filtroDriver.setTipo(filtro.getTipo());
            }
            if (filtro.getTipologia() != null) {
                filtroDriver.setTipologia(filtro.getTipologia());
            }
            if (filtro.getContesto() != null) {
                filtroDriver.setContesto(filtro.getContesto());
            }
            return this.driverRegistroServiziGET.getAllIdRuoli(filtroDriver);
        }
        catch (DriverRegistroServiziNotFound de) {
            throw new RegistryNotFound(de.getMessage(), de);
        }
        catch (Exception e) {
            throw new RegistryException(e.getMessage(), e);
        }
    }

    @Override
    public List<IDScope> findIdScope(ProtocolFiltroRicercaScope filtro) throws RegistryNotFound, RegistryException {
        try {
            FiltroRicercaScope filtroDriver = new FiltroRicercaScope();
            if (filtro.getMinDate() != null) {
                filtroDriver.setMinDate(filtro.getMinDate());
            }
            if (filtro.getMaxDate() != null) {
                filtroDriver.setMaxDate(filtro.getMaxDate());
            }
            if (filtro.getNome() != null) {
                filtroDriver.setNome(filtro.getNome());
            }
            if (filtro.getTipo() != null) {
                filtroDriver.setTipo(filtro.getTipo());
            }
            if (filtro.getTipologia() != null) {
                filtroDriver.setTipologia(filtro.getTipologia());
            }
            if (filtro.getContesto() != null) {
                filtroDriver.setContesto(filtro.getContesto());
            }
            return this.driverRegistroServiziGET.getAllIdScope(filtroDriver);
        }
        catch (DriverRegistroServiziNotFound de) {
            throw new RegistryNotFound(de.getMessage(), de);
        }
        catch (Exception e) {
            throw new RegistryException(e.getMessage(), e);
        }
    }
}

