/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.protocol.basic.config;

import java.util.ArrayList;
import java.util.List;
import org.openspcoop2.core.allarmi.Allarme;
import org.openspcoop2.core.allarmi.utils.AllarmiDriverUtils;
import org.openspcoop2.core.config.PortaApplicativa;
import org.openspcoop2.core.config.PortaApplicativaAzione;
import org.openspcoop2.core.config.constants.PortaApplicativaAzioneIdentificazione;
import org.openspcoop2.core.config.constants.StatoFunzionalita;
import org.openspcoop2.core.controllo_traffico.AttivazionePolicy;
import org.openspcoop2.core.controllo_traffico.utils.ControlloTrafficoDriverUtils;
import org.openspcoop2.core.id.IDPortaApplicativa;
import org.openspcoop2.core.id.IDServizio;
import org.openspcoop2.core.mapping.ImplementationUtils;
import org.openspcoop2.core.mapping.MappingErogazionePortaApplicativa;
import org.openspcoop2.protocol.basic.config.AbstractIntegrationConfiguration;
import org.openspcoop2.protocol.manifest.IntegrationConfiguration;
import org.openspcoop2.protocol.manifest.IntegrationConfigurationResourceIdentificationMode;
import org.openspcoop2.protocol.manifest.constants.ResourceIdentificationType;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.protocol.sdk.config.ProtocolImplementation;
import org.openspcoop2.protocol.sdk.constants.ConsoleInterfaceType;
import org.openspcoop2.protocol.sdk.registry.IConfigIntegrationReader;

public class ImplementationConfiguration
extends AbstractIntegrationConfiguration {
    private static final long serialVersionUID = 1L;
    private static final String SERVICE_IMPLEMENTATION_PREFIX = "Service implementation ";
    private static final String INTERNAL_IMPLEMENTATION_PREFIX = "Internal Implementation '";

    protected ImplementationConfiguration(IntegrationConfiguration integrationConfiguration) {
        super(integrationConfiguration);
    }

    public static boolean isDescriptionDefault(String descrizione) {
        return descrizione != null && (descrizione.startsWith(INTERNAL_IMPLEMENTATION_PREFIX) || descrizione.startsWith(SERVICE_IMPLEMENTATION_PREFIX));
    }

    public ProtocolImplementation createDefaultImplementation(IDServizio idServizio) throws ProtocolException {
        ProtocolImplementation implementation = new ProtocolImplementation();
        PortaApplicativa portaApplicativa = new PortaApplicativa();
        portaApplicativa.setNome(this.getNome(idServizio, null, null, null, this.integrationConfiguration.getName().getParamList()));
        portaApplicativa.setDescrizione(SERVICE_IMPLEMENTATION_PREFIX + idServizio.toString());
        if (portaApplicativa.getDescrizione().length() > 255) {
            portaApplicativa.setDescrizione(SERVICE_IMPLEMENTATION_PREFIX + idServizio.toString());
        }
        if (portaApplicativa.getDescrizione().length() > 255) {
            portaApplicativa.setDescrizione(null);
        }
        IDPortaApplicativa idPortaApplicativa = ImplementationUtils.setCommonParameter((PortaApplicativa)portaApplicativa, (IDServizio)idServizio, (boolean)true, (boolean)false);
        PortaApplicativaAzione pdAzione = new PortaApplicativaAzione();
        ResourceIdentificationType defaultIdentification = this.integrationConfiguration.getResourceIdentification().getIdentificationModes().getDefault();
        if (defaultIdentification == null) {
            defaultIdentification = this.integrationConfiguration.getResourceIdentification().getIdentificationModes().getMode(0).getName();
        }
        boolean setPattern = false;
        switch (defaultIdentification) {
            case CONTENT: {
                pdAzione.setIdentificazione(PortaApplicativaAzioneIdentificazione.CONTENT_BASED);
                setPattern = true;
                break;
            }
            case HEADER: {
                pdAzione.setIdentificazione(PortaApplicativaAzioneIdentificazione.HEADER_BASED);
                setPattern = true;
                break;
            }
            case URL: {
                pdAzione.setIdentificazione(PortaApplicativaAzioneIdentificazione.URL_BASED);
                setPattern = true;
                break;
            }
            case INPUT: {
                pdAzione.setIdentificazione(PortaApplicativaAzioneIdentificazione.INPUT_BASED);
                break;
            }
            case INTERFACE: {
                pdAzione.setIdentificazione(PortaApplicativaAzioneIdentificazione.INTERFACE_BASED);
                break;
            }
            case SOAP_ACTION: {
                pdAzione.setIdentificazione(PortaApplicativaAzioneIdentificazione.SOAP_ACTION_BASED);
                break;
            }
            case PROTOCOL: {
                pdAzione.setIdentificazione(PortaApplicativaAzioneIdentificazione.PROTOCOL_BASED);
            }
        }
        if (setPattern) {
            pdAzione.setPattern(this.getNome(idServizio, null, portaApplicativa.getNome(), null, this.integrationConfiguration.getResourceIdentification().getIdentificationParameter().getParamList()));
        }
        if (this.integrationConfiguration.getResourceIdentification().getIdentificationModes().isForceInterfaceMode()) {
            pdAzione.setForceInterfaceBased(StatoFunzionalita.ABILITATO);
        } else {
            pdAzione.setForceInterfaceBased(StatoFunzionalita.DISABILITATO);
        }
        portaApplicativa.setAzione(pdAzione);
        portaApplicativa.setRicercaPortaAzioneDelegata(StatoFunzionalita.ABILITATO);
        implementation.setPortaApplicativa(portaApplicativa);
        MappingErogazionePortaApplicativa mappingErogazione = ImplementationUtils.createMappingDefault((IDServizio)idServizio, (IDPortaApplicativa)idPortaApplicativa);
        implementation.setMapping(mappingErogazione);
        return implementation;
    }

    public List<PortaApplicativaAzioneIdentificazione> supportedIdentificationModes(ConsoleInterfaceType consoleType) {
        ArrayList<PortaApplicativaAzioneIdentificazione> list = new ArrayList<PortaApplicativaAzioneIdentificazione>();
        for (IntegrationConfigurationResourceIdentificationMode mode : this.integrationConfiguration.getResourceIdentification().getIdentificationModes().getModeList()) {
            if (mode.isOnlyAdvancedMode() && ConsoleInterfaceType.STANDARD.equals((Object)consoleType)) continue;
            ResourceIdentificationType type = mode.getName();
            switch (type) {
                case CONTENT: {
                    list.add(PortaApplicativaAzioneIdentificazione.CONTENT_BASED);
                    break;
                }
                case HEADER: {
                    list.add(PortaApplicativaAzioneIdentificazione.HEADER_BASED);
                    break;
                }
                case URL: {
                    list.add(PortaApplicativaAzioneIdentificazione.URL_BASED);
                    break;
                }
                case INPUT: {
                    list.add(PortaApplicativaAzioneIdentificazione.INPUT_BASED);
                    break;
                }
                case INTERFACE: {
                    list.add(PortaApplicativaAzioneIdentificazione.INTERFACE_BASED);
                    break;
                }
                case SOAP_ACTION: {
                    list.add(PortaApplicativaAzioneIdentificazione.SOAP_ACTION_BASED);
                    break;
                }
                case PROTOCOL: {
                    list.add(PortaApplicativaAzioneIdentificazione.PROTOCOL_BASED);
                }
            }
        }
        return list;
    }

    public ProtocolImplementation createImplementation(IConfigIntegrationReader configIntegrationReader, IDServizio idServizio, PortaApplicativa portaApplicativaDefault, String ruleName, String description, String ... azione) throws ProtocolException {
        return this.createImplementation(configIntegrationReader, idServizio, portaApplicativaDefault, (PortaApplicativa)null, ruleName, description, azione);
    }

    public ProtocolImplementation createImplementation(IConfigIntegrationReader configIntegrationReader, IDServizio idServizio, PortaApplicativa portaApplicativaDefault, PortaApplicativa portaApplicativaDaClonare, String ruleName, String description, String ... azione) throws ProtocolException {
        if (azione == null || azione.length <= 0) {
            throw new ProtocolException("Actions undefined");
        }
        String nomePortaDelegante = portaApplicativaDefault.getNome();
        String nomeNuovaPortaApplicativa = this.getNome(idServizio, null, nomePortaDelegante, ruleName, this.integrationConfiguration.getResourceIdentification().getSpecificResource().getName().getParamList());
        String descrizioneNuovaPortaApplicativa = INTERNAL_IMPLEMENTATION_PREFIX + ruleName + "' for " + nomePortaDelegante;
        if (descrizioneNuovaPortaApplicativa.length() > 255) {
            descrizioneNuovaPortaApplicativa = INTERNAL_IMPLEMENTATION_PREFIX + ruleName + "'";
        }
        if (descrizioneNuovaPortaApplicativa.length() > 255) {
            descrizioneNuovaPortaApplicativa = null;
        }
        ProtocolImplementation implementation = new ProtocolImplementation();
        PortaApplicativa portaApplicativa = null;
        boolean setDatiServizio = false;
        boolean portaClonata = false;
        if (portaApplicativaDaClonare != null) {
            portaApplicativa = (PortaApplicativa)portaApplicativaDaClonare.clone();
            portaApplicativa.setId(null);
            portaApplicativa.setGestioneCors(null);
            portaApplicativa.setCanale(null);
            IDPortaApplicativa idPA = new IDPortaApplicativa();
            idPA.setNome(portaApplicativaDaClonare.getNome());
            List<AttivazionePolicy> listAP = null;
            try {
                listAP = configIntegrationReader.getRateLimitingPolicy(idPA);
            }
            catch (Exception exception) {
                // empty catch block
            }
            ArrayList<String> idPolicyCreate = new ArrayList<String>();
            if (listAP != null && !listAP.isEmpty()) {
                for (AttivazionePolicy attivazionePolicy : listAP) {
                    AttivazionePolicy apCloned = (AttivazionePolicy)attivazionePolicy.clone();
                    if (apCloned.getIdPolicy() == null || apCloned.getFiltro() == null || !portaApplicativaDaClonare.getNome().equals(apCloned.getFiltro().getNomePorta())) continue;
                    try {
                        apCloned.getFiltro().setNomePorta(nomeNuovaPortaApplicativa);
                        String serialId = configIntegrationReader.getNextPolicyInstanceSerialId(apCloned.getIdPolicy());
                        String idActive = ControlloTrafficoDriverUtils.buildIdActivePolicy((String)apCloned.getIdPolicy(), (String)serialId);
                        for (int limit = 0; idPolicyCreate.contains(idActive) && limit < 1000; ++limit) {
                            serialId = ControlloTrafficoDriverUtils.incrementPolicyInstanceSerialId((String)serialId);
                            idActive = ControlloTrafficoDriverUtils.buildIdActivePolicy((String)apCloned.getIdPolicy(), (String)serialId);
                        }
                        idPolicyCreate.add(idActive);
                        apCloned.setIdActivePolicy(idActive);
                        if (implementation.getRateLimitingPolicies() == null) {
                            implementation.setRateLimitingPolicies(new ArrayList());
                        }
                        implementation.getRateLimitingPolicies().add(apCloned);
                    }
                    catch (Exception serialId) {}
                }
            }
            List<Allarme> listAllarmi = null;
            try {
                listAllarmi = configIntegrationReader.getAllarmi(idPA);
            }
            catch (Exception attivazionePolicy) {
                // empty catch block
            }
            ArrayList<String> idAllarmiCreate = new ArrayList<String>();
            if (listAllarmi != null && !listAllarmi.isEmpty()) {
                for (Allarme allarme : listAllarmi) {
                    Allarme allarmeCloned = (Allarme)allarme.clone();
                    if (allarmeCloned.getTipo() == null || allarmeCloned.getFiltro() == null || !portaApplicativaDaClonare.getNome().equals(allarmeCloned.getFiltro().getNomePorta())) continue;
                    try {
                        allarmeCloned.getFiltro().setNomePorta(nomeNuovaPortaApplicativa);
                        String serialId = configIntegrationReader.getNextAlarmInstanceSerialId(allarmeCloned.getTipo());
                        String uniqueName = AllarmiDriverUtils.buildIdAlarm((String)allarmeCloned.getTipo(), (String)serialId);
                        for (int limit = 0; idAllarmiCreate.contains(uniqueName) && limit < 1000; ++limit) {
                            serialId = AllarmiDriverUtils.incrementAlarmInstanceSerialId((String)serialId);
                            uniqueName = AllarmiDriverUtils.buildIdAlarm((String)allarmeCloned.getTipo(), (String)serialId);
                        }
                        idAllarmiCreate.add(uniqueName);
                        allarmeCloned.setNome(uniqueName);
                        if (implementation.getAllarmi() == null) {
                            implementation.setAllarmi(new ArrayList());
                        }
                        implementation.getAllarmi().add(allarmeCloned);
                    }
                    catch (Exception exception) {}
                }
            }
            portaClonata = true;
        } else {
            portaApplicativa = new PortaApplicativa();
            setDatiServizio = true;
        }
        portaApplicativa.setNome(nomeNuovaPortaApplicativa);
        portaApplicativa.setDescrizione(descrizioneNuovaPortaApplicativa);
        IDPortaApplicativa idPortaApplicativa = ImplementationUtils.setCommonParameter((PortaApplicativa)portaApplicativa, (IDServizio)idServizio, (boolean)setDatiServizio, (boolean)portaClonata);
        ImplementationUtils.setAzioneDelegate((PortaApplicativa)portaApplicativa, (String)nomePortaDelegante, (String[])azione);
        implementation.setPortaApplicativa(portaApplicativa);
        MappingErogazionePortaApplicativa mappingErogazione = ImplementationUtils.createMapping((IDServizio)idServizio, (IDPortaApplicativa)idPortaApplicativa, (String)ruleName, (String)description);
        implementation.setMapping(mappingErogazione);
        return implementation;
    }
}

