/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.protocol.basic;

import javax.xml.soap.SOAPElement;
import org.openspcoop2.message.OpenSPCoop2MessageFactory;
import org.openspcoop2.message.constants.ServiceBinding;
import org.openspcoop2.message.xml.MessageXMLUtils;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class Utilities {
    public static String toString(OpenSPCoop2MessageFactory messageFactory, SOAPElement soapElement, boolean consume) throws ProtocolException {
        if (soapElement == null) {
            throw new ProtocolException("Conversione in element non riuscita");
        }
        try {
            MessageXMLUtils xmlUtils = MessageXMLUtils.getInstance((OpenSPCoop2MessageFactory)messageFactory);
            String xml = OpenSPCoop2MessageFactory.getAsString((OpenSPCoop2MessageFactory)messageFactory, (Node)soapElement, (boolean)consume);
            if (xml == null && (xml = xmlUtils.toString((Element)soapElement, true)) == null) {
                throw new Exception("Conversione in stringa non riuscita");
            }
            return xml;
        }
        catch (ProtocolException pe) {
            throw pe;
        }
        catch (Exception e) {
            throw new ProtocolException(e.getMessage(), e);
        }
    }

    public static byte[] toByteArray(OpenSPCoop2MessageFactory messageFactory, SOAPElement soapElement, boolean consume) throws ProtocolException {
        if (soapElement == null) {
            throw new ProtocolException("Conversione in element non riuscita");
        }
        try {
            MessageXMLUtils xmlUtils = MessageXMLUtils.getInstance((OpenSPCoop2MessageFactory)messageFactory);
            byte[] xml = OpenSPCoop2MessageFactory.getAsByte((OpenSPCoop2MessageFactory)messageFactory, (Node)soapElement, (boolean)consume);
            if (xml == null && (xml = xmlUtils.toByteArray((Element)soapElement, true)) == null) {
                throw new Exception("Conversione in bytes non riuscita");
            }
            return xml;
        }
        catch (ProtocolException pe) {
            throw pe;
        }
        catch (Exception e) {
            throw new ProtocolException(e.getMessage(), e);
        }
    }

    public static ServiceBinding convert(org.openspcoop2.core.registry.constants.ServiceBinding serviceBinding) {
        switch (serviceBinding) {
            case SOAP: {
                return ServiceBinding.SOAP;
            }
            case REST: {
                return ServiceBinding.REST;
            }
        }
        return null;
    }

    public static ServiceBinding convert(org.openspcoop2.protocol.manifest.constants.ServiceBinding serviceBinding) {
        switch (serviceBinding) {
            case SOAP: {
                return ServiceBinding.SOAP;
            }
            case REST: {
                return ServiceBinding.REST;
            }
        }
        return null;
    }
}

