/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.protocol.basic;

import org.openspcoop2.protocol.sdk.IComponentFactory;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.slf4j.Logger;

public class BasicComponentFactory
implements IComponentFactory {
    private static Logger checkLogger = null;
    private static boolean checkIsClosed = true;
    private static boolean checkAutocommit = true;
    protected Logger log;
    protected IProtocolFactory<?> protocolFactory;

    public static boolean isCheckIsClosed() {
        return checkIsClosed;
    }

    public static void setCheckIsClosed(boolean checkIsClosed) {
        BasicComponentFactory.checkIsClosed = checkIsClosed;
    }

    public static boolean isCheckAutocommit() {
        return checkAutocommit;
    }

    public static void setCheckAutocommit(boolean checkAutocommit) {
        BasicComponentFactory.checkAutocommit = checkAutocommit;
    }

    public static Logger getCheckLogger() {
        return checkLogger;
    }

    public static void setCheckLogger(Logger checkLogger) {
        BasicComponentFactory.checkLogger = checkLogger;
    }

    public BasicComponentFactory(IProtocolFactory<?> protocolFactory) throws ProtocolException {
        try {
            this.protocolFactory = protocolFactory;
            this.log = this.protocolFactory.getLogger();
        }
        catch (Exception e) {
            throw new ProtocolException(e.getMessage(), e);
        }
    }

    public Logger getLog() {
        return this.log;
    }

    public void logError(String msg) {
        if (this.log != null) {
            this.log.error(msg);
        }
    }

    public void logError(String msg, Exception e) {
        if (this.log != null) {
            this.log.error(msg, (Throwable)e);
        }
    }

    public void logInfo(String msg) {
        if (this.log != null) {
            this.log.info(msg);
        }
    }

    public void logDebug(String msg) {
        if (this.log != null) {
            this.log.debug(msg);
        }
    }

    @Override
    public IProtocolFactory<?> getProtocolFactory() {
        return this.protocolFactory;
    }
}

