/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.protocol.abstraction.csv;

import freemarker.template.Template;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import org.openspcoop2.protocol.abstraction.Erogazione;
import org.openspcoop2.protocol.abstraction.Fruizione;
import org.openspcoop2.protocol.abstraction.utils.XSDValidator;
import org.openspcoop2.protocol.abstraction.utils.serializer.JaxbDeserializer;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.protocol.utils.ManagerUtils;
import org.openspcoop2.utils.Utilities;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.csv.Format;
import org.openspcoop2.utils.csv.FormatReader;
import org.openspcoop2.utils.csv.Parser;
import org.openspcoop2.utils.csv.ParserResult;
import org.openspcoop2.utils.csv.Record;
import org.openspcoop2.utils.resources.TemplateUtils;
import org.slf4j.Logger;

public class Deserializer {
    private static final String PROTOCOLLO = "protocollo";
    private static final String DEFAULT_SUBJECT_TYPE = "_DefaultSubjectType_";
    private JaxbDeserializer jaxbAbstractionDeserializer = new JaxbDeserializer();
    private boolean validate;
    private Logger log;

    public Deserializer(boolean validate, Logger log) throws ProtocolException {
        this.validate = validate;
        this.log = log;
    }

    public List<Erogazione> toErogazione(byte[] erogazioneTemplateParam, byte[] formatParam, byte[] mappingParam, byte[] csv) throws ProtocolException {
        return this.toErogazione(erogazioneTemplateParam, formatParam, mappingParam, csv, "UTF-8");
    }

    public List<Erogazione> toErogazione(byte[] erogazioneTemplateParam, byte[] formatParam, byte[] mappingParam, byte[] csv, String charset) throws ProtocolException {
        Properties format = null;
        if (formatParam != null) {
            try {
                format = Utilities.getAsProperties((byte[])formatParam);
            }
            catch (UtilsException e) {
                throw new ProtocolException(e.getMessage(), e);
            }
        }
        Properties mapping = null;
        if (mappingParam != null) {
            try {
                mapping = Utilities.getAsProperties((byte[])mappingParam);
            }
            catch (UtilsException e) {
                throw new ProtocolException(e.getMessage(), e);
            }
        }
        return this.toErogazione(erogazioneTemplateParam, format, mapping, csv, charset);
    }

    public List<Erogazione> toErogazione(byte[] erogazioneTemplateParam, Properties formatParam, Properties mappingParam, byte[] csvParam) throws ProtocolException {
        return this.toErogazione(erogazioneTemplateParam, formatParam, mappingParam, csvParam, "UTF-8");
    }

    public List<Erogazione> toErogazione(byte[] erogazioneTemplateParam, Properties formatParam, Properties mappingParam, byte[] csvParam, String charset) throws ProtocolException {
        String csv = null;
        if (csvParam == null) {
            throw new ProtocolException("CSV non disponibile");
        }
        if (charset == null) {
            charset = "UTF-8";
        }
        try {
            csv = new String(csvParam, charset);
        }
        catch (Exception e) {
            throw new ProtocolException("CSV con formato errato [encoding:" + charset + "]: " + e.getMessage());
        }
        return this.toErogazione(erogazioneTemplateParam, formatParam, mappingParam, csv);
    }

    public List<Erogazione> toErogazione(byte[] erogazioneTemplateParam, byte[] formatParam, byte[] mappingParam, String csv) throws ProtocolException {
        Properties format = null;
        if (formatParam != null) {
            try {
                format = Utilities.getAsProperties((byte[])formatParam);
            }
            catch (UtilsException e) {
                throw new ProtocolException(e.getMessage(), e);
            }
        }
        Properties mapping = null;
        if (mappingParam != null) {
            try {
                mapping = Utilities.getAsProperties((byte[])mappingParam);
            }
            catch (UtilsException e) {
                throw new ProtocolException(e.getMessage(), e);
            }
        }
        return this.toErogazione(erogazioneTemplateParam, format, mapping, csv);
    }

    public List<Erogazione> toErogazione(byte[] erogazioneTemplateParam, Properties formatParam, Properties mappingParam, String csv) throws ProtocolException {
        try {
            Properties mapping;
            byte[] erogazioneTemplate = erogazioneTemplateParam;
            Template template = null;
            if (erogazioneTemplate == null) {
                erogazioneTemplate = this.readBytes("/templates/csv/Erogazione.ftl");
            }
            try {
                template = TemplateUtils.buildTemplate((String)"Erogazione", (byte[])erogazioneTemplate);
            }
            catch (Exception e) {
                throw new ProtocolException("Build Template error: " + e.getMessage());
            }
            Properties format = formatParam;
            if (format == null) {
                format = this.readProperties("/templates/csv/format.properties");
            }
            if ((mapping = mappingParam) == null) {
                mapping = this.readProperties("/templates/csv/erogazione.properties");
            }
            ArrayList<Erogazione> listErogazioni = new ArrayList<Erogazione>();
            FormatReader formatReader = new FormatReader(format);
            Format f = formatReader.getFormat();
            Parser p = new Parser(mapping, true);
            ParserResult pr = p.parseCsvFile(f, csv);
            for (Record record : pr.getRecords()) {
                HashMap<String, String> mapFreemarker = new HashMap<String, String>();
                if (record.getMap().size() <= 0) {
                    throw new ProtocolException("Csv Record at line [" + record.getCsvLine() + "] not correct, mapping produce 0 fields");
                }
                List keys = record.getMap().keys();
                for (String key : keys) {
                    String s = record.getMap().get(key);
                    if (s == null) continue;
                    mapFreemarker.put(key, s);
                }
                String protocollo = record.getMap().get(PROTOCOLLO);
                if (protocollo == null) {
                    protocollo = ManagerUtils.getDefaultProtocol();
                }
                mapFreemarker.put(DEFAULT_SUBJECT_TYPE, ManagerUtils.getDefaultOrganizationType(protocollo));
                byte[] xmlErogazione = null;
                try {
                    xmlErogazione = TemplateUtils.toByteArray((Template)template, mapFreemarker);
                }
                catch (Exception e) {
                    throw new ProtocolException("Csv Record at line [" + record.getCsvLine() + "] not correct (Build xml from template failed): " + e.getMessage());
                }
                ByteArrayInputStream bin = null;
                try {
                    if (this.validate) {
                        bin = new ByteArrayInputStream(xmlErogazione);
                        XSDValidator.getXSDValidator(this.log).valida((InputStream)bin);
                    }
                    Erogazione erogazione = this.jaxbAbstractionDeserializer.readErogazione(xmlErogazione);
                    listErogazioni.add(erogazione);
                }
                catch (Exception e) {
                    throw new ProtocolException("Csv Record at line [" + record.getCsvLine() + "] not correct. Marshall Xml [" + new String(xmlErogazione) + "]\n" + e.getMessage(), e);
                }
                finally {
                    try {
                        if (bin == null) continue;
                        bin.close();
                    }
                    catch (Exception exception) {}
                }
            }
            return listErogazioni;
        }
        catch (UtilsException e) {
            throw new ProtocolException(e.getMessage(), e);
        }
    }

    public List<Fruizione> toFruizione(byte[] fruizioneTemplateParam, byte[] formatParam, byte[] mappingParam, byte[] csv) throws ProtocolException {
        return this.toFruizione(fruizioneTemplateParam, formatParam, mappingParam, csv, "UTF-8");
    }

    public List<Fruizione> toFruizione(byte[] fruizioneTemplateParam, byte[] formatParam, byte[] mappingParam, byte[] csv, String charset) throws ProtocolException {
        Properties format = null;
        if (formatParam != null) {
            try {
                format = Utilities.getAsProperties((byte[])formatParam);
            }
            catch (UtilsException e) {
                throw new ProtocolException(e.getMessage(), e);
            }
        }
        Properties mapping = null;
        if (mappingParam != null) {
            try {
                mapping = Utilities.getAsProperties((byte[])mappingParam);
            }
            catch (UtilsException e) {
                throw new ProtocolException(e.getMessage(), e);
            }
        }
        return this.toFruizione(fruizioneTemplateParam, format, mapping, csv, charset);
    }

    public List<Fruizione> toFruizione(byte[] fruizioneTemplateParam, Properties formatParam, Properties mappingParam, byte[] csvParam) throws ProtocolException {
        return this.toFruizione(fruizioneTemplateParam, formatParam, mappingParam, csvParam, "UTF-8");
    }

    public List<Fruizione> toFruizione(byte[] fruizioneTemplateParam, Properties formatParam, Properties mappingParam, byte[] csvParam, String charset) throws ProtocolException {
        String csv = null;
        if (csvParam == null) {
            throw new ProtocolException("CSV non disponibile");
        }
        if (charset == null) {
            charset = "UTF-8";
        }
        try {
            csv = new String(csvParam, charset);
        }
        catch (Exception e) {
            throw new ProtocolException("CSV con formato errato [encoding:" + charset + "]: " + e.getMessage());
        }
        return this.toFruizione(fruizioneTemplateParam, formatParam, mappingParam, csv);
    }

    public List<Fruizione> toFruizione(byte[] fruizioneTemplateParam, byte[] formatParam, byte[] mappingParam, String csv) throws ProtocolException {
        Properties format = null;
        if (formatParam != null) {
            try {
                format = Utilities.getAsProperties((byte[])formatParam);
            }
            catch (UtilsException e) {
                throw new ProtocolException(e.getMessage(), e);
            }
        }
        Properties mapping = null;
        if (mappingParam != null) {
            try {
                mapping = Utilities.getAsProperties((byte[])mappingParam);
            }
            catch (UtilsException e) {
                throw new ProtocolException(e.getMessage(), e);
            }
        }
        return this.toFruizione(fruizioneTemplateParam, format, mapping, csv);
    }

    public List<Fruizione> toFruizione(byte[] fruizioneTemplateParam, Properties formatParam, Properties mappingParam, String csv) throws ProtocolException {
        try {
            Properties mapping;
            byte[] fruizioneTemplate = fruizioneTemplateParam;
            Template template = null;
            if (fruizioneTemplate == null) {
                fruizioneTemplate = this.readBytes("/templates/csv/Fruizione.ftl");
            }
            try {
                template = TemplateUtils.buildTemplate((String)"Fruizione", (byte[])fruizioneTemplate);
            }
            catch (Exception e) {
                throw new ProtocolException("Build Template error: " + e.getMessage());
            }
            Properties format = formatParam;
            if (format == null) {
                format = this.readProperties("/templates/csv/format.properties");
            }
            if ((mapping = mappingParam) == null) {
                mapping = this.readProperties("/templates/csv/fruizione.properties");
            }
            ArrayList<Fruizione> listFruizioni = new ArrayList<Fruizione>();
            FormatReader formatReader = new FormatReader(format);
            Format f = formatReader.getFormat();
            Parser p = new Parser(mapping, true);
            ParserResult pr = p.parseCsvFile(f, csv);
            for (Record record : pr.getRecords()) {
                HashMap<String, String> mapFreemarker = new HashMap<String, String>();
                if (record.getMap().size() <= 0) {
                    throw new ProtocolException("Csv Record at line [" + record.getCsvLine() + "] not correct, mapping produce 0 fields");
                }
                List keys = record.getMap().keys();
                for (String key : keys) {
                    String s = record.getMap().get(key);
                    if (s == null) continue;
                    mapFreemarker.put(key, s);
                }
                String protocollo = record.getMap().get(PROTOCOLLO);
                if (protocollo == null) {
                    protocollo = ManagerUtils.getDefaultProtocol();
                }
                mapFreemarker.put(DEFAULT_SUBJECT_TYPE, ManagerUtils.getDefaultOrganizationType(protocollo));
                byte[] xmlFruizione = null;
                try {
                    xmlFruizione = TemplateUtils.toByteArray((Template)template, mapFreemarker);
                }
                catch (Exception e) {
                    throw new ProtocolException("Csv Record at line [" + record.getCsvLine() + "] not correct (Build xml from template failed): " + e.getMessage());
                }
                ByteArrayInputStream bin = null;
                try {
                    if (this.validate) {
                        bin = new ByteArrayInputStream(xmlFruizione);
                        XSDValidator.getXSDValidator(this.log).valida((InputStream)bin);
                    }
                    Fruizione fruizione = this.jaxbAbstractionDeserializer.readFruizione(xmlFruizione);
                    listFruizioni.add(fruizione);
                }
                catch (Exception e) {
                    throw new ProtocolException("Csv Record at line [" + record.getCsvLine() + "] not correct. Marshall Xml [" + new String(xmlFruizione) + "]\n" + e.getMessage(), e);
                }
                finally {
                    try {
                        if (bin == null) continue;
                        bin.close();
                    }
                    catch (Exception exception) {}
                }
            }
            return listFruizioni;
        }
        catch (UtilsException e) {
            throw new ProtocolException(e.getMessage(), e);
        }
    }

    private byte[] readBytes(String resourceName) throws UtilsException {
        InputStream is = null;
        try {
            is = Deserializer.class.getResourceAsStream(resourceName);
            if (is == null) {
                throw new UtilsException("[" + resourceName + "] non disponibile");
            }
            byte[] byArray = Utilities.getAsByteArray((InputStream)is);
            return byArray;
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    private Properties readProperties(String resourceName) throws UtilsException {
        InputStream isProp = null;
        try {
            isProp = Deserializer.class.getResourceAsStream(resourceName);
            if (isProp == null) {
                throw new UtilsException("Format non disponibile");
            }
            Properties p = new Properties();
            p.load(isProp);
            Properties properties = p;
            return properties;
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                if (isProp != null) {
                    isProp.close();
                }
            }
            catch (Exception exception) {}
        }
    }
}

