/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.core.registry.wsdl;

import com.ibm.wsdl.TypesImpl;
import com.ibm.wsdl.xml.WSDLReaderImpl;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.wsdl.Binding;
import javax.wsdl.Definition;
import javax.wsdl.Import;
import javax.wsdl.Service;
import javax.wsdl.Types;
import org.apache.log4j.Logger;
import org.openspcoop2.core.id.IDAccordo;
import org.openspcoop2.core.registry.AccordoServizioParteComune;
import org.openspcoop2.core.registry.AccordoServizioParteSpecifica;
import org.openspcoop2.core.registry.Documento;
import org.openspcoop2.core.registry.driver.DriverRegistroServiziException;
import org.openspcoop2.core.registry.driver.IDAccordoFactory;
import org.openspcoop2.message.XMLUtils;
import org.openspcoop2.utils.id.IDUtilities;
import org.openspcoop2.utils.wsdl.DefinitionWrapper;
import org.openspcoop2.utils.wsdl.WSDLException;
import org.openspcoop2.utils.wsdl.WSDLUtilities;
import org.openspcoop2.utils.xml.AbstractXMLUtils;
import org.openspcoop2.utils.xml.PrettyPrintXMLUtils;
import org.openspcoop2.utils.xml.XSDUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class RegistroOpenSPCoopUtilities {
    private Logger logger = null;
    private XMLUtils xmlUtils = null;
    private XSDUtils xsdUtils = null;
    private WSDLUtilities wsdlUtilities = null;
    private IDAccordoFactory idAccordoFactory = IDAccordoFactory.getInstance();

    public RegistroOpenSPCoopUtilities(Logger log) {
        this.logger = log != null ? log : Logger.getLogger(RegistroOpenSPCoopUtilities.class);
        this.xmlUtils = XMLUtils.getInstance();
        this.xsdUtils = new XSDUtils((AbstractXMLUtils)this.xmlUtils);
        this.wsdlUtilities = WSDLUtilities.getInstance((AbstractXMLUtils)this.xmlUtils);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Definition buildWsdlFromObjects(AccordoServizioParteComune parteComune, byte[] implementativoByte, boolean implementativoErogatore) throws DriverRegistroServiziException {
        try {
            AccordoServizioParteComune parteComuneNormalizzata = (AccordoServizioParteComune)parteComune.clone();
            this.updateLocation(parteComuneNormalizzata, false, false);
            byte[] logicoByte = null;
            if (implementativoErogatore) {
                if (parteComuneNormalizzata.getByteWsdlLogicoErogatore() == null) throw new DriverRegistroServiziException("Byte del WSDL logico erogatore non presenti");
                logicoByte = parteComuneNormalizzata.getByteWsdlLogicoErogatore();
            } else {
                if (parteComuneNormalizzata.getByteWsdlLogicoFruitore() == null) throw new DriverRegistroServiziException("Byte del WSDL logico fruitore non presenti");
                logicoByte = parteComuneNormalizzata.getByteWsdlLogicoFruitore();
            }
            WSDLReaderImpl builderWSDL = new WSDLReaderImpl();
            Definition wsdl = null;
            if (logicoByte == null) {
                throw new Exception("Wsdl logico (byte[]) non definito");
            }
            this.logger.debug((Object)"Leggo WSDL logico");
            Document documentLogico = this.xmlUtils.newDocument(logicoByte);
            Element wsdlElement = documentLogico.getDocumentElement();
            String prefix = wsdlElement.getPrefix();
            TypesImpl types = new TypesImpl();
            ByteArrayOutputStream xsd = new ByteArrayOutputStream();
            HashMap<String, String> prefixForWSDL = new HashMap<String, String>();
            List importIntoWSDL = this.wsdlUtilities.readImportsSchemaIntoTypes(documentLogico);
            block8: for (int i = 0; i < importIntoWSDL.size(); ++i) {
                String file;
                Node n = (Node)importIntoWSDL.get(i);
                String namespaceImport = null;
                try {
                    namespaceImport = this.xsdUtils.getImportNamespace(n);
                }
                catch (Exception e) {
                    // empty catch block
                }
                String location = null;
                try {
                    location = this.xsdUtils.getImportSchemaLocation(n);
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (location == null) continue;
                if ("InterfacciaDefinitoria.xsd".equals(location)) {
                    if (parteComuneNormalizzata.getByteWsdlDefinitorio() == null) continue;
                    xsd.write("\n".getBytes());
                    this.risoluzioneImportIncludeInXSD(parteComuneNormalizzata, parteComuneNormalizzata.getByteWsdlDefinitorio(), xsd, wsdlElement, prefixForWSDL, true, namespaceImport, 1);
                    continue;
                }
                if (location.startsWith("allegati")) {
                    for (int j = 0; j < parteComuneNormalizzata.sizeAllegatoList(); ++j) {
                        Documento allegato = parteComuneNormalizzata.getAllegato(j);
                        file = "allegati" + File.separatorChar + allegato.getFile();
                        if (!location.equals(file)) continue;
                        xsd.write("\n".getBytes());
                        this.risoluzioneImportIncludeInXSD(parteComuneNormalizzata, parteComuneNormalizzata.getAllegato(j).getByteContenuto(), xsd, wsdlElement, prefixForWSDL, true, namespaceImport, 1);
                        continue block8;
                    }
                    continue;
                }
                if (!location.startsWith("specificaSemiformale")) continue;
                for (int j = 0; j < parteComuneNormalizzata.sizeSpecificaSemiformaleList(); ++j) {
                    Documento specificaSemiformale = parteComuneNormalizzata.getSpecificaSemiformale(j);
                    file = "specificaSemiformale" + File.separatorChar + specificaSemiformale.getFile();
                    if (!location.equals(file)) continue;
                    xsd.write("\n".getBytes());
                    this.risoluzioneImportIncludeInXSD(parteComuneNormalizzata, parteComuneNormalizzata.getSpecificaSemiformale(j).getByteContenuto(), xsd, wsdlElement, prefixForWSDL, true, namespaceImport, 1);
                    continue block8;
                }
            }
            List includeIntoWSDL = this.wsdlUtilities.readIncludesSchemaIntoTypes(documentLogico);
            block11: for (int i = 0; i < includeIntoWSDL.size(); ++i) {
                String file;
                Node n = (Node)includeIntoWSDL.get(i);
                Object o = n.getUserData("TargetNamespaceSchema");
                String targetNamespaceXSD = null;
                if (o != null) {
                    targetNamespaceXSD = (String)o;
                }
                String location = null;
                try {
                    location = this.xsdUtils.getIncludeSchemaLocation(n);
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (location == null) continue;
                if ("InterfacciaDefinitoria.xsd".equals(location)) {
                    if (parteComuneNormalizzata.getByteWsdlDefinitorio() == null) continue;
                    xsd.write("\n".getBytes());
                    this.risoluzioneImportIncludeInXSD(parteComuneNormalizzata, parteComuneNormalizzata.getByteWsdlDefinitorio(), xsd, wsdlElement, prefixForWSDL, true, targetNamespaceXSD, 1);
                    continue;
                }
                if (location.startsWith("allegati")) {
                    for (int j = 0; j < parteComuneNormalizzata.sizeAllegatoList(); ++j) {
                        Documento allegato = parteComuneNormalizzata.getAllegato(j);
                        file = "allegati" + File.separatorChar + allegato.getFile();
                        if (!location.equals(file)) continue;
                        xsd.write("\n".getBytes());
                        this.risoluzioneImportIncludeInXSD(parteComuneNormalizzata, parteComuneNormalizzata.getAllegato(j).getByteContenuto(), xsd, wsdlElement, prefixForWSDL, true, targetNamespaceXSD, 1);
                        continue block11;
                    }
                    continue;
                }
                if (!location.startsWith("specificaSemiformale")) continue;
                for (int j = 0; j < parteComuneNormalizzata.sizeSpecificaSemiformaleList(); ++j) {
                    Documento specificaSemiformale = parteComuneNormalizzata.getSpecificaSemiformale(j);
                    file = "specificaSemiformale" + File.separatorChar + specificaSemiformale.getFile();
                    if (!location.equals(file)) continue;
                    xsd.write("\n".getBytes());
                    this.risoluzioneImportIncludeInXSD(parteComuneNormalizzata, parteComuneNormalizzata.getSpecificaSemiformale(j).getByteContenuto(), xsd, wsdlElement, prefixForWSDL, true, targetNamespaceXSD, 1);
                    continue block11;
                }
            }
            this.wsdlUtilities.removeTypes(documentLogico);
            this.logger.debug((Object)"Costruisco WSDL Logico");
            wsdl = builderWSDL.readWSDL(null, documentLogico);
            wsdl.setTypes((Types)types);
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            this.wsdlUtilities.writeWsdlTo(wsdl, (OutputStream)bout);
            bout.flush();
            bout.close();
            String typesLine = null;
            typesLine = prefix != null ? "<" + prefix + ":types>" : "<types>";
            String wsdlTrasformato = bout.toString().replace(typesLine, typesLine + "\n" + xsd.toString());
            if (wsdlTrasformato.trim().startsWith("<?xml")) {
                wsdlTrasformato = wsdlTrasformato.substring(wsdlTrasformato.indexOf(">") + 1);
            }
            for (String key : prefixForWSDL.keySet()) {
                wsdlTrasformato = wsdlTrasformato.replaceFirst(">", " " + key + "=\"" + prefixForWSDL.get(key) + "\">");
            }
            documentLogico = this.xmlUtils.newDocument(wsdlTrasformato.getBytes());
            this.logger.debug((Object)"Costruisco WSDL Logico per la seconda volta, stavolta con i types corretti");
            wsdl = builderWSDL.readWSDL(null, documentLogico);
            if (implementativoByte == null) return wsdl;
            this.logger.debug((Object)"Leggo WSDL implementativo");
            Document documentImplementativo = this.xmlUtils.newDocument(implementativoByte);
            this.logger.debug((Object)"Rimuovo import da WSDL Loimplementativogico");
            this.wsdlUtilities.removeImports(documentImplementativo);
            this.wsdlUtilities.removeTypes(documentImplementativo);
            this.logger.debug((Object)"Costruisco WSDL Implementativo");
            Definition wsdlImplementativo = builderWSDL.readWSDL(null, documentImplementativo);
            this.addParteImplementativa(wsdl, wsdlImplementativo);
            return wsdl;
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("Riscontrato errore durante la costruzione del wsdl dai bytes: " + e.getMessage(), e);
        }
    }

    public void updateLocation(AccordoServizioParteComune accordoServizioOpenspcoop, boolean strutturaPackageCNIPA, boolean prettyDocument) throws DriverRegistroServiziException {
        try {
            String targetNamespace;
            String file;
            File fLocalName;
            Documento doc;
            int i;
            byte[] wsdlDefinitorio = accordoServizioOpenspcoop.getByteWsdlDefinitorio();
            byte[] wsdlConcettuale = accordoServizioOpenspcoop.getByteWsdlConcettuale();
            byte[] wsdlLogicoErogatore = accordoServizioOpenspcoop.getByteWsdlLogicoErogatore();
            byte[] wsdlLogicoFruitore = accordoServizioOpenspcoop.getByteWsdlLogicoFruitore();
            HashMap<String, String> targetNamespacesXSD = new HashMap<String, String>();
            HashMap<String, String> includePath = new HashMap<String, String>();
            if (wsdlDefinitorio != null) {
                String file2 = "InterfacciaDefinitoria.xsd";
                if (strutturaPackageCNIPA) {
                    file2 = ".." + File.separatorChar + "allegati" + File.separatorChar + file2;
                }
                String targetNamespace2 = null;
                try {
                    targetNamespace2 = this.xsdUtils.getTargetNamespace(wsdlDefinitorio);
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (targetNamespace2 != null) {
                    targetNamespacesXSD.put(targetNamespace2, file2);
                } else {
                    this.logger.debug((Object)"Target namespace non trovato per il wsdl definitorio [InterfacciaDefinitoria.xsd]");
                }
                includePath.put("InterfacciaDefinitoria.xsd", file2);
                includePath.put("allegati" + File.separatorChar + "InterfacciaDefinitoria.xsd", file2);
            } else {
                this.logger.debug((Object)"Bytes non presenti per il wsdl definitorio [InterfacciaDefinitoria.xsd]");
            }
            for (i = 0; i < accordoServizioOpenspcoop.sizeAllegatoList(); ++i) {
                doc = accordoServizioOpenspcoop.getAllegato(i);
                fLocalName = new File(doc.getFile());
                file = "allegati" + File.separatorChar + fLocalName.getName();
                if (strutturaPackageCNIPA) {
                    file = ".." + File.separatorChar + file;
                }
                if (doc.getByteContenuto() != null) {
                    targetNamespace = null;
                    try {
                        targetNamespace = this.xsdUtils.getTargetNamespace(doc.getByteContenuto());
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    if (targetNamespace == null) {
                        try {
                            targetNamespace = this.wsdlUtilities.getTargetNamespace(doc.getByteContenuto());
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                    if (targetNamespace != null) {
                        targetNamespacesXSD.put(targetNamespace, file);
                    } else {
                        this.logger.debug((Object)("Target namespace non trovato per l'allegato [" + doc.getFile() + "] (tipo:" + doc.getTipo() + ")"));
                    }
                } else {
                    this.logger.debug((Object)("Bytes non presenti per l'allegato [" + doc.getFile() + "] (tipo:" + doc.getTipo() + ")"));
                }
                includePath.put(fLocalName.getName(), file);
                includePath.put("allegati" + File.separatorChar + fLocalName.getName(), file);
            }
            for (i = 0; i < accordoServizioOpenspcoop.sizeSpecificaSemiformaleList(); ++i) {
                doc = accordoServizioOpenspcoop.getSpecificaSemiformale(i);
                fLocalName = new File(doc.getFile());
                file = "specificaSemiformale" + File.separatorChar + fLocalName.getName();
                if (strutturaPackageCNIPA) {
                    file = ".." + File.separatorChar + file;
                }
                if (doc.getByteContenuto() != null) {
                    targetNamespace = null;
                    try {
                        targetNamespace = this.xsdUtils.getTargetNamespace(doc.getByteContenuto());
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    if (targetNamespace == null) {
                        try {
                            targetNamespace = this.wsdlUtilities.getTargetNamespace(doc.getByteContenuto());
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                    if (targetNamespace != null) {
                        targetNamespacesXSD.put(targetNamespace, file);
                    } else {
                        this.logger.debug((Object)("Target namespace non trovato per la specifica semiformale [" + doc.getFile() + "] (tipo:" + doc.getTipo() + ")"));
                    }
                } else {
                    this.logger.debug((Object)("Bytes non presenti per la specifica semiformale [" + doc.getFile() + "] (tipo:" + doc.getTipo() + ")"));
                }
                includePath.put(fLocalName.getName(), file);
                includePath.put("specificaSemiformale" + File.separatorChar + fLocalName.getName(), file);
            }
            if (wsdlConcettuale != null) {
                this.logger.debug((Object)"Update Wsdl Concettuale...");
                wsdlConcettuale = this.updateImportsAndIncludesWSDLLocation("WSDLConcettuale", wsdlConcettuale, targetNamespacesXSD, includePath, prettyDocument, true);
                accordoServizioOpenspcoop.setByteWsdlConcettuale(wsdlConcettuale);
                this.logger.debug((Object)"Update Wsdl Concettuale ok");
            }
            if (wsdlLogicoErogatore != null) {
                this.logger.debug((Object)"Update Wsdl Logico Erogatore...");
                wsdlLogicoErogatore = this.updateImportsAndIncludesWSDLLocation("WSDLLogicoErogatore", wsdlLogicoErogatore, targetNamespacesXSD, includePath, prettyDocument, true);
                accordoServizioOpenspcoop.setByteWsdlLogicoErogatore(wsdlLogicoErogatore);
                this.logger.debug((Object)"Update Wsdl Logico Erogatore ok");
            }
            if (wsdlLogicoFruitore != null) {
                this.logger.debug((Object)"Update Wsdl Logico Fruitore...");
                wsdlLogicoFruitore = this.updateImportsAndIncludesWSDLLocation("WSDLLogicoFruitore", wsdlLogicoFruitore, targetNamespacesXSD, includePath, prettyDocument, true);
                accordoServizioOpenspcoop.setByteWsdlLogicoFruitore(wsdlLogicoFruitore);
                this.logger.debug((Object)"Update Wsdl Logico Fruitore ok");
            }
            if (wsdlDefinitorio != null) {
                this.logger.debug((Object)"Update Wsdl Definitorio (import)...");
                wsdlDefinitorio = this.updateImportXSDLocation(wsdlDefinitorio, targetNamespacesXSD, prettyDocument);
                this.logger.debug((Object)"Update Wsdl Definitorio (include)...");
                wsdlDefinitorio = this.updateIncludeXSDLocation(wsdlDefinitorio, includePath, prettyDocument);
                this.logger.debug((Object)"Update Wsdl Definitorio ok");
                accordoServizioOpenspcoop.setByteWsdlDefinitorio(wsdlDefinitorio);
            }
            for (i = 0; i < accordoServizioOpenspcoop.sizeAllegatoList(); ++i) {
                doc = accordoServizioOpenspcoop.getAllegato(i);
                if (doc.getByteContenuto() == null) continue;
                this.logger.debug((Object)("Update Allegato di tipo [" + doc.getTipo() + "] [" + doc.getFile() + "] (import)..."));
                byte[] allegato = this.updateImportXSDLocation(doc.getByteContenuto(), targetNamespacesXSD, prettyDocument);
                if (allegato != null) {
                    this.logger.debug((Object)("Update Allegato di tipo [" + doc.getTipo() + "] [" + doc.getFile() + "] (include)..."));
                    allegato = this.updateIncludeXSDLocation(allegato, includePath, prettyDocument);
                    if (allegato != null) {
                        doc.setByteContenuto(allegato);
                        this.logger.debug((Object)("Update Allegato di tipo [" + doc.getTipo() + "] [" + doc.getFile() + "] ok"));
                        continue;
                    }
                    this.logger.debug((Object)("Update (include) Allegato di tipo [" + doc.getTipo() + "] [" + doc.getFile() + "] non effettuato, il documento non e' uno schema XSD"));
                    continue;
                }
                this.logger.debug((Object)("Update (import) Allegato di tipo [" + doc.getTipo() + "] [" + doc.getFile() + "] non effettuato, il documento non e' uno schema XSD"));
            }
            for (i = 0; i < accordoServizioOpenspcoop.sizeSpecificaSemiformaleList(); ++i) {
                doc = accordoServizioOpenspcoop.getSpecificaSemiformale(i);
                if (doc.getByteContenuto() == null) continue;
                this.logger.debug((Object)("Update SpecificaSemiformale di tipo [" + doc.getTipo() + "] [" + doc.getFile() + "] (import)..."));
                byte[] specificaSemiformale = this.updateImportXSDLocation(doc.getByteContenuto(), targetNamespacesXSD, prettyDocument);
                if (specificaSemiformale != null) {
                    this.logger.debug((Object)("Update SpecificaSemiformale di tipo [" + doc.getTipo() + "] [" + doc.getFile() + "] (include)..."));
                    specificaSemiformale = this.updateIncludeXSDLocation(specificaSemiformale, includePath, prettyDocument);
                    if (specificaSemiformale != null) {
                        doc.setByteContenuto(specificaSemiformale);
                        this.logger.debug((Object)("Update SpecificaSemiformale di tipo [" + doc.getTipo() + "] [" + doc.getFile() + "] ok"));
                        continue;
                    }
                    this.logger.debug((Object)("Update (include) SpecificaSemiformale di tipo [" + doc.getTipo() + "] [" + doc.getFile() + "] non effettuato, il documento non e' uno schema XSD"));
                    continue;
                }
                this.logger.debug((Object)("Update (import)SpecificaSemiformale di tipo [" + doc.getTipo() + "] [" + doc.getFile() + "] non effettuato, il documento non e' uno schema XSD"));
            }
        }
        catch (Exception e) {
            this.logger.error((Object)("Correzione import non riuscita: " + e.getMessage()), (Throwable)e);
            throw new DriverRegistroServiziException("Riscontrato errore durante la lettura del wsdl: " + e.getMessage(), e);
        }
    }

    public void updateLocation(AccordoServizioParteSpecifica servizioOpenspcoop, boolean strutturaPackageCNIPA, boolean prettyDocument) throws DriverRegistroServiziException {
        try {
            String file;
            String targetNamespace;
            byte[] wsdlImplementativoErogatore = servizioOpenspcoop.getByteWsdlImplementativoErogatore();
            byte[] wsdlImplementativoFruitore = servizioOpenspcoop.getByteWsdlImplementativoFruitore();
            HashMap<String, String> targetNamespacesXSD = new HashMap<String, String>();
            IDAccordo idAccordoParteComune = this.idAccordoFactory.getIDAccordoFromUri(servizioOpenspcoop.getAccordoServizioParteComune());
            if (wsdlImplementativoErogatore != null) {
                targetNamespace = this.wsdlUtilities.getTargetNamespace(wsdlImplementativoErogatore);
                if (targetNamespace != null) {
                    file = "InterfacciaLogicaErogatore.wsdl";
                    if (strutturaPackageCNIPA) {
                        file = ".." + File.separatorChar + ".." + File.separatorChar + idAccordoParteComune.getNome() + File.separatorChar + "specificaInterfaccia" + File.separatorChar + file;
                    }
                    targetNamespacesXSD.put(targetNamespace, file);
                } else {
                    this.logger.debug((Object)"Target namespace non trovato per il wsdl implementativo erogatore [InterfacciaLogicaErogatore.wsdl]");
                }
                this.logger.debug((Object)"Update Wsdl Implementativo Erogatore...");
                wsdlImplementativoErogatore = this.updateImportsAndIncludesWSDLLocation("WSDLImplementativoErogatore", wsdlImplementativoErogatore, targetNamespacesXSD, null, prettyDocument, false);
                servizioOpenspcoop.setByteWsdlImplementativoErogatore(wsdlImplementativoErogatore);
                this.logger.debug((Object)"Update Wsdl Implementativo Erogatore ok");
            }
            if (wsdlImplementativoFruitore != null) {
                targetNamespace = this.wsdlUtilities.getTargetNamespace(wsdlImplementativoFruitore);
                if (targetNamespace != null) {
                    file = "InterfacciaLogicaFruitore.wsdl";
                    if (strutturaPackageCNIPA) {
                        file = ".." + File.separatorChar + ".." + File.separatorChar + idAccordoParteComune.getNome() + File.separatorChar + "specificaInterfaccia" + File.separatorChar + file;
                    }
                    targetNamespacesXSD.put(targetNamespace, file);
                } else {
                    this.logger.debug((Object)"Target namespace non trovato per il wsdl implementativo fruitore [InterfacciaLogicaFruitore.wsdl]");
                }
                this.logger.debug((Object)"Update Wsdl Implementativo Fruitore...");
                wsdlImplementativoFruitore = this.updateImportsAndIncludesWSDLLocation("WSDLImplementativoFruitore", wsdlImplementativoFruitore, targetNamespacesXSD, null, prettyDocument, false);
                servizioOpenspcoop.setByteWsdlImplementativoFruitore(wsdlImplementativoFruitore);
                this.logger.debug((Object)"Update Wsdl Implementativo Fruitore ok");
            }
        }
        catch (Exception e) {
            this.logger.error((Object)("Correzione import non riuscita: " + e.getMessage()), (Throwable)e);
            throw new DriverRegistroServiziException("Riscontrato errore durante la lettura del wsdl: " + e.getMessage(), e);
        }
    }

    public byte[] eliminaASParteComune(byte[] wsdlBytes, boolean implementativoErogatore) throws DriverRegistroServiziException {
        try {
            Document d = this.xmlUtils.newDocument(wsdlBytes);
            this.wsdlUtilities.removeTypes(d);
            this.wsdlUtilities.removeImports(d);
            DefinitionWrapper wsdl = new DefinitionWrapper(d, (AbstractXMLUtils)this.xmlUtils);
            wsdl.createTypes();
            Import importLogico = wsdl.createImport();
            if (implementativoErogatore) {
                importLogico.setLocationURI("InterfacciaLogicaErogatore.wsdl");
            } else {
                importLogico.setLocationURI("InterfacciaLogicaFruitore.wsdl");
            }
            importLogico.setNamespaceURI(this.wsdlUtilities.getTargetNamespace(wsdlBytes));
            wsdl.addImport(importLogico);
            wsdl.removeAllMessages();
            wsdl.removeAllPortTypes();
            byte[] wsdlSenzaParteComune = wsdl.toByteArray();
            return wsdlSenzaParteComune;
        }
        catch (Exception e) {
            this.logger.error((Object)("Eliminazione  ASParteComune non riuscita: " + e.getMessage()), (Throwable)e);
            throw new DriverRegistroServiziException("Riscontrato errore durante l'eliminazione dell'ASParteComune del wsdl: " + e.getMessage(), e);
        }
    }

    public byte[] aggiungiImportASParteComune(byte[] wsdlBytes, boolean implementativoErogatore) throws DriverRegistroServiziException {
        try {
            Document d = this.xmlUtils.newDocument(wsdlBytes);
            this.wsdlUtilities.removeTypes(d);
            this.wsdlUtilities.removeImports(d);
            DefinitionWrapper wsdl = new DefinitionWrapper(d, (AbstractXMLUtils)this.xmlUtils);
            wsdl.createTypes();
            Import importLogico = wsdl.createImport();
            if (implementativoErogatore) {
                importLogico.setLocationURI("InterfacciaLogicaErogatore.wsdl");
            } else {
                importLogico.setLocationURI("InterfacciaLogicaFruitore.wsdl");
            }
            importLogico.setNamespaceURI(this.wsdlUtilities.getTargetNamespace(wsdlBytes));
            wsdl.addImport(importLogico);
            return wsdl.toByteArray();
        }
        catch (Exception e) {
            this.logger.error((Object)("aggiungiImportASParteComune non riuscito: " + e.getMessage()), (Throwable)e);
            throw new DriverRegistroServiziException("Riscontrato errore durante l'eliminazione dell'ASParteComune del wsdl: " + e.getMessage(), e);
        }
    }

    public byte[] eliminaImportASParteComune(byte[] wsdlBytes) throws DriverRegistroServiziException {
        try {
            Document d = this.xmlUtils.newDocument(wsdlBytes);
            this.wsdlUtilities.removeTypes(d);
            this.wsdlUtilities.removeImports(d);
            DefinitionWrapper wsdl = new DefinitionWrapper(d, (AbstractXMLUtils)this.xmlUtils);
            return wsdl.toByteArray();
        }
        catch (Exception e) {
            this.logger.error((Object)("Eliminazione  ASParteComune non riuscita: " + e.getMessage()), (Throwable)e);
            throw new DriverRegistroServiziException("Riscontrato errore durante l'eliminazione dell'ASParteComune del wsdl: " + e.getMessage(), e);
        }
    }

    public void addParteImplementativa(Definition wsdlOriginale, Definition wsdlImplementativo) {
        this.logger.debug((Object)"Aggiungo wsdl-binding...");
        Map bindings = wsdlImplementativo.getAllBindings();
        if (bindings != null && bindings.size() > 0) {
            this.logger.debug((Object)("Aggiungo wsdl-binding [" + bindings.size() + "] a wsdl ritornato"));
            for (Binding bindingWSDL : bindings.values()) {
                wsdlOriginale.addBinding(bindingWSDL);
            }
        }
        this.logger.debug((Object)"Aggiungo wsdl-service...");
        Map services = wsdlImplementativo.getAllServices();
        if (services != null && services.size() > 0) {
            this.logger.debug((Object)("Aggiungo wsdl-service [" + services.size() + "] a wsdl ritornato"));
            for (Service serviceWSDL : services.values()) {
                wsdlOriginale.addService(serviceWSDL);
            }
        }
    }

    private void risoluzioneImportIncludeInXSD(AccordoServizioParteComune parteComuneNormalizzata, byte[] documentXSD, ByteArrayOutputStream xsd, Element wsdlElement, HashMap<String, String> prefixForWSDL, boolean docImportato, String targetNamespaceParent, int profondita) throws DriverRegistroServiziException {
        try {
            Document doc = this.xmlUtils.newDocument(documentXSD);
            Element docElement = doc.getDocumentElement();
            String targetNamespace = null;
            String uniquePrefix = "_p" + profondita + "_n" + IDUtilities.getUniqueSerialNumber() + "_";
            targetNamespace = this.wsdlUtilities.normalizzazioneSchemaPerInserimentoInWsdl(docElement, wsdlElement, prefixForWSDL, uniquePrefix, docImportato, targetNamespaceParent);
            List importIntoXSD = this.xsdUtils.readImports(doc);
            block6: for (int i = 0; i < importIntoXSD.size(); ++i) {
                String file;
                Node n = (Node)importIntoXSD.get(i);
                String location = null;
                try {
                    location = this.xsdUtils.getImportSchemaLocation(n);
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (location.startsWith("allegati")) {
                    for (int j = 0; j < parteComuneNormalizzata.sizeAllegatoList(); ++j) {
                        Documento allegato = parteComuneNormalizzata.getAllegato(j);
                        file = "allegati" + File.separatorChar + allegato.getFile();
                        if (!location.equals(file)) continue;
                        xsd.write("\n".getBytes());
                        this.risoluzioneImportIncludeInXSD(parteComuneNormalizzata, parteComuneNormalizzata.getAllegato(j).getByteContenuto(), xsd, wsdlElement, prefixForWSDL, true, targetNamespace, profondita + 1);
                        continue block6;
                    }
                    continue;
                }
                if (!location.startsWith("specificaSemiformale")) continue;
                for (int j = 0; j < parteComuneNormalizzata.sizeSpecificaSemiformaleList(); ++j) {
                    Documento specificaSemiformale = parteComuneNormalizzata.getSpecificaSemiformale(j);
                    file = "specificaSemiformale" + File.separatorChar + specificaSemiformale.getFile();
                    if (!location.equals(file)) continue;
                    xsd.write("\n".getBytes());
                    this.risoluzioneImportIncludeInXSD(parteComuneNormalizzata, parteComuneNormalizzata.getSpecificaSemiformale(j).getByteContenuto(), xsd, wsdlElement, prefixForWSDL, true, targetNamespace, profondita + 1);
                    continue block6;
                }
            }
            List includeIntoXSD = this.xsdUtils.readIncludes(doc);
            block9: for (int i = 0; i < includeIntoXSD.size(); ++i) {
                String file;
                Node n = (Node)includeIntoXSD.get(i);
                String location = null;
                try {
                    location = this.xsdUtils.getIncludeSchemaLocation(n);
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (location.startsWith("allegati")) {
                    for (int j = 0; j < parteComuneNormalizzata.sizeAllegatoList(); ++j) {
                        Documento allegato = parteComuneNormalizzata.getAllegato(j);
                        file = "allegati" + File.separatorChar + allegato.getFile();
                        if (!location.equals(file)) continue;
                        xsd.write("\n".getBytes());
                        this.risoluzioneImportIncludeInXSD(parteComuneNormalizzata, parteComuneNormalizzata.getAllegato(j).getByteContenuto(), xsd, wsdlElement, prefixForWSDL, false, targetNamespace, profondita + 1);
                        continue block9;
                    }
                    continue;
                }
                if (!location.startsWith("specificaSemiformale")) continue;
                for (int j = 0; j < parteComuneNormalizzata.sizeSpecificaSemiformaleList(); ++j) {
                    Documento specificaSemiformale = parteComuneNormalizzata.getSpecificaSemiformale(j);
                    file = "specificaSemiformale" + File.separatorChar + specificaSemiformale.getFile();
                    if (!location.equals(file)) continue;
                    xsd.write("\n".getBytes());
                    this.risoluzioneImportIncludeInXSD(parteComuneNormalizzata, parteComuneNormalizzata.getSpecificaSemiformale(j).getByteContenuto(), xsd, wsdlElement, prefixForWSDL, false, targetNamespace, profondita + 1);
                    continue block9;
                }
            }
            this.xsdUtils.removeImportsAndIncludes(doc);
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            this.xmlUtils.writeTo(doc, (OutputStream)bout, true);
            bout.flush();
            bout.close();
            xsd.write(bout.toByteArray());
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("Riscontrato errore durante la costruzione del xsd dai bytes: " + e.getMessage(), e);
        }
    }

    private byte[] updateImportsAndIncludesWSDLLocation(String file, byte[] wsdl, HashMap<String, String> targetNamespacesXSD, HashMap<String, String> includePath, boolean prettyDocument, boolean traduciImportIntoTypesImport) throws WSDLException {
        try {
            String location;
            if (!this.xmlUtils.isDocument(wsdl)) {
                throw new WSDLException("WSDL[" + file + "] non e' un documento valido");
            }
            Document doc = this.xmlUtils.newDocument(wsdl);
            List importsIntoTypesIntoWSDL = this.wsdlUtilities.readImportsSchemaIntoTypes(doc);
            for (int i = 0; i < importsIntoTypesIntoWSDL.size(); ++i) {
                Node n = (Node)importsIntoTypesIntoWSDL.get(i);
                String namespaceImport = null;
                try {
                    namespaceImport = this.xsdUtils.getImportNamespace(n);
                }
                catch (Exception e) {
                    // empty catch block
                }
                location = null;
                try {
                    location = this.xsdUtils.getImportSchemaLocation(n);
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (namespaceImport != null) {
                    String path = targetNamespacesXSD.get(namespaceImport);
                    if (path == null) {
                        this.logger.debug((Object)("Schema non trovato per il namespace " + namespaceImport));
                        continue;
                    }
                    Node old = n.getAttributes().removeNamedItem("schemaLocation");
                    old.setNodeValue(path);
                    n.getAttributes().setNamedItem(old);
                    this.logger.debug((Object)("Reimpostata location: " + path));
                    continue;
                }
                this.logger.debug((Object)("Import presente nel WSDL[" + file + "] [" + location + "] non possiede il target namespace"));
            }
            if (includePath != null) {
                List includesIntoTypesIntoWSDL = this.wsdlUtilities.readIncludesSchemaIntoTypes(doc);
                for (int i = 0; i < includesIntoTypesIntoWSDL.size(); ++i) {
                    Node n = (Node)includesIntoTypesIntoWSDL.get(i);
                    location = null;
                    try {
                        location = this.xsdUtils.getIncludeSchemaLocation(n);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    if (location != null) {
                        String key;
                        File locationF = new File(location);
                        String path = null;
                        if (locationF.getParentFile() != null) {
                            key = locationF.getParentFile().getName() + File.separatorChar + locationF.getName();
                            path = includePath.get(key);
                        }
                        if (path == null) {
                            key = locationF.getName();
                            path = includePath.get(key);
                        }
                        if (path == null) {
                            this.logger.debug((Object)("Schema non trovato per la location " + location));
                            continue;
                        }
                        Node old = n.getAttributes().removeNamedItem("schemaLocation");
                        old.setNodeValue(path);
                        n.getAttributes().setNamedItem(old);
                        this.logger.debug((Object)("Reimpostata location: " + path));
                        continue;
                    }
                    this.logger.debug((Object)("Include presente nel XSD [" + location + "] non possiede la location?"));
                }
            }
            List importsIntoWSDL = this.wsdlUtilities.readImports(doc);
            Vector<Element> newSchemi = new Vector<Element>();
            for (int i = 0; i < importsIntoWSDL.size(); ++i) {
                Node n = (Node)importsIntoWSDL.get(i);
                String namespaceImport = null;
                try {
                    namespaceImport = this.wsdlUtilities.getImportNamespace(n);
                }
                catch (Exception e) {
                    // empty catch block
                }
                String location2 = null;
                try {
                    location2 = this.wsdlUtilities.getImportLocation(n);
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (namespaceImport != null) {
                    String path = targetNamespacesXSD.get(namespaceImport);
                    if (path == null) {
                        this.logger.debug((Object)("Schema non trovato per il namespace " + namespaceImport));
                        continue;
                    }
                    if (traduciImportIntoTypesImport) {
                        Element schemaElement = doc.createElementNS("http://www.w3.org/2001/XMLSchema", "schema");
                        schemaElement.setPrefix("xsd");
                        schemaElement.setAttribute("targetNamespace", this.wsdlUtilities.getTargetNamespace(wsdl));
                        Element importElement = doc.createElementNS("http://www.w3.org/2001/XMLSchema", "import");
                        importElement.setPrefix("xsd");
                        importElement.setAttribute("schemaLocation", path);
                        importElement.setAttribute("namespace", namespaceImport);
                        schemaElement.appendChild(importElement);
                        newSchemi.add(schemaElement);
                        continue;
                    }
                    Node old = n.getAttributes().removeNamedItem("location");
                    old.setNodeValue(path);
                    n.getAttributes().setNamedItem(old);
                    this.logger.debug((Object)("Reimpostata location: " + path));
                    continue;
                }
                this.logger.debug((Object)("Import presente nel WSDL[" + file + "] [" + location2 + "] non possiede il target namespace"));
            }
            if (traduciImportIntoTypesImport) {
                this.wsdlUtilities.removeImports(doc);
            }
            if (newSchemi.size() > 0) {
                Node types = this.wsdlUtilities.getIfExistsTypesElementIntoWSDL(doc);
                if (types == null) {
                    Node definition = this.wsdlUtilities.getIfExistsDefinitionsElementIntoWSDL(doc);
                    if (definition == null) {
                        this.logger.debug((Object)"Definition non esistente");
                    } else {
                        types = doc.createElementNS(definition.getNamespaceURI(), "types");
                        types.setPrefix(definition.getPrefix());
                        for (int i = 0; i < newSchemi.size(); ++i) {
                            types.appendChild((Node)newSchemi.get(i));
                        }
                        definition.appendChild(types);
                    }
                } else {
                    for (int i = 0; i < newSchemi.size(); ++i) {
                        types.appendChild((Node)newSchemi.get(i));
                    }
                }
            }
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            if (prettyDocument) {
                PrettyPrintXMLUtils.prettyPrintWithTrAX((Document)doc, (OutputStream)bout);
            } else {
                this.xmlUtils.writeTo(doc, (OutputStream)bout);
            }
            bout.flush();
            bout.close();
            return bout.toByteArray();
        }
        catch (Exception e) {
            throw new WSDLException(e.getMessage(), (Throwable)e);
        }
    }

    private byte[] updateImportXSDLocation(byte[] xsd, HashMap<String, String> targetNamespacesXSD, boolean prettyDocument) throws WSDLException {
        try {
            if (!this.xmlUtils.isDocument(xsd)) {
                return null;
            }
            Document doc = this.xmlUtils.newDocument(xsd);
            List importsIntoXSD = this.xsdUtils.readImports(doc);
            for (int i = 0; i < importsIntoXSD.size(); ++i) {
                Node n = (Node)importsIntoXSD.get(i);
                String namespaceImport = null;
                try {
                    namespaceImport = this.xsdUtils.getImportNamespace(n);
                }
                catch (Exception e) {
                    // empty catch block
                }
                String location = null;
                try {
                    location = this.xsdUtils.getImportSchemaLocation(n);
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (namespaceImport != null && location != null) {
                    String path = targetNamespacesXSD.get(namespaceImport);
                    if (path == null) {
                        this.logger.debug((Object)("Schema non trovato per il namespace " + namespaceImport));
                        continue;
                    }
                    Node old = n.getAttributes().removeNamedItem("schemaLocation");
                    old.setNodeValue(path);
                    n.getAttributes().setNamedItem(old);
                    this.logger.debug((Object)("Reimpostata location: " + path));
                    continue;
                }
                this.logger.debug((Object)("Import presente nel XSD [" + location + "] non possiede il target namespace"));
            }
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            if (prettyDocument) {
                PrettyPrintXMLUtils.prettyPrintWithTrAX((Document)doc, (OutputStream)bout);
            } else {
                this.xmlUtils.writeTo(doc, (OutputStream)bout);
            }
            bout.flush();
            bout.close();
            return bout.toByteArray();
        }
        catch (Exception e) {
            throw new WSDLException(e.getMessage(), (Throwable)e);
        }
    }

    private byte[] updateIncludeXSDLocation(byte[] xsd, HashMap<String, String> includePath, boolean prettyDocument) throws WSDLException {
        try {
            if (!this.xmlUtils.isDocument(xsd)) {
                return null;
            }
            Document doc = this.xmlUtils.newDocument(xsd);
            List includeIntoXSD = this.xsdUtils.readIncludes(doc);
            for (int i = 0; i < includeIntoXSD.size(); ++i) {
                Node n = (Node)includeIntoXSD.get(i);
                String location = null;
                try {
                    location = this.xsdUtils.getIncludeSchemaLocation(n);
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (location != null) {
                    String key;
                    File locationF = new File(location);
                    String path = null;
                    if (locationF.getParentFile() != null) {
                        key = locationF.getParentFile().getName() + File.separatorChar + locationF.getName();
                        path = includePath.get(key);
                    }
                    if (path == null) {
                        key = locationF.getName();
                        path = includePath.get(key);
                    }
                    if (path == null) {
                        this.logger.debug((Object)("Schema non trovato per la location " + location));
                        continue;
                    }
                    Node old = n.getAttributes().removeNamedItem("schemaLocation");
                    old.setNodeValue(path);
                    n.getAttributes().setNamedItem(old);
                    this.logger.debug((Object)("Reimpostata location: " + path));
                    continue;
                }
                this.logger.debug((Object)("Include presente nel XSD [" + location + "] non possiede la location?"));
            }
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            if (prettyDocument) {
                PrettyPrintXMLUtils.prettyPrintWithTrAX((Document)doc, (OutputStream)bout);
            } else {
                this.xmlUtils.writeTo(doc, (OutputStream)bout);
            }
            bout.flush();
            bout.close();
            return bout.toByteArray();
        }
        catch (Exception e) {
            throw new WSDLException(e.getMessage(), (Throwable)e);
        }
    }
}

