/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.core.registry.driver;

import org.openspcoop2.core.id.IDServizio;
import org.openspcoop2.core.registry.AccordoServizioParteSpecifica;
import org.openspcoop2.core.registry.Servizio;
import org.openspcoop2.core.registry.driver.DriverRegistroServiziException;
import org.openspcoop2.core.registry.driver.IDAccordoFactory;

public class IDServizioFactory {
    private static IDAccordoFactory factory = null;

    private static synchronized void init() {
        if (factory == null) {
            factory = new IDAccordoFactory();
        }
    }

    public static IDAccordoFactory getInstance() {
        if (factory == null) {
            IDServizioFactory.init();
        }
        return factory;
    }

    public IDServizio getIDAccordoFromServizio(AccordoServizioParteSpecifica accordo) throws DriverRegistroServiziException {
        if (accordo == null) {
            throw new DriverRegistroServiziException("AccordoServizioParteSpecifica non fornito");
        }
        Servizio servizio = accordo.getServizio();
        if (servizio == null) {
            throw new DriverRegistroServiziException("Servizio non fornito");
        }
        IDServizio idServizio = new IDServizio(servizio.getTipoSoggettoErogatore(), servizio.getNomeSoggettoErogatore(), servizio.getTipo(), servizio.getNome());
        return idServizio;
    }
}

