/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.core.registry.driver;

import java.util.Vector;
import org.openspcoop2.core.id.IDAccordo;
import org.openspcoop2.core.id.IDAccordoCooperazione;
import org.openspcoop2.core.registry.AccordoCooperazione;
import org.openspcoop2.core.registry.AccordoServizioParteComune;
import org.openspcoop2.core.registry.AccordoServizioParteSpecifica;
import org.openspcoop2.core.registry.Documento;
import org.openspcoop2.core.registry.Fruitore;
import org.openspcoop2.core.registry.PortType;
import org.openspcoop2.core.registry.PortaDominio;
import org.openspcoop2.core.registry.Servizio;
import org.openspcoop2.core.registry.Soggetto;
import org.openspcoop2.core.registry.driver.IDAccordoCooperazioneFactory;
import org.openspcoop2.core.registry.driver.IDAccordoFactory;
import org.openspcoop2.utils.serialization.IOException;

public class IDBuilder
implements org.openspcoop2.utils.serialization.IDBuilder {
    protected boolean prefix = false;
    private IDAccordoFactory idAccordoFactory = IDAccordoFactory.getInstance();
    private IDAccordoCooperazioneFactory idAccordoCooperazioneFactory = IDAccordoCooperazioneFactory.getInstance();

    public IDBuilder(boolean insertClassNamePrefix) {
        this.prefix = insertClassNamePrefix;
    }

    public IDBuilder() {
        this.prefix = false;
    }

    public static IDBuilder getIDBuilder() {
        return new IDBuilder();
    }

    public String toID(Object o) throws IOException {
        if (o == null) {
            throw new IOException("Oggetto is null");
        }
        try {
            if (o instanceof AccordoCooperazione) {
                AccordoCooperazione ac = (AccordoCooperazione)o;
                String id = this.idAccordoCooperazioneFactory.getUriFromAccordo(ac);
                if (this.prefix) {
                    return "[AccordoCooperazione] " + id;
                }
                return id;
            }
            if (o instanceof AccordoServizioParteComune) {
                AccordoServizioParteComune as = (AccordoServizioParteComune)o;
                String id = this.idAccordoFactory.getUriFromAccordo(as);
                if (this.prefix) {
                    return "[AS] " + id;
                }
                return id;
            }
            if (o instanceof PortType) {
                PortType p = (PortType)o;
                String id = "IDAccordo[" + p.getIdAccordo() + "]_" + p.getNome();
                if (this.prefix) {
                    return "[PortType] " + id;
                }
                return id;
            }
            if (o instanceof Documento) {
                Documento d = (Documento)o;
                String id = "[" + d.getRuolo() + "][" + d.getTipo() + "]" + " " + d.getFile();
                if (this.prefix) {
                    return "[Documento] " + id;
                }
                return id;
            }
            if (o instanceof PortaDominio) {
                PortaDominio p = (PortaDominio)o;
                String id = p.getNome();
                if (this.prefix) {
                    return "[PdD] " + id;
                }
                return id;
            }
            if (o instanceof AccordoServizioParteSpecifica) {
                AccordoServizioParteSpecifica s = (AccordoServizioParteSpecifica)o;
                String id = s.getServizio().getTipoSoggettoErogatore() + "/" + s.getServizio().getNomeSoggettoErogatore() + "#" + s.getServizio().getTipo() + "/" + s.getNome();
                if (this.prefix) {
                    return "[Servizio] " + id;
                }
                return id;
            }
            if (o instanceof Fruitore) {
                Fruitore fr = (Fruitore)o;
                String id = fr.getTipo() + "/" + fr.getNome();
                if (fr.getIdServizio() != null && fr.getIdServizio() > 0L) {
                    id = id + "#idServizio:" + fr.getIdServizio();
                }
                if (this.prefix) {
                    return "[FruitoreServizio] " + id;
                }
                return id;
            }
            if (o instanceof Soggetto) {
                Soggetto s = (Soggetto)o;
                String id = s.getTipo() + "/" + s.getNome();
                if (this.prefix) {
                    return "[Soggetto] " + id;
                }
                return id;
            }
        }
        catch (Exception e) {
            throw new IOException("Trasformazione non riuscita: " + e.getMessage(), (Throwable)e);
        }
        throw new IOException("Tipo di Oggetto non gestito [" + o.getClass().getName() + "]");
    }

    public String toID(Object o, String field) throws IOException {
        if (o != null && o instanceof Documento) {
            return this.toID(o);
        }
        return this.toID(o) + "." + field;
    }

    public String toOldID(Object o) throws IOException {
        if (o == null) {
            throw new IOException("Oggetto is null");
        }
        try {
            if (o instanceof AccordoCooperazione) {
                AccordoCooperazione ac = (AccordoCooperazione)o;
                IDAccordoCooperazione idOLD = ac.getOldIDAccordoForUpdate();
                if (idOLD == null) {
                    return null;
                }
                String id = this.idAccordoCooperazioneFactory.getUriFromIDAccordo(idOLD);
                if (this.prefix) {
                    return "[AccordoCooperazione] " + id;
                }
                return id;
            }
            if (o instanceof AccordoServizioParteComune) {
                AccordoServizioParteComune as = (AccordoServizioParteComune)o;
                IDAccordo idOLD = as.getOldIDAccordoForUpdate();
                if (idOLD == null) {
                    return null;
                }
                String id = this.idAccordoFactory.getUriFromIDAccordo(idOLD);
                if (this.prefix) {
                    return "[AS] " + id;
                }
                return id;
            }
            if (o instanceof PortType) {
                return null;
            }
            if (o instanceof Documento) {
                return null;
            }
            if (o instanceof PortaDominio) {
                PortaDominio p = (PortaDominio)o;
                if (p.getOldNomeForUpdate() == null) {
                    return null;
                }
                String id = p.getOldNomeForUpdate();
                if (this.prefix) {
                    return "[PdD] " + id;
                }
                return id;
            }
            if (o instanceof AccordoServizioParteSpecifica) {
                AccordoServizioParteSpecifica as = (AccordoServizioParteSpecifica)o;
                Servizio s = as.getServizio();
                if (s.getOldTipoSoggettoErogatoreForUpdate() == null && s.getOldNomeSoggettoErogatoreForUpdate() == null && s.getOldTipoForUpdate() == null && s.getOldNomeForUpdate() == null) {
                    return null;
                }
                String id = null;
                id = s.getOldTipoSoggettoErogatoreForUpdate() != null && s.getOldNomeSoggettoErogatoreForUpdate() != null && s.getOldTipoForUpdate() != null && s.getOldNomeForUpdate() != null ? s.getOldTipoSoggettoErogatoreForUpdate() + "/" + s.getOldNomeSoggettoErogatoreForUpdate() + "#" + s.getOldTipoForUpdate() + "/" + s.getOldNomeForUpdate() : (s.getOldTipoSoggettoErogatoreForUpdate() == null && s.getOldNomeSoggettoErogatoreForUpdate() == null ? s.getTipoSoggettoErogatore() + "/" + s.getNomeSoggettoErogatore() + "#" + s.getOldTipoForUpdate() + "/" + s.getOldNomeForUpdate() : s.getOldTipoSoggettoErogatoreForUpdate() + "/" + s.getOldNomeSoggettoErogatoreForUpdate() + "#" + s.getTipo() + "/" + s.getNome());
                if (this.prefix) {
                    return "[Servizio] " + id;
                }
                return id;
            }
            if (o instanceof Soggetto) {
                Soggetto s = (Soggetto)o;
                if (s.getOldTipoForUpdate() == null || s.getOldNomeForUpdate() == null) {
                    return null;
                }
                String id = s.getOldTipoForUpdate() + "/" + s.getOldNomeForUpdate();
                if (this.prefix) {
                    return "[Soggetto] " + id;
                }
                return id;
            }
        }
        catch (Exception e) {
            throw new IOException("Trasformazione non riuscita: " + e.getMessage(), (Throwable)e);
        }
        throw new IOException("Tipo di Oggetto non gestito [" + o.getClass().getName() + "]");
    }

    public String[] getManagedObjects(boolean simpleName) throws IOException {
        Vector<String> oggetti = new Vector<String>();
        if (simpleName) {
            oggetti.add(AccordoCooperazione.class.getSimpleName());
            oggetti.add(AccordoServizioParteComune.class.getSimpleName());
            oggetti.add(PortType.class.getSimpleName());
            oggetti.add(Documento.class.getSimpleName());
            oggetti.add(AccordoServizioParteSpecifica.class.getSimpleName());
            oggetti.add(Soggetto.class.getSimpleName());
        } else {
            oggetti.add(AccordoCooperazione.class.getName());
            oggetti.add(AccordoServizioParteComune.class.getName());
            oggetti.add(PortType.class.getName());
            oggetti.add(Documento.class.getName());
            oggetti.add(AccordoServizioParteSpecifica.class.getName());
            oggetti.add(Soggetto.class.getName());
        }
        String[] tmp = new String[1];
        return oggetti.toArray(tmp);
    }

    public String getSimpleName(Object o) throws IOException {
        return o.getClass().getSimpleName();
    }
}

