/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.core.config.driver.xml;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import org.apache.log4j.Logger;
import org.jibx.runtime.BindingDirectory;
import org.jibx.runtime.IBindingFactory;
import org.jibx.runtime.IUnmarshallingContext;
import org.jibx.runtime.JiBXException;
import org.openspcoop2.core.commons.CoreException;
import org.openspcoop2.core.commons.IMonitoraggioRisorsa;
import org.openspcoop2.core.config.AccessoConfigurazione;
import org.openspcoop2.core.config.AccessoDatiAutorizzazione;
import org.openspcoop2.core.config.AccessoRegistro;
import org.openspcoop2.core.config.Configurazione;
import org.openspcoop2.core.config.GestioneErrore;
import org.openspcoop2.core.config.Openspcoop2;
import org.openspcoop2.core.config.PortaApplicativa;
import org.openspcoop2.core.config.PortaDelegata;
import org.openspcoop2.core.config.RoutingTable;
import org.openspcoop2.core.config.ServizioApplicativo;
import org.openspcoop2.core.config.Soggetto;
import org.openspcoop2.core.config.StatoServiziPdd;
import org.openspcoop2.core.config.SystemProperties;
import org.openspcoop2.core.config.constants.CostantiConfigurazione;
import org.openspcoop2.core.config.driver.BeanUtilities;
import org.openspcoop2.core.config.driver.DriverConfigurazioneException;
import org.openspcoop2.core.config.driver.DriverConfigurazioneNotFound;
import org.openspcoop2.core.config.driver.FiltroRicercaPorteApplicative;
import org.openspcoop2.core.config.driver.FiltroRicercaPorteDelegate;
import org.openspcoop2.core.config.driver.FiltroRicercaServiziApplicativi;
import org.openspcoop2.core.config.driver.FiltroRicercaSoggetti;
import org.openspcoop2.core.config.driver.IDriverConfigurazioneGet;
import org.openspcoop2.core.config.driver.ValidazioneSemantica;
import org.openspcoop2.core.id.IDPortaApplicativa;
import org.openspcoop2.core.id.IDPortaApplicativaByNome;
import org.openspcoop2.core.id.IDPortaDelegata;
import org.openspcoop2.core.id.IDServizio;
import org.openspcoop2.core.id.IDServizioApplicativo;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.message.ValidatoreXSD;
import org.openspcoop2.utils.Utilities;
import org.openspcoop2.utils.date.DateManager;

public class DriverConfigurazioneXML
extends BeanUtilities
implements IDriverConfigurazioneGet,
IMonitoraggioRisorsa {
    public boolean create = false;
    private IUnmarshallingContext uctx;
    private String configuration_path;
    private Openspcoop2 openspcoop;
    private ValidatoreXSD validatoreConfigurazione = null;
    private long lastModified = 0L;
    private Logger log = null;
    private static final int timeoutRefresh = 30;
    private boolean validazioneSemanticaDuranteModificaXML = false;
    private String[] tipiConnettori = null;
    private String[] tipiSoggetti = null;
    private String[] tipiServizi = null;
    private String[] tipoMsgDiagnosticiAppender = null;
    private String[] tipoTracciamentoAppender = null;
    private String[] tipoAutenticazione = null;
    private String[] tipoAutorizzazione = null;
    private String[] tipoAutorizzazioneContenuto = null;
    private String[] tipoAutorizzazioneBusteContenuto = null;
    private String[] tipoIntegrazionePD = null;
    private String[] tipoIntegrazionePA = null;

    private void parsingXMLConfigurazione() throws DriverConfigurazioneException {
        FileInputStream fXML = null;
        try {
            if (this.configuration_path.startsWith("http://") || this.configuration_path.startsWith("file://")) {
                this.validatoreConfigurazione.valida(this.configuration_path);
            } else {
                fXML = new FileInputStream(this.configuration_path);
                this.validatoreConfigurazione.valida((InputStream)fXML);
            }
        }
        catch (Exception e) {
            throw new DriverConfigurazioneException("Riscontrato errore durante la validazione XSD della configurazione XML di OpenSPCoop: " + e.getMessage());
        }
        finally {
            if (fXML != null) {
                try {
                    fXML.close();
                }
                catch (Exception e) {}
            }
        }
        InputStreamReader iStream = null;
        FileInputStream fin = null;
        HttpURLConnection httpConn = null;
        if (this.configuration_path.startsWith("http://") || this.configuration_path.startsWith("file://")) {
            try {
                URL url = new URL(this.configuration_path);
                URLConnection connection = url.openConnection();
                httpConn = (HttpURLConnection)connection;
                httpConn.setRequestMethod("GET");
                httpConn.setDoOutput(true);
                httpConn.setDoInput(true);
                iStream = new InputStreamReader(httpConn.getInputStream());
            }
            catch (Exception e) {
                try {
                    if (iStream != null) {
                        iStream.close();
                    }
                    if (httpConn != null) {
                        httpConn.disconnect();
                    }
                }
                catch (Exception ef) {
                    // empty catch block
                }
                throw new DriverConfigurazioneException("Riscontrato errore durante la creazione dell'inputStream della configurazione (HTTP) : \n\n" + e.getMessage());
            }
            this.lastModified = DateManager.getTimeMillis();
        } else {
            try {
                fin = new FileInputStream(this.configuration_path);
                iStream = new InputStreamReader(fin);
            }
            catch (FileNotFoundException e) {
                throw new DriverConfigurazioneException("Riscontrato errore durante la creazione dell'inputStream della configurazione (FILE) : \n\n" + e.getMessage());
            }
            try {
                this.lastModified = new File(this.configuration_path).lastModified();
            }
            catch (Exception e) {
                try {
                    if (iStream != null) {
                        iStream.close();
                    }
                }
                catch (IOException ef) {
                    // empty catch block
                }
                try {
                    if (fin != null) {
                        fin.close();
                    }
                }
                catch (IOException ef) {
                    // empty catch block
                }
                throw new DriverConfigurazioneException("Riscontrato errore durante la lettura del file dove e' allocato la configurazione: " + e.getMessage());
            }
        }
        try {
            this.openspcoop = (Openspcoop2)this.uctx.unmarshalDocument((Reader)iStream, null);
        }
        catch (JiBXException e) {
            try {
                if (iStream != null) {
                    iStream.close();
                }
            }
            catch (Exception ef) {
                // empty catch block
            }
            try {
                if (fin != null) {
                    fin.close();
                }
            }
            catch (Exception ef) {
                // empty catch block
            }
            try {
                if (httpConn != null) {
                    httpConn.disconnect();
                }
            }
            catch (Exception ef) {
                // empty catch block
            }
            throw new DriverConfigurazioneException("Riscontrato errore durante l'unmarshall del file di configurazione: " + e.getMessage());
        }
        try {
            if (iStream != null) {
                iStream.close();
            }
        }
        catch (Exception e) {
            throw new DriverConfigurazioneException("Riscontrato errore durante la chiusura dell'Input Stream: " + e.getMessage());
        }
        try {
            if (fin != null) {
                fin.close();
            }
        }
        catch (Exception e) {
            throw new DriverConfigurazioneException("Riscontrato errore durante la chiusura dell'Input Stream (file): " + e.getMessage());
        }
        try {
            if (httpConn != null) {
                httpConn.disconnect();
            }
        }
        catch (Exception e) {
            throw new DriverConfigurazioneException("Riscontrato errore durante la chiusura dell'Input Stream (http): " + e.getMessage());
        }
    }

    public DriverConfigurazioneXML(String path, Logger alog) {
        this.log = alog == null ? Logger.getLogger(DriverConfigurazioneXML.class) : alog;
        if (path == null) {
            this.log.error((Object)"DriverConfigurazione: Riscontrato errore durante la creazione: url/path is null");
            this.create = false;
            return;
        }
        this.configuration_path = path;
        try {
            this.validatoreConfigurazione = new ValidatoreXSD(this.log, DriverConfigurazioneXML.class.getResourceAsStream("/config.xsd"));
        }
        catch (Exception e) {
            this.log.info((Object)("Riscontrato errore durante l'inizializzazione dello schema della configurazione di OpenSPCoop: " + e.getMessage()), (Throwable)e);
            return;
        }
        try {
            IBindingFactory bfact = BindingDirectory.getFactory(Openspcoop2.class);
            this.uctx = bfact.createUnmarshallingContext();
        }
        catch (JiBXException e) {
            this.log.error((Object)("DriverConfigurazione: Riscontrato errore durante la creazione del contesto di unmarshall  : " + e.getMessage()), (Throwable)e);
            this.create = false;
            return;
        }
        try {
            this.parsingXMLConfigurazione();
        }
        catch (Exception e) {
            this.log.error((Object)("DriverConfigurazione: " + e.getMessage()), (Throwable)e);
            this.create = false;
            return;
        }
        this.create = true;
    }

    private void forzaRefreshConfigurazioneXML() throws DriverConfigurazioneException {
        this.refreshConfigurazioneXML(true);
    }

    public void refreshConfigurazioneXML() throws DriverConfigurazioneException {
        this.refreshConfigurazioneXML(false);
    }

    private synchronized void refreshConfigurazioneXML(boolean refreshForzato) throws DriverConfigurazioneException {
        File fTest = null;
        boolean refresh = refreshForzato;
        if (!refreshForzato) {
            if (this.configuration_path.startsWith("http://") || this.configuration_path.startsWith("file://")) {
                long now = DateManager.getTimeMillis();
                if (now - this.lastModified > 30000L) {
                    refresh = true;
                }
            } else {
                fTest = new File(this.configuration_path);
                if (this.lastModified != fTest.lastModified()) {
                    refresh = true;
                }
            }
        }
        if (refresh) {
            try {
                this.parsingXMLConfigurazione();
            }
            catch (Exception e) {
                this.log.error((Object)("DriverConfigurazione refreshError: " + e.getMessage()));
                throw new DriverConfigurazioneException("DriverConfigurazione refreshError: " + e.getMessage());
            }
            if (!this.configuration_path.startsWith("http://") && !this.configuration_path.startsWith("file://")) {
                this.log.warn((Object)"Reloaded configuration context.");
            }
            if (this.validazioneSemanticaDuranteModificaXML) {
                ValidazioneSemantica validazioneSemantica = new ValidazioneSemantica(this.openspcoop, this.tipiConnettori, this.tipiSoggetti, this.tipiServizi, this.tipoMsgDiagnosticiAppender, this.tipoTracciamentoAppender, this.tipoAutenticazione, this.tipoAutorizzazione, this.tipoAutorizzazioneContenuto, this.tipoAutorizzazioneBusteContenuto, this.tipoIntegrazionePD, this.tipoIntegrazionePA, true, this.log);
                try {
                    validazioneSemantica.validazioneSemantica(false);
                }
                catch (Exception e) {
                    this.log.error((Object)("DriverConfigurazione refreshError(ValidazioneSemantica): " + e.getMessage()));
                    throw new DriverConfigurazioneException("DriverConfigurazione refreshError(ValidazioneSemantica): " + e.getMessage());
                }
            }
        }
        if (this.openspcoop == null) {
            this.log.error((Object)"DriverConfigurazione refreshError: istanza della configurazione is null dopo il refresh");
            throw new DriverConfigurazioneException("DriverConfigurazione refreshError: istanza della configurazione is null dopo il refresh");
        }
    }

    public void abilitazioneValidazioneSemanticaDuranteModificaXML(String[] tipiConnettori, String[] tipiSoggetti, String[] tipiServizi, String[] tipoMsgDiagnosticiAppender, String[] tipoTracciamentoAppender, String[] tipoAutenticazione, String[] tipoAutorizzazione, String[] tipoAutorizzazioneContenuto, String[] tipoAutorizzazioneBusteContenuto, String[] tipoIntegrazionePD, String[] tipoIntegrazionePA) {
        this.validazioneSemanticaDuranteModificaXML = true;
        this.tipiConnettori = tipiConnettori;
        this.tipiSoggetti = tipiSoggetti;
        this.tipiServizi = tipiServizi;
        this.tipoMsgDiagnosticiAppender = tipoMsgDiagnosticiAppender;
        this.tipoTracciamentoAppender = tipoTracciamentoAppender;
        this.tipoAutenticazione = tipoAutenticazione;
        this.tipoAutorizzazione = tipoAutorizzazione;
        this.tipoAutorizzazioneContenuto = tipoAutorizzazioneContenuto;
        this.tipoAutorizzazioneBusteContenuto = tipoAutorizzazioneBusteContenuto;
        this.tipoIntegrazionePD = tipoIntegrazionePD;
        this.tipoIntegrazionePA = tipoIntegrazionePA;
    }

    @Override
    public Soggetto getSoggetto(IDSoggetto aSoggetto) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        if (aSoggetto == null || aSoggetto.getNome() == null || aSoggetto.getTipo() == null) {
            throw new DriverConfigurazioneException("[getSoggetto] Parametri Non Validi");
        }
        this.refreshConfigurazioneXML();
        for (int i = 0; i < this.openspcoop.sizeSoggettoList(); ++i) {
            Soggetto soggetto = this.openspcoop.getSoggetto(i);
            if (!aSoggetto.getNome().equals(soggetto.getNome()) || !aSoggetto.getTipo().equals(soggetto.getTipo())) continue;
            return soggetto;
        }
        throw new DriverConfigurazioneNotFound("[getSoggetto] Soggetto " + aSoggetto.toString() + " non Esistente");
    }

    @Override
    public Soggetto getSoggetto(String location) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        if (location == null) {
            throw new DriverConfigurazioneException("[getSoggetto] Parametro Non Validi");
        }
        this.refreshConfigurazioneXML();
        for (int i = 0; i < this.openspcoop.sizeSoggettoList(); ++i) {
            Soggetto soggetto = this.openspcoop.getSoggetto(i);
            for (int j = 0; j < soggetto.sizePortaDelegataList(); ++j) {
                PortaDelegata pd = soggetto.getPortaDelegata(j);
                if (!(pd.getLocation() != null ? pd.getLocation().equals(location) : location.equals(pd.getNome()))) continue;
                return soggetto;
            }
        }
        throw new DriverConfigurazioneNotFound("[getSoggetto] Soggetto che possiede la porta delegata [" + location + "] non esistente");
    }

    @Override
    public Soggetto getRouter() throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        this.refreshConfigurazioneXML();
        for (int i = 0; i < this.openspcoop.sizeSoggettoList(); ++i) {
            if (!this.openspcoop.getSoggetto(i).getRouter()) continue;
            return this.openspcoop.getSoggetto(i);
        }
        throw new DriverConfigurazioneNotFound("[getRouter] Router non esistente");
    }

    @Override
    public HashSet<String> getSoggettiVirtuali() throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        this.refreshConfigurazioneXML();
        HashSet<String> lista = new HashSet<String>();
        try {
            for (int i = 0; i < this.openspcoop.sizeSoggettoList(); ++i) {
                Soggetto soggetto = this.openspcoop.getSoggetto(i);
                for (int j = 0; j < soggetto.sizePortaApplicativaList(); ++j) {
                    String soggettoVirtuale;
                    PortaApplicativa pa = soggetto.getPortaApplicativa(j);
                    if (pa.getSoggettoVirtuale() == null || pa.getSoggettoVirtuale().getTipo() == null || pa.getSoggettoVirtuale().getNome() == null || lista.contains(soggettoVirtuale = pa.getSoggettoVirtuale().getTipo() + pa.getSoggettoVirtuale().getNome())) continue;
                    this.log.info((Object)("aggiunto Soggetto " + soggettoVirtuale + " alla lista dei Soggetti Virtuali"));
                    lista.add(soggettoVirtuale);
                }
            }
        }
        catch (Exception e) {
            throw new DriverConfigurazioneException("[getSoggettiVirtuali] Inizializzazione lista dei soggetti virtuali non riuscita: " + e.getMessage());
        }
        if (lista.size() == 0) {
            throw new DriverConfigurazioneNotFound("[getSoggettiVirtuali] Soggetti virtuali non esistenti");
        }
        return lista;
    }

    @Override
    public HashSet<IDServizio> getServizi_SoggettiVirtuali() throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        this.refreshConfigurazioneXML();
        HashSet<IDServizio> lista = new HashSet<IDServizio>();
        HashSet<String> unique = new HashSet<String>();
        try {
            for (int i = 0; i < this.openspcoop.sizeSoggettoList(); ++i) {
                Soggetto soggetto = this.openspcoop.getSoggetto(i);
                for (int j = 0; j < soggetto.sizePortaApplicativaList(); ++j) {
                    PortaApplicativa pa = soggetto.getPortaApplicativa(j);
                    if (pa.getSoggettoVirtuale() == null || pa.getSoggettoVirtuale().getTipo() == null || pa.getSoggettoVirtuale().getNome() == null) continue;
                    IDServizio s = new IDServizio();
                    s.setSoggettoErogatore(new IDSoggetto(pa.getSoggettoVirtuale().getTipo(), pa.getSoggettoVirtuale().getNome()));
                    s.setTipoServizio(pa.getServizio().getTipo());
                    s.setServizio(pa.getServizio().getNome());
                    if (unique.contains(s.toString())) continue;
                    lista.add(s);
                    unique.add(s.toString());
                }
            }
        }
        catch (Exception e) {
            throw new DriverConfigurazioneException("[getServizi_SoggettiVirtuali] Inizializzazione lista servizi dei soggetti virtuali non riuscita: " + e.getMessage());
        }
        if (lista.size() == 0) {
            throw new DriverConfigurazioneNotFound("[getServizi_SoggettiVirtuali] Servizi erogati da Soggetti virtuali non esistenti");
        }
        return lista;
    }

    @Override
    public List<IDSoggetto> getAllIdSoggetti(FiltroRicercaSoggetti filtroRicerca) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        this.refreshConfigurazioneXML();
        ArrayList<IDSoggetto> listIDSoggetti = new ArrayList<IDSoggetto>();
        for (int i = 0; i < this.openspcoop.sizeSoggettoList(); ++i) {
            Soggetto soggetto = this.openspcoop.getSoggetto(i);
            if (filtroRicerca != null) {
                if (filtroRicerca.getMinDate() != null) {
                    if (soggetto.getOraRegistrazione() == null) {
                        this.log.debug((Object)("[getAllIdSoggetti](FiltroByMinDate) Soggetto [" + soggetto.getTipo() + "/" + soggetto.getNome() + "] non valorizzato nell'ora-registrazione. Non inserito nella lista ritornata."));
                        continue;
                    }
                    if (soggetto.getOraRegistrazione().before(filtroRicerca.getMinDate())) continue;
                }
                if (filtroRicerca.getMaxDate() != null) {
                    if (soggetto.getOraRegistrazione() == null) {
                        this.log.debug((Object)("[getAllIdSoggetti](FiltroByMaxDate) Soggetto [" + soggetto.getTipo() + "/" + soggetto.getNome() + "] non valorizzato nell'ora-registrazione. Non inserito nella lista ritornata."));
                        continue;
                    }
                    if (soggetto.getOraRegistrazione().after(filtroRicerca.getMaxDate())) continue;
                }
                if (filtroRicerca.getTipo() != null && !soggetto.getTipo().equals(filtroRicerca.getTipo()) || filtroRicerca.getNome() != null && !soggetto.getNome().equals(filtroRicerca.getNome())) continue;
            }
            listIDSoggetti.add(new IDSoggetto(soggetto.getTipo(), soggetto.getNome()));
        }
        if (listIDSoggetti.size() <= 0) {
            if (filtroRicerca != null) {
                throw new DriverConfigurazioneNotFound("Soggetti non trovati che rispettano il filtro di ricerca selezionato: " + filtroRicerca.toString());
            }
            throw new DriverConfigurazioneNotFound("Soggetti non trovati");
        }
        return listIDSoggetti;
    }

    @Override
    public PortaDelegata getPortaDelegata(IDPortaDelegata idPD) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        if (idPD == null) {
            throw new DriverConfigurazioneException("[getPortaDelegata] Parametro idPD Non Validi");
        }
        IDSoggetto aSoggetto = idPD.getSoggettoFruitore();
        String location = idPD.getLocationPD();
        if (location == null || aSoggetto == null) {
            throw new DriverConfigurazioneException("[getPortaDelegata] Parametri non Validi");
        }
        Soggetto soggetto = null;
        try {
            soggetto = this.getSoggetto(aSoggetto);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (soggetto == null) {
            throw new DriverConfigurazioneException("[getPortaDelegata] Soggetto fruitore [" + aSoggetto.getTipo() + "/" + aSoggetto.getNome() + "] non esistente");
        }
        for (int j = 0; j < soggetto.sizePortaDelegataList(); ++j) {
            PortaDelegata pd = soggetto.getPortaDelegata(j);
            if (pd.getLocation() != null) {
                if (!pd.getLocation().equals(location)) continue;
                pd.setTipoSoggettoProprietario(soggetto.getTipo());
                pd.setNomeSoggettoProprietario(soggetto.getNome());
                return pd;
            }
            if (!location.equals(pd.getNome())) continue;
            pd.setTipoSoggettoProprietario(soggetto.getTipo());
            pd.setNomeSoggettoProprietario(soggetto.getNome());
            return pd;
        }
        throw new DriverConfigurazioneNotFound("[getPortaDelegata] PortaDelegata [" + location + "] non esistente");
    }

    @Override
    public List<IDPortaDelegata> getAllIdPorteDelegate(FiltroRicercaPorteDelegate filtroRicerca) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        this.refreshConfigurazioneXML();
        ArrayList<IDPortaDelegata> listIDPorteDelegate = new ArrayList<IDPortaDelegata>();
        for (int i = 0; i < this.openspcoop.sizeSoggettoList(); ++i) {
            Soggetto soggetto = this.openspcoop.getSoggetto(i);
            for (int j = 0; j < soggetto.sizePortaDelegataList(); ++j) {
                PortaDelegata pd = soggetto.getPortaDelegata(j);
                String id = pd.getNome();
                if (pd.getLocation() != null) {
                    id = pd.getLocation();
                }
                if (filtroRicerca != null) {
                    if (filtroRicerca.getMinDate() != null) {
                        if (pd.getOraRegistrazione() == null) {
                            this.log.debug((Object)("[getAllIdPorteDelegate](FiltroByMinDate) PortaDelegata [" + id + "] non valorizzato nell'ora-registrazione. Non inserito nella lista ritornata."));
                            continue;
                        }
                        if (pd.getOraRegistrazione().before(filtroRicerca.getMinDate())) continue;
                    }
                    if (filtroRicerca.getMaxDate() != null) {
                        if (soggetto.getOraRegistrazione() == null) {
                            this.log.debug((Object)("[getAllIdPorteDelegate](FiltroByMaxDate) PortaDelegata [" + id + "] non valorizzato nell'ora-registrazione. Non inserito nella lista ritornata."));
                            continue;
                        }
                        if (soggetto.getOraRegistrazione().after(filtroRicerca.getMaxDate())) continue;
                    }
                    if (filtroRicerca.getTipoSoggetto() != null && !soggetto.getTipo().equals(filtroRicerca.getTipoSoggetto()) || filtroRicerca.getNomeSoggetto() != null && !soggetto.getNome().equals(filtroRicerca.getNomeSoggetto()) || filtroRicerca.getTipoSoggettoErogatore() != null && !pd.getSoggettoErogatore().getTipo().equals(filtroRicerca.getTipoSoggettoErogatore()) || filtroRicerca.getNomeSoggettoErogatore() != null && (pd.getSoggettoErogatore().getNome() == null || !pd.getSoggettoErogatore().getNome().equals(filtroRicerca.getNomeSoggettoErogatore())) || filtroRicerca.getTipoServizio() != null && !pd.getServizio().getTipo().equals(filtroRicerca.getTipoServizio()) || filtroRicerca.getNomeServizio() != null && (pd.getServizio().getNome() == null || !pd.getServizio().getNome().equals(filtroRicerca.getNomeServizio())) || filtroRicerca.getAzione() != null && (pd.getAzione().getNome() == null || !pd.getAzione().getNome().equals(filtroRicerca.getAzione()))) continue;
                }
                IDPortaDelegata idPD = new IDPortaDelegata();
                idPD.setLocationPD(id);
                idPD.setSoggettoFruitore(new IDSoggetto(soggetto.getTipo(), soggetto.getNome()));
                listIDPorteDelegate.add(idPD);
            }
        }
        if (listIDPorteDelegate.size() <= 0) {
            if (filtroRicerca != null) {
                throw new DriverConfigurazioneNotFound("PorteDelegate non trovate che rispettano il filtro di ricerca selezionato: " + filtroRicerca.toString());
            }
            throw new DriverConfigurazioneNotFound("PorteDelegate non trovate");
        }
        return listIDPorteDelegate;
    }

    @Override
    public PortaApplicativa getPortaApplicativa(IDPortaApplicativa idPA) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        return this.getPortaApplicativa_engine(idPA, false, null);
    }

    @Override
    public PortaApplicativa getPortaApplicativa(IDPortaApplicativa idPA, boolean ricercaPuntuale) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        return this.getPortaApplicativa_engine(idPA, ricercaPuntuale, null);
    }

    @Override
    public PortaApplicativa getPortaApplicativaVirtuale(IDPortaApplicativa idPA, IDSoggetto soggettoVirtuale) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        return this.getPortaApplicativa_engine(idPA, false, soggettoVirtuale);
    }

    @Override
    public PortaApplicativa getPortaApplicativaVirtuale(IDPortaApplicativa idPA, IDSoggetto soggettoVirtuale, boolean ricercaPuntuale) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        return this.getPortaApplicativa_engine(idPA, ricercaPuntuale, soggettoVirtuale);
    }

    private PortaApplicativa getPortaApplicativa_engine(IDPortaApplicativa idPA, boolean ricercaPuntuale, IDSoggetto soggettoVirtuale) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        if (idPA == null) {
            throw new DriverConfigurazioneException("[getPortaApplicativa] Parametro idPA Non Validi");
        }
        if (idPA.getIDServizio() == null) {
            throw new DriverConfigurazioneException("[getPortaApplicativa] Parametro idPA non Validi (IDServizio is null)");
        }
        IDSoggetto soggettoErogatore = idPA.getIDServizio().getSoggettoErogatore();
        if (soggettoErogatore == null) {
            throw new DriverConfigurazioneException("[getPortaApplicativa] Parametri Non Validi (Soggetto Erogatore is null)");
        }
        IDServizio service = idPA.getIDServizio();
        if (service == null) {
            throw new DriverConfigurazioneException("[getPortaApplicativa] Parametri Non Validi (Servizio is null)");
        }
        String servizio = service.getServizio();
        String tipoServizio = service.getTipoServizio();
        String azione = service.getAzione();
        if (servizio == null || tipoServizio == null) {
            throw new DriverConfigurazioneException("[getPortaApplicativa] Parametri (Servizio) Non Validi");
        }
        Soggetto soggetto = null;
        try {
            soggetto = this.getSoggetto(soggettoErogatore);
        }
        catch (DriverConfigurazioneNotFound dn) {
            throw new DriverConfigurazioneNotFound("[getPortaApplicativa] " + dn.getMessage(), dn);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (soggetto == null) {
            throw new DriverConfigurazioneException("[getPortaApplicativa] Soggetto erogatore [" + soggettoErogatore.getTipo() + "/" + soggettoErogatore.getNome() + "] non esistente");
        }
        if (soggettoVirtuale != null && (soggettoVirtuale.getTipo() == null || soggettoVirtuale.getNome() == null)) {
            throw new DriverConfigurazioneException("[getPortaApplicativa] Parametri (Soggetto Virtuale) non validi");
        }
        PortaApplicativa paSenzaAzione = null;
        for (int j = 0; j < soggetto.sizePortaApplicativaList(); ++j) {
            PortaApplicativa pa = soggetto.getPortaApplicativa(j);
            boolean paMatchaCriteriDiRicerca = false;
            if (soggettoVirtuale == null) {
                paMatchaCriteriDiRicerca = servizio.equals(pa.getServizio().getNome()) && tipoServizio.equals(pa.getServizio().getTipo());
            } else {
                boolean bl = paMatchaCriteriDiRicerca = servizio.equals(pa.getServizio().getNome()) && tipoServizio.equals(pa.getServizio().getTipo()) && pa.getSoggettoVirtuale() != null && soggettoVirtuale.getTipo().equals(pa.getSoggettoVirtuale().getTipo()) && soggettoVirtuale.getNome().equals(pa.getSoggettoVirtuale().getNome());
            }
            if (!paMatchaCriteriDiRicerca) continue;
            if (azione == null) {
                if (pa.getAzione() != null) continue;
                pa.setTipoSoggettoProprietario(soggetto.getTipo());
                pa.setNomeSoggettoProprietario(soggetto.getNome());
                return pa;
            }
            if (pa.getAzione() == null) {
                paSenzaAzione = pa;
                paSenzaAzione.setTipoSoggettoProprietario(soggetto.getTipo());
                paSenzaAzione.setNomeSoggettoProprietario(soggetto.getNome());
                continue;
            }
            if (!azione.equals(pa.getAzione().getNome())) continue;
            pa.setTipoSoggettoProprietario(soggetto.getTipo());
            pa.setNomeSoggettoProprietario(soggetto.getNome());
            return pa;
        }
        if (paSenzaAzione != null && !ricercaPuntuale) {
            return paSenzaAzione;
        }
        throw new DriverConfigurazioneNotFound("[getPortaApplicativa] PortaApplicativa non esistente");
    }

    @Override
    public PortaApplicativa getPortaApplicativa(IDPortaApplicativaByNome idPA) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        if (idPA == null) {
            throw new DriverConfigurazioneException("Identificativo non fornito");
        }
        return this.getPortaApplicativa(idPA.getNome(), idPA.getSoggetto());
    }

    @Override
    public PortaApplicativa getPortaApplicativa(String nomePorta, IDSoggetto soggettoProprietario) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        if (nomePorta == null) {
            throw new DriverConfigurazioneException("[getPortaApplicativa]  Nome Porta is null");
        }
        if (soggettoProprietario == null) {
            throw new DriverConfigurazioneException("[getPortaApplicativa]  SoggettoProprietario is null");
        }
        if (soggettoProprietario.getTipo() == null || soggettoProprietario.getNome() == null) {
            throw new DriverConfigurazioneException("[getPortaApplicativa]  dati del SoggettoProprietario null");
        }
        Soggetto soggetto = null;
        try {
            soggetto = this.getSoggetto(soggettoProprietario);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (soggetto == null) {
            throw new DriverConfigurazioneException("[getPortaApplicativa] Soggetto proprietario [" + soggettoProprietario.toString() + "] non esistente");
        }
        for (int i = 0; i < soggetto.sizePortaApplicativaList(); ++i) {
            if (!nomePorta.equals(soggetto.getPortaApplicativa(i).getNome())) continue;
            PortaApplicativa pa = soggetto.getPortaApplicativa(i);
            pa.setTipoSoggettoProprietario(soggetto.getTipo());
            pa.setNomeSoggettoProprietario(soggetto.getNome());
            return pa;
        }
        throw new DriverConfigurazioneNotFound("[getPortaApplicativa] PortaApplicativa non esistente");
    }

    @Override
    public Hashtable<IDSoggetto, PortaApplicativa> getPorteApplicative_SoggettiVirtuali(IDPortaApplicativa idPA) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        if (idPA == null) {
            throw new DriverConfigurazioneException("[getPortaApplicativa_SoggettiVirtuali] Parametro idPA Non Valido");
        }
        if (idPA.getIDServizio() == null) {
            throw new DriverConfigurazioneException("[getPortaApplicativa_SoggettiVirtuali] Parametro idServizio Non Valido");
        }
        if (idPA.getIDServizio().getSoggettoErogatore() == null) {
            throw new DriverConfigurazioneException("[getPortaApplicativa_SoggettiVirtuali] Parametro Soggetto Erogatore Non Valido");
        }
        this.refreshConfigurazioneXML();
        Hashtable<IDSoggetto, PortaApplicativa> paConSoggetti = new Hashtable<IDSoggetto, PortaApplicativa>();
        IDSoggetto soggettoVirtuale = idPA.getIDServizio().getSoggettoErogatore();
        String servizio = idPA.getIDServizio().getServizio();
        String tipoServizio = idPA.getIDServizio().getTipoServizio();
        String azione = idPA.getIDServizio().getAzione();
        if (servizio == null || tipoServizio == null) {
            throw new DriverConfigurazioneException("[getPortaApplicativa_SoggettiVirtuali] Parametri (Servizio) Non Validi");
        }
        for (int i = 0; i < this.openspcoop.sizeSoggettoList(); ++i) {
            Soggetto aSoggetto = this.openspcoop.getSoggetto(i);
            PortaApplicativa paSenzaAzione = null;
            for (int j = 0; j < aSoggetto.sizePortaApplicativaList(); ++j) {
                int k;
                PortaApplicativa pa = aSoggetto.getPortaApplicativa(j);
                if (pa.getSoggettoVirtuale() == null || !pa.getSoggettoVirtuale().getTipo().equals(soggettoVirtuale.getTipo()) || !pa.getSoggettoVirtuale().getNome().equals(soggettoVirtuale.getNome()) || !servizio.equals(pa.getServizio().getNome()) || !tipoServizio.equals(pa.getServizio().getTipo())) continue;
                if (azione == null) {
                    if (pa.getAzione() != null) continue;
                    for (k = 0; k < pa.sizeServizioApplicativoList(); ++k) {
                        paConSoggetti.put(new IDSoggetto(aSoggetto.getTipo(), aSoggetto.getNome()), pa);
                    }
                } else {
                    if (pa.getAzione() == null) {
                        paSenzaAzione = pa;
                        continue;
                    }
                    if (!azione.equals(pa.getAzione().getNome())) continue;
                    for (k = 0; k < pa.sizeServizioApplicativoList(); ++k) {
                        paConSoggetti.put(new IDSoggetto(aSoggetto.getTipo(), aSoggetto.getNome()), pa);
                        paSenzaAzione = null;
                    }
                }
                break;
            }
            if (paSenzaAzione == null) continue;
            paConSoggetti.put(new IDSoggetto(aSoggetto.getTipo(), aSoggetto.getNome()), paSenzaAzione);
        }
        if (paConSoggetti.size() == 0) {
            throw new DriverConfigurazioneNotFound("[getPortaApplicativa_SoggettiVirtuali] Porte applicative di soggetti virtuali non esistenti.");
        }
        return paConSoggetti;
    }

    @Override
    public List<PortaApplicativa> getPorteApplicative(String nomePA, String tipoSoggettoProprietario, String nomeSoggettoProprietario) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        if (nomePA == null) {
            throw new DriverConfigurazioneException("[getPorteApplicative] Parametro nomePA Non Valido");
        }
        this.refreshConfigurazioneXML();
        ArrayList<PortaApplicativa> lista = new ArrayList<PortaApplicativa>();
        for (int i = 0; i < this.openspcoop.sizeSoggettoList(); ++i) {
            Soggetto aSoggetto = this.openspcoop.getSoggetto(i);
            if (tipoSoggettoProprietario != null && !"".equals(tipoSoggettoProprietario) && !aSoggetto.getTipo().equals(tipoSoggettoProprietario) || nomeSoggettoProprietario != null && !"".equals(nomeSoggettoProprietario) && !aSoggetto.getNome().equals(nomeSoggettoProprietario)) continue;
            for (int j = 0; j < aSoggetto.sizePortaApplicativaList(); ++j) {
                PortaApplicativa pa = aSoggetto.getPortaApplicativa(j);
                pa.setTipoSoggettoProprietario(aSoggetto.getTipo());
                pa.setNomeSoggettoProprietario(aSoggetto.getNome());
                if (!pa.getNome().equals(nomePA)) continue;
                lista.add(pa);
            }
        }
        if (lista.size() == 0) {
            throw new DriverConfigurazioneNotFound("[getPorteApplicative] Porte applicative non esistenti.");
        }
        return lista;
    }

    @Override
    public List<IDPortaApplicativaByNome> getAllIdPorteApplicative(FiltroRicercaPorteApplicative filtroRicerca) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        this.refreshConfigurazioneXML();
        ArrayList<IDPortaApplicativaByNome> listIDPorteApplicative = new ArrayList<IDPortaApplicativaByNome>();
        for (int i = 0; i < this.openspcoop.sizeSoggettoList(); ++i) {
            Soggetto soggetto = this.openspcoop.getSoggetto(i);
            for (int j = 0; j < soggetto.sizePortaApplicativaList(); ++j) {
                PortaApplicativa pa = soggetto.getPortaApplicativa(j);
                String id = pa.getNome();
                if (filtroRicerca != null) {
                    if (filtroRicerca.getMinDate() != null) {
                        if (pa.getOraRegistrazione() == null) {
                            this.log.debug((Object)("[getAllIdPorteApplicative](FiltroByMinDate) PortaApplicativa [" + id + "] non valorizzato nell'ora-registrazione. Non inserito nella lista ritornata."));
                            continue;
                        }
                        if (pa.getOraRegistrazione().before(filtroRicerca.getMinDate())) continue;
                    }
                    if (filtroRicerca.getMaxDate() != null) {
                        if (soggetto.getOraRegistrazione() == null) {
                            this.log.debug((Object)("[getAllIdPorteApplicative](FiltroByMaxDate) PortaApplicativa [" + id + "] non valorizzato nell'ora-registrazione. Non inserito nella lista ritornata."));
                            continue;
                        }
                        if (soggetto.getOraRegistrazione().after(filtroRicerca.getMaxDate())) continue;
                    }
                    if (filtroRicerca.getTipoSoggetto() != null && !soggetto.getTipo().equals(filtroRicerca.getTipoSoggetto()) || filtroRicerca.getNomeSoggetto() != null && !soggetto.getNome().equals(filtroRicerca.getNomeSoggetto()) || filtroRicerca.getTipoServizio() != null && !pa.getServizio().getTipo().equals(filtroRicerca.getTipoServizio()) || filtroRicerca.getNomeServizio() != null && (pa.getServizio().getNome() == null || !pa.getServizio().getNome().equals(filtroRicerca.getNomeServizio())) || filtroRicerca.getAzione() != null && (pa.getAzione().getNome() == null || !pa.getAzione().getNome().equals(filtroRicerca.getAzione()))) continue;
                }
                IDPortaApplicativaByNome idPA = new IDPortaApplicativaByNome();
                idPA.setNome(id);
                idPA.setSoggetto(new IDSoggetto(soggetto.getTipo(), soggetto.getNome()));
                listIDPorteApplicative.add(idPA);
            }
        }
        if (listIDPorteApplicative.size() <= 0) {
            if (filtroRicerca != null) {
                throw new DriverConfigurazioneNotFound("PorteApplicative non trovate che rispettano il filtro di ricerca selezionato: " + filtroRicerca.toString());
            }
            throw new DriverConfigurazioneNotFound("PorteApplicative non trovate");
        }
        return listIDPorteApplicative;
    }

    @Override
    public ServizioApplicativo getServizioApplicativo(IDPortaDelegata idPD, String servizioApplicativo) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        IDSoggetto soggetto = idPD.getSoggettoFruitore();
        if (servizioApplicativo == null) {
            throw new DriverConfigurazioneException("[getServizioApplicativo(RichiestaDelegata)] Parametro servizioApplicativo Non Valido");
        }
        PortaDelegata pd = this.getPortaDelegata(idPD);
        if (pd != null) {
            for (int j = 0; j < pd.sizeServizioApplicativoList(); ++j) {
                ServizioApplicativo sa = pd.getServizioApplicativo(j);
                if (!servizioApplicativo.equals(sa.getNome())) continue;
                if (sa.getInvocazionePorta() == null) break;
                sa.setTipoSoggettoProprietario(pd.getTipoSoggettoProprietario());
                sa.setNomeSoggettoProprietario(pd.getNomeSoggettoProprietario());
                return sa;
            }
        }
        if (soggetto != null) {
            Soggetto soggettoProprietario = null;
            try {
                soggettoProprietario = this.getSoggetto(soggetto);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (soggettoProprietario == null) {
                throw new DriverConfigurazioneException("[getServizioApplicativo(RichiestaDelegata)] Soggetto fruitore non esistente");
            }
            for (int j = 0; j < soggettoProprietario.sizeServizioApplicativoList(); ++j) {
                ServizioApplicativo sa = soggettoProprietario.getServizioApplicativo(j);
                if (!servizioApplicativo.equals(sa.getNome())) continue;
                sa.setTipoSoggettoProprietario(soggettoProprietario.getTipo());
                sa.setNomeSoggettoProprietario(soggettoProprietario.getNome());
                return sa;
            }
        } else {
            for (int i = 0; i < this.openspcoop.sizeSoggettoList(); ++i) {
                Soggetto soggettoSearch = this.openspcoop.getSoggetto(i);
                for (int j = 0; j < soggettoSearch.sizeServizioApplicativoList(); ++j) {
                    ServizioApplicativo sa = soggettoSearch.getServizioApplicativo(j);
                    if (!servizioApplicativo.equals(sa.getNome())) continue;
                    sa.setTipoSoggettoProprietario(soggettoSearch.getTipo());
                    sa.setNomeSoggettoProprietario(soggettoSearch.getNome());
                    return sa;
                }
            }
        }
        throw new DriverConfigurazioneNotFound("[getServizioApplicativo(RichiestaDelegata)] Servizio Applicativo non esistente");
    }

    @Override
    public ServizioApplicativo getServizioApplicativo(IDPortaApplicativa idPA, String servizioApplicativo) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        IDSoggetto soggetto = idPA.getIDServizio().getSoggettoErogatore();
        if (soggetto == null || servizioApplicativo == null) {
            throw new DriverConfigurazioneException("[getServizioApplicativo(RichiestaApplicativa)] Parametri Non Validi");
        }
        PortaApplicativa pa = this.getPortaApplicativa(idPA);
        if (pa != null) {
            for (int j = 0; j < pa.sizeServizioApplicativoList(); ++j) {
                ServizioApplicativo sa = pa.getServizioApplicativo(j);
                if (!servizioApplicativo.equals(sa.getNome())) continue;
                if (sa.getInvocazioneServizio() == null) break;
                sa.setTipoSoggettoProprietario(pa.getTipoSoggettoProprietario());
                sa.setNomeSoggettoProprietario(pa.getNomeSoggettoProprietario());
                return sa;
            }
        }
        Soggetto soggettoProprietario = null;
        try {
            soggettoProprietario = this.getSoggetto(soggetto);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (soggettoProprietario == null) {
            throw new DriverConfigurazioneException("[getServizioApplicativo(RichiestaApplicativa)] Soggetto Erogatore non esistente");
        }
        for (int j = 0; j < soggettoProprietario.sizeServizioApplicativoList(); ++j) {
            ServizioApplicativo sa = soggettoProprietario.getServizioApplicativo(j);
            if (!servizioApplicativo.equals(sa.getNome())) continue;
            sa.setTipoSoggettoProprietario(soggettoProprietario.getTipo());
            sa.setNomeSoggettoProprietario(soggettoProprietario.getNome());
            return sa;
        }
        throw new DriverConfigurazioneNotFound("[getServizioApplicativo(RichiestaApplicativa)] Servizio applicativo non esistente");
    }

    @Override
    public ServizioApplicativo getServizioApplicativoAutenticato(IDPortaDelegata idPD, String aUser, String aPassword) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        block14: {
            block13: {
                int z;
                ServizioApplicativo sa;
                if (idPD != null && idPD.getSoggettoFruitore() != null & idPD.getLocationPD() != null) {
                    PortaDelegata pd = null;
                    try {
                        pd = this.getPortaDelegata(idPD);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    if (pd != null) {
                        for (int j = 0; j < pd.sizeServizioApplicativoList(); ++j) {
                            sa = pd.getServizioApplicativo(j);
                            if (sa.getInvocazionePorta() == null) continue;
                            for (z = 0; z < sa.getInvocazionePorta().sizeCredenzialiList(); ++z) {
                                if (sa.getInvocazionePorta().getCredenziali(z).getTipo() == null || !CostantiConfigurazione.CREDENZIALE_BASIC.equals(sa.getInvocazionePorta().getCredenziali(z).getTipo()) || !aUser.equals(sa.getInvocazionePorta().getCredenziali(z).getUser()) || !aPassword.equals(sa.getInvocazionePorta().getCredenziali(z).getPassword())) continue;
                                sa.setTipoSoggettoProprietario(pd.getTipoSoggettoProprietario());
                                sa.setNomeSoggettoProprietario(pd.getNomeSoggettoProprietario());
                                return sa;
                            }
                        }
                    }
                }
                if (idPD == null || idPD.getSoggettoFruitore() == null) break block13;
                Soggetto soggetto = null;
                try {
                    soggetto = this.getSoggetto(idPD.getSoggettoFruitore());
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (soggetto == null) break block14;
                for (int j = 0; j < soggetto.sizeServizioApplicativoList(); ++j) {
                    sa = soggetto.getServizioApplicativo(j);
                    if (sa.getInvocazionePorta() == null) continue;
                    for (z = 0; z < sa.getInvocazionePorta().sizeCredenzialiList(); ++z) {
                        if (sa.getInvocazionePorta().getCredenziali(z).getTipo() == null || !CostantiConfigurazione.CREDENZIALE_BASIC.equals(sa.getInvocazionePorta().getCredenziali(z).getTipo()) || !aUser.equals(sa.getInvocazionePorta().getCredenziali(z).getUser()) || !aPassword.equals(sa.getInvocazionePorta().getCredenziali(z).getPassword())) continue;
                        sa.setTipoSoggettoProprietario(soggetto.getTipo());
                        sa.setNomeSoggettoProprietario(soggetto.getNome());
                        return sa;
                    }
                }
                break block14;
            }
            for (int i = 0; i < this.openspcoop.sizeSoggettoList(); ++i) {
                Soggetto soggettoSearch = this.openspcoop.getSoggetto(i);
                for (int j = 0; j < soggettoSearch.sizeServizioApplicativoList(); ++j) {
                    ServizioApplicativo sa = soggettoSearch.getServizioApplicativo(j);
                    if (sa.getInvocazionePorta() == null) continue;
                    for (int z = 0; z < sa.getInvocazionePorta().sizeCredenzialiList(); ++z) {
                        if (sa.getInvocazionePorta().getCredenziali(z).getTipo() == null || !CostantiConfigurazione.CREDENZIALE_BASIC.equals(sa.getInvocazionePorta().getCredenziali(z).getTipo()) || !aUser.equals(sa.getInvocazionePorta().getCredenziali(z).getUser()) || !aPassword.equals(sa.getInvocazionePorta().getCredenziali(z).getPassword())) continue;
                        sa.setTipoSoggettoProprietario(soggettoSearch.getTipo());
                        sa.setNomeSoggettoProprietario(soggettoSearch.getNome());
                        return sa;
                    }
                }
            }
        }
        throw new DriverConfigurazioneNotFound("Servizio Applicativo cercato con credenziali basic non trovato");
    }

    @Override
    public ServizioApplicativo getServizioApplicativoAutenticato(String aUser, String aPassword) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        for (int i = 0; i < this.openspcoop.sizeSoggettoList(); ++i) {
            Soggetto soggettoSearch = this.openspcoop.getSoggetto(i);
            for (int j = 0; j < soggettoSearch.sizeServizioApplicativoList(); ++j) {
                ServizioApplicativo sa = soggettoSearch.getServizioApplicativo(j);
                if (sa.getInvocazionePorta() == null) continue;
                for (int z = 0; z < sa.getInvocazionePorta().sizeCredenzialiList(); ++z) {
                    if (sa.getInvocazionePorta().getCredenziali(z).getTipo() == null || !CostantiConfigurazione.CREDENZIALE_BASIC.equals(sa.getInvocazionePorta().getCredenziali(z).getTipo()) || !aUser.equals(sa.getInvocazionePorta().getCredenziali(z).getUser()) || !aPassword.equals(sa.getInvocazionePorta().getCredenziali(z).getPassword())) continue;
                    sa.setTipoSoggettoProprietario(soggettoSearch.getTipo());
                    sa.setNomeSoggettoProprietario(soggettoSearch.getNome());
                    return sa;
                }
            }
        }
        throw new DriverConfigurazioneNotFound("Servizio Applicativo cercato con credenziali basic non trovato");
    }

    @Override
    public ServizioApplicativo getServizioApplicativoAutenticato(IDPortaDelegata idPD, String aSubject) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        block32: {
            block31: {
                int z;
                ServizioApplicativo sa;
                if (idPD != null && idPD.getSoggettoFruitore() != null & idPD.getLocationPD() != null) {
                    PortaDelegata pd = null;
                    try {
                        pd = this.getPortaDelegata(idPD);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    if (pd != null) {
                        for (int j = 0; j < pd.sizeServizioApplicativoList(); ++j) {
                            sa = pd.getServizioApplicativo(j);
                            if (sa.getInvocazionePorta() == null) continue;
                            for (z = 0; z < sa.getInvocazionePorta().sizeCredenzialiList(); ++z) {
                                if (sa.getInvocazionePorta().getCredenziali(z).getTipo() == null) {
                                    try {
                                        if (Utilities.sslVerify((String)sa.getInvocazionePorta().getCredenziali(z).getSubject(), (String)aSubject)) {
                                            sa.setTipoSoggettoProprietario(pd.getTipoSoggettoProprietario());
                                            sa.setNomeSoggettoProprietario(pd.getNomeSoggettoProprietario());
                                            return sa;
                                        }
                                    }
                                    catch (Exception e) {
                                        throw new DriverConfigurazioneException(e.getMessage(), e);
                                    }
                                }
                                if (sa.getInvocazionePorta().getCredenziali(z).getTipo() == null || !CostantiConfigurazione.CREDENZIALE_SSL.equals(sa.getInvocazionePorta().getCredenziali(z).getTipo())) continue;
                                try {
                                    if (!Utilities.sslVerify((String)sa.getInvocazionePorta().getCredenziali(z).getSubject(), (String)aSubject)) continue;
                                    sa.setTipoSoggettoProprietario(pd.getTipoSoggettoProprietario());
                                    sa.setNomeSoggettoProprietario(pd.getNomeSoggettoProprietario());
                                    return sa;
                                }
                                catch (Exception e) {
                                    throw new DriverConfigurazioneException(e.getMessage(), e);
                                }
                            }
                        }
                    }
                }
                if (idPD == null || idPD.getSoggettoFruitore() == null) break block31;
                Soggetto soggetto = null;
                try {
                    soggetto = this.getSoggetto(idPD.getSoggettoFruitore());
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (soggetto == null) break block32;
                for (int j = 0; j < soggetto.sizeServizioApplicativoList(); ++j) {
                    sa = soggetto.getServizioApplicativo(j);
                    if (sa.getInvocazionePorta() == null) continue;
                    for (z = 0; z < sa.getInvocazionePorta().sizeCredenzialiList(); ++z) {
                        if (sa.getInvocazionePorta().getCredenziali(z).getTipo() == null) {
                            try {
                                if (Utilities.sslVerify((String)sa.getInvocazionePorta().getCredenziali(z).getSubject(), (String)aSubject)) {
                                    sa.setTipoSoggettoProprietario(soggetto.getTipo());
                                    sa.setNomeSoggettoProprietario(soggetto.getNome());
                                    return sa;
                                }
                            }
                            catch (Exception e) {
                                throw new DriverConfigurazioneException(e.getMessage(), e);
                            }
                        }
                        if (sa.getInvocazionePorta().getCredenziali(z).getTipo() == null || !CostantiConfigurazione.CREDENZIALE_SSL.equals(sa.getInvocazionePorta().getCredenziali(z).getTipo())) continue;
                        try {
                            if (!Utilities.sslVerify((String)sa.getInvocazionePorta().getCredenziali(z).getSubject(), (String)aSubject)) continue;
                            sa.setTipoSoggettoProprietario(soggetto.getTipo());
                            sa.setNomeSoggettoProprietario(soggetto.getNome());
                            return sa;
                        }
                        catch (Exception e) {
                            throw new DriverConfigurazioneException(e.getMessage(), e);
                        }
                    }
                }
                break block32;
            }
            for (int i = 0; i < this.openspcoop.sizeSoggettoList(); ++i) {
                Soggetto soggettoSearch = this.openspcoop.getSoggetto(i);
                for (int j = 0; j < soggettoSearch.sizeServizioApplicativoList(); ++j) {
                    ServizioApplicativo sa = soggettoSearch.getServizioApplicativo(j);
                    if (sa.getInvocazionePorta() == null) continue;
                    for (int z = 0; z < sa.getInvocazionePorta().sizeCredenzialiList(); ++z) {
                        if (sa.getInvocazionePorta().getCredenziali(z).getTipo() == null) {
                            try {
                                if (Utilities.sslVerify((String)sa.getInvocazionePorta().getCredenziali(z).getSubject(), (String)aSubject)) {
                                    sa.setTipoSoggettoProprietario(soggettoSearch.getTipo());
                                    sa.setNomeSoggettoProprietario(soggettoSearch.getNome());
                                    return sa;
                                }
                            }
                            catch (Exception e) {
                                throw new DriverConfigurazioneException(e.getMessage(), e);
                            }
                        }
                        if (sa.getInvocazionePorta().getCredenziali(z).getTipo() == null || !CostantiConfigurazione.CREDENZIALE_SSL.equals(sa.getInvocazionePorta().getCredenziali(z).getTipo())) continue;
                        try {
                            if (!Utilities.sslVerify((String)sa.getInvocazionePorta().getCredenziali(z).getSubject(), (String)aSubject)) continue;
                            sa.setTipoSoggettoProprietario(soggettoSearch.getTipo());
                            sa.setNomeSoggettoProprietario(soggettoSearch.getNome());
                            return sa;
                        }
                        catch (Exception e) {
                            throw new DriverConfigurazioneException(e.getMessage(), e);
                        }
                    }
                }
            }
        }
        throw new DriverConfigurazioneNotFound("Servizio Applicativo cercato con credenziali ssl non trovato");
    }

    @Override
    public ServizioApplicativo getServizioApplicativoAutenticato(String aSubject) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        for (int i = 0; i < this.openspcoop.sizeSoggettoList(); ++i) {
            Soggetto soggettoSearch = this.openspcoop.getSoggetto(i);
            for (int j = 0; j < soggettoSearch.sizeServizioApplicativoList(); ++j) {
                ServizioApplicativo sa = soggettoSearch.getServizioApplicativo(j);
                if (sa.getInvocazionePorta() == null) continue;
                for (int z = 0; z < sa.getInvocazionePorta().sizeCredenzialiList(); ++z) {
                    if (sa.getInvocazionePorta().getCredenziali(z).getTipo() == null) {
                        try {
                            if (Utilities.sslVerify((String)sa.getInvocazionePorta().getCredenziali(z).getSubject(), (String)aSubject)) {
                                sa.setTipoSoggettoProprietario(soggettoSearch.getTipo());
                                sa.setNomeSoggettoProprietario(soggettoSearch.getNome());
                                return sa;
                            }
                        }
                        catch (Exception e) {
                            throw new DriverConfigurazioneException(e.getMessage(), e);
                        }
                    }
                    if (sa.getInvocazionePorta().getCredenziali(z).getTipo() == null || !CostantiConfigurazione.CREDENZIALE_SSL.equals(sa.getInvocazionePorta().getCredenziali(z).getTipo())) continue;
                    try {
                        if (!Utilities.sslVerify((String)sa.getInvocazionePorta().getCredenziali(z).getSubject(), (String)aSubject)) continue;
                        sa.setTipoSoggettoProprietario(soggettoSearch.getTipo());
                        sa.setNomeSoggettoProprietario(soggettoSearch.getNome());
                        return sa;
                    }
                    catch (Exception e) {
                        throw new DriverConfigurazioneException(e.getMessage(), e);
                    }
                }
            }
        }
        throw new DriverConfigurazioneNotFound("Servizio Applicativo cercato con credenziali ssl non trovato");
    }

    @Override
    public ServizioApplicativo getServizioApplicativo(IDServizioApplicativo idServizioApplicativo) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        if (idServizioApplicativo == null) {
            throw new DriverConfigurazioneException("IDServizioApplicativo non definito");
        }
        if (idServizioApplicativo.getIdSoggettoProprietario() == null) {
            throw new DriverConfigurazioneException("IDServizioApplicativo.idSoggettoProprietario non definito");
        }
        if (idServizioApplicativo.getNome() == null) {
            throw new DriverConfigurazioneException("IDServizioApplicativo.nome non definito");
        }
        Soggetto soggettoProprietario = this.getSoggetto(idServizioApplicativo.getIdSoggettoProprietario());
        for (int j = 0; j < soggettoProprietario.sizeServizioApplicativoList(); ++j) {
            ServizioApplicativo sa = soggettoProprietario.getServizioApplicativo(j);
            if (!idServizioApplicativo.getNome().equals(sa.getNome())) continue;
            sa.setTipoSoggettoProprietario(soggettoProprietario.getTipo());
            sa.setNomeSoggettoProprietario(soggettoProprietario.getNome());
            return sa;
        }
        throw new DriverConfigurazioneNotFound("Servizio Applicativo non trovato");
    }

    @Override
    public ServizioApplicativo getServizioApplicativo(IDSoggetto idSoggetto, String nomeServizioApplicativo) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        for (int i = 0; i < this.openspcoop.sizeSoggettoList(); ++i) {
            Soggetto soggettoSearch = this.openspcoop.getSoggetto(i);
            if (!idSoggetto.getTipo().equals(soggettoSearch.getTipo()) || !idSoggetto.getNome().equals(soggettoSearch.getNome())) continue;
            for (int j = 0; j < soggettoSearch.sizeServizioApplicativoList(); ++j) {
                ServizioApplicativo sa = soggettoSearch.getServizioApplicativo(j);
                if (!sa.getNome().equals(nomeServizioApplicativo)) continue;
                sa.setTipoSoggettoProprietario(soggettoSearch.getTipo());
                sa.setNomeSoggettoProprietario(soggettoSearch.getNome());
                return sa;
            }
        }
        throw new DriverConfigurazioneNotFound("Servizio Applicativo cercato con credenziali ssl non trovato");
    }

    @Override
    public List<IDServizioApplicativo> getAllIdServiziApplicativi(FiltroRicercaServiziApplicativi filtroRicerca) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        this.refreshConfigurazioneXML();
        ArrayList<IDServizioApplicativo> listIDServiziApplicativi = new ArrayList<IDServizioApplicativo>();
        for (int i = 0; i < this.openspcoop.sizeSoggettoList(); ++i) {
            Soggetto soggetto = this.openspcoop.getSoggetto(i);
            for (int j = 0; j < soggetto.sizeServizioApplicativoList(); ++j) {
                ServizioApplicativo sa = soggetto.getServizioApplicativo(j);
                String id = sa.getNome();
                if (filtroRicerca != null) {
                    if (filtroRicerca.getMinDate() != null) {
                        if (sa.getOraRegistrazione() == null) {
                            this.log.debug((Object)("[getAllIdPorteApplicative](FiltroByMinDate) PortaApplicativa [" + id + "] non valorizzato nell'ora-registrazione. Non inserito nella lista ritornata."));
                            continue;
                        }
                        if (sa.getOraRegistrazione().before(filtroRicerca.getMinDate())) continue;
                    }
                    if (filtroRicerca.getMaxDate() != null) {
                        if (soggetto.getOraRegistrazione() == null) {
                            this.log.debug((Object)("[getAllIdPorteApplicative](FiltroByMaxDate) PortaApplicativa [" + id + "] non valorizzato nell'ora-registrazione. Non inserito nella lista ritornata."));
                            continue;
                        }
                        if (soggetto.getOraRegistrazione().after(filtroRicerca.getMaxDate())) continue;
                    }
                    if (filtroRicerca.getTipoSoggetto() != null && !soggetto.getTipo().equals(filtroRicerca.getTipoSoggetto()) || filtroRicerca.getNomeSoggetto() != null && !soggetto.getNome().equals(filtroRicerca.getNomeSoggetto())) continue;
                }
                IDServizioApplicativo idSA = new IDServizioApplicativo();
                idSA.setNome(id);
                idSA.setIdSoggettoProprietario(new IDSoggetto(soggetto.getTipo(), soggetto.getNome()));
                listIDServiziApplicativi.add(idSA);
            }
        }
        if (listIDServiziApplicativi.size() <= 0) {
            if (filtroRicerca != null) {
                throw new DriverConfigurazioneNotFound("ServiziApplicativi non trovate che rispettano il filtro di ricerca selezionato: " + filtroRicerca.toString());
            }
            throw new DriverConfigurazioneNotFound("ServiziApplicativi non trovate");
        }
        return listIDServiziApplicativi;
    }

    @Override
    public RoutingTable getRoutingTable() throws DriverConfigurazioneException {
        this.refreshConfigurazioneXML();
        RoutingTable r = null;
        if (this.openspcoop.getConfigurazione().getRoutingTable() == null) {
            r = new RoutingTable();
            r.setAbilitata(false);
        } else {
            r = this.openspcoop.getConfigurazione().getRoutingTable();
            r.setAbilitata(true);
        }
        return r;
    }

    @Override
    public AccessoRegistro getAccessoRegistro() throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        this.refreshConfigurazioneXML();
        if (this.openspcoop.getConfigurazione().getAccessoRegistro() == null) {
            throw new DriverConfigurazioneNotFound("[getAccessoRegistro] Informazioni di accesso al RegistroServizi non trovate");
        }
        return this.openspcoop.getConfigurazione().getAccessoRegistro();
    }

    @Override
    public AccessoConfigurazione getAccessoConfigurazione() throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        this.refreshConfigurazioneXML();
        if (this.openspcoop.getConfigurazione().getAccessoConfigurazione() == null) {
            throw new DriverConfigurazioneNotFound("[getAccessoConfigurazione] Informazioni di accesso alla configurazione non trovate");
        }
        return this.openspcoop.getConfigurazione().getAccessoConfigurazione();
    }

    @Override
    public AccessoDatiAutorizzazione getAccessoDatiAutorizzazione() throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        this.refreshConfigurazioneXML();
        if (this.openspcoop.getConfigurazione().getAccessoDatiAutorizzazione() == null) {
            throw new DriverConfigurazioneNotFound("[getAccessoDatiAutorizzazione] Informazioni di accesso ai dati di autorizzazione non trovate");
        }
        return this.openspcoop.getConfigurazione().getAccessoDatiAutorizzazione();
    }

    @Override
    public GestioneErrore getGestioneErroreComponenteCooperazione() throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        this.refreshConfigurazioneXML();
        if (this.openspcoop.getConfigurazione() == null) {
            throw new DriverConfigurazioneNotFound("[getGestioneErroreComponenteCooperazione] Configurazione non trovata");
        }
        if (this.openspcoop.getConfigurazione().getGestioneErrore() == null) {
            throw new DriverConfigurazioneNotFound("[getGestioneErroreComponenteCooperazione] Informazioni per la gestione dell'errore non trovate");
        }
        if (this.openspcoop.getConfigurazione().getGestioneErrore().getComponenteCooperazione() == null) {
            throw new DriverConfigurazioneNotFound("[getGestioneErroreComponenteCooperazione] Informazioni per la gestione dell'errore per il componente di cooperazione non trovate");
        }
        return this.openspcoop.getConfigurazione().getGestioneErrore().getComponenteCooperazione();
    }

    @Override
    public GestioneErrore getGestioneErroreComponenteIntegrazione() throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        this.refreshConfigurazioneXML();
        if (this.openspcoop.getConfigurazione() == null) {
            throw new DriverConfigurazioneNotFound("[getGestioneErroreComponenteIntegrazione] Configurazione non trovata");
        }
        if (this.openspcoop.getConfigurazione().getGestioneErrore() == null) {
            throw new DriverConfigurazioneNotFound("[getGestioneErroreComponenteIntegrazione] Informazioni per la gestione dell'errore non trovate");
        }
        if (this.openspcoop.getConfigurazione().getGestioneErrore().getComponenteIntegrazione() == null) {
            throw new DriverConfigurazioneNotFound("[getGestioneErroreComponenteIntegrazione] Informazioni per la gestione dell'errore per il componente di cooperazione non trovate");
        }
        return this.openspcoop.getConfigurazione().getGestioneErrore().getComponenteIntegrazione();
    }

    @Override
    public StatoServiziPdd getStatoServiziPdD() throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        this.refreshConfigurazioneXML();
        if (this.openspcoop.getConfigurazione() == null) {
            throw new DriverConfigurazioneNotFound("[getServiziAttiviPdD] Configurazione non trovata");
        }
        if (this.openspcoop.getConfigurazione().getStatoServiziPdd() == null) {
            throw new DriverConfigurazioneNotFound("[getServiziAttiviPdD] Configurazione servizi attivi sulla PdD non presente");
        }
        return this.openspcoop.getConfigurazione().getStatoServiziPdd();
    }

    @Override
    public SystemProperties getSystemPropertiesPdD() throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        this.refreshConfigurazioneXML();
        if (this.openspcoop.getConfigurazione() == null) {
            throw new DriverConfigurazioneNotFound("[getServiziAttiviPdD] Configurazione non trovata");
        }
        if (this.openspcoop.getConfigurazione().getSystemProperties() == null) {
            throw new DriverConfigurazioneNotFound("[getServiziAttiviPdD] Configurazione System Properties non presenti");
        }
        return this.openspcoop.getConfigurazione().getSystemProperties();
    }

    @Override
    public Configurazione getConfigurazioneGenerale() throws DriverConfigurazioneException {
        this.refreshConfigurazioneXML();
        return this.openspcoop.getConfigurazione();
    }

    @Override
    public void isAlive() throws CoreException {
        if (!this.create) {
            throw new CoreException("Driver non inizializzato");
        }
        try {
            this.forzaRefreshConfigurazioneXML();
        }
        catch (Exception e) {
            throw new CoreException("Connessione al registro non disponibile: " + e.getMessage(), e);
        }
    }

    @Override
    public Openspcoop2 getImmagineCompletaConfigurazionePdD() throws DriverConfigurazioneException {
        this.refreshConfigurazioneXML();
        return this.openspcoop;
    }
}

