/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.core.config.driver.utils;

import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;
import java.sql.Connection;
import java.sql.DriverManager;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;
import org.openspcoop2.core.config.Openspcoop2;
import org.openspcoop2.core.config.driver.ValidazioneSemantica;
import org.openspcoop2.core.config.driver.db.DriverConfigurazioneDB;
import org.openspcoop2.core.config.driver.xml.DriverConfigurazioneXML;
import org.openspcoop2.utils.Utilities;
import org.openspcoop2.utils.resources.Loader;

public class TestValidazioneSemantica {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void main(String[] args) throws Exception {
        if (args.length < 4) {
            String errorMsg = "ERROR, Usage:  java TestValidazioneSemantica commonProperties tipoConfigurazione proprietaConfigurazione validazioneConfigurazione";
            System.err.println(errorMsg);
            throw new Exception(errorMsg);
        }
        try {
            if (args.length == 5) {
                PropertyConfigurator.configure((String)args[4]);
            } else {
                PropertyConfigurator.configure((URL)TestValidazioneSemantica.class.getResource("/validator.log4j.properties"));
            }
        }
        catch (Exception e) {
            String errorMsg = "Errore durante il caricamento del file di log args4[" + args[4] + "] : " + e.getMessage();
            System.err.println(errorMsg);
            throw new Exception(errorMsg);
        }
        Logger log = Logger.getLogger((String)"validatoreDatiConfigurazione");
        Properties commonProperties = new Properties();
        try {
            commonProperties.load(new FileInputStream(args[0]));
        }
        catch (IOException e) {
            String errorMsg = "Errore durante il caricamento del file di properties [" + args[0] + "] : " + e.getMessage();
            log.error((Object)errorMsg, (Throwable)e);
            throw new Exception(errorMsg, e);
        }
        Properties reader = new Properties();
        try {
            reader.load(new FileInputStream(args[2]));
        }
        catch (IOException e) {
            String errorMsg = "Errore durante il caricamento del file di properties [" + args[2] + "] : " + e.getMessage();
            log.error((Object)errorMsg, (Throwable)e);
            throw new Exception(errorMsg, e);
        }
        Openspcoop2 configurazione = null;
        Connection connectionDB = null;
        String tipoConfigurazione = args[1];
        boolean validaSezioneConfigurazione = Boolean.parseBoolean(args[2]);
        if ("xml".equals(tipoConfigurazione)) {
            String path = reader.getProperty("openspcoop2.configurazione.xml");
            if (path == null) {
                throw new Exception("Non e' stato definito il path dove localizzare la configurazione xml");
            }
            path = path.trim();
            DriverConfigurazioneXML driver = new DriverConfigurazioneXML(path, log);
            if (!driver.create) {
                throw new Exception("ConfigurazionePdD XML non inizializzata");
            }
            log.info((Object)"Inizializzata Configurazione PdD XML");
            configurazione = driver.getImmagineCompletaConfigurazionePdD();
        } else {
            if (!"db".equals(tipoConfigurazione)) throw new Exception("Tipo di configurazione [" + tipoConfigurazione + "] non gestita");
            String tipoDatabase = reader.getProperty("openspcoop2.configurazione.db.tipo");
            if (tipoDatabase == null) {
                throw new Exception("Non e' stato definito il tipo di database");
            }
            tipoDatabase = tipoDatabase.trim();
            String dataSource = reader.getProperty("openspcoop2.configurazione.db.dataSource");
            if (dataSource != null) {
                dataSource = dataSource.trim();
                Properties context = Utilities.readProperties((String)"openspcoop2.configurazione.db.context.", (Properties)reader);
                DriverConfigurazioneDB driver = new DriverConfigurazioneDB(dataSource, context, log, tipoDatabase);
                if (!driver.create) {
                    throw new Exception("Configurazione DB non inizializzata");
                }
                log.info((Object)"Inizializzata Configurazione DB");
                configurazione = driver.getImmagineCompletaConfigurazionePdD();
            } else {
                String connection = reader.getProperty("openspcoop2.configurazione.db.url");
                if (connection == null) {
                    throw new Exception("Non e' stata definita una destinazione ne attraverso un datasource, ne attraverso una connessione diretta");
                }
                connection = connection.trim();
                String driverJDBC = reader.getProperty("openspcoop2.configurazione.db.driver");
                if (driverJDBC == null) {
                    throw new Exception("Connessione diretta: non e' stato definito il Driver");
                }
                driverJDBC = driverJDBC.trim();
                String username = reader.getProperty("openspcoop2.configurazione.db.user");
                String password = reader.getProperty("openspcoop2.configurazione.db.password");
                if (username != null) {
                    username = username.trim();
                }
                if (password != null) {
                    password = password.trim();
                }
                Loader.getInstance().newInstance(driverJDBC);
                try {
                    connectionDB = username != null ? DriverManager.getConnection(connection, username, password) : DriverManager.getConnection(connection);
                    DriverConfigurazioneDB driver = new DriverConfigurazioneDB(connectionDB, log, tipoDatabase);
                    if (!driver.create) {
                        throw new Exception("Configurazione DB non inizializzata");
                    }
                    log.info((Object)"Inizializzata Configurazione DB");
                    configurazione = driver.getImmagineCompletaConfigurazionePdD();
                }
                finally {
                    try {
                        if (connectionDB != null) {
                            connectionDB.close();
                        }
                    }
                    catch (Exception e) {}
                }
            }
        }
        try {
            String tipiConnettori = commonProperties.getProperty("openspcoop2.tipiConnettori");
            if (tipiConnettori == null) {
                throw new Exception("Non sono stati definiti i tipi di connettori supportati");
            }
            tipiConnettori = tipiConnettori.trim();
            String[] tipoConnettoriArray = tipiConnettori.split(",");
            for (int i = 0; i < tipoConnettoriArray.length; ++i) {
                tipoConnettoriArray[i] = tipoConnettoriArray[i].trim();
            }
            String tipiSoggetti = commonProperties.getProperty("openspcoop2.tipiSoggetti");
            if (tipiSoggetti == null) {
                throw new Exception("Non sono stati definiti i tipi di soggetti supportati");
            }
            tipiSoggetti = tipiSoggetti.trim();
            String[] tipoSoggettiArray = tipiSoggetti.split(",");
            for (int i = 0; i < tipoSoggettiArray.length; ++i) {
                tipoSoggettiArray[i] = tipoSoggettiArray[i].trim();
            }
            String tipiServizi = commonProperties.getProperty("openspcoop2.tipiServizi");
            if (tipiServizi == null) {
                throw new Exception("Non sono stati definiti i tipi di Servizi supportati");
            }
            tipiServizi = tipiServizi.trim();
            String[] tipoServiziArray = tipiServizi.split(",");
            for (int i = 0; i < tipoServiziArray.length; ++i) {
                tipoServiziArray[i] = tipoServiziArray[i].trim();
            }
            String tipiDiagnosticiAppender = commonProperties.getProperty("openspcoop2.diagnostici.appender");
            if (tipiDiagnosticiAppender == null) {
                throw new Exception("Non sono stati definiti i tipi di appender supportati (diagnostici)");
            }
            tipiDiagnosticiAppender = tipiServizi.trim();
            String[] tipiDiagnosticiAppenderArray = tipiDiagnosticiAppender.split(",");
            for (int i = 0; i < tipiDiagnosticiAppenderArray.length; ++i) {
                tipiDiagnosticiAppenderArray[i] = tipiDiagnosticiAppenderArray[i].trim();
            }
            String tipiTracceAppender = commonProperties.getProperty("openspcoop2.tracce.appender");
            if (tipiTracceAppender == null) {
                throw new Exception("Non sono stati definiti i tipi di appender supportati (tracce)");
            }
            tipiTracceAppender = tipiServizi.trim();
            String[] tipiTracceAppenderArray = tipiTracceAppender.split(",");
            for (int i = 0; i < tipiTracceAppenderArray.length; ++i) {
                tipiTracceAppenderArray[i] = tipiTracceAppenderArray[i].trim();
            }
            String tipiAutenticazione = commonProperties.getProperty("openspcoop2.autenticazione");
            if (tipiAutenticazione == null) {
                throw new Exception("Non sono stati definiti i tipi di autenticazione supportati");
            }
            tipiAutenticazione = tipiAutenticazione.trim();
            String[] tipiAutenticazioneArray = tipiAutenticazione.split(",");
            for (int i = 0; i < tipiAutenticazioneArray.length; ++i) {
                tipiAutenticazioneArray[i] = tipiAutenticazioneArray[i].trim();
            }
            String tipiAutorizzazione = commonProperties.getProperty("openspcoop2.autorizzazione");
            if (tipiAutorizzazione == null) {
                throw new Exception("Non sono stati definiti i tipi di autorizzazione supportati");
            }
            tipiAutorizzazione = tipiAutorizzazione.trim();
            String[] tipiAutorizzazioneArray = tipiAutorizzazione.split(",");
            for (int i = 0; i < tipiAutorizzazioneArray.length; ++i) {
                tipiAutorizzazioneArray[i] = tipiAutorizzazioneArray[i].trim();
            }
            String tipiAutorizzazioneContenutoPD = commonProperties.getProperty("openspcoop2.autorizzazioneContenuto.pd");
            if (tipiAutorizzazioneContenutoPD == null) {
                throw new Exception("Non sono stati definiti i tipi di autorizzazione per contenuto supportati (PD)");
            }
            tipiAutorizzazioneContenutoPD = tipiAutorizzazioneContenutoPD.trim();
            String[] tipiAutorizzazioneContenutoPDArray = tipiAutorizzazioneContenutoPD.split(",");
            for (int i = 0; i < tipiAutorizzazioneContenutoPDArray.length; ++i) {
                tipiAutorizzazioneContenutoPDArray[i] = tipiAutorizzazioneContenutoPDArray[i].trim();
            }
            String tipiAutorizzazioneContenutoPA = commonProperties.getProperty("openspcoop2.autorizzazioneContenuto.pa");
            if (tipiAutorizzazioneContenutoPA == null) {
                throw new Exception("Non sono stati definiti i tipi di autorizzazione per contenuto supportati (PA)");
            }
            tipiAutorizzazioneContenutoPA = tipiAutorizzazioneContenutoPA.trim();
            String[] tipiAutorizzazioneContenutoPAArray = tipiAutorizzazioneContenutoPA.split(",");
            for (int i = 0; i < tipiAutorizzazioneContenutoPAArray.length; ++i) {
                tipiAutorizzazioneContenutoPAArray[i] = tipiAutorizzazioneContenutoPAArray[i].trim();
            }
            String tipiIntegrazionePD = commonProperties.getProperty("openspcoop2.integrazione.pd");
            if (tipiIntegrazionePD == null) {
                throw new Exception("Non sono stati definiti i tipi di Integrazione supportati (PD)");
            }
            tipiIntegrazionePD = tipiIntegrazionePD.trim();
            String[] tipiIntegrazionePDArray = tipiIntegrazionePD.split(",");
            for (int i = 0; i < tipiIntegrazionePDArray.length; ++i) {
                tipiIntegrazionePDArray[i] = tipiIntegrazionePDArray[i].trim();
            }
            String tipiIntegrazionePA = commonProperties.getProperty("openspcoop2.integrazione.pa");
            if (tipiIntegrazionePA == null) {
                throw new Exception("Non sono stati definiti i tipi di Integrazione supportati (PA)");
            }
            tipiIntegrazionePA = tipiIntegrazionePA.trim();
            String[] tipiIntegrazionePAArray = tipiIntegrazionePA.split(",");
            for (int i = 0; i < tipiIntegrazionePAArray.length; ++i) {
                tipiIntegrazionePAArray[i] = tipiIntegrazionePAArray[i].trim();
            }
            ValidazioneSemantica validatore = new ValidazioneSemantica(configurazione, tipoConnettoriArray, tipoSoggettiArray, tipoServiziArray, tipiDiagnosticiAppenderArray, tipiTracceAppenderArray, tipiAutenticazioneArray, tipiAutorizzazioneArray, tipiAutorizzazioneContenutoPDArray, tipiAutorizzazioneContenutoPAArray, tipiIntegrazionePDArray, tipiIntegrazionePAArray, validaSezioneConfigurazione, log);
            validatore.validazioneSemantica(true);
            return;
        }
        catch (Exception e) {
            log.error((Object)("Errore: " + e.getMessage()));
            throw e;
        }
    }
}

