/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.core.config.driver.db;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import org.apache.log4j.Logger;
import org.openspcoop2.core.commons.CoreException;
import org.openspcoop2.core.commons.DBUtils;
import org.openspcoop2.core.commons.IExtendedInfo;
import org.openspcoop2.core.config.AccessoConfigurazione;
import org.openspcoop2.core.config.AccessoDatiAutorizzazione;
import org.openspcoop2.core.config.AccessoRegistro;
import org.openspcoop2.core.config.AccessoRegistroRegistro;
import org.openspcoop2.core.config.Attachments;
import org.openspcoop2.core.config.Cache;
import org.openspcoop2.core.config.Configurazione;
import org.openspcoop2.core.config.Connettore;
import org.openspcoop2.core.config.CorrelazioneApplicativa;
import org.openspcoop2.core.config.CorrelazioneApplicativaRisposta;
import org.openspcoop2.core.config.Credenziali;
import org.openspcoop2.core.config.GestioneErrore;
import org.openspcoop2.core.config.GestioneErroreCodiceTrasporto;
import org.openspcoop2.core.config.GestioneErroreSoapFault;
import org.openspcoop2.core.config.IndirizzoRisposta;
import org.openspcoop2.core.config.InoltroBusteNonRiscontrate;
import org.openspcoop2.core.config.IntegrationManager;
import org.openspcoop2.core.config.InvocazionePorta;
import org.openspcoop2.core.config.InvocazionePortaGestioneErrore;
import org.openspcoop2.core.config.InvocazioneServizio;
import org.openspcoop2.core.config.MessageSecurity;
import org.openspcoop2.core.config.MessaggiDiagnostici;
import org.openspcoop2.core.config.MtomProcessor;
import org.openspcoop2.core.config.OpenspcoopAppender;
import org.openspcoop2.core.config.OpenspcoopSorgenteDati;
import org.openspcoop2.core.config.PortaApplicativa;
import org.openspcoop2.core.config.PortaApplicativaAzione;
import org.openspcoop2.core.config.PortaApplicativaServizio;
import org.openspcoop2.core.config.PortaApplicativaSoggettoVirtuale;
import org.openspcoop2.core.config.PortaDelegata;
import org.openspcoop2.core.config.PortaDelegataAzione;
import org.openspcoop2.core.config.PortaDelegataServizio;
import org.openspcoop2.core.config.PortaDelegataSoggettoErogatore;
import org.openspcoop2.core.config.Property;
import org.openspcoop2.core.config.ProprietaProtocollo;
import org.openspcoop2.core.config.RispostaAsincrona;
import org.openspcoop2.core.config.Risposte;
import org.openspcoop2.core.config.Route;
import org.openspcoop2.core.config.RouteGateway;
import org.openspcoop2.core.config.RouteRegistro;
import org.openspcoop2.core.config.RoutingTable;
import org.openspcoop2.core.config.RoutingTableDefault;
import org.openspcoop2.core.config.RoutingTableDestinazione;
import org.openspcoop2.core.config.ServizioApplicativo;
import org.openspcoop2.core.config.Soggetto;
import org.openspcoop2.core.config.StatoServiziPdd;
import org.openspcoop2.core.config.StatoServiziPddIntegrationManager;
import org.openspcoop2.core.config.StatoServiziPddPortaApplicativa;
import org.openspcoop2.core.config.StatoServiziPddPortaDelegata;
import org.openspcoop2.core.config.SystemProperties;
import org.openspcoop2.core.config.TipoFiltroAbilitazioneServizi;
import org.openspcoop2.core.config.Tracciamento;
import org.openspcoop2.core.config.ValidazioneBuste;
import org.openspcoop2.core.config.constants.AlgoritmoCache;
import org.openspcoop2.core.config.constants.CorrelazioneApplicativaGestioneIdentificazioneFallita;
import org.openspcoop2.core.config.constants.CorrelazioneApplicativaRichiestaIdentificazione;
import org.openspcoop2.core.config.constants.CorrelazioneApplicativaRispostaIdentificazione;
import org.openspcoop2.core.config.constants.CostantiConfigurazione;
import org.openspcoop2.core.config.constants.CredenzialeTipo;
import org.openspcoop2.core.config.constants.FaultIntegrazioneTipo;
import org.openspcoop2.core.config.constants.GestioneErroreComportamento;
import org.openspcoop2.core.config.constants.InvocazioneServizioTipoAutenticazione;
import org.openspcoop2.core.config.constants.MTOMProcessorType;
import org.openspcoop2.core.config.constants.PortaDelegataAzioneIdentificazione;
import org.openspcoop2.core.config.constants.PortaDelegataServizioIdentificazione;
import org.openspcoop2.core.config.constants.PortaDelegataSoggettoErogatoreIdentificazione;
import org.openspcoop2.core.config.constants.ProprietaProtocolloValore;
import org.openspcoop2.core.config.constants.Severita;
import org.openspcoop2.core.config.constants.StatoFunzionalita;
import org.openspcoop2.core.config.constants.StatoFunzionalitaConWarning;
import org.openspcoop2.core.config.constants.TipoConnessioneRisposte;
import org.openspcoop2.core.config.constants.TipologiaErogazione;
import org.openspcoop2.core.config.constants.TipologiaFruizione;
import org.openspcoop2.core.config.constants.ValidazioneBusteTipoControllo;
import org.openspcoop2.core.config.constants.ValidazioneContenutiApplicativiTipo;
import org.openspcoop2.core.config.driver.ConnettorePropertiesUtilities;
import org.openspcoop2.core.config.driver.DriverConfigurazioneException;
import org.openspcoop2.core.config.driver.DriverConfigurazioneNotFound;
import org.openspcoop2.core.config.driver.ExtendedInfoManager;
import org.openspcoop2.core.constants.CostantiDB;
import org.openspcoop2.core.constants.TipiConnettore;
import org.openspcoop2.utils.TipiDatabase;
import org.openspcoop2.utils.Utilities;
import org.openspcoop2.utils.beans.BaseBean;
import org.openspcoop2.utils.jdbc.CustomKeyGeneratorObject;
import org.openspcoop2.utils.jdbc.IKeyGeneratorObject;
import org.openspcoop2.utils.jdbc.InsertAndGeneratedKey;
import org.openspcoop2.utils.jdbc.InsertAndGeneratedKeyJDBCType;
import org.openspcoop2.utils.jdbc.InsertAndGeneratedKeyObject;
import org.openspcoop2.utils.sql.ISQLQueryObject;
import org.openspcoop2.utils.sql.SQLObjectFactory;

public class DriverConfigurazioneDB_LIB {
    public static Logger log = Logger.getLogger((String)"DRIVER_DB_CONFIGURAZIONE");
    private static String tipoDB = null;
    private static String tabellaSoggetti = "soggetti";
    private static boolean initialize = false;

    public static void initStaticLogger(Logger aLog) {
        if (!initialize) {
            if (aLog != null) {
                log = aLog;
            }
            initialize = true;
        }
    }

    public static boolean isStaticLoggerInitialized() {
        return initialize;
    }

    public static void setTipoDB(String tipoDatabase) {
        tipoDB = tipoDatabase;
    }

    public static void setTabellaSoggetti(String tab) {
        tabellaSoggetti = tab;
    }

    public static String getValue(StatoFunzionalita funzionalita) {
        if (funzionalita == null) {
            return null;
        }
        return funzionalita.getValue();
    }

    public static String getValue(StatoFunzionalitaConWarning funzionalita) {
        if (funzionalita == null) {
            return null;
        }
        return funzionalita.getValue();
    }

    public static String getValue(MTOMProcessorType tipo) {
        if (tipo == null) {
            return null;
        }
        return tipo.getValue();
    }

    public static String getValue(ValidazioneContenutiApplicativiTipo tipo) {
        if (tipo == null) {
            return null;
        }
        return tipo.getValue();
    }

    public static String getValue(CorrelazioneApplicativaRichiestaIdentificazione identificazione) {
        if (identificazione == null) {
            return null;
        }
        return identificazione.getValue();
    }

    public static String getValue(CorrelazioneApplicativaRispostaIdentificazione identificazione) {
        if (identificazione == null) {
            return null;
        }
        return identificazione.getValue();
    }

    public static String getValue(CorrelazioneApplicativaGestioneIdentificazioneFallita identificazione) {
        if (identificazione == null) {
            return null;
        }
        return identificazione.getValue();
    }

    public static String getValue(InvocazioneServizioTipoAutenticazione tipo) {
        if (tipo == null) {
            return null;
        }
        return tipo.getValue();
    }

    public static String getValue(FaultIntegrazioneTipo tipo) {
        if (tipo == null) {
            return null;
        }
        return tipo.getValue();
    }

    public static String getValue(CredenzialeTipo tipo) {
        if (tipo == null) {
            return null;
        }
        return tipo.getValue();
    }

    public static String getValue(ProprietaProtocolloValore valore) {
        if (valore == null) {
            return null;
        }
        return valore.getValue();
    }

    public static String getValue(Severita valore) {
        if (valore == null) {
            return null;
        }
        return valore.getValue();
    }

    public static String getValue(ValidazioneBusteTipoControllo valore) {
        if (valore == null) {
            return null;
        }
        return valore.getValue();
    }

    public static String getValue(AlgoritmoCache valore) {
        if (valore == null) {
            return null;
        }
        return valore.getValue();
    }

    public static String getValue(GestioneErroreComportamento valore) {
        if (valore == null) {
            return null;
        }
        return valore.getValue();
    }

    public static String getValue(TipoConnessioneRisposte valore) {
        if (valore == null) {
            return null;
        }
        return valore.getValue();
    }

    public static StatoFunzionalita getEnumStatoFunzionalita(String value) {
        if (value == null) {
            return null;
        }
        return StatoFunzionalita.toEnumConstant(value);
    }

    public static StatoFunzionalitaConWarning getEnumStatoFunzionalitaConWarning(String value) {
        if (value == null) {
            return null;
        }
        return StatoFunzionalitaConWarning.toEnumConstant(value);
    }

    public static MTOMProcessorType getEnumMTOMProcessorType(String value) {
        if (value == null) {
            return null;
        }
        return MTOMProcessorType.toEnumConstant(value);
    }

    public static ValidazioneContenutiApplicativiTipo getEnumValidazioneContenutiApplicativiTipo(String value) {
        if (value == null) {
            return null;
        }
        return ValidazioneContenutiApplicativiTipo.toEnumConstant(value);
    }

    public static CorrelazioneApplicativaRichiestaIdentificazione getEnumCorrelazioneApplicativaRichiestaIdentificazione(String value) {
        if (value == null) {
            return null;
        }
        return CorrelazioneApplicativaRichiestaIdentificazione.toEnumConstant(value);
    }

    public static CorrelazioneApplicativaRispostaIdentificazione getEnumCorrelazioneApplicativaRispostaIdentificazione(String value) {
        if (value == null) {
            return null;
        }
        return CorrelazioneApplicativaRispostaIdentificazione.toEnumConstant(value);
    }

    public static CorrelazioneApplicativaGestioneIdentificazioneFallita getEnumCorrelazioneApplicativaGestioneIdentificazioneFallita(String value) {
        if (value == null) {
            return null;
        }
        return CorrelazioneApplicativaGestioneIdentificazioneFallita.toEnumConstant(value);
    }

    public static InvocazioneServizioTipoAutenticazione getEnumInvocazioneServizioTipoAutenticazione(String value) {
        if (value == null) {
            return null;
        }
        return InvocazioneServizioTipoAutenticazione.toEnumConstant(value);
    }

    public static FaultIntegrazioneTipo getEnumFaultIntegrazioneTipo(String value) {
        if (value == null) {
            return null;
        }
        return FaultIntegrazioneTipo.toEnumConstant(value);
    }

    public static CredenzialeTipo getEnumCredenzialeTipo(String value) {
        if (value == null) {
            return null;
        }
        return CredenzialeTipo.toEnumConstant(value);
    }

    public static ProprietaProtocolloValore getEnumProprietaProtocolloValore(String value) {
        if (value == null) {
            return null;
        }
        return ProprietaProtocolloValore.toEnumConstant(value);
    }

    public static Severita getEnumSeverita(String value) {
        if (value == null) {
            return null;
        }
        return Severita.toEnumConstant(value);
    }

    public static ValidazioneBusteTipoControllo getEnumValidazioneBusteTipoControllo(String value) {
        if (value == null) {
            return null;
        }
        return ValidazioneBusteTipoControllo.toEnumConstant(value);
    }

    public static AlgoritmoCache getEnumAlgoritmoCache(String value) {
        if (value == null) {
            return null;
        }
        return AlgoritmoCache.toEnumConstant(value);
    }

    public static GestioneErroreComportamento getEnumGestioneErroreComportamento(String value) {
        if (value == null) {
            return null;
        }
        return GestioneErroreComportamento.toEnumConstant(value);
    }

    public static TipoConnessioneRisposte getEnumTipoConnessioneRisposte(String value) {
        if (value == null) {
            return null;
        }
        return TipoConnessioneRisposte.toEnumConstant(value);
    }

    public static String formatSQLString(String sql, Object ... params) {
        String res = sql;
        for (int i = 0; i < params.length; ++i) {
            res = res.replaceFirst("\\?", "{" + i + "}");
        }
        return MessageFormat.format(res, params);
    }

    public static long CRUDSoggetto(int type, Soggetto soggetto, Connection con) throws DriverConfigurazioneException {
        long sqlQueryObject2;
        if (soggetto == null) {
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB_LIB::CRUDSoggetto] Parametro non valido.");
        }
        String nome = soggetto.getNome();
        String tipo = soggetto.getTipo();
        if (nome == null || nome.equals("")) {
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB_LIB::CRUDSoggetto] Parametro Nome non valido.");
        }
        if (tipo == null || tipo.equals("")) {
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB_LIB::CRUDSoggetto] Parametro Tipo non valido.");
        }
        String descrizione = soggetto.getDescrizione();
        String identificativoPorta = soggetto.getIdentificativoPorta();
        String superuser = soggetto.getSuperUser();
        boolean router = soggetto.getRouter();
        String pdUrlPrefixRewriter = soggetto.getPdUrlPrefixRewriter();
        String paUrlPrefixRewriter = soggetto.getPaUrlPrefixRewriter();
        Statement updateStmt = null;
        PreparedStatement selectStmt = null;
        String updateQuery = "";
        String selectQuery = "";
        ResultSet selectRS = null;
        int n = 0;
        try {
            switch (type) {
                case 1: {
                    ISQLQueryObject sqlQueryObject2 = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                    sqlQueryObject2.addInsertTable(tabellaSoggetti);
                    sqlQueryObject2.addInsertField("nome_soggetto", "?");
                    sqlQueryObject2.addInsertField("descrizione", "?");
                    sqlQueryObject2.addInsertField("identificativo_porta", "?");
                    sqlQueryObject2.addInsertField("tipo_soggetto", "?");
                    sqlQueryObject2.addInsertField("is_router", "?");
                    sqlQueryObject2.addInsertField("superuser", "?");
                    sqlQueryObject2.addInsertField("pd_url_prefix_rewriter", "?");
                    sqlQueryObject2.addInsertField("pa_url_prefix_rewriter", "?");
                    updateQuery = sqlQueryObject2.createSQLInsert();
                    updateStmt = con.prepareStatement(updateQuery);
                    updateStmt.setString(1, nome);
                    updateStmt.setString(2, descrizione);
                    updateStmt.setString(3, identificativoPorta);
                    updateStmt.setString(4, tipo);
                    updateStmt.setInt(5, router ? 1 : 0);
                    updateStmt.setString(6, superuser);
                    updateStmt.setString(7, pdUrlPrefixRewriter);
                    updateStmt.setString(8, paUrlPrefixRewriter);
                    n = updateStmt.executeUpdate();
                    log.debug((Object)("CRUDSoggetto CREATE : \n" + DBUtils.formatSQLString(updateQuery, nome, descrizione, identificativoPorta, tipo, router, superuser)));
                    log.debug((Object)("CRUDSoggetto type = " + type + " row affected =" + n));
                    sqlQueryObject2 = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                    sqlQueryObject2.addFromTable(tabellaSoggetti);
                    sqlQueryObject2.addSelectField("id");
                    sqlQueryObject2.addWhereCondition("tipo_soggetto = ?");
                    sqlQueryObject2.addWhereCondition("nome_soggetto = ?");
                    sqlQueryObject2.setANDLogicOperator(true);
                    selectQuery = sqlQueryObject2.createSQLQuery();
                    selectStmt = con.prepareStatement(selectQuery);
                    selectStmt.setString(1, tipo);
                    selectStmt.setString(2, nome);
                    break;
                }
                case 2: {
                    String oldNomeSoggetto = soggetto.getOldNomeForUpdate();
                    String oldTipoSoggetto = soggetto.getOldTipoForUpdate();
                    if (oldNomeSoggetto == null || oldNomeSoggetto.equals("")) {
                        oldNomeSoggetto = nome;
                    }
                    if (oldTipoSoggetto == null || oldTipoSoggetto.equals("")) {
                        oldTipoSoggetto = tipo;
                    }
                    ISQLQueryObject sqlQueryObject2 = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                    sqlQueryObject2.addUpdateTable(tabellaSoggetti);
                    sqlQueryObject2.addUpdateField("nome_soggetto", "?");
                    sqlQueryObject2.addUpdateField("descrizione", "?");
                    sqlQueryObject2.addUpdateField("identificativo_porta", "?");
                    sqlQueryObject2.addUpdateField("tipo_soggetto", "?");
                    sqlQueryObject2.addUpdateField("is_router", "?");
                    sqlQueryObject2.addUpdateField("superuser", "?");
                    sqlQueryObject2.addUpdateField("pd_url_prefix_rewriter", "?");
                    sqlQueryObject2.addUpdateField("pa_url_prefix_rewriter", "?");
                    sqlQueryObject2.addWhereCondition("nome_soggetto=?");
                    sqlQueryObject2.addWhereCondition("tipo_soggetto=?");
                    sqlQueryObject2.setANDLogicOperator(true);
                    updateQuery = sqlQueryObject2.createSQLUpdate();
                    updateStmt = con.prepareStatement(updateQuery);
                    updateStmt.setString(1, nome);
                    updateStmt.setString(2, descrizione);
                    updateStmt.setString(3, identificativoPorta);
                    updateStmt.setString(4, tipo);
                    updateStmt.setInt(5, router ? 1 : 0);
                    updateStmt.setString(6, superuser);
                    updateStmt.setString(7, pdUrlPrefixRewriter);
                    updateStmt.setString(8, paUrlPrefixRewriter);
                    updateStmt.setString(9, oldNomeSoggetto);
                    updateStmt.setString(10, oldTipoSoggetto);
                    n = updateStmt.executeUpdate();
                    updateStmt.close();
                    log.debug((Object)("CRUDSoggetto UPDATE : \n" + DBUtils.formatSQLString(updateQuery, nome, descrizione, identificativoPorta, tipo, router, soggetto.getId())));
                    log.debug((Object)("CRUDSoggetto type = " + type + " row affected =" + n));
                    break;
                }
                case 3: {
                    ISQLQueryObject sqlQueryObject2 = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                    sqlQueryObject2.addDeleteTable(tabellaSoggetti);
                    sqlQueryObject2.addWhereCondition("nome_soggetto=?");
                    sqlQueryObject2.addWhereCondition("tipo_soggetto=?");
                    sqlQueryObject2.setANDLogicOperator(true);
                    updateQuery = sqlQueryObject2.createSQLDelete();
                    updateStmt = con.prepareStatement(updateQuery);
                    updateStmt.setString(1, soggetto.getNome());
                    updateStmt.setString(2, soggetto.getTipo());
                    n = updateStmt.executeUpdate();
                    updateStmt.close();
                    log.debug((Object)("CRUDSoggetto type = " + type + " row affected =" + n));
                    log.debug((Object)("CRUDSoggetto DELETE : \n" + DBUtils.formatSQLString(updateQuery, soggetto.getNome(), soggetto.getTipo())));
                }
            }
            if (type == 1 && (selectRS = selectStmt.executeQuery()).next()) {
                soggetto.setId(selectRS.getLong("id"));
                long sqlQueryObject2 = soggetto.getId();
                return sqlQueryObject2;
            }
            sqlQueryObject2 = n;
        }
        catch (SQLException se) {
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB_LIB::CRUDSoggetto] SQLException [" + se.getMessage() + "].", se);
        }
        catch (Exception se) {
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB_LIB::CRUDSoggetto] Exception [" + se.getMessage() + "].", se);
        }
        finally {
            try {
                if (selectRS != null) {
                    selectRS.close();
                }
                if (selectStmt != null) {
                    selectStmt.close();
                }
                if (updateStmt != null) {
                    updateStmt.close();
                }
            }
            catch (Exception e) {}
        }
        return sqlQueryObject2;
    }

    public static long CRUDConnettore(int type, Connettore connettore, Connection connection) throws DriverConfigurazioneException {
        Statement stm = null;
        ResultSet rs = null;
        if (connettore == null) {
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB_LIB::CRUDConnettore] L'oggetto Connettore non puo essere null");
        }
        if (type != 3 && (connettore.getNome() == null || connettore.getNome().trim().equals(""))) {
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB_LIB::CRUDConnettore]Il nome Connettore non puo essere null");
        }
        String nomeConnettore = connettore.getNome();
        String endpointtype = connettore.getTipo();
        if (endpointtype == null || endpointtype.trim().equals("")) {
            endpointtype = TipiConnettore.DISABILITATO.getNome();
        }
        String url = null;
        boolean debug = false;
        String nome = null;
        String tipo = null;
        String utente = null;
        String password = null;
        String initcont = null;
        String urlpkg = null;
        String provurl = null;
        String connectionfactory = null;
        String sendas = null;
        boolean isAbilitato = false;
        Hashtable<String, String> extendedProperties = new Hashtable<String, String>();
        String nomeProperty = null;
        String valoreProperty = null;
        for (int i = 0; i < connettore.sizePropertyList(); ++i) {
            nomeProperty = connettore.getProperty(i).getNome();
            valoreProperty = connettore.getProperty(i).getValore();
            if (valoreProperty != null && valoreProperty.equals("")) {
                valoreProperty = null;
            }
            if (nomeProperty.equals("debug") && "true".equals(valoreProperty)) {
                debug = true;
            }
            if (TipiConnettore.HTTP.getNome().equals(endpointtype)) {
                if (nomeProperty.equals("location")) {
                    url = valoreProperty;
                }
            } else if (TipiConnettore.JMS.getNome().equals(endpointtype)) {
                if (nomeProperty.equals("location")) {
                    nome = valoreProperty;
                } else if (nomeProperty.equals("tipo")) {
                    tipo = valoreProperty;
                } else if (nomeProperty.equals("user")) {
                    utente = valoreProperty;
                } else if (nomeProperty.equals("password")) {
                    password = valoreProperty;
                } else if (nomeProperty.equals("context-java.naming.factory.initial")) {
                    initcont = valoreProperty;
                } else if (nomeProperty.equals("context-java.naming.factory.url.pkgs")) {
                    urlpkg = valoreProperty;
                } else if (nomeProperty.equals("context-java.naming.provider.url")) {
                    provurl = valoreProperty;
                } else if (nomeProperty.equals("connection-factory")) {
                    connectionfactory = valoreProperty;
                } else if (nomeProperty.equals("send-as")) {
                    sendas = valoreProperty;
                }
            }
            if (!endpointtype.equalsIgnoreCase(TipiConnettore.DISABILITATO.getNome())) {
                isAbilitato = true;
            }
            if (!nomeProperty.startsWith("-#ext#-")) continue;
            extendedProperties.put(nomeProperty, valoreProperty);
        }
        try {
            long idConnettore = 0L;
            int n = 0;
            switch (type) {
                case 1: {
                    ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                    sqlQueryObject.addInsertTable("connettori");
                    sqlQueryObject.addInsertField("endpointtype", "?");
                    sqlQueryObject.addInsertField("url", "?");
                    sqlQueryObject.addInsertField("nome", "?");
                    sqlQueryObject.addInsertField("tipo", "?");
                    sqlQueryObject.addInsertField("utente", "?");
                    sqlQueryObject.addInsertField("password", "?");
                    sqlQueryObject.addInsertField("initcont", "?");
                    sqlQueryObject.addInsertField("urlpkg", "?");
                    sqlQueryObject.addInsertField("provurl", "?");
                    sqlQueryObject.addInsertField("connection_factory", "?");
                    sqlQueryObject.addInsertField("send_as", "?");
                    sqlQueryObject.addInsertField("nome_connettore", "?");
                    sqlQueryObject.addInsertField("debug", "?");
                    sqlQueryObject.addInsertField("custom", "?");
                    String sqlQuery = sqlQueryObject.createSQLInsert();
                    stm = connection.prepareStatement(sqlQuery);
                    stm.setString(1, endpointtype);
                    stm.setString(2, isAbilitato ? url : null);
                    stm.setString(3, isAbilitato ? nome : null);
                    stm.setString(4, isAbilitato ? tipo : null);
                    stm.setString(5, isAbilitato ? utente : null);
                    stm.setString(6, isAbilitato ? password : null);
                    stm.setString(7, isAbilitato ? initcont : null);
                    stm.setString(8, isAbilitato ? urlpkg : null);
                    stm.setString(9, isAbilitato ? provurl : null);
                    stm.setString(10, isAbilitato ? connectionfactory : null);
                    stm.setString(11, isAbilitato ? sendas : null);
                    stm.setString(12, nomeConnettore);
                    if (debug) {
                        stm.setInt(13, 1);
                    } else {
                        stm.setInt(13, 0);
                    }
                    if (connettore.getCustom() != null && connettore.getCustom().booleanValue()) {
                        stm.setInt(14, 1);
                    } else {
                        stm.setInt(14, 0);
                    }
                    log.debug((Object)("CRUDConnettore CREATE : \n" + DBUtils.formatSQLString(sqlQuery, endpointtype, url, nome, tipo, utente, password, initcont, urlpkg, provurl, connectionfactory, sendas, nomeConnettore, debug, connettore.getCustom() != null && connettore.getCustom() != false)));
                    n = stm.executeUpdate();
                    stm.close();
                    log.debug((Object)("Inserted " + n + " row(s)"));
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                    sqlQueryObject.addFromTable("connettori");
                    sqlQueryObject.addSelectField("*");
                    sqlQueryObject.addWhereCondition("endpointtype = ?");
                    sqlQueryObject.addWhereCondition("nome_connettore = ?");
                    sqlQueryObject.setANDLogicOperator(true);
                    sqlQuery = sqlQueryObject.createSQLQuery();
                    stm = connection.prepareStatement(sqlQuery);
                    stm.setString(1, endpointtype);
                    stm.setString(2, nomeConnettore);
                    log.debug((Object)("Recupero idConnettore inserito : \n" + DBUtils.formatSQLString(sqlQuery, endpointtype, nomeConnettore)));
                    rs = stm.executeQuery();
                    if (!rs.next()) {
                        throw new DriverConfigurazioneException("[DriverConfigurazioneDB_LIB::CRUDConnettore] Errore tentanto di effettuare la select dopo una create, non riesco a recuperare l'id!");
                    }
                    idConnettore = rs.getLong("id");
                    connettore.setId(idConnettore);
                    rs.close();
                    stm.close();
                    if (connettore.getCustom() != null && connettore.getCustom().booleanValue()) {
                        sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                        sqlQueryObject.addInsertTable("connettori_custom");
                        sqlQueryObject.addInsertField("name", "?");
                        sqlQueryObject.addInsertField("value", "?");
                        sqlQueryObject.addInsertField("id_connettore", "?");
                        sqlQuery = sqlQueryObject.createSQLInsert();
                        for (int i = 0; i < connettore.sizePropertyList(); ++i) {
                            nomeProperty = connettore.getProperty(i).getNome();
                            valoreProperty = connettore.getProperty(i).getValore();
                            if (valoreProperty != null && valoreProperty.equals("")) {
                                valoreProperty = null;
                            }
                            if (valoreProperty == null) {
                                throw new Exception("Property [" + nomeProperty + "] without value");
                            }
                            stm = connection.prepareStatement(sqlQuery);
                            stm.setString(1, nomeProperty);
                            stm.setString(2, valoreProperty);
                            stm.setLong(3, connettore.getId());
                            stm.executeUpdate();
                            stm.close();
                        }
                    } else {
                        if (extendedProperties.size() <= 0) break;
                        sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                        sqlQueryObject.addInsertTable("connettori_custom");
                        sqlQueryObject.addInsertField("name", "?");
                        sqlQueryObject.addInsertField("value", "?");
                        sqlQueryObject.addInsertField("id_connettore", "?");
                        sqlQuery = sqlQueryObject.createSQLInsert();
                        Enumeration keys = extendedProperties.keys();
                        while (keys.hasMoreElements()) {
                            nomeProperty = (String)keys.nextElement();
                            valoreProperty = (String)extendedProperties.get(nomeProperty);
                            if (valoreProperty != null && valoreProperty.equals("")) {
                                valoreProperty = null;
                            }
                            if (valoreProperty == null) {
                                throw new Exception("Property [" + nomeProperty + "] without value");
                            }
                            stm = connection.prepareStatement(sqlQuery);
                            stm.setString(1, nomeProperty);
                            stm.setString(2, valoreProperty);
                            stm.setLong(3, connettore.getId());
                            stm.executeUpdate();
                            stm.close();
                        }
                    }
                    break;
                }
                case 2: {
                    idConnettore = connettore.getId();
                    if (idConnettore < 0L) {
                        throw new DriverConfigurazioneException("[DriverConfigurazioneDB_LIB::CRUDConnettore] L'id del connettore non puo essere 0 tentando di fare una operazione di update.");
                    }
                    ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                    sqlQueryObject.addUpdateTable("connettori");
                    sqlQueryObject.addUpdateField("endpointtype", "?");
                    sqlQueryObject.addUpdateField("url", "?");
                    sqlQueryObject.addUpdateField("nome", "?");
                    sqlQueryObject.addUpdateField("tipo", "?");
                    sqlQueryObject.addUpdateField("utente", "?");
                    sqlQueryObject.addUpdateField("password", "?");
                    sqlQueryObject.addUpdateField("initcont", "?");
                    sqlQueryObject.addUpdateField("urlpkg", "?");
                    sqlQueryObject.addUpdateField("provurl", "?");
                    sqlQueryObject.addUpdateField("connection_factory", "?");
                    sqlQueryObject.addUpdateField("send_as", "?");
                    sqlQueryObject.addUpdateField("nome_connettore", "?");
                    sqlQueryObject.addUpdateField("debug", "?");
                    sqlQueryObject.addUpdateField("custom", "?");
                    sqlQueryObject.addWhereCondition("id=?");
                    String sqlQuery = sqlQueryObject.createSQLUpdate();
                    stm = connection.prepareStatement(sqlQuery);
                    stm.setString(1, endpointtype);
                    stm.setString(2, url);
                    stm.setString(3, nome);
                    stm.setString(4, tipo);
                    stm.setString(5, utente);
                    stm.setString(6, password);
                    stm.setString(7, initcont);
                    stm.setString(8, urlpkg);
                    stm.setString(9, provurl);
                    stm.setString(10, connectionfactory);
                    stm.setString(11, sendas);
                    stm.setString(12, nomeConnettore);
                    if (debug) {
                        stm.setInt(13, 1);
                    } else {
                        stm.setInt(13, 0);
                    }
                    if (connettore.getCustom() != null && connettore.getCustom().booleanValue()) {
                        stm.setInt(14, 1);
                    } else {
                        stm.setInt(14, 0);
                    }
                    stm.setLong(15, idConnettore);
                    stm.executeUpdate();
                    stm.close();
                    log.debug((Object)("CRUDConnettore UPDATE : \n" + DBUtils.formatSQLString(sqlQuery, endpointtype, url, nome, tipo, utente, password, initcont, urlpkg, provurl, connectionfactory, sendas, nomeConnettore, debug, connettore.getCustom() != null && connettore.getCustom() != false, idConnettore)));
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                    sqlQueryObject.addDeleteTable("connettori_custom");
                    sqlQueryObject.addWhereCondition("id_connettore=?");
                    sqlQuery = sqlQueryObject.createSQLDelete();
                    stm = connection.prepareStatement(sqlQuery);
                    stm.setLong(1, idConnettore);
                    stm.executeUpdate();
                    stm.close();
                    if (connettore.getCustom() != null && connettore.getCustom().booleanValue()) {
                        sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                        sqlQueryObject.addInsertTable("connettori_custom");
                        sqlQueryObject.addInsertField("name", "?");
                        sqlQueryObject.addInsertField("value", "?");
                        sqlQueryObject.addInsertField("id_connettore", "?");
                        sqlQuery = sqlQueryObject.createSQLInsert();
                        for (int i = 0; i < connettore.sizePropertyList(); ++i) {
                            nomeProperty = connettore.getProperty(i).getNome();
                            valoreProperty = connettore.getProperty(i).getValore();
                            if (valoreProperty != null && valoreProperty.equals("")) {
                                valoreProperty = null;
                            }
                            if (valoreProperty == null) {
                                throw new Exception("Property [" + nomeProperty + "] without value");
                            }
                            stm = connection.prepareStatement(sqlQuery);
                            stm.setString(1, nomeProperty);
                            stm.setString(2, valoreProperty);
                            stm.setLong(3, idConnettore);
                            stm.executeUpdate();
                            stm.close();
                        }
                    } else {
                        if (extendedProperties.size() <= 0) break;
                        sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                        sqlQueryObject.addInsertTable("connettori_custom");
                        sqlQueryObject.addInsertField("name", "?");
                        sqlQueryObject.addInsertField("value", "?");
                        sqlQueryObject.addInsertField("id_connettore", "?");
                        sqlQuery = sqlQueryObject.createSQLInsert();
                        Enumeration keys = extendedProperties.keys();
                        while (keys.hasMoreElements()) {
                            nomeProperty = (String)keys.nextElement();
                            valoreProperty = (String)extendedProperties.get(nomeProperty);
                            if (valoreProperty != null && valoreProperty.equals("")) {
                                valoreProperty = null;
                            }
                            if (valoreProperty == null) {
                                throw new Exception("Property [" + nomeProperty + "] without value");
                            }
                            stm = connection.prepareStatement(sqlQuery);
                            stm.setString(1, nomeProperty);
                            stm.setString(2, valoreProperty);
                            stm.setLong(3, idConnettore);
                            stm.executeUpdate();
                            stm.close();
                        }
                    }
                    break;
                }
                case 3: {
                    idConnettore = connettore.getId();
                    if (idConnettore < 0L) {
                        throw new DriverConfigurazioneException("[DriverConfigurazioneDB_LIB::CRUDConnettore] L'id del connettore non puo essere 0 tentando di fare una operazione di delete.");
                    }
                    ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                    sqlQueryObject.addDeleteTable("connettori_custom");
                    sqlQueryObject.addWhereCondition("id_connettore=?");
                    String sqlQuery = sqlQueryObject.createSQLDelete();
                    stm = connection.prepareStatement(sqlQuery);
                    stm.setLong(1, idConnettore);
                    stm.executeUpdate();
                    stm.close();
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                    sqlQueryObject.addDeleteTable("connettori");
                    sqlQueryObject.addWhereCondition("id=?");
                    sqlQuery = sqlQueryObject.createSQLDelete();
                    stm = connection.prepareStatement(sqlQuery);
                    stm.setLong(1, idConnettore);
                    stm.executeUpdate();
                    stm.close();
                    log.debug((Object)("CRUDConnettore DELETE : \n" + DBUtils.formatSQLString(sqlQuery, idConnettore)));
                }
            }
            long l = idConnettore;
            return l;
        }
        catch (SQLException se) {
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB_LIB::CRUDConnettore] SQLException : " + se.getMessage(), se);
        }
        catch (Exception se) {
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB_LIB::CRUDConnettore] Exception : " + se.getMessage(), se);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception e) {}
        }
    }

    public static long CRUDPortaDelegata(int type, PortaDelegata aPD, Connection con) throws DriverConfigurazioneException {
        long idSoggettoProprietario;
        if (aPD == null) {
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB_LIB::CRUDPortaDelegata] Porta Delegata non valida.");
        }
        String nomePorta = aPD.getNome();
        String nomeProprietario = aPD.getNomeSoggettoProprietario();
        String tipoProprietario = aPD.getTipoSoggettoProprietario();
        if (nomePorta == null || nomePorta.equals("")) {
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB_LIB::CRUDPortaDelegata] Nome della Porta Delegata non valido.");
        }
        if (nomeProprietario == null || nomeProprietario.equals("")) {
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB_LIB::CRUDPortaDelegata] Nome proprietario Porta Delegata non valido.");
        }
        if (tipoProprietario == null || tipoProprietario.equals("")) {
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB_LIB::CRUDPortaDelegata] Tipo proprietario della Porta Delegata non valido.");
        }
        Statement stm = null;
        ResultSet rs = null;
        String autenticazione = aPD.getAutenticazione();
        String autorizzazione = aPD.getAutorizzazione();
        String autorizzazioneContenuto = aPD.getAutorizzazioneContenuto();
        String descrizione = aPD.getDescrizione();
        PortaDelegataAzione azione = aPD.getAzione();
        long idAzione = azione != null && azione.getId() != null ? azione.getId() : -1L;
        try {
            idSoggettoProprietario = DBUtils.getIdSoggetto(nomeProprietario, tipoProprietario, con, tipoDB, tabellaSoggetti);
        }
        catch (Exception e1) {
            throw new DriverConfigurazioneException(e1);
        }
        long idPortaDelegata = -1L;
        String location = aPD.getLocation();
        PortaDelegataServizio servizio = aPD.getServizio();
        long idServizioPD = servizio != null && servizio.getId() != null ? servizio.getId() : -1L;
        PortaDelegataSoggettoErogatore soggErogatore = aPD.getSoggettoErogatore();
        long idSoggettoErogatore = soggErogatore != null && soggErogatore.getId() != null ? soggErogatore.getId() : -1L;
        MtomProcessor mtomProcessor = aPD.getMtomProcessor();
        MTOMProcessorType mtomMode_request = null;
        MTOMProcessorType mtomMode_response = null;
        if (mtomProcessor != null) {
            if (mtomProcessor.getRequestFlow() != null) {
                mtomMode_request = mtomProcessor.getRequestFlow().getMode();
            }
            if (mtomProcessor.getResponseFlow() != null) {
                mtomMode_response = mtomProcessor.getResponseFlow().getMode();
            }
        }
        MessageSecurity messageSecurity = aPD.getMessageSecurity();
        String messageSecurityStatus = aPD.getStatoMessageSecurity();
        StatoFunzionalita messageSecurityApplyMtom_request = null;
        StatoFunzionalita messageSecurityApplyMtom_response = null;
        if (messageSecurity != null) {
            if (messageSecurity.getRequestFlow() != null) {
                messageSecurityApplyMtom_request = messageSecurity.getRequestFlow().getApplyToMtom();
            }
            if (messageSecurity.getResponseFlow() != null) {
                messageSecurityApplyMtom_response = messageSecurity.getResponseFlow().getApplyToMtom();
            }
        }
        CorrelazioneApplicativa corrApp = aPD.getCorrelazioneApplicativa();
        CorrelazioneApplicativaRisposta corrAppRisposta = aPD.getCorrelazioneApplicativaRisposta();
        ExtendedInfoManager extInfoManager = ExtendedInfoManager.getInstance();
        IExtendedInfo extInfoConfigurazioneDriver = extInfoManager.newInstanceExtendedInfoPortaDelegata();
        ServizioApplicativo servizioApplicativo = null;
        try {
            int n = 0;
            int i = 0;
            switch (type) {
                case 1: {
                    BaseBean cae;
                    BaseBean flow;
                    BaseBean resParam;
                    BaseBean flow2;
                    BaseBean reqParam;
                    PortaDelegataAzioneIdentificazione modeAzione;
                    PortaDelegataServizioIdentificazione modeServizio;
                    PortaDelegataSoggettoErogatoreIdentificazione modeSoggettoErogatore;
                    String tipoSoggErogatore = soggErogatore != null ? soggErogatore.getTipo() : null;
                    String nomeSoggErogatore = soggErogatore != null ? soggErogatore.getNome() : null;
                    String patternErogatore = soggErogatore != null ? soggErogatore.getPattern() : null;
                    PortaDelegataSoggettoErogatoreIdentificazione portaDelegataSoggettoErogatoreIdentificazione = modeSoggettoErogatore = soggErogatore != null ? soggErogatore.getIdentificazione() : null;
                    if (modeSoggettoErogatore == null || modeSoggettoErogatore.equals("")) {
                        modeSoggettoErogatore = PortaDelegataSoggettoErogatoreIdentificazione.STATIC;
                    }
                    switch (modeSoggettoErogatore) {
                        case CONTENT_BASED: 
                        case URL_BASED: {
                            if (tipoSoggErogatore == null || tipoSoggErogatore.equals("")) {
                                throw new DriverConfigurazioneException("Tipo Soggetto Erogatore non impostato.");
                            }
                            if (patternErogatore == null || patternErogatore.equals("")) {
                                throw new DriverConfigurazioneException("Pattern Soggetto Erogatore non impostato.");
                            }
                            nomeSoggErogatore = null;
                            break;
                        }
                        case INPUT_BASED: {
                            if (tipoSoggErogatore != null && !tipoSoggErogatore.equals("")) break;
                            throw new DriverConfigurazioneException("Tipo Soggetto Erogatore non impostato.");
                        }
                        case STATIC: {
                            if (idSoggettoErogatore <= 0L) {
                                if (tipoSoggErogatore == null || tipoSoggErogatore.equals("")) {
                                    throw new DriverConfigurazioneException("Tipo Soggetto Erogatore non impostato.");
                                }
                                if (nomeSoggErogatore == null || nomeSoggErogatore.equals("")) {
                                    throw new DriverConfigurazioneException("Nome Soggetto Erogatore non impostato.");
                                }
                            }
                            patternErogatore = null;
                            break;
                        }
                    }
                    String tipoServizio = servizio != null ? servizio.getTipo() : null;
                    String nomeServizio = servizio != null ? servizio.getNome() : null;
                    String patternServizio = servizio != null ? servizio.getPattern() : null;
                    PortaDelegataServizioIdentificazione portaDelegataServizioIdentificazione = modeServizio = servizio != null ? servizio.getIdentificazione() : null;
                    if (modeServizio == null || modeServizio.equals("")) {
                        modeServizio = PortaDelegataServizioIdentificazione.STATIC;
                    }
                    switch (modeServizio) {
                        case CONTENT_BASED: 
                        case URL_BASED: {
                            if (tipoServizio == null || tipoServizio.equals("")) {
                                throw new DriverConfigurazioneException("Tipo Servizio non impostato.");
                            }
                            if (patternServizio == null || patternServizio.equals("")) {
                                throw new DriverConfigurazioneException("Pattern Servizio non impostato.");
                            }
                            nomeServizio = null;
                            break;
                        }
                        case INPUT_BASED: {
                            if (tipoServizio != null && !tipoServizio.equals("")) break;
                            throw new DriverConfigurazioneException("Tipo Servizio non impostato.");
                        }
                        case STATIC: {
                            if (idServizioPD <= 0L) {
                                if (tipoServizio == null || tipoServizio.equals("")) {
                                    throw new DriverConfigurazioneException("Tipo Servizio non impostato.");
                                }
                                if (nomeServizio == null || nomeServizio.equals("")) {
                                    throw new DriverConfigurazioneException("Nome Servizio non impostato.");
                                }
                            }
                            patternServizio = null;
                            break;
                        }
                    }
                    String nomeAzione = azione != null ? azione.getNome() : null;
                    String patternAzione = azione != null ? azione.getPattern() : null;
                    StatoFunzionalita forceWsdlBased = azione != null ? azione.getForceWsdlBased() : null;
                    PortaDelegataAzioneIdentificazione portaDelegataAzioneIdentificazione = modeAzione = azione != null ? azione.getIdentificazione() : null;
                    if (azione != null) {
                        if (modeAzione == null || modeAzione.equals("")) {
                            modeAzione = PortaDelegataAzioneIdentificazione.STATIC;
                        }
                        switch (modeAzione) {
                            case CONTENT_BASED: 
                            case URL_BASED: {
                                if (patternAzione == null || patternAzione.equals("")) {
                                    throw new DriverConfigurazioneException("Pattern Azione non impostato.");
                                }
                                nomeAzione = null;
                                break;
                            }
                            case INPUT_BASED: 
                            case SOAP_ACTION_BASED: 
                            case WSDL_BASED: {
                                break;
                            }
                            case STATIC: {
                                if (idAzione <= 0L && (nomeAzione == null || nomeAzione.equals(""))) {
                                    throw new DriverConfigurazioneException("Nome Azione non impostato.");
                                }
                                patternAzione = null;
                                break;
                            }
                        }
                    }
                    ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                    sqlQueryObject.addInsertTable("porte_delegate");
                    sqlQueryObject.addInsertField("nome_porta", "?");
                    sqlQueryObject.addInsertField("descrizione", "?");
                    sqlQueryObject.addInsertField("location", "?");
                    sqlQueryObject.addInsertField("id_soggetto_erogatore", "?");
                    sqlQueryObject.addInsertField("tipo_soggetto_erogatore", "?");
                    sqlQueryObject.addInsertField("nome_soggetto_erogatore", "?");
                    sqlQueryObject.addInsertField("mode_soggetto_erogatore", "?");
                    sqlQueryObject.addInsertField("id_servizio", "?");
                    sqlQueryObject.addInsertField("tipo_servizio", "?");
                    sqlQueryObject.addInsertField("nome_servizio", "?");
                    sqlQueryObject.addInsertField("mode_servizio", "?");
                    sqlQueryObject.addInsertField("id_azione", "?");
                    sqlQueryObject.addInsertField("nome_azione", "?");
                    sqlQueryObject.addInsertField("mode_azione", "?");
                    sqlQueryObject.addInsertField("force_wsdl_based_azione", "?");
                    sqlQueryObject.addInsertField("autenticazione", "?");
                    sqlQueryObject.addInsertField("autorizzazione", "?");
                    sqlQueryObject.addInsertField("autorizzazione_contenuto", "?");
                    sqlQueryObject.addInsertField("mtom_request_mode", "?");
                    sqlQueryObject.addInsertField("mtom_response_mode", "?");
                    sqlQueryObject.addInsertField("ws_security", "?");
                    sqlQueryObject.addInsertField("ws_security_mtom_req", "?");
                    sqlQueryObject.addInsertField("ws_security_mtom_res", "?");
                    sqlQueryObject.addInsertField("id_soggetto", "?");
                    sqlQueryObject.addInsertField("ricevuta_asincrona_sim", "?");
                    sqlQueryObject.addInsertField("ricevuta_asincrona_asim", "?");
                    sqlQueryObject.addInsertField("integrazione", "?");
                    sqlQueryObject.addInsertField("pattern_soggetto_erogatore", "?");
                    sqlQueryObject.addInsertField("pattern_servizio", "?");
                    sqlQueryObject.addInsertField("pattern_azione", "?");
                    sqlQueryObject.addInsertField("scadenza_correlazione_appl", "?");
                    sqlQueryObject.addInsertField("validazione_contenuti_stato", "?");
                    sqlQueryObject.addInsertField("validazione_contenuti_tipo", "?");
                    sqlQueryObject.addInsertField("validazione_contenuti_mtom", "?");
                    sqlQueryObject.addInsertField("allega_body", "?");
                    sqlQueryObject.addInsertField("scarta_body", "?");
                    sqlQueryObject.addInsertField("gestione_manifest", "?");
                    sqlQueryObject.addInsertField("stateless", "?");
                    sqlQueryObject.addInsertField("local_forward", "?");
                    sqlQueryObject.addInsertField("id_accordo", "?");
                    sqlQueryObject.addInsertField("id_port_type", "?");
                    String sqlQuery = sqlQueryObject.createSQLInsert();
                    stm = con.prepareStatement(sqlQuery);
                    int index = 1;
                    stm.setString(index++, nomePorta);
                    stm.setString(index++, descrizione);
                    stm.setString(index++, location);
                    stm.setLong(index++, idSoggettoErogatore);
                    stm.setString(index++, tipoSoggErogatore);
                    stm.setString(index++, nomeSoggErogatore);
                    stm.setString(index++, modeSoggettoErogatore.toString());
                    stm.setLong(index++, idServizioPD);
                    stm.setString(index++, tipoServizio);
                    stm.setString(index++, nomeServizio);
                    stm.setString(index++, modeServizio.toString());
                    stm.setLong(index++, idAzione);
                    stm.setString(index++, nomeAzione);
                    if (modeAzione != null) {
                        stm.setString(index++, modeAzione.toString());
                    } else {
                        stm.setString(index++, null);
                    }
                    stm.setString(index++, DriverConfigurazioneDB_LIB.getValue(forceWsdlBased));
                    stm.setString(index++, autenticazione);
                    stm.setString(index++, autorizzazione);
                    stm.setString(index++, autorizzazioneContenuto);
                    stm.setString(index++, DriverConfigurazioneDB_LIB.getValue(mtomMode_request));
                    stm.setString(index++, DriverConfigurazioneDB_LIB.getValue(mtomMode_response));
                    stm.setString(index++, messageSecurityStatus);
                    stm.setString(index++, DriverConfigurazioneDB_LIB.getValue(messageSecurityApplyMtom_request));
                    stm.setString(index++, DriverConfigurazioneDB_LIB.getValue(messageSecurityApplyMtom_response));
                    stm.setLong(index++, idSoggettoProprietario);
                    stm.setString(index++, DriverConfigurazioneDB_LIB.getValue(aPD.getRicevutaAsincronaSimmetrica()));
                    stm.setString(index++, DriverConfigurazioneDB_LIB.getValue(aPD.getRicevutaAsincronaAsimmetrica()));
                    stm.setString(index++, aPD.getIntegrazione());
                    stm.setString(index++, patternErogatore);
                    stm.setString(index++, patternServizio);
                    stm.setString(index++, patternAzione);
                    stm.setString(index++, aPD.getCorrelazioneApplicativa() != null ? aPD.getCorrelazioneApplicativa().getScadenza() : null);
                    stm.setString(index++, aPD.getValidazioneContenutiApplicativi() != null ? DriverConfigurazioneDB_LIB.getValue(aPD.getValidazioneContenutiApplicativi().getStato()) : null);
                    stm.setString(index++, aPD.getValidazioneContenutiApplicativi() != null ? DriverConfigurazioneDB_LIB.getValue(aPD.getValidazioneContenutiApplicativi().getTipo()) : null);
                    stm.setString(index++, aPD.getValidazioneContenutiApplicativi() != null ? DriverConfigurazioneDB_LIB.getValue(aPD.getValidazioneContenutiApplicativi().getAcceptMtomMessage()) : null);
                    stm.setString(index++, aPD != null ? DriverConfigurazioneDB_LIB.getValue(aPD.getAllegaBody()) : null);
                    stm.setString(index++, aPD != null ? DriverConfigurazioneDB_LIB.getValue(aPD.getScartaBody()) : null);
                    stm.setString(index++, aPD != null ? DriverConfigurazioneDB_LIB.getValue(aPD.getGestioneManifest()) : null);
                    stm.setString(index++, aPD != null ? DriverConfigurazioneDB_LIB.getValue(aPD.getStateless()) : null);
                    stm.setString(index++, aPD != null ? DriverConfigurazioneDB_LIB.getValue(aPD.getLocalForward()) : null);
                    stm.setLong(index++, aPD.getIdAccordo() != null ? aPD.getIdAccordo() : -1L);
                    stm.setLong(index++, aPD.getIdPortType() != null ? aPD.getIdPortType() : -1L);
                    log.debug((Object)("eseguo query: " + DBUtils.formatSQLString(sqlQuery, nomePorta, descrizione, location, idSoggettoErogatore, tipoSoggErogatore, nomeSoggErogatore, modeSoggettoErogatore, idServizioPD, tipoServizio, nomeServizio, modeServizio, idAzione, nomeAzione, modeAzione, autenticazione, autorizzazione, autorizzazioneContenuto, mtomMode_request, mtomMode_response, messageSecurityStatus, messageSecurityApplyMtom_request, messageSecurityApplyMtom_response, idSoggettoProprietario, aPD.getRicevutaAsincronaSimmetrica(), aPD.getRicevutaAsincronaAsimmetrica(), aPD.getIntegrazione(), patternErogatore, patternServizio, patternAzione, aPD.getCorrelazioneApplicativa() != null ? aPD.getCorrelazioneApplicativa().getScadenza() : null, aPD.getValidazioneContenutiApplicativi() != null ? aPD.getValidazioneContenutiApplicativi().getStato() : null, aPD.getValidazioneContenutiApplicativi() != null ? aPD.getValidazioneContenutiApplicativi().getTipo() : null, aPD.getValidazioneContenutiApplicativi() != null ? aPD.getValidazioneContenutiApplicativi().getAcceptMtomMessage() : null, aPD.getAllegaBody(), aPD.getScartaBody(), aPD.getGestioneManifest(), aPD.getStateless(), aPD.getLocalForward(), aPD.getIdAccordo(), aPD.getIdPortType())));
                    n = stm.executeUpdate();
                    stm.close();
                    log.debug((Object)("Inserted " + n + " row(s)."));
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                    sqlQueryObject.addFromTable("porte_delegate");
                    sqlQueryObject.addSelectField("id");
                    sqlQueryObject.addWhereCondition("id_soggetto = ?");
                    sqlQueryObject.addWhereCondition("nome_porta = ?");
                    sqlQueryObject.setANDLogicOperator(true);
                    sqlQuery = sqlQueryObject.createSQLQuery();
                    stm = con.prepareStatement(sqlQuery);
                    stm.setLong(1, idSoggettoProprietario);
                    stm.setString(2, nomePorta);
                    rs = stm.executeQuery();
                    if (!rs.next()) {
                        rs.close();
                        stm.close();
                        throw new DriverConfigurazioneException("[DriverConfigurazioneDB_LIB::CRUDPortaDelegata(CREATE)] Impossibile recuperare l'ID della PortaDelegata appena create.");
                    }
                    idPortaDelegata = rs.getLong("id");
                    aPD.setId(idPortaDelegata);
                    rs.close();
                    stm.close();
                    if (mtomProcessor != null) {
                        reqParam = null;
                        sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                        sqlQueryObject.addInsertTable("pd_mtom_request");
                        sqlQueryObject.addInsertField("id_porta", "?");
                        sqlQueryObject.addInsertField("nome", "?");
                        sqlQueryObject.addInsertField("pattern", "?");
                        sqlQueryObject.addInsertField("content_type", "?");
                        sqlQueryObject.addInsertField("required", "?");
                        sqlQuery = sqlQueryObject.createSQLInsert();
                        stm = con.prepareStatement(sqlQuery);
                        i = 0;
                        if (mtomProcessor.getRequestFlow() != null) {
                            flow2 = mtomProcessor.getRequestFlow();
                            for (i = 0; i < flow2.sizeParameterList(); ++i) {
                                reqParam = flow2.getParameter(i);
                                stm.setLong(1, idPortaDelegata);
                                stm.setString(2, reqParam.getNome());
                                stm.setString(3, reqParam.getPattern());
                                stm.setString(4, reqParam.getContentType());
                                stm.setInt(5, reqParam.getRequired() ? 1 : 0);
                                stm.executeUpdate();
                            }
                        }
                        stm.close();
                        log.debug((Object)("Inserted " + i + " mtom request flow con id=" + idPortaDelegata));
                        resParam = null;
                        sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                        sqlQueryObject.addInsertTable("pd_mtom_response");
                        sqlQueryObject.addInsertField("id_porta", "?");
                        sqlQueryObject.addInsertField("nome", "?");
                        sqlQueryObject.addInsertField("pattern", "?");
                        sqlQueryObject.addInsertField("content_type", "?");
                        sqlQueryObject.addInsertField("required", "?");
                        sqlQuery = sqlQueryObject.createSQLInsert();
                        stm = con.prepareStatement(sqlQuery);
                        i = 0;
                        if (mtomProcessor.getResponseFlow() != null) {
                            flow = mtomProcessor.getResponseFlow();
                            for (i = 0; i < flow.sizeParameterList(); ++i) {
                                resParam = flow.getParameter(i);
                                stm.setLong(1, idPortaDelegata);
                                stm.setString(2, resParam.getNome());
                                stm.setString(3, resParam.getPattern());
                                stm.setString(4, resParam.getContentType());
                                stm.setInt(5, resParam.getRequired() ? 1 : 0);
                                stm.executeUpdate();
                            }
                        }
                        stm.close();
                        log.debug((Object)("Inserted " + i + " mtom response flow con id=" + idPortaDelegata));
                    }
                    if (messageSecurity != null) {
                        reqParam = null;
                        sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                        sqlQueryObject.addInsertTable("pd_ws_request");
                        sqlQueryObject.addInsertField("id_porta", "?");
                        sqlQueryObject.addInsertField("nome", "?");
                        sqlQueryObject.addInsertField("valore", "?");
                        sqlQuery = sqlQueryObject.createSQLInsert();
                        stm = con.prepareStatement(sqlQuery);
                        i = 0;
                        if (messageSecurity.getRequestFlow() != null) {
                            flow2 = messageSecurity.getRequestFlow();
                            for (i = 0; i < flow2.sizeParameterList(); ++i) {
                                reqParam = flow2.getParameter(i);
                                stm.setLong(1, idPortaDelegata);
                                stm.setString(2, reqParam.getNome());
                                stm.setString(3, reqParam.getValore());
                                stm.executeUpdate();
                            }
                        }
                        stm.close();
                        log.debug((Object)("Inserted " + i + " request flow con id=" + idPortaDelegata));
                        resParam = null;
                        sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                        sqlQueryObject.addInsertTable("pd_ws_response");
                        sqlQueryObject.addInsertField("id_porta", "?");
                        sqlQueryObject.addInsertField("nome", "?");
                        sqlQueryObject.addInsertField("valore", "?");
                        sqlQuery = sqlQueryObject.createSQLInsert();
                        stm = con.prepareStatement(sqlQuery);
                        i = 0;
                        if (messageSecurity.getResponseFlow() != null) {
                            flow = messageSecurity.getResponseFlow();
                            for (i = 0; i < flow.sizeParameterList(); ++i) {
                                resParam = flow.getParameter(i);
                                stm.setLong(1, idPortaDelegata);
                                stm.setString(2, resParam.getNome());
                                stm.setString(3, resParam.getValore());
                                stm.executeUpdate();
                            }
                        }
                        stm.close();
                        log.debug((Object)("Inserted " + i + " response flow con id=" + idPortaDelegata));
                    }
                    if (corrApp != null) {
                        cae = null;
                        sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                        sqlQueryObject.addInsertTable("pd_correlazione");
                        sqlQueryObject.addInsertField("id_porta", "?");
                        sqlQueryObject.addInsertField("nome_elemento", "?");
                        sqlQueryObject.addInsertField("mode_correlazione", "?");
                        sqlQueryObject.addInsertField("pattern", "?");
                        sqlQueryObject.addInsertField("identificazione_fallita", "?");
                        sqlQueryObject.addInsertField("riuso_id", "?");
                        sqlQuery = sqlQueryObject.createSQLInsert();
                        stm = con.prepareStatement(sqlQuery);
                        for (i = 0; i < corrApp.sizeElementoList(); ++i) {
                            cae = corrApp.getElemento(i);
                            stm.setLong(1, idPortaDelegata);
                            stm.setString(2, cae.getNome());
                            stm.setString(3, DriverConfigurazioneDB_LIB.getValue(cae.getIdentificazione()));
                            if (cae.getPattern() != null) {
                                stm.setString(4, cae.getPattern());
                            } else {
                                stm.setString(4, "");
                            }
                            stm.setString(5, DriverConfigurazioneDB_LIB.getValue(cae.getIdentificazioneFallita()));
                            stm.setString(6, DriverConfigurazioneDB_LIB.getValue(cae.getRiusoIdentificativo()));
                            stm.executeUpdate();
                        }
                        stm.close();
                        log.debug((Object)("Inserted " + i + " correlazione applicativa con id=" + idPortaDelegata));
                    }
                    if (corrAppRisposta != null) {
                        cae = null;
                        sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                        sqlQueryObject.addInsertTable("pd_correlazione_risposta");
                        sqlQueryObject.addInsertField("id_porta", "?");
                        sqlQueryObject.addInsertField("nome_elemento", "?");
                        sqlQueryObject.addInsertField("mode_correlazione", "?");
                        sqlQueryObject.addInsertField("pattern", "?");
                        sqlQueryObject.addInsertField("identificazione_fallita", "?");
                        sqlQuery = sqlQueryObject.createSQLInsert();
                        stm = con.prepareStatement(sqlQuery);
                        for (i = 0; i < corrAppRisposta.sizeElementoList(); ++i) {
                            cae = corrAppRisposta.getElemento(i);
                            stm.setLong(1, idPortaDelegata);
                            stm.setString(2, cae.getNome());
                            stm.setString(3, DriverConfigurazioneDB_LIB.getValue(cae.getIdentificazione()));
                            if (cae.getPattern() != null) {
                                stm.setString(4, cae.getPattern());
                            } else {
                                stm.setString(4, "");
                            }
                            stm.setString(5, DriverConfigurazioneDB_LIB.getValue(cae.getIdentificazioneFallita()));
                            stm.executeUpdate();
                        }
                        stm.close();
                        log.debug((Object)("Inserted " + i + " correlazione applicativa risposta con id=" + idPortaDelegata));
                    }
                    servizioApplicativo = null;
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                    sqlQueryObject.addInsertTable("porte_delegate_sa");
                    sqlQueryObject.addInsertField("id_porta", "?");
                    sqlQueryObject.addInsertField("id_servizio_applicativo", "?");
                    sqlQuery = sqlQueryObject.createSQLInsert();
                    stm = con.prepareStatement(sqlQuery);
                    for (i = 0; i < aPD.sizeServizioApplicativoList(); ++i) {
                        servizioApplicativo = aPD.getServizioApplicativo(i);
                        String nomeSA = servizioApplicativo.getNome();
                        String nomeProprietarioSA = aPD.getNomeSoggettoProprietario();
                        String tipoProprietarioSA = aPD.getTipoSoggettoProprietario();
                        if (nomeSA == null || nomeSA.equals("")) {
                            throw new DriverConfigurazioneException("Nome del ServizioApplicativo associato non valido.");
                        }
                        if (nomeProprietarioSA == null || nomeProprietarioSA.equals("")) {
                            throw new DriverConfigurazioneException("Nome Proprietario del ServizioApplicativo associato non valido.");
                        }
                        if (tipoProprietarioSA == null || tipoProprietarioSA.equals("")) {
                            throw new DriverConfigurazioneException("Tipo Proprietario del ServizioApplicativo associato non valido.");
                        }
                        long idSA = DriverConfigurazioneDB_LIB.getIdServizioApplicativo(nomeSA, tipoProprietarioSA, nomeProprietarioSA, con, tipoDB, tabellaSoggetti);
                        if (idSA <= 0L) {
                            throw new DriverConfigurazioneException("Impossibile recuperare l'id del Servizio Applicativo [" + nomeSA + "] di [" + tipoProprietarioSA + "/" + nomeProprietarioSA + "]");
                        }
                        stm.setLong(1, idPortaDelegata);
                        stm.setLong(2, idSA);
                        stm.executeUpdate();
                    }
                    stm.close();
                    log.debug((Object)("Insererted " + i + " associazioni ServizioApplicativo<->PortaDelegata associati alla PortaDelegata[" + idPortaDelegata + "]"));
                    i = 0;
                    if (aPD.sizeExtendedInfoList() > 0 && extInfoConfigurazioneDriver != null) {
                        for (i = 0; i < aPD.sizeExtendedInfoList(); ++i) {
                            extInfoConfigurazioneDriver.createExtendedInfo(con, log, aPD, aPD.getExtendedInfo(i));
                        }
                    }
                    log.debug((Object)("Insererted " + i + " associazioni ExtendedInfo<->PortaDelegata associati alla PortaDelegata[" + idPortaDelegata + "]"));
                    break;
                }
                case 2: {
                    BaseBean cae;
                    BaseBean flow;
                    BaseBean resParam;
                    BaseBean flow3;
                    BaseBean reqParam;
                    StatoFunzionalita forceWsdlBased;
                    PortaDelegataServizioIdentificazione modeServizio;
                    PortaDelegataSoggettoErogatoreIdentificazione modeSoggettoErogatore;
                    String tipoSoggErogatore = soggErogatore != null ? soggErogatore.getTipo() : null;
                    String nomeSoggErogatore = soggErogatore != null ? soggErogatore.getNome() : null;
                    String patternErogatore = soggErogatore != null ? soggErogatore.getPattern() : null;
                    PortaDelegataSoggettoErogatoreIdentificazione portaDelegataSoggettoErogatoreIdentificazione = modeSoggettoErogatore = soggErogatore != null ? soggErogatore.getIdentificazione() : null;
                    if (modeSoggettoErogatore == null || modeSoggettoErogatore.equals("")) {
                        modeSoggettoErogatore = PortaDelegataSoggettoErogatoreIdentificazione.STATIC;
                    }
                    switch (modeSoggettoErogatore) {
                        case CONTENT_BASED: 
                        case URL_BASED: {
                            if (tipoSoggErogatore == null || tipoSoggErogatore.equals("")) {
                                throw new DriverConfigurazioneException("Tipo Soggetto Erogatore non impostato.");
                            }
                            if (patternErogatore == null || patternErogatore.equals("")) {
                                throw new DriverConfigurazioneException("Pattern Soggetto Erogatore non impostato.");
                            }
                            nomeSoggErogatore = null;
                            break;
                        }
                        case INPUT_BASED: {
                            if (tipoSoggErogatore != null && !tipoSoggErogatore.equals("")) break;
                            throw new DriverConfigurazioneException("Tipo Soggetto Erogatore non impostato.");
                        }
                        case STATIC: {
                            if (idSoggettoErogatore <= 0L) {
                                if (tipoSoggErogatore == null || tipoSoggErogatore.equals("")) {
                                    throw new DriverConfigurazioneException("Tipo Soggetto Erogatore non impostato.");
                                }
                                if (nomeSoggErogatore == null || nomeSoggErogatore.equals("")) {
                                    throw new DriverConfigurazioneException("Nome Soggetto Erogatore non impostato.");
                                }
                            }
                            patternErogatore = null;
                            break;
                        }
                    }
                    String tipoServizio = servizio != null ? servizio.getTipo() : null;
                    String nomeServizio = servizio != null ? servizio.getNome() : null;
                    String patternServizio = servizio != null ? servizio.getPattern() : null;
                    PortaDelegataServizioIdentificazione portaDelegataServizioIdentificazione = modeServizio = servizio != null ? servizio.getIdentificazione() : null;
                    if (modeServizio == null || modeServizio.equals("")) {
                        modeServizio = PortaDelegataServizioIdentificazione.STATIC;
                    }
                    switch (modeServizio) {
                        case CONTENT_BASED: 
                        case URL_BASED: {
                            if (tipoServizio == null || tipoServizio.equals("")) {
                                throw new DriverConfigurazioneException("Tipo Servizio non impostato.");
                            }
                            if (patternServizio == null || patternServizio.equals("")) {
                                throw new DriverConfigurazioneException("Pattern Servizio non impostato.");
                            }
                            nomeServizio = null;
                            break;
                        }
                        case INPUT_BASED: {
                            if (tipoServizio != null && !tipoServizio.equals("")) break;
                            throw new DriverConfigurazioneException("Tipo Servizio non impostato.");
                        }
                        case STATIC: {
                            if (idServizioPD <= 0L) {
                                if (tipoServizio == null || tipoServizio.equals("")) {
                                    throw new DriverConfigurazioneException("Tipo Servizio non impostato.");
                                }
                                if (nomeServizio == null || nomeServizio.equals("")) {
                                    throw new DriverConfigurazioneException("Nome Servizio non impostato.");
                                }
                            }
                            patternServizio = null;
                            break;
                        }
                    }
                    String nomeAzione = azione != null ? azione.getNome() : null;
                    String patternAzione = azione != null ? azione.getPattern() : null;
                    PortaDelegataAzioneIdentificazione modeAzione = azione != null ? azione.getIdentificazione() : null;
                    StatoFunzionalita statoFunzionalita = forceWsdlBased = azione != null ? azione.getForceWsdlBased() : null;
                    if (azione != null) {
                        if (modeAzione == null || modeAzione.equals("")) {
                            modeAzione = PortaDelegataAzioneIdentificazione.STATIC;
                        }
                        switch (modeAzione) {
                            case CONTENT_BASED: 
                            case URL_BASED: {
                                if (patternAzione == null || patternAzione.equals("")) {
                                    throw new DriverConfigurazioneException("Pattern Azione non impostato.");
                                }
                                nomeAzione = null;
                                break;
                            }
                            case INPUT_BASED: 
                            case SOAP_ACTION_BASED: 
                            case WSDL_BASED: {
                                break;
                            }
                            case STATIC: {
                                if (idAzione <= 0L && (nomeAzione == null || nomeAzione.equals(""))) {
                                    throw new DriverConfigurazioneException("Nome Azione non impostato.");
                                }
                                patternAzione = null;
                                break;
                            }
                        }
                    }
                    String oldNomePD = aPD.getOldNomeForUpdate();
                    String oldNomeProprietario = aPD.getOldNomeSoggettoProprietarioForUpdate();
                    String oldTipoProprietario = aPD.getOldTipoSoggettoProprietarioForUpdate();
                    log.debug((Object)("OLD-PD[" + oldNomePD + "] PD[" + nomePorta + "] OLD-TIPOS[" + oldTipoProprietario + "] TIPOS[" + tipoProprietario + "] OLD-NOMES[" + oldNomeProprietario + "] NOMES[" + nomeProprietario + "]"));
                    if (oldNomePD == null || oldNomePD.equals("")) {
                        log.debug((Object)("old nomePD is null, assegno: " + nomePorta));
                        oldNomePD = nomePorta;
                    }
                    if (oldNomeProprietario == null || oldNomeProprietario.equals("")) {
                        log.debug((Object)("oldNomeProprietario is null, assegno: " + nomeProprietario));
                        oldNomeProprietario = nomeProprietario;
                    }
                    if (oldTipoProprietario == null || oldTipoProprietario.equals("")) {
                        log.debug((Object)("oldTipoProprietario is null, assegno: " + tipoProprietario));
                        oldTipoProprietario = tipoProprietario;
                    }
                    if ((idPortaDelegata = DriverConfigurazioneDB_LIB.getIdPortaDelegata(oldNomePD, oldTipoProprietario, oldNomeProprietario, con, tipoDB, tabellaSoggetti)) <= 0L) {
                        idPortaDelegata = DriverConfigurazioneDB_LIB.getIdPortaDelegata(oldNomePD, tipoProprietario, nomeProprietario, con, tipoDB, tabellaSoggetti);
                    }
                    if (idPortaDelegata <= 0L) {
                        throw new DriverConfigurazioneException("[DriverConfigurazioneDB_LIB::CRUDPortaDelegata(UPDATE)] id porta delegata non trovato nome[" + oldNomePD + "] tipoProprietario[" + oldTipoProprietario + "] nomeProprietario[" + oldNomeProprietario + "]");
                    }
                    aPD.setId(idPortaDelegata);
                    long oldIdSoggettoProprietario = DBUtils.getIdSoggetto(oldNomeProprietario, oldTipoProprietario, con, tipoDB, tabellaSoggetti);
                    if (oldIdSoggettoProprietario <= 0L) {
                        oldIdSoggettoProprietario = DBUtils.getIdSoggetto(nomeProprietario, tipoProprietario, con, tipoDB, tabellaSoggetti);
                    }
                    if (oldIdSoggettoProprietario <= 0L) {
                        throw new DriverConfigurazioneException("Impossibile recuperare l'id del Soggetto Proprietario della Porta Delegata");
                    }
                    ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                    sqlQueryObject.addUpdateTable("porte_delegate");
                    sqlQueryObject.addUpdateField("nome_porta", "?");
                    sqlQueryObject.addUpdateField("descrizione", "?");
                    sqlQueryObject.addUpdateField("location", "?");
                    sqlQueryObject.addUpdateField("id_soggetto_erogatore", "?");
                    sqlQueryObject.addUpdateField("tipo_soggetto_erogatore", "?");
                    sqlQueryObject.addUpdateField("nome_soggetto_erogatore", "?");
                    sqlQueryObject.addUpdateField("mode_soggetto_erogatore", "?");
                    sqlQueryObject.addUpdateField("id_servizio", "?");
                    sqlQueryObject.addUpdateField("tipo_servizio", "?");
                    sqlQueryObject.addUpdateField("nome_servizio", "?");
                    sqlQueryObject.addUpdateField("mode_servizio", "?");
                    sqlQueryObject.addUpdateField("id_azione", "?");
                    sqlQueryObject.addUpdateField("nome_azione", "?");
                    sqlQueryObject.addUpdateField("mode_azione", "?");
                    sqlQueryObject.addUpdateField("force_wsdl_based_azione", "?");
                    sqlQueryObject.addUpdateField("autenticazione", "?");
                    sqlQueryObject.addUpdateField("autorizzazione", "?");
                    sqlQueryObject.addUpdateField("autorizzazione_contenuto", "?");
                    sqlQueryObject.addUpdateField("mtom_request_mode", "?");
                    sqlQueryObject.addUpdateField("mtom_response_mode", "?");
                    sqlQueryObject.addUpdateField("ws_security", "?");
                    sqlQueryObject.addUpdateField("ws_security_mtom_req", "?");
                    sqlQueryObject.addUpdateField("ws_security_mtom_res", "?");
                    sqlQueryObject.addUpdateField("id_soggetto", "?");
                    sqlQueryObject.addUpdateField("ricevuta_asincrona_sim", "?");
                    sqlQueryObject.addUpdateField("ricevuta_asincrona_asim", "?");
                    sqlQueryObject.addUpdateField("integrazione", "?");
                    sqlQueryObject.addUpdateField("pattern_soggetto_erogatore", "?");
                    sqlQueryObject.addUpdateField("pattern_servizio", "?");
                    sqlQueryObject.addUpdateField("pattern_azione", "?");
                    sqlQueryObject.addUpdateField("scadenza_correlazione_appl", "?");
                    sqlQueryObject.addUpdateField("validazione_contenuti_stato", "?");
                    sqlQueryObject.addUpdateField("validazione_contenuti_tipo", "?");
                    sqlQueryObject.addUpdateField("validazione_contenuti_mtom", "?");
                    sqlQueryObject.addUpdateField("allega_body", "?");
                    sqlQueryObject.addUpdateField("scarta_body", "?");
                    sqlQueryObject.addUpdateField("gestione_manifest", "?");
                    sqlQueryObject.addUpdateField("stateless", "?");
                    sqlQueryObject.addUpdateField("local_forward", "?");
                    sqlQueryObject.addUpdateField("id_accordo", "?");
                    sqlQueryObject.addUpdateField("id_port_type", "?");
                    sqlQueryObject.addWhereCondition("id=?");
                    sqlQueryObject.addWhereCondition("id_soggetto=?");
                    sqlQueryObject.setANDLogicOperator(true);
                    String sqlQuery = sqlQueryObject.createSQLUpdate();
                    stm = con.prepareStatement(sqlQuery);
                    int index = 1;
                    stm.setString(index++, nomePorta);
                    stm.setString(index++, descrizione);
                    stm.setString(index++, location);
                    stm.setLong(index++, idSoggettoErogatore);
                    stm.setString(index++, tipoSoggErogatore);
                    stm.setString(index++, nomeSoggErogatore);
                    stm.setString(index++, modeSoggettoErogatore.toString());
                    stm.setLong(index++, idServizioPD);
                    stm.setString(index++, tipoServizio);
                    stm.setString(index++, nomeServizio);
                    stm.setString(index++, modeServizio.toString());
                    stm.setLong(index++, idAzione);
                    stm.setString(index++, nomeAzione);
                    if (modeAzione != null) {
                        stm.setString(index++, modeAzione.toString());
                    } else {
                        stm.setString(index++, null);
                    }
                    stm.setString(index++, DriverConfigurazioneDB_LIB.getValue(forceWsdlBased));
                    stm.setString(index++, autenticazione);
                    stm.setString(index++, autorizzazione);
                    stm.setString(index++, autorizzazioneContenuto);
                    stm.setString(index++, DriverConfigurazioneDB_LIB.getValue(mtomMode_request));
                    stm.setString(index++, DriverConfigurazioneDB_LIB.getValue(mtomMode_response));
                    stm.setString(index++, messageSecurityStatus);
                    stm.setString(index++, DriverConfigurazioneDB_LIB.getValue(messageSecurityApplyMtom_request));
                    stm.setString(index++, DriverConfigurazioneDB_LIB.getValue(messageSecurityApplyMtom_response));
                    stm.setLong(index++, idSoggettoProprietario);
                    stm.setString(index++, DriverConfigurazioneDB_LIB.getValue(aPD.getRicevutaAsincronaSimmetrica()));
                    stm.setString(index++, DriverConfigurazioneDB_LIB.getValue(aPD.getRicevutaAsincronaAsimmetrica()));
                    stm.setString(index++, aPD.getIntegrazione());
                    stm.setString(index++, patternErogatore);
                    stm.setString(index++, patternServizio);
                    stm.setString(index++, patternAzione);
                    stm.setString(index++, aPD.getCorrelazioneApplicativa() != null ? aPD.getCorrelazioneApplicativa().getScadenza() : null);
                    stm.setString(index++, aPD.getValidazioneContenutiApplicativi() != null ? DriverConfigurazioneDB_LIB.getValue(aPD.getValidazioneContenutiApplicativi().getStato()) : null);
                    stm.setString(index++, aPD.getValidazioneContenutiApplicativi() != null ? DriverConfigurazioneDB_LIB.getValue(aPD.getValidazioneContenutiApplicativi().getTipo()) : null);
                    stm.setString(index++, aPD.getValidazioneContenutiApplicativi() != null ? DriverConfigurazioneDB_LIB.getValue(aPD.getValidazioneContenutiApplicativi().getAcceptMtomMessage()) : null);
                    stm.setString(index++, aPD != null ? DriverConfigurazioneDB_LIB.getValue(aPD.getAllegaBody()) : null);
                    stm.setString(index++, aPD != null ? DriverConfigurazioneDB_LIB.getValue(aPD.getScartaBody()) : null);
                    stm.setString(index++, aPD != null ? DriverConfigurazioneDB_LIB.getValue(aPD.getGestioneManifest()) : null);
                    stm.setString(index++, aPD != null ? DriverConfigurazioneDB_LIB.getValue(aPD.getStateless()) : null);
                    stm.setString(index++, aPD != null ? DriverConfigurazioneDB_LIB.getValue(aPD.getLocalForward()) : null);
                    stm.setLong(index++, aPD.getIdAccordo() != null ? aPD.getIdAccordo() : -1L);
                    stm.setLong(index++, aPD.getIdPortType() != null ? aPD.getIdPortType() : -1L);
                    stm.setLong(index++, idPortaDelegata);
                    stm.setLong(index++, oldIdSoggettoProprietario);
                    n = stm.executeUpdate();
                    stm.close();
                    log.debug((Object)("Updated " + n + " row(s)."));
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                    sqlQueryObject.addDeleteTable("pd_mtom_request");
                    sqlQueryObject.addWhereCondition("id_porta=?");
                    sqlQuery = sqlQueryObject.createSQLDelete();
                    stm = con.prepareStatement(sqlQuery);
                    stm.setLong(1, idPortaDelegata);
                    stm.executeUpdate();
                    stm.close();
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                    sqlQueryObject.addDeleteTable("pd_mtom_response");
                    sqlQueryObject.addWhereCondition("id_porta=?");
                    sqlQuery = sqlQueryObject.createSQLDelete();
                    stm = con.prepareStatement(sqlQuery);
                    stm.setLong(1, idPortaDelegata);
                    stm.executeUpdate();
                    stm.close();
                    if (mtomProcessor != null) {
                        reqParam = null;
                        sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                        sqlQueryObject.addInsertTable("pd_mtom_request");
                        sqlQueryObject.addInsertField("id_porta", "?");
                        sqlQueryObject.addInsertField("nome", "?");
                        sqlQueryObject.addInsertField("pattern", "?");
                        sqlQueryObject.addInsertField("content_type", "?");
                        sqlQueryObject.addInsertField("required", "?");
                        sqlQuery = sqlQueryObject.createSQLInsert();
                        stm = con.prepareStatement(sqlQuery);
                        i = 0;
                        if (mtomProcessor.getRequestFlow() != null) {
                            flow3 = mtomProcessor.getRequestFlow();
                            for (i = 0; i < flow3.sizeParameterList(); ++i) {
                                reqParam = flow3.getParameter(i);
                                stm.setLong(1, idPortaDelegata);
                                stm.setString(2, reqParam.getNome());
                                stm.setString(3, reqParam.getPattern());
                                stm.setString(4, reqParam.getContentType());
                                stm.setInt(5, reqParam.getRequired() ? 1 : 0);
                                stm.executeUpdate();
                            }
                        }
                        stm.close();
                        log.debug((Object)("Inserted " + i + " mtom request flow con id=" + idPortaDelegata));
                        resParam = null;
                        sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                        sqlQueryObject.addInsertTable("pd_mtom_response");
                        sqlQueryObject.addInsertField("id_porta", "?");
                        sqlQueryObject.addInsertField("nome", "?");
                        sqlQueryObject.addInsertField("pattern", "?");
                        sqlQueryObject.addInsertField("content_type", "?");
                        sqlQueryObject.addInsertField("required", "?");
                        sqlQuery = sqlQueryObject.createSQLInsert();
                        stm = con.prepareStatement(sqlQuery);
                        i = 0;
                        if (mtomProcessor.getResponseFlow() != null) {
                            flow = mtomProcessor.getResponseFlow();
                            for (i = 0; i < flow.sizeParameterList(); ++i) {
                                resParam = flow.getParameter(i);
                                stm.setLong(1, idPortaDelegata);
                                stm.setString(2, resParam.getNome());
                                stm.setString(3, resParam.getPattern());
                                stm.setString(4, resParam.getContentType());
                                stm.setInt(5, resParam.getRequired() ? 1 : 0);
                                stm.executeUpdate();
                            }
                        }
                        stm.close();
                        log.debug((Object)("Inserted " + i + " mtom response flow con id=" + idPortaDelegata));
                    }
                    if (messageSecurity != null) {
                        sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                        sqlQueryObject.addDeleteTable("pd_ws_request");
                        sqlQueryObject.addWhereCondition("id_porta=?");
                        sqlQuery = sqlQueryObject.createSQLDelete();
                        stm = con.prepareStatement(sqlQuery);
                        stm.setLong(1, idPortaDelegata);
                        stm.executeUpdate();
                        stm.close();
                        sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                        sqlQueryObject.addDeleteTable("pd_ws_response");
                        sqlQueryObject.addWhereCondition("id_porta=?");
                        sqlQuery = sqlQueryObject.createSQLDelete();
                        stm = con.prepareStatement(sqlQuery);
                        stm.setLong(1, idPortaDelegata);
                        stm.executeUpdate();
                        stm.close();
                        reqParam = null;
                        sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                        sqlQueryObject.addInsertTable("pd_ws_request");
                        sqlQueryObject.addInsertField("id_porta", "?");
                        sqlQueryObject.addInsertField("nome", "?");
                        sqlQueryObject.addInsertField("valore", "?");
                        sqlQuery = sqlQueryObject.createSQLInsert();
                        stm = con.prepareStatement(sqlQuery);
                        i = 0;
                        if (messageSecurity.getRequestFlow() != null) {
                            flow3 = messageSecurity.getRequestFlow();
                            for (i = 0; i < flow3.sizeParameterList(); ++i) {
                                reqParam = flow3.getParameter(i);
                                stm.setLong(1, idPortaDelegata);
                                stm.setString(2, reqParam.getNome());
                                stm.setString(3, reqParam.getValore());
                                stm.executeUpdate();
                            }
                        }
                        stm.close();
                        log.debug((Object)("Inserted " + i + " request flow con id=" + idPortaDelegata));
                        resParam = null;
                        sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                        sqlQueryObject.addInsertTable("pd_ws_response");
                        sqlQueryObject.addInsertField("id_porta", "?");
                        sqlQueryObject.addInsertField("nome", "?");
                        sqlQueryObject.addInsertField("valore", "?");
                        sqlQuery = sqlQueryObject.createSQLInsert();
                        stm = con.prepareStatement(sqlQuery);
                        i = 0;
                        if (messageSecurity.getResponseFlow() != null) {
                            flow = messageSecurity.getResponseFlow();
                            for (i = 0; i < flow.sizeParameterList(); ++i) {
                                resParam = flow.getParameter(i);
                                stm.setLong(1, idPortaDelegata);
                                stm.setString(2, resParam.getNome());
                                stm.setString(3, resParam.getValore());
                                stm.executeUpdate();
                            }
                        }
                        stm.close();
                        log.debug((Object)("Inserted " + i + " response flow con id=" + idPortaDelegata));
                    }
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                    sqlQueryObject.addDeleteTable("pd_correlazione");
                    sqlQueryObject.addWhereCondition("id_porta=?");
                    sqlQuery = sqlQueryObject.createSQLDelete();
                    stm = con.prepareStatement(sqlQuery);
                    stm.setLong(1, idPortaDelegata);
                    stm.executeUpdate();
                    stm.close();
                    if (corrApp != null) {
                        cae = null;
                        sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                        sqlQueryObject.addInsertTable("pd_correlazione");
                        sqlQueryObject.addInsertField("id_porta", "?");
                        sqlQueryObject.addInsertField("nome_elemento", "?");
                        sqlQueryObject.addInsertField("mode_correlazione", "?");
                        sqlQueryObject.addInsertField("pattern", "?");
                        sqlQueryObject.addInsertField("identificazione_fallita", "?");
                        sqlQueryObject.addInsertField("riuso_id", "?");
                        sqlQuery = sqlQueryObject.createSQLInsert();
                        stm = con.prepareStatement(sqlQuery);
                        for (i = 0; i < corrApp.sizeElementoList(); ++i) {
                            cae = corrApp.getElemento(i);
                            stm.setLong(1, idPortaDelegata);
                            stm.setString(2, cae.getNome());
                            stm.setString(3, DriverConfigurazioneDB_LIB.getValue(cae.getIdentificazione()));
                            if (cae.getPattern() != null) {
                                stm.setString(4, cae.getPattern());
                            } else {
                                stm.setString(4, "");
                            }
                            stm.setString(5, DriverConfigurazioneDB_LIB.getValue(cae.getIdentificazioneFallita()));
                            stm.setString(6, DriverConfigurazioneDB_LIB.getValue(cae.getRiusoIdentificativo()));
                            stm.executeUpdate();
                        }
                        stm.close();
                        log.debug((Object)("Inserted " + i + " correlazione applicativa con id=" + idPortaDelegata));
                    }
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                    sqlQueryObject.addDeleteTable("pd_correlazione_risposta");
                    sqlQueryObject.addWhereCondition("id_porta=?");
                    sqlQuery = sqlQueryObject.createSQLDelete();
                    stm = con.prepareStatement(sqlQuery);
                    stm.setLong(1, idPortaDelegata);
                    stm.executeUpdate();
                    stm.close();
                    if (corrAppRisposta != null) {
                        cae = null;
                        sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                        sqlQueryObject.addInsertTable("pd_correlazione_risposta");
                        sqlQueryObject.addInsertField("id_porta", "?");
                        sqlQueryObject.addInsertField("nome_elemento", "?");
                        sqlQueryObject.addInsertField("mode_correlazione", "?");
                        sqlQueryObject.addInsertField("pattern", "?");
                        sqlQueryObject.addInsertField("identificazione_fallita", "?");
                        sqlQuery = sqlQueryObject.createSQLInsert();
                        stm = con.prepareStatement(sqlQuery);
                        for (i = 0; i < corrAppRisposta.sizeElementoList(); ++i) {
                            cae = corrAppRisposta.getElemento(i);
                            stm.setLong(1, idPortaDelegata);
                            stm.setString(2, cae.getNome());
                            stm.setString(3, DriverConfigurazioneDB_LIB.getValue(cae.getIdentificazione()));
                            if (cae.getPattern() != null) {
                                stm.setString(4, cae.getPattern());
                            } else {
                                stm.setString(4, "");
                            }
                            stm.setString(5, DriverConfigurazioneDB_LIB.getValue(cae.getIdentificazioneFallita()));
                            stm.executeUpdate();
                        }
                        stm.close();
                        log.debug((Object)("Inserted " + i + " correlazione applicativa risposta con id=" + idPortaDelegata));
                    }
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                    sqlQueryObject.addDeleteTable("porte_delegate_sa");
                    sqlQueryObject.addWhereCondition("id_porta=?");
                    sqlQuery = sqlQueryObject.createSQLDelete();
                    stm = con.prepareStatement(sqlQuery);
                    stm.setLong(1, idPortaDelegata);
                    n = stm.executeUpdate();
                    stm.close();
                    log.debug((Object)("Cancellati " + n + " servizi applicativi associati alla Porta Delegata " + idPortaDelegata));
                    n = 0;
                    for (i = 0; i < aPD.sizeServizioApplicativoList(); ++i) {
                        servizioApplicativo = aPD.getServizioApplicativo(i);
                        String nomeSA = servizioApplicativo.getNome();
                        String nomeProprietarioSA = aPD.getNomeSoggettoProprietario();
                        String tipoProprietarioSA = aPD.getTipoSoggettoProprietario();
                        if (nomeSA == null || nomeSA.equals("")) {
                            throw new DriverConfigurazioneException("Nome del ServizioApplicativo associato non valido.");
                        }
                        if (nomeProprietarioSA == null || nomeProprietarioSA.equals("")) {
                            throw new DriverConfigurazioneException("Nome Proprietario del ServizioApplicativo associato non valido.");
                        }
                        if (tipoProprietarioSA == null || tipoProprietarioSA.equals("")) {
                            throw new DriverConfigurazioneException("Tipo Proprietario del ServizioApplicativo associato non valido.");
                        }
                        long idSA = DriverConfigurazioneDB_LIB.getIdServizioApplicativo(nomeSA, tipoProprietarioSA, nomeProprietarioSA, con, tipoDB, tabellaSoggetti);
                        if (idSA <= 0L) {
                            throw new DriverConfigurazioneException("Impossibile recuperare l'id del Servizio Applicativo [" + nomeSA + "] di [" + tipoProprietarioSA + "/" + nomeProprietarioSA + "]");
                        }
                        sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                        sqlQueryObject.addInsertTable("porte_delegate_sa");
                        sqlQueryObject.addInsertField("id_porta", "?");
                        sqlQueryObject.addInsertField("id_servizio_applicativo", "?");
                        sqlQuery = sqlQueryObject.createSQLInsert();
                        stm = con.prepareStatement(sqlQuery);
                        stm.setLong(1, idPortaDelegata);
                        stm.setLong(2, idSA);
                        stm.executeUpdate();
                        stm.close();
                        ++n;
                        log.debug((Object)("Aggiunta associazione PortaDelegata<->ServizioApplicativo [" + idPortaDelegata + "]<->[" + idSA + "]"));
                    }
                    log.debug((Object)("Aggiunti " + n + " associazioni PortaDelegata<->ServizioApplicativo associati alla PortaDelegata[" + idPortaDelegata + "]"));
                    if (extInfoConfigurazioneDriver != null) {
                        extInfoConfigurazioneDriver.deleteAllExtendedInfo(con, log, aPD);
                    }
                    i = 0;
                    if (aPD.sizeExtendedInfoList() > 0 && extInfoConfigurazioneDriver != null) {
                        for (i = 0; i < aPD.sizeExtendedInfoList(); ++i) {
                            extInfoConfigurazioneDriver.createExtendedInfo(con, log, aPD, aPD.getExtendedInfo(i));
                        }
                    }
                    log.debug((Object)("Aggiunte " + i + " associazioni ExtendedInfo<->PortaDelegata associati alla PortaDelegata[" + idPortaDelegata + "]"));
                    break;
                }
                case 3: {
                    idPortaDelegata = DriverConfigurazioneDB_LIB.getIdPortaDelegata(nomePorta, tipoProprietario, nomeProprietario, con, tipoDB, tabellaSoggetti);
                    if (idPortaDelegata <= 0L) {
                        throw new DriverConfigurazioneException("[DriverConfigurazioneDB_LIB::CRUDPortaDelegata(DELETE)] Non e' stato possibile recuperare l'id della Porta Delegata, necessario per effettuare la DELETE.");
                    }
                    ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                    sqlQueryObject.addDeleteTable("pd_mtom_request");
                    sqlQueryObject.addWhereCondition("id_porta=?");
                    String sqlQuery = sqlQueryObject.createSQLDelete();
                    stm = con.prepareStatement(sqlQuery);
                    stm.setLong(1, idPortaDelegata);
                    n = stm.executeUpdate();
                    stm.close();
                    log.debug((Object)("Deleted " + n + " request flow con id=" + idPortaDelegata));
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                    sqlQueryObject.addDeleteTable("pd_mtom_response");
                    sqlQueryObject.addWhereCondition("id_porta=?");
                    sqlQuery = sqlQueryObject.createSQLDelete();
                    stm = con.prepareStatement(sqlQuery);
                    stm.setLong(1, idPortaDelegata);
                    n = stm.executeUpdate();
                    stm.close();
                    log.debug((Object)("Deleted " + n + " response flow con id=" + idPortaDelegata));
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                    sqlQueryObject.addDeleteTable("pd_ws_request");
                    sqlQueryObject.addWhereCondition("id_porta=?");
                    sqlQuery = sqlQueryObject.createSQLDelete();
                    stm = con.prepareStatement(sqlQuery);
                    stm.setLong(1, idPortaDelegata);
                    n = stm.executeUpdate();
                    stm.close();
                    log.debug((Object)("Deleted " + n + " request flow con id=" + idPortaDelegata));
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                    sqlQueryObject.addDeleteTable("pd_ws_response");
                    sqlQueryObject.addWhereCondition("id_porta=?");
                    sqlQuery = sqlQueryObject.createSQLDelete();
                    stm = con.prepareStatement(sqlQuery);
                    stm.setLong(1, idPortaDelegata);
                    n = stm.executeUpdate();
                    stm.close();
                    log.debug((Object)("Deleted " + n + " response flow con id=" + idPortaDelegata));
                    servizioApplicativo = null;
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                    sqlQueryObject.addDeleteTable("porte_delegate_sa");
                    sqlQueryObject.addWhereCondition("id_porta=?");
                    sqlQuery = sqlQueryObject.createSQLDelete();
                    stm = con.prepareStatement(sqlQuery);
                    stm.setLong(1, idPortaDelegata);
                    n = stm.executeUpdate();
                    stm.close();
                    log.debug((Object)("Deleted " + n + " associazioni PortaDelegata<->ServizioApplicativo associati alla PortaDelegata[" + idPortaDelegata + "]"));
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                    sqlQueryObject.addDeleteTable("pd_ws_request");
                    sqlQueryObject.addWhereCondition("id_porta=?");
                    sqlQuery = sqlQueryObject.createSQLDelete();
                    stm = con.prepareStatement(sqlQuery);
                    stm.setLong(1, idPortaDelegata);
                    n = stm.executeUpdate();
                    stm.close();
                    if (n > 0) {
                        log.debug((Object)("Deleted " + n + " ws_request flow associate alla PortaDelegata[" + idPortaDelegata + "]"));
                    }
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                    sqlQueryObject.addDeleteTable("pd_ws_response");
                    sqlQueryObject.addWhereCondition("id_porta=?");
                    sqlQuery = sqlQueryObject.createSQLDelete();
                    stm = con.prepareStatement(sqlQuery);
                    stm.setLong(1, idPortaDelegata);
                    n = stm.executeUpdate();
                    stm.close();
                    if (n > 0) {
                        log.debug((Object)("Deleted " + n + " ws_response flow associate alla PortaDelegata[" + idPortaDelegata + "]"));
                    }
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                    sqlQueryObject.addDeleteTable("pd_correlazione");
                    sqlQueryObject.addWhereCondition("id_porta=?");
                    sqlQuery = sqlQueryObject.createSQLDelete();
                    stm = con.prepareStatement(sqlQuery);
                    stm.setLong(1, idPortaDelegata);
                    n = stm.executeUpdate();
                    stm.close();
                    if (n > 0) {
                        log.debug((Object)("Deleted " + n + " correlazione associate alla PortaDelegata[" + idPortaDelegata + "]"));
                    }
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                    sqlQueryObject.addDeleteTable("pd_correlazione_risposta");
                    sqlQueryObject.addWhereCondition("id_porta=?");
                    sqlQuery = sqlQueryObject.createSQLDelete();
                    stm = con.prepareStatement(sqlQuery);
                    stm.setLong(1, idPortaDelegata);
                    n = stm.executeUpdate();
                    stm.close();
                    if (n > 0) {
                        log.debug((Object)("Deleted " + n + " correlazione per la rispsota associate alla PortaDelegata[" + idPortaDelegata + "]"));
                    }
                    if (extInfoConfigurazioneDriver != null) {
                        extInfoConfigurazioneDriver.deleteAllExtendedInfo(con, log, aPD);
                    }
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                    sqlQueryObject.addDeleteTable("porte_delegate");
                    sqlQueryObject.addWhereCondition("id=?");
                    sqlQuery = sqlQueryObject.createSQLDelete();
                    stm = con.prepareStatement(sqlQuery);
                    stm.setLong(1, idPortaDelegata);
                    log.debug((Object)("eseguo query : " + DBUtils.formatSQLString(sqlQuery, idPortaDelegata)));
                    n = stm.executeUpdate();
                    stm.close();
                    log.debug((Object)("Deleted " + n + " row(s)."));
                }
            }
            long l = idPortaDelegata;
            return l;
        }
        catch (DriverConfigurazioneException e) {
            throw e;
        }
        catch (SQLException se) {
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB_LIB::CRUDPortaDelegata] SQLException : " + se.getMessage(), se);
        }
        catch (Exception e) {
            throw new DriverConfigurazioneException("Errore durante operazione(" + type + ") CRUDPortaDelegata.", e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception e) {}
        }
    }

    public static long CRUDServizioApplicativo(int type, ServizioApplicativo aSA, Connection con) throws DriverConfigurazioneException {
        if (aSA == null) {
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB_LIB::CRUDServizioApplicativo] Servizio Applicativo non valido.");
        }
        String nomeSA = aSA.getNome();
        String tipoProprietario = aSA.getTipoSoggettoProprietario();
        String nomeProprietario = aSA.getNomeSoggettoProprietario();
        if (nomeSA == null || nomeSA.equals("")) {
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB_LIB::CRUDServizioApplicativo] Nome Servizio Applicativo non valido.");
        }
        if (tipoProprietario == null || tipoProprietario.equals("")) {
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB_LIB::CRUDServizioApplicativo] Tipo Proprietario Servizio Applicativo non valido.");
        }
        if (nomeProprietario == null || nomeProprietario.equals("")) {
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB_LIB::CRUDServizioApplicativo] Nome Proprietario Servizio Applicativo non valido.");
        }
        Statement stm = null;
        ResultSet rs = null;
        int n = 0;
        try {
            String descrizione = aSA.getDescrizione();
            log.debug((Object)("get ID Soggetto con tipo[" + tipoProprietario + "] e nome[" + nomeProprietario + "]"));
            long idProprietario = DBUtils.getIdSoggetto(nomeProprietario, tipoProprietario, con, tipoDB, tabellaSoggetti);
            log.debug((Object)("get ID Soggetto con tipo[" + tipoProprietario + "] e nome[" + nomeProprietario + "] : " + idProprietario));
            InvocazionePorta invPorta = aSA.getInvocazionePorta();
            InvocazioneServizio invServizio = aSA.getInvocazioneServizio();
            RispostaAsincrona ricezione = aSA.getRispostaAsincrona();
            Connettore connettoreRisp = null;
            Connettore connettoreInv = null;
            long idConnettoreRisp = 0L;
            long idConnettoreInv = 0L;
            long idServizioApplicativo = 0L;
            Credenziali credenziali = null;
            InvocazionePortaGestioneErrore gestErr = null;
            String fault = null;
            switch (type) {
                case 1: {
                    ISQLQueryObject sqlQueryObjectUpdate;
                    Connettore connettore;
                    ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                    sqlQueryObject.addInsertTable("servizi_applicativi");
                    sqlQueryObject.addInsertField("nome", "?");
                    sqlQueryObject.addInsertField("descrizione", "?");
                    sqlQueryObject.addInsertField("sbustamentorisp", "?");
                    sqlQueryObject.addInsertField("sbustamento_protocol_info_risp", "?");
                    sqlQueryObject.addInsertField("getmsgrisp", "?");
                    sqlQueryObject.addInsertField("tipoauthrisp", "?");
                    sqlQueryObject.addInsertField("utenterisp", "?");
                    sqlQueryObject.addInsertField("passwordrisp", "?");
                    sqlQueryObject.addInsertField("subjectrisp", "?");
                    sqlQueryObject.addInsertField("id_connettore_risp", "?");
                    sqlQueryObject.addInsertField("sbustamentoinv", "?");
                    sqlQueryObject.addInsertField("sbustamento_protocol_info_inv", "?");
                    sqlQueryObject.addInsertField("getmsginv", "?");
                    sqlQueryObject.addInsertField("tipoauthinv", "?");
                    sqlQueryObject.addInsertField("utenteinv", "?");
                    sqlQueryObject.addInsertField("passwordinv", "?");
                    sqlQueryObject.addInsertField("subjectinv", "?");
                    sqlQueryObject.addInsertField("id_connettore_inv", "?");
                    sqlQueryObject.addInsertField("id_soggetto", "?");
                    sqlQueryObject.addInsertField("fault", "?");
                    sqlQueryObject.addInsertField("tipoauth", "?");
                    sqlQueryObject.addInsertField("utente", "?");
                    sqlQueryObject.addInsertField("password", "?");
                    sqlQueryObject.addInsertField("subject", "?");
                    sqlQueryObject.addInsertField("invio_x_rif_inv", "?");
                    sqlQueryObject.addInsertField("risposta_x_rif_inv", "?");
                    sqlQueryObject.addInsertField("invio_x_rif", "?");
                    sqlQueryObject.addInsertField("invio_x_rif_risp", "?");
                    sqlQueryObject.addInsertField("risposta_x_rif_risp", "?");
                    sqlQueryObject.addInsertField("sbustamento_protocol_info", "?");
                    sqlQueryObject.addInsertField("fault_actor", "?");
                    sqlQueryObject.addInsertField("generic_fault_code", "?");
                    sqlQueryObject.addInsertField("prefix_fault_code", "?");
                    sqlQueryObject.addInsertField("tipologia_fruizione", "?");
                    sqlQueryObject.addInsertField("tipologia_erogazione", "?");
                    String sqlQuery = sqlQueryObject.createSQLInsert();
                    stm = con.prepareStatement(sqlQuery);
                    connettoreRisp = new Connettore();
                    connettoreRisp.setNome("ConnettoreRISP_" + aSA.getNome() + aSA.getTipoSoggettoProprietario() + aSA.getNomeSoggettoProprietario());
                    connettoreRisp.setTipo(TipiConnettore.DISABILITATO.getNome());
                    idConnettoreRisp = DriverConfigurazioneDB_LIB.CRUDConnettore(1, connettoreRisp, con);
                    if (ricezione != null && ricezione.getConnettore() != null) {
                        connettore = ricezione.getConnettore();
                        connettore.setId(idConnettoreRisp);
                        connettore.setNome(connettoreRisp.getNome());
                        DriverConfigurazioneDB_LIB.CRUDConnettore(2, connettore, con);
                    }
                    connettoreInv = new Connettore();
                    connettoreInv.setNome("ConnettoreINV_" + aSA.getNome() + aSA.getTipoSoggettoProprietario() + aSA.getNomeSoggettoProprietario());
                    connettoreInv.setTipo(TipiConnettore.DISABILITATO.getNome());
                    idConnettoreInv = DriverConfigurazioneDB_LIB.CRUDConnettore(1, connettoreInv, con);
                    if (invServizio != null && invServizio.getConnettore() != null) {
                        connettore = invServizio.getConnettore();
                        connettore.setId(idConnettoreInv);
                        connettore.setNome(connettoreInv.getNome());
                        DriverConfigurazioneDB_LIB.CRUDConnettore(2, connettore, con);
                    }
                    int index = 1;
                    stm.setString(index++, nomeSA);
                    stm.setString(index++, descrizione);
                    stm.setInt(index++, ricezione != null && CostantiConfigurazione.ABILITATO.equals(ricezione.getSbustamentoSoap()) ? 1 : 0);
                    stm.setInt(index++, ricezione != null && !CostantiConfigurazione.DISABILITATO.equals(ricezione.getSbustamentoInformazioniProtocollo()) ? 1 : 0);
                    stm.setString(index++, ricezione != null ? DriverConfigurazioneDB_LIB.getValue(ricezione.getGetMessage()) : null);
                    credenziali = ricezione != null ? ricezione.getCredenziali() : null;
                    stm.setString(index++, ricezione != null ? DriverConfigurazioneDB_LIB.getValue(ricezione.getAutenticazione()) : null);
                    stm.setString(index++, credenziali != null ? credenziali.getUser() : null);
                    stm.setString(index++, credenziali != null ? credenziali.getPassword() : null);
                    stm.setString(index++, credenziali != null ? credenziali.getSubject() : null);
                    stm.setLong(index++, idConnettoreRisp);
                    stm.setInt(index++, invServizio != null && CostantiConfigurazione.ABILITATO.equals(invServizio.getSbustamentoSoap()) ? 1 : 0);
                    stm.setInt(index++, invServizio != null && !CostantiConfigurazione.DISABILITATO.equals(invServizio.getSbustamentoInformazioniProtocollo()) ? 1 : 0);
                    stm.setString(index++, invServizio != null ? DriverConfigurazioneDB_LIB.getValue(invServizio.getGetMessage()) : null);
                    credenziali = invServizio != null ? invServizio.getCredenziali() : null;
                    stm.setString(index++, invServizio != null ? DriverConfigurazioneDB_LIB.getValue(invServizio.getAutenticazione()) : null);
                    stm.setString(index++, credenziali != null ? credenziali.getUser() : null);
                    stm.setString(index++, credenziali != null ? credenziali.getPassword() : null);
                    stm.setString(index++, credenziali != null ? credenziali.getSubject() : null);
                    stm.setLong(index++, idConnettoreInv);
                    stm.setLong(index++, idProprietario);
                    gestErr = invPorta != null ? invPorta.getGestioneErrore() : null;
                    fault = gestErr != null ? DriverConfigurazioneDB_LIB.getValue(gestErr.getFault()) : null;
                    stm.setString(index++, fault);
                    credenziali = invPorta != null && invPorta.sizeCredenzialiList() > 0 ? invPorta.getCredenziali(0) : null;
                    stm.setString(index++, credenziali != null ? DriverConfigurazioneDB_LIB.getValue(credenziali.getTipo()) : null);
                    stm.setString(index++, credenziali != null ? credenziali.getUser() : null);
                    stm.setString(index++, credenziali != null ? credenziali.getPassword() : null);
                    String subject = null;
                    if (credenziali != null && credenziali.getSubject() != null && !"".equals(credenziali.getSubject())) {
                        subject = credenziali.getSubject();
                    }
                    stm.setString(index++, subject != null ? Utilities.formatSubject(subject) : null);
                    stm.setString(index++, invServizio != null ? DriverConfigurazioneDB_LIB.getValue(invServizio.getInvioPerRiferimento()) : null);
                    stm.setString(index++, invServizio != null ? DriverConfigurazioneDB_LIB.getValue(invServizio.getRispostaPerRiferimento()) : null);
                    stm.setString(index++, invPorta != null ? DriverConfigurazioneDB_LIB.getValue(invPorta.getInvioPerRiferimento()) : null);
                    stm.setString(index++, ricezione != null ? DriverConfigurazioneDB_LIB.getValue(ricezione.getInvioPerRiferimento()) : null);
                    stm.setString(index++, ricezione != null ? DriverConfigurazioneDB_LIB.getValue(ricezione.getRispostaPerRiferimento()) : null);
                    stm.setInt(index++, invPorta != null && !CostantiConfigurazione.DISABILITATO.equals(invPorta.getSbustamentoInformazioniProtocollo()) ? 1 : 0);
                    stm.setString(index++, gestErr != null ? gestErr.getFaultActor() : null);
                    stm.setString(index++, gestErr != null ? DriverConfigurazioneDB_LIB.getValue(gestErr.getGenericFaultCode()) : null);
                    stm.setString(index++, gestErr != null ? gestErr.getPrefixFaultCode() : null);
                    stm.setString(index++, aSA.getTipologiaFruizione() != null ? TipologiaFruizione.valueOf(aSA.getTipologiaFruizione().toUpperCase()).toString() : TipologiaFruizione.DISABILITATO.toString());
                    stm.setString(index++, aSA.getTipologiaErogazione() != null ? TipologiaErogazione.valueOf(aSA.getTipologiaErogazione().toUpperCase()).toString() : TipologiaErogazione.DISABILITATO.toString());
                    n = stm.executeUpdate();
                    stm.close();
                    log.debug((Object)("Inserted " + n + " row(s)"));
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                    sqlQueryObject.addFromTable("servizi_applicativi");
                    sqlQueryObject.addSelectField("id");
                    sqlQueryObject.addWhereCondition("id_soggetto = ?");
                    sqlQueryObject.addWhereCondition("nome = ?");
                    sqlQueryObject.setANDLogicOperator(true);
                    sqlQuery = sqlQueryObject.createSQLQuery();
                    stm = con.prepareStatement(sqlQuery);
                    stm.setLong(1, idProprietario);
                    stm.setString(2, nomeSA);
                    rs = stm.executeQuery();
                    if (!rs.next()) {
                        throw new DriverConfigurazioneException("[DriverConfigurazioneDB_LIB::CRUDServizioApplicativo(CREATE)] Impossibile trovare il servizio appena creato.");
                    }
                    idServizioApplicativo = rs.getLong("id");
                    aSA.setId(idServizioApplicativo);
                    rs.close();
                    stm.close();
                    if (aSA.getRispostaAsincrona() != null && aSA.getRispostaAsincrona().getGestioneErrore() != null) {
                        DriverConfigurazioneDB_LIB.CRUDGestioneErroreServizioApplicativo(1, aSA.getRispostaAsincrona().getGestioneErrore(), idProprietario, idServizioApplicativo, false, con);
                        sqlQueryObjectUpdate = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                        sqlQueryObjectUpdate.addUpdateTable("servizi_applicativi");
                        sqlQueryObjectUpdate.addUpdateField("id_gestione_errore_risp", "?");
                        sqlQueryObjectUpdate.addWhereCondition("id = ?");
                        stm = con.prepareStatement(sqlQueryObjectUpdate.createSQLUpdate());
                        stm.setLong(1, aSA.getRispostaAsincrona().getGestioneErrore().getId());
                        stm.setLong(2, idServizioApplicativo);
                        stm.executeUpdate();
                    }
                    if (aSA.getInvocazioneServizio() == null || aSA.getInvocazioneServizio().getGestioneErrore() == null) break;
                    DriverConfigurazioneDB_LIB.CRUDGestioneErroreServizioApplicativo(1, aSA.getInvocazioneServizio().getGestioneErrore(), idProprietario, idServizioApplicativo, true, con);
                    sqlQueryObjectUpdate = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                    sqlQueryObjectUpdate.addUpdateTable("servizi_applicativi");
                    sqlQueryObjectUpdate.addUpdateField("id_gestione_errore_inv", "?");
                    sqlQueryObjectUpdate.addWhereCondition("id = ?");
                    stm = con.prepareStatement(sqlQueryObjectUpdate.createSQLUpdate());
                    stm.setLong(1, aSA.getInvocazioneServizio().getGestioneErrore().getId());
                    stm.setLong(2, idServizioApplicativo);
                    stm.executeUpdate();
                    break;
                }
                case 2: {
                    long oldIdProprietario;
                    String oldNomeSA = aSA.getOldNomeForUpdate();
                    String oldNomeProprietario = aSA.getOldNomeSoggettoProprietarioForUpdate();
                    String oldTipoProprietario = aSA.getOldTipoSoggettoProprietarioForUpdate();
                    if (oldNomeSA == null || oldNomeSA.equals("")) {
                        oldNomeSA = nomeSA;
                    }
                    if (oldNomeProprietario == null || oldNomeProprietario.equals("")) {
                        oldNomeProprietario = nomeProprietario;
                    }
                    if (oldTipoProprietario == null || oldTipoProprietario.equals("")) {
                        oldTipoProprietario = tipoProprietario;
                    }
                    if ((oldIdProprietario = DBUtils.getIdSoggetto(oldNomeProprietario, oldTipoProprietario, con, tipoDB, tabellaSoggetti)) <= 0L) {
                        oldIdProprietario = DBUtils.getIdSoggetto(nomeProprietario, tipoProprietario, con, tipoDB, tabellaSoggetti);
                    }
                    if (oldIdProprietario <= 0L) {
                        throw new DriverConfigurazioneException("Impossibile recuperare l'id del Soggetto Proprietario del Servizio Applicativo");
                    }
                    ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                    sqlQueryObject.addUpdateTable("servizi_applicativi");
                    sqlQueryObject.addUpdateField("descrizione", "?");
                    sqlQueryObject.addUpdateField("sbustamentorisp", "?");
                    sqlQueryObject.addUpdateField("sbustamento_protocol_info_risp", "?");
                    sqlQueryObject.addUpdateField("getmsgrisp", "?");
                    sqlQueryObject.addUpdateField("tipoauthrisp", "?");
                    sqlQueryObject.addUpdateField("utenterisp", "?");
                    sqlQueryObject.addUpdateField("passwordrisp", "?");
                    sqlQueryObject.addUpdateField("subjectrisp", "?");
                    sqlQueryObject.addUpdateField("id_connettore_risp", "?");
                    sqlQueryObject.addUpdateField("sbustamentoinv", "?");
                    sqlQueryObject.addUpdateField("sbustamento_protocol_info_inv", "?");
                    sqlQueryObject.addUpdateField("getmsginv", "?");
                    sqlQueryObject.addUpdateField("tipoauthinv", "?");
                    sqlQueryObject.addUpdateField("utenteinv", "?");
                    sqlQueryObject.addUpdateField("passwordinv", "?");
                    sqlQueryObject.addUpdateField("subjectinv", "?");
                    sqlQueryObject.addUpdateField("id_connettore_inv", "?");
                    sqlQueryObject.addUpdateField("fault", "?");
                    sqlQueryObject.addUpdateField("tipoauth", "?");
                    sqlQueryObject.addUpdateField("utente", "?");
                    sqlQueryObject.addUpdateField("password", "?");
                    sqlQueryObject.addUpdateField("subject", "?");
                    sqlQueryObject.addUpdateField("invio_x_rif_inv", "?");
                    sqlQueryObject.addUpdateField("risposta_x_rif_inv", "?");
                    sqlQueryObject.addUpdateField("invio_x_rif", "?");
                    sqlQueryObject.addUpdateField("invio_x_rif_risp", "?");
                    sqlQueryObject.addUpdateField("risposta_x_rif_risp", "?");
                    sqlQueryObject.addUpdateField("sbustamento_protocol_info", "?");
                    sqlQueryObject.addUpdateField("fault_actor", "?");
                    sqlQueryObject.addUpdateField("generic_fault_code", "?");
                    sqlQueryObject.addUpdateField("prefix_fault_code", "?");
                    sqlQueryObject.addUpdateField("nome", "?");
                    sqlQueryObject.addUpdateField("id_soggetto", "?");
                    if (aSA.getRispostaAsincrona() != null && aSA.getRispostaAsincrona().getGestioneErrore() != null) {
                        sqlQueryObject.addUpdateField("id_gestione_errore_risp", "?");
                    }
                    if (aSA.getInvocazioneServizio() != null && aSA.getInvocazioneServizio().getGestioneErrore() != null) {
                        sqlQueryObject.addUpdateField("id_gestione_errore_inv", "?");
                    }
                    sqlQueryObject.addUpdateField("tipologia_fruizione", "?");
                    sqlQueryObject.addUpdateField("tipologia_erogazione", "?");
                    sqlQueryObject.addWhereCondition("id=?");
                    sqlQueryObject.addWhereCondition("nome=?");
                    sqlQueryObject.addWhereCondition("id_soggetto=?");
                    sqlQueryObject.setANDLogicOperator(true);
                    String sqlQuery = sqlQueryObject.createSQLUpdate();
                    stm = con.prepareStatement(sqlQuery);
                    idServizioApplicativo = DriverConfigurazioneDB_LIB.getIdServizioApplicativo(oldNomeSA, oldTipoProprietario, oldNomeProprietario, con, tipoDB, tabellaSoggetti);
                    if (idServizioApplicativo <= 0L) {
                        idServizioApplicativo = DriverConfigurazioneDB_LIB.getIdServizioApplicativo(oldNomeSA, tipoProprietario, nomeProprietario, con, tipoDB, tabellaSoggetti);
                    }
                    if (idServizioApplicativo <= 0L) {
                        throw new DriverConfigurazioneException("[DriverConfigurazioneDB_LIB::CRUDServizioApplicativo(UPDATE)] ID del ServizioApplicativo necessario per l'aggiornamento.");
                    }
                    RispostaAsincrona rispAsin = aSA.getRispostaAsincrona();
                    connettoreRisp = rispAsin != null ? rispAsin.getConnettore() : new Connettore();
                    String newNomeConnettoreRisp = "ConnettoreRISP_" + nomeSA + tipoProprietario + nomeProprietario;
                    idConnettoreRisp = DriverConfigurazioneDB_LIB.getIdConnettore_SA_RISP(idServizioApplicativo, con);
                    InvocazioneServizio invServ = aSA.getInvocazioneServizio();
                    connettoreInv = invServ != null ? invServizio.getConnettore() : new Connettore();
                    String newNomeConnettoreInv = "ConnettoreINV_" + nomeSA + tipoProprietario + nomeProprietario;
                    idConnettoreInv = DriverConfigurazioneDB_LIB.getIdConnettore_SA_INV(idServizioApplicativo, con);
                    if (idConnettoreInv <= 0L || idConnettoreRisp <= 0L) {
                        throw new DriverConfigurazioneException("I connettori del servizio applicativo sono invalidi");
                    }
                    String nomeConnettoreRisp = DriverConfigurazioneDB_LIB.getConnettore(idConnettoreRisp, con).getNome();
                    String nomeConnettoreInv = DriverConfigurazioneDB_LIB.getConnettore(idConnettoreInv, con).getNome();
                    String pattern = "Aggiorno Connettore [{0}] : id [{1}] oldNome [{2}] newNome [{2}]";
                    log.debug((Object)MessageFormat.format(pattern, "Risposta Asincrona", idConnettoreRisp, nomeConnettoreRisp, newNomeConnettoreRisp));
                    connettoreRisp.setNome(newNomeConnettoreRisp);
                    connettoreRisp.setId(idConnettoreRisp);
                    DriverConfigurazioneDB_LIB.CRUDConnettore(2, connettoreRisp, con);
                    log.debug((Object)MessageFormat.format(pattern, "Invocazione Servizio", idConnettoreInv, nomeConnettoreInv, newNomeConnettoreInv));
                    connettoreInv.setNome(newNomeConnettoreInv);
                    connettoreInv.setId(idConnettoreInv);
                    DriverConfigurazioneDB_LIB.CRUDConnettore(2, connettoreInv, con);
                    int index = 1;
                    stm.setString(index++, descrizione);
                    stm.setInt(index++, ricezione != null && CostantiConfigurazione.ABILITATO.equals(ricezione.getSbustamentoSoap()) ? 1 : 0);
                    stm.setInt(index++, ricezione != null && !CostantiConfigurazione.DISABILITATO.equals(ricezione.getSbustamentoInformazioniProtocollo()) ? 1 : 0);
                    stm.setString(index++, ricezione != null ? DriverConfigurazioneDB_LIB.getValue(ricezione.getGetMessage()) : null);
                    credenziali = ricezione != null ? ricezione.getCredenziali() : null;
                    stm.setString(index++, credenziali != null ? DriverConfigurazioneDB_LIB.getValue(credenziali.getTipo()) : null);
                    stm.setString(index++, credenziali != null ? credenziali.getUser() : null);
                    stm.setString(index++, credenziali != null ? credenziali.getPassword() : null);
                    stm.setString(index++, credenziali != null ? credenziali.getSubject() : null);
                    stm.setLong(index++, idConnettoreRisp);
                    stm.setInt(index++, invServizio != null && CostantiConfigurazione.ABILITATO.equals(invServizio.getSbustamentoSoap()) ? 1 : 0);
                    stm.setInt(index++, invServizio != null && !CostantiConfigurazione.DISABILITATO.equals(invServizio.getSbustamentoInformazioniProtocollo()) ? 1 : 0);
                    stm.setString(index++, invServizio != null ? DriverConfigurazioneDB_LIB.getValue(invServizio.getGetMessage()) : null);
                    credenziali = invServizio != null ? invServizio.getCredenziali() : null;
                    stm.setString(index++, credenziali != null ? DriverConfigurazioneDB_LIB.getValue(credenziali.getTipo()) : null);
                    stm.setString(index++, credenziali != null ? credenziali.getUser() : null);
                    stm.setString(index++, credenziali != null ? credenziali.getPassword() : null);
                    stm.setString(index++, credenziali != null ? credenziali.getSubject() : null);
                    stm.setLong(index++, idConnettoreInv);
                    gestErr = invPorta != null ? invPorta.getGestioneErrore() : null;
                    fault = gestErr != null ? DriverConfigurazioneDB_LIB.getValue(gestErr.getFault()) : null;
                    stm.setString(index++, fault);
                    credenziali = invPorta != null && invPorta.sizeCredenzialiList() > 0 ? invPorta.getCredenziali(0) : null;
                    stm.setString(index++, credenziali != null ? DriverConfigurazioneDB_LIB.getValue(credenziali.getTipo()) : null);
                    stm.setString(index++, credenziali != null ? credenziali.getUser() : null);
                    stm.setString(index++, credenziali != null ? credenziali.getPassword() : null);
                    String subject = null;
                    if (credenziali != null && credenziali.getSubject() != null && !"".equals(credenziali.getSubject())) {
                        subject = credenziali.getSubject();
                    }
                    stm.setString(index++, subject != null ? Utilities.formatSubject(subject) : null);
                    stm.setString(index++, invServizio != null ? DriverConfigurazioneDB_LIB.getValue(invServizio.getInvioPerRiferimento()) : null);
                    stm.setString(index++, invServizio != null ? DriverConfigurazioneDB_LIB.getValue(invServizio.getRispostaPerRiferimento()) : null);
                    stm.setString(index++, invPorta != null ? DriverConfigurazioneDB_LIB.getValue(invPorta.getInvioPerRiferimento()) : null);
                    stm.setString(index++, ricezione != null ? DriverConfigurazioneDB_LIB.getValue(ricezione.getInvioPerRiferimento()) : null);
                    stm.setString(index++, ricezione != null ? DriverConfigurazioneDB_LIB.getValue(ricezione.getRispostaPerRiferimento()) : null);
                    stm.setInt(index++, invPorta != null && !CostantiConfigurazione.DISABILITATO.equals(invPorta.getSbustamentoInformazioniProtocollo()) ? 1 : 0);
                    stm.setString(index++, gestErr != null ? gestErr.getFaultActor() : null);
                    stm.setString(index++, gestErr != null ? DriverConfigurazioneDB_LIB.getValue(gestErr.getGenericFaultCode()) : null);
                    stm.setString(index++, gestErr != null ? gestErr.getPrefixFaultCode() : null);
                    stm.setString(index++, nomeSA);
                    stm.setLong(index++, idProprietario < 0L ? oldIdProprietario : idProprietario);
                    if (aSA.getRispostaAsincrona() != null && aSA.getRispostaAsincrona().getGestioneErrore() != null) {
                        DriverConfigurazioneDB_LIB.CRUDGestioneErroreServizioApplicativo(2, aSA.getRispostaAsincrona().getGestioneErrore(), idProprietario, idServizioApplicativo, false, con);
                        stm.setLong(index++, aSA.getRispostaAsincrona().getGestioneErrore().getId());
                    }
                    if (aSA.getInvocazioneServizio() != null && aSA.getInvocazioneServizio().getGestioneErrore() != null) {
                        DriverConfigurazioneDB_LIB.CRUDGestioneErroreServizioApplicativo(2, aSA.getInvocazioneServizio().getGestioneErrore(), idProprietario, idServizioApplicativo, true, con);
                        stm.setLong(index++, aSA.getInvocazioneServizio().getGestioneErrore().getId());
                    }
                    stm.setString(index++, aSA.getTipologiaFruizione() != null ? TipologiaFruizione.valueOf(aSA.getTipologiaFruizione().toUpperCase()).toString() : TipologiaFruizione.DISABILITATO.toString());
                    stm.setString(index++, aSA.getTipologiaErogazione() != null ? TipologiaErogazione.valueOf(aSA.getTipologiaErogazione().toUpperCase()).toString() : TipologiaErogazione.DISABILITATO.toString());
                    stm.setLong(index++, idServizioApplicativo);
                    stm.setString(index++, oldNomeSA);
                    stm.setLong(index++, oldIdProprietario);
                    n = stm.executeUpdate();
                    stm.close();
                    log.debug((Object)("Updated " + n + " row(s)"));
                    break;
                }
                case 3: {
                    log.debug((Object)("get ID Servizio Applicativo con nome[" + nomeSA + "] tipoProprietario[" + tipoProprietario + "] nomeProprietario[" + nomeProprietario + "]"));
                    idServizioApplicativo = DriverConfigurazioneDB_LIB.getIdServizioApplicativo(nomeSA, tipoProprietario, nomeProprietario, con, tipoDB, tabellaSoggetti);
                    log.debug((Object)("get ID Servizio Applicativo: " + idServizioApplicativo));
                    log.debug((Object)"Deleted PA associazioni...");
                    ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                    sqlQueryObject.addDeleteTable("porte_applicative_sa");
                    sqlQueryObject.addWhereCondition("id_servizio_applicativo=?");
                    String sqlQuery = sqlQueryObject.createSQLDelete();
                    stm = con.prepareStatement(sqlQuery);
                    stm.setLong(1, idServizioApplicativo);
                    n = stm.executeUpdate();
                    stm.close();
                    if (n > 0) {
                        log.debug((Object)("Deleted " + n + " associazioni di PortaApplicativa<->ServizioApplicativo associate al ServizioApplicativo[" + idServizioApplicativo + "]"));
                    }
                    log.debug((Object)"Deleted PD associazioni...");
                    log.debug((Object)"Deleted PA associazioni...");
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                    sqlQueryObject.addDeleteTable("porte_delegate_sa");
                    sqlQueryObject.addWhereCondition("id_servizio_applicativo=?");
                    sqlQuery = sqlQueryObject.createSQLDelete();
                    stm = con.prepareStatement(sqlQuery);
                    stm.setLong(1, idServizioApplicativo);
                    n = stm.executeUpdate();
                    stm.close();
                    if (n > 0) {
                        log.debug((Object)("Deleted " + n + " associazioni di PortaDelegata<->ServizioApplicativo associate al ServizioApplicativo[" + idServizioApplicativo + "]"));
                    }
                    log.debug((Object)"Deleted ...");
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                    sqlQueryObject.addDeleteTable("servizi_applicativi");
                    sqlQueryObject.addWhereCondition("id=?");
                    sqlQueryObject.addWhereCondition("nome=?");
                    sqlQueryObject.addWhereCondition("id_soggetto=?");
                    sqlQueryObject.setANDLogicOperator(true);
                    sqlQuery = sqlQueryObject.createSQLDelete();
                    stm = con.prepareStatement(sqlQuery);
                    stm.setLong(1, idServizioApplicativo);
                    stm.setString(2, nomeSA);
                    stm.setLong(3, idProprietario);
                    log.debug((Object)("eseguo query : " + DBUtils.formatSQLString(sqlQuery, idServizioApplicativo, nomeSA, idProprietario)));
                    n = stm.executeUpdate();
                    stm.close();
                    log.debug((Object)("Deleted " + n + " row(s)"));
                    log.debug((Object)"Recupero connettore asincrono ...");
                    if (aSA.getRispostaAsincrona() != null && aSA.getRispostaAsincrona().getConnettore() != null) {
                        connettoreRisp = aSA.getRispostaAsincrona().getConnettore();
                    } else {
                        connettoreRisp = new Connettore();
                        connettoreRisp.setTipo(TipiConnettore.DISABILITATO.getNome());
                    }
                    String nomeConnettoreRisp = "ConnettoreRISP_" + aSA.getNome() + aSA.getTipoSoggettoProprietario() + aSA.getNomeSoggettoProprietario();
                    connettoreRisp.setNome(nomeConnettoreRisp);
                    idConnettoreRisp = DBUtils.getIdConnettore(nomeConnettoreRisp, con, tipoDB);
                    log.debug((Object)("Recupero connettore asincrono id[" + idConnettoreRisp + "]"));
                    connettoreRisp.setId(idConnettoreRisp);
                    log.debug((Object)"Recupero connettore invocazione servizio ...");
                    if (aSA.getInvocazioneServizio() != null && aSA.getInvocazioneServizio().getConnettore() != null) {
                        connettoreInv = aSA.getInvocazioneServizio().getConnettore();
                    } else {
                        connettoreInv = new Connettore();
                        connettoreInv.setTipo(TipiConnettore.DISABILITATO.getNome());
                    }
                    String nomeConnettoreInv = "ConnettoreINV_" + aSA.getNome() + aSA.getTipoSoggettoProprietario() + aSA.getNomeSoggettoProprietario();
                    connettoreInv.setNome(nomeConnettoreInv);
                    idConnettoreInv = DBUtils.getIdConnettore(nomeConnettoreInv, con, tipoDB);
                    log.debug((Object)("Recupero connettore invocazione servizio id[" + idConnettoreInv + "]"));
                    connettoreInv.setId(idConnettoreInv);
                    if (idConnettoreInv <= 0L || idConnettoreRisp <= 0L) {
                        throw new DriverConfigurazioneException("I connettori del servizio applicativo sono invalidi");
                    }
                    log.debug((Object)"Delete connettore asincrono ...");
                    DriverConfigurazioneDB_LIB.CRUDConnettore(3, connettoreRisp, con);
                    log.debug((Object)"Delete connettore invocazione servizio ...");
                    DriverConfigurazioneDB_LIB.CRUDConnettore(3, connettoreInv, con);
                    if (aSA.getRispostaAsincrona() != null && aSA.getRispostaAsincrona().getGestioneErrore() != null) {
                        DriverConfigurazioneDB_LIB.CRUDGestioneErroreServizioApplicativo(3, aSA.getRispostaAsincrona().getGestioneErrore(), idProprietario, idServizioApplicativo, false, con);
                    }
                    if (aSA.getInvocazioneServizio() == null || aSA.getInvocazioneServizio().getGestioneErrore() == null) break;
                    DriverConfigurazioneDB_LIB.CRUDGestioneErroreServizioApplicativo(3, aSA.getInvocazioneServizio().getGestioneErrore(), idProprietario, idServizioApplicativo, true, con);
                }
            }
            long l = idServizioApplicativo;
            return l;
        }
        catch (DriverConfigurazioneException e) {
            throw e;
        }
        catch (SQLException se) {
            throw new DriverConfigurazioneException("SQLException : " + se.getMessage(), se);
        }
        catch (Exception se) {
            throw new DriverConfigurazioneException("Exception : " + se.getMessage(), se);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception e) {}
        }
    }

    public static long CRUDPortaApplicativa(int type, PortaApplicativa aPA, Connection con) throws DriverConfigurazioneException {
        if (aPA == null) {
            throw new DriverConfigurazioneException("Porta Applicativa non valida.");
        }
        String nomePorta = aPA.getNome();
        String nomeProprietario = aPA.getNomeSoggettoProprietario();
        String tipoProprietario = aPA.getTipoSoggettoProprietario();
        if (nomePorta == null || nomePorta.equals("")) {
            throw new DriverConfigurazioneException("Nome della Porta Applicativa non valido.");
        }
        if (nomeProprietario == null || nomeProprietario.equals("")) {
            throw new DriverConfigurazioneException("Nome proprietario Porta Applicativa non valido.");
        }
        if (tipoProprietario == null || tipoProprietario.equals("")) {
            throw new DriverConfigurazioneException("Tipo proprietario della Porta Applicativa non valido.");
        }
        Statement stm = null;
        String sqlQuery = "";
        ResultSet rs = null;
        String descrizione = aPA.getDescrizione();
        PortaApplicativaAzione azione = aPA.getAzione();
        PortaApplicativaServizio servizio = aPA.getServizio();
        long idServizio = servizio != null && servizio.getId() != null ? servizio.getId() : -1L;
        PortaApplicativaSoggettoVirtuale soggVirt = aPA.getSoggettoVirtuale();
        String tipoSoggVirt = soggVirt != null ? soggVirt.getTipo() : null;
        String nomeSoggVirt = soggVirt != null ? soggVirt.getNome() : null;
        long idSoggVirt = -1L;
        try {
            idSoggVirt = DBUtils.getIdSoggetto(nomeSoggVirt, tipoSoggVirt, con, tipoDB, tabellaSoggetti);
        }
        catch (CoreException e1) {
            log.error((Object)e1);
        }
        ProprietaProtocollo propProtocollo = null;
        MtomProcessor mtomProcessor = aPA.getMtomProcessor();
        MTOMProcessorType mtomMode_request = null;
        MTOMProcessorType mtomMode_response = null;
        if (mtomProcessor != null) {
            if (mtomProcessor.getRequestFlow() != null) {
                mtomMode_request = mtomProcessor.getRequestFlow().getMode();
            }
            if (mtomProcessor.getResponseFlow() != null) {
                mtomMode_response = mtomProcessor.getResponseFlow().getMode();
            }
        }
        MessageSecurity messageSecurity = aPA.getMessageSecurity();
        String messageSecurityStatus = aPA.getStatoMessageSecurity();
        StatoFunzionalita messageSecurityApplyMtom_request = null;
        StatoFunzionalita messageSecurityApplyMtom_response = null;
        if (messageSecurity != null) {
            if (messageSecurity.getRequestFlow() != null) {
                messageSecurityApplyMtom_request = messageSecurity.getRequestFlow().getApplyToMtom();
            }
            if (messageSecurity.getResponseFlow() != null) {
                messageSecurityApplyMtom_response = messageSecurity.getResponseFlow().getApplyToMtom();
            }
        }
        CorrelazioneApplicativa corrApp = aPA.getCorrelazioneApplicativa();
        CorrelazioneApplicativaRisposta corrAppRisposta = aPA.getCorrelazioneApplicativaRisposta();
        ExtendedInfoManager extInfoManager = ExtendedInfoManager.getInstance();
        IExtendedInfo extInfoConfigurazioneDriver = extInfoManager.newInstanceExtendedInfoPortaApplicativa();
        try {
            int n = 0;
            int i = 0;
            long idPortaApplicativa = 0L;
            ServizioApplicativo servizioApplicativo = null;
            long idProprietario = DBUtils.getIdSoggetto(nomeProprietario, tipoProprietario, con, tipoDB, tabellaSoggetti);
            switch (type) {
                case 1: {
                    BaseBean cae;
                    BaseBean flow;
                    BaseBean resParam;
                    BaseBean flow2;
                    BaseBean reqParam;
                    String nomeServizio;
                    String tipoServizio = servizio != null ? servizio.getTipo() : null;
                    String string = nomeServizio = servizio != null ? servizio.getNome() : null;
                    if (idServizio <= 0L) {
                        if (tipoServizio == null || tipoServizio.equals("")) {
                            throw new DriverConfigurazioneException("Tipo Servizio non impostato.");
                        }
                        if (nomeServizio == null || nomeServizio.equals("")) {
                            throw new DriverConfigurazioneException("Nome Servizio non impostato.");
                        }
                    }
                    ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                    sqlQueryObject.addInsertTable("porte_applicative");
                    sqlQueryObject.addInsertField("nome_porta", "?");
                    sqlQueryObject.addInsertField("descrizione", "?");
                    sqlQueryObject.addInsertField("id_soggetto_virtuale", "?");
                    sqlQueryObject.addInsertField("tipo_soggetto_virtuale", "?");
                    sqlQueryObject.addInsertField("nome_soggetto_virtuale", "?");
                    sqlQueryObject.addInsertField("id_servizio", "?");
                    sqlQueryObject.addInsertField("tipo_servizio", "?");
                    sqlQueryObject.addInsertField("servizio", "?");
                    sqlQueryObject.addInsertField("azione", "?");
                    sqlQueryObject.addInsertField("mtom_request_mode", "?");
                    sqlQueryObject.addInsertField("mtom_response_mode", "?");
                    sqlQueryObject.addInsertField("ws_security", "?");
                    sqlQueryObject.addInsertField("ws_security_mtom_req", "?");
                    sqlQueryObject.addInsertField("ws_security_mtom_res", "?");
                    sqlQueryObject.addInsertField("id_soggetto", "?");
                    sqlQueryObject.addInsertField("ricevuta_asincrona_sim", "?");
                    sqlQueryObject.addInsertField("ricevuta_asincrona_asim", "?");
                    sqlQueryObject.addInsertField("integrazione", "?");
                    sqlQueryObject.addInsertField("validazione_contenuti_stato", "?");
                    sqlQueryObject.addInsertField("validazione_contenuti_tipo", "?");
                    sqlQueryObject.addInsertField("validazione_contenuti_mtom", "?");
                    sqlQueryObject.addInsertField("allega_body", "?");
                    sqlQueryObject.addInsertField("scarta_body", "?");
                    sqlQueryObject.addInsertField("gestione_manifest", "?");
                    sqlQueryObject.addInsertField("stateless", "?");
                    sqlQueryObject.addInsertField("behaviour", "?");
                    sqlQueryObject.addInsertField("autorizzazione_contenuto", "?");
                    sqlQueryObject.addInsertField("id_accordo", "?");
                    sqlQueryObject.addInsertField("id_port_type", "?");
                    sqlQueryObject.addInsertField("scadenza_correlazione_appl", "?");
                    sqlQuery = sqlQueryObject.createSQLInsert();
                    stm = con.prepareStatement(sqlQuery);
                    int index = 1;
                    stm.setString(index++, nomePorta);
                    stm.setString(index++, descrizione);
                    stm.setLong(index++, idSoggVirt);
                    stm.setString(index++, tipoSoggVirt);
                    stm.setString(index++, nomeSoggVirt);
                    stm.setLong(index++, idServizio);
                    stm.setString(index++, tipoServizio);
                    stm.setString(index++, nomeServizio);
                    stm.setString(index++, azione != null ? azione.getNome() : null);
                    stm.setString(index++, DriverConfigurazioneDB_LIB.getValue(mtomMode_request));
                    stm.setString(index++, DriverConfigurazioneDB_LIB.getValue(mtomMode_response));
                    stm.setString(index++, messageSecurityStatus);
                    stm.setString(index++, DriverConfigurazioneDB_LIB.getValue(messageSecurityApplyMtom_request));
                    stm.setString(index++, DriverConfigurazioneDB_LIB.getValue(messageSecurityApplyMtom_response));
                    stm.setLong(index++, idProprietario);
                    stm.setString(index++, aPA.getRicevutaAsincronaSimmetrica() != null ? DriverConfigurazioneDB_LIB.getValue(aPA.getRicevutaAsincronaSimmetrica()) : null);
                    stm.setString(index++, aPA.getRicevutaAsincronaAsimmetrica() != null ? DriverConfigurazioneDB_LIB.getValue(aPA.getRicevutaAsincronaAsimmetrica()) : null);
                    stm.setString(index++, aPA.getIntegrazione() != null ? aPA.getIntegrazione() : null);
                    stm.setString(index++, aPA.getValidazioneContenutiApplicativi() != null ? DriverConfigurazioneDB_LIB.getValue(aPA.getValidazioneContenutiApplicativi().getStato()) : null);
                    stm.setString(index++, aPA.getValidazioneContenutiApplicativi() != null ? DriverConfigurazioneDB_LIB.getValue(aPA.getValidazioneContenutiApplicativi().getTipo()) : null);
                    stm.setString(index++, aPA.getValidazioneContenutiApplicativi() != null ? DriverConfigurazioneDB_LIB.getValue(aPA.getValidazioneContenutiApplicativi().getAcceptMtomMessage()) : null);
                    stm.setString(index++, aPA != null ? DriverConfigurazioneDB_LIB.getValue(aPA.getAllegaBody()) : null);
                    stm.setString(index++, aPA != null ? DriverConfigurazioneDB_LIB.getValue(aPA.getScartaBody()) : null);
                    stm.setString(index++, aPA != null ? DriverConfigurazioneDB_LIB.getValue(aPA.getGestioneManifest()) : null);
                    stm.setString(index++, aPA != null ? DriverConfigurazioneDB_LIB.getValue(aPA.getStateless()) : null);
                    stm.setString(index++, aPA != null ? aPA.getBehaviour() : null);
                    stm.setString(index++, aPA != null ? aPA.getAutorizzazioneContenuto() : null);
                    stm.setLong(index++, aPA.getIdAccordo() != null ? aPA.getIdAccordo() : -1L);
                    stm.setLong(index++, aPA.getIdPortType() != null ? aPA.getIdPortType() : -1L);
                    stm.setString(index++, aPA.getCorrelazioneApplicativa() != null ? aPA.getCorrelazioneApplicativa().getScadenza() : null);
                    n = stm.executeUpdate();
                    stm.close();
                    log.debug((Object)("Created " + n + " row(s)"));
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                    sqlQueryObject.addFromTable("porte_applicative");
                    sqlQueryObject.addSelectField("id");
                    sqlQueryObject.addWhereCondition("id_soggetto = ?");
                    sqlQueryObject.addWhereCondition("nome_porta = ?");
                    sqlQueryObject.setANDLogicOperator(true);
                    sqlQuery = sqlQueryObject.createSQLQuery();
                    stm = con.prepareStatement(sqlQuery);
                    stm.setLong(1, idProprietario);
                    stm.setString(2, nomePorta);
                    rs = stm.executeQuery();
                    if (!rs.next()) {
                        throw new DriverConfigurazioneException("[DriverConfigurazioneDB_LIB::CRUDPortaApplicativa(CREATE)] Impossibile recuperare l'ID della PortaApplicativa appena create.");
                    }
                    idPortaApplicativa = rs.getLong("id");
                    aPA.setId(idPortaApplicativa);
                    rs.close();
                    stm.close();
                    if (mtomProcessor != null) {
                        reqParam = null;
                        sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                        sqlQueryObject.addInsertTable("pa_mtom_request");
                        sqlQueryObject.addInsertField("id_porta", "?");
                        sqlQueryObject.addInsertField("nome", "?");
                        sqlQueryObject.addInsertField("pattern", "?");
                        sqlQueryObject.addInsertField("content_type", "?");
                        sqlQueryObject.addInsertField("required", "?");
                        sqlQuery = sqlQueryObject.createSQLInsert();
                        stm = con.prepareStatement(sqlQuery);
                        i = 0;
                        if (mtomProcessor.getRequestFlow() != null) {
                            flow2 = mtomProcessor.getRequestFlow();
                            for (i = 0; i < flow2.sizeParameterList(); ++i) {
                                reqParam = flow2.getParameter(i);
                                stm.setLong(1, idPortaApplicativa);
                                stm.setString(2, reqParam.getNome());
                                stm.setString(3, reqParam.getPattern());
                                stm.setString(4, reqParam.getContentType());
                                stm.setInt(5, reqParam.getRequired() ? 1 : 0);
                                stm.executeUpdate();
                            }
                        }
                        stm.close();
                        log.debug((Object)("Inserted " + i + " mtom request flow con id=" + idPortaApplicativa));
                        resParam = null;
                        sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                        sqlQueryObject.addInsertTable("pa_mtom_response");
                        sqlQueryObject.addInsertField("id_porta", "?");
                        sqlQueryObject.addInsertField("nome", "?");
                        sqlQueryObject.addInsertField("pattern", "?");
                        sqlQueryObject.addInsertField("content_type", "?");
                        sqlQueryObject.addInsertField("required", "?");
                        sqlQuery = sqlQueryObject.createSQLInsert();
                        stm = con.prepareStatement(sqlQuery);
                        i = 0;
                        if (mtomProcessor.getResponseFlow() != null) {
                            flow = mtomProcessor.getResponseFlow();
                            for (i = 0; i < flow.sizeParameterList(); ++i) {
                                resParam = flow.getParameter(i);
                                stm.setLong(1, idPortaApplicativa);
                                stm.setString(2, resParam.getNome());
                                stm.setString(3, resParam.getPattern());
                                stm.setString(4, resParam.getContentType());
                                stm.setInt(5, resParam.getRequired() ? 1 : 0);
                                stm.executeUpdate();
                            }
                        }
                        stm.close();
                        log.debug((Object)("Inserted " + i + " mtom response flow con id=" + idPortaApplicativa));
                    }
                    if (messageSecurity != null) {
                        reqParam = null;
                        sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                        sqlQueryObject.addInsertTable("pa_ws_request");
                        sqlQueryObject.addInsertField("id_porta", "?");
                        sqlQueryObject.addInsertField("nome", "?");
                        sqlQueryObject.addInsertField("valore", "?");
                        sqlQuery = sqlQueryObject.createSQLInsert();
                        stm = con.prepareStatement(sqlQuery);
                        i = 0;
                        if (messageSecurity.getRequestFlow() != null) {
                            flow2 = messageSecurity.getRequestFlow();
                            for (i = 0; i < flow2.sizeParameterList(); ++i) {
                                reqParam = flow2.getParameter(i);
                                stm.setLong(1, idPortaApplicativa);
                                stm.setString(2, reqParam.getNome());
                                stm.setString(3, reqParam.getValore());
                                stm.executeUpdate();
                            }
                        }
                        stm.close();
                        log.debug((Object)("Inserted " + i + " request flow con id=" + idPortaApplicativa));
                        resParam = null;
                        sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                        sqlQueryObject.addInsertTable("pa_ws_response");
                        sqlQueryObject.addInsertField("id_porta", "?");
                        sqlQueryObject.addInsertField("nome", "?");
                        sqlQueryObject.addInsertField("valore", "?");
                        sqlQuery = sqlQueryObject.createSQLInsert();
                        stm = con.prepareStatement(sqlQuery);
                        i = 0;
                        if (messageSecurity.getResponseFlow() != null) {
                            flow = messageSecurity.getResponseFlow();
                            for (i = 0; i < flow.sizeParameterList(); ++i) {
                                resParam = flow.getParameter(i);
                                stm.setLong(1, idPortaApplicativa);
                                stm.setString(2, resParam.getNome());
                                stm.setString(3, resParam.getValore());
                                stm.executeUpdate();
                            }
                        }
                        stm.close();
                        log.debug((Object)("Inserted " + i + " response flow con id=" + idPortaApplicativa));
                    }
                    if (corrApp != null) {
                        cae = null;
                        sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                        sqlQueryObject.addInsertTable("pa_correlazione");
                        sqlQueryObject.addInsertField("id_porta", "?");
                        sqlQueryObject.addInsertField("nome_elemento", "?");
                        sqlQueryObject.addInsertField("mode_correlazione", "?");
                        sqlQueryObject.addInsertField("pattern", "?");
                        sqlQueryObject.addInsertField("identificazione_fallita", "?");
                        sqlQuery = sqlQueryObject.createSQLInsert();
                        stm = con.prepareStatement(sqlQuery);
                        for (i = 0; i < corrApp.sizeElementoList(); ++i) {
                            cae = corrApp.getElemento(i);
                            stm.setLong(1, idPortaApplicativa);
                            stm.setString(2, cae.getNome());
                            stm.setString(3, DriverConfigurazioneDB_LIB.getValue(cae.getIdentificazione()));
                            if (cae.getPattern() != null) {
                                stm.setString(4, cae.getPattern());
                            } else {
                                stm.setString(4, "");
                            }
                            stm.setString(5, DriverConfigurazioneDB_LIB.getValue(cae.getIdentificazioneFallita()));
                            stm.executeUpdate();
                        }
                        stm.close();
                        log.debug((Object)("Inserted " + i + " correlazione applicativa con id=" + idPortaApplicativa));
                    }
                    if (corrAppRisposta != null) {
                        cae = null;
                        sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                        sqlQueryObject.addInsertTable("pa_correlazione_risposta");
                        sqlQueryObject.addInsertField("id_porta", "?");
                        sqlQueryObject.addInsertField("nome_elemento", "?");
                        sqlQueryObject.addInsertField("mode_correlazione", "?");
                        sqlQueryObject.addInsertField("pattern", "?");
                        sqlQueryObject.addInsertField("identificazione_fallita", "?");
                        sqlQuery = sqlQueryObject.createSQLInsert();
                        stm = con.prepareStatement(sqlQuery);
                        for (i = 0; i < corrAppRisposta.sizeElementoList(); ++i) {
                            cae = corrAppRisposta.getElemento(i);
                            stm.setLong(1, idPortaApplicativa);
                            stm.setString(2, cae.getNome());
                            stm.setString(3, DriverConfigurazioneDB_LIB.getValue(cae.getIdentificazione()));
                            if (cae.getPattern() != null) {
                                stm.setString(4, cae.getPattern());
                            } else {
                                stm.setString(4, "");
                            }
                            stm.setString(5, DriverConfigurazioneDB_LIB.getValue(cae.getIdentificazioneFallita()));
                            stm.executeUpdate();
                        }
                        stm.close();
                        log.debug((Object)("Inserted " + i + " correlazione applicativa risposta con id=" + idPortaApplicativa));
                    }
                    servizioApplicativo = null;
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                    sqlQueryObject.addInsertTable("porte_applicative_sa");
                    sqlQueryObject.addInsertField("id_porta", "?");
                    sqlQueryObject.addInsertField("id_servizio_applicativo", "?");
                    sqlQuery = sqlQueryObject.createSQLInsert();
                    stm = con.prepareStatement(sqlQuery);
                    for (i = 0; i < aPA.sizeServizioApplicativoList(); ++i) {
                        servizioApplicativo = aPA.getServizioApplicativo(i);
                        String nomeSA = servizioApplicativo.getNome();
                        String nomeProprietarioSA = aPA.getNomeSoggettoProprietario();
                        String tipoProprietarioSA = aPA.getTipoSoggettoProprietario();
                        if (nomeSA == null || nomeSA.equals("")) {
                            throw new DriverConfigurazioneException("[CRUDPortaApplicativa(CREATE)::Nome del ServizioApplicativo associato non valido.");
                        }
                        if (nomeProprietarioSA == null || nomeProprietarioSA.equals("")) {
                            throw new DriverConfigurazioneException("[CRUDPortaApplicativa(CREATE)::Nome Proprietario del ServizioApplicativo associato non valido.");
                        }
                        if (tipoProprietarioSA == null || tipoProprietarioSA.equals("")) {
                            throw new DriverConfigurazioneException("[CRUDPortaApplicativa(CREATE)::Tipo Proprietario del ServizioApplicativo associato non valido.");
                        }
                        long idSA = DriverConfigurazioneDB_LIB.getIdServizioApplicativo(nomeSA, tipoProprietarioSA, nomeProprietarioSA, con, tipoDB, tabellaSoggetti);
                        if (idSA <= 0L) {
                            throw new DriverConfigurazioneException("Impossibile recuperare l'id del Servizio Applicativo [" + nomeSA + "] di [" + tipoProprietarioSA + "/" + nomeProprietarioSA + "]");
                        }
                        stm.setLong(1, idPortaApplicativa);
                        stm.setLong(2, idSA);
                        stm.executeUpdate();
                    }
                    stm.close();
                    log.debug((Object)("Insererted " + i + " servizi applicativi associati alla PortaApplicativa[" + idPortaApplicativa + "]"));
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                    sqlQueryObject.addInsertTable("pa_properties");
                    sqlQueryObject.addInsertField("id_porta", "?");
                    sqlQueryObject.addInsertField("nome", "?");
                    sqlQueryObject.addInsertField("valore", "?");
                    sqlQuery = sqlQueryObject.createSQLInsert();
                    stm = con.prepareStatement(sqlQuery);
                    for (i = 0; i < aPA.sizeProprietaProtocolloList(); ++i) {
                        propProtocollo = aPA.getProprietaProtocollo(i);
                        stm.setLong(1, idPortaApplicativa);
                        stm.setString(2, propProtocollo.getNome());
                        stm.setString(3, propProtocollo.getValore());
                        stm.executeUpdate();
                    }
                    stm.close();
                    log.debug((Object)("Insererted " + i + " SetProtocolProp associati alla PortaApplicativa[" + idPortaApplicativa + "]"));
                    i = 0;
                    if (aPA.sizeExtendedInfoList() > 0 && extInfoConfigurazioneDriver != null) {
                        for (i = 0; i < aPA.sizeExtendedInfoList(); ++i) {
                            extInfoConfigurazioneDriver.createExtendedInfo(con, log, aPA, aPA.getExtendedInfo(i));
                        }
                    }
                    log.debug((Object)("Aggiunte " + i + " associazioni ExtendedInfo<->PortaApplicativa associati alla PortaApplicativa[" + idPortaApplicativa + "]"));
                    break;
                }
                case 2: {
                    BaseBean cae;
                    BaseBean flow;
                    BaseBean resParam;
                    BaseBean flow3;
                    BaseBean reqParam;
                    String nomeServizio;
                    String oldNomePA = aPA.getOldNomeForUpdate();
                    String oldNomeProprietario = aPA.getOldNomeSoggettoProprietarioForUpdate();
                    String oldTipoProprietario = aPA.getOldTipoSoggettoProprietarioForUpdate();
                    if (oldNomePA == null || oldNomePA.equals("")) {
                        oldNomePA = nomePorta;
                    }
                    if (oldNomeProprietario == null || oldNomeProprietario.equals("")) {
                        oldNomeProprietario = nomeProprietario;
                    }
                    if (oldTipoProprietario == null || oldTipoProprietario.equals("")) {
                        oldTipoProprietario = tipoProprietario;
                    }
                    String tipoServizio = servizio != null ? servizio.getTipo() : null;
                    String string = nomeServizio = servizio != null ? servizio.getNome() : null;
                    if (idServizio <= 0L) {
                        if (tipoServizio == null || tipoServizio.equals("")) {
                            throw new DriverConfigurazioneException("Tipo Servizio non impostato.");
                        }
                        if (nomeServizio == null || nomeServizio.equals("")) {
                            throw new DriverConfigurazioneException("Nome Servizio non impostato.");
                        }
                    }
                    ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                    sqlQueryObject.addUpdateTable("porte_applicative");
                    sqlQueryObject.addUpdateField("descrizione", "?");
                    sqlQueryObject.addUpdateField("id_soggetto_virtuale", "?");
                    sqlQueryObject.addUpdateField("tipo_soggetto_virtuale", "?");
                    sqlQueryObject.addUpdateField("nome_soggetto_virtuale", "?");
                    sqlQueryObject.addUpdateField("id_servizio", "?");
                    sqlQueryObject.addUpdateField("tipo_servizio", "?");
                    sqlQueryObject.addUpdateField("servizio", "?");
                    sqlQueryObject.addUpdateField("azione", "?");
                    sqlQueryObject.addUpdateField("mtom_request_mode", "?");
                    sqlQueryObject.addUpdateField("mtom_response_mode", "?");
                    sqlQueryObject.addUpdateField("ws_security", "?");
                    sqlQueryObject.addUpdateField("ws_security_mtom_req", "?");
                    sqlQueryObject.addUpdateField("ws_security_mtom_res", "?");
                    sqlQueryObject.addUpdateField("nome_porta", "?");
                    sqlQueryObject.addUpdateField("ricevuta_asincrona_sim", "?");
                    sqlQueryObject.addUpdateField("ricevuta_asincrona_asim", "?");
                    sqlQueryObject.addUpdateField("integrazione", "?");
                    sqlQueryObject.addUpdateField("validazione_contenuti_stato", "?");
                    sqlQueryObject.addUpdateField("validazione_contenuti_tipo", "?");
                    sqlQueryObject.addUpdateField("validazione_contenuti_mtom", "?");
                    sqlQueryObject.addUpdateField("id_soggetto", "?");
                    sqlQueryObject.addUpdateField("allega_body", "?");
                    sqlQueryObject.addUpdateField("scarta_body", "?");
                    sqlQueryObject.addUpdateField("gestione_manifest", "?");
                    sqlQueryObject.addUpdateField("stateless", "?");
                    sqlQueryObject.addUpdateField("behaviour", "?");
                    sqlQueryObject.addUpdateField("autorizzazione_contenuto", "?");
                    sqlQueryObject.addUpdateField("id_accordo", "?");
                    sqlQueryObject.addUpdateField("id_port_type", "?");
                    sqlQueryObject.addUpdateField("scadenza_correlazione_appl", "?");
                    sqlQueryObject.addWhereCondition("id_soggetto=?");
                    sqlQueryObject.addWhereCondition("nome_porta=?");
                    sqlQueryObject.setANDLogicOperator(true);
                    sqlQuery = sqlQueryObject.createSQLUpdate();
                    stm = con.prepareStatement(sqlQuery);
                    idPortaApplicativa = DBUtils.getIdPortaApplicativa(oldNomePA, oldTipoProprietario, oldNomeProprietario, con, tipoDB, tabellaSoggetti);
                    if (idPortaApplicativa <= 0L) {
                        idPortaApplicativa = DBUtils.getIdPortaApplicativa(oldNomePA, tipoProprietario, nomeProprietario, con, tipoDB, tabellaSoggetti);
                    }
                    if (idPortaApplicativa <= 0L) {
                        throw new DriverConfigurazioneException("Impossibile recuperare l'id della Porta Applicativa nomePA[" + oldNomePA + "] (old[" + aPA.getOldNomeForUpdate() + "]) tipoProprietario[" + oldTipoProprietario + "] (old[" + aPA.getOldTipoSoggettoProprietarioForUpdate() + "]) nomeProprietario[" + oldNomeProprietario + "] (old[" + aPA.getOldNomeSoggettoProprietarioForUpdate() + "])");
                    }
                    long oldIdProprietario = DBUtils.getIdSoggetto(oldNomeProprietario, oldTipoProprietario, con, tipoDB, tabellaSoggetti);
                    if (oldIdProprietario <= 0L) {
                        oldIdProprietario = DBUtils.getIdSoggetto(nomeProprietario, tipoProprietario, con, tipoDB, tabellaSoggetti);
                    }
                    if (oldIdProprietario <= 0L) {
                        throw new DriverConfigurazioneException("Impossibile recuperare l'id del Soggetto Proprietario della Porta Applicativa");
                    }
                    int index = 1;
                    stm.setString(index++, descrizione);
                    stm.setLong(index++, idSoggVirt);
                    stm.setString(index++, tipoSoggVirt);
                    stm.setString(index++, nomeSoggVirt);
                    stm.setLong(index++, idServizio);
                    stm.setString(index++, tipoServizio);
                    stm.setString(index++, nomeServizio);
                    stm.setString(index++, azione != null ? azione.getNome() : null);
                    stm.setString(index++, DriverConfigurazioneDB_LIB.getValue(mtomMode_request));
                    stm.setString(index++, DriverConfigurazioneDB_LIB.getValue(mtomMode_response));
                    stm.setString(index++, messageSecurityStatus);
                    stm.setString(index++, DriverConfigurazioneDB_LIB.getValue(messageSecurityApplyMtom_request));
                    stm.setString(index++, DriverConfigurazioneDB_LIB.getValue(messageSecurityApplyMtom_response));
                    stm.setString(index++, nomePorta);
                    stm.setString(index++, aPA.getRicevutaAsincronaSimmetrica() != null ? DriverConfigurazioneDB_LIB.getValue(aPA.getRicevutaAsincronaSimmetrica()) : null);
                    stm.setString(index++, aPA.getRicevutaAsincronaAsimmetrica() != null ? DriverConfigurazioneDB_LIB.getValue(aPA.getRicevutaAsincronaAsimmetrica()) : null);
                    stm.setString(index++, aPA.getIntegrazione() != null ? aPA.getIntegrazione() : null);
                    stm.setString(index++, aPA.getValidazioneContenutiApplicativi() != null ? DriverConfigurazioneDB_LIB.getValue(aPA.getValidazioneContenutiApplicativi().getStato()) : null);
                    stm.setString(index++, aPA.getValidazioneContenutiApplicativi() != null ? DriverConfigurazioneDB_LIB.getValue(aPA.getValidazioneContenutiApplicativi().getTipo()) : null);
                    stm.setString(index++, aPA.getValidazioneContenutiApplicativi() != null ? DriverConfigurazioneDB_LIB.getValue(aPA.getValidazioneContenutiApplicativi().getAcceptMtomMessage()) : null);
                    stm.setLong(index++, idProprietario);
                    stm.setString(index++, aPA != null ? DriverConfigurazioneDB_LIB.getValue(aPA.getAllegaBody()) : null);
                    stm.setString(index++, aPA != null ? DriverConfigurazioneDB_LIB.getValue(aPA.getScartaBody()) : null);
                    stm.setString(index++, aPA != null ? DriverConfigurazioneDB_LIB.getValue(aPA.getGestioneManifest()) : null);
                    stm.setString(index++, aPA != null ? DriverConfigurazioneDB_LIB.getValue(aPA.getStateless()) : null);
                    stm.setString(index++, aPA != null ? aPA.getBehaviour() : null);
                    stm.setString(index++, aPA != null ? aPA.getAutorizzazioneContenuto() : null);
                    stm.setLong(index++, aPA.getIdAccordo() != null ? aPA.getIdAccordo() : -1L);
                    stm.setLong(index++, aPA.getIdPortType() != null ? aPA.getIdPortType() : -1L);
                    stm.setString(index++, aPA.getCorrelazioneApplicativa() != null ? aPA.getCorrelazioneApplicativa().getScadenza() : null);
                    stm.setLong(index++, oldIdProprietario);
                    stm.setString(index++, oldNomePA);
                    n = stm.executeUpdate();
                    stm.close();
                    log.debug((Object)("Updated " + n + " row(s)."));
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                    sqlQueryObject.addDeleteTable("pa_mtom_request");
                    sqlQueryObject.addWhereCondition("id_porta=?");
                    sqlQuery = sqlQueryObject.createSQLDelete();
                    stm = con.prepareStatement(sqlQuery);
                    stm.setLong(1, idPortaApplicativa);
                    stm.executeUpdate();
                    stm.close();
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                    sqlQueryObject.addDeleteTable("pa_mtom_response");
                    sqlQueryObject.addWhereCondition("id_porta=?");
                    sqlQuery = sqlQueryObject.createSQLDelete();
                    stm = con.prepareStatement(sqlQuery);
                    stm.setLong(1, idPortaApplicativa);
                    stm.executeUpdate();
                    stm.close();
                    if (mtomProcessor != null) {
                        reqParam = null;
                        sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                        sqlQueryObject.addInsertTable("pa_mtom_request");
                        sqlQueryObject.addInsertField("id_porta", "?");
                        sqlQueryObject.addInsertField("nome", "?");
                        sqlQueryObject.addInsertField("pattern", "?");
                        sqlQueryObject.addInsertField("content_type", "?");
                        sqlQueryObject.addInsertField("required", "?");
                        sqlQuery = sqlQueryObject.createSQLInsert();
                        stm = con.prepareStatement(sqlQuery);
                        i = 0;
                        if (mtomProcessor.getRequestFlow() != null) {
                            flow3 = mtomProcessor.getRequestFlow();
                            for (i = 0; i < flow3.sizeParameterList(); ++i) {
                                reqParam = flow3.getParameter(i);
                                stm.setLong(1, idPortaApplicativa);
                                stm.setString(2, reqParam.getNome());
                                stm.setString(3, reqParam.getPattern());
                                stm.setString(4, reqParam.getContentType());
                                stm.setInt(5, reqParam.getRequired() ? 1 : 0);
                                stm.executeUpdate();
                            }
                        }
                        stm.close();
                        log.debug((Object)("Inserted " + i + " mtom request flow con id=" + idPortaApplicativa));
                        resParam = null;
                        sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                        sqlQueryObject.addInsertTable("pa_mtom_response");
                        sqlQueryObject.addInsertField("id_porta", "?");
                        sqlQueryObject.addInsertField("nome", "?");
                        sqlQueryObject.addInsertField("pattern", "?");
                        sqlQueryObject.addInsertField("content_type", "?");
                        sqlQueryObject.addInsertField("required", "?");
                        sqlQuery = sqlQueryObject.createSQLInsert();
                        stm = con.prepareStatement(sqlQuery);
                        i = 0;
                        if (mtomProcessor.getResponseFlow() != null) {
                            flow = mtomProcessor.getResponseFlow();
                            for (i = 0; i < flow.sizeParameterList(); ++i) {
                                resParam = flow.getParameter(i);
                                stm.setLong(1, idPortaApplicativa);
                                stm.setString(2, resParam.getNome());
                                stm.setString(3, resParam.getPattern());
                                stm.setString(4, resParam.getContentType());
                                stm.setInt(5, resParam.getRequired() ? 1 : 0);
                                stm.executeUpdate();
                            }
                        }
                        stm.close();
                        log.debug((Object)("Inserted " + i + " mtom response flow con id=" + idPortaApplicativa));
                    }
                    if (messageSecurity != null) {
                        sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                        sqlQueryObject.addDeleteTable("pa_ws_request");
                        sqlQueryObject.addWhereCondition("id_porta=?");
                        sqlQuery = sqlQueryObject.createSQLDelete();
                        stm = con.prepareStatement(sqlQuery);
                        stm.setLong(1, idPortaApplicativa);
                        stm.executeUpdate();
                        stm.close();
                        sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                        sqlQueryObject.addDeleteTable("pa_ws_response");
                        sqlQueryObject.addWhereCondition("id_porta=?");
                        sqlQuery = sqlQueryObject.createSQLDelete();
                        stm = con.prepareStatement(sqlQuery);
                        stm.setLong(1, idPortaApplicativa);
                        stm.executeUpdate();
                        stm.close();
                        reqParam = null;
                        sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                        sqlQueryObject.addInsertTable("pa_ws_request");
                        sqlQueryObject.addInsertField("id_porta", "?");
                        sqlQueryObject.addInsertField("nome", "?");
                        sqlQueryObject.addInsertField("valore", "?");
                        sqlQuery = sqlQueryObject.createSQLInsert();
                        stm = con.prepareStatement(sqlQuery);
                        i = 0;
                        if (messageSecurity.getRequestFlow() != null) {
                            flow3 = messageSecurity.getRequestFlow();
                            for (i = 0; i < flow3.sizeParameterList(); ++i) {
                                reqParam = flow3.getParameter(i);
                                stm.setLong(1, idPortaApplicativa);
                                stm.setString(2, reqParam.getNome());
                                stm.setString(3, reqParam.getValore());
                                stm.executeUpdate();
                            }
                        }
                        stm.close();
                        log.debug((Object)("Inserted " + i + " request flow con id=" + idPortaApplicativa));
                        resParam = null;
                        sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                        sqlQueryObject.addInsertTable("pa_ws_response");
                        sqlQueryObject.addInsertField("id_porta", "?");
                        sqlQueryObject.addInsertField("nome", "?");
                        sqlQueryObject.addInsertField("valore", "?");
                        sqlQuery = sqlQueryObject.createSQLInsert();
                        stm = con.prepareStatement(sqlQuery);
                        i = 0;
                        if (messageSecurity.getResponseFlow() != null) {
                            flow = messageSecurity.getResponseFlow();
                            for (i = 0; i < flow.sizeParameterList(); ++i) {
                                resParam = flow.getParameter(i);
                                stm.setLong(1, idPortaApplicativa);
                                stm.setString(2, resParam.getNome());
                                stm.setString(3, resParam.getValore());
                                stm.executeUpdate();
                            }
                        }
                        stm.close();
                        log.debug((Object)("Inserted " + i + " response flow con id=" + idPortaApplicativa));
                    }
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                    sqlQueryObject.addDeleteTable("pa_correlazione");
                    sqlQueryObject.addWhereCondition("id_porta=?");
                    sqlQuery = sqlQueryObject.createSQLDelete();
                    stm = con.prepareStatement(sqlQuery);
                    stm.setLong(1, idPortaApplicativa);
                    stm.executeUpdate();
                    stm.close();
                    if (corrApp != null) {
                        cae = null;
                        sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                        sqlQueryObject.addInsertTable("pa_correlazione");
                        sqlQueryObject.addInsertField("id_porta", "?");
                        sqlQueryObject.addInsertField("nome_elemento", "?");
                        sqlQueryObject.addInsertField("mode_correlazione", "?");
                        sqlQueryObject.addInsertField("pattern", "?");
                        sqlQueryObject.addInsertField("identificazione_fallita", "?");
                        sqlQuery = sqlQueryObject.createSQLInsert();
                        stm = con.prepareStatement(sqlQuery);
                        for (i = 0; i < corrApp.sizeElementoList(); ++i) {
                            cae = corrApp.getElemento(i);
                            stm.setLong(1, idPortaApplicativa);
                            stm.setString(2, cae.getNome());
                            stm.setString(3, DriverConfigurazioneDB_LIB.getValue(cae.getIdentificazione()));
                            if (cae.getPattern() != null) {
                                stm.setString(4, cae.getPattern());
                            } else {
                                stm.setString(4, "");
                            }
                            stm.setString(5, DriverConfigurazioneDB_LIB.getValue(cae.getIdentificazioneFallita()));
                            stm.executeUpdate();
                        }
                        stm.close();
                        log.debug((Object)("Inserted " + i + " correlazione applicativa con id=" + idPortaApplicativa));
                    }
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                    sqlQueryObject.addDeleteTable("pa_correlazione_risposta");
                    sqlQueryObject.addWhereCondition("id_porta=?");
                    sqlQuery = sqlQueryObject.createSQLDelete();
                    stm = con.prepareStatement(sqlQuery);
                    stm.setLong(1, idPortaApplicativa);
                    stm.executeUpdate();
                    stm.close();
                    if (corrAppRisposta != null) {
                        cae = null;
                        sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                        sqlQueryObject.addInsertTable("pa_correlazione_risposta");
                        sqlQueryObject.addInsertField("id_porta", "?");
                        sqlQueryObject.addInsertField("nome_elemento", "?");
                        sqlQueryObject.addInsertField("mode_correlazione", "?");
                        sqlQueryObject.addInsertField("pattern", "?");
                        sqlQueryObject.addInsertField("identificazione_fallita", "?");
                        sqlQuery = sqlQueryObject.createSQLInsert();
                        stm = con.prepareStatement(sqlQuery);
                        for (i = 0; i < corrAppRisposta.sizeElementoList(); ++i) {
                            cae = corrAppRisposta.getElemento(i);
                            stm.setLong(1, idPortaApplicativa);
                            stm.setString(2, cae.getNome());
                            stm.setString(3, DriverConfigurazioneDB_LIB.getValue(cae.getIdentificazione()));
                            if (cae.getPattern() != null) {
                                stm.setString(4, cae.getPattern());
                            } else {
                                stm.setString(4, "");
                            }
                            stm.setString(5, DriverConfigurazioneDB_LIB.getValue(cae.getIdentificazioneFallita()));
                            stm.executeUpdate();
                        }
                        stm.close();
                        log.debug((Object)("Inserted " + i + " correlazione applicativa risposta con id=" + idPortaApplicativa));
                    }
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                    sqlQueryObject.addDeleteTable("porte_applicative_sa");
                    sqlQueryObject.addWhereCondition("id_porta=?");
                    sqlQuery = sqlQueryObject.createSQLDelete();
                    stm = con.prepareStatement(sqlQuery);
                    stm.setLong(1, idPortaApplicativa);
                    n = stm.executeUpdate();
                    stm.close();
                    log.debug((Object)("Cancellati " + n + " servizi applicativi associati alla Porta Applicativa " + idPortaApplicativa));
                    n = 0;
                    for (i = 0; i < aPA.sizeServizioApplicativoList(); ++i) {
                        servizioApplicativo = aPA.getServizioApplicativo(i);
                        String nomeSA = servizioApplicativo.getNome();
                        String nomeProprietarioSA = aPA.getNomeSoggettoProprietario();
                        String tipoProprietarioSA = aPA.getTipoSoggettoProprietario();
                        if (nomeSA == null || nomeSA.equals("")) {
                            throw new DriverConfigurazioneException("Nome del ServizioApplicativo associato non valido.");
                        }
                        if (nomeProprietarioSA == null || nomeProprietarioSA.equals("")) {
                            throw new DriverConfigurazioneException("Nome Proprietario del ServizioApplicativo associato non valido.");
                        }
                        if (tipoProprietarioSA == null || tipoProprietarioSA.equals("")) {
                            throw new DriverConfigurazioneException("Tipo Proprietario del ServizioApplicativo associato non valido.");
                        }
                        long idSA = DriverConfigurazioneDB_LIB.getIdServizioApplicativo(nomeSA, tipoProprietarioSA, nomeProprietarioSA, con, tipoDB, tabellaSoggetti);
                        if (idSA <= 0L) {
                            throw new DriverConfigurazioneException("Impossibile recuperare l'id del Servizio Applicativo [" + nomeSA + "] di [" + tipoProprietarioSA + "/" + nomeProprietarioSA + "]");
                        }
                        sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                        sqlQueryObject.addInsertTable("porte_applicative_sa");
                        sqlQueryObject.addInsertField("id_porta", "?");
                        sqlQueryObject.addInsertField("id_servizio_applicativo", "?");
                        sqlQuery = sqlQueryObject.createSQLInsert();
                        stm = con.prepareStatement(sqlQuery);
                        stm.setLong(1, idPortaApplicativa);
                        stm.setLong(2, idSA);
                        stm.executeUpdate();
                        stm.close();
                        ++n;
                        log.debug((Object)("Aggiunta associazione PortaApplicativa<->ServizioApplicativo [" + idPortaApplicativa + "]<->[" + idSA + "]"));
                    }
                    log.debug((Object)("Aggiunti " + n + " associazioni PortaApplicativa<->ServizioApplicativo associati alla PortaDelegata[" + idPortaApplicativa + "]"));
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                    sqlQueryObject.addDeleteTable("pa_properties");
                    sqlQueryObject.addWhereCondition("id_porta=?");
                    sqlQuery = sqlQueryObject.createSQLDelete();
                    stm = con.prepareStatement(sqlQuery);
                    stm.setLong(1, idPortaApplicativa);
                    n = stm.executeUpdate();
                    stm.close();
                    log.debug((Object)("Eliminate " + n + " proprieta associate alla Porta Applicativa " + idPortaApplicativa));
                    int newProps = 0;
                    for (i = 0; i < aPA.sizeProprietaProtocolloList(); ++i) {
                        propProtocollo = aPA.getProprietaProtocollo(i);
                        sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                        sqlQueryObject.addInsertTable("pa_properties");
                        sqlQueryObject.addInsertField("id_porta", "?");
                        sqlQueryObject.addInsertField("nome", "?");
                        sqlQueryObject.addInsertField("valore", "?");
                        sqlQuery = sqlQueryObject.createSQLInsert();
                        stm = con.prepareStatement(sqlQuery);
                        stm.setLong(1, idPortaApplicativa);
                        stm.setString(2, propProtocollo.getNome());
                        stm.setString(3, propProtocollo.getValore());
                        stm.executeUpdate();
                        stm.close();
                        ++newProps;
                    }
                    log.debug((Object)("Inserted " + newProps + " SetProtocolProp associati alla PortaApplicativa[" + idPortaApplicativa + "]"));
                    if (extInfoConfigurazioneDriver != null) {
                        extInfoConfigurazioneDriver.deleteAllExtendedInfo(con, log, aPA);
                    }
                    i = 0;
                    if (aPA.sizeExtendedInfoList() > 0 && extInfoConfigurazioneDriver != null) {
                        for (i = 0; i < aPA.sizeExtendedInfoList(); ++i) {
                            extInfoConfigurazioneDriver.createExtendedInfo(con, log, aPA, aPA.getExtendedInfo(i));
                        }
                    }
                    log.debug((Object)("Aggiunte " + i + " associazioni ExtendedInfo<->PortaApplicativa associati alla PortaApplicativa[" + idPortaApplicativa + "]"));
                    break;
                }
                case 3: {
                    idPortaApplicativa = DBUtils.getIdPortaApplicativa(nomePorta, tipoProprietario, nomeProprietario, con, tipoDB, tabellaSoggetti);
                    if (idPortaApplicativa <= 0L) {
                        throw new DriverConfigurazioneException("Non e' stato possibile recuperare l'id della Porta Applicativa.");
                    }
                    ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                    sqlQueryObject.addDeleteTable("pa_mtom_request");
                    sqlQueryObject.addWhereCondition("id_porta=?");
                    sqlQuery = sqlQueryObject.createSQLDelete();
                    stm = con.prepareStatement(sqlQuery);
                    stm.setLong(1, idPortaApplicativa);
                    n = stm.executeUpdate();
                    stm.close();
                    log.debug((Object)("Deleted " + n + " request flow con id=" + idPortaApplicativa));
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                    sqlQueryObject.addDeleteTable("pa_mtom_response");
                    sqlQueryObject.addWhereCondition("id_porta=?");
                    sqlQuery = sqlQueryObject.createSQLDelete();
                    stm = con.prepareStatement(sqlQuery);
                    stm.setLong(1, idPortaApplicativa);
                    n = stm.executeUpdate();
                    stm.close();
                    log.debug((Object)("Deleted " + n + " response flow con id=" + idPortaApplicativa));
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                    sqlQueryObject.addDeleteTable("pa_ws_request");
                    sqlQueryObject.addWhereCondition("id_porta=?");
                    sqlQuery = sqlQueryObject.createSQLDelete();
                    stm = con.prepareStatement(sqlQuery);
                    stm.setLong(1, idPortaApplicativa);
                    n = stm.executeUpdate();
                    stm.close();
                    log.debug((Object)("Deleted " + n + " request flow con id=" + idPortaApplicativa));
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                    sqlQueryObject.addDeleteTable("pa_ws_response");
                    sqlQueryObject.addWhereCondition("id_porta=?");
                    sqlQuery = sqlQueryObject.createSQLDelete();
                    stm = con.prepareStatement(sqlQuery);
                    stm.setLong(1, idPortaApplicativa);
                    n = stm.executeUpdate();
                    stm.close();
                    log.debug((Object)("Deleted " + n + " response flow con id=" + idPortaApplicativa));
                    servizioApplicativo = null;
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                    sqlQueryObject.addDeleteTable("porte_applicative_sa");
                    sqlQueryObject.addWhereCondition("id_porta=?");
                    sqlQuery = sqlQueryObject.createSQLDelete();
                    stm = con.prepareStatement(sqlQuery);
                    stm.setLong(1, idPortaApplicativa);
                    n = stm.executeUpdate();
                    stm.close();
                    log.debug((Object)("Deleted " + n + " servizi applicativi associati alla PortaApplicativa[" + idPortaApplicativa + "]"));
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                    sqlQueryObject.addDeleteTable("pa_ws_request");
                    sqlQueryObject.addWhereCondition("id_porta=?");
                    sqlQuery = sqlQueryObject.createSQLDelete();
                    stm = con.prepareStatement(sqlQuery);
                    stm.setLong(1, idPortaApplicativa);
                    n = stm.executeUpdate();
                    stm.close();
                    if (n > 0) {
                        log.debug((Object)("Deleted " + n + " ws_request flow associate alla PortaApplicativa[" + idPortaApplicativa + "]"));
                    }
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                    sqlQueryObject.addDeleteTable("pa_ws_response");
                    sqlQueryObject.addWhereCondition("id_porta=?");
                    sqlQuery = sqlQueryObject.createSQLDelete();
                    stm = con.prepareStatement(sqlQuery);
                    stm.setLong(1, idPortaApplicativa);
                    n = stm.executeUpdate();
                    stm.close();
                    if (n > 0) {
                        log.debug((Object)("Deleted " + n + " ws_response flow associate alla PortaApplicativa[" + idPortaApplicativa + "]"));
                    }
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                    sqlQueryObject.addDeleteTable("pa_correlazione");
                    sqlQueryObject.addWhereCondition("id_porta=?");
                    sqlQuery = sqlQueryObject.createSQLDelete();
                    stm = con.prepareStatement(sqlQuery);
                    stm.setLong(1, idPortaApplicativa);
                    n = stm.executeUpdate();
                    stm.close();
                    if (n > 0) {
                        log.debug((Object)("Deleted " + n + " correlazione associate alla PortaApplicativa[" + idPortaApplicativa + "]"));
                    }
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                    sqlQueryObject.addDeleteTable("pa_correlazione_risposta");
                    sqlQueryObject.addWhereCondition("id_porta=?");
                    sqlQuery = sqlQueryObject.createSQLDelete();
                    stm = con.prepareStatement(sqlQuery);
                    stm.setLong(1, idPortaApplicativa);
                    n = stm.executeUpdate();
                    stm.close();
                    if (n > 0) {
                        log.debug((Object)("Deleted " + n + " correlazione della risposta associate alla PortaApplicativa[" + idPortaApplicativa + "]"));
                    }
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                    sqlQueryObject.addDeleteTable("pa_properties");
                    sqlQueryObject.addWhereCondition("id_porta=?");
                    sqlQuery = sqlQueryObject.createSQLDelete();
                    stm = con.prepareStatement(sqlQuery);
                    stm.setLong(1, idPortaApplicativa);
                    n = stm.executeUpdate();
                    stm.close();
                    if (n > 0) {
                        log.debug((Object)("Deleted " + n + " SetProtocolProp associati alla PortaApplicativa[" + idPortaApplicativa + "]"));
                    }
                    if (extInfoConfigurazioneDriver != null) {
                        extInfoConfigurazioneDriver.deleteAllExtendedInfo(con, log, aPA);
                    }
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                    sqlQueryObject.addDeleteTable("porte_applicative");
                    sqlQueryObject.addWhereCondition("id=?");
                    sqlQueryObject.addWhereCondition("id_soggetto=?");
                    sqlQueryObject.addWhereCondition("nome_porta=?");
                    sqlQueryObject.setANDLogicOperator(true);
                    sqlQuery = sqlQueryObject.createSQLDelete();
                    stm = con.prepareStatement(sqlQuery);
                    stm.setLong(1, idPortaApplicativa);
                    stm.setLong(2, idProprietario);
                    stm.setString(3, nomePorta);
                    n = stm.executeUpdate();
                    stm.close();
                    log.debug((Object)("Deleted " + n + " row(s)."));
                }
            }
            long l = idPortaApplicativa;
            return l;
        }
        catch (DriverConfigurazioneException e) {
            throw e;
        }
        catch (SQLException se) {
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB_LIB::CRUDPortaApplicativa] SQLException [" + se.getMessage() + "].", se);
        }
        catch (Exception e) {
            throw new DriverConfigurazioneException("Errore durante operazione(" + type + ") CRUDPortaApplicativa.", e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception e) {}
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void CRUDRoutingTable(int type, RoutingTable aRT, Connection con) throws DriverConfigurazioneException {
        Statement updateStmt = null;
        Statement insertStmt = null;
        Statement updateStmtSelectRegistri = null;
        ResultSet rsSelectRegistri = null;
        String updateQuery = "";
        int i = 0;
        RoutingTableDestinazione rtd = null;
        Route route = null;
        RouteGateway gw = null;
        RouteRegistro rg = null;
        String tipo = null;
        String nome = null;
        long idRoute = 0L;
        try {
            switch (type) {
                case 1: {
                    String selectQuery;
                    long registroRotta;
                    ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                    sqlQueryObject.addUpdateTable("configurazione");
                    sqlQueryObject.addUpdateField("routing_enabled", "?");
                    updateQuery = sqlQueryObject.createSQLUpdate();
                    updateStmt = con.prepareStatement(updateQuery);
                    if (aRT.getAbilitata() != null && aRT.getAbilitata().booleanValue()) {
                        updateStmt.setString(1, CostantiConfigurazione.ABILITATO.toString());
                    } else {
                        updateStmt.setString(1, CostantiConfigurazione.DISABILITATO.toString());
                    }
                    log.debug((Object)("eseguo query :" + DBUtils.formatSQLString(updateQuery, aRT.getAbilitata() != null && aRT.getAbilitata() != false)));
                    updateStmt.executeUpdate();
                    updateStmt.close();
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                    sqlQueryObject.addInsertTable("routing");
                    sqlQueryObject.addInsertField("tipo", "?");
                    sqlQueryObject.addInsertField("nome", "?");
                    sqlQueryObject.addInsertField("tiporotta", "?");
                    sqlQueryObject.addInsertField("tiposoggrotta", "?");
                    sqlQueryObject.addInsertField("nomesoggrotta", "?");
                    sqlQueryObject.addInsertField("registrorotta", "?");
                    sqlQueryObject.addInsertField("is_default", "?");
                    updateQuery = sqlQueryObject.createSQLInsert();
                    i = 0;
                    if (aRT.getDefault() != null) {
                        RoutingTableDefault rtDefault = aRT.getDefault();
                        for (i = 0; i < rtDefault.sizeRouteList(); ++i) {
                            route = rtDefault.getRoute(i);
                            gw = route.getGateway();
                            rg = route.getRegistro();
                            updateStmt = con.prepareStatement(updateQuery);
                            updateStmt.setString(1, null);
                            updateStmt.setString(2, null);
                            updateStmt.setString(3, gw != null ? "gateway" : "registro");
                            updateStmt.setString(4, gw != null ? gw.getTipo() : null);
                            updateStmt.setString(5, gw != null ? gw.getNome() : null);
                            registroRotta = 0L;
                            if (rg != null && rg.getId() <= 0L && rg.getNome() != null && !"".equals(rg.getNome())) {
                                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                                sqlQueryObject.addFromTable("registri");
                                sqlQueryObject.addSelectField("id");
                                sqlQueryObject.addWhereCondition("nome = ?");
                                selectQuery = sqlQueryObject.createSQLQuery();
                                updateStmtSelectRegistri = con.prepareStatement(selectQuery);
                                updateStmtSelectRegistri.setString(1, rg.getNome());
                                rsSelectRegistri = updateStmtSelectRegistri.executeQuery();
                                if (rsSelectRegistri != null && rsSelectRegistri.next()) {
                                    registroRotta = rsSelectRegistri.getLong("id");
                                }
                                rsSelectRegistri.close();
                                updateStmtSelectRegistri.close();
                            }
                            updateStmt.setLong(6, registroRotta);
                            updateStmt.setInt(7, 1);
                            updateStmt.executeUpdate();
                            updateStmt.close();
                        }
                    }
                    log.debug((Object)("Inserted " + i + " Default route."));
                    i = 0;
                    while (true) {
                        if (i >= aRT.sizeDestinazioneList()) {
                            log.debug((Object)("Inserted " + i + " Destination route."));
                            return;
                        }
                        rtd = aRT.getDestinazione(i);
                        nome = rtd.getNome();
                        tipo = rtd.getTipo();
                        for (int j = 0; j < rtd.sizeRouteList(); ++j) {
                            route = rtd.getRoute(j);
                            gw = route.getGateway();
                            rg = route.getRegistro();
                            updateStmt = con.prepareStatement(updateQuery);
                            updateStmt.setString(1, tipo);
                            updateStmt.setString(2, nome);
                            updateStmt.setString(3, gw != null ? "gateway" : "registro");
                            updateStmt.setString(4, gw != null ? gw.getTipo() : null);
                            updateStmt.setString(5, gw != null ? gw.getNome() : null);
                            registroRotta = 0L;
                            if (rg != null && rg.getId() <= 0L && rg.getNome() != null && !"".equals(rg.getNome())) {
                                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                                sqlQueryObject.addFromTable("registri");
                                sqlQueryObject.addSelectField("id");
                                sqlQueryObject.addWhereCondition("nome = ?");
                                selectQuery = sqlQueryObject.createSQLQuery();
                                updateStmtSelectRegistri = con.prepareStatement(selectQuery);
                                updateStmtSelectRegistri.setString(1, rg.getNome());
                                rsSelectRegistri = updateStmtSelectRegistri.executeQuery();
                                if (rsSelectRegistri != null && rsSelectRegistri.next()) {
                                    registroRotta = rsSelectRegistri.getLong("id");
                                }
                                rsSelectRegistri.close();
                                updateStmtSelectRegistri.close();
                            }
                            updateStmt.setLong(6, registroRotta);
                            updateStmt.setInt(7, 0);
                            updateStmt.executeUpdate();
                            updateStmt.close();
                        }
                        ++i;
                    }
                }
                case 2: {
                    String selectQuery;
                    long registroRotta;
                    ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                    sqlQueryObject.addUpdateTable("configurazione");
                    sqlQueryObject.addUpdateField("routing_enabled", "?");
                    updateQuery = sqlQueryObject.createSQLUpdate();
                    updateStmt = con.prepareStatement(updateQuery);
                    if (aRT.getAbilitata() != null && aRT.getAbilitata().booleanValue()) {
                        updateStmt.setString(1, CostantiConfigurazione.ABILITATO.toString());
                    } else {
                        updateStmt.setString(1, CostantiConfigurazione.DISABILITATO.toString());
                    }
                    log.debug((Object)("eseguo query :" + DBUtils.formatSQLString(updateQuery, aRT.getAbilitata() != null && aRT.getAbilitata() != false)));
                    updateStmt.executeUpdate();
                    updateStmt.close();
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                    sqlQueryObject.addUpdateTable("routing");
                    sqlQueryObject.addUpdateField("tipo", "?");
                    sqlQueryObject.addUpdateField("nome", "?");
                    sqlQueryObject.addUpdateField("tiporotta", "?");
                    sqlQueryObject.addUpdateField("tiposoggrotta", "?");
                    sqlQueryObject.addUpdateField("nomesoggrotta", "?");
                    sqlQueryObject.addUpdateField("registrorotta", "?");
                    sqlQueryObject.addUpdateField("is_default", "?");
                    sqlQueryObject.addWhereCondition("id = ?");
                    updateQuery = sqlQueryObject.createSQLUpdate();
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                    sqlQueryObject.addInsertTable("routing");
                    sqlQueryObject.addInsertField("tipo", "?");
                    sqlQueryObject.addInsertField("nome", "?");
                    sqlQueryObject.addInsertField("tiporotta", "?");
                    sqlQueryObject.addInsertField("tiposoggrotta", "?");
                    sqlQueryObject.addInsertField("nomesoggrotta", "?");
                    sqlQueryObject.addInsertField("registrorotta", "?");
                    sqlQueryObject.addInsertField("is_default", "?");
                    String insertQuery = sqlQueryObject.createSQLInsert();
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                    sqlQueryObject.setANDLogicOperator(true);
                    sqlQueryObject.addDeleteTable("routing");
                    String queryDelete = sqlQueryObject.createSQLDelete();
                    log.debug((Object)("DELETING Destination Route : " + queryDelete));
                    updateStmt = con.prepareStatement(queryDelete);
                    int n = updateStmt.executeUpdate();
                    updateStmt.close();
                    log.debug((Object)("Deleted " + n + " Destination route."));
                    i = 0;
                    if (aRT.getDefault() != null) {
                        RoutingTableDefault rtDefault = aRT.getDefault();
                        for (i = 0; i < rtDefault.sizeRouteList(); ++i) {
                            route = rtDefault.getRoute(i);
                            idRoute = route.getId();
                            gw = route.getGateway();
                            rg = route.getRegistro();
                            registroRotta = 0L;
                            if (rg != null && rg.getId() <= 0L && rg.getNome() != null && !"".equals(rg.getNome())) {
                                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                                sqlQueryObject.addFromTable("registri");
                                sqlQueryObject.addSelectField("id");
                                sqlQueryObject.addWhereCondition("nome = ?");
                                selectQuery = sqlQueryObject.createSQLQuery();
                                updateStmtSelectRegistri = con.prepareStatement(selectQuery);
                                updateStmtSelectRegistri.setString(1, rg.getNome());
                                rsSelectRegistri = updateStmtSelectRegistri.executeQuery();
                                if (rsSelectRegistri != null && rsSelectRegistri.next()) {
                                    registroRotta = rsSelectRegistri.getLong("id");
                                }
                                rsSelectRegistri.close();
                                updateStmtSelectRegistri.close();
                            }
                            insertStmt = con.prepareStatement(insertQuery);
                            insertStmt.setString(1, null);
                            insertStmt.setString(2, null);
                            insertStmt.setString(3, gw != null ? "gateway" : "registro");
                            insertStmt.setString(4, gw != null ? gw.getTipo() : null);
                            insertStmt.setString(5, gw != null ? gw.getNome() : null);
                            insertStmt.setLong(6, registroRotta);
                            insertStmt.setInt(7, 1);
                            insertStmt.executeUpdate();
                            insertStmt.close();
                        }
                    }
                    log.debug((Object)("Updated " + i + " Default route."));
                    i = 0;
                    while (true) {
                        if (i >= aRT.sizeDestinazioneList()) {
                            log.debug((Object)("Updated " + i + " Destination route."));
                            return;
                        }
                        rtd = aRT.getDestinazione(i);
                        nome = rtd.getNome();
                        tipo = rtd.getTipo();
                        for (int j = 0; j < rtd.sizeRouteList(); ++j) {
                            route = rtd.getRoute(j);
                            idRoute = route.getId();
                            gw = route.getGateway();
                            rg = route.getRegistro();
                            registroRotta = 0L;
                            if (rg != null && rg.getId() <= 0L && rg.getNome() != null && !"".equals(rg.getNome())) {
                                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                                sqlQueryObject.addFromTable("registri");
                                sqlQueryObject.addSelectField("id");
                                sqlQueryObject.addWhereCondition("nome = ?");
                                selectQuery = sqlQueryObject.createSQLQuery();
                                updateStmtSelectRegistri = con.prepareStatement(selectQuery);
                                updateStmtSelectRegistri.setString(1, rg.getNome());
                                rsSelectRegistri = updateStmtSelectRegistri.executeQuery();
                                if (rsSelectRegistri != null && rsSelectRegistri.next()) {
                                    registroRotta = rsSelectRegistri.getLong("id");
                                }
                                rsSelectRegistri.close();
                                updateStmtSelectRegistri.close();
                            }
                            insertStmt = con.prepareStatement(insertQuery);
                            insertStmt.setString(1, tipo);
                            insertStmt.setString(2, nome);
                            insertStmt.setString(3, gw != null ? "gateway" : "registro");
                            insertStmt.setString(4, gw != null ? gw.getTipo() : null);
                            insertStmt.setString(5, gw != null ? gw.getNome() : null);
                            insertStmt.setLong(6, registroRotta);
                            insertStmt.setInt(7, 0);
                            insertStmt.executeUpdate();
                            insertStmt.close();
                        }
                        ++i;
                    }
                }
                case 3: {
                    i = 0;
                    if (aRT.getDefault() == null) return;
                    RoutingTableDefault rtDefault = aRT.getDefault();
                    i = 0;
                    while (i < rtDefault.sizeRouteList()) {
                        route = rtDefault.getRoute(i);
                        if (route.getId() == null) throw new DriverConfigurazioneException("[DriverConfigurazioneDB_LIB::CRUDRoutingTable(DELETE)] id route non valida.");
                        if (route.getId() <= 0L) {
                            throw new DriverConfigurazioneException("[DriverConfigurazioneDB_LIB::CRUDRoutingTable(DELETE)] id route non valida.");
                        }
                        idRoute = route.getId();
                        ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                        sqlQueryObject.addDeleteTable("routing");
                        sqlQueryObject.addWhereCondition("id=?");
                        String sqlQuery = sqlQueryObject.createSQLDelete();
                        updateStmt = con.prepareStatement(sqlQuery);
                        updateStmt.setLong(1, idRoute);
                        updateStmt.executeUpdate();
                        updateStmt.close();
                        log.debug((Object)("Deleted " + i + " Destination route."));
                        ++i;
                    }
                    return;
                }
            }
            return;
        }
        catch (SQLException se) {
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB_LIB::CRUDRoutingTable] SQLException [" + se.getMessage() + "].", se);
        }
        catch (Exception se) {
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB_LIB::CRUDRoutingTable] Exception [" + se.getMessage() + "].", se);
        }
        finally {
            try {
                if (updateStmt != null) {
                    updateStmt.close();
                }
            }
            catch (Exception e) {}
            try {
                if (insertStmt != null) {
                    insertStmt.close();
                }
            }
            catch (Exception e) {}
            try {
                if (rsSelectRegistri != null) {
                    rsSelectRegistri.close();
                }
            }
            catch (Exception e) {}
            try {
                if (updateStmtSelectRegistri != null) {
                    updateStmtSelectRegistri.close();
                }
            }
            catch (Exception e) {}
        }
    }

    public static long CRUDAccessoRegistro(int type, AccessoRegistroRegistro registro, Connection con) throws DriverConfigurazioneException {
        long sqlQueryObject2;
        if (registro == null) {
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB_LIB::CRUDAccessoRegistro] Il servizio non puo essere NULL");
        }
        Statement updateStmt = null;
        String updateQuery = "";
        Statement selectStmt = null;
        String selectQuery = "";
        ResultSet selectRS = null;
        long idRegistro = 0L;
        int n = 0;
        String nome = registro.getNome();
        String location = registro.getLocation();
        String tipo = registro.getTipo().toString();
        String user = registro.getUser();
        String password = registro.getPassword();
        try {
            switch (type) {
                case 1: {
                    ISQLQueryObject sqlQueryObject2 = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                    sqlQueryObject2.addInsertTable("registri");
                    sqlQueryObject2.addInsertField("nome", "?");
                    sqlQueryObject2.addInsertField("location", "?");
                    sqlQueryObject2.addInsertField("tipo", "?");
                    sqlQueryObject2.addInsertField("utente", "?");
                    sqlQueryObject2.addInsertField("password", "?");
                    updateQuery = sqlQueryObject2.createSQLInsert();
                    updateStmt = con.prepareStatement(updateQuery);
                    updateStmt.setString(1, nome);
                    updateStmt.setString(2, location);
                    updateStmt.setString(3, tipo);
                    updateStmt.setString(4, user);
                    updateStmt.setString(5, password);
                    log.debug((Object)("eseguo query: " + DBUtils.formatSQLString(updateQuery, nome, location, tipo, user, password)));
                    n = updateStmt.executeUpdate();
                    sqlQueryObject2 = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                    sqlQueryObject2.addFromTable("registri");
                    sqlQueryObject2.addSelectField("id");
                    sqlQueryObject2.addWhereCondition("nome = ?");
                    sqlQueryObject2.addWhereCondition("location = ?");
                    sqlQueryObject2.setANDLogicOperator(true);
                    selectQuery = sqlQueryObject2.createSQLQuery();
                    selectStmt = con.prepareStatement(selectQuery);
                    selectStmt.setString(1, nome);
                    selectStmt.setString(2, location);
                    selectRS = selectStmt.executeQuery();
                    if (!selectRS.next()) break;
                    idRegistro = selectRS.getLong("id");
                    registro.setId(idRegistro);
                    break;
                }
                case 2: {
                    if (registro.getId() == null || registro.getId() <= 0L) {
                        throw new DriverConfigurazioneException("[DriverConfigurazioneDB_LIB::CRUDAccessoRegistro(UPDATE)] L'id del Servizio e' necessario.");
                    }
                    idRegistro = registro.getId();
                    ISQLQueryObject sqlQueryObject2 = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                    sqlQueryObject2.addUpdateTable("routing");
                    sqlQueryObject2.addUpdateField("nome", "?");
                    sqlQueryObject2.addUpdateField("location", "?");
                    sqlQueryObject2.addUpdateField("tipo", "?");
                    sqlQueryObject2.addUpdateField("utente", "?");
                    sqlQueryObject2.addUpdateField("password", "?");
                    sqlQueryObject2.addWhereCondition("id=?");
                    updateQuery = sqlQueryObject2.createSQLUpdate();
                    updateStmt = con.prepareStatement(updateQuery);
                    updateStmt.setString(1, registro.getNome());
                    updateStmt.setString(2, registro.getLocation());
                    updateStmt.setString(3, registro.getTipo().toString());
                    updateStmt.setString(4, registro.getUser());
                    updateStmt.setString(5, registro.getPassword());
                    updateStmt.setLong(6, idRegistro);
                    log.debug((Object)("eseguo query: " + DBUtils.formatSQLString(updateQuery, nome, location, tipo, user, password, idRegistro)));
                    n = updateStmt.executeUpdate();
                    break;
                }
                case 3: {
                    if (registro.getId() == null || registro.getId() <= 0L) {
                        throw new DriverConfigurazioneException("[DriverConfigurazioneDB_LIB::CRUDAccessoRegistro(DELETE)] L'id del Servizio e' necessario.");
                    }
                    idRegistro = registro.getId();
                    ISQLQueryObject sqlQueryObject2 = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                    sqlQueryObject2.addDeleteTable("registri");
                    sqlQueryObject2.addWhereCondition("id=?");
                    String sqlQuery = sqlQueryObject2.createSQLDelete();
                    updateStmt = con.prepareStatement(sqlQuery);
                    updateStmt.setLong(1, idRegistro);
                    log.debug((Object)("eseguo query: " + DBUtils.formatSQLString(updateQuery, idRegistro)));
                    n = updateStmt.executeUpdate();
                    updateStmt.close();
                }
            }
            if (type == 1) {
                long sqlQueryObject2 = idRegistro;
                return sqlQueryObject2;
            }
            sqlQueryObject2 = n;
        }
        catch (SQLException se) {
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB_LIB::CRUDAccessoRegistro] SQLException [" + se.getMessage() + "].", se);
        }
        catch (Exception se) {
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB_LIB::CRUDAccessoRegistro] Exception [" + se.getMessage() + "].", se);
        }
        finally {
            try {
                if (selectRS != null) {
                    selectRS.close();
                }
                if (selectStmt != null) {
                    selectStmt.close();
                }
                if (updateStmt != null) {
                    updateStmt.close();
                }
            }
            catch (Exception e) {}
        }
        return sqlQueryObject2;
    }

    public static long CRUDAccessoRegistro(int type, AccessoRegistro registro, Connection con) throws DriverConfigurazioneException {
        long sqlQueryObject2;
        if (registro == null) {
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB_LIB::CRUDAccessoRegistro] Il registro non pu\u00f2 essere NULL");
        }
        Statement updateStmt = null;
        String updateQuery = "";
        Statement selectStmt = null;
        ResultSet selectRS = null;
        long idRegistro = 0L;
        int n = 0;
        Cache arc = registro.getCache();
        String statoCache = "disabilitato";
        String dimensionecache = null;
        String algoritmocache = null;
        String idlecache = null;
        String lifecache = null;
        if (arc != null) {
            statoCache = "abilitato";
            dimensionecache = arc.getDimensione();
            if (arc.getAlgoritmo() != null) {
                algoritmocache = arc.getAlgoritmo().toString();
            }
            idlecache = arc.getItemIdleTime();
            lifecache = arc.getItemLifeSecond();
        }
        try {
            switch (type) {
                case 1: 
                case 2: {
                    ISQLQueryObject sqlQueryObject2 = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                    sqlQueryObject2.addUpdateTable("configurazione");
                    sqlQueryObject2.addUpdateField("statocache", "?");
                    sqlQueryObject2.addUpdateField("dimensionecache", "?");
                    sqlQueryObject2.addUpdateField("algoritmocache", "?");
                    sqlQueryObject2.addUpdateField("idlecache", "?");
                    sqlQueryObject2.addUpdateField("lifecache", "?");
                    updateQuery = sqlQueryObject2.createSQLUpdate();
                    updateStmt = con.prepareStatement(updateQuery);
                    updateStmt.setString(1, statoCache);
                    updateStmt.setString(2, dimensionecache);
                    updateStmt.setString(3, algoritmocache);
                    updateStmt.setString(4, idlecache);
                    updateStmt.setString(5, lifecache);
                    log.debug((Object)("eseguo query :" + DBUtils.formatSQLString(updateQuery, statoCache, dimensionecache, algoritmocache, idlecache, lifecache)));
                    n = updateStmt.executeUpdate();
                    updateStmt.close();
                    sqlQueryObject2 = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                    sqlQueryObject2.addDeleteTable("registri");
                    String sqlQuery = sqlQueryObject2.createSQLDelete();
                    updateStmt = con.prepareStatement(sqlQuery);
                    log.debug((Object)("eseguo query: " + DBUtils.formatSQLString(updateQuery, new Object[0])));
                    int risultato = updateStmt.executeUpdate();
                    log.debug((Object)("eseguo query risultato[" + risultato + "]: " + DBUtils.formatSQLString(updateQuery, new Object[0])));
                    updateStmt.close();
                    sqlQueryObject2 = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                    sqlQueryObject2.addInsertTable("registri");
                    sqlQueryObject2.addInsertField("nome", "?");
                    sqlQueryObject2.addInsertField("location", "?");
                    sqlQueryObject2.addInsertField("tipo", "?");
                    sqlQueryObject2.addInsertField("utente", "?");
                    sqlQueryObject2.addInsertField("password", "?");
                    updateQuery = sqlQueryObject2.createSQLInsert();
                    for (int i = 0; i < registro.sizeRegistroList(); ++i) {
                        updateStmt = con.prepareStatement(updateQuery);
                        AccessoRegistroRegistro arr = registro.getRegistro(i);
                        String nome = arr.getNome();
                        String location = arr.getLocation();
                        String tipo = arr.getTipo().toString();
                        String utente = arr.getUser();
                        String password = arr.getPassword();
                        updateStmt.setString(1, nome);
                        updateStmt.setString(2, location);
                        updateStmt.setString(3, tipo);
                        updateStmt.setString(4, utente);
                        updateStmt.setString(5, password);
                        log.debug((Object)("eseguo query INSERT INTO registri(nome, location, tipo, utente, password) VALUES (" + nome + ", " + location + ", " + tipo + ", " + utente + ", " + password + ")"));
                        updateStmt.executeUpdate();
                        updateStmt.close();
                    }
                    break;
                }
            }
            if (type == 1) {
                long sqlQueryObject2 = idRegistro;
                return sqlQueryObject2;
            }
            sqlQueryObject2 = n;
        }
        catch (SQLException se) {
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB_LIB::CRUDAccessoRegistro] SQLException [" + se.getMessage() + "].", se);
        }
        catch (Exception se) {
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB_LIB::CRUDAccessoRegistro] Exception [" + se.getMessage() + "].", se);
        }
        finally {
            try {
                if (selectRS != null) {
                    selectRS.close();
                }
            }
            catch (Exception e) {}
            try {
                if (selectStmt != null) {
                    selectStmt.close();
                }
            }
            catch (Exception e) {}
            try {
                if (updateStmt != null) {
                    updateStmt.close();
                }
            }
            catch (Exception e) {}
        }
        return sqlQueryObject2;
    }

    public static long CRUDAccessoConfigurazione(int type, AccessoConfigurazione accessoConfigurazione, Connection con) throws DriverConfigurazioneException {
        if (accessoConfigurazione == null) {
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB_LIB::CRUDAccessoConfigurazione] Parametro accessoConfigurazione non pu\u00f2 essere NULL");
        }
        Statement updateStmt = null;
        String updateQuery = "";
        int n = 0;
        Cache cache = accessoConfigurazione.getCache();
        String statoCache = "disabilitato";
        String dimensionecache = null;
        String algoritmocache = null;
        String idlecache = null;
        String lifecache = null;
        if (cache != null) {
            statoCache = "abilitato";
            dimensionecache = cache.getDimensione();
            if (cache.getAlgoritmo() != null) {
                algoritmocache = cache.getAlgoritmo().toString();
            }
            idlecache = cache.getItemIdleTime();
            lifecache = cache.getItemLifeSecond();
        }
        try {
            switch (type) {
                case 1: 
                case 2: {
                    ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                    sqlQueryObject.addUpdateTable("configurazione");
                    sqlQueryObject.addUpdateField("config_statocache", "?");
                    sqlQueryObject.addUpdateField("config_dimensionecache", "?");
                    sqlQueryObject.addUpdateField("config_algoritmocache", "?");
                    sqlQueryObject.addUpdateField("config_idlecache", "?");
                    sqlQueryObject.addUpdateField("config_lifecache", "?");
                    updateQuery = sqlQueryObject.createSQLUpdate();
                    updateStmt = con.prepareStatement(updateQuery);
                    updateStmt.setString(1, statoCache);
                    updateStmt.setString(2, dimensionecache);
                    updateStmt.setString(3, algoritmocache);
                    updateStmt.setString(4, idlecache);
                    updateStmt.setString(5, lifecache);
                    log.debug((Object)("eseguo query :" + DBUtils.formatSQLString(updateQuery, statoCache, dimensionecache, algoritmocache, idlecache, lifecache)));
                    n = updateStmt.executeUpdate();
                    updateStmt.close();
                    break;
                }
            }
            long sqlQueryObject = n;
            return sqlQueryObject;
        }
        catch (SQLException se) {
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB_LIB::CRUDAccessoConfigurazione] SQLException [" + se.getMessage() + "].", se);
        }
        catch (Exception se) {
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB_LIB::CRUDAccessoConfigurazione] Exception [" + se.getMessage() + "].", se);
        }
        finally {
            try {
                if (updateStmt != null) {
                    updateStmt.close();
                }
            }
            catch (Exception e) {}
        }
    }

    public static long CRUDAccessoDatiAutorizzazione(int type, AccessoDatiAutorizzazione accessoDatiAutorizzazione, Connection con) throws DriverConfigurazioneException {
        if (accessoDatiAutorizzazione == null) {
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB_LIB::CRUDAccessoDatiAutorizzazione] Parametro accessoDatiAutorizzazione non pu\u00f2 essere NULL");
        }
        Statement updateStmt = null;
        String updateQuery = "";
        int n = 0;
        Cache cache = accessoDatiAutorizzazione.getCache();
        String statoCache = "disabilitato";
        String dimensionecache = null;
        String algoritmocache = null;
        String idlecache = null;
        String lifecache = null;
        if (cache != null) {
            statoCache = "abilitato";
            dimensionecache = cache.getDimensione();
            if (cache.getAlgoritmo() != null) {
                algoritmocache = cache.getAlgoritmo().toString();
            }
            idlecache = cache.getItemIdleTime();
            lifecache = cache.getItemLifeSecond();
        }
        try {
            switch (type) {
                case 1: 
                case 2: {
                    ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                    sqlQueryObject.addUpdateTable("configurazione");
                    sqlQueryObject.addUpdateField("auth_statocache", "?");
                    sqlQueryObject.addUpdateField("auth_dimensionecache", "?");
                    sqlQueryObject.addUpdateField("auth_algoritmocache", "?");
                    sqlQueryObject.addUpdateField("auth_idlecache", "?");
                    sqlQueryObject.addUpdateField("auth_lifecache", "?");
                    updateQuery = sqlQueryObject.createSQLUpdate();
                    updateStmt = con.prepareStatement(updateQuery);
                    updateStmt.setString(1, statoCache);
                    updateStmt.setString(2, dimensionecache);
                    updateStmt.setString(3, algoritmocache);
                    updateStmt.setString(4, idlecache);
                    updateStmt.setString(5, lifecache);
                    log.debug((Object)("eseguo query :" + DBUtils.formatSQLString(updateQuery, statoCache, dimensionecache, algoritmocache, idlecache, lifecache)));
                    n = updateStmt.executeUpdate();
                    updateStmt.close();
                    break;
                }
            }
            long sqlQueryObject = n;
            return sqlQueryObject;
        }
        catch (SQLException se) {
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB_LIB::CRUDAccessoDatiAutorizzazione] SQLException [" + se.getMessage() + "].", se);
        }
        catch (Exception se) {
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB_LIB::CRUDAccessoDatiAutorizzazione] Exception [" + se.getMessage() + "].", se);
        }
        finally {
            try {
                if (updateStmt != null) {
                    updateStmt.close();
                }
            }
            catch (Exception e) {}
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void CRUDServiziPdD(int type, StatoServiziPdd statoServiziPdD, Connection con) throws DriverConfigurazioneException {
        if (statoServiziPdD == null) {
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB_LIB::CRUDServiziPdD] Le configurazioni del servizio non possono essere NULL");
        }
        Statement updateStmt = null;
        String updateQuery = "";
        Statement selectStmt = null;
        ResultSet selectRS = null;
        try {
            switch (type) {
                case 1: 
                case 2: {
                    int stato;
                    ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                    sqlQueryObject.addDeleteTable("servizi_pdd_filtri");
                    String sqlQuery = sqlQueryObject.createSQLDelete();
                    updateStmt = con.prepareStatement(sqlQuery);
                    log.debug((Object)("eseguo query: " + DBUtils.formatSQLString(updateQuery, new Object[0])));
                    int risultato = updateStmt.executeUpdate();
                    log.debug((Object)("eseguo query risultato[" + risultato + "]: " + DBUtils.formatSQLString(updateQuery, new Object[0])));
                    updateStmt.close();
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                    sqlQueryObject.addDeleteTable("servizi_pdd");
                    sqlQuery = sqlQueryObject.createSQLDelete();
                    updateStmt = con.prepareStatement(sqlQuery);
                    log.debug((Object)("eseguo query: " + DBUtils.formatSQLString(updateQuery, new Object[0])));
                    risultato = updateStmt.executeUpdate();
                    log.debug((Object)("eseguo query risultato[" + risultato + "]: " + DBUtils.formatSQLString(updateQuery, new Object[0])));
                    updateStmt.close();
                    if (statoServiziPdD.getPortaDelegata() != null) {
                        StatoServiziPddPortaDelegata sPD = statoServiziPdD.getPortaDelegata();
                        stato = 1;
                        if (sPD.getStato() != null) {
                            stato = CostantiConfigurazione.DISABILITATO.equals(sPD.getStato()) ? 0 : 1;
                        }
                        DriverConfigurazioneDB_LIB.registraComponentePdD("pd", stato, con, sPD.getFiltroAbilitazioneList(), sPD.getFiltroDisabilitazioneList());
                    }
                    if (statoServiziPdD.getPortaApplicativa() != null) {
                        StatoServiziPddPortaApplicativa sPA = statoServiziPdD.getPortaApplicativa();
                        stato = 1;
                        if (sPA.getStato() != null) {
                            stato = CostantiConfigurazione.DISABILITATO.equals(sPA.getStato()) ? 0 : 1;
                        }
                        DriverConfigurazioneDB_LIB.registraComponentePdD("pa", stato, con, sPA.getFiltroAbilitazioneList(), sPA.getFiltroDisabilitazioneList());
                    }
                    if (statoServiziPdD.getIntegrationManager() == null) return;
                    StatoServiziPddIntegrationManager sIM = statoServiziPdD.getIntegrationManager();
                    stato = 1;
                    if (sIM.getStato() != null) {
                        stato = CostantiConfigurazione.DISABILITATO.equals(sIM.getStato()) ? 0 : 1;
                    }
                    DriverConfigurazioneDB_LIB.registraComponentePdD("im", stato, con, null, null);
                    return;
                }
            }
            return;
        }
        catch (SQLException se) {
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB_LIB::CRUDAccessoRegistro] SQLException [" + se.getMessage() + "].", se);
        }
        catch (Exception se) {
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB_LIB::CRUDAccessoRegistro] Exception [" + se.getMessage() + "].", se);
        }
        finally {
            try {
                if (selectRS != null) {
                    selectRS.close();
                }
            }
            catch (Exception e) {}
            try {
                if (selectStmt != null) {
                    selectStmt.close();
                }
            }
            catch (Exception e) {}
            try {
                if (updateStmt != null) {
                    updateStmt.close();
                }
            }
            catch (Exception e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void registraComponentePdD(String componente, int stato, Connection con, List<TipoFiltroAbilitazioneServizi> abilitazioni, List<TipoFiltroAbilitazioneServizi> disabilitazioni) throws Exception {
        Statement updateStmt = null;
        String updateQuery = "";
        Statement selectStmt = null;
        ResultSet selectRS = null;
        try {
            int index;
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
            sqlQueryObject.addInsertTable("servizi_pdd");
            sqlQueryObject.addInsertField("componente", "?");
            sqlQueryObject.addInsertField("stato", "?");
            updateQuery = sqlQueryObject.createSQLInsert();
            updateStmt = con.prepareStatement(updateQuery);
            log.debug((Object)("eseguo query INSERT INTO servizi_pdd(componente, stato) VALUES ('" + componente + "', " + stato + ")"));
            updateStmt.setString(1, componente);
            updateStmt.setInt(2, stato);
            updateStmt.executeUpdate();
            updateStmt.close();
            long idComponente = -1L;
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
            sqlQueryObject.addFromTable("servizi_pdd");
            sqlQueryObject.addSelectField("id");
            sqlQueryObject.addWhereCondition("componente=?");
            updateQuery = sqlQueryObject.createSQLQuery();
            selectStmt = con.prepareStatement(updateQuery);
            log.debug((Object)("eseguo query [" + updateQuery + "] per il componente [" + componente + "]"));
            selectStmt.setString(1, componente);
            selectRS = selectStmt.executeQuery();
            if (!selectRS.next()) {
                throw new Exception("Query [" + updateQuery + "] per il componente [" + componente + "] non ha ritornato risultati");
            }
            idComponente = selectRS.getLong("id");
            selectRS.close();
            selectStmt.close();
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
            sqlQueryObject.addInsertTable("servizi_pdd_filtri");
            sqlQueryObject.addInsertField("id_servizio_pdd", "?");
            sqlQueryObject.addInsertField("tipo_filtro", "?");
            sqlQueryObject.addInsertField("tipo_soggetto_fruitore", "?");
            sqlQueryObject.addInsertField("soggetto_fruitore", "?");
            sqlQueryObject.addInsertField("identificativo_porta_fruitore", "?");
            sqlQueryObject.addInsertField("tipo_soggetto_erogatore", "?");
            sqlQueryObject.addInsertField("soggetto_erogatore", "?");
            sqlQueryObject.addInsertField("identificativo_porta_erogatore", "?");
            sqlQueryObject.addInsertField("tipo_servizio", "?");
            sqlQueryObject.addInsertField("servizio", "?");
            sqlQueryObject.addInsertField("azione", "?");
            updateQuery = sqlQueryObject.createSQLInsert();
            if (abilitazioni != null) {
                for (TipoFiltroAbilitazioneServizi filtro : abilitazioni) {
                    updateStmt = con.prepareStatement(updateQuery);
                    index = 1;
                    updateStmt.setLong(index++, idComponente);
                    updateStmt.setString(index++, "abilitazione");
                    updateStmt.setString(index++, filtro.getTipoSoggettoFruitore());
                    updateStmt.setString(index++, filtro.getSoggettoFruitore());
                    updateStmt.setString(index++, filtro.getIdentificativoPortaFruitore());
                    updateStmt.setString(index++, filtro.getTipoSoggettoErogatore());
                    updateStmt.setString(index++, filtro.getSoggettoErogatore());
                    updateStmt.setString(index++, filtro.getIdentificativoPortaErogatore());
                    updateStmt.setString(index++, filtro.getTipoServizio());
                    updateStmt.setString(index++, filtro.getServizio());
                    updateStmt.setString(index++, filtro.getAzione());
                    updateStmt.executeUpdate();
                    updateStmt.close();
                }
            }
            if (disabilitazioni != null) {
                for (TipoFiltroAbilitazioneServizi filtro : disabilitazioni) {
                    updateStmt = con.prepareStatement(updateQuery);
                    index = 1;
                    updateStmt.setLong(index++, idComponente);
                    updateStmt.setString(index++, "disabilitazione");
                    updateStmt.setString(index++, filtro.getTipoSoggettoFruitore());
                    updateStmt.setString(index++, filtro.getSoggettoFruitore());
                    updateStmt.setString(index++, filtro.getIdentificativoPortaFruitore());
                    updateStmt.setString(index++, filtro.getTipoSoggettoErogatore());
                    updateStmt.setString(index++, filtro.getSoggettoErogatore());
                    updateStmt.setString(index++, filtro.getIdentificativoPortaErogatore());
                    updateStmt.setString(index++, filtro.getTipoServizio());
                    updateStmt.setString(index++, filtro.getServizio());
                    updateStmt.setString(index++, filtro.getAzione());
                    updateStmt.executeUpdate();
                    updateStmt.close();
                }
            }
        }
        finally {
            try {
                if (selectRS != null) {
                    selectRS.close();
                }
            }
            catch (Exception e) {}
            try {
                if (selectStmt != null) {
                    selectStmt.close();
                }
            }
            catch (Exception e) {}
            try {
                if (updateStmt != null) {
                    updateStmt.close();
                }
            }
            catch (Exception e) {}
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void CRUDSystemPropertiesPdD(int type, SystemProperties systemProperties, Connection con) throws DriverConfigurazioneException {
        if (systemProperties == null) {
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB_LIB::CRUDSystemPropertiesPdD] Le configurazioni per le system properties non possono essere NULL");
        }
        Statement updateStmt = null;
        String updateQuery = "";
        Statement selectStmt = null;
        ResultSet selectRS = null;
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
            sqlQueryObject.addDeleteTable("pdd_sys_props");
            String sqlQuery = sqlQueryObject.createSQLDelete();
            updateStmt = con.prepareStatement(sqlQuery);
            log.debug((Object)("eseguo query: " + DBUtils.formatSQLString(updateQuery, new Object[0])));
            int risultato = updateStmt.executeUpdate();
            log.debug((Object)("eseguo query risultato[" + risultato + "]: " + DBUtils.formatSQLString(updateQuery, new Object[0])));
            updateStmt.close();
            switch (type) {
                case 1: 
                case 2: {
                    int i = 0;
                    while (i < systemProperties.sizeSystemPropertyList()) {
                        Property sp = systemProperties.getSystemProperty(i);
                        String nome = sp.getNome();
                        String valore = sp.getValore();
                        sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                        sqlQueryObject.addInsertTable("pdd_sys_props");
                        sqlQueryObject.addInsertField("nome", "?");
                        sqlQueryObject.addInsertField("valore", "?");
                        updateQuery = sqlQueryObject.createSQLInsert();
                        updateStmt = con.prepareStatement(updateQuery);
                        log.debug((Object)("eseguo query INSERT INTO pdd_sys_props(nome, valore) VALUES ('" + nome + "', " + valore + ")"));
                        updateStmt.setString(1, nome);
                        updateStmt.setString(2, valore);
                        updateStmt.executeUpdate();
                        updateStmt.close();
                        long idComponente = -1L;
                        sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                        sqlQueryObject.addFromTable("pdd_sys_props");
                        sqlQueryObject.addSelectField("id");
                        sqlQueryObject.setANDLogicOperator(true);
                        sqlQueryObject.addWhereCondition("nome=?");
                        sqlQueryObject.addWhereCondition("valore=?");
                        updateQuery = sqlQueryObject.createSQLQuery();
                        selectStmt = con.prepareStatement(updateQuery);
                        log.debug((Object)("eseguo query [" + updateQuery + "] per la prop nome[" + nome + "] valore[" + valore + "]"));
                        selectStmt.setString(1, nome);
                        selectStmt.setString(2, valore);
                        selectRS = selectStmt.executeQuery();
                        if (!selectRS.next()) throw new Exception("Query [" + updateQuery + "] per la prop nome[" + nome + "] valore[" + valore + "] non ha ritornato risultati");
                        idComponente = selectRS.getLong("id");
                        selectRS.close();
                        selectStmt.close();
                        sp.setId(idComponente);
                        ++i;
                    }
                    return;
                }
            }
            return;
        }
        catch (SQLException se) {
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB_LIB::CRUDAccessoRegistro] SQLException [" + se.getMessage() + "].", se);
        }
        catch (Exception se) {
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB_LIB::CRUDAccessoRegistro] Exception [" + se.getMessage() + "].", se);
        }
        finally {
            try {
                if (selectRS != null) {
                    selectRS.close();
                }
            }
            catch (Exception e) {}
            try {
                if (selectStmt != null) {
                    selectStmt.close();
                }
            }
            catch (Exception e) {}
            try {
                if (updateStmt != null) {
                    updateStmt.close();
                }
            }
            catch (Exception e) {}
        }
    }

    public static long CRUDConfigurazioneGenerale(int type, Configurazione config, Connection con) throws DriverConfigurazioneException {
        if (config.sizeExtendedInfoList() > 0 && config.getAccessoConfigurazione() == null && config.getAccessoRegistro() == null && config.getAccessoDatiAutorizzazione() == null && config.getAttachments() == null && config.getGestioneErrore() == null && config.getIndirizzoRisposta() == null && config.getInoltroBusteNonRiscontrate() == null && config.getIntegrationManager() == null && config.getMessaggiDiagnostici() == null && config.getRisposte() == null && config.getRoutingTable() == null && config.getStatoServiziPdd() == null && config.getSystemProperties() == null && config.getTracciamento() == null && config.getValidazioneBuste() == null && config.getValidazioneContenutiApplicativi() == null) {
            ExtendedInfoManager extInfoManager = ExtendedInfoManager.getInstance();
            IExtendedInfo extInfoConfigurazioneDriver = extInfoManager.newInstanceExtendedInfoConfigurazione();
            if (extInfoConfigurazioneDriver != null) {
                try {
                    switch (type) {
                        case 1: 
                        case 2: {
                            extInfoConfigurazioneDriver.deleteAllExtendedInfo(con, log, config);
                            if (config.sizeExtendedInfoList() <= 0) break;
                            for (int l = 0; l < config.sizeExtendedInfoList(); ++l) {
                                extInfoConfigurazioneDriver.createExtendedInfo(con, log, config, config.getExtendedInfo(l));
                            }
                            break;
                        }
                        case 3: {
                            extInfoConfigurazioneDriver.deleteAllExtendedInfo(con, log, config);
                        }
                    }
                }
                catch (Exception se) {
                    throw new DriverConfigurazioneException("[DriverConfigurazioneDB_LIB::CRUDConfigurazioneGenerale-Extended] Exception [" + se.getMessage() + "].", se);
                }
            }
            return -1L;
        }
        return DriverConfigurazioneDB_LIB._CRUDConfigurazioneGenerale(type, config, con);
    }

    private static long _CRUDConfigurazioneGenerale(int type, Configurazione config, Connection con) throws DriverConfigurazioneException {
        long sqlQueryObject2;
        Statement updateStmt = null;
        String updateQuery = "";
        Statement selectStmt = null;
        ResultSet selectRS = null;
        int n = 0;
        long idConfigurazione = 0L;
        IndirizzoRisposta indirizzoPerRisposta = config.getIndirizzoRisposta();
        InoltroBusteNonRiscontrate inoltroBusteNonRiscontrate = config.getInoltroBusteNonRiscontrate();
        IntegrationManager integrationManager = config.getIntegrationManager();
        MessaggiDiagnostici messaggiDiagnostici = config.getMessaggiDiagnostici();
        Risposte risposte = config.getRisposte();
        ValidazioneBuste validazioneBuste = config.getValidazioneBuste();
        AccessoRegistro car = config.getAccessoRegistro();
        AccessoConfigurazione aConfig = config.getAccessoConfigurazione();
        AccessoDatiAutorizzazione aDatiAuth = config.getAccessoDatiAutorizzazione();
        Attachments att = config.getAttachments();
        String utilizzoIndTelematico = null;
        if (indirizzoPerRisposta != null) {
            utilizzoIndTelematico = DriverConfigurazioneDB_LIB.getValue(indirizzoPerRisposta.getUtilizzo());
        }
        String cadenza_inoltro = null;
        if (inoltroBusteNonRiscontrate != null) {
            cadenza_inoltro = inoltroBusteNonRiscontrate.getCadenza();
        }
        String autenticazione = null;
        if (integrationManager != null) {
            autenticazione = integrationManager.getAutenticazione();
        }
        String msg_diag_severita = null;
        String msg_diag_severita_log4j = null;
        if (messaggiDiagnostici != null) {
            msg_diag_severita = DriverConfigurazioneDB_LIB.getValue(messaggiDiagnostici.getSeverita());
            msg_diag_severita_log4j = DriverConfigurazioneDB_LIB.getValue(messaggiDiagnostici.getSeveritaLog4j());
        }
        String val_controllo = null;
        String val_stato = null;
        String val_manifest = null;
        String val_profiloCollaborazione = null;
        if (validazioneBuste != null) {
            val_controllo = DriverConfigurazioneDB_LIB.getValue(validazioneBuste.getControllo());
            val_stato = DriverConfigurazioneDB_LIB.getValue(validazioneBuste.getStato());
            val_manifest = DriverConfigurazioneDB_LIB.getValue(validazioneBuste.getManifestAttachments());
            val_profiloCollaborazione = DriverConfigurazioneDB_LIB.getValue(validazioneBuste.getProfiloCollaborazione());
        }
        String gestioneManifest = null;
        if (att != null) {
            gestioneManifest = DriverConfigurazioneDB_LIB.getValue(att.getGestioneManifest());
        }
        Cache registro_cache = null;
        String registro_dimensioneCache = null;
        String registro_algoritmoCache = null;
        String registro_idleCache = null;
        String registro_lifeCache = null;
        String registro_statoCache = null;
        if (car != null) {
            registro_cache = car.getCache();
        }
        String string = registro_statoCache = registro_cache != null ? CostantiConfigurazione.ABILITATO.toString() : CostantiConfigurazione.DISABILITATO.toString();
        if (registro_statoCache.equals(CostantiConfigurazione.ABILITATO.toString())) {
            registro_dimensioneCache = registro_cache.getDimensione();
            registro_algoritmoCache = DriverConfigurazioneDB_LIB.getValue(registro_cache.getAlgoritmo());
            registro_idleCache = registro_cache.getItemIdleTime();
            registro_lifeCache = registro_cache.getItemLifeSecond();
        }
        Cache config_cache = null;
        String config_dimensioneCache = null;
        String config_algoritmoCache = null;
        String config_idleCache = null;
        String config_lifeCache = null;
        String config_statoCache = null;
        if (aConfig != null) {
            config_cache = aConfig.getCache();
        }
        String string2 = config_statoCache = config_cache != null ? CostantiConfigurazione.ABILITATO.toString() : CostantiConfigurazione.DISABILITATO.toString();
        if (config_statoCache.equals(CostantiConfigurazione.ABILITATO.toString())) {
            config_dimensioneCache = config_cache.getDimensione();
            config_algoritmoCache = DriverConfigurazioneDB_LIB.getValue(config_cache.getAlgoritmo());
            config_idleCache = config_cache.getItemIdleTime();
            config_lifeCache = config_cache.getItemLifeSecond();
        }
        Cache auth_cache = null;
        String auth_dimensioneCache = null;
        String auth_algoritmoCache = null;
        String auth_idleCache = null;
        String auth_lifeCache = null;
        String auth_statoCache = null;
        if (aDatiAuth != null) {
            auth_cache = aDatiAuth.getCache();
        }
        String string3 = auth_statoCache = auth_cache != null ? CostantiConfigurazione.ABILITATO.toString() : CostantiConfigurazione.DISABILITATO.toString();
        if (auth_statoCache.equals(CostantiConfigurazione.ABILITATO.toString())) {
            auth_dimensioneCache = auth_cache.getDimensione();
            auth_algoritmoCache = DriverConfigurazioneDB_LIB.getValue(auth_cache.getAlgoritmo());
            auth_idleCache = auth_cache.getItemIdleTime();
            auth_lifeCache = auth_cache.getItemLifeSecond();
        }
        Tracciamento t = config.getTracciamento();
        String tracciamentoBuste = null;
        String dumpApplicativo = null;
        String dumpPD = null;
        String dumpPA = null;
        if (t != null) {
            tracciamentoBuste = DriverConfigurazioneDB_LIB.getValue(t.getBuste());
            dumpApplicativo = DriverConfigurazioneDB_LIB.getValue(t.getDump());
            dumpPD = DriverConfigurazioneDB_LIB.getValue(t.getDumpBinarioPortaDelegata());
            dumpPA = DriverConfigurazioneDB_LIB.getValue(t.getDumpBinarioPortaApplicativa());
        }
        String modRisposta = CostantiConfigurazione.CONNECTION_REPLY.toString();
        if (risposte != null) {
            modRisposta = risposte.getConnessione().equals(CostantiConfigurazione.CONNECTION_REPLY) ? CostantiConfigurazione.CONNECTION_REPLY.toString() : CostantiConfigurazione.NEW_CONNECTION.toString();
        }
        String routingEnabled = CostantiConfigurazione.DISABILITATO.toString();
        if (config.getRoutingTable() != null && config.getRoutingTable().getAbilitata() != null && config.getRoutingTable().getAbilitata().booleanValue()) {
            routingEnabled = CostantiConfigurazione.ABILITATO.toString();
        }
        String validazione_contenuti_stato = null;
        String validazione_contenuti_tipo = null;
        String validazione_contenuti_acceptMtomMessage = null;
        if (config.getValidazioneContenutiApplicativi() != null) {
            validazione_contenuti_stato = DriverConfigurazioneDB_LIB.getValue(config.getValidazioneContenutiApplicativi().getStato());
            validazione_contenuti_tipo = DriverConfigurazioneDB_LIB.getValue(config.getValidazioneContenutiApplicativi().getTipo());
            validazione_contenuti_acceptMtomMessage = DriverConfigurazioneDB_LIB.getValue(config.getValidazioneContenutiApplicativi().getAcceptMtomMessage());
        }
        ExtendedInfoManager extInfoManager = ExtendedInfoManager.getInstance();
        IExtendedInfo extInfoConfigurazioneDriver = extInfoManager.newInstanceExtendedInfoConfigurazione();
        try {
            switch (type) {
                case 1: {
                    OpenspcoopSorgenteDati ds;
                    int l;
                    ArrayList<InsertAndGeneratedKeyObject> listInsertAndGeneratedKeyObject;
                    OpenspcoopAppender appender;
                    int k;
                    ISQLQueryObject sqlQueryObject2 = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                    sqlQueryObject2.addInsertTable("configurazione");
                    sqlQueryObject2.addInsertField("cadenza_inoltro", "?");
                    sqlQueryObject2.addInsertField("validazione_stato", "?");
                    sqlQueryObject2.addInsertField("validazione_controllo", "?");
                    sqlQueryObject2.addInsertField("msg_diag_severita", "?");
                    sqlQueryObject2.addInsertField("msg_diag_severita_log4j", "?");
                    sqlQueryObject2.addInsertField("auth_integration_manager", "?");
                    sqlQueryObject2.addInsertField("validazione_profilo", "?");
                    sqlQueryObject2.addInsertField("mod_risposta", "?");
                    sqlQueryObject2.addInsertField("indirizzo_telematico", "?");
                    sqlQueryObject2.addInsertField("routing_enabled", "?");
                    sqlQueryObject2.addInsertField("gestione_manifest", "?");
                    sqlQueryObject2.addInsertField("validazione_manifest", "?");
                    sqlQueryObject2.addInsertField("tracciamento_buste", "?");
                    sqlQueryObject2.addInsertField("tracciamento_dump", "?");
                    sqlQueryObject2.addInsertField("tracciamento_dump_bin_pd", "?");
                    sqlQueryObject2.addInsertField("tracciamento_dump_bin_pa", "?");
                    sqlQueryObject2.addInsertField("validazione_contenuti_stato", "?");
                    sqlQueryObject2.addInsertField("validazione_contenuti_tipo", "?");
                    sqlQueryObject2.addInsertField("validazione_contenuti_mtom", "?");
                    sqlQueryObject2.addInsertField("statocache", "?");
                    sqlQueryObject2.addInsertField("dimensionecache", "?");
                    sqlQueryObject2.addInsertField("algoritmocache", "?");
                    sqlQueryObject2.addInsertField("idlecache", "?");
                    sqlQueryObject2.addInsertField("lifecache", "?");
                    sqlQueryObject2.addInsertField("config_statocache", "?");
                    sqlQueryObject2.addInsertField("config_dimensionecache", "?");
                    sqlQueryObject2.addInsertField("config_algoritmocache", "?");
                    sqlQueryObject2.addInsertField("config_idlecache", "?");
                    sqlQueryObject2.addInsertField("config_lifecache", "?");
                    sqlQueryObject2.addInsertField("auth_statocache", "?");
                    sqlQueryObject2.addInsertField("auth_dimensionecache", "?");
                    sqlQueryObject2.addInsertField("auth_algoritmocache", "?");
                    sqlQueryObject2.addInsertField("auth_idlecache", "?");
                    sqlQueryObject2.addInsertField("auth_lifecache", "?");
                    updateQuery = sqlQueryObject2.createSQLInsert();
                    updateStmt = con.prepareStatement(updateQuery);
                    int index = 1;
                    updateStmt.setString(index++, cadenza_inoltro);
                    updateStmt.setString(index++, val_stato);
                    updateStmt.setString(index++, val_controllo);
                    updateStmt.setString(index++, msg_diag_severita);
                    updateStmt.setString(index++, msg_diag_severita_log4j);
                    updateStmt.setString(index++, autenticazione);
                    updateStmt.setString(index++, val_profiloCollaborazione);
                    updateStmt.setString(index++, modRisposta);
                    updateStmt.setString(index++, utilizzoIndTelematico);
                    updateStmt.setString(index++, routingEnabled);
                    updateStmt.setString(index++, gestioneManifest);
                    updateStmt.setString(index++, val_manifest);
                    updateStmt.setString(index++, tracciamentoBuste);
                    updateStmt.setString(index++, dumpApplicativo);
                    updateStmt.setString(index++, dumpPD);
                    updateStmt.setString(index++, dumpPA);
                    updateStmt.setString(index++, validazione_contenuti_stato);
                    updateStmt.setString(index++, validazione_contenuti_tipo);
                    updateStmt.setString(index++, validazione_contenuti_acceptMtomMessage);
                    updateStmt.setString(index++, registro_statoCache);
                    updateStmt.setString(index++, registro_dimensioneCache);
                    updateStmt.setString(index++, registro_algoritmoCache);
                    updateStmt.setString(index++, registro_idleCache);
                    updateStmt.setString(index++, registro_lifeCache);
                    updateStmt.setString(index++, config_statoCache);
                    updateStmt.setString(index++, config_dimensioneCache);
                    updateStmt.setString(index++, config_algoritmoCache);
                    updateStmt.setString(index++, config_idleCache);
                    updateStmt.setString(index++, config_lifeCache);
                    updateStmt.setString(index++, auth_statoCache);
                    updateStmt.setString(index++, auth_dimensioneCache);
                    updateStmt.setString(index++, auth_algoritmoCache);
                    updateStmt.setString(index++, auth_idleCache);
                    updateStmt.setString(index++, auth_lifeCache);
                    log.debug((Object)("eseguo query :" + DBUtils.formatSQLString(updateQuery, cadenza_inoltro, val_stato, val_controllo, msg_diag_severita, msg_diag_severita_log4j, autenticazione, val_profiloCollaborazione, modRisposta, utilizzoIndTelematico, routingEnabled, gestioneManifest, val_manifest, tracciamentoBuste, dumpApplicativo, dumpPD, dumpPA, validazione_contenuti_stato, validazione_contenuti_tipo, validazione_contenuti_acceptMtomMessage, registro_statoCache, registro_dimensioneCache, registro_algoritmoCache, registro_idleCache, registro_lifeCache, config_statoCache, config_dimensioneCache, config_algoritmoCache, config_idleCache, config_lifeCache, auth_statoCache, auth_dimensioneCache, auth_algoritmoCache, auth_idleCache, auth_lifeCache)));
                    n = updateStmt.executeUpdate();
                    updateStmt.close();
                    sqlQueryObject2 = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                    sqlQueryObject2.addDeleteTable("msgdiag_appender_prop");
                    updateQuery = sqlQueryObject2.createSQLDelete();
                    updateStmt = con.prepareStatement(updateQuery);
                    updateStmt.executeUpdate();
                    updateStmt.close();
                    sqlQueryObject2 = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                    sqlQueryObject2.addDeleteTable("msgdiag_appender");
                    updateQuery = sqlQueryObject2.createSQLDelete();
                    updateStmt = con.prepareStatement(updateQuery);
                    updateStmt.executeUpdate();
                    updateStmt.close();
                    if (config.getMessaggiDiagnostici() != null) {
                        for (k = 0; k < config.getMessaggiDiagnostici().sizeOpenspcoopAppenderList(); ++k) {
                            appender = config.getMessaggiDiagnostici().getOpenspcoopAppender(k);
                            listInsertAndGeneratedKeyObject = new ArrayList<InsertAndGeneratedKeyObject>();
                            listInsertAndGeneratedKeyObject.add(new InsertAndGeneratedKeyObject("tipo", (Object)appender.getTipo(), InsertAndGeneratedKeyJDBCType.STRING));
                            long idMsgDiagAppender = InsertAndGeneratedKey.insertAndReturnGeneratedKey((Connection)con, (TipiDatabase)TipiDatabase.toEnumConstant((String)tipoDB), (IKeyGeneratorObject)new CustomKeyGeneratorObject("msgdiag_appender", "id", "seq_msgdiag_appender", "msgdiag_appender_init_seq"), (InsertAndGeneratedKeyObject[])listInsertAndGeneratedKeyObject.toArray(new InsertAndGeneratedKeyObject[1]));
                            if (idMsgDiagAppender <= 0L) {
                                throw new Exception("ID (msg diag appender) autoincrementale non ottenuto");
                            }
                            for (l = 0; l < appender.sizePropertyList(); ++l) {
                                sqlQueryObject2 = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                                sqlQueryObject2.addInsertTable("msgdiag_appender_prop");
                                sqlQueryObject2.addInsertField("id_appender", "?");
                                sqlQueryObject2.addInsertField("nome", "?");
                                sqlQueryObject2.addInsertField("valore", "?");
                                updateQuery = sqlQueryObject2.createSQLInsert();
                                updateStmt = con.prepareStatement(updateQuery);
                                updateStmt.setLong(1, idMsgDiagAppender);
                                updateStmt.setString(2, appender.getProperty(l).getNome());
                                updateStmt.setString(3, appender.getProperty(l).getValore());
                                updateStmt.executeUpdate();
                                updateStmt.close();
                            }
                        }
                    }
                    sqlQueryObject2 = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                    sqlQueryObject2.addDeleteTable("tracce_appender_prop");
                    updateQuery = sqlQueryObject2.createSQLDelete();
                    updateStmt = con.prepareStatement(updateQuery);
                    updateStmt.executeUpdate();
                    updateStmt.close();
                    sqlQueryObject2 = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                    sqlQueryObject2.addDeleteTable("tracce_appender");
                    updateQuery = sqlQueryObject2.createSQLDelete();
                    updateStmt = con.prepareStatement(updateQuery);
                    updateStmt.executeUpdate();
                    updateStmt.close();
                    if (config.getTracciamento() != null) {
                        for (k = 0; k < config.getTracciamento().sizeOpenspcoopAppenderList(); ++k) {
                            appender = config.getTracciamento().getOpenspcoopAppender(k);
                            listInsertAndGeneratedKeyObject = new ArrayList();
                            listInsertAndGeneratedKeyObject.add(new InsertAndGeneratedKeyObject("tipo", (Object)appender.getTipo(), InsertAndGeneratedKeyJDBCType.STRING));
                            long idTracceAppender = InsertAndGeneratedKey.insertAndReturnGeneratedKey((Connection)con, (TipiDatabase)TipiDatabase.toEnumConstant((String)tipoDB), (IKeyGeneratorObject)new CustomKeyGeneratorObject("tracce_appender", "id", "seq_tracce_appender", "tracce_appender_init_seq"), (InsertAndGeneratedKeyObject[])listInsertAndGeneratedKeyObject.toArray(new InsertAndGeneratedKeyObject[1]));
                            if (idTracceAppender <= 0L) {
                                throw new Exception("ID (tracce appender) autoincrementale non ottenuto");
                            }
                            for (l = 0; l < appender.sizePropertyList(); ++l) {
                                sqlQueryObject2 = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                                sqlQueryObject2.addInsertTable("tracce_appender_prop");
                                sqlQueryObject2.addInsertField("id_appender", "?");
                                sqlQueryObject2.addInsertField("nome", "?");
                                sqlQueryObject2.addInsertField("valore", "?");
                                updateQuery = sqlQueryObject2.createSQLInsert();
                                updateStmt = con.prepareStatement(updateQuery);
                                updateStmt.setLong(1, idTracceAppender);
                                updateStmt.setString(2, appender.getProperty(l).getNome());
                                updateStmt.setString(3, appender.getProperty(l).getValore());
                                updateStmt.executeUpdate();
                                updateStmt.close();
                            }
                        }
                    }
                    sqlQueryObject2 = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                    sqlQueryObject2.addDeleteTable("msgdiag_ds_prop");
                    updateQuery = sqlQueryObject2.createSQLDelete();
                    updateStmt = con.prepareStatement(updateQuery);
                    updateStmt.executeUpdate();
                    updateStmt.close();
                    sqlQueryObject2 = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                    sqlQueryObject2.addDeleteTable("msgdiag_ds");
                    updateQuery = sqlQueryObject2.createSQLDelete();
                    updateStmt = con.prepareStatement(updateQuery);
                    updateStmt.executeUpdate();
                    updateStmt.close();
                    if (config.getMessaggiDiagnostici() != null) {
                        for (k = 0; k < config.getMessaggiDiagnostici().sizeOpenspcoopSorgenteDatiList(); ++k) {
                            ds = config.getMessaggiDiagnostici().getOpenspcoopSorgenteDati(k);
                            listInsertAndGeneratedKeyObject = new ArrayList();
                            listInsertAndGeneratedKeyObject.add(new InsertAndGeneratedKeyObject("nome", (Object)ds.getNome(), InsertAndGeneratedKeyJDBCType.STRING));
                            listInsertAndGeneratedKeyObject.add(new InsertAndGeneratedKeyObject("nome_jndi", (Object)ds.getNomeJndi(), InsertAndGeneratedKeyJDBCType.STRING));
                            listInsertAndGeneratedKeyObject.add(new InsertAndGeneratedKeyObject("tipo_database", (Object)ds.getTipoDatabase(), InsertAndGeneratedKeyJDBCType.STRING));
                            long idMsgDsAppender = InsertAndGeneratedKey.insertAndReturnGeneratedKey((Connection)con, (TipiDatabase)TipiDatabase.toEnumConstant((String)tipoDB), (IKeyGeneratorObject)new CustomKeyGeneratorObject("msgdiag_ds", "id", "seq_msgdiag_ds", "msgdiag_ds_init_seq"), (InsertAndGeneratedKeyObject[])listInsertAndGeneratedKeyObject.toArray(new InsertAndGeneratedKeyObject[1]));
                            if (idMsgDsAppender <= 0L) {
                                throw new Exception("ID (msgdiag ds appender) autoincrementale non ottenuto");
                            }
                            for (l = 0; l < ds.sizePropertyList(); ++l) {
                                sqlQueryObject2 = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                                sqlQueryObject2.addInsertTable("msgdiag_ds_prop");
                                sqlQueryObject2.addInsertField("id_prop", "?");
                                sqlQueryObject2.addInsertField("nome", "?");
                                sqlQueryObject2.addInsertField("valore", "?");
                                updateQuery = sqlQueryObject2.createSQLInsert();
                                updateStmt = con.prepareStatement(updateQuery);
                                updateStmt.setLong(1, idMsgDsAppender);
                                updateStmt.setString(2, ds.getProperty(l).getNome());
                                updateStmt.setString(3, ds.getProperty(l).getValore());
                                updateStmt.executeUpdate();
                                updateStmt.close();
                            }
                        }
                    }
                    sqlQueryObject2 = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                    sqlQueryObject2.addDeleteTable("tracce_ds_prop");
                    updateQuery = sqlQueryObject2.createSQLDelete();
                    updateStmt = con.prepareStatement(updateQuery);
                    updateStmt.executeUpdate();
                    updateStmt.close();
                    sqlQueryObject2 = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                    sqlQueryObject2.addDeleteTable("tracce_ds");
                    updateQuery = sqlQueryObject2.createSQLDelete();
                    updateStmt = con.prepareStatement(updateQuery);
                    updateStmt.executeUpdate();
                    updateStmt.close();
                    if (config.getTracciamento() != null) {
                        for (k = 0; k < config.getTracciamento().sizeOpenspcoopSorgenteDatiList(); ++k) {
                            ds = config.getTracciamento().getOpenspcoopSorgenteDati(k);
                            listInsertAndGeneratedKeyObject = new ArrayList();
                            listInsertAndGeneratedKeyObject.add(new InsertAndGeneratedKeyObject("nome", (Object)ds.getNome(), InsertAndGeneratedKeyJDBCType.STRING));
                            listInsertAndGeneratedKeyObject.add(new InsertAndGeneratedKeyObject("nome_jndi", (Object)ds.getNomeJndi(), InsertAndGeneratedKeyJDBCType.STRING));
                            listInsertAndGeneratedKeyObject.add(new InsertAndGeneratedKeyObject("tipo_database", (Object)ds.getTipoDatabase(), InsertAndGeneratedKeyJDBCType.STRING));
                            long idTracceDsAppender = InsertAndGeneratedKey.insertAndReturnGeneratedKey((Connection)con, (TipiDatabase)TipiDatabase.toEnumConstant((String)tipoDB), (IKeyGeneratorObject)new CustomKeyGeneratorObject("tracce_ds", "id", "seq_tracce_ds", "tracce_ds_init_seq"), (InsertAndGeneratedKeyObject[])listInsertAndGeneratedKeyObject.toArray(new InsertAndGeneratedKeyObject[1]));
                            if (idTracceDsAppender <= 0L) {
                                throw new Exception("ID (tracciamento ds appender) autoincrementale non ottenuto");
                            }
                            for (l = 0; l < ds.sizePropertyList(); ++l) {
                                sqlQueryObject2 = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                                sqlQueryObject2.addInsertTable("tracce_ds_prop");
                                sqlQueryObject2.addInsertField("id_prop", "?");
                                sqlQueryObject2.addInsertField("nome", "?");
                                sqlQueryObject2.addInsertField("valore", "?");
                                updateQuery = sqlQueryObject2.createSQLInsert();
                                updateStmt = con.prepareStatement(updateQuery);
                                updateStmt.setLong(1, idTracceDsAppender);
                                updateStmt.setString(2, ds.getProperty(l).getNome());
                                updateStmt.setString(3, ds.getProperty(l).getValore());
                                updateStmt.executeUpdate();
                                updateStmt.close();
                            }
                        }
                    }
                    if (extInfoConfigurazioneDriver == null) break;
                    extInfoConfigurazioneDriver.deleteAllExtendedInfo(con, log, config);
                    if (config.sizeExtendedInfoList() <= 0) break;
                    for (int l2 = 0; l2 < config.sizeExtendedInfoList(); ++l2) {
                        extInfoConfigurazioneDriver.createExtendedInfo(con, log, config, config.getExtendedInfo(l2));
                    }
                    break;
                }
                case 2: {
                    OpenspcoopSorgenteDati ds;
                    int l;
                    ArrayList<InsertAndGeneratedKeyObject> listInsertAndGeneratedKeyObject;
                    OpenspcoopAppender appender;
                    int k;
                    ISQLQueryObject sqlQueryObject2 = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                    sqlQueryObject2.addUpdateTable("configurazione");
                    sqlQueryObject2.addUpdateField("cadenza_inoltro", "?");
                    sqlQueryObject2.addUpdateField("validazione_stato", "?");
                    sqlQueryObject2.addUpdateField("validazione_controllo", "?");
                    sqlQueryObject2.addUpdateField("msg_diag_severita", "?");
                    sqlQueryObject2.addUpdateField("msg_diag_severita_log4j", "?");
                    sqlQueryObject2.addUpdateField("auth_integration_manager", "?");
                    sqlQueryObject2.addUpdateField("validazione_profilo", "?");
                    sqlQueryObject2.addUpdateField("mod_risposta", "?");
                    sqlQueryObject2.addUpdateField("indirizzo_telematico", "?");
                    sqlQueryObject2.addUpdateField("routing_enabled", "?");
                    sqlQueryObject2.addUpdateField("gestione_manifest", "?");
                    sqlQueryObject2.addUpdateField("validazione_manifest", "?");
                    sqlQueryObject2.addUpdateField("tracciamento_buste", "?");
                    sqlQueryObject2.addUpdateField("tracciamento_dump", "?");
                    sqlQueryObject2.addUpdateField("tracciamento_dump_bin_pd", "?");
                    sqlQueryObject2.addUpdateField("tracciamento_dump_bin_pa", "?");
                    sqlQueryObject2.addUpdateField("validazione_contenuti_stato", "?");
                    sqlQueryObject2.addUpdateField("validazione_contenuti_tipo", "?");
                    sqlQueryObject2.addUpdateField("validazione_contenuti_mtom", "?");
                    sqlQueryObject2.addUpdateField("statocache", "?");
                    sqlQueryObject2.addUpdateField("dimensionecache", "?");
                    sqlQueryObject2.addUpdateField("algoritmocache", "?");
                    sqlQueryObject2.addUpdateField("idlecache", "?");
                    sqlQueryObject2.addUpdateField("lifecache", "?");
                    sqlQueryObject2.addUpdateField("config_statocache", "?");
                    sqlQueryObject2.addUpdateField("config_dimensionecache", "?");
                    sqlQueryObject2.addUpdateField("config_algoritmocache", "?");
                    sqlQueryObject2.addUpdateField("config_idlecache", "?");
                    sqlQueryObject2.addUpdateField("config_lifecache", "?");
                    sqlQueryObject2.addUpdateField("auth_statocache", "?");
                    sqlQueryObject2.addUpdateField("auth_dimensionecache", "?");
                    sqlQueryObject2.addUpdateField("auth_algoritmocache", "?");
                    sqlQueryObject2.addUpdateField("auth_idlecache", "?");
                    sqlQueryObject2.addUpdateField("auth_lifecache", "?");
                    updateQuery = sqlQueryObject2.createSQLUpdate();
                    updateStmt = con.prepareStatement(updateQuery);
                    int index = 1;
                    updateStmt.setString(index++, cadenza_inoltro);
                    updateStmt.setString(index++, val_stato);
                    updateStmt.setString(index++, val_controllo);
                    updateStmt.setString(index++, msg_diag_severita);
                    updateStmt.setString(index++, msg_diag_severita_log4j);
                    updateStmt.setString(index++, autenticazione);
                    updateStmt.setString(index++, val_profiloCollaborazione);
                    updateStmt.setString(index++, modRisposta);
                    updateStmt.setString(index++, utilizzoIndTelematico);
                    updateStmt.setString(index++, routingEnabled);
                    updateStmt.setString(index++, gestioneManifest);
                    updateStmt.setString(index++, val_manifest);
                    updateStmt.setString(index++, tracciamentoBuste);
                    updateStmt.setString(index++, dumpApplicativo);
                    updateStmt.setString(index++, dumpPD);
                    updateStmt.setString(index++, dumpPA);
                    updateStmt.setString(index++, validazione_contenuti_stato);
                    updateStmt.setString(index++, validazione_contenuti_tipo);
                    updateStmt.setString(index++, validazione_contenuti_acceptMtomMessage);
                    updateStmt.setString(index++, registro_statoCache);
                    updateStmt.setString(index++, registro_dimensioneCache);
                    updateStmt.setString(index++, registro_algoritmoCache);
                    updateStmt.setString(index++, registro_idleCache);
                    updateStmt.setString(index++, registro_lifeCache);
                    updateStmt.setString(index++, config_statoCache);
                    updateStmt.setString(index++, config_dimensioneCache);
                    updateStmt.setString(index++, config_algoritmoCache);
                    updateStmt.setString(index++, config_idleCache);
                    updateStmt.setString(index++, config_lifeCache);
                    updateStmt.setString(index++, auth_statoCache);
                    updateStmt.setString(index++, auth_dimensioneCache);
                    updateStmt.setString(index++, auth_algoritmoCache);
                    updateStmt.setString(index++, auth_idleCache);
                    updateStmt.setString(index++, auth_lifeCache);
                    log.debug((Object)("eseguo query :" + DBUtils.formatSQLString(updateQuery, cadenza_inoltro, val_stato, val_controllo, msg_diag_severita, msg_diag_severita_log4j, autenticazione, val_profiloCollaborazione, modRisposta, utilizzoIndTelematico, routingEnabled, gestioneManifest, val_manifest, tracciamentoBuste, dumpApplicativo, dumpPD, dumpPA, validazione_contenuti_stato, validazione_contenuti_tipo, registro_statoCache, registro_dimensioneCache, registro_algoritmoCache, registro_idleCache, registro_lifeCache, config_statoCache, config_dimensioneCache, config_algoritmoCache, config_idleCache, config_lifeCache, auth_statoCache, auth_dimensioneCache, auth_algoritmoCache, auth_idleCache, auth_lifeCache)));
                    n = updateStmt.executeUpdate();
                    updateStmt.close();
                    sqlQueryObject2 = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                    sqlQueryObject2.addDeleteTable("msgdiag_appender_prop");
                    updateQuery = sqlQueryObject2.createSQLDelete();
                    updateStmt = con.prepareStatement(updateQuery);
                    updateStmt.executeUpdate();
                    updateStmt.close();
                    sqlQueryObject2 = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                    sqlQueryObject2.addDeleteTable("msgdiag_appender");
                    updateQuery = sqlQueryObject2.createSQLDelete();
                    updateStmt = con.prepareStatement(updateQuery);
                    updateStmt.executeUpdate();
                    updateStmt.close();
                    if (config.getMessaggiDiagnostici() != null) {
                        for (k = 0; k < config.getMessaggiDiagnostici().sizeOpenspcoopAppenderList(); ++k) {
                            appender = config.getMessaggiDiagnostici().getOpenspcoopAppender(k);
                            listInsertAndGeneratedKeyObject = new ArrayList<InsertAndGeneratedKeyObject>();
                            listInsertAndGeneratedKeyObject.add(new InsertAndGeneratedKeyObject("tipo", (Object)appender.getTipo(), InsertAndGeneratedKeyJDBCType.STRING));
                            long idMsgDiagAppender = InsertAndGeneratedKey.insertAndReturnGeneratedKey((Connection)con, (TipiDatabase)TipiDatabase.toEnumConstant((String)tipoDB), (IKeyGeneratorObject)new CustomKeyGeneratorObject("msgdiag_appender", "id", "seq_msgdiag_appender", "msgdiag_appender_init_seq"), (InsertAndGeneratedKeyObject[])listInsertAndGeneratedKeyObject.toArray(new InsertAndGeneratedKeyObject[1]));
                            if (idMsgDiagAppender <= 0L) {
                                throw new Exception("ID (msg diag appender) autoincrementale non ottenuto");
                            }
                            for (l = 0; l < appender.sizePropertyList(); ++l) {
                                log.debug((Object)("INSERT INTO msgdiag_appender_prop (id_appender,nome,valore) VALUES (" + idMsgDiagAppender + "," + appender.getProperty(l).getNome() + "," + appender.getProperty(l).getValore() + ")"));
                                sqlQueryObject2 = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                                sqlQueryObject2.addInsertTable("msgdiag_appender_prop");
                                sqlQueryObject2.addInsertField("id_appender", "?");
                                sqlQueryObject2.addInsertField("nome", "?");
                                sqlQueryObject2.addInsertField("valore", "?");
                                updateQuery = sqlQueryObject2.createSQLInsert();
                                updateStmt = con.prepareStatement(updateQuery);
                                updateStmt.setLong(1, idMsgDiagAppender);
                                updateStmt.setString(2, appender.getProperty(l).getNome());
                                updateStmt.setString(3, appender.getProperty(l).getValore());
                                updateStmt.executeUpdate();
                                updateStmt.close();
                            }
                        }
                    }
                    sqlQueryObject2 = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                    sqlQueryObject2.addDeleteTable("tracce_appender_prop");
                    updateQuery = sqlQueryObject2.createSQLDelete();
                    updateStmt = con.prepareStatement(updateQuery);
                    updateStmt.executeUpdate();
                    updateStmt.close();
                    sqlQueryObject2 = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                    sqlQueryObject2.addDeleteTable("tracce_appender");
                    updateQuery = sqlQueryObject2.createSQLDelete();
                    updateStmt = con.prepareStatement(updateQuery);
                    updateStmt.executeUpdate();
                    updateStmt.close();
                    if (config.getTracciamento() != null) {
                        for (k = 0; k < config.getTracciamento().sizeOpenspcoopAppenderList(); ++k) {
                            appender = config.getTracciamento().getOpenspcoopAppender(k);
                            listInsertAndGeneratedKeyObject = new ArrayList();
                            listInsertAndGeneratedKeyObject.add(new InsertAndGeneratedKeyObject("tipo", (Object)appender.getTipo(), InsertAndGeneratedKeyJDBCType.STRING));
                            long idTracceAppender = InsertAndGeneratedKey.insertAndReturnGeneratedKey((Connection)con, (TipiDatabase)TipiDatabase.toEnumConstant((String)tipoDB), (IKeyGeneratorObject)new CustomKeyGeneratorObject("tracce_appender", "id", "seq_tracce_appender", "tracce_appender_init_seq"), (InsertAndGeneratedKeyObject[])listInsertAndGeneratedKeyObject.toArray(new InsertAndGeneratedKeyObject[1]));
                            if (idTracceAppender <= 0L) {
                                throw new Exception("ID (tracce appender) autoincrementale non ottenuto");
                            }
                            for (l = 0; l < appender.sizePropertyList(); ++l) {
                                log.debug((Object)("INSERT INTO tracce_appender_prop (id_appender,nome,valore) VALUES (" + idTracceAppender + "," + appender.getProperty(l).getNome() + "," + appender.getProperty(l).getValore() + ")"));
                                sqlQueryObject2 = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                                sqlQueryObject2.addInsertTable("tracce_appender_prop");
                                sqlQueryObject2.addInsertField("id_appender", "?");
                                sqlQueryObject2.addInsertField("nome", "?");
                                sqlQueryObject2.addInsertField("valore", "?");
                                updateQuery = sqlQueryObject2.createSQLInsert();
                                updateStmt = con.prepareStatement(updateQuery);
                                updateStmt.setLong(1, idTracceAppender);
                                updateStmt.setString(2, appender.getProperty(l).getNome());
                                updateStmt.setString(3, appender.getProperty(l).getValore());
                                updateStmt.executeUpdate();
                                updateStmt.close();
                            }
                        }
                    }
                    sqlQueryObject2 = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                    sqlQueryObject2.addDeleteTable("msgdiag_ds_prop");
                    updateQuery = sqlQueryObject2.createSQLDelete();
                    updateStmt = con.prepareStatement(updateQuery);
                    updateStmt.executeUpdate();
                    updateStmt.close();
                    sqlQueryObject2 = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                    sqlQueryObject2.addDeleteTable("msgdiag_ds");
                    updateQuery = sqlQueryObject2.createSQLDelete();
                    updateStmt = con.prepareStatement(updateQuery);
                    updateStmt.executeUpdate();
                    updateStmt.close();
                    if (config.getMessaggiDiagnostici() != null) {
                        for (k = 0; k < config.getMessaggiDiagnostici().sizeOpenspcoopSorgenteDatiList(); ++k) {
                            ds = config.getMessaggiDiagnostici().getOpenspcoopSorgenteDati(k);
                            listInsertAndGeneratedKeyObject = new ArrayList();
                            listInsertAndGeneratedKeyObject.add(new InsertAndGeneratedKeyObject("nome", (Object)ds.getNome(), InsertAndGeneratedKeyJDBCType.STRING));
                            listInsertAndGeneratedKeyObject.add(new InsertAndGeneratedKeyObject("nome_jndi", (Object)ds.getNomeJndi(), InsertAndGeneratedKeyJDBCType.STRING));
                            listInsertAndGeneratedKeyObject.add(new InsertAndGeneratedKeyObject("tipo_database", (Object)ds.getTipoDatabase(), InsertAndGeneratedKeyJDBCType.STRING));
                            long idMsgDsAppender = InsertAndGeneratedKey.insertAndReturnGeneratedKey((Connection)con, (TipiDatabase)TipiDatabase.toEnumConstant((String)tipoDB), (IKeyGeneratorObject)new CustomKeyGeneratorObject("msgdiag_ds", "id", "seq_msgdiag_ds", "msgdiag_ds_init_seq"), (InsertAndGeneratedKeyObject[])listInsertAndGeneratedKeyObject.toArray(new InsertAndGeneratedKeyObject[1]));
                            if (idMsgDsAppender <= 0L) {
                                throw new Exception("ID (msgdiag ds appender) autoincrementale non ottenuto");
                            }
                            for (l = 0; l < ds.sizePropertyList(); ++l) {
                                sqlQueryObject2 = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                                sqlQueryObject2.addInsertTable("msgdiag_ds_prop");
                                sqlQueryObject2.addInsertField("id_prop", "?");
                                sqlQueryObject2.addInsertField("nome", "?");
                                sqlQueryObject2.addInsertField("valore", "?");
                                updateQuery = sqlQueryObject2.createSQLInsert();
                                updateStmt = con.prepareStatement(updateQuery);
                                updateStmt.setLong(1, idMsgDsAppender);
                                updateStmt.setString(2, ds.getProperty(l).getNome());
                                updateStmt.setString(3, ds.getProperty(l).getValore());
                                updateStmt.executeUpdate();
                                updateStmt.close();
                            }
                        }
                    }
                    sqlQueryObject2 = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                    sqlQueryObject2.addDeleteTable("tracce_ds_prop");
                    updateQuery = sqlQueryObject2.createSQLDelete();
                    updateStmt = con.prepareStatement(updateQuery);
                    updateStmt.executeUpdate();
                    updateStmt.close();
                    sqlQueryObject2 = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                    sqlQueryObject2.addDeleteTable("tracce_ds");
                    updateQuery = sqlQueryObject2.createSQLDelete();
                    updateStmt = con.prepareStatement(updateQuery);
                    updateStmt.executeUpdate();
                    updateStmt.close();
                    if (config.getTracciamento() != null) {
                        for (k = 0; k < config.getTracciamento().sizeOpenspcoopSorgenteDatiList(); ++k) {
                            ds = config.getTracciamento().getOpenspcoopSorgenteDati(k);
                            listInsertAndGeneratedKeyObject = new ArrayList();
                            listInsertAndGeneratedKeyObject.add(new InsertAndGeneratedKeyObject("nome", (Object)ds.getNome(), InsertAndGeneratedKeyJDBCType.STRING));
                            listInsertAndGeneratedKeyObject.add(new InsertAndGeneratedKeyObject("nome_jndi", (Object)ds.getNomeJndi(), InsertAndGeneratedKeyJDBCType.STRING));
                            listInsertAndGeneratedKeyObject.add(new InsertAndGeneratedKeyObject("tipo_database", (Object)ds.getTipoDatabase(), InsertAndGeneratedKeyJDBCType.STRING));
                            long idTracceDsAppender = InsertAndGeneratedKey.insertAndReturnGeneratedKey((Connection)con, (TipiDatabase)TipiDatabase.toEnumConstant((String)tipoDB), (IKeyGeneratorObject)new CustomKeyGeneratorObject("tracce_ds", "id", "seq_tracce_ds", "tracce_ds_init_seq"), (InsertAndGeneratedKeyObject[])listInsertAndGeneratedKeyObject.toArray(new InsertAndGeneratedKeyObject[1]));
                            if (idTracceDsAppender <= 0L) {
                                throw new Exception("ID (tracciamento ds appender) autoincrementale non ottenuto");
                            }
                            for (l = 0; l < ds.sizePropertyList(); ++l) {
                                sqlQueryObject2 = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                                sqlQueryObject2.addInsertTable("tracce_ds_prop");
                                sqlQueryObject2.addInsertField("id_prop", "?");
                                sqlQueryObject2.addInsertField("nome", "?");
                                sqlQueryObject2.addInsertField("valore", "?");
                                updateQuery = sqlQueryObject2.createSQLInsert();
                                updateStmt = con.prepareStatement(updateQuery);
                                updateStmt.setLong(1, idTracceDsAppender);
                                updateStmt.setString(2, ds.getProperty(l).getNome());
                                updateStmt.setString(3, ds.getProperty(l).getValore());
                                updateStmt.executeUpdate();
                                updateStmt.close();
                            }
                        }
                    }
                    if (extInfoConfigurazioneDriver == null) break;
                    extInfoConfigurazioneDriver.deleteAllExtendedInfo(con, log, config);
                    if (config.sizeExtendedInfoList() <= 0) break;
                    for (int l3 = 0; l3 < config.sizeExtendedInfoList(); ++l3) {
                        extInfoConfigurazioneDriver.createExtendedInfo(con, log, config, config.getExtendedInfo(l3));
                    }
                    break;
                }
                case 3: {
                    extInfoConfigurazioneDriver.deleteAllExtendedInfo(con, log, config);
                    ISQLQueryObject sqlQueryObject2 = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                    sqlQueryObject2.addDeleteTable("configurazione");
                    updateQuery = sqlQueryObject2.createSQLDelete();
                    updateStmt = con.prepareStatement(updateQuery);
                    updateStmt.executeUpdate();
                    updateStmt.close();
                }
            }
            if (type == 1) {
                long sqlQueryObject2 = idConfigurazione;
                return sqlQueryObject2;
            }
            sqlQueryObject2 = n;
        }
        catch (SQLException se) {
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB_LIB::CRUDConfigurazioneGenerale] SQLException [" + se.getMessage() + "].", se);
        }
        catch (Exception se) {
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB_LIB::CRUDConfigurazioneGenerale] Exception [" + se.getMessage() + "].", se);
        }
        finally {
            try {
                if (selectRS != null) {
                    selectRS.close();
                }
                if (selectStmt != null) {
                    selectStmt.close();
                }
                if (updateStmt != null) {
                    updateStmt.close();
                }
            }
            catch (Exception e) {}
        }
        return sqlQueryObject2;
    }

    protected static Connettore getConnettore(long idConnettore, Connection connection) throws DriverConfigurazioneException {
        Connettore connettore = null;
        Statement stm = null;
        ResultSet rs = null;
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
            sqlQueryObject.addFromTable("connettori");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("id = ?");
            String sqlQuery = sqlQueryObject.createSQLQuery();
            stm = connection.prepareStatement(sqlQuery);
            stm.setLong(1, idConnettore);
            log.debug((Object)("eseguo query : " + DBUtils.formatSQLString(sqlQuery, idConnettore)));
            rs = stm.executeQuery();
            if (rs.next()) {
                String endpoint = rs.getString("endpointtype");
                if (endpoint == null || endpoint.equals("") || endpoint.equals(TipiConnettore.DISABILITATO.getNome())) {
                    connettore = new Connettore();
                    connettore.setNome(rs.getString("nome_connettore"));
                    connettore.setTipo(TipiConnettore.DISABILITATO.getNome());
                    connettore.setId(idConnettore);
                } else {
                    Property prop = null;
                    connettore = new Connettore();
                    connettore.setNome(rs.getString("nome_connettore"));
                    connettore.setTipo(endpoint);
                    connettore.setId(idConnettore);
                    if (rs.getInt("debug") == 1) {
                        prop = new Property();
                        prop.setNome("debug");
                        prop.setValore("true");
                        connettore.addProperty(prop);
                    }
                    if (endpoint.equals(CostantiDB.CONNETTORE_TIPO_HTTP)) {
                        String value = rs.getString("url");
                        if (value != null) {
                            value = value.trim();
                        }
                        if (value == null || "".equals(value) || " ".equals(value)) {
                            throw new DriverConfigurazioneException("Connettore di tipo http possiede una url non definita");
                        }
                        prop = new Property();
                        prop.setNome("location");
                        prop.setValore(value);
                        connettore.addProperty(prop);
                    } else if (endpoint.equals(TipiConnettore.JMS.getNome())) {
                        String provurl;
                        String urlpkg;
                        String initcont;
                        String pwd;
                        String value = rs.getString("nome");
                        if (value != null) {
                            value = value.trim();
                        }
                        if (value == null || "".equals(value) || " ".equals(value)) {
                            throw new DriverConfigurazioneException("Connettore di tipo jms possiede il nome della coda/topic non definito");
                        }
                        prop = new Property();
                        prop.setNome("location");
                        prop.setValore(value);
                        connettore.addProperty(prop);
                        value = rs.getString("tipo");
                        if (value != null) {
                            value = value.trim();
                        }
                        if (value == null || "".equals(value) || " ".equals(value)) {
                            throw new DriverConfigurazioneException("Connettore di tipo jms possiede il tipo della coda non definito");
                        }
                        prop = new Property();
                        prop.setNome("tipo");
                        prop.setValore(value);
                        connettore.addProperty(prop);
                        value = rs.getString("connection_factory");
                        if (value != null) {
                            value = value.trim();
                        }
                        if (value == null || "".equals(value) || " ".equals(value)) {
                            throw new DriverConfigurazioneException("Connettore di tipo jms non possiede la definizione di una Connection Factory");
                        }
                        prop = new Property();
                        prop.setNome("connection-factory");
                        prop.setValore(value);
                        connettore.addProperty(prop);
                        value = rs.getString("send_as");
                        if (value != null) {
                            value = value.trim();
                        }
                        if (value == null || "".equals(value) || " ".equals(value)) {
                            throw new DriverConfigurazioneException("Connettore di tipo jms possiede il tipo dell'oggetto JMS non definito");
                        }
                        prop = new Property();
                        prop.setNome("send-as");
                        prop.setValore(value);
                        connettore.addProperty(prop);
                        String usr = rs.getString("utente");
                        if (usr != null && !usr.trim().equals("")) {
                            prop = new Property();
                            prop.setNome("user");
                            prop.setValore(usr);
                            connettore.addProperty(prop);
                        }
                        if ((pwd = rs.getString("password")) != null && !pwd.trim().equals("")) {
                            prop = new Property();
                            prop.setNome("password");
                            prop.setValore(pwd);
                            connettore.addProperty(prop);
                        }
                        if ((initcont = rs.getString("initcont")) != null && !initcont.trim().equals("")) {
                            prop = new Property();
                            prop.setNome("context-java.naming.factory.initial");
                            prop.setValore(initcont);
                            connettore.addProperty(prop);
                        }
                        if ((urlpkg = rs.getString("urlpkg")) != null && !urlpkg.trim().equals("")) {
                            prop = new Property();
                            prop.setNome("context-java.naming.factory.url.pkgs");
                            prop.setValore(urlpkg);
                            connettore.addProperty(prop);
                        }
                        if ((provurl = rs.getString("provurl")) != null && !provurl.trim().equals("")) {
                            prop = new Property();
                            prop.setNome("context-java.naming.provider.url");
                            prop.setValore(provurl);
                            connettore.addProperty(prop);
                        }
                    } else if (!(endpoint.equals(TipiConnettore.NULL.getNome()) || endpoint.equals(TipiConnettore.NULLECHO.getNome()) || endpoint.equals(TipiConnettore.DISABILITATO.getNome()))) {
                        if (rs.getLong("custom") == 1L) {
                            DriverConfigurazioneDB_LIB.readPropertiesConnettoreCustom(idConnettore, connettore, connection);
                            connettore.setCustom(true);
                        } else {
                            connettore.setPropertyList(ConnettorePropertiesUtilities.getPropertiesConnettore(endpoint, connection, tipoDB));
                        }
                    }
                }
            }
            DriverConfigurazioneDB_LIB.readPropertiesConnettoreExtendedInfo(idConnettore, connettore, connection);
            Connettore connettore2 = connettore;
            return connettore2;
        }
        catch (SQLException sqle) {
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB_LIB::getConnettore] SQLException : " + sqle.getMessage(), sqle);
        }
        catch (DriverConfigurazioneException e) {
            throw e;
        }
        catch (Exception sqle) {
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB_LIB::getConnettore] Exception : " + sqle.getMessage(), sqle);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception e) {}
        }
    }

    protected static void readPropertiesConnettoreCustom(long idConnettore, Connettore connettore, Connection connection) throws DriverConfigurazioneException {
        Statement stm = null;
        ResultSet rs = null;
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
            sqlQueryObject.addFromTable("connettori_custom");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("id_connettore = ?");
            String sqlQuery = sqlQueryObject.createSQLQuery();
            stm = connection.prepareStatement(sqlQuery);
            stm.setLong(1, idConnettore);
            log.debug((Object)("eseguo query : " + DBUtils.formatSQLString(sqlQuery, idConnettore)));
            rs = stm.executeQuery();
            while (rs.next()) {
                String nome = rs.getString("name");
                String valore = rs.getString("value");
                if ("debug".equals(nome)) {
                    boolean found = false;
                    for (int i = 0; i < connettore.sizePropertyList(); ++i) {
                        if (!"debug".equals(connettore.getProperty(i).getNome())) continue;
                        found = true;
                        break;
                    }
                    if (found) continue;
                }
                Property prop = new Property();
                prop.setNome(nome);
                prop.setValore(valore);
                connettore.addProperty(prop);
            }
            rs.close();
            stm.close();
        }
        catch (SQLException sqle) {
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB_LIB::readPropertiesConnettoreCustom] SQLException : " + sqle.getMessage(), sqle);
        }
        catch (Exception sqle) {
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB_LIB::readPropertiesConnettoreCustom] Exception : " + sqle.getMessage(), sqle);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception e) {}
        }
    }

    protected static void readPropertiesConnettoreExtendedInfo(long idConnettore, Connettore connettore, Connection connection) throws DriverConfigurazioneException {
        Statement stm = null;
        ResultSet rs = null;
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
            sqlQueryObject.addFromTable("connettori_custom");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("id_connettore = ?");
            sqlQueryObject.addWhereLikeCondition("name", "-#ext#-%");
            String sqlQuery = sqlQueryObject.createSQLQuery();
            stm = connection.prepareStatement(sqlQuery);
            stm.setLong(1, idConnettore);
            log.debug((Object)("eseguo query : " + DBUtils.formatSQLString(sqlQuery, idConnettore)));
            rs = stm.executeQuery();
            while (rs.next()) {
                String nome = rs.getString("name");
                String valore = rs.getString("value");
                boolean found = false;
                for (int i = 0; i < connettore.sizePropertyList(); ++i) {
                    if (!nome.equals(connettore.getProperty(i).getNome())) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                Property prop = new Property();
                prop.setNome(nome);
                prop.setValore(valore);
                connettore.addProperty(prop);
            }
            rs.close();
            stm.close();
        }
        catch (SQLException sqle) {
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB_LIB::readPropertiesConnettoreExtendedInfo] SQLException : " + sqle.getMessage(), sqle);
        }
        catch (Exception sqle) {
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB_LIB::readPropertiesConnettoreExtendedInfo] Exception : " + sqle.getMessage(), sqle);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception e) {}
        }
    }

    protected static boolean isConnettoreAbilitato(Connettore connettore) {
        if (connettore == null) {
            return false;
        }
        String tipo = connettore.getTipo();
        return !TipiConnettore.DISABILITATO.getNome().equals(tipo);
    }

    protected static long getIdConnettore_SA_RISP(long idServizioApplicativo, Connection con) throws DriverConfigurazioneException {
        Statement stm = null;
        ResultSet rs = null;
        long idConnettore = -1L;
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
            sqlQueryObject.addFromTable("servizi_applicativi");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("id = ?");
            String query = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(query);
            stm.setLong(1, idServizioApplicativo);
            rs = stm.executeQuery();
            if (rs.next()) {
                idConnettore = rs.getLong("id_connettore_risp");
            }
            long l = idConnettore;
            return l;
        }
        catch (SQLException e) {
            throw new DriverConfigurazioneException(e);
        }
        catch (Exception e) {
            throw new DriverConfigurazioneException(e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception e) {}
        }
    }

    protected static long getIdConnettore_SA_INV(long idServizioApplicativo, Connection con) throws DriverConfigurazioneException {
        Statement stm = null;
        ResultSet rs = null;
        long idConnettore = -1L;
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
            sqlQueryObject.addFromTable("servizi_applicativi");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("id = ?");
            String query = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(query);
            stm.setLong(1, idServizioApplicativo);
            rs = stm.executeQuery();
            if (rs.next()) {
                idConnettore = rs.getLong("id_connettore_inv");
            }
            long l = idConnettore;
            return l;
        }
        catch (SQLException e) {
            throw new DriverConfigurazioneException(e);
        }
        catch (Exception e) {
            throw new DriverConfigurazioneException(e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception e) {}
        }
    }

    public static GestioneErrore getGestioneErrore(long idGestioneErrore, Connection con) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        GestioneErrore gestioneErrore = null;
        Statement stm = null;
        ResultSet rs = null;
        Statement stm1 = null;
        ResultSet rs1 = null;
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
            sqlQueryObject.addFromTable("gestione_errore");
            sqlQueryObject.addSelectField("comportamento_default");
            sqlQueryObject.addSelectField("cadenza_rispedizione");
            sqlQueryObject.addSelectField("nome");
            sqlQueryObject.addWhereCondition("id=?");
            String sqlQuery = sqlQueryObject.createSQLQuery();
            log.debug((Object)("eseguo query: " + DBUtils.formatSQLString(sqlQuery, new Object[0])));
            stm = con.prepareStatement(sqlQuery);
            stm.setLong(1, idGestioneErrore);
            rs = stm.executeQuery();
            if (rs.next()) {
                gestioneErrore = new GestioneErrore();
                gestioneErrore.setId(idGestioneErrore);
                gestioneErrore.setComportamento(GestioneErroreComportamento.toEnumConstant(rs.getString("comportamento_default")));
                gestioneErrore.setCadenzaRispedizione(rs.getString("cadenza_rispedizione"));
                gestioneErrore.setNome(rs.getString("nome"));
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                sqlQueryObject.addFromTable("gestione_errore_trasporto");
                sqlQueryObject.addSelectField("*");
                sqlQueryObject.addWhereCondition("id_gestione_errore = ?");
                sqlQuery = sqlQueryObject.createSQLQuery();
                stm1 = con.prepareStatement(sqlQuery);
                stm1.setLong(1, gestioneErrore.getId());
                rs1 = stm1.executeQuery();
                while (rs1.next()) {
                    GestioneErroreCodiceTrasporto trasporto = new GestioneErroreCodiceTrasporto();
                    trasporto.setComportamento(GestioneErroreComportamento.toEnumConstant(rs1.getString("comportamento")));
                    trasporto.setCadenzaRispedizione(rs1.getString("cadenza_rispedizione"));
                    if (rs1.getLong("valore_massimo") > 0L) {
                        String maxVal = "" + rs1.getLong("valore_massimo");
                        trasporto.setValoreMassimo(!maxVal.equals("") ? new Integer(maxVal) : null);
                    }
                    if (rs1.getLong("valore_minimo") > 0L) {
                        String minVal = "" + rs1.getLong("valore_minimo");
                        trasporto.setValoreMinimo(!minVal.equals("") ? new Integer(minVal) : null);
                    }
                    gestioneErrore.addCodiceTrasporto(trasporto);
                }
                rs1.close();
                stm1.close();
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                sqlQueryObject.addFromTable("gestione_errore_soap");
                sqlQueryObject.addSelectField("*");
                sqlQueryObject.addWhereCondition("id_gestione_errore = ?");
                sqlQuery = sqlQueryObject.createSQLQuery();
                stm1 = con.prepareStatement(sqlQuery);
                stm1.setLong(1, gestioneErrore.getId());
                rs1 = stm1.executeQuery();
                while (rs1.next()) {
                    GestioneErroreSoapFault soap = new GestioneErroreSoapFault();
                    soap.setComportamento(GestioneErroreComportamento.toEnumConstant(rs1.getString("comportamento")));
                    soap.setCadenzaRispedizione(rs1.getString("cadenza_rispedizione"));
                    soap.setFaultActor(rs1.getString("fault_actor"));
                    soap.setFaultCode(rs1.getString("fault_code"));
                    soap.setFaultString(rs1.getString("fault_string"));
                    gestioneErrore.addSoapFault(soap);
                }
            } else {
                throw new DriverConfigurazioneNotFound("Gestione errore con id[" + idGestioneErrore + "] non presente");
            }
            rs1.close();
            stm1.close();
            rs.close();
            stm.close();
            GestioneErrore gestioneErrore2 = gestioneErrore;
            return gestioneErrore2;
        }
        catch (SQLException se) {
            throw new DriverConfigurazioneException(" SqlException: " + se.getMessage(), se);
        }
        catch (DriverConfigurazioneNotFound e) {
            throw new DriverConfigurazioneNotFound(e);
        }
        catch (Exception se) {
            throw new DriverConfigurazioneException(" Exception: " + se.getMessage(), se);
        }
        finally {
            try {
                if (rs1 != null) {
                    rs1.close();
                }
                if (stm1 != null) {
                    stm1.close();
                }
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception e) {}
        }
    }

    public static long getIdGestioneErrore(String nomeGestioneErrore, Connection con) throws DriverConfigurazioneException {
        Statement stm = null;
        ResultSet rs = null;
        long idGestioneErrore = -1L;
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
            sqlQueryObject.addFromTable("gestione_errore");
            sqlQueryObject.addSelectField("id");
            sqlQueryObject.addWhereCondition("nome = ?");
            String query = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(query);
            stm.setString(1, nomeGestioneErrore);
            rs = stm.executeQuery();
            if (rs.next()) {
                idGestioneErrore = rs.getLong("id");
            }
            long l = idGestioneErrore;
            return l;
        }
        catch (SQLException e) {
            throw new DriverConfigurazioneException(e);
        }
        catch (Exception e) {
            throw new DriverConfigurazioneException(e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception e) {}
        }
    }

    public static long CRUDGestioneErroreServizioApplicativo(int type, GestioneErrore gestioneErrore, long idSoggettoProprietario, long idServizioApplicativo, boolean invocazioneServizio, Connection con) throws DriverConfigurazioneException {
        if (invocazioneServizio) {
            return DriverConfigurazioneDB_LIB.CRUDGestioneErrore(type, gestioneErrore, idSoggettoProprietario, idServizioApplicativo, 1, con);
        }
        return DriverConfigurazioneDB_LIB.CRUDGestioneErrore(type, gestioneErrore, idSoggettoProprietario, idServizioApplicativo, 2, con);
    }

    public static long CRUDGestioneErroreComponenteCooperazione(int type, GestioneErrore gestioneErrore, Connection con) throws DriverConfigurazioneException {
        return DriverConfigurazioneDB_LIB.CRUDGestioneErrore(type, gestioneErrore, -1L, -1L, 3, con);
    }

    public static long CRUDGestioneErroreComponenteIntegrazione(int type, GestioneErrore gestioneErrore, Connection con) throws DriverConfigurazioneException {
        return DriverConfigurazioneDB_LIB.CRUDGestioneErrore(type, gestioneErrore, -1L, -1L, 4, con);
    }

    private static long CRUDGestioneErrore(int type, GestioneErrore gestioneErrore, long idSoggettoProprietario, long idServizioApplicativo, int tipoCRUD, Connection con) throws DriverConfigurazioneException {
        if (gestioneErrore == null) {
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB_LIB::CRUDGestioneErrore] Parametro non valido.");
        }
        String nomeGestioneErrore = null;
        if (tipoCRUD == 1 || tipoCRUD == 2) {
            if (idSoggettoProprietario <= 0L) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB_LIB::CRUDGestioneErrore] Soggetto proprietario non fornito.");
            }
            if (idServizioApplicativo <= 0L) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB_LIB::CRUDGestioneErrore] Servizio applicativo non fornito.");
            }
            nomeGestioneErrore = "Soggetto(" + idSoggettoProprietario + ")_SA(" + idServizioApplicativo + ")_";
            nomeGestioneErrore = tipoCRUD == 1 ? nomeGestioneErrore + "INV" : nomeGestioneErrore + "RISP";
        } else if (tipoCRUD == 3) {
            nomeGestioneErrore = "componenteCooperazioneGestioneErroreDefaultPdD";
        } else if (tipoCRUD == 4) {
            nomeGestioneErrore = "componenteIntegrazioneGestioneErroreDefaultPdD";
        }
        gestioneErrore.setNome(nomeGestioneErrore);
        int tipoOperazione = type;
        long idGestioneErroreChange = -1L;
        if (type == 2) {
            try {
                idGestioneErroreChange = DriverConfigurazioneDB_LIB.getIdGestioneErrore(nomeGestioneErrore, con);
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException(e.getMessage(), e);
            }
            if (idGestioneErroreChange <= 0L) {
                tipoOperazione = 1;
            }
        }
        Statement updateStmt = null;
        Statement selectStmt = null;
        String updateQuery = "";
        String selectQuery = "";
        ResultSet selectRS = null;
        int n = 0;
        try {
            switch (tipoOperazione) {
                case 1: {
                    int i;
                    ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                    sqlQueryObject.addInsertTable("gestione_errore");
                    sqlQueryObject.addInsertField("comportamento_default", "?");
                    sqlQueryObject.addInsertField("cadenza_rispedizione", "?");
                    sqlQueryObject.addInsertField("nome", "?");
                    updateQuery = sqlQueryObject.createSQLInsert();
                    updateStmt = con.prepareStatement(updateQuery);
                    updateStmt.setString(1, DriverConfigurazioneDB_LIB.getValue(gestioneErrore.getComportamento()));
                    updateStmt.setString(2, gestioneErrore.getCadenzaRispedizione());
                    updateStmt.setString(3, gestioneErrore.getNome());
                    n = updateStmt.executeUpdate();
                    updateStmt.close();
                    log.debug((Object)("CRUDGestioneErrore CREATE : \n" + DBUtils.formatSQLString(updateQuery, gestioneErrore.getComportamento(), gestioneErrore.getCadenzaRispedizione(), gestioneErrore.getNome())));
                    log.debug((Object)("CRUDGestioneErrore type = " + type + " row affected =" + n));
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                    sqlQueryObject.addFromTable("gestione_errore");
                    sqlQueryObject.addSelectField("id");
                    sqlQueryObject.addWhereCondition("nome = ?");
                    selectQuery = sqlQueryObject.createSQLQuery();
                    selectStmt = con.prepareStatement(selectQuery);
                    selectStmt.setString(1, gestioneErrore.getNome());
                    selectRS = selectStmt.executeQuery();
                    if (!selectRS.next()) {
                        throw new Exception("id gestione errore non trovato dopo inserimento con nome [" + gestioneErrore.getNome() + "]");
                    }
                    gestioneErrore.setId(selectRS.getLong("id"));
                    selectRS.close();
                    selectStmt.close();
                    for (i = 0; i < gestioneErrore.sizeCodiceTrasportoList(); ++i) {
                        GestioneErroreCodiceTrasporto tr = gestioneErrore.getCodiceTrasporto(i);
                        int valoreMassimo = -1;
                        int valoreMinimo = -1;
                        if (tr.getValoreMassimo() != null) {
                            valoreMassimo = tr.getValoreMassimo();
                        }
                        if (tr.getValoreMinimo() != null) {
                            valoreMinimo = tr.getValoreMinimo();
                        }
                        sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                        sqlQueryObject.addInsertTable("gestione_errore_trasporto");
                        sqlQueryObject.addInsertField("id_gestione_errore", "?");
                        if (valoreMassimo >= 0) {
                            sqlQueryObject.addInsertField("valore_massimo", "?");
                        }
                        if (valoreMinimo >= 0) {
                            sqlQueryObject.addInsertField("valore_minimo", "?");
                        }
                        sqlQueryObject.addInsertField("comportamento", "?");
                        sqlQueryObject.addInsertField("cadenza_rispedizione", "?");
                        updateQuery = sqlQueryObject.createSQLInsert();
                        updateStmt = con.prepareStatement(updateQuery);
                        int index = 1;
                        updateStmt.setLong(index, gestioneErrore.getId());
                        ++index;
                        if (valoreMassimo >= 0) {
                            updateStmt.setInt(index, valoreMassimo);
                            ++index;
                        }
                        if (valoreMinimo >= 0) {
                            updateStmt.setInt(index, valoreMinimo);
                            ++index;
                        }
                        updateStmt.setString(index, DriverConfigurazioneDB_LIB.getValue(tr.getComportamento()));
                        updateStmt.setString(++index, tr.getCadenzaRispedizione());
                        ++index;
                        n = updateStmt.executeUpdate();
                        updateStmt.close();
                        if (valoreMassimo >= 0 && valoreMinimo >= 0) {
                            log.debug((Object)("CRUDGestioneErrore_Trasporto(" + i + ") CREATE : \n" + DBUtils.formatSQLString(updateQuery, gestioneErrore.getId(), valoreMassimo, valoreMinimo, tr.getComportamento(), tr.getCadenzaRispedizione())));
                        } else if (valoreMassimo >= 0) {
                            log.debug((Object)("CRUDGestioneErrore_Trasporto(" + i + ") CREATE : \n" + DBUtils.formatSQLString(updateQuery, gestioneErrore.getId(), valoreMassimo, tr.getComportamento(), tr.getCadenzaRispedizione())));
                        } else if (valoreMinimo >= 0) {
                            log.debug((Object)("CRUDGestioneErrore_Trasporto(" + i + ") CREATE : \n" + DBUtils.formatSQLString(updateQuery, gestioneErrore.getId(), valoreMinimo, tr.getComportamento(), tr.getCadenzaRispedizione())));
                        } else {
                            log.debug((Object)("CRUDGestioneErrore_Trasporto(" + i + ") CREATE : \n" + DBUtils.formatSQLString(updateQuery, gestioneErrore.getId(), tr.getComportamento(), tr.getCadenzaRispedizione())));
                        }
                        log.debug((Object)("CRUDGestioneErrore_Trasporto(" + i + ") type = " + type + " row affected =" + n));
                    }
                    for (i = 0; i < gestioneErrore.sizeSoapFaultList(); ++i) {
                        GestioneErroreSoapFault sf = gestioneErrore.getSoapFault(i);
                        sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                        sqlQueryObject.addInsertTable("gestione_errore_soap");
                        sqlQueryObject.addInsertField("id_gestione_errore", "?");
                        sqlQueryObject.addInsertField("fault_actor", "?");
                        sqlQueryObject.addInsertField("fault_code", "?");
                        sqlQueryObject.addInsertField("fault_string", "?");
                        sqlQueryObject.addInsertField("comportamento", "?");
                        sqlQueryObject.addInsertField("cadenza_rispedizione", "?");
                        updateQuery = sqlQueryObject.createSQLInsert();
                        updateStmt = con.prepareStatement(updateQuery);
                        updateStmt.setLong(1, gestioneErrore.getId());
                        updateStmt.setString(2, sf.getFaultActor());
                        updateStmt.setString(3, sf.getFaultCode());
                        updateStmt.setString(4, sf.getFaultString());
                        updateStmt.setString(5, DriverConfigurazioneDB_LIB.getValue(sf.getComportamento()));
                        updateStmt.setString(6, sf.getCadenzaRispedizione());
                        n = updateStmt.executeUpdate();
                        updateStmt.close();
                        log.debug((Object)("CRUDGestioneErrore_SoapFault(" + i + ") CREATE : \n" + DBUtils.formatSQLString(updateQuery, gestioneErrore.getId(), sf.getFaultActor(), sf.getFaultCode(), sf.getFaultString(), sf.getComportamento(), sf.getCadenzaRispedizione())));
                        log.debug((Object)("CRUDGestioneErrore_SoapFault(" + i + ") type = " + type + " row affected =" + n));
                    }
                    break;
                }
                case 2: {
                    int i;
                    gestioneErrore.setId(idGestioneErroreChange);
                    ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                    sqlQueryObject.addUpdateTable("gestione_errore");
                    sqlQueryObject.addUpdateField("comportamento_default", "?");
                    sqlQueryObject.addUpdateField("cadenza_rispedizione", "?");
                    sqlQueryObject.addWhereCondition("id=?");
                    sqlQueryObject.setANDLogicOperator(true);
                    updateQuery = sqlQueryObject.createSQLUpdate();
                    updateStmt = con.prepareStatement(updateQuery);
                    updateStmt.setString(1, DriverConfigurazioneDB_LIB.getValue(gestioneErrore.getComportamento()));
                    updateStmt.setString(2, gestioneErrore.getCadenzaRispedizione());
                    updateStmt.setLong(3, idGestioneErroreChange);
                    n = updateStmt.executeUpdate();
                    updateStmt.close();
                    log.debug((Object)("CRUDGestioneErrore UPDATE : \n" + DBUtils.formatSQLString(updateQuery, gestioneErrore.getComportamento(), gestioneErrore.getCadenzaRispedizione(), idGestioneErroreChange)));
                    log.debug((Object)("CRUGestioneErrore type = " + type + " row affected =" + n));
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                    sqlQueryObject.addDeleteTable("gestione_errore_trasporto");
                    sqlQueryObject.addWhereCondition("id_gestione_errore=?");
                    updateQuery = sqlQueryObject.createSQLDelete();
                    updateStmt = con.prepareStatement(updateQuery);
                    updateStmt.setLong(1, idGestioneErroreChange);
                    n = updateStmt.executeUpdate();
                    updateStmt.close();
                    log.debug((Object)("CRUDGestioneErrore (Delete old trasporto) UPDATE : \n" + DBUtils.formatSQLString(updateQuery, idGestioneErroreChange)));
                    log.debug((Object)("CRUGestioneErrore (Delete old trasporto) type = " + type + " row affected =" + n));
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                    sqlQueryObject.addDeleteTable("gestione_errore_soap");
                    sqlQueryObject.addWhereCondition("id_gestione_errore=?");
                    updateQuery = sqlQueryObject.createSQLDelete();
                    updateStmt = con.prepareStatement(updateQuery);
                    updateStmt.setLong(1, idGestioneErroreChange);
                    n = updateStmt.executeUpdate();
                    updateStmt.close();
                    log.debug((Object)("CRUDGestioneErrore (Delete old soap fault) UPDATE : \n" + DBUtils.formatSQLString(updateQuery, idGestioneErroreChange)));
                    log.debug((Object)("CRUGestioneErrore (Delete old soap fault) type = " + type + " row affected =" + n));
                    for (i = 0; i < gestioneErrore.sizeCodiceTrasportoList(); ++i) {
                        GestioneErroreCodiceTrasporto tr = gestioneErrore.getCodiceTrasporto(i);
                        int valoreMassimo = -1;
                        int valoreMinimo = -1;
                        if (tr.getValoreMassimo() != null) {
                            valoreMassimo = tr.getValoreMassimo();
                        }
                        if (tr.getValoreMinimo() != null) {
                            valoreMinimo = tr.getValoreMinimo();
                        }
                        sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                        sqlQueryObject.addInsertTable("gestione_errore_trasporto");
                        sqlQueryObject.addInsertField("id_gestione_errore", "?");
                        if (valoreMassimo >= 0) {
                            sqlQueryObject.addInsertField("valore_massimo", "?");
                        }
                        if (valoreMinimo >= 0) {
                            sqlQueryObject.addInsertField("valore_minimo", "?");
                        }
                        sqlQueryObject.addInsertField("comportamento", "?");
                        sqlQueryObject.addInsertField("cadenza_rispedizione", "?");
                        updateQuery = sqlQueryObject.createSQLInsert();
                        updateStmt = con.prepareStatement(updateQuery);
                        int index = 1;
                        updateStmt.setLong(index, gestioneErrore.getId());
                        ++index;
                        if (valoreMassimo >= 0) {
                            updateStmt.setInt(index, valoreMassimo);
                            ++index;
                        }
                        if (valoreMinimo >= 0) {
                            updateStmt.setInt(index, valoreMinimo);
                            ++index;
                        }
                        updateStmt.setString(index, DriverConfigurazioneDB_LIB.getValue(tr.getComportamento()));
                        updateStmt.setString(++index, tr.getCadenzaRispedizione());
                        ++index;
                        n = updateStmt.executeUpdate();
                        updateStmt.close();
                        if (valoreMassimo >= 0 && valoreMinimo >= 0) {
                            log.debug((Object)("CRUDGestioneErrore_Trasporto(" + i + ") CREATE : \n" + DBUtils.formatSQLString(updateQuery, gestioneErrore.getId(), valoreMassimo, valoreMinimo, tr.getComportamento(), tr.getCadenzaRispedizione())));
                        } else if (valoreMassimo >= 0) {
                            log.debug((Object)("CRUDGestioneErrore_Trasporto(" + i + ") CREATE : \n" + DBUtils.formatSQLString(updateQuery, gestioneErrore.getId(), valoreMassimo, tr.getComportamento(), tr.getCadenzaRispedizione())));
                        } else if (valoreMinimo >= 0) {
                            log.debug((Object)("CRUDGestioneErrore_Trasporto(" + i + ") CREATE : \n" + DBUtils.formatSQLString(updateQuery, gestioneErrore.getId(), valoreMinimo, tr.getComportamento(), tr.getCadenzaRispedizione())));
                        } else {
                            log.debug((Object)("CRUDGestioneErrore_Trasporto(" + i + ") CREATE : \n" + DBUtils.formatSQLString(updateQuery, gestioneErrore.getId(), tr.getComportamento(), tr.getCadenzaRispedizione())));
                        }
                        log.debug((Object)("CRUDGestioneErrore_Trasporto(" + i + ") type = " + type + " row affected =" + n));
                    }
                    for (i = 0; i < gestioneErrore.sizeSoapFaultList(); ++i) {
                        GestioneErroreSoapFault sf = gestioneErrore.getSoapFault(i);
                        sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                        sqlQueryObject.addInsertTable("gestione_errore_soap");
                        sqlQueryObject.addInsertField("id_gestione_errore", "?");
                        sqlQueryObject.addInsertField("fault_actor", "?");
                        sqlQueryObject.addInsertField("fault_code", "?");
                        sqlQueryObject.addInsertField("fault_string", "?");
                        sqlQueryObject.addInsertField("comportamento", "?");
                        sqlQueryObject.addInsertField("cadenza_rispedizione", "?");
                        updateQuery = sqlQueryObject.createSQLInsert();
                        updateStmt = con.prepareStatement(updateQuery);
                        updateStmt.setLong(1, gestioneErrore.getId());
                        updateStmt.setString(2, sf.getFaultActor());
                        updateStmt.setString(3, sf.getFaultCode());
                        updateStmt.setString(4, sf.getFaultString());
                        updateStmt.setString(5, DriverConfigurazioneDB_LIB.getValue(sf.getComportamento()));
                        updateStmt.setString(6, sf.getCadenzaRispedizione());
                        n = updateStmt.executeUpdate();
                        updateStmt.close();
                        log.debug((Object)("CRUDGestioneErrore_SoapFault(" + i + ") CREATE : \n" + DBUtils.formatSQLString(updateQuery, gestioneErrore.getId(), sf.getFaultActor(), sf.getFaultCode(), sf.getFaultString(), sf.getComportamento(), sf.getCadenzaRispedizione())));
                        log.debug((Object)("CRUDGestioneErrore_SoapFault(" + i + ") type = " + type + " row affected =" + n));
                    }
                    break;
                }
                case 3: {
                    long idGestioneErrore = DriverConfigurazioneDB_LIB.getIdGestioneErrore(nomeGestioneErrore, con);
                    gestioneErrore.setId(idGestioneErrore);
                    if (idGestioneErrore <= 0L) break;
                    ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                    sqlQueryObject.addDeleteTable("gestione_errore_trasporto");
                    sqlQueryObject.addWhereCondition("id_gestione_errore=?");
                    updateQuery = sqlQueryObject.createSQLDelete();
                    updateStmt = con.prepareStatement(updateQuery);
                    updateStmt.setLong(1, idGestioneErrore);
                    n = updateStmt.executeUpdate();
                    updateStmt.close();
                    log.debug((Object)("CRUDGestioneErrore (Delete trasporto) UPDATE : \n" + DBUtils.formatSQLString(updateQuery, idGestioneErrore)));
                    log.debug((Object)("CRUGestioneErrore (Delete trasporto) type = " + type + " row affected =" + n));
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                    sqlQueryObject.addDeleteTable("gestione_errore_soap");
                    sqlQueryObject.addWhereCondition("id_gestione_errore=?");
                    updateQuery = sqlQueryObject.createSQLDelete();
                    updateStmt = con.prepareStatement(updateQuery);
                    updateStmt.setLong(1, idGestioneErrore);
                    n = updateStmt.executeUpdate();
                    updateStmt.close();
                    log.debug((Object)("CRUDGestioneErrore (Delete soap fault) UPDATE : \n" + DBUtils.formatSQLString(updateQuery, idGestioneErrore)));
                    log.debug((Object)("CRUGestioneErrore (Delete soap fault) type = " + type + " row affected =" + n));
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                    sqlQueryObject.addDeleteTable("gestione_errore");
                    sqlQueryObject.addWhereCondition("id=?");
                    updateQuery = sqlQueryObject.createSQLDelete();
                    updateStmt = con.prepareStatement(updateQuery);
                    updateStmt.setLong(1, idGestioneErrore);
                    n = updateStmt.executeUpdate();
                    updateStmt.close();
                    log.debug((Object)("CRUDGestioneErrore type = " + type + " row affected =" + n));
                    log.debug((Object)("CRUDGestioneErrore DELETE : \n" + DBUtils.formatSQLString(updateQuery, idGestioneErrore)));
                }
            }
            long sqlQueryObject = n;
            return sqlQueryObject;
        }
        catch (SQLException se) {
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB_LIB::CRUDGestioneErrore] SQLException [" + se.getMessage() + "].", se);
        }
        catch (Exception se) {
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB_LIB::CRUDGestioneErrore] Exception [" + se.getMessage() + "].", se);
        }
        finally {
            try {
                if (selectRS != null) {
                    selectRS.close();
                }
                if (selectStmt != null) {
                    selectStmt.close();
                }
                if (updateStmt != null) {
                    updateStmt.close();
                }
            }
            catch (Exception e) {}
        }
    }

    public static long getIdServizioApplicativo(String nomeServizioApplicativo, String tipoProprietario, String nomeProprietario, Connection con, String tipoDB) throws CoreException {
        return DriverConfigurazioneDB_LIB.getIdServizioApplicativo(nomeServizioApplicativo, tipoProprietario, nomeProprietario, con, tipoDB, "soggetti");
    }

    public static long getIdServizioApplicativo(String nomeServizioApplicativo, String tipoProprietario, String nomeProprietario, Connection con, String tipoDB, String tabellaSoggetti) throws CoreException {
        Statement stm = null;
        ResultSet rs = null;
        long idServizioApplicativo = -1L;
        try {
            long idSoggetto = DBUtils.getIdSoggetto(nomeProprietario, tipoProprietario, con, tipoDB, tabellaSoggetti);
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
            sqlQueryObject.addFromTable("servizi_applicativi");
            sqlQueryObject.addSelectField("id");
            sqlQueryObject.addWhereCondition("id_soggetto = ?");
            sqlQueryObject.addWhereCondition("nome = ?");
            sqlQueryObject.setANDLogicOperator(true);
            String sqlQuery = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(sqlQuery);
            stm.setLong(1, idSoggetto);
            stm.setString(2, nomeServizioApplicativo);
            rs = stm.executeQuery();
            if (rs.next()) {
                idServizioApplicativo = rs.getLong("id");
            }
            long l = idServizioApplicativo;
            return l;
        }
        catch (SQLException e) {
            throw new CoreException(e);
        }
        catch (Exception e) {
            throw new CoreException(e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception e) {}
        }
    }

    public static long getIdPortaApplicativa(String nomePorta, String tipoProprietario, String nomeProprietario, Connection con, String tipoDB) throws CoreException {
        return DBUtils.getIdPortaApplicativa(nomePorta, tipoProprietario, nomeProprietario, con, tipoDB, "soggetti");
    }

    public static long getIdPortaApplicativa(String nomePorta, String tipoProprietario, String nomeProprietario, Connection con, String tipoDB, String tabellaSoggetti) throws CoreException {
        Statement stm = null;
        ResultSet rs = null;
        long idPortaApplicativa = -1L;
        try {
            long idSoggetto = DBUtils.getIdSoggetto(nomeProprietario, tipoProprietario, con, tipoDB, tabellaSoggetti);
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
            sqlQueryObject.addFromTable("porte_applicative");
            sqlQueryObject.addSelectField("id");
            sqlQueryObject.addWhereCondition("id_soggetto = ?");
            sqlQueryObject.addWhereCondition("nome_porta = ?");
            sqlQueryObject.setANDLogicOperator(true);
            String sqlQuery = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(sqlQuery);
            stm.setLong(1, idSoggetto);
            stm.setString(2, nomePorta);
            rs = stm.executeQuery();
            if (rs.next()) {
                idPortaApplicativa = rs.getLong("id");
            }
            long l = idPortaApplicativa;
            return l;
        }
        catch (SQLException e) {
            throw new CoreException(e);
        }
        catch (Exception e) {
            throw new CoreException(e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception e) {}
        }
    }

    public static long getIdPortaDelegata(String nomePorta, String tipoProprietario, String nomeProprietario, Connection con, String tipoDB) throws CoreException {
        return DriverConfigurazioneDB_LIB.getIdPortaDelegata(nomePorta, tipoProprietario, nomeProprietario, con, tipoDB, "soggetti");
    }

    public static long getIdPortaDelegata(String nomePorta, String tipoProprietario, String nomeProprietario, Connection con, String tipoDB, String tabellaSoggetti) throws CoreException {
        Statement stm = null;
        ResultSet rs = null;
        long idPortaDelegata = -1L;
        try {
            long idSoggetto = DBUtils.getIdSoggetto(nomeProprietario, tipoProprietario, con, tipoDB, tabellaSoggetti);
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
            sqlQueryObject.addFromTable("porte_delegate");
            sqlQueryObject.addSelectField("id");
            sqlQueryObject.addWhereCondition("id_soggetto = ?");
            sqlQueryObject.addWhereCondition("nome_porta = ?");
            sqlQueryObject.setANDLogicOperator(true);
            String sqlQuery = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(sqlQuery);
            stm.setLong(1, idSoggetto);
            stm.setString(2, nomePorta);
            rs = stm.executeQuery();
            if (rs.next()) {
                idPortaDelegata = rs.getLong("id");
            }
            long l = idPortaDelegata;
            return l;
        }
        catch (SQLException e) {
            throw new CoreException(e);
        }
        catch (Exception e) {
            throw new CoreException(e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception e) {}
        }
    }
}

