/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.security.message.utils;

import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import org.openspcoop2.security.message.utils.AttachmentProcessingPart;
import org.openspcoop2.security.message.utils.ElementProcessingPart;
import org.openspcoop2.security.message.utils.ProcessingPart;

public class ProcessingPartUtils {
    private String processingPartsConstant;
    private String processingPartsElementConstant;
    private String processingPartsContentConstant;
    private String processingPartsNamespaceAttachConstant;
    private String processingPartsCompleteConstant;

    public ProcessingPartUtils(String processingPartsConstant, String processingPartsElementConstant, String processingPartsContentConstant, String processingPartsNamespaceAttachConstant, String processingPartsCompleteConstant) {
        this.processingPartsConstant = processingPartsConstant;
        this.processingPartsElementConstant = processingPartsElementConstant;
        this.processingPartsContentConstant = processingPartsContentConstant;
        this.processingPartsNamespaceAttachConstant = processingPartsNamespaceAttachConstant;
        this.processingPartsCompleteConstant = processingPartsCompleteConstant;
    }

    public List<ProcessingPart<?, ?>> getProcessingParts(String processingPartString) throws Exception {
        ArrayList lst = new ArrayList();
        String[] split = processingPartString.split(";");
        for (int i = 0; i < split.length; ++i) {
            String[] split2 = split[i].trim().split("}");
            String tipo = split2[0].trim().substring(1);
            if ("".equals(tipo)) {
                tipo = "Content";
            }
            if (!this.processingPartsContentConstant.equals(tipo) && !this.processingPartsElementConstant.equals(tipo)) {
                throw new Exception(this.processingPartsConstant + "[" + i + "] possiede un tipo non supportato (supportati:" + this.processingPartsContentConstant + "," + this.processingPartsElementConstant + "): " + tipo);
            }
            if (split2.length == 3) {
                String namespace = split2[1].trim().substring(1);
                if (this.processingPartsNamespaceAttachConstant.equals(namespace)) {
                    String indice = split2[2].trim().substring(1);
                    lst.add(this.getAttachmentProcessingPart(tipo, indice, i));
                    continue;
                }
                String nome = split2[2].trim();
                lst.add(this.getProcessingPart(tipo, namespace, nome));
                continue;
            }
            if ("cid:Attachments".equalsIgnoreCase(split2[1].trim())) {
                lst.add(this.getAttachmentProcessingPart(tipo, "*", i));
                continue;
            }
            throw new Exception("Part [" + split[i] + "] with wrong format");
        }
        return lst;
    }

    private ElementProcessingPart getProcessingPart(String tipo, String namespace, String nome) throws Exception {
        QName elemento = new QName(namespace, nome);
        return new ElementProcessingPart(elemento, this.processingPartsContentConstant.equals(tipo));
    }

    private AttachmentProcessingPart getAttachmentProcessingPart(String tipo, String indice, int indexPart) throws Exception {
        boolean complete = this.processingPartsCompleteConstant.equals(tipo);
        if ("*".equals(indice) || "".equals(indice)) {
            return new AttachmentProcessingPart(complete);
        }
        int indexAllegato = -1;
        try {
            indexAllegato = Integer.parseInt(indice);
            return new AttachmentProcessingPart(indexAllegato, complete);
        }
        catch (NumberFormatException e) {
            throw new Exception("Property " + this.processingPartsConstant + "[" + indexPart + "] (Attach) con un indice [" + indice + "] che non risulta essere ne un numero intero ne un carattere speciale", e);
        }
    }

    public static ProcessingPartUtils getSignatureInstance() {
        return new ProcessingPartUtils("signatureParts", "Element", "Content", "Attach", "Complete");
    }

    public static ProcessingPartUtils getEncryptionInstance() {
        return new ProcessingPartUtils("encryptionParts", "Element", "Content", "Attach", "Complete");
    }
}

