/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.security.message.jose;

import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.openspcoop2.core.mvc.properties.provider.InputValidationUtils;
import org.openspcoop2.core.mvc.properties.provider.ProviderException;
import org.openspcoop2.core.mvc.properties.provider.ProviderValidationException;
import org.openspcoop2.core.mvc.properties.utils.MultiPropertiesUtilities;
import org.openspcoop2.security.message.jose.TrustStoreSecurityProvider;

public class EncryptSenderProvider
extends TrustStoreSecurityProvider {
    @Override
    public void validate(Map<String, Properties> mapProperties) throws ProviderException, ProviderValidationException {
        String file;
        super.validate(mapProperties);
        Properties defaultP = MultiPropertiesUtilities.getDefaultProperties(mapProperties);
        Properties p = mapProperties.get("encryptionPropRefId");
        if (p != null && p.size() > 0 && !p.containsKey("rs.security.keystore") && !p.containsKey("rs.security.keystore.jwkset") && (file = p.getProperty("rs.security.keystore.file")) != null && StringUtils.isNotEmpty((String)file)) {
            InputValidationUtils.validateTextAreaInput((String)file, (String)"Encryption - KeyStore - File");
        }
        if ((file = defaultP.getProperty("joseX509Url")) != null && StringUtils.isNotEmpty((String)file)) {
            InputValidationUtils.validateTextAreaInput((String)file, (String)"Encryption - X.509 Certificate - URL");
        }
        if ((file = defaultP.getProperty("joseJWKSetUrl")) != null && StringUtils.isNotEmpty((String)file)) {
            InputValidationUtils.validateTextAreaInput((String)file, (String)"Encryption - Public Key - URL");
        }
        if ((file = defaultP.getProperty("joseCriticalHeaders")) != null && StringUtils.isNotEmpty((String)file)) {
            InputValidationUtils.validateTextAreaInput((String)file, (String)"Encryption - Type (typ) - Critical Headers (crit)");
        }
    }
}

