/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.security.message.engine;

import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPHeaderElement;
import org.openspcoop2.message.OpenSPCoop2Message;
import org.openspcoop2.message.constants.ServiceBinding;
import org.openspcoop2.message.soap.reference.Reference;
import org.openspcoop2.protocol.sdk.Busta;
import org.openspcoop2.protocol.sdk.constants.CodiceErroreCooperazione;
import org.openspcoop2.security.SecurityException;
import org.openspcoop2.security.message.IMessageSecurityReceiver;
import org.openspcoop2.security.message.MessageSecurityContext;
import org.openspcoop2.security.message.MessageSecurityUtilities;
import org.openspcoop2.security.message.SubErrorCodeSecurity;
import org.openspcoop2.security.message.authorization.IMessageSecurityAuthorization;
import org.openspcoop2.security.message.authorization.MessageSecurityAuthorizationRequest;
import org.openspcoop2.security.message.authorization.MessageSecurityAuthorizationResult;
import org.openspcoop2.security.message.constants.SecurityConstants;
import org.openspcoop2.security.message.engine.MessageSecurityReceiver;
import org.openspcoop2.utils.Map;
import org.openspcoop2.utils.resources.Loader;

public class MessageSecurityReceiver_impl
extends MessageSecurityReceiver {
    protected MessageSecurityReceiver_impl(MessageSecurityContext messageSecurityContext) {
        super(messageSecurityContext);
    }

    @Override
    protected boolean process(OpenSPCoop2Message message, Busta busta, Map<Object> ctx) {
        try {
            IMessageSecurityReceiver receiverInterface = this.messageSecurityContext.getMessageSecurityReceiver();
            if (ServiceBinding.SOAP.equals((Object)message.getServiceBinding()) ? (message.isFault() || message.castAsSoap().getSOAPBody().hasFault()) && !MessageSecurityUtilities.processSOAPFault(this.messageSecurityContext.getIncomingProperties()) : ServiceBinding.REST.equals((Object)message.getServiceBinding()) && (message.isFault() || message.castAsRest().isProblemDetailsForHttpApis_RFC7807()) && !MessageSecurityUtilities.processProblemDetails(this.messageSecurityContext.getIncomingProperties())) {
                return true;
            }
            String action = (String)this.messageSecurityContext.getIncomingProperties().get("action");
            if (action == null || "".equals(action.trim())) {
                return true;
            }
            String authClass = (String)this.messageSecurityContext.getIncomingProperties().get("authorizationClass");
            String actor = this.messageSecurityContext.getActor();
            if ("".equals(this.messageSecurityContext.getActor())) {
                actor = null;
            }
            if (receiverInterface.checkExistsWSSecurityHeader()) {
                String samlVersion;
                if (!this.messageSecurityContext.existsSecurityHeader(message, actor)) {
                    this.msgErrore = "Header Message Security, richiesto dalla configurazione (action:" + action + "), non riscontrato nella SOAPEnvelope ricevuta";
                    this.codiceErrore = action.contains("Signature") ? CodiceErroreCooperazione.SICUREZZA_FIRMA_NON_PRESENTE : (SecurityConstants.containsActionEncryption(action) || SecurityConstants.containsActionDecryption(action) ? CodiceErroreCooperazione.SICUREZZA_CIFRATURA_NON_PRESENTE : CodiceErroreCooperazione.SICUREZZA_NON_PRESENTE);
                    return false;
                }
                if ((action.contains("SAMLTokenSigned") || action.contains("SAMLTokenUnsigned")) && (samlVersion = (String)this.messageSecurityContext.getIncomingProperties().get("samlVersion")) != null && !"".equals(samlVersion)) {
                    SOAPHeaderElement securityHeader = this.messageSecurityContext.getSecurityHeader(message, actor);
                    SOAPElement samlToken = this.messageSecurityContext.getSAMLTokenInSecurityHeader(message.getFactory(), securityHeader, samlVersion);
                    if (samlToken == null) {
                        this.msgErrore = "SAMLToken (versione:" + samlVersion + "), richiesto dalla configurazione (action:" + action + "), non riscontrato nell'header Message Security presente all'interno della SOAPEnvelope ricevuta";
                        this.codiceErrore = CodiceErroreCooperazione.SICUREZZA_TOKEN_NON_PRESENTE;
                        return false;
                    }
                    String samlConfirmationType = (String)this.messageSecurityContext.getIncomingProperties().get("validateSamlSubjectConfirmationType");
                    if (samlConfirmationType != null && !"".equals(samlConfirmationType)) {
                        String confirmationMethod = this.messageSecurityContext.getSAMLTokenSubjectConfirmationMethodInSecurityHeader(message.getFactory(), samlToken, samlVersion);
                        if (confirmationMethod == null) {
                            this.msgErrore = "SAMLToken (versione:" + samlVersion + "), richiesto dalla configurazione (action:" + action + "), non possiede un metodo di subject confirmation";
                            this.codiceErrore = CodiceErroreCooperazione.SICUREZZA_TOKEN_NON_VALIDO;
                            return false;
                        }
                        String atteso = null;
                        if ("holder-of-key".equals(samlConfirmationType)) {
                            atteso = "2.0".equals(samlVersion) ? "urn:oasis:names:tc:SAML:2.0:cm:holder-of-key" : "urn:oasis:names:tc:SAML:1.0:cm:holder-of-key";
                        } else if ("sender-vouches".equals(samlConfirmationType)) {
                            String string = atteso = "2.0".equals(samlVersion) ? "urn:oasis:names:tc:SAML:2.0:cm:sender-vouches" : "urn:oasis:names:tc:SAML:1.0:cm:sender-vouches";
                        }
                        if (atteso != null && !atteso.equals(confirmationMethod)) {
                            this.msgErrore = "SAMLToken (versione:" + samlVersion + "), richiesto dalla configurazione (action:" + action + "), possiede un metodo di subject confirmation (" + confirmationMethod + ") diverso da quello atteso (" + atteso + ")";
                            this.codiceErrore = CodiceErroreCooperazione.SICUREZZA_TOKEN_NON_VALIDO;
                            return false;
                        }
                    }
                }
            }
            List<Reference> elementsToClean = null;
            if (ServiceBinding.SOAP.equals((Object)message.getServiceBinding())) {
                elementsToClean = receiverInterface.getDirtyElements(this.messageSecurityContext, message.castAsSoap());
            }
            ArrayList<SubErrorCodeSecurity> listaErroriRiscontrati = new ArrayList<SubErrorCodeSecurity>();
            java.util.Map<QName, QName> notResolved = null;
            if (ServiceBinding.SOAP.equals((Object)message.getServiceBinding())) {
                notResolved = receiverInterface.checkEncryptSignatureParts(this.messageSecurityContext, elementsToClean, message.castAsSoap(), listaErroriRiscontrati);
            }
            if (listaErroriRiscontrati.size() > 0) {
                StringBuilder bf = new StringBuilder();
                for (SubErrorCodeSecurity subCodiceErroreSicurezza : listaErroriRiscontrati) {
                    if (bf.length() > 0) {
                        bf.append(" ; ");
                    }
                    bf.append(subCodiceErroreSicurezza.getMsgErrore());
                }
                this.messageSecurityContext.getLog().error(bf.toString());
                this.msgErrore = bf.toString();
                this.codiceErrore = CodiceErroreCooperazione.SICUREZZA_NON_PRESENTE;
                this.listaSubCodiceErrore.addAll(listaErroriRiscontrati);
                return false;
            }
            receiverInterface.process(this.messageSecurityContext, message, busta, ctx);
            ArrayList<SubErrorCodeSecurity> listaErroriInElementi = new ArrayList<SubErrorCodeSecurity>();
            if (ServiceBinding.SOAP.equals((Object)message.getServiceBinding())) {
                receiverInterface.checkEncryptionPartElements(notResolved, message.castAsSoap(), listaErroriInElementi);
            }
            if (listaErroriInElementi.size() > 0) {
                StringBuilder bf = new StringBuilder();
                for (SubErrorCodeSecurity subCodiceErroreSicurezza : listaErroriInElementi) {
                    if (bf.length() > 0) {
                        bf.append(" ; ");
                    }
                    bf.append(subCodiceErroreSicurezza.getMsgErrore());
                }
                this.messageSecurityContext.getLog().error(bf.toString());
                this.msgErrore = bf.toString();
                this.codiceErrore = CodiceErroreCooperazione.SICUREZZA_NON_PRESENTE;
                this.listaSubCodiceErrore.addAll(listaErroriInElementi);
                return false;
            }
            try {
                this.subject = receiverInterface.getCertificate();
            }
            catch (Exception e) {
                this.messageSecurityContext.getLog().error("GetPrincipal Message-Security(Receiver) error: " + e.getMessage(), (Throwable)e);
            }
            if (authClass != null) {
                try {
                    IMessageSecurityAuthorization auth = (IMessageSecurityAuthorization)Loader.getInstance().newInstance(authClass);
                    MessageSecurityAuthorizationRequest req = new MessageSecurityAuthorizationRequest();
                    req.setBusta(busta);
                    req.setSecurityPrincipal(this.subject);
                    req.setMessageSecurityContext(this.messageSecurityContext);
                    req.setMessage(message);
                    MessageSecurityAuthorizationResult result = auth.authorize(req);
                    if (!result.isAuthorized()) {
                        this.msgErrore = "Mittente della busta [" + busta.getTipoMittente() + busta.getMittente() + "] (subject:" + this.subject + ") non autorizzato ad invocare il servizio [" + busta.getServizio() + "] erogato dal soggetto [" + busta.getTipoDestinatario() + busta.getDestinatario() + "]";
                        if (result.getErrorMessage() != null) {
                            this.msgErrore = this.msgErrore + "(" + result.getErrorMessage() + ")";
                        }
                        if (result.getException() != null) {
                            this.messageSecurityContext.getLog().error(this.msgErrore, (Throwable)result.getException());
                        }
                        this.codiceErrore = CodiceErroreCooperazione.SICUREZZA_AUTORIZZAZIONE_FALLITA;
                        return false;
                    }
                }
                catch (Exception e) {
                    throw new Exception("Errore di Processamento durante l'autorizzazione: " + e.getMessage());
                }
            }
            try {
                boolean detachValue = true;
                Object detach = this.messageSecurityContext.getIncomingProperties().get("detachHeaderWSSecurity");
                if (detach != null) {
                    detachValue = Boolean.parseBoolean((String)detach);
                }
                if (detach == null && (detach = this.messageSecurityContext.getIncomingProperties().get("detachSecurityInfo")) != null) {
                    detachValue = Boolean.parseBoolean((String)detach);
                }
                boolean removeAllIdRefValue = this.messageSecurityContext.isRemoveAllWsuIdRef();
                Object removeAllIdRef = this.messageSecurityContext.getIncomingProperties().get("removeAllWsuIdRef");
                if (removeAllIdRef != null) {
                    removeAllIdRefValue = Boolean.parseBoolean((String)removeAllIdRef);
                }
                if (ServiceBinding.SOAP.equals((Object)message.getServiceBinding())) {
                    receiverInterface.cleanDirtyElements(this.messageSecurityContext, message.castAsSoap(), elementsToClean, detachValue, removeAllIdRefValue);
                } else if (detachValue) {
                    receiverInterface.detachSecurity(this.messageSecurityContext, message.castAsRest());
                }
            }
            catch (SecurityException e) {
                this.messageSecurityContext.getLog().error("Errore durante il clean del messaggio: " + e.getMessage(), (Throwable)e);
                throw new Exception("Errore durante la cleanMessage: " + e.getMessage());
            }
        }
        catch (Exception e) {
            String prefix = "Generatosi errore durante il processamento Message-Security(Receiver): ";
            this.messageSecurityContext.getLog().error(prefix + e.getMessage(), (Throwable)e);
            this.msgErrore = prefix + "Generatosi errore durante il processamento Message-Security(Receiver): " + e.getMessage();
            this.codiceErrore = CodiceErroreCooperazione.SICUREZZA;
            if (e instanceof SecurityException) {
                SecurityException securityException = (SecurityException)e;
                if (securityException.getMsgErrore() != null) {
                    this.msgErrore = prefix + securityException.getMsgErrore();
                }
                if (securityException.getCodiceErrore() != null) {
                    this.codiceErrore = securityException.getCodiceErrore();
                }
            }
            return false;
        }
        return true;
    }
}

