/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.security.message;

import java.util.HashMap;
import java.util.Map;
import org.openspcoop2.message.OpenSPCoop2RestMessage;
import org.openspcoop2.message.constants.MessageRole;
import org.openspcoop2.security.SecurityException;
import org.openspcoop2.security.message.IMessageSecuritySender;
import org.openspcoop2.security.message.constants.SecurityConstants;
import org.openspcoop2.utils.io.Base64Utilities;

public abstract class AbstractRESTMessageSecuritySender
implements IMessageSecuritySender {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void setDetachedSignatureInMessage(Map<String, Object> map, OpenSPCoop2RestMessage<?> restMessage, String descriptionEngine, String detachedSignatureParam) throws SecurityException {
        String signatureDetachedHeader = null;
        String signatureDetachedPropertyUrl = null;
        String mode = (String)map.get("signatureMode");
        boolean base64Detached = SecurityConstants.SIGNATURE_DETACHED_BASE64_DEFAULT;
        String tmpBase64 = (String)map.get("signatureDetachedBase64");
        if (tmpBase64 != null && !"".equals(tmpBase64)) {
            try {
                base64Detached = Boolean.parseBoolean(tmpBase64);
            }
            catch (Exception e) {
                throw new SecurityException(descriptionEngine + " (mode:" + mode + " message-role:" + restMessage.getMessageRole() + ") property 'signatureDetachedBase64' with wrong value (expected true/false): " + e.getMessage(), e);
            }
        }
        String detachedSignature = null;
        detachedSignature = base64Detached ? Base64Utilities.encodeAsString((byte[])detachedSignatureParam.getBytes()) : detachedSignatureParam;
        signatureDetachedHeader = (String)map.get("signatureDetachedHeader");
        if (signatureDetachedHeader == null || "".equals(signatureDetachedHeader.trim())) {
            signatureDetachedHeader = null;
            if (!MessageRole.REQUEST.equals((Object)restMessage.getMessageRole())) throw new SecurityException(descriptionEngine + " (mode:" + mode + " message-role:" + restMessage.getMessageRole() + ") require 'signatureDetachedHeader' property");
            signatureDetachedPropertyUrl = (String)map.get("signatureDetachedPropertyURL");
            if (signatureDetachedPropertyUrl == null || "".equals(signatureDetachedPropertyUrl.trim())) {
                signatureDetachedPropertyUrl = null;
                throw new SecurityException(descriptionEngine + " (mode:" + mode + " message-role:" + restMessage.getMessageRole() + ") require 'signatureDetachedHeader'/'signatureDetachedPropertyURL' property");
            }
            if (restMessage.getTransportRequestContext() == null) {
                throw new SecurityException(descriptionEngine + " (mode:" + mode + " message-role:" + restMessage.getMessageRole() + ") property url '" + signatureDetachedPropertyUrl + "'; transporto context undefined");
            }
            if (restMessage.getTransportRequestContext().getParameters() == null) {
                restMessage.getTransportRequestContext().setParameters(new HashMap());
            }
            restMessage.getTransportRequestContext().removeParameter(signatureDetachedPropertyUrl);
            restMessage.forceUrlProperty(signatureDetachedPropertyUrl, detachedSignature);
            return;
        } else {
            if (MessageRole.REQUEST.equals((Object)restMessage.getMessageRole())) {
                if (restMessage.getTransportRequestContext() == null) {
                    throw new SecurityException(descriptionEngine + " (mode:" + mode + " message-role:" + restMessage.getMessageRole() + ") property url '" + signatureDetachedPropertyUrl + "'; transporto context undefined");
                }
                if (restMessage.getTransportRequestContext().getHeaders() == null) {
                    restMessage.getTransportRequestContext().setHeaders(new HashMap());
                }
                restMessage.getTransportRequestContext().removeHeader(signatureDetachedHeader);
                restMessage.forceTransportHeader(signatureDetachedHeader, detachedSignature);
            } else {
                if (restMessage.getTransportResponseContext() == null) {
                    throw new SecurityException(descriptionEngine + " (mode:" + mode + " message-role:" + restMessage.getMessageRole() + ") property url '" + signatureDetachedPropertyUrl + "'; transporto context undefined");
                }
                if (restMessage.getTransportResponseContext().getHeaders() == null) {
                    restMessage.getTransportResponseContext().setHeaders(new HashMap());
                }
                restMessage.getTransportResponseContext().removeHeader(signatureDetachedHeader);
                restMessage.forceTransportHeader(signatureDetachedHeader, detachedSignature);
            }
            if (detachedSignature != null) return;
            throw new SecurityException(descriptionEngine + " (mode:" + mode + " message-role:" + restMessage.getMessageRole() + ") header '" + signatureDetachedHeader + "' not found");
        }
    }
}

