/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.security.keystore.cache;

import org.openspcoop2.security.SecurityException;
import org.openspcoop2.security.keystore.PublicKeyStore;
import org.openspcoop2.security.keystore.cache.AbstractKeystoreCache;

public class PublicKeyStoreCache
extends AbstractKeystoreCache<PublicKeyStore> {
    @Override
    public PublicKeyStore createKeystore(String key, Object ... params) throws SecurityException {
        if (params == null) {
            throw new SecurityException("Params is null");
        }
        if (params.length == 1) {
            return this.createFromPath(key, params);
        }
        if (params.length == 2) {
            return this.createFromByteArray(params);
        }
        throw new SecurityException("Params [lenght:" + params.length + "] not supported");
    }

    private PublicKeyStore createFromPath(String key, Object ... params) throws SecurityException {
        if (params[0] instanceof String) {
            String pathPublicKey = key;
            String algorithm = (String)params[0];
            return new PublicKeyStore(pathPublicKey, algorithm);
        }
        throw new SecurityException("Param[0] must be String (algorithm)");
    }

    private PublicKeyStore createFromByteArray(Object ... params) throws SecurityException {
        if (params[0] instanceof byte[]) {
            if (!(params[1] instanceof String)) {
                throw new SecurityException("Param[1] must be String (algorithm)");
            }
            byte[] publicKey = (byte[])params[0];
            String algorithm = (String)params[1];
            return new PublicKeyStore(publicKey, algorithm);
        }
        throw new SecurityException("Param[0] must be byte[] (publicKey)");
    }

    @Override
    public String getPrefixKey() {
        return "PublicKey ";
    }
}

