/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop.pdd.timers;

import org.apache.log4j.Logger;
import org.openspcoop.pdd.config.ClassNameProperties;
import org.openspcoop.pdd.config.OpenSPCoopProperties;
import org.openspcoop.pdd.core.threshold.IThreshold;
import org.openspcoop.pdd.core.threshold.ThresholdException;
import org.openspcoop.pdd.logger.MsgDiagnostico;
import org.openspcoop.pdd.logger.OpenSPCoopLogger;
import org.openspcoop.pdd.timers.TimerMonitoraggioRisorse;
import org.openspcoop.utils.Loader;

public class TimerThreshold
extends Thread {
    public static boolean freeSpace = true;
    public static final String ID_MODULO = "GestoreThreshold";
    private boolean stop = false;
    private OpenSPCoopProperties propertiesReader = OpenSPCoopProperties.getInstance();
    private MsgDiagnostico msgDiag = new MsgDiagnostico(this.propertiesReader.getIdentificativoPortaDefault(), "GestoreThreshold");
    private IThreshold[] gestore = null;
    private String[] tipiThreshold = null;
    private Logger log;
    private boolean lastCheck = true;

    public boolean isStop() {
        return this.stop;
    }

    public void setStop(boolean stop) {
        this.stop = stop;
    }

    public TimerThreshold() throws ThresholdException {
        this.msgDiag.setPrefixMsgPersonalizzati("timerThreshold.");
        this.msgDiag.addKeyword("@ID_TIMER_THRESHOLD@", ID_MODULO);
        this.log = OpenSPCoopLogger.getLoggerOpenSPCoopResources();
        this.tipiThreshold = this.propertiesReader.getRepositoryThresholdTypes();
        this.gestore = new IThreshold[this.tipiThreshold.length];
        Loader loader = Loader.getInstance();
        for (int i = 0; i < this.tipiThreshold.length; ++i) {
            String tipoClass = ClassNameProperties.getInstance().getThreshold(this.tipiThreshold[i]);
            if (tipoClass == null) {
                throw new ThresholdException("Riscontrato errore durante l'istanziazione del threshold di tipo [" + this.tipiThreshold[i] + "]: is null");
            }
            try {
                this.gestore[i] = (IThreshold)loader.newInstance(tipoClass);
                this.gestore[i].toString();
                continue;
            }
            catch (Exception e) {
                throw new ThresholdException("Riscontrato errore durante l'istanziazione del threshold di tipo [" + this.tipiThreshold[i] + "]: " + e.getMessage());
            }
        }
    }

    public void run() {
        String sec = "secondi";
        if (this.propertiesReader.getRepositoryThresholdCheckInterval() == 1L) {
            sec = "secondo";
        }
        this.msgDiag.addKeyword("@TIMEOUT@", this.propertiesReader.getRepositoryThresholdCheckInterval() + " " + sec);
        this.msgDiag.logPersonalizzato("avvioEffettuato");
        while (!this.stop) {
            if (!TimerMonitoraggioRisorse.risorseDisponibili) {
                this.log.error((Object)("[GestoreThreshold] Risorse di sistema non disponibili: " + TimerMonitoraggioRisorse.risorsaNonDisponibile.getMessage()), (Throwable)TimerMonitoraggioRisorse.risorsaNonDisponibile);
                if (this.stop) continue;
                try {
                    Thread.sleep(this.propertiesReader.getRepositoryThresholdCheckInterval() * 1000L);
                }
                catch (Exception e) {}
                continue;
            }
            boolean checkThreshold = true;
            for (int i = 0; i < this.tipiThreshold.length; ++i) {
                this.msgDiag.addKeyword("@TIPO_THRESHOLD@", this.tipiThreshold[i]);
                this.msgDiag.logPersonalizzato("controlloInCorso");
                try {
                    checkThreshold = this.gestore[i].check(this.propertiesReader.getRepositoryThresholdValue(this.tipiThreshold[i]));
                }
                catch (Exception e) {
                    this.msgDiag.logErroreGenerico(e, "checkThreshold(" + this.tipiThreshold[i] + ")");
                    this.log.debug((Object)("Controllo threshould non riuscito (tipo:" + this.tipiThreshold[i] + ")"), (Throwable)e);
                    checkThreshold = false;
                }
                if (!checkThreshold) break;
            }
            if (!checkThreshold && this.lastCheck) {
                this.msgDiag.logPersonalizzato("risorsaNonDisponibile");
            } else if (checkThreshold && !this.lastCheck) {
                this.msgDiag.logPersonalizzato("risorsaRitornataDisponibile");
            }
            this.lastCheck = checkThreshold;
            freeSpace = checkThreshold;
            if (this.stop) continue;
            try {
                Thread.sleep(this.propertiesReader.getRepositoryThresholdCheckInterval() * 1000L);
            }
            catch (Exception exception) {}
        }
    }
}

