/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop.pdd.timers;

import java.util.Vector;
import org.apache.log4j.Logger;
import org.openspcoop.egov.RepositoryEGov;
import org.openspcoop.pdd.config.OpenSPCoopProperties;
import org.openspcoop.pdd.core.state.OpenSPCoopStateful;
import org.openspcoop.pdd.logger.MsgDiagnostico;
import org.openspcoop.pdd.services.OpenSPCoopStartup;
import org.openspcoop.pdd.timers.TimerException;
import org.openspcoop.pdd.timers.TimerMonitoraggioRisorse;

public class TimerGestoreRepositoryEGovLib {
    private MsgDiagnostico msgDiag = null;
    private Logger log = null;
    private OpenSPCoopProperties propertiesReader = null;
    private boolean logQuery = false;

    public TimerGestoreRepositoryEGovLib(MsgDiagnostico msgDiag, Logger log, OpenSPCoopProperties p, boolean logQuery) {
        this.msgDiag = msgDiag;
        this.log = log;
        this.propertiesReader = p;
        this.logQuery = logQuery;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void check() throws TimerException {
        if (!OpenSPCoopStartup.initialize) {
            this.msgDiag.logFatalError("inizializzazione di OpenSPCoop non effettuata", "Check Inizializzazione");
            throw new TimerException("Riscontrato errore: inizializzazione del Timer o di OpenSPCoop non effettuata");
        }
        if (!TimerMonitoraggioRisorse.risorseDisponibili) {
            this.log.error((Object)("[GestoreRepositoryEGov] Risorse di sistema non disponibili: " + TimerMonitoraggioRisorse.risorsaNonDisponibile.getMessage()), (Throwable)TimerMonitoraggioRisorse.risorsaNonDisponibile);
            return;
        }
        if (!MsgDiagnostico.gestoreDiagnosticaDisponibile) {
            this.log.error((Object)("[GestoreRepositoryEGov] Sistema di diagnostica non disponibile: " + MsgDiagnostico.motivoMalfunzionamentoDiagnostici.getMessage()), (Throwable)MsgDiagnostico.motivoMalfunzionamentoDiagnostici);
            return;
        }
        this.msgDiag.logPersonalizzato("controlloInCorso");
        RepositoryEGov repositoryEGov = null;
        OpenSPCoopStateful openspcoopstate = new OpenSPCoopStateful();
        try {
            openspcoopstate.initResource(this.propertiesReader.getIdentitaPortaDefault(), "GestoreRepositoryEGov");
            repositoryEGov = new RepositoryEGov(openspcoopstate.getStatoRichiesta());
            RepositoryEGov rBuste = new RepositoryEGov(openspcoopstate.getStatoRichiesta());
            Vector idMsgINBOX = rBuste.getBusteDaEliminareFromInBox(200, this.logQuery, this.propertiesReader.isForceIndex());
            Vector idMsgOUTBOX = rBuste.getBusteDaEliminareFromOutBox(200, this.logQuery, this.propertiesReader.isForceIndex());
            while (idMsgINBOX.size() > 0 || idMsgOUTBOX.size() > 0) {
                String idMsgDaEliminare;
                int i;
                this.msgDiag.addKeyword("@NUMERO_BUSTE_INBOX@", idMsgINBOX.size() + "");
                this.msgDiag.addKeyword("@NUMERO_BUSTE_OUTBOX@", idMsgOUTBOX.size() + "");
                this.msgDiag.logPersonalizzato("ricercaMessaggiDaEliminare");
                this.msgDiag.addKeyword("@TIPO_MESSAGGIO@", "INBOX");
                for (i = 0; i < idMsgINBOX.size(); ++i) {
                    idMsgDaEliminare = (String)idMsgINBOX.get(i);
                    this.msgDiag.addKeyword("@ID_EGOV_DA_ELIMINARE@", idMsgDaEliminare);
                    try {
                        repositoryEGov.eliminaBustaFromInBox(idMsgDaEliminare);
                        this.msgDiag.logPersonalizzato("eliminazioneMessaggio");
                        continue;
                    }
                    catch (Exception e) {
                        this.msgDiag.logErroreGenerico(e, "EliminazioneBustaInbox(" + idMsgDaEliminare + ")");
                    }
                }
                this.msgDiag.addKeyword("@TIPO_MESSAGGIO@", "OUTBOX");
                for (i = 0; i < idMsgOUTBOX.size(); ++i) {
                    idMsgDaEliminare = (String)idMsgOUTBOX.get(i);
                    this.msgDiag.addKeyword("@ID_EGOV_DA_ELIMINARE@", idMsgDaEliminare);
                    try {
                        repositoryEGov.eliminaBustaFromOutBox(idMsgDaEliminare);
                        this.msgDiag.logPersonalizzato("eliminazioneMessaggio");
                        continue;
                    }
                    catch (Exception e) {
                        this.msgDiag.logErroreGenerico(e, "EliminazioneBustaOutbox(" + idMsgDaEliminare + ")");
                    }
                }
                idMsgINBOX = rBuste.getBusteDaEliminareFromInBox(200, this.logQuery, this.propertiesReader.isForceIndex());
                idMsgOUTBOX = rBuste.getBusteDaEliminareFromOutBox(200, this.logQuery, this.propertiesReader.isForceIndex());
            }
        }
        catch (Exception e) {
            this.msgDiag.logErroreGenerico(e, "GestioneBuste");
        }
        finally {
            if (openspcoopstate != null) {
                openspcoopstate.releaseResource();
            }
        }
    }
}

