/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop.pdd.timers;

import java.util.Vector;
import org.apache.log4j.Logger;
import org.openspcoop.dao.state.StateMessage;
import org.openspcoop.egov.RollbackRepositoryEGov;
import org.openspcoop.pdd.config.OpenSPCoopProperties;
import org.openspcoop.pdd.core.GestoreMessaggi;
import org.openspcoop.pdd.core.state.OpenSPCoopStateful;
import org.openspcoop.pdd.logger.MsgDiagnostico;
import org.openspcoop.pdd.services.OpenSPCoopStartup;
import org.openspcoop.pdd.timers.TimerException;
import org.openspcoop.pdd.timers.TimerMonitoraggioRisorse;

public class TimerGestorePuliziaMessaggiAnomaliLib {
    private MsgDiagnostico msgDiag = null;
    private Logger log = null;
    private OpenSPCoopProperties propertiesReader = null;
    private boolean logQuery = false;

    public TimerGestorePuliziaMessaggiAnomaliLib(MsgDiagnostico msgDiag, Logger log, OpenSPCoopProperties p, boolean logQuery) {
        this.msgDiag = msgDiag;
        this.log = log;
        this.propertiesReader = p;
        this.logQuery = logQuery;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void check() throws TimerException {
        if (!OpenSPCoopStartup.initialize) {
            this.msgDiag.logFatalError("inizializzazione di OpenSPCoop non effettuata", "Check Inizializzazione");
            throw new TimerException("Riscontrato errore: inizializzazione del Timer o di OpenSPCoop non effettuata");
        }
        if (!TimerMonitoraggioRisorse.risorseDisponibili) {
            this.log.error((Object)("[GestoreConsistenzaDatabase] Risorse di sistema non disponibili: " + TimerMonitoraggioRisorse.risorsaNonDisponibile.getMessage()), (Throwable)TimerMonitoraggioRisorse.risorsaNonDisponibile);
            return;
        }
        if (!MsgDiagnostico.gestoreDiagnosticaDisponibile) {
            this.log.error((Object)("[GestoreRepositoryEGov] Sistema di diagnostica non disponibile: " + MsgDiagnostico.motivoMalfunzionamentoDiagnostici.getMessage()), (Throwable)MsgDiagnostico.motivoMalfunzionamentoDiagnostici);
            return;
        }
        this.msgDiag.logPersonalizzato("controlloInCorso");
        RollbackRepositoryEGov rollbackEGovMessaggio = null;
        OpenSPCoopStateful openspcoopstate = new OpenSPCoopStateful();
        try {
            openspcoopstate.initResource(this.propertiesReader.getIdentitaPortaDefault(), "GestoreConsistenzaDatabase");
            GestoreMessaggi gestoreMsgSearch = new GestoreMessaggi(openspcoopstate, true, this.msgDiag);
            Vector<String> busteEGovInutiliINBOX = gestoreMsgSearch.readBusteEGovNonRiferiteDaMessaggiFromInBox(200, this.logQuery, this.propertiesReader.isForceIndex());
            Vector<String> busteEGovInutiliOUTBOX = gestoreMsgSearch.readBusteEGovNonRiferiteDaMessaggiFromOutBox(200, this.logQuery, this.propertiesReader.isForceIndex());
            while (busteEGovInutiliINBOX.size() > 0 || busteEGovInutiliOUTBOX.size() > 0) {
                String idMsgDaEliminare;
                int i;
                this.msgDiag.addKeyword("@NUMERO_MESSAGGI_INCONSISTENTI_INBOX@", busteEGovInutiliINBOX.size() + "");
                this.msgDiag.addKeyword("@NUMERO_MESSAGGI_INCONSISTENTI_OUTBOX@", busteEGovInutiliOUTBOX.size() + "");
                this.msgDiag.logPersonalizzato("ricercaMessaggiDaEliminare");
                this.msgDiag.addKeyword("@TIPO_MESSAGGIO@", "INBOX");
                for (i = 0; i < busteEGovInutiliINBOX.size(); ++i) {
                    idMsgDaEliminare = busteEGovInutiliINBOX.get(i);
                    this.msgDiag.addKeyword("@ID_EGOV_DA_ELIMINARE@", idMsgDaEliminare);
                    try {
                        rollbackEGovMessaggio = new RollbackRepositoryEGov(idMsgDaEliminare, openspcoopstate.getStatoRichiesta(), true);
                        rollbackEGovMessaggio.rollbackBustaIntoInBox(false);
                        ((StateMessage)openspcoopstate.getStatoRichiesta()).executePreparedStatement();
                        this.msgDiag.logPersonalizzato("eliminazioneMessaggio");
                        continue;
                    }
                    catch (Exception e) {
                        if (rollbackEGovMessaggio != null) {
                            ((StateMessage)openspcoopstate.getStatoRichiesta()).closePreparedStatement();
                            rollbackEGovMessaggio = null;
                        }
                        this.msgDiag.logErroreGenerico(e, "EliminazioneBustaInbox(" + idMsgDaEliminare + ")");
                    }
                }
                this.msgDiag.addKeyword("@TIPO_MESSAGGIO@", "OUTBOX");
                for (i = 0; i < busteEGovInutiliOUTBOX.size(); ++i) {
                    idMsgDaEliminare = busteEGovInutiliOUTBOX.get(i);
                    this.msgDiag.addKeyword("@ID_EGOV_DA_ELIMINARE@", idMsgDaEliminare);
                    try {
                        rollbackEGovMessaggio = new RollbackRepositoryEGov(idMsgDaEliminare, openspcoopstate.getStatoRichiesta(), true);
                        rollbackEGovMessaggio.rollbackBustaIntoOutBox(false);
                        ((StateMessage)openspcoopstate.getStatoRichiesta()).executePreparedStatement();
                        this.msgDiag.logPersonalizzato("eliminazioneMessaggio");
                        continue;
                    }
                    catch (Exception e) {
                        if (rollbackEGovMessaggio != null) {
                            ((StateMessage)openspcoopstate.getStatoRichiesta()).closePreparedStatement();
                            rollbackEGovMessaggio = null;
                        }
                        this.msgDiag.logErroreGenerico(e, "EliminazioneBustaOutbox(" + idMsgDaEliminare + ")");
                    }
                }
                busteEGovInutiliINBOX = gestoreMsgSearch.readBusteEGovNonRiferiteDaMessaggiFromInBox(200, this.logQuery, this.propertiesReader.isForceIndex());
                busteEGovInutiliOUTBOX = gestoreMsgSearch.readBusteEGovNonRiferiteDaMessaggiFromOutBox(200, this.logQuery, this.propertiesReader.isForceIndex());
            }
        }
        catch (Exception e) {
            this.msgDiag.logErroreGenerico(e, "GestioneMessaggiInconsistenti");
        }
        finally {
            if (openspcoopstate != null) {
                openspcoopstate.releaseResource();
            }
        }
    }
}

