/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop.pdd.timers;

import org.apache.log4j.Logger;
import org.openspcoop.pdd.config.OpenSPCoopProperties;
import org.openspcoop.pdd.logger.MsgDiagnostico;
import org.openspcoop.pdd.logger.OpenSPCoopLogger;
import org.openspcoop.pdd.services.OpenSPCoopStartup;
import org.openspcoop.pdd.timers.TimerException;
import org.openspcoop.pdd.timers.TimerGestoreMessaggiLib;

public class TimerGestoreMessaggiThread
extends Thread {
    private long timeout = 10L;
    private long scadenzaMessaggio = 7200L;
    private OpenSPCoopProperties propertiesReader;
    private MsgDiagnostico msgDiag;
    private Logger log = null;
    private boolean logQuery = false;
    private boolean stop = false;

    public boolean isStop() {
        return this.stop;
    }

    public void setStop(boolean stop) {
        this.stop = stop;
    }

    public TimerGestoreMessaggiThread() throws TimerException {
        int secondi;
        int attesa = 90;
        for (secondi = 0; !OpenSPCoopStartup.initialize && secondi < attesa; ++secondi) {
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (secondi >= 90) {
            throw new TimerException("Riscontrata inizializzazione OpenSPCoop non effettuata");
        }
        this.log = OpenSPCoopLogger.getLoggerOpenSPCoopCore();
        try {
            this.msgDiag = new MsgDiagnostico("GestoreMessaggi");
            this.msgDiag.setPrefixMsgPersonalizzati("timerGestoreMessaggi.");
            this.msgDiag.addKeyword("@ID_TIMER_GESTORE_MESSAGGI@", "GestoreMessaggi");
        }
        catch (Exception e) {
            this.log.error((Object)"Riscontrato Errore durante l'inizializzazione del MsgDiagnostico", (Throwable)e);
            throw new TimerException("Riscontrato Errore durante l'inizializzazione del MsgDiagnostico per il Thread GestoreMessaggi");
        }
        this.msgDiag.logPersonalizzato("avvioInCorso");
        try {
            this.propertiesReader = OpenSPCoopProperties.getInstance();
        }
        catch (Exception e) {
            this.msgDiag.logErroreGenerico(e, "InizializzazioneTimer");
            throw new TimerException("Riscontrato errore durante la lettura delle configurazione per il Thread GestoreMessaggi");
        }
        this.timeout = this.propertiesReader.getRepositoryIntervalloEliminazioneMessaggi();
        String s = "secondi";
        if (this.timeout == 1L) {
            s = "secondo";
        }
        this.msgDiag.addKeyword("@TIMEOUT@", this.timeout + " " + s);
        this.scadenzaMessaggio = this.propertiesReader.getRepositoryIntervalloScadenzaMessaggi();
        s = "minuti";
        if (this.scadenzaMessaggio == 1L) {
            s = "minuto";
        }
        this.msgDiag.addKeyword("@SCADENZA_MESSAGGIO@", this.scadenzaMessaggio + " " + s);
        this.logQuery = this.propertiesReader.isTimerGestoreMessaggiAbilitatoLog();
        this.msgDiag.logPersonalizzato("avvioEffettuato");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        block6: while (!this.stop) {
            try {
                TimerGestoreMessaggiLib gestoreMessaggiLib = new TimerGestoreMessaggiLib(this.msgDiag, this.log, this.propertiesReader, this.scadenzaMessaggio, this.logQuery);
                gestoreMessaggiLib.check();
            }
            catch (Exception e) {
                this.msgDiag.logErroreGenerico(e, "TimerGestoreMessaggiLib.check()");
            }
            if (this.stop) continue;
            int i = 0;
            while ((long)i < this.timeout) {
                try {
                    Thread.sleep(1000L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (this.stop) continue block6;
                ++i;
            }
        }
    }
}

