/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop.pdd.timers;

import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.openspcoop.dao.state.StateMessage;
import org.openspcoop.egov.RollbackRepositoryEGov;
import org.openspcoop.pdd.config.OpenSPCoopProperties;
import org.openspcoop.pdd.core.GestoreCorrelazioneApplicativa;
import org.openspcoop.pdd.core.GestoreMessaggi;
import org.openspcoop.pdd.core.JMSReceiver;
import org.openspcoop.pdd.core.connettori.IConnettore;
import org.openspcoop.pdd.core.connettori.RepositoryConnettori;
import org.openspcoop.pdd.core.state.OpenSPCoopStateful;
import org.openspcoop.pdd.logger.MsgDiagnostico;
import org.openspcoop.pdd.services.OpenSPCoopStartup;
import org.openspcoop.pdd.timers.TimerException;
import org.openspcoop.pdd.timers.TimerMonitoraggioRisorse;
import org.openspcoop.utils.date.DateManager;

public class TimerGestoreMessaggiLib {
    private MsgDiagnostico msgDiag = null;
    private Logger log = null;
    private OpenSPCoopProperties propertiesReader = null;
    private long scadenzaMessaggio = -1L;
    private boolean logQuery = false;

    public TimerGestoreMessaggiLib(MsgDiagnostico msgDiag, Logger log, OpenSPCoopProperties p, long scadenzaMessaggio, boolean logQuery) {
        this.msgDiag = msgDiag;
        this.log = log;
        this.propertiesReader = p;
        this.scadenzaMessaggio = scadenzaMessaggio;
        this.logQuery = logQuery;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void check() throws TimerException {
        if (!OpenSPCoopStartup.initialize) {
            this.msgDiag.logFatalError("inizializzazione di OpenSPCoop non effettuata", "Check Inizializzazione");
            throw new TimerException("Riscontrato errore: inizializzazione del Timer o di OpenSPCoop non effettuata");
        }
        if (!TimerMonitoraggioRisorse.risorseDisponibili) {
            this.log.error((Object)("[GestoreMessaggi] Risorse di sistema non disponibili: " + TimerMonitoraggioRisorse.risorsaNonDisponibile.getMessage()), (Throwable)TimerMonitoraggioRisorse.risorsaNonDisponibile);
            return;
        }
        if (!MsgDiagnostico.gestoreDiagnosticaDisponibile) {
            this.log.error((Object)("[GestoreRepositoryEGov] Sistema di diagnostica non disponibile: " + MsgDiagnostico.motivoMalfunzionamentoDiagnostici.getMessage()), (Throwable)MsgDiagnostico.motivoMalfunzionamentoDiagnostici);
            return;
        }
        this.msgDiag.logPersonalizzato("controlloInCorso");
        GestoreMessaggi gestoreMsg = null;
        RollbackRepositoryEGov rollbackEGovMessaggio = null;
        RollbackRepositoryEGov rollbackEGovRepository = null;
        OpenSPCoopStateful openspcoopstate = new OpenSPCoopStateful();
        try {
            openspcoopstate.initResource(this.propertiesReader.getIdentitaPortaDefault(), "GestoreMessaggi");
            JMSReceiver receiverJMS = null;
            if ("jms".equals(this.propertiesReader.getNodeReceiver())) {
                receiverJMS = new JMSReceiver(this.propertiesReader.getIdentificativoPortaDefault(), "ForcedDeleteMessage", this.propertiesReader.singleConnection_NodeReceiver(), this.log);
            }
            GestoreMessaggi gestoreMsgSearch = new GestoreMessaggi(openspcoopstate, true, this.msgDiag);
            Vector<String> idMsgInutiliINBOX = gestoreMsgSearch.readMessaggiInutiliIntoInbox("GestoreMessaggi", 200, this.logQuery);
            Vector<String> idMsgInutiliOUTBOX = gestoreMsgSearch.readMessaggiInutiliIntoOutbox("GestoreMessaggi", 200, this.logQuery);
            Vector<String> idMsgScadutiINBOX = gestoreMsgSearch.readMessaggiScadutiIntoInbox(this.scadenzaMessaggio, 200, this.logQuery);
            Vector<String> idMsgScadutiOUTBOX = gestoreMsgSearch.readMessaggiScadutiIntoOutbox(this.scadenzaMessaggio, 200, this.logQuery);
            long timeoutRicezioneContenutiApplicativiNonGestiti = this.propertiesReader.getNodeReceiverTimeoutRicezioneContenutiApplicativi() * 3L;
            Vector<String> idMsgServizioRicezioneContenutiApplicativiNonGestiti = gestoreMsgSearch.readMsgForRicezioneContenutiApplicativiNonGestiti(timeoutRicezioneContenutiApplicativiNonGestiti, 200, this.logQuery);
            long timeoutRicezioneBusteEGovNonGestiti = this.propertiesReader.getNodeReceiverTimeoutRicezioneBusteEgov() * 3L;
            Vector<String> idMsgServizioRicezioneBusteEGovNonGestiti = gestoreMsgSearch.readMsgForRicezioneBusteEGovNonGestiti(timeoutRicezioneBusteEGovNonGestiti, 200, this.logQuery);
            while (idMsgInutiliINBOX.size() > 0 || idMsgInutiliOUTBOX.size() > 0 || idMsgScadutiINBOX.size() > 0 || idMsgScadutiOUTBOX.size() > 0 || idMsgServizioRicezioneContenutiApplicativiNonGestiti.size() > 0 || idMsgServizioRicezioneBusteEGovNonGestiti.size() > 0) {
                String strMessageSelector;
                String rifMsg;
                String idMsgDaEliminare;
                int i;
                this.msgDiag.addKeyword("@NUMERO_MESSAGGI_COMPLETATI_INBOX@", idMsgInutiliINBOX.size() + "");
                this.msgDiag.addKeyword("@NUMERO_MESSAGGI_COMPLETATI_OUTBOX@", idMsgInutiliOUTBOX.size() + "");
                this.msgDiag.addKeyword("@NUMERO_MESSAGGI_SCADUTI_INBOX@", idMsgScadutiINBOX.size() + "");
                this.msgDiag.addKeyword("@NUMERO_MESSAGGI_SCADUTI_OUTBOX@", idMsgScadutiOUTBOX.size() + "");
                this.msgDiag.addKeyword("@NUMERO_MESSAGGI_NON_GESTITI_RICEZIONE_CONTENUTI_APPLICATIVI@", idMsgServizioRicezioneContenutiApplicativiNonGestiti.size() + "");
                this.msgDiag.addKeyword("@NUMERO_MESSAGGI_NON_GESTITI_RICEZIONE_BUSTE_EGOV@", idMsgServizioRicezioneBusteEGovNonGestiti.size() + "");
                this.msgDiag.logPersonalizzato("ricercaMessaggiDaEliminare");
                this.msgDiag.addKeyword("@TIPO_RICERCA@", "MessaggiCompletati");
                this.msgDiag.addKeyword("@TIPO_MESSAGGIO@", "INBOX");
                for (i = 0; i < idMsgInutiliINBOX.size(); ++i) {
                    idMsgDaEliminare = idMsgInutiliINBOX.get(i);
                    this.msgDiag.addKeyword("@ID_EGOV_DA_ELIMINARE@", idMsgDaEliminare);
                    try {
                        gestoreMsg = new GestoreMessaggi(openspcoopstate, true, idMsgDaEliminare, "INBOX", this.msgDiag);
                        gestoreMsg.deleteMessage();
                        this.msgDiag.logPersonalizzato("eliminazioneMessaggio");
                        continue;
                    }
                    catch (Exception e) {
                        this.msgDiag.logErroreGenerico(e, "EliminazioneMessaggioInbox(" + idMsgDaEliminare + ")");
                    }
                }
                this.msgDiag.addKeyword("@TIPO_RICERCA@", "MessaggiCompletati");
                this.msgDiag.addKeyword("@TIPO_MESSAGGIO@", "OUTBOX");
                for (i = 0; i < idMsgInutiliOUTBOX.size(); ++i) {
                    idMsgDaEliminare = idMsgInutiliOUTBOX.get(i);
                    this.msgDiag.addKeyword("@ID_EGOV_DA_ELIMINARE@", idMsgDaEliminare);
                    try {
                        gestoreMsg = new GestoreMessaggi(openspcoopstate, true, idMsgDaEliminare, "OUTBOX", this.msgDiag);
                        gestoreMsg.deleteMessage();
                        this.msgDiag.logPersonalizzato("eliminazioneMessaggio");
                        continue;
                    }
                    catch (Exception e) {
                        this.msgDiag.logErroreGenerico(e, "EliminazioneMessaggioOutbox(" + idMsgDaEliminare + ")");
                    }
                }
                this.msgDiag.addKeyword("@TIPO_RICERCA@", "MessaggiScaduti");
                this.msgDiag.addKeyword("@TIPO_MESSAGGIO@", "INBOX");
                for (i = 0; i < idMsgScadutiINBOX.size(); ++i) {
                    idMsgDaEliminare = idMsgScadutiINBOX.get(i);
                    this.msgDiag.addKeyword("@ID_EGOV_DA_ELIMINARE@", idMsgDaEliminare);
                    try {
                        gestoreMsg = new GestoreMessaggi(openspcoopstate, true, idMsgDaEliminare, "INBOX", this.msgDiag);
                        rollbackEGovMessaggio = new RollbackRepositoryEGov(idMsgDaEliminare, openspcoopstate.getStatoRichiesta(), true);
                        rollbackEGovMessaggio.rollbackBustaIntoInBox();
                        rifMsg = gestoreMsg.getRiferimentoMessaggio();
                        if (rifMsg == null) {
                            if (receiverJMS != null && receiverJMS.clean("RicezioneBusteEGov", strMessageSelector = "ID = '" + idMsgDaEliminare + "'")) {
                                this.msgDiag.addKeyword("@CODA_JMS_RICEZIONE@", "RicezioneBusteEGov");
                                this.msgDiag.addKeyword("@RICERCA_TRAMITE_RIFERIMENTO@", "false");
                                this.msgDiag.logPersonalizzato("messaggioNonConsumato.codaJMS");
                            }
                        } else {
                            rollbackEGovRepository = new RollbackRepositoryEGov(rifMsg, openspcoopstate.getStatoRichiesta(), true);
                            rollbackEGovRepository.rollbackBustaIntoOutBox(false);
                            if (receiverJMS != null && receiverJMS.clean("RicezioneContenutiApplicativi", strMessageSelector = "ID = '" + rifMsg + "'")) {
                                this.msgDiag.addKeyword("@CODA_JMS_RICEZIONE@", "RicezioneContenutiApplicativi");
                                this.msgDiag.addKeyword("@RICERCA_TRAMITE_RIFERIMENTO@", "true");
                                this.msgDiag.logPersonalizzato("messaggioNonConsumato.codaJMS");
                            }
                        }
                        ((StateMessage)openspcoopstate.getStatoRichiesta()).executePreparedStatement();
                        gestoreMsg.deleteMessage();
                        this.msgDiag.logPersonalizzato("eliminazioneMessaggio");
                        continue;
                    }
                    catch (Exception e) {
                        ((StateMessage)openspcoopstate.getStatoRichiesta()).closePreparedStatement();
                        this.msgDiag.logErroreGenerico(e, "EliminazioneMessaggioScadutoInbox(" + idMsgDaEliminare + ")");
                    }
                }
                this.msgDiag.addKeyword("@TIPO_RICERCA@", "MessaggiScaduti");
                this.msgDiag.addKeyword("@TIPO_MESSAGGIO@", "OUTBOX");
                for (i = 0; i < idMsgScadutiOUTBOX.size(); ++i) {
                    idMsgDaEliminare = idMsgScadutiOUTBOX.get(i);
                    this.msgDiag.addKeyword("@ID_EGOV_DA_ELIMINARE@", idMsgDaEliminare);
                    try {
                        gestoreMsg = new GestoreMessaggi(openspcoopstate, true, idMsgDaEliminare, "OUTBOX", this.msgDiag);
                        rollbackEGovMessaggio = new RollbackRepositoryEGov(idMsgDaEliminare, openspcoopstate.getStatoRichiesta(), true);
                        rollbackEGovMessaggio.rollbackBustaIntoOutBox();
                        rifMsg = gestoreMsg.getRiferimentoMessaggio();
                        if (rifMsg == null) {
                            if (receiverJMS != null && receiverJMS.clean("RicezioneContenutiApplicativi", strMessageSelector = "ID = '" + idMsgDaEliminare + "'")) {
                                this.msgDiag.addKeyword("@CODA_JMS_RICEZIONE@", "RicezioneContenutiApplicativi");
                                this.msgDiag.addKeyword("@RICERCA_TRAMITE_RIFERIMENTO@", "false");
                                this.msgDiag.logPersonalizzato("messaggioNonConsumato.codaJMS");
                            }
                        } else {
                            rollbackEGovRepository = new RollbackRepositoryEGov(rifMsg, openspcoopstate.getStatoRichiesta(), true);
                            rollbackEGovRepository.rollbackBustaIntoInBox(false);
                            if (receiverJMS != null && receiverJMS.clean("RicezioneBusteEGov", strMessageSelector = "ID = '" + rifMsg + "'")) {
                                this.msgDiag.addKeyword("@CODA_JMS_RICEZIONE@", "RicezioneBusteEGov");
                                this.msgDiag.addKeyword("@RICERCA_TRAMITE_RIFERIMENTO@", "true");
                                this.msgDiag.logPersonalizzato("messaggioNonConsumato.codaJMS");
                            }
                        }
                        ((StateMessage)openspcoopstate.getStatoRichiesta()).executePreparedStatement();
                        gestoreMsg.deleteMessage();
                        this.msgDiag.logPersonalizzato("eliminazioneMessaggio");
                        continue;
                    }
                    catch (Exception e) {
                        ((StateMessage)openspcoopstate.getStatoRichiesta()).closePreparedStatement();
                        this.msgDiag.logErroreGenerico(e, "EliminazioneMessaggioScadutoOutbox(" + idMsgDaEliminare + ")");
                    }
                }
                this.msgDiag.addKeyword("@TIPO_RICERCA@", "MessaggiNonGestitiRicezioneContenutiApplicativi");
                this.msgDiag.addKeyword("@TIPO_MESSAGGIO@", "INBOX");
                for (i = 0; i < idMsgServizioRicezioneContenutiApplicativiNonGestiti.size(); ++i) {
                    idMsgDaEliminare = idMsgServizioRicezioneContenutiApplicativiNonGestiti.get(i);
                    String idEGovDaEliminare = idMsgDaEliminare.split("@")[0];
                    String servizioApplicativoDaEliminare = idMsgDaEliminare.split("@")[1];
                    this.msgDiag.addKeyword("@ID_EGOV_DA_ELIMINARE@", idEGovDaEliminare);
                    try {
                        String strMessageSelector2;
                        String rifMsg2;
                        gestoreMsg = new GestoreMessaggi(openspcoopstate, true, idEGovDaEliminare, "INBOX", this.msgDiag);
                        if (receiverJMS != null && (rifMsg2 = gestoreMsg.getRiferimentoMessaggio()) != null && receiverJMS.clean("RicezioneContenutiApplicativi", strMessageSelector2 = "ID = '" + rifMsg2 + "'")) {
                            this.msgDiag.addKeyword("@CODA_JMS_RICEZIONE@", "RicezioneContenutiApplicativi");
                            this.msgDiag.addKeyword("@RICERCA_TRAMITE_RIFERIMENTO@", "true");
                            this.msgDiag.logPersonalizzato("messaggioNonConsumato.codaJMS");
                        }
                        gestoreMsg.eliminaDestinatarioMessaggio(servizioApplicativoDaEliminare, gestoreMsg.getRiferimentoMessaggio());
                        if (!gestoreMsg.existsServiziApplicativiDestinatariMessaggio()) {
                            rollbackEGovMessaggio = new RollbackRepositoryEGov(idEGovDaEliminare, openspcoopstate.getStatoRichiesta(), true);
                            rollbackEGovMessaggio.rollbackBustaIntoInBox();
                            ((StateMessage)openspcoopstate.getStatoRichiesta()).executePreparedStatement();
                        }
                        this.msgDiag.logPersonalizzato("eliminazioneDestinatarioMessaggio");
                        continue;
                    }
                    catch (Exception e) {
                        if (rollbackEGovMessaggio != null) {
                            ((StateMessage)openspcoopstate.getStatoRichiesta()).closePreparedStatement();
                            rollbackEGovMessaggio = null;
                        }
                        this.msgDiag.logErroreGenerico(e, "EliminazioneMessaggioRicezioneContenutiApplicativiNonGestiti(" + idMsgDaEliminare + ")");
                    }
                }
                this.msgDiag.addKeyword("@TIPO_RICERCA@", "MessaggiNonGestitiRicezioneBusteEGov");
                this.msgDiag.addKeyword("@TIPO_MESSAGGIO@", "OUTBOX");
                for (i = 0; i < idMsgServizioRicezioneBusteEGovNonGestiti.size(); ++i) {
                    idMsgDaEliminare = idMsgServizioRicezioneBusteEGovNonGestiti.get(i);
                    this.msgDiag.addKeyword("@ID_EGOV_DA_ELIMINARE@", idMsgDaEliminare);
                    try {
                        gestoreMsg = new GestoreMessaggi(openspcoopstate, true, idMsgDaEliminare, "OUTBOX", this.msgDiag);
                        rollbackEGovMessaggio = new RollbackRepositoryEGov(idMsgDaEliminare, openspcoopstate.getStatoRichiesta(), true);
                        rollbackEGovMessaggio.rollbackBustaIntoOutBox();
                        ((StateMessage)openspcoopstate.getStatoRichiesta()).executePreparedStatement();
                        if (receiverJMS != null && (rifMsg = gestoreMsg.getRiferimentoMessaggio()) != null && receiverJMS.clean("RicezioneBusteEGov", strMessageSelector = "ID = '" + rifMsg + "'")) {
                            this.msgDiag.addKeyword("@CODA_JMS_RICEZIONE@", "RicezioneBusteEGov");
                            this.msgDiag.addKeyword("@RICERCA_TRAMITE_RIFERIMENTO@", "false");
                            this.msgDiag.logPersonalizzato("messaggioNonConsumato.codaJMS");
                        }
                        gestoreMsg.deleteMessage();
                        this.msgDiag.logPersonalizzato("eliminazioneMessaggio");
                        continue;
                    }
                    catch (Exception e) {
                        if (rollbackEGovMessaggio != null) {
                            ((StateMessage)openspcoopstate.getStatoRichiesta()).closePreparedStatement();
                            rollbackEGovMessaggio = null;
                        }
                        this.msgDiag.logErroreGenerico(e, "EliminazioneMessaggioRicezioneBusteEGovNonGestiti(" + idMsgDaEliminare + ")");
                    }
                }
                idMsgInutiliINBOX = gestoreMsgSearch.readMessaggiInutiliIntoInbox("GestoreMessaggi", 200, this.logQuery);
                idMsgInutiliOUTBOX = gestoreMsgSearch.readMessaggiInutiliIntoOutbox("GestoreMessaggi", 200, this.logQuery);
                idMsgScadutiINBOX = gestoreMsgSearch.readMessaggiScadutiIntoInbox(this.scadenzaMessaggio, 200, this.logQuery);
                idMsgScadutiOUTBOX = gestoreMsgSearch.readMessaggiScadutiIntoOutbox(this.scadenzaMessaggio, 200, this.logQuery);
                idMsgServizioRicezioneContenutiApplicativiNonGestiti = gestoreMsgSearch.readMsgForRicezioneContenutiApplicativiNonGestiti(timeoutRicezioneContenutiApplicativiNonGestiti, 200, this.logQuery);
                idMsgServizioRicezioneBusteEGovNonGestiti = gestoreMsgSearch.readMsgForRicezioneBusteEGovNonGestiti(timeoutRicezioneBusteEGovNonGestiti, 200, this.logQuery);
            }
            GestoreCorrelazioneApplicativa gestoreCorrelazioneApplicativa = new GestoreCorrelazioneApplicativa(openspcoopstate.getStatoRichiesta(), this.log, this.propertiesReader.getRepositoryIntervalloScadenzaMessaggi());
            int offsetCorrelazioni = 0;
            Vector<Long> correlazioni = gestoreCorrelazioneApplicativa.getCorrelazioniScadute(200, offsetCorrelazioni, this.logQuery);
            this.msgDiag.addKeyword("@TIPO_RICERCA@", "CorrelazioniApplicative");
            while (correlazioni.size() > 0) {
                this.msgDiag.addKeyword("@NUMERO_CORRELAZIONI_APPLICATIVE@", correlazioni.size() + "");
                this.msgDiag.logPersonalizzato("ricercaCorrelazioniApplicativeScadute");
                while (correlazioni.size() > 0) {
                    Long idCorrelazioneScaduta = correlazioni.remove(0);
                    String idEGovCorrelato = null;
                    String idApplicativo = null;
                    try {
                        String[] id = gestoreCorrelazioneApplicativa.getIDMappingCorrelazioneApplicativa(idCorrelazioneScaduta);
                        this.msgDiag.addKeyword("@ID_EGOV_DA_ELIMINARE@", id[0]);
                        this.msgDiag.addKeyword("@ID_CORRELAZIONE_APPLICATIVA@", id[1]);
                        gestoreCorrelazioneApplicativa.deleteCorrelazioneApplicativa(idCorrelazioneScaduta);
                        this.msgDiag.logPersonalizzato("eliminazioneCorrelazioneApplicativaScaduta");
                    }
                    catch (Exception e) {
                        this.msgDiag.logErroreGenerico(e, "EliminazioneCorrelazioni(id_applicativo:" + idApplicativo + ",id_egov:" + idEGovCorrelato + ")");
                    }
                }
                correlazioni = gestoreCorrelazioneApplicativa.getCorrelazioniScadute(200, offsetCorrelazioni += correlazioni.size(), this.logQuery);
            }
            if (this.propertiesReader.isTimerGestoreMessaggiVerificaConnessioniAttive()) {
                Enumeration<String> identificatoriConnettoriPA;
                this.log.debug((Object)"Verifico connessioni attive...");
                Enumeration<String> identificatoriConnettoriPD = RepositoryConnettori.getIdentificatoriConnettori_pd();
                if (identificatoriConnettoriPD != null) {
                    while (identificatoriConnettoriPD.hasMoreElements()) {
                        String identificatoreEgovConnessione = identificatoriConnettoriPD.nextElement();
                        String tipoConnettore = null;
                        IConnettore connettore = null;
                        try {
                            connettore = RepositoryConnettori.getConnettorePD(identificatoreEgovConnessione);
                            if (connettore != null) {
                                tipoConnettore = connettore.getClass().getSimpleName();
                            }
                            int millisecondiScadenza = this.propertiesReader.getConnectionLife_inoltroBusteEGov();
                            Date now = DateManager.getDate();
                            Date scadenza = new Date(now.getTime() - (long)millisecondiScadenza);
                            String tipoConnessione = "tipo:" + tipoConnettore + " porta:delegata id_egov:" + identificatoreEgovConnessione;
                            this.log.debug((Object)"--------------------------------------");
                            this.log.debug((Object)tipoConnessione);
                            this.log.debug((Object)("SCADENZA [" + scadenza.toString() + "]   CONNETTORE [" + connettore.getCreationDate().toString() + "]"));
                            if (connettore.getCreationDate().before(scadenza)) {
                                this.log.debug((Object)"SCADUTO");
                                this.msgDiag.addKeyword("@TIPO_CONNESSIONE@", tipoConnessione);
                                this.msgDiag.addKeyword("@DATA_CREAZIONE_CONNESSIONE@", connettore.getCreationDate().toString());
                                this.msgDiag.logPersonalizzato("connessioneScaduta.EliminazioneInCorso");
                                connettore = RepositoryConnettori.removeConnettorePD(identificatoreEgovConnessione);
                                if (connettore != null) {
                                    connettore.disconnect();
                                }
                                this.msgDiag.logPersonalizzato("connessioneScaduta.EliminazioneEffettuata");
                            } else {
                                this.log.debug((Object)"NON SCADUTO");
                            }
                            this.log.debug((Object)"--------------------------------------");
                        }
                        catch (Exception e) {
                            if (tipoConnettore != null) {
                                this.msgDiag.logErroreGenerico(e, "EliminazioneConnessione(tipo:" + tipoConnettore + " porta:delegata id_egov:" + identificatoreEgovConnessione + ")");
                                continue;
                            }
                            this.msgDiag.logErroreGenerico(e, "EliminazioneConnessione(porta:delegata id_egov:" + identificatoreEgovConnessione + ")");
                        }
                        catch (Throwable e) {
                            if (tipoConnettore != null) {
                                this.msgDiag.logErroreGenerico(e, "EliminazioneConnessione(tipo:" + tipoConnettore + " porta:delegata id_egov:" + identificatoreEgovConnessione + ")");
                                continue;
                            }
                            this.msgDiag.logErroreGenerico(e, "EliminazioneConnessione(porta:delegata id_egov:" + identificatoreEgovConnessione + ")");
                        }
                    }
                }
                if ((identificatoriConnettoriPA = RepositoryConnettori.getIdentificatoriConnettori_pa()) != null) {
                    while (identificatoriConnettoriPA.hasMoreElements()) {
                        String identificatoreEgovConnessione = identificatoriConnettoriPA.nextElement();
                        String tipoConnettore = null;
                        IConnettore connettore = null;
                        try {
                            connettore = RepositoryConnettori.getConnettorePA(identificatoreEgovConnessione);
                            if (connettore != null) {
                                tipoConnettore = connettore.getClass().getSimpleName();
                            }
                            int millisecondiScadenza = this.propertiesReader.getConnectionLife_inoltroBusteEGov();
                            Date now = DateManager.getDate();
                            Date scadenza = new Date(now.getTime() - (long)millisecondiScadenza);
                            String tipoConnessione = "tipo:" + tipoConnettore + " porta:applicativa id_egov:" + identificatoreEgovConnessione;
                            this.log.debug((Object)"--------------------------------------");
                            this.log.debug((Object)tipoConnessione);
                            this.log.debug((Object)("SCADENZA [" + scadenza.toString() + "]   CONNETTORE [" + connettore.getCreationDate().toString() + "]"));
                            if (connettore.getCreationDate().before(scadenza)) {
                                this.log.debug((Object)"SCADUTO");
                                this.msgDiag.addKeyword("@TIPO_CONNESSIONE@", tipoConnessione);
                                this.msgDiag.addKeyword("@DATA_CREAZIONE_CONNESSIONE@", connettore.getCreationDate().toString());
                                this.msgDiag.logPersonalizzato("connessioneScaduta.EliminazioneInCorso");
                                connettore = RepositoryConnettori.removeConnettorePA(identificatoreEgovConnessione);
                                if (connettore != null) {
                                    connettore.disconnect();
                                }
                                this.msgDiag.logPersonalizzato("connessioneScaduta.EliminazioneEffettuata");
                            } else {
                                this.log.debug((Object)"NON SCADUTO");
                            }
                            this.log.debug((Object)"--------------------------------------");
                        }
                        catch (Exception e) {
                            if (tipoConnettore != null) {
                                this.msgDiag.logErroreGenerico(e, "EliminazioneConnessione(tipo:" + tipoConnettore + " porta:applicativa id_egov:" + identificatoreEgovConnessione + ")");
                                continue;
                            }
                            this.msgDiag.logErroreGenerico(e, "EliminazioneConnessione(porta:applicativa id_egov:" + identificatoreEgovConnessione + ")");
                        }
                        catch (Throwable e) {
                            if (tipoConnettore != null) {
                                this.msgDiag.logErroreGenerico(e, "EliminazioneConnessione(tipo:" + tipoConnettore + " porta:applicativa id_egov:" + identificatoreEgovConnessione + ")");
                                continue;
                            }
                            this.msgDiag.logErroreGenerico(e, "EliminazioneConnessione(porta:applicativa id_egov:" + identificatoreEgovConnessione + ")");
                        }
                    }
                }
            } else {
                this.log.debug((Object)"Non verifico connessioni attive");
            }
        }
        catch (Exception e) {
            this.msgDiag.logErroreGenerico(e, "GestioneMessaggi");
        }
        finally {
            if (openspcoopstate != null) {
                openspcoopstate.releaseResource();
            }
        }
    }
}

