/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop.pdd.timers;

import java.sql.Timestamp;
import java.util.Date;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.openspcoop.dao.commons.IDSoggetto;
import org.openspcoop.dao.config.PortaDelegata;
import org.openspcoop.dao.config.ServizioApplicativo;
import org.openspcoop.dao.config.driver.DriverConfigurazioneNotFound;
import org.openspcoop.dao.config.driver.IDPortaDelegata;
import org.openspcoop.dao.registry.driver.IDServizio;
import org.openspcoop.dao.state.IState;
import org.openspcoop.dao.state.StateMessage;
import org.openspcoop.dao.state.StatelessMessage;
import org.openspcoop.egov.Busta;
import org.openspcoop.egov.Integrazione;
import org.openspcoop.egov.ProfiloDiCollaborazione;
import org.openspcoop.egov.ProprietaErroreApplicativo;
import org.openspcoop.egov.RepositoryEGov;
import org.openspcoop.egov.Riscontri;
import org.openspcoop.egov.RollbackRepositoryEGov;
import org.openspcoop.pdd.config.ConfigurazionePdDReader;
import org.openspcoop.pdd.config.OpenSPCoopProperties;
import org.openspcoop.pdd.config.RichiestaDelegata;
import org.openspcoop.pdd.core.EJBUtils;
import org.openspcoop.pdd.core.GestoreMessaggi;
import org.openspcoop.pdd.core.PdDContext;
import org.openspcoop.pdd.core.node.INodeSender;
import org.openspcoop.pdd.core.state.OpenSPCoopStateful;
import org.openspcoop.pdd.core.state.OpenSPCoopStateless;
import org.openspcoop.pdd.logger.MsgDiagnostico;
import org.openspcoop.pdd.mdb.InoltroBusteEGovMessage;
import org.openspcoop.pdd.services.OpenSPCoopStartup;
import org.openspcoop.pdd.timers.TimerException;
import org.openspcoop.pdd.timers.TimerMonitoraggioRisorse;
import org.openspcoop.registry.RegistroServiziReader;
import org.openspcoop.utils.date.DateManager;

public class TimerGestoreBusteNonRiscontrateLib {
    private MsgDiagnostico msgDiag = null;
    private Logger log = null;
    private OpenSPCoopProperties propertiesReader = null;
    private boolean logQuery = false;
    private long timeout = 10L;
    private ConfigurazionePdDReader configurazionePdDReader;
    private RegistroServiziReader registroServiziReader;
    private static INodeSender nodeSender = null;
    private static String tipoNodeSender = null;

    public TimerGestoreBusteNonRiscontrateLib(MsgDiagnostico msgDiag, Logger log, OpenSPCoopProperties p, boolean logQuery, long timeout, ConfigurazionePdDReader configurazionePdDReader, RegistroServiziReader registroServiziReader) throws TimerException {
        this.msgDiag = msgDiag;
        this.log = log;
        this.propertiesReader = p;
        this.logQuery = logQuery;
        this.timeout = timeout;
        this.configurazionePdDReader = configurazionePdDReader;
        this.registroServiziReader = registroServiziReader;
        if (nodeSender == null) {
            try {
                nodeSender = EJBUtils.getNodeSender(this.propertiesReader, this.log);
                tipoNodeSender = this.propertiesReader.getNodeSender();
            }
            catch (Exception e) {
                throw new TimerException("Riscontrato errore durante l'inizializzazione del Thread GestoreBusteNonRiscontrate (NodeSender): " + e.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void check() throws TimerException {
        if (!OpenSPCoopStartup.initialize) {
            this.msgDiag.logFatalError("inizializzazione di OpenSPCoop non effettuata", "Check Inizializzazione");
            throw new TimerException("Riscontrato errore: inizializzazione del Timer o di OpenSPCoop non effettuata");
        }
        if (!TimerMonitoraggioRisorse.risorseDisponibili) {
            this.log.error((Object)("[GestoreBusteNonRiscontrate] Risorse di sistema non disponibili: " + TimerMonitoraggioRisorse.risorsaNonDisponibile.getMessage()), (Throwable)TimerMonitoraggioRisorse.risorsaNonDisponibile);
            return;
        }
        if (!MsgDiagnostico.gestoreDiagnosticaDisponibile) {
            this.log.error((Object)("[GestoreRepositoryEGov] Sistema di diagnostica non disponibile: " + MsgDiagnostico.motivoMalfunzionamentoDiagnostici.getMessage()), (Throwable)MsgDiagnostico.motivoMalfunzionamentoDiagnostici);
            return;
        }
        if (this.configurazionePdDReader.getTimeoutRiscontro() < 1L) {
            this.msgDiag.logErroreGenerico("timeout per le buste non riscontrate: is <= 0 ??", "getTimeoutRiscontro()");
            return;
        }
        this.timeout = this.configurazionePdDReader.getTimeoutRiscontro();
        String minuti = "minuti";
        if (this.timeout == 1L) {
            minuti = "minuto";
        }
        this.msgDiag.addKeyword("@TIMEOUT@", this.timeout + " " + minuti);
        this.msgDiag.logPersonalizzato("controlloInCorso");
        GestoreMessaggi gestoreMsg = null;
        RepositoryEGov repositoryEGov = null;
        Riscontri gestoreRiscontri = null;
        RollbackRepositoryEGov rollbackRepositoryEGov = null;
        OpenSPCoopStateful openspcoopState = new OpenSPCoopStateful();
        try {
            openspcoopState.initResource(this.propertiesReader.getIdentitaPortaDefault(), "GestoreBusteNonRiscontrate");
            Riscontri rBuste = new Riscontri(openspcoopState.getStatoRichiesta());
            int offsetRiscontri = 0;
            Vector busteOneWayToSend = rBuste.getBustePerUlterioreInoltro(this.timeout, 200, offsetRiscontri, this.logQuery);
            while (busteOneWayToSend != null && busteOneWayToSend.size() > 0) {
                for (int i = 0; i < busteOneWayToSend.size(); ++i) {
                    Busta bustaToSend = (Busta)busteOneWayToSend.get(i);
                    this.msgDiag.addKeywords(bustaToSend, true);
                    Date scadenza = bustaToSend.getScadenza();
                    Timestamp now = DateManager.getTimestamp();
                    if (scadenza.before(now)) {
                        this.msgDiag.logPersonalizzato("bustaNonRiscontrataScaduta");
                        try {
                            repositoryEGov = new RepositoryEGov(openspcoopState.getStatoRichiesta(), true);
                            repositoryEGov.eliminaUtilizzoPdDFromOutBox(bustaToSend.getID());
                            ((StateMessage)openspcoopState.getStatoRichiesta()).executePreparedStatement();
                            gestoreMsg = new GestoreMessaggi(openspcoopState, true, bustaToSend.getID(), "OUTBOX", this.msgDiag);
                            gestoreMsg.validateAndDeleteMsgOneWayRiscontrato();
                        }
                        catch (Exception e) {
                            this.msgDiag.logErroreGenerico(e, "EliminazioneBustaNonRiscontrataScaduta(" + bustaToSend.getID() + ")");
                        }
                        continue;
                    }
                    this.msgDiag.logPersonalizzato("bustaNonRiscontrata");
                    try {
                        ServizioApplicativo sa;
                        IDPortaDelegata idPD;
                        RichiestaDelegata richiestaDelegata;
                        ProprietaErroreApplicativo erroreAppl;
                        IDServizio servizioBusta;
                        GestoreMessaggi messaggioDaInviare;
                        block62: {
                            messaggioDaInviare = new GestoreMessaggi(openspcoopState, true, bustaToSend.getID(), "OUTBOX", this.log, this.msgDiag);
                            if (!messaggioDaInviare.existsMessage_noCache()) {
                                this.msgDiag.logPersonalizzato("bustaNonRiscontrata.messaggioNonEsistente");
                                try {
                                    repositoryEGov = new RepositoryEGov(openspcoopState.getStatoRichiesta(), true);
                                    repositoryEGov.eliminaUtilizzoPdDFromOutBox(bustaToSend.getID());
                                    gestoreRiscontri = new Riscontri(openspcoopState.getStatoRichiesta());
                                    gestoreRiscontri.validazioneRiscontroRicevuto(bustaToSend.getID());
                                    ((StateMessage)openspcoopState.getStatoRichiesta()).executePreparedStatement();
                                }
                                catch (Exception e) {
                                    this.msgDiag.logErroreGenerico(e, "EliminazioneBustaNonRiscontrataNonEsistente(" + bustaToSend.getID() + ")");
                                }
                                continue;
                            }
                            IDSoggetto soggettoBustaNonRiscontrata = new IDSoggetto(bustaToSend.getTipoMittente(), bustaToSend.getMittente());
                            IDSoggetto identitaPdD = null;
                            String dominioRD = null;
                            try {
                                dominioRD = this.configurazionePdDReader.getDominio(soggettoBustaNonRiscontrata);
                                if (dominioRD == null) {
                                    throw new Exception("Dominio is null");
                                }
                            }
                            catch (Exception e) {
                                this.msgDiag.logErroreGenerico(e, "BustaNonRiscontrata getDominio(" + soggettoBustaNonRiscontrata + ")");
                            }
                            identitaPdD = dominioRD == null ? this.propertiesReader.getIdentitaPortaDefault() : new IDSoggetto(bustaToSend.getTipoMittente(), bustaToSend.getMittente(), dominioRD);
                            servizioBusta = new IDServizio(bustaToSend.getTipoDestinatario(), bustaToSend.getDestinatario(), bustaToSend.getTipoServizio(), bustaToSend.getServizio(), bustaToSend.getAzione());
                            repositoryEGov = new RepositoryEGov(openspcoopState.getStatoRichiesta(), true);
                            Integrazione infoIntegrazione = repositoryEGov.getInfoIntegrazioneFromOutBox(bustaToSend.getID());
                            erroreAppl = this.propertiesReader.getProprietaGestioneErrorePD();
                            erroreAppl.setDominio(identitaPdD.getCodicePorta());
                            richiestaDelegata = new RichiestaDelegata(soggettoBustaNonRiscontrata, infoIntegrazione.getLocationPD(), infoIntegrazione.getServizioApplicativo(), servizioBusta, infoIntegrazione.getIdModuloInAttesa(), erroreAppl, identitaPdD);
                            richiestaDelegata.setScenario(infoIntegrazione.getScenario());
                            richiestaDelegata.setUtilizzoConsegnaAsincrona(true);
                            richiestaDelegata.setIdCollaborazione(bustaToSend.getCollaborazione());
                            richiestaDelegata.setProfiloCollaborazione(bustaToSend.getProfiloDiCollaborazione());
                            try {
                                richiestaDelegata.setIdCorrelazioneApplicativa(messaggioDaInviare.getIDCorrelazioneApplicativa());
                            }
                            catch (Exception e) {
                                // empty catch block
                            }
                            idPD = richiestaDelegata.getIdPortaDelegata();
                            idPD.setSoggettoFruitore(soggettoBustaNonRiscontrata);
                            sa = null;
                            String servizioApplicativo = richiestaDelegata.getServizioApplicativo();
                            try {
                                if (servizioApplicativo != null) {
                                    this.configurazionePdDReader.getServizioApplicativo(idPD, servizioApplicativo);
                                }
                            }
                            catch (Exception e) {
                                if (e instanceof DriverConfigurazioneNotFound && "Anonimo".equals(servizioApplicativo)) break block62;
                                throw e;
                            }
                        }
                        String implementazioneMittente = this.registroServiziReader.getImplementazionePdD(new IDSoggetto(bustaToSend.getTipoMittente(), bustaToSend.getMittente()), null);
                        String implementazioneDestinatario = this.registroServiziReader.getImplementazionePdD(new IDSoggetto(bustaToSend.getTipoDestinatario(), bustaToSend.getDestinatario()), null);
                        this.configurazionePdDReader.aggiornaProprietaGestioneErrorePD(erroreAppl, sa);
                        String profiloGestione = this.registroServiziReader.getProfiloGestioneFruizioneServizio(servizioBusta, null);
                        richiestaDelegata.setProfiloGestione(profiloGestione);
                        PortaDelegata pd = this.configurazionePdDReader.getPortaDelegata_SafeMethod(idPD);
                        boolean oneWayStateless = this.configurazionePdDReader.isModalitaStateless(pd, bustaToSend.getProfiloDiCollaborazione());
                        boolean oneWayVersione11 = this.propertiesReader.isGestioneOnewayStateful_1_1() && !oneWayStateless;
                        InoltroBusteEGovMessage inoltroMSG = new InoltroBusteEGovMessage();
                        inoltroMSG.setRichiestaDelegata(richiestaDelegata);
                        inoltroMSG.setBusta(bustaToSend);
                        inoltroMSG.setOneWayVersione11(oneWayVersione11);
                        if (oneWayVersione11) {
                            OpenSPCoopStateless stateless = new OpenSPCoopStateless();
                            StatelessMessage statelessMessage = new StatelessMessage();
                            statelessMessage.setBusta(bustaToSend);
                            stateless.setStatoRichiesta((IState)statelessMessage);
                            inoltroMSG.setOpenspcoopstate(stateless);
                        }
                        inoltroMSG.setImplementazionePdDSoggettoMittente(implementazioneMittente);
                        inoltroMSG.setImplementazionePdDSoggettoDestinatario(implementazioneDestinatario);
                        try {
                            PdDContext pddContext = messaggioDaInviare.getPdDContext();
                            inoltroMSG.setPddContext(pddContext);
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                        gestoreMsg = new GestoreMessaggi(openspcoopState, true, bustaToSend.getID(), "OUTBOX", this.msgDiag);
                        if ("db".equals(tipoNodeSender)) {
                            gestoreMsg.ripristinaMessaggio();
                            continue;
                        }
                        try {
                            nodeSender.send(inoltroMSG, "InoltroBusteEGov", this.msgDiag, this.propertiesReader.getIdentificativoPortaDefault(), "GestoreBusteNonRiscontrate", bustaToSend.getID(), gestoreMsg);
                            continue;
                        }
                        catch (Exception e) {
                            this.log.error((Object)"Spedizione->InoltroBusteEGov non riuscita", (Throwable)e);
                            this.msgDiag.logErroreGenerico(e, "GenericLib.nodeSender.send(InoltroBusteEGov)");
                            if (openspcoopState != null) {
                                openspcoopState.releaseResource();
                            }
                            return;
                        }
                    }
                    catch (Exception e) {
                        this.msgDiag.logErroreGenerico(e, "RespedizioneBustaNonRiscontrata ErroreGenerale(" + bustaToSend.getID() + ")");
                    }
                }
                busteOneWayToSend = rBuste.getBustePerUlterioreInoltro(this.timeout, 200, offsetRiscontri += busteOneWayToSend.size(), this.logQuery);
            }
            ProfiloDiCollaborazione pBuste = new ProfiloDiCollaborazione(openspcoopState.getStatoRichiesta());
            int offsetBusteAsincrone = 0;
            Vector busteAsincroneToSend = pBuste.asincrono_getBusteAsincronePerUlterioreInoltro(this.timeout, 200, offsetBusteAsincrone, this.logQuery);
            while (busteAsincroneToSend != null && busteAsincroneToSend.size() > 0) {
                for (int i = 0; i < busteAsincroneToSend.size(); ++i) {
                    Busta bustaToSend = (Busta)busteAsincroneToSend.get(i);
                    this.msgDiag.addKeywords(bustaToSend, true);
                    Date scadenza = bustaToSend.getScadenza();
                    Timestamp now = DateManager.getTimestamp();
                    if (scadenza.before(now)) {
                        this.msgDiag.logPersonalizzato("ricevutaAsincronaNonRicevuta.bustaScaduta");
                        try {
                            rollbackRepositoryEGov = new RollbackRepositoryEGov(bustaToSend.getID(), openspcoopState.getStatoRichiesta(), true);
                            rollbackRepositoryEGov.rollbackBustaIntoOutBox();
                            ((StateMessage)openspcoopState.getStatoRichiesta()).executePreparedStatement();
                            gestoreMsg = new GestoreMessaggi(openspcoopState, true, bustaToSend.getID(), "OUTBOX", this.msgDiag);
                            gestoreMsg.deleteMessage();
                        }
                        catch (Exception e) {
                            this.msgDiag.logErroreGenerico(e, "EliminazioneBustaAsincronaScaduta(" + bustaToSend.getID() + ")");
                        }
                        continue;
                    }
                    this.msgDiag.logPersonalizzato("ricevutaAsincronaNonRicevuta");
                    try {
                        ServizioApplicativo sa;
                        RichiestaDelegata richiestaDelegata;
                        ProprietaErroreApplicativo erroreAppl;
                        GestoreMessaggi messaggioDaInviare;
                        block63: {
                            messaggioDaInviare = new GestoreMessaggi(openspcoopState, true, bustaToSend.getID(), "OUTBOX", this.log, this.msgDiag);
                            if (!messaggioDaInviare.existsMessage_noCache()) {
                                this.msgDiag.logPersonalizzato("ricevutaAsincronaNonRicevuta.messaggioNonEsistente");
                                try {
                                    repositoryEGov = new RepositoryEGov(openspcoopState.getStatoRichiesta(), true);
                                    repositoryEGov.eliminaUtilizzoPdDFromOutBox(bustaToSend.getID());
                                    rollbackRepositoryEGov = new RollbackRepositoryEGov(bustaToSend.getID(), openspcoopState.getStatoRichiesta(), true);
                                    rollbackRepositoryEGov.rollbackBustaIntoOutBox();
                                    ((StateMessage)openspcoopState.getStatoRichiesta()).executePreparedStatement();
                                }
                                catch (Exception e) {
                                    this.msgDiag.logErroreGenerico(e, "EliminazioneBustaAsincronaNonEsistente(" + bustaToSend.getID() + ")");
                                }
                                continue;
                            }
                            IDSoggetto soggettoBustaNonRiscontrata = new IDSoggetto(bustaToSend.getTipoMittente(), bustaToSend.getMittente());
                            IDSoggetto identitaPdD = null;
                            String dominioRD = null;
                            try {
                                dominioRD = this.configurazionePdDReader.getDominio(soggettoBustaNonRiscontrata);
                                if (dominioRD == null) {
                                    throw new Exception("Dominio is null");
                                }
                            }
                            catch (Exception e) {
                                this.msgDiag.logErroreGenerico(e, "BustaAsincrona getDominio(" + soggettoBustaNonRiscontrata + ")");
                            }
                            identitaPdD = dominioRD == null ? this.propertiesReader.getIdentitaPortaDefault() : new IDSoggetto(bustaToSend.getTipoMittente(), bustaToSend.getMittente(), dominioRD);
                            IDServizio servizioBusta = new IDServizio(bustaToSend.getTipoDestinatario(), bustaToSend.getDestinatario(), bustaToSend.getTipoServizio(), bustaToSend.getServizio(), bustaToSend.getAzione());
                            repositoryEGov = new RepositoryEGov(openspcoopState.getStatoRichiesta(), true);
                            Integrazione infoIntegrazione = repositoryEGov.getInfoIntegrazioneFromOutBox(bustaToSend.getID());
                            erroreAppl = this.propertiesReader.getProprietaGestioneErrorePD();
                            erroreAppl.setDominio(identitaPdD.getCodicePorta());
                            richiestaDelegata = new RichiestaDelegata(soggettoBustaNonRiscontrata, infoIntegrazione.getLocationPD(), infoIntegrazione.getServizioApplicativo(), servizioBusta, infoIntegrazione.getIdModuloInAttesa(), erroreAppl, identitaPdD);
                            richiestaDelegata.setScenario(infoIntegrazione.getScenario());
                            if ("EGOV_IT_ServizioAsincronoSimmetrico".equals(bustaToSend.getProfiloDiCollaborazione()) && bustaToSend.getRiferimentoMessaggio() == null) {
                                richiestaDelegata.setUtilizzoConsegnaAsincrona(false);
                            } else {
                                richiestaDelegata.setUtilizzoConsegnaAsincrona(true);
                            }
                            richiestaDelegata.setRicevutaAsincrona(false);
                            IDPortaDelegata idPD = richiestaDelegata.getIdPortaDelegata();
                            idPD.setSoggettoFruitore(soggettoBustaNonRiscontrata);
                            sa = null;
                            String servizioApplicativo = richiestaDelegata.getServizioApplicativo();
                            try {
                                if (servizioApplicativo != null) {
                                    this.configurazionePdDReader.getServizioApplicativo(idPD, servizioApplicativo);
                                }
                            }
                            catch (Exception e) {
                                if (e instanceof DriverConfigurazioneNotFound && "Anonimo".equals(servizioApplicativo)) break block63;
                                throw e;
                            }
                        }
                        this.configurazionePdDReader.aggiornaProprietaGestioneErrorePD(erroreAppl, sa);
                        InoltroBusteEGovMessage inoltroMSG = new InoltroBusteEGovMessage();
                        inoltroMSG.setRichiestaDelegata(richiestaDelegata);
                        inoltroMSG.setBusta(bustaToSend);
                        gestoreMsg = new GestoreMessaggi(openspcoopState, true, bustaToSend.getID(), "OUTBOX", this.msgDiag);
                        try {
                            PdDContext pddContext = messaggioDaInviare.getPdDContext();
                            inoltroMSG.setPddContext(pddContext);
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                        if ("db".equals(tipoNodeSender)) {
                            gestoreMsg.ripristinaMessaggio();
                            continue;
                        }
                        try {
                            nodeSender.send(inoltroMSG, "InoltroBusteEGov", this.msgDiag, this.propertiesReader.getIdentificativoPortaDefault(), "GestoreBusteNonRiscontrate", bustaToSend.getID(), gestoreMsg);
                            continue;
                        }
                        catch (Exception e) {
                            this.log.error((Object)"Spedizione->InoltroBusteEGov non riuscita", (Throwable)e);
                            this.msgDiag.logErroreGenerico(e, "Asincrono GenericLib.nodeSender.send(InoltroBusteEGov)");
                            if (openspcoopState != null) {
                                openspcoopState.releaseResource();
                            }
                            return;
                        }
                    }
                    catch (Exception e) {
                        this.log.error((Object)"Send non riuscita", (Throwable)e);
                        this.msgDiag.logErroreGenerico(e, "RespedizioneBustaAsincrona ErroreGenerale(" + bustaToSend.getID() + ")");
                    }
                }
                busteAsincroneToSend = pBuste.asincrono_getBusteAsincronePerUlterioreInoltro(this.timeout, 200, offsetBusteAsincrone += busteAsincroneToSend.size(), this.logQuery);
            }
        }
        catch (Exception e) {
            this.msgDiag.logErroreGenerico(e, "GestioneBusteNonRiscontrate");
            return;
        }
        finally {
            if (openspcoopState != null) {
                openspcoopState.releaseResource();
            }
        }
    }
}

