/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop.pdd.timers;

import java.io.Serializable;
import java.util.Date;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import javax.ejb.TimedObject;
import javax.ejb.Timer;
import javax.ejb.TimerService;
import org.apache.log4j.Logger;
import org.openspcoop.pdd.config.ConfigurazionePdDReader;
import org.openspcoop.pdd.config.OpenSPCoopProperties;
import org.openspcoop.pdd.logger.MsgDiagnostico;
import org.openspcoop.pdd.logger.OpenSPCoopLogger;
import org.openspcoop.pdd.services.OpenSPCoopStartup;
import org.openspcoop.pdd.timers.TimerGestoreBusteNonRiscontrateLib;
import org.openspcoop.registry.RegistroServiziReader;
import org.openspcoop.utils.date.DateManager;

public class TimerGestoreBusteNonRiscontrateImpl
implements SessionBean,
TimedObject {
    private static final long serialVersionUID = 1L;
    private SessionContext sessionContext;
    private Timer timer;
    private long timeout = 10L;
    private OpenSPCoopProperties propertiesReader;
    private ConfigurazionePdDReader configurazionePdDReader;
    private RegistroServiziReader registroServiziReader;
    private MsgDiagnostico msgDiag;
    private Logger log;
    private boolean deployFromOpenSPCoop = false;
    private boolean gestioneAttiva = false;
    private boolean logQuery = false;

    public void ejbCreate() throws CreateException {
        int secondi;
        int attesa = 90;
        for (secondi = 0; !OpenSPCoopStartup.initialize && secondi < attesa; ++secondi) {
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (secondi >= 90) {
            throw new CreateException("Riscontrata inizializzazione OpenSPCoop non effettuata");
        }
        this.log = OpenSPCoopLogger.getLoggerOpenSPCoopCore();
        try {
            this.msgDiag = new MsgDiagnostico("GestoreBusteNonRiscontrate");
            this.msgDiag.setPrefixMsgPersonalizzati("timerGestoreRiscontriRicevute.");
            this.msgDiag.addKeyword("@ID_TIMER_GESTORE_RISCONTRI_RICEVUTE@", "GestoreBusteNonRiscontrate");
        }
        catch (Exception e) {
            this.log.error((Object)"Riscontrato Errore durante l'inizializzazione del MsgDiagnostico", (Throwable)e);
            throw new CreateException("Riscontrato Errore durante l'inizializzazione del MsgDiagnostico per il Thread GestoreBusteNonRiscontrate");
        }
        try {
            this.configurazionePdDReader = ConfigurazionePdDReader.getInstance();
        }
        catch (Exception e) {
            throw new CreateException("Riscontrato Errore durante l'inizializzazione del Reader della Configurazione");
        }
        if (this.configurazionePdDReader.getTimeoutRiscontro() < 1L) {
            this.msgDiag.logErroreGenerico("timeout per le buste non riscontrate: is <= 0 ??", "getTimeoutRiscontro()");
            throw new CreateException("Riscontrato errore durante la lettura del timeout per le buste non riscontrate");
        }
        try {
            this.registroServiziReader = RegistroServiziReader.getInstance();
        }
        catch (Exception e) {
            throw new CreateException("Riscontrato Errore durante l'inizializzazione del Reader del registro dei Servizi");
        }
        try {
            this.timeout = this.configurazionePdDReader.getTimeoutRiscontro();
            String minuti = "minuti";
            if (this.timeout == 1L) {
                minuti = "minuto";
            }
            this.msgDiag.addKeyword("@TIMEOUT@", this.timeout + " " + minuti);
            this.propertiesReader = OpenSPCoopProperties.getInstance();
        }
        catch (Exception e) {
            this.msgDiag.logErroreGenerico(e, "InizializzazioneTimer");
            throw new CreateException("Riscontrato errore durante la lettura dellea configurazione per il Thread GestoreBusteNonRiscontrate");
        }
        this.logQuery = this.propertiesReader.isTimerGestoreRiscontriRicevuteAbilitatoLog();
    }

    public void ejbRemove() throws EJBException {
    }

    public void ejbActivate() throws EJBException {
    }

    public void ejbPassivate() throws EJBException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ejbTimeout(Timer timer) throws EJBException {
        if (!this.deployFromOpenSPCoop) {
            this.stop(timer);
            return;
        }
        if (!this.propertiesReader.isTimerGestoreRiscontriRicevuteAbilitato()) {
            this.msgDiag.logPersonalizzato("disabilitato");
            this.stop(timer);
            return;
        }
        if (timer == null) {
            this.msgDiag.logFatalError("inizializzazione del Timer non effettuata", "Check inizializzazione");
            this.stop(timer);
            return;
        }
        if (!OpenSPCoopStartup.initialize) {
            this.msgDiag.logFatalError("inizializzazione di OpenSPCoop non effettuata", "Check inizializzazione");
            this.stop(timer);
            return;
        }
        if (this.gestioneAttiva) {
            this.msgDiag.logPersonalizzato("precedenteEsecuzioneInCorso");
            return;
        }
        try {
            this.gestioneAttiva = true;
            TimerGestoreBusteNonRiscontrateLib gestoreMessaggiLib = new TimerGestoreBusteNonRiscontrateLib(this.msgDiag, this.log, this.propertiesReader, this.logQuery, this.timeout, this.configurazionePdDReader, this.registroServiziReader);
            gestoreMessaggiLib.check();
        }
        catch (Exception e) {
            this.msgDiag.logErroreGenerico(e, "GestoreRepositoryEGovTimerEJB");
        }
        finally {
            this.gestioneAttiva = false;
        }
    }

    public void setSessionContext(SessionContext aContext) throws EJBException {
        this.sessionContext = aContext;
    }

    public boolean start() throws EJBException {
        if (this.timer != null) {
            this.msgDiag.logPersonalizzato("timerGiaAvviato");
            return false;
        }
        if (this.propertiesReader.isTimerGestoreRiscontriRicevuteAbilitato()) {
            this.deployFromOpenSPCoop = true;
            this.msgDiag.logPersonalizzato("avvioInCorso");
            try {
                Thread.sleep(1000L);
            }
            catch (Exception e) {
                // empty catch block
            }
            Date now = DateManager.getDate();
            long timeout = 60000L * this.timeout;
            try {
                TimerService ts = this.sessionContext.getTimerService();
                this.timer = ts.createTimer(now, timeout, (Serializable)((Object)"GestoreBusteNonRiscontrate"));
                this.msgDiag.logPersonalizzato("avvioEffettuato");
            }
            catch (Exception e) {
                this.stop();
                this.msgDiag.logFatalError(e, "Creazione timer EJB gestore delle buste non riscontrate");
            }
            return this.timer != null;
        }
        this.msgDiag.logPersonalizzato("disabilitato");
        return false;
    }

    public boolean isStarted() throws EJBException {
        return this.timer != null;
    }

    public void stop(Timer atimer) throws EJBException {
        if (atimer != null) {
            atimer.cancel();
        }
    }

    public void stop() throws EJBException {
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
        }
    }
}

