/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop.pdd.services.skeleton;

import java.io.Serializable;
import javax.xml.namespace.QName;
import org.apache.axis.AxisFault;
import org.apache.axis.message.MessageElement;
import org.openspcoop.dao.config.ServizioApplicativo;
import org.openspcoop.dao.config.driver.IDPortaDelegata;
import org.openspcoop.egov.Imbustamento;
import org.openspcoop.egov.ProprietaErroreApplicativo;
import org.openspcoop.egov.XMLBuilder;
import org.openspcoop.pdd.config.ConfigurazionePdDReader;
import org.openspcoop.pdd.config.OpenSPCoopProperties;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SPCoopException
extends AxisFault
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String ECCEZIONE_BUSTA = "EccezioneBusta";
    public static final String ECCEZIONE_PROCESSAMENTO = "EccezioneProcessamento";
    private String oraRegistrazione;
    private String identificativoPorta;
    private String identificativoFunzione;
    private String tipoEccezione;
    private String codiceEccezione;
    private String descrizioneEccezione;
    private OpenSPCoopProperties openspcoopProperties = null;

    public SPCoopException(String codiceEccezione, String descrizioneEccezione, String tipo, String servizioApplicativo) {
        super(descrizioneEccezione);
        this.tipoEccezione = tipo;
        this.oraRegistrazione = Imbustamento.getDate_eGovFormat();
        this.identificativoFunzione = "IntegrationManager";
        this.openspcoopProperties = OpenSPCoopProperties.getInstance();
        ProprietaErroreApplicativo proprietaErroreAppl = this.openspcoopProperties.getProprietaGestioneErrorePD();
        if (servizioApplicativo != null) {
            try {
                ConfigurazionePdDReader configPdDReader = ConfigurazionePdDReader.getInstance();
                ServizioApplicativo sa = configPdDReader.getServizioApplicativo(new IDPortaDelegata(), servizioApplicativo);
                ConfigurazionePdDReader.getInstance().aggiornaProprietaGestioneErrorePD(proprietaErroreAppl, sa);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        this.codiceEccezione = proprietaErroreAppl.transformFaultCode(codiceEccezione);
        this.descrizioneEccezione = descrizioneEccezione;
        this.identificativoPorta = this.openspcoopProperties.getIdentificativoPortaDefault();
        this.buildAxisFault();
    }

    public SPCoopException(String codiceEccezione, String descrizioneEccezione) {
        this(codiceEccezione, descrizioneEccezione, ECCEZIONE_PROCESSAMENTO, null);
    }

    public SPCoopException(String codiceEccezione, String descrizioneEccezione, String servizioApplicativo) {
        this(codiceEccezione, descrizioneEccezione, ECCEZIONE_PROCESSAMENTO, servizioApplicativo);
    }

    public void buildAxisFault() {
        this.setFaultCodeAsString(this.codiceEccezione);
        try {
            XMLBuilder xmlBuilder = new XMLBuilder();
            this.setFaultString(xmlBuilder.buildString_Eccezione(this.identificativoPorta, this.identificativoFunzione, this.codiceEccezione, this.descrizioneEccezione, this.tipoEccezione));
        }
        catch (Exception e) {
            this.setFaultString("Costruzione messaggio errore xml non riuscito: " + e.getMessage() + "\nMessaggio di errore spcoop: " + e.getMessage());
        }
        Element[] details = new Element[1];
        QName name = new QName("org.openspcoop.pdd.services.SPCoopException");
        details[0] = new MessageElement(name);
        QName nameCodiceEccezione = new QName("codiceEccezione");
        MessageElement codiceEccezione = new MessageElement(nameCodiceEccezione);
        codiceEccezione.setValue(this.codiceEccezione);
        details[0].appendChild((Node)codiceEccezione);
        QName nameDescrizioneEccezione = new QName("descrizioneEccezione");
        MessageElement descrizioneEccezione = new MessageElement(nameDescrizioneEccezione);
        descrizioneEccezione.setValue(this.descrizioneEccezione);
        details[0].appendChild((Node)descrizioneEccezione);
        QName nameIdentificativoFunzione = new QName("identificativoFunzione");
        MessageElement identificativoFunzione = new MessageElement(nameIdentificativoFunzione);
        identificativoFunzione.setValue(this.identificativoFunzione);
        details[0].appendChild((Node)identificativoFunzione);
        QName nameIdentificativoPorta = new QName("identificativoPorta");
        MessageElement identificativoPorta = new MessageElement(nameIdentificativoPorta);
        identificativoPorta.setValue(this.identificativoPorta);
        details[0].appendChild((Node)identificativoPorta);
        QName nameOraRegistrazione = new QName("oraRegistrazione");
        MessageElement oraRegistrazione = new MessageElement(nameOraRegistrazione);
        oraRegistrazione.setValue(this.oraRegistrazione);
        details[0].appendChild((Node)oraRegistrazione);
        QName nameTipoEccezione = new QName("tipoEccezione");
        MessageElement tipoEccezione = new MessageElement(nameTipoEccezione);
        tipoEccezione.setValue(this.tipoEccezione);
        details[0].appendChild((Node)tipoEccezione);
        this.setFaultDetail(details);
    }

    public void setCodiceEccezione(String codice) {
        this.codiceEccezione = codice;
    }

    public void setDescrizioneEccezione(String descrizione) {
        this.descrizioneEccezione = descrizione;
    }

    public void setTipoEccezione(String tipo) {
        this.tipoEccezione = tipo;
    }

    public void setOraRegistrazione(String ora) {
        this.oraRegistrazione = ora;
    }

    public void setIdentificativoPorta(String id) {
        this.identificativoPorta = id;
    }

    public void setIdentificativoFunzione(String id) {
        this.identificativoFunzione = id;
    }

    public String getCodiceEccezione() {
        return this.codiceEccezione;
    }

    public String getDescrizioneEccezione() {
        return this.descrizioneEccezione;
    }

    public String getTipoEccezione() {
        return this.tipoEccezione;
    }

    public String getOraRegistrazione() {
        return this.oraRegistrazione;
    }

    public String getIdentificativoPorta() {
        return this.identificativoPorta;
    }

    public String getIdentificativoFunzione() {
        return this.identificativoFunzione;
    }
}

