/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop.pdd.services.skeleton;

import java.sql.Timestamp;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import javax.xml.rpc.server.ServiceLifecycle;
import javax.xml.soap.SOAPFault;
import org.apache.axis.AxisFault;
import org.apache.axis.Message;
import org.apache.axis.MessageContext;
import org.apache.axis.message.MessageElement;
import org.apache.axis.transport.http.HTTPConstants;
import org.apache.log4j.Logger;
import org.openspcoop.dao.commons.IDSoggetto;
import org.openspcoop.dao.commons.TipoPdD;
import org.openspcoop.dao.registry.driver.IDServizio;
import org.openspcoop.egov.Busta;
import org.openspcoop.egov.LetturaParametriBusta;
import org.openspcoop.egov.RepositoryEGov;
import org.openspcoop.pdd.config.ClassNameProperties;
import org.openspcoop.pdd.config.ConfigurazionePdDReader;
import org.openspcoop.pdd.config.OpenSPCoopProperties;
import org.openspcoop.pdd.core.Esito;
import org.openspcoop.pdd.core.EsitoIM;
import org.openspcoop.pdd.core.GestoreMessaggi;
import org.openspcoop.pdd.core.ParametriInvocazionePorta;
import org.openspcoop.pdd.core.ParametriPortaDelegata;
import org.openspcoop.pdd.core.PdDContext;
import org.openspcoop.pdd.core.autenticazione.Credenziali;
import org.openspcoop.pdd.core.autenticazione.GestoreCredenzialiConfigurationException;
import org.openspcoop.pdd.core.autenticazione.IAutenticazione;
import org.openspcoop.pdd.core.autenticazione.IGestoreCredenzialiIM;
import org.openspcoop.pdd.core.connettori.IConnettore;
import org.openspcoop.pdd.core.connettori.InfoConnettoreIngresso;
import org.openspcoop.pdd.core.connettori.RepositoryConnettori;
import org.openspcoop.pdd.core.handlers.GestoreHandlers;
import org.openspcoop.pdd.core.handlers.HandlerException;
import org.openspcoop.pdd.core.handlers.IntegrationManagerRequestContext;
import org.openspcoop.pdd.core.handlers.IntegrationManagerResponseContext;
import org.openspcoop.pdd.core.handlers.PostOutResponseContext;
import org.openspcoop.pdd.core.handlers.PreInRequestContext;
import org.openspcoop.pdd.core.integrazione.HeaderIntegrazione;
import org.openspcoop.pdd.core.state.OpenSPCoopState;
import org.openspcoop.pdd.core.state.OpenSPCoopStateful;
import org.openspcoop.pdd.logger.Dump;
import org.openspcoop.pdd.logger.MsgDiagnostico;
import org.openspcoop.pdd.logger.OpenSPCoopLogger;
import org.openspcoop.pdd.logger.Tracciamento;
import org.openspcoop.pdd.services.OpenSPCoopStartup;
import org.openspcoop.pdd.services.RicezioneContenutiApplicativi;
import org.openspcoop.pdd.services.RicezioneContenutiApplicativiContext;
import org.openspcoop.pdd.services.ServicesUtils;
import org.openspcoop.pdd.services.ServletUtils;
import org.openspcoop.pdd.services.skeleton.Operazione;
import org.openspcoop.pdd.services.skeleton.SPCoopException;
import org.openspcoop.pdd.services.skeleton.SPCoopHeaderInfo;
import org.openspcoop.pdd.services.skeleton.SPCoopMessage;
import org.openspcoop.pdd.timers.TimerMonitoraggioRisorse;
import org.openspcoop.pdd.timers.TimerThreshold;
import org.openspcoop.utils.Loader;
import org.openspcoop.utils.SoapUtils;
import org.openspcoop.utils.date.DateManager;
import org.openspcoop.utils.id.IUniqueIdentifier;
import org.openspcoop.utils.id.UniqueIdentifierManager;
import org.w3c.dom.Element;

public class IntegrationManager
implements ServiceLifecycle {
    public static final String ID_MODULO = "IntegrationManager";
    private OpenSPCoopProperties propertiesReader;
    private ClassNameProperties className;
    private ConfigurazionePdDReader configurazionePdDReader;
    private Hashtable<String, IGestoreCredenzialiIM> gestoriCredenziali = null;
    private String[] tipiGestoriCredenziali = null;

    public void init(Object arg0) {
        this.propertiesReader = OpenSPCoopProperties.getInstance();
        this.className = ClassNameProperties.getInstance();
        this.configurazionePdDReader = ConfigurazionePdDReader.getInstance();
    }

    public void destroy() {
    }

    private InfoConnettoreIngresso buildInfoConnettoreIngresso(HttpServletRequest req, Credenziali credenziali, ParametriInvocazionePorta paramInvokePdD) {
        InfoConnettoreIngresso connettoreIngresso = new InfoConnettoreIngresso();
        connettoreIngresso.setCredenziali(credenziali);
        connettoreIngresso.setFromLocation(ServletUtils.getLocation(req, credenziali));
        connettoreIngresso.setParametersFormBased(paramInvokePdD.getParametersFormBased());
        connettoreIngresso.setParametersTrasporto(paramInvokePdD.getParametersTrasporto());
        connettoreIngresso.setUrlInvocazione(paramInvokePdD.getUrlInvocazione());
        return connettoreIngresso;
    }

    private IntegrationManagerRequestContext buildIMRequestContext(Timestamp dataRichiestaOperazione, Operazione tipoOperazione, PdDContext pddContext, Logger logCore) {
        IntegrationManagerRequestContext imRequestContext = new IntegrationManagerRequestContext(dataRichiestaOperazione, tipoOperazione, pddContext, logCore);
        MessageContext msgContext = MessageContext.getCurrentContext();
        Credenziali credenziali = null;
        HttpServletRequest req = (HttpServletRequest)msgContext.getProperty(HTTPConstants.MC_HTTP_SERVLETREQUEST);
        ParametriInvocazionePorta paramInvokePdD = ServletUtils.getParametriInvocazionePorta(req);
        credenziali = msgContext.getProperty("openspcoop.credenziali") != null ? (Credenziali)msgContext.getProperty("openspcoop.credenziali") : new Credenziali();
        imRequestContext.setConnettore(this.buildInfoConnettoreIngresso(req, credenziali, paramInvokePdD));
        return imRequestContext;
    }

    private synchronized void initializeGestoreCredenziali(MsgDiagnostico msgDiag) throws SPCoopException {
        if (this.gestoriCredenziali == null) {
            Loader loader = Loader.getInstance();
            this.gestoriCredenziali = new Hashtable();
            this.tipiGestoriCredenziali = this.propertiesReader.getTipoGestoreCredenzialiIM();
            if (this.tipiGestoriCredenziali != null) {
                for (int i = 0; i < this.tipiGestoriCredenziali.length; ++i) {
                    String classType = this.className.getGestoreCredenzialiIM(this.tipiGestoriCredenziali[i]);
                    try {
                        IGestoreCredenzialiIM gestore = (IGestoreCredenzialiIM)loader.newInstance(classType);
                        this.gestoriCredenziali.put(this.tipiGestoriCredenziali[i], gestore);
                        continue;
                    }
                    catch (Exception e) {
                        msgDiag.logErroreGenerico(e, "InizializzazioneGestoreCredenziali(" + this.tipiGestoriCredenziali[i] + ")");
                        throw new SPCoopException("OPENSPCOOP_ORG_548", "Sistema non disponibile");
                    }
                }
            }
        }
    }

    private void gestioneCredenziali(MsgDiagnostico msgDiag, InfoConnettoreIngresso infoConnettoreIngresso) throws SPCoopException {
        if (this.gestoriCredenziali == null) {
            this.initializeGestoreCredenziali(msgDiag);
        }
        if (this.tipiGestoriCredenziali != null) {
            msgDiag.mediumDebug("Gestione personalizzata delle credenziali...");
            for (int i = 0; i < this.tipiGestoriCredenziali.length; ++i) {
                try {
                    IGestoreCredenzialiIM gestore = this.gestoriCredenziali.get(this.tipiGestoriCredenziali[i]);
                    if (gestore != null) {
                        Credenziali credenzialiRitornate = gestore.elaborazioneCredenziali(infoConnettoreIngresso);
                        if (credenzialiRitornate == null) {
                            throw new Exception("Credenziali non ritornate");
                        }
                        if (!infoConnettoreIngresso.getCredenziali().equals(credenzialiRitornate)) {
                            String nuoveCredenziali = credenzialiRitornate.toString();
                            nuoveCredenziali = nuoveCredenziali.substring(0, nuoveCredenziali.length() - 1);
                            msgDiag.addKeyword("@NUOVE_CREDENZIALI@", nuoveCredenziali);
                            String identita = gestore.getIdentitaGestoreCredenziali();
                            if (identita == null) {
                                identita = "Gestore delle credenziali di tipo " + this.tipiGestoriCredenziali[i];
                            }
                            msgDiag.addKeyword("@IDENTITA_GESTORE_CREDENZIALI@", identita);
                            msgDiag.logPersonalizzato("gestoreCredenziali.nuoveCredenziali");
                            infoConnettoreIngresso.setCredenziali(credenzialiRitornate);
                        }
                        continue;
                    }
                    throw new Exception("non inizializzato");
                }
                catch (Exception e) {
                    OpenSPCoopLogger.getLoggerOpenSPCoopCore().error((Object)("Errore durante l'identificazione delle credenziali [" + this.tipiGestoriCredenziali[i] + "]: " + e.getMessage()), (Throwable)e);
                    msgDiag.addKeyword("@TIPO_GESTORE_CREDENZIALI@", this.tipiGestoriCredenziali[i]);
                    msgDiag.addKeyword("@ERRORE_PROCESSAMENTO@", e.getMessage());
                    msgDiag.logPersonalizzato("gestoreCredenziali.errore");
                    String codiceErrore = null;
                    String messaggioErrore = null;
                    if (e instanceof GestoreCredenzialiConfigurationException) {
                        codiceErrore = "OPENSPCOOP_ORG_431";
                        messaggioErrore = "Riscontrato errore durante la gestione delle credenziali effettuata tramite il gestore [#MSG_431_GESTORE_KEY#]: ".replace("#MSG_431_GESTORE_KEY#", this.tipiGestoriCredenziali[i]) + e.getMessage();
                    } else {
                        codiceErrore = "OPENSPCOOP_ORG_548";
                        messaggioErrore = "Sistema non disponibile";
                    }
                    throw new SPCoopException(codiceErrore, messaggioErrore);
                }
            }
        }
    }

    private String autenticazione(MsgDiagnostico msgDiag, Credenziali credenziali) throws SPCoopException {
        String credenzialiFornite = "";
        if (credenziali.getUsername() != null || credenziali.getSubject() != null) {
            credenzialiFornite = "(";
            if (credenziali.getUsername() != null) {
                credenzialiFornite = credenziali.getPassword() == null || "".equals(credenziali.getPassword()) ? credenzialiFornite + " Basic Username: " + credenziali.getUsername() + "  Basic Password: non definita" : credenzialiFornite + " Basic Username: " + credenziali.getUsername() + " ";
            }
            if (credenziali.getSubject() != null) {
                credenzialiFornite = credenzialiFornite + " SSL Subject: " + credenziali.getSubject() + " ";
            }
            credenzialiFornite = credenzialiFornite + ") ";
        }
        msgDiag.addKeyword("@CREDENZIALI_SA_FRUITORE@", credenzialiFornite);
        String servizio_applicativo = null;
        String[] tipoAutenticazione = this.configurazionePdDReader.getIntegrationManagerAuthentication();
        if (tipoAutenticazione == null || tipoAutenticazione.length < 1) {
            msgDiag.logPersonalizzato("autenticazioneNonImpostata");
            throw new SPCoopException("OPENSPCOOP_ORG_519", "Sistema non disponibile");
        }
        for (int i = 0; i < tipoAutenticazione.length; ++i) {
            if (!"none".equalsIgnoreCase(tipoAutenticazione[i])) continue;
            msgDiag.logPersonalizzato("autenticazioneNonImpostata");
            throw new SPCoopException("OPENSPCOOP_ORG_519", "Sistema non disponibile");
        }
        Loader loader = Loader.getInstance();
        String codiceErrore = null;
        StringBuffer errori = new StringBuffer();
        for (int i = 0; i < tipoAutenticazione.length; ++i) {
            String authClass = this.className.getAutenticazione(tipoAutenticazione[i]);
            IAutenticazione auth = null;
            try {
                auth = (IAutenticazione)loader.newInstance(authClass);
            }
            catch (Exception e) {
                msgDiag.logErroreGenerico(e, "Autenticazione(" + tipoAutenticazione + ") Class.forName(" + authClass + ")");
                throw new SPCoopException("OPENSPCOOP_ORG_503", "Sistema non disponibile");
            }
            if (!auth.process(credenziali)) {
                if (errori.length() > 0) {
                    errori.append("\n");
                }
            } else {
                servizio_applicativo = auth.getServizioApplicativo();
                break;
            }
            errori.append("(Autenticazione " + tipoAutenticazione[i] + ") " + auth.getMsgError());
            codiceErrore = auth.getCodiceErrore();
        }
        if (servizio_applicativo == null) {
            if (errori.length() > 0) {
                msgDiag.addKeyword("@ERRORE_PROCESSAMENTO@", errori.toString());
                msgDiag.logPersonalizzato("servizioApplicativo.identificazioneTramiteCredenziali");
                throw new SPCoopException(codiceErrore, errori.toString());
            }
            msgDiag.addKeyword("@ERRORE_PROCESSAMENTO@", "servizio applicativo non autenticato");
            msgDiag.logPersonalizzato("servizioApplicativo.identificazioneTramiteCredenziali");
            throw new SPCoopException("OPENSPCOOP_ORG_503", "Sistema non disponibile");
        }
        msgDiag.addKeyword("@SERVIZIO_APPLICATIVO_FRUITORE@", servizio_applicativo);
        msgDiag.addKeyword("@SERVIZIO_APPLICATIVO_EROGATORE@", servizio_applicativo);
        msgDiag.setServizioApplicativo(servizio_applicativo);
        return servizio_applicativo;
    }

    private void verificaRisorseSistema(Logger logCore, String tipoOperazione) throws SPCoopException {
        if (!OpenSPCoopStartup.initialize) {
            logCore.error((Object)("[IntegrationManager][" + tipoOperazione + "] Inizializzazione di OpenSPCoop non correttamente effettuata"));
            throw new SPCoopException("OPENSPCOOP_ORG_501", "Sistema non disponibile");
        }
        if (!TimerMonitoraggioRisorse.risorseDisponibili) {
            logCore.error((Object)("[IntegrationManager][" + tipoOperazione + "] Risorse di sistema non disponibili: " + TimerMonitoraggioRisorse.risorsaNonDisponibile.getMessage()), (Throwable)TimerMonitoraggioRisorse.risorsaNonDisponibile);
            throw new SPCoopException("OPENSPCOOP_ORG_532", "Sistema non disponibile");
        }
        if (!TimerThreshold.freeSpace) {
            logCore.error((Object)("[IntegrationManager][" + tipoOperazione + "] Non sono disponibili abbastanza risorse per la gestione della richiesta"));
            throw new SPCoopException("OPENSPCOOP_ORG_533", "Sistema non disponibile");
        }
        if (!Tracciamento.tracciamentoDisponibile) {
            logCore.error((Object)("[IntegrationManager][" + tipoOperazione + "] Tracciatura e-Gov non disponibile: " + Tracciamento.motivoMalfunzionamentoTracciamento.getMessage()), (Throwable)Tracciamento.motivoMalfunzionamentoTracciamento);
            throw new SPCoopException("OPENSPCOOP_ORG_545", "Sistema non disponibile");
        }
        if (!MsgDiagnostico.gestoreDiagnosticaDisponibile) {
            logCore.error((Object)("[IntegrationManager][" + tipoOperazione + "] Sistema di diagnostica non disponibile: " + MsgDiagnostico.motivoMalfunzionamentoDiagnostici.getMessage()), (Throwable)MsgDiagnostico.motivoMalfunzionamentoDiagnostici);
            throw new SPCoopException("OPENSPCOOP_ORG_546", "Sistema non disponibile");
        }
        if (!Dump.sistemaDumpDisponibile) {
            logCore.error((Object)("[IntegrationManager][" + tipoOperazione + "] Sistema di dump dei contenuti applicativi non disponibile: " + Dump.motivoMalfunzionamentoDump.getMessage()), (Throwable)Dump.motivoMalfunzionamentoDump);
            throw new SPCoopException("OPENSPCOOP_ORG_547", "Sistema non disponibile");
        }
        try {
            this.configurazionePdDReader.verificaConsistenzaConfigurazione();
        }
        catch (Exception e) {
            logCore.error((Object)("[IntegrationManager][" + tipoOperazione + "] Riscontrato errore durante la verifica della consistenza della configurazione PdD"));
            throw new SPCoopException("OPENSPCOOP_ORG_536", "Sistema non disponibile");
        }
    }

    private IUniqueIdentifier getUniqueIdentifier(MsgDiagnostico msgDiag, String tipoOperazione) throws SPCoopException {
        try {
            return UniqueIdentifierManager.newUniqueIdentifier();
        }
        catch (Exception e) {
            msgDiag.logErroreGenerico(e, "getAllMessagesId(" + tipoOperazione + ").getUniqueIdentifier()");
            throw new SPCoopException("OPENSPCOOP_ORG_500", "Sistema non disponibile");
        }
    }

    private MsgDiagnostico getMsgDiagnostico() {
        MsgDiagnostico msgDiag = new MsgDiagnostico(ID_MODULO);
        msgDiag.setPrefixMsgPersonalizzati("integrationManager.");
        return msgDiag;
    }

    /*
     * Loose catch block
     */
    private String[] getAllMessagesId_engine(Operazione tipoOperazione, String tipoServizio, String servizio, String azione, int counter, int offset) throws SPCoopException {
        String[] stringArray;
        IntegrationManagerResponseContext imResponseContext;
        OpenSPCoopState stato;
        String servizio_applicativo;
        MsgDiagnostico msgDiag;
        block30: {
            Timestamp dataRichiestaOperazione = DateManager.getTimestamp();
            Logger logCore = OpenSPCoopLogger.getLoggerOpenSPCoopCore();
            if (logCore == null) {
                logCore = Logger.getLogger((String)ID_MODULO);
            }
            this.verificaRisorseSistema(logCore, tipoOperazione.toString());
            msgDiag = this.getMsgDiagnostico();
            msgDiag.addKeyword("@TIPO_OPERAZIONE_IM@", tipoOperazione.toString());
            servizio_applicativo = null;
            stato = null;
            PdDContext pddContext = new PdDContext();
            pddContext.addObject("ID", this.getUniqueIdentifier(msgDiag, tipoOperazione.toString()).getAsString());
            IDServizio idServizio = new IDServizio();
            idServizio.setTipoServizio(tipoServizio);
            idServizio.setServizio(servizio);
            idServizio.setAzione(azione);
            pddContext.addObject("SERVIZIO", idServizio);
            msgDiag.setPddContext(pddContext);
            IntegrationManagerRequestContext imRequestContext = null;
            try {
                imRequestContext = this.buildIMRequestContext(dataRichiestaOperazione, tipoOperazione, pddContext, logCore);
                GestoreHandlers.integrationManagerRequest(imRequestContext, msgDiag);
            }
            catch (Exception e) {
                if (e instanceof HandlerException) {
                    msgDiag.logErroreGenerico(e, ((HandlerException)e).getIdentitaHandler());
                } else {
                    msgDiag.logErroreGenerico(e, "IntegrationManagerRequestHandler");
                }
                throw new SPCoopException("OPENSPCOOP_ORG_500", "Sistema non disponibile");
            }
            imResponseContext = new IntegrationManagerResponseContext(dataRichiestaOperazione, tipoOperazione, pddContext, logCore);
            this.gestioneCredenziali(msgDiag, imRequestContext.getConnettore());
            servizio_applicativo = this.autenticazione(msgDiag, imRequestContext.getConnettore().getCredenziali());
            imResponseContext.setNomeServizioApplicativo(servizio_applicativo);
            String tipoServizioLog = "";
            String servizioLog = "";
            String azioneLog = "";
            String counterLog = "";
            if (tipoServizio != null) {
                tipoServizioLog = " tipoServizio[" + tipoServizio + "]";
            }
            if (servizio != null) {
                servizioLog = " servizio[" + servizio + "]";
            }
            if (azione != null) {
                azioneLog = " azione[" + azione + "]";
            }
            if (counter >= 0) {
                counterLog = " counter[" + counter + "]";
            }
            String param = "ServizioApplicativo[" + servizio_applicativo + "]" + tipoServizioLog + servizioLog + azioneLog + counterLog;
            msgDiag.addKeyword("@PARAMETRI_OPERAZIONE_IM@", param);
            msgDiag.logPersonalizzato("logInvocazioneOperazione");
            Vector<String> ids = null;
            stato = new OpenSPCoopStateful();
            stato.initResource(this.propertiesReader.getIdentitaPortaDefault(), ID_MODULO);
            GestoreMessaggi gestoreMessaggi = new GestoreMessaggi(stato, true, msgDiag);
            ids = counter < 0 && offset < 0 ? gestoreMessaggi.getIDMessaggi_ServizioApplicativo(servizio_applicativo, tipoServizio, servizio, azione) : (offset < 0 ? gestoreMessaggi.getIDMessaggi_ServizioApplicativo(servizio_applicativo, tipoServizio, servizio, azione, counter) : gestoreMessaggi.getIDMessaggi_ServizioApplicativo(servizio_applicativo, tipoServizio, servizio, azione, counter, offset));
            if (ids.size() == 0) {
                msgDiag.logPersonalizzato("messaggiNonPresenti");
                throw new SPCoopException("OPENSPCOOP_ORG_406", "Non sono stati rilevati messaggi per il servizio applicativo", servizio_applicativo);
            }
            String[] idsResponse = new String[ids.size()];
            idsResponse = ids.toArray(idsResponse);
            imResponseContext.setEsito(EsitoIM.OK);
            stringArray = idsResponse;
            Object var26_28 = null;
            try {
                if (stato != null) {
                    stato.releaseResource();
                }
            }
            catch (Exception eClose) {
                // empty catch block
            }
            imResponseContext.setDataCompletamentoOperazione(DateManager.getDate());
            try {
                GestoreHandlers.integrationManagerResponse(imResponseContext, msgDiag);
            }
            catch (Exception e2) {
                if (e2 instanceof HandlerException) {
                    msgDiag.logErroreGenerico(e2, ((HandlerException)e2).getIdentitaHandler());
                    break block30;
                }
                msgDiag.logErroreGenerico(e2, "IntegrationManagerResponseHandler");
            }
        }
        return stringArray;
        catch (Exception e) {
            try {
                imResponseContext.setEsito(EsitoIM.ERRORE_GENERICO);
                if (e instanceof SPCoopException) {
                    SPCoopException spcoopE = (SPCoopException)((Object)e);
                    if ("OPENSPCOOP_ORG_402".equals(spcoopE.getCodiceEccezione()) || "OPENSPCOOP_ORG_431".equals(spcoopE.getCodiceEccezione())) {
                        imResponseContext.setEsito(EsitoIM.AUTENTICAZIONE_FALLITA);
                    } else if ("OPENSPCOOP_ORG_406".equals(spcoopE.getCodiceEccezione())) {
                        imResponseContext.setEsito(EsitoIM.MESSAGGI_NON_PRESENTI);
                    }
                }
                if (e instanceof SPCoopException) {
                    throw (SPCoopException)((Object)e);
                }
                msgDiag.logErroreGenerico(e, "getAllMessagesId(" + tipoOperazione + ")");
                throw new SPCoopException("OPENSPCOOP_ORG_500", "Sistema non disponibile", servizio_applicativo);
            }
            catch (Throwable throwable) {
                block31: {
                    Object var26_29 = null;
                    try {
                        if (stato != null) {
                            stato.releaseResource();
                        }
                    }
                    catch (Exception eClose) {
                        // empty catch block
                    }
                    imResponseContext.setDataCompletamentoOperazione(DateManager.getDate());
                    try {
                        GestoreHandlers.integrationManagerResponse(imResponseContext, msgDiag);
                    }
                    catch (Exception e2) {
                        if (e2 instanceof HandlerException) {
                            msgDiag.logErroreGenerico(e2, ((HandlerException)e2).getIdentitaHandler());
                            break block31;
                        }
                        msgDiag.logErroreGenerico(e2, "IntegrationManagerResponseHandler");
                    }
                }
                throw throwable;
            }
        }
    }

    public String[] getAllMessagesId() throws SPCoopException {
        return this.getAllMessagesId_engine(Operazione.getAllMessagesId, null, null, null, -1, -1);
    }

    public String[] getAllMessagesIdByService(String tipoServizio, String servizio, String azione) throws SPCoopException {
        return this.getAllMessagesId_engine(Operazione.getAllMessagesIdByService, tipoServizio, servizio, azione, -1, -1);
    }

    @Deprecated
    public String[] getNextMessagesId(int counter) throws SPCoopException {
        return this.getAllMessagesId_engine(Operazione.getNextMessagesId, null, null, null, counter, -1);
    }

    @Deprecated
    public String[] getNextMessagesIdByService(int counter, String tipoServizio, String servizio, String azione) throws SPCoopException {
        return this.getAllMessagesId_engine(Operazione.getNextMessagesIdByService, tipoServizio, servizio, azione, counter, -1);
    }

    public String[] getMessagesIdArray(int offset, int counter) throws SPCoopException {
        return this.getAllMessagesId_engine(Operazione.getMessagesIdArray, null, null, null, counter, offset);
    }

    public String[] getMessagesIdArrayByService(int offset, int counter, String tipoServizio, String servizio, String azione) throws SPCoopException {
        return this.getAllMessagesId_engine(Operazione.getMessagesIdArrayByService, tipoServizio, servizio, azione, counter, offset);
    }

    /*
     * Loose catch block
     */
    private SPCoopMessage getMessage_engine(Operazione tipoOperazione, String idEGov, boolean isRiferimentoMessaggio) throws SPCoopException {
        SPCoopMessage sPCoopMessage;
        IntegrationManagerResponseContext imResponseContext;
        OpenSPCoopState stato;
        String servizio_applicativo;
        MsgDiagnostico msgDiag;
        block45: {
            IDServizio idServizio;
            IDSoggetto fruitore;
            SPCoopHeaderInfo spcoopHeaderInfo;
            GestoreMessaggi gestoreMessaggi;
            PdDContext pddContext;
            block43: {
                Timestamp dataRichiestaOperazione = DateManager.getTimestamp();
                Logger logCore = OpenSPCoopLogger.getLoggerOpenSPCoopCore();
                if (logCore == null) {
                    logCore = Logger.getLogger((String)ID_MODULO);
                }
                this.verificaRisorseSistema(logCore, tipoOperazione.toString());
                msgDiag = this.getMsgDiagnostico();
                msgDiag.addKeyword("@TIPO_OPERAZIONE_IM@", tipoOperazione.toString());
                if (isRiferimentoMessaggio) {
                    msgDiag.addKeyword("@RIFERIMENTO_MESSAGGIO_RICHIESTA@", idEGov);
                    msgDiag.addKeyword("@RIFERIMENTO_MESSAGGIO_RISPOSTA@", idEGov);
                } else {
                    msgDiag.addKeyword("@ID_EGOV_RICHIESTA@", idEGov);
                    msgDiag.addKeyword("@ID_EGOV_RISPOSTA@", idEGov);
                }
                servizio_applicativo = null;
                stato = null;
                pddContext = new PdDContext();
                pddContext.addObject("ID", this.getUniqueIdentifier(msgDiag, tipoOperazione.toString()).getAsString());
                pddContext.addObject("ID_EGOV", idEGov);
                msgDiag.setPddContext(pddContext);
                IntegrationManagerRequestContext imRequestContext = null;
                try {
                    imRequestContext = this.buildIMRequestContext(dataRichiestaOperazione, tipoOperazione, pddContext, logCore);
                    imRequestContext.setIdMessaggio(idEGov);
                    GestoreHandlers.integrationManagerRequest(imRequestContext, msgDiag);
                }
                catch (Exception e) {
                    if (e instanceof HandlerException) {
                        msgDiag.logErroreGenerico(e, ((HandlerException)e).getIdentitaHandler());
                    } else {
                        msgDiag.logErroreGenerico(e, "IntegrationManagerRequestHandler");
                    }
                    throw new SPCoopException("OPENSPCOOP_ORG_500", "Sistema non disponibile");
                }
                imResponseContext = new IntegrationManagerResponseContext(dataRichiestaOperazione, tipoOperazione, pddContext, logCore);
                imResponseContext.setIdMessaggio(idEGov);
                this.gestioneCredenziali(msgDiag, imRequestContext.getConnettore());
                servizio_applicativo = this.autenticazione(msgDiag, imRequestContext.getConnettore().getCredenziali());
                imResponseContext.setNomeServizioApplicativo(servizio_applicativo);
                String param = "ServizioApplicativo[" + servizio_applicativo + "] ID[" + idEGov + "]";
                msgDiag.addKeyword("@PARAMETRI_OPERAZIONE_IM@", param);
                msgDiag.logPersonalizzato("logInvocazioneOperazione");
                stato = new OpenSPCoopStateful();
                stato.initResource(this.propertiesReader.getIdentitaPortaDefault(), ID_MODULO);
                gestoreMessaggi = new GestoreMessaggi(stato, true, idEGov, "INBOX", msgDiag);
                if (!gestoreMessaggi.existsMessageForSIL(servizio_applicativo, isRiferimentoMessaggio)) {
                    msgDiag.addKeyword("@ID_MESSAGGIO_TRANSACTION_MANAGER@", idEGov);
                    msgDiag.logPersonalizzato("messaggioNonTrovato");
                    throw new SPCoopException("OPENSPCOOP_ORG_407", "Non \u00e8 stato rilevato il messaggio richiesto dal servizio applicativo", servizio_applicativo);
                }
                boolean authorized = gestoreMessaggi.checkAutorizzazione(servizio_applicativo, isRiferimentoMessaggio);
                if (!authorized) {
                    msgDiag.logPersonalizzato("servizioApplicativo.nonAutorizzato");
                    throw new SPCoopException("OPENSPCOOP_ORG_404", "Servizio non invocabile dal servizio applicativo ", servizio_applicativo);
                }
                String idMessaggioRichiesto = idEGov;
                try {
                    if (isRiferimentoMessaggio) {
                        idMessaggioRichiesto = gestoreMessaggi.mapRiferimentoIntoIDEgov();
                    }
                }
                catch (Exception e) {
                    msgDiag.addKeyword("@ERRORE_PROCESSAMENTO@", e.getMessage());
                    msgDiag.logPersonalizzato("mappingRifMsgToIdEGov.nonRiuscito");
                    throw new SPCoopException("OPENSPCOOP_ORG_520", "Sistema non disponibile", servizio_applicativo);
                }
                RepositoryEGov repository = new RepositoryEGov(stato.getStatoRichiesta(), true);
                spcoopHeaderInfo = null;
                fruitore = null;
                idServizio = null;
                try {
                    LetturaParametriBusta parametri = new LetturaParametriBusta();
                    parametri.setMittente(true);
                    parametri.setDestinatario(true);
                    parametri.setRiferimentoMessaggio(true);
                    parametri.setServizio(true);
                    parametri.setAzione(true);
                    parametri.setCollaborazione(true);
                    Busta busta = repository.getSomeValuesFromInBox(idMessaggioRichiesto, parametri);
                    if (busta != null) {
                        spcoopHeaderInfo = new SPCoopHeaderInfo();
                        spcoopHeaderInfo.setID(idMessaggioRichiesto);
                        spcoopHeaderInfo.setRiferimentoMessaggio(busta.getRiferimentoMessaggio());
                        spcoopHeaderInfo.setTipoMittente(busta.getTipoMittente());
                        spcoopHeaderInfo.setMittente(busta.getMittente());
                        spcoopHeaderInfo.setTipoDestinatario(busta.getTipoDestinatario());
                        spcoopHeaderInfo.setDestinatario(busta.getDestinatario());
                        spcoopHeaderInfo.setTipoServizio(busta.getTipoServizio());
                        spcoopHeaderInfo.setServizio(busta.getServizio());
                        spcoopHeaderInfo.setAzione(busta.getAzione());
                        spcoopHeaderInfo.setIdCollaborazione(busta.getCollaborazione());
                        busta.setID(idMessaggioRichiesto);
                        msgDiag.addKeywords(busta, true);
                        fruitore = new IDSoggetto(busta.getTipoMittente(), busta.getMittente());
                        idServizio = new IDServizio(busta.getTipoDestinatario(), busta.getDestinatario(), busta.getTipoServizio(), busta.getServizio());
                    }
                }
                catch (Exception e) {
                    msgDiag.logErroreGenerico(e, "ReadInformazioniEGov(" + tipoOperazione + "," + idMessaggioRichiesto + ")");
                    if (e.getMessage() != null && e.getMessage().indexOf("Busta non trovata") >= 0) break block43;
                    throw new SPCoopException("OPENSPCOOP_ORG_520", "Sistema non disponibile", servizio_applicativo);
                }
            }
            boolean sbustamento_soap = gestoreMessaggi.sbustamentoSoap(servizio_applicativo, isRiferimentoMessaggio);
            Message consegnaAxisMessage = null;
            try {
                consegnaAxisMessage = gestoreMessaggi.getMessage(isRiferimentoMessaggio);
            }
            catch (Exception e) {
                msgDiag.logErroreGenerico(e, "gestoreMessaggi.getMessage(" + isRiferimentoMessaggio + "," + tipoOperazione + ")");
                throw new SPCoopException("OPENSPCOOP_ORG_520", "Sistema non disponibile", servizio_applicativo);
            }
            if (this.configurazionePdDReader.dumpMessaggi()) {
                msgDiag.mediumDebug("Dump applicativo messaggio ritornato...");
                Dump dumpApplicativo = new Dump(this.propertiesReader.getIdentificativoPortaDefault(), ID_MODULO, idEGov, fruitore, idServizio, TipoPdD.INTEGRATION_MANAGER, pddContext);
                dumpApplicativo.dumpIntegrationManagerGetMessage(consegnaAxisMessage);
            }
            SPCoopMessage msgReturn = null;
            try {
                if (!sbustamento_soap) {
                    msgReturn = new SPCoopMessage(consegnaAxisMessage, false, spcoopHeaderInfo);
                } else {
                    byte[] sbustato = SoapUtils.sbustamentoMessaggio((Message)consegnaAxisMessage);
                    msgReturn = new SPCoopMessage(sbustato, false, spcoopHeaderInfo);
                }
            }
            catch (Exception e) {
                msgDiag.logErroreGenerico(e, "buildMsgReturn(" + idEGov + "," + tipoOperazione + ")");
                throw new SPCoopException("OPENSPCOOP_ORG_523", "Sistema non disponibile", servizio_applicativo);
            }
            imResponseContext.setEsito(EsitoIM.OK);
            imResponseContext.setDimensioneMessaggioBytes(new Long(msgReturn.getMessage().length));
            sPCoopMessage = msgReturn;
            Object var25_32 = null;
            try {
                if (stato != null) {
                    stato.releaseResource();
                }
            }
            catch (Exception eClose) {
                // empty catch block
            }
            imResponseContext.setDataCompletamentoOperazione(DateManager.getDate());
            try {
                GestoreHandlers.integrationManagerResponse(imResponseContext, msgDiag);
            }
            catch (Exception e2) {
                if (e2 instanceof HandlerException) {
                    msgDiag.logErroreGenerico(e2, ((HandlerException)e2).getIdentitaHandler());
                    break block45;
                }
                msgDiag.logErroreGenerico(e2, "IntegrationManagerResponseHandler");
            }
        }
        return sPCoopMessage;
        catch (Exception e) {
            try {
                imResponseContext.setEsito(EsitoIM.ERRORE_GENERICO);
                if (e instanceof SPCoopException) {
                    SPCoopException spcoopE = (SPCoopException)((Object)e);
                    if ("OPENSPCOOP_ORG_402".equals(spcoopE.getCodiceEccezione()) || "OPENSPCOOP_ORG_431".equals(spcoopE.getCodiceEccezione())) {
                        imResponseContext.setEsito(EsitoIM.AUTENTICAZIONE_FALLITA);
                    } else if ("OPENSPCOOP_ORG_407".equals(spcoopE.getCodiceEccezione())) {
                        imResponseContext.setEsito(EsitoIM.MESSAGGIO_NON_TROVATO);
                    } else if ("OPENSPCOOP_ORG_404".equals(spcoopE.getCodiceEccezione())) {
                        imResponseContext.setEsito(EsitoIM.AUTORIZZAZIONE_FALLITA);
                    }
                }
                if (e instanceof SPCoopException) {
                    throw (SPCoopException)((Object)e);
                }
                msgDiag.logErroreGenerico(e, "getMessage(" + tipoOperazione + ")");
                throw new SPCoopException("OPENSPCOOP_ORG_500", "Sistema non disponibile", servizio_applicativo);
            }
            catch (Throwable throwable) {
                block46: {
                    Object var25_33 = null;
                    try {
                        if (stato != null) {
                            stato.releaseResource();
                        }
                    }
                    catch (Exception eClose) {
                        // empty catch block
                    }
                    imResponseContext.setDataCompletamentoOperazione(DateManager.getDate());
                    try {
                        GestoreHandlers.integrationManagerResponse(imResponseContext, msgDiag);
                    }
                    catch (Exception e2) {
                        if (e2 instanceof HandlerException) {
                            msgDiag.logErroreGenerico(e2, ((HandlerException)e2).getIdentitaHandler());
                            break block46;
                        }
                        msgDiag.logErroreGenerico(e2, "IntegrationManagerResponseHandler");
                    }
                }
                throw throwable;
            }
        }
    }

    public SPCoopMessage getMessage(String idEGov) throws SPCoopException {
        return this.getMessage_engine(Operazione.getMessage, idEGov, false);
    }

    public SPCoopMessage getMessageByReference(String riferimentoMsg) throws SPCoopException {
        return this.getMessage_engine(Operazione.getMessageByReference, riferimentoMsg, true);
    }

    /*
     * Loose catch block
     */
    private void deleteMessage_engine(Operazione tipoOperazione, String idEGov, boolean isRiferimentoMessaggio) throws SPCoopException {
        block36: {
            Timestamp dataRichiestaOperazione = DateManager.getTimestamp();
            Logger logCore = OpenSPCoopLogger.getLoggerOpenSPCoopCore();
            if (logCore == null) {
                logCore = Logger.getLogger((String)ID_MODULO);
            }
            this.verificaRisorseSistema(logCore, tipoOperazione.toString());
            MsgDiagnostico msgDiag = this.getMsgDiagnostico();
            msgDiag.addKeyword("@TIPO_OPERAZIONE_IM@", tipoOperazione.toString());
            if (isRiferimentoMessaggio) {
                msgDiag.addKeyword("@RIFERIMENTO_MESSAGGIO_RICHIESTA@", idEGov);
                msgDiag.addKeyword("@RIFERIMENTO_MESSAGGIO_RISPOSTA@", idEGov);
            } else {
                msgDiag.addKeyword("@ID_EGOV_RICHIESTA@", idEGov);
                msgDiag.addKeyword("@ID_EGOV_RISPOSTA@", idEGov);
            }
            GestoreMessaggi gestoreMessaggi = null;
            String servizio_applicativo = null;
            OpenSPCoopState stato = null;
            PdDContext pddContext = new PdDContext();
            pddContext.addObject("ID", this.getUniqueIdentifier(msgDiag, tipoOperazione.toString()).getAsString());
            pddContext.addObject("ID_EGOV", idEGov);
            msgDiag.setPddContext(pddContext);
            IntegrationManagerRequestContext imRequestContext = null;
            try {
                imRequestContext = this.buildIMRequestContext(dataRichiestaOperazione, tipoOperazione, pddContext, logCore);
                imRequestContext.setIdMessaggio(idEGov);
                GestoreHandlers.integrationManagerRequest(imRequestContext, msgDiag);
            }
            catch (Exception e) {
                if (e instanceof HandlerException) {
                    msgDiag.logErroreGenerico(e, ((HandlerException)e).getIdentitaHandler());
                } else {
                    msgDiag.logErroreGenerico(e, "IntegrationManagerRequestHandler");
                }
                throw new SPCoopException("OPENSPCOOP_ORG_500", "Sistema non disponibile");
            }
            IntegrationManagerResponseContext imResponseContext = new IntegrationManagerResponseContext(dataRichiestaOperazione, tipoOperazione, pddContext, logCore);
            imResponseContext.setIdMessaggio(idEGov);
            this.gestioneCredenziali(msgDiag, imRequestContext.getConnettore());
            servizio_applicativo = this.autenticazione(msgDiag, imRequestContext.getConnettore().getCredenziali());
            imResponseContext.setNomeServizioApplicativo(servizio_applicativo);
            String param = "ServizioApplicativo[" + servizio_applicativo + "] ID[" + idEGov + "]";
            msgDiag.addKeyword("@PARAMETRI_OPERAZIONE_IM@", param);
            msgDiag.logPersonalizzato("logInvocazioneOperazione");
            stato = new OpenSPCoopStateful();
            stato.initResource(this.propertiesReader.getIdentitaPortaDefault(), ID_MODULO);
            gestoreMessaggi = new GestoreMessaggi(stato, true, idEGov, "INBOX", msgDiag);
            if (!gestoreMessaggi.existsMessageForSIL(servizio_applicativo, isRiferimentoMessaggio)) {
                msgDiag.addKeyword("@ID_MESSAGGIO_TRANSACTION_MANAGER@", idEGov);
                msgDiag.logPersonalizzato("messaggioNonTrovato");
                throw new SPCoopException("OPENSPCOOP_ORG_407", "Non \u00e8 stato rilevato il messaggio richiesto dal servizio applicativo", servizio_applicativo);
            }
            boolean authorized = gestoreMessaggi.checkAutorizzazione(servizio_applicativo, isRiferimentoMessaggio);
            if (!authorized) {
                msgDiag.logPersonalizzato("servizioApplicativo.nonAutorizzato");
                throw new SPCoopException("OPENSPCOOP_ORG_404", "Servizio non invocabile dal servizio applicativo ", servizio_applicativo);
            }
            String idMessaggioRichiesto = idEGov;
            try {
                if (isRiferimentoMessaggio) {
                    idMessaggioRichiesto = gestoreMessaggi.mapRiferimentoIntoIDEgov();
                }
            }
            catch (Exception e) {
                msgDiag.addKeyword("@ERRORE_PROCESSAMENTO@", e.getMessage());
                msgDiag.logPersonalizzato("mappingRifMsgToIdEGov.nonRiuscito");
                throw new SPCoopException("OPENSPCOOP_ORG_520", "Sistema non disponibile", servizio_applicativo);
            }
            try {
                GestoreMessaggi gestoreEliminazione = new GestoreMessaggi(stato, true, idMessaggioRichiesto, "INBOX", msgDiag);
                gestoreEliminazione.eliminaDestinatarioMessaggio(servizio_applicativo, gestoreEliminazione.getRiferimentoMessaggio());
            }
            catch (Exception e) {
                msgDiag.logErroreGenerico(e, "gestoreMessaggi.eliminaDestinatarioMessaggio(" + tipoOperazione + "," + servizio_applicativo + "," + idEGov + ")");
                throw new SPCoopException("OPENSPCOOP_ORG_522", "Sistema non disponibile", servizio_applicativo);
            }
            imResponseContext.setEsito(EsitoIM.OK);
            Object var18_22 = null;
            try {
                if (stato != null) {
                    stato.releaseResource();
                }
            }
            catch (Exception eClose) {
                // empty catch block
            }
            imResponseContext.setDataCompletamentoOperazione(DateManager.getDate());
            try {
                GestoreHandlers.integrationManagerResponse(imResponseContext, msgDiag);
            }
            catch (Exception e) {
                if (e instanceof HandlerException) {
                    msgDiag.logErroreGenerico(e, ((HandlerException)e).getIdentitaHandler());
                    break block36;
                }
                msgDiag.logErroreGenerico(e, "IntegrationManagerResponseHandler");
            }
            break block36;
            {
                catch (Exception e) {
                    imResponseContext.setEsito(EsitoIM.ERRORE_GENERICO);
                    if (e instanceof SPCoopException) {
                        SPCoopException spcoopE = (SPCoopException)((Object)e);
                        if ("OPENSPCOOP_ORG_402".equals(spcoopE.getCodiceEccezione()) || "OPENSPCOOP_ORG_431".equals(spcoopE.getCodiceEccezione())) {
                            imResponseContext.setEsito(EsitoIM.AUTENTICAZIONE_FALLITA);
                        } else if ("OPENSPCOOP_ORG_407".equals(spcoopE.getCodiceEccezione())) {
                            imResponseContext.setEsito(EsitoIM.MESSAGGIO_NON_TROVATO);
                        } else if ("OPENSPCOOP_ORG_404".equals(spcoopE.getCodiceEccezione())) {
                            imResponseContext.setEsito(EsitoIM.AUTORIZZAZIONE_FALLITA);
                        }
                    }
                    if (e instanceof SPCoopException) {
                        throw (SPCoopException)((Object)e);
                    }
                    msgDiag.logErroreGenerico(e, "deleteMessage(" + tipoOperazione + ")");
                    throw new SPCoopException("OPENSPCOOP_ORG_500", "Sistema non disponibile", servizio_applicativo);
                }
            }
            catch (Throwable throwable) {
                block37: {
                    Object var18_23 = null;
                    try {
                        if (stato != null) {
                            stato.releaseResource();
                        }
                    }
                    catch (Exception eClose) {
                        // empty catch block
                    }
                    imResponseContext.setDataCompletamentoOperazione(DateManager.getDate());
                    try {
                        GestoreHandlers.integrationManagerResponse(imResponseContext, msgDiag);
                    }
                    catch (Exception e) {
                        if (e instanceof HandlerException) {
                            msgDiag.logErroreGenerico(e, ((HandlerException)e).getIdentitaHandler());
                            break block37;
                        }
                        msgDiag.logErroreGenerico(e, "IntegrationManagerResponseHandler");
                    }
                }
                throw throwable;
            }
        }
    }

    public void deleteMessage(String idEGov) throws SPCoopException {
        this.deleteMessage_engine(Operazione.deleteMessage, idEGov, false);
    }

    public void deleteMessageByReference(String riferimentoMsg) throws SPCoopException {
        this.deleteMessage_engine(Operazione.deleteMessageByReference, riferimentoMsg, true);
    }

    /*
     * Loose catch block
     */
    public void deleteAllMessages() throws SPCoopException {
        block33: {
            Operazione tipoOperazione = Operazione.deleteAllMessages;
            Timestamp dataRichiestaOperazione = DateManager.getTimestamp();
            Logger logCore = OpenSPCoopLogger.getLoggerOpenSPCoopCore();
            if (logCore == null) {
                logCore = Logger.getLogger((String)ID_MODULO);
            }
            this.verificaRisorseSistema(logCore, tipoOperazione.toString());
            MsgDiagnostico msgDiag = this.getMsgDiagnostico();
            msgDiag.addKeyword("@TIPO_OPERAZIONE_IM@", tipoOperazione.toString());
            String servizio_applicativo = null;
            OpenSPCoopState stato = null;
            PdDContext pddContext = new PdDContext();
            pddContext.addObject("ID", this.getUniqueIdentifier(msgDiag, tipoOperazione.toString()).getAsString());
            msgDiag.setPddContext(pddContext);
            IntegrationManagerRequestContext imRequestContext = null;
            try {
                imRequestContext = this.buildIMRequestContext(dataRichiestaOperazione, tipoOperazione, pddContext, logCore);
                GestoreHandlers.integrationManagerRequest(imRequestContext, msgDiag);
            }
            catch (Exception e) {
                if (e instanceof HandlerException) {
                    msgDiag.logErroreGenerico(e, ((HandlerException)e).getIdentitaHandler());
                } else {
                    msgDiag.logErroreGenerico(e, "IntegrationManagerRequestHandler");
                }
                throw new SPCoopException("OPENSPCOOP_ORG_500", "Sistema non disponibile");
            }
            IntegrationManagerResponseContext imResponseContext = new IntegrationManagerResponseContext(dataRichiestaOperazione, tipoOperazione, pddContext, logCore);
            this.gestioneCredenziali(msgDiag, imRequestContext.getConnettore());
            servizio_applicativo = this.autenticazione(msgDiag, imRequestContext.getConnettore().getCredenziali());
            imResponseContext.setNomeServizioApplicativo(servizio_applicativo);
            String param = "ServizioApplicativo[" + servizio_applicativo + "]";
            msgDiag.addKeyword("@PARAMETRI_OPERAZIONE_IM@", param);
            msgDiag.logPersonalizzato("logInvocazioneOperazione");
            stato = new OpenSPCoopStateful();
            stato.initResource(this.propertiesReader.getIdentitaPortaDefault(), ID_MODULO);
            GestoreMessaggi gestoreSearchID = new GestoreMessaggi(stato, true, msgDiag);
            Vector<String> ids = gestoreSearchID.getIDMessaggi_ServizioApplicativo(servizio_applicativo);
            if (ids.size() == 0) {
                msgDiag.logPersonalizzato("messaggiNonPresenti");
                throw new SPCoopException("OPENSPCOOP_ORG_406", "Non sono stati rilevati messaggi per il servizio applicativo", servizio_applicativo);
            }
            for (int i = 0; i < ids.size(); ++i) {
                String idMessaggio = ids.get(i);
                GestoreMessaggi gestoreMessaggi = new GestoreMessaggi(stato, true, idMessaggio, "INBOX", msgDiag);
                if (!gestoreMessaggi.existsMessageForSIL(servizio_applicativo)) {
                    msgDiag.addKeyword("@ID_MESSAGGIO_TRANSACTION_MANAGER@", idMessaggio);
                    msgDiag.logPersonalizzato("messaggioNonTrovato");
                    throw new SPCoopException("OPENSPCOOP_ORG_520", "Sistema non disponibile", servizio_applicativo);
                }
                boolean authorized = gestoreMessaggi.checkAutorizzazione(servizio_applicativo);
                if (authorized) continue;
                msgDiag.logPersonalizzato("servizioApplicativo.nonAutorizzato");
                throw new SPCoopException("OPENSPCOOP_ORG_404", "Servizio non invocabile dal servizio applicativo ", servizio_applicativo);
            }
            while (ids.size() > 0) {
                String idEGov = ids.remove(0);
                try {
                    GestoreMessaggi gestoreEliminazione = new GestoreMessaggi(stato, true, idEGov, "INBOX", msgDiag);
                    gestoreEliminazione.eliminaDestinatarioMessaggio(servizio_applicativo, gestoreEliminazione.getRiferimentoMessaggio());
                }
                catch (Exception e) {
                    msgDiag.logErroreGenerico(e, "gestoreMessaggi.eliminaDestinatarioMessaggio(" + tipoOperazione + "," + servizio_applicativo + "," + idEGov + ")");
                    throw new SPCoopException("OPENSPCOOP_ORG_522", "Sistema non disponibile", servizio_applicativo);
                }
            }
            imResponseContext.setEsito(EsitoIM.OK);
            Object var18_22 = null;
            try {
                if (stato != null) {
                    stato.releaseResource();
                }
            }
            catch (Exception eClose) {
                // empty catch block
            }
            imResponseContext.setDataCompletamentoOperazione(DateManager.getDate());
            try {
                GestoreHandlers.integrationManagerResponse(imResponseContext, msgDiag);
            }
            catch (Exception e) {
                if (e instanceof HandlerException) {
                    msgDiag.logErroreGenerico(e, ((HandlerException)e).getIdentitaHandler());
                    break block33;
                }
                msgDiag.logErroreGenerico(e, "IntegrationManagerResponseHandler");
            }
            break block33;
            {
                catch (Exception e) {
                    imResponseContext.setEsito(EsitoIM.ERRORE_GENERICO);
                    if (e instanceof SPCoopException) {
                        SPCoopException spcoopE = (SPCoopException)((Object)e);
                        if ("OPENSPCOOP_ORG_402".equals(spcoopE.getCodiceEccezione()) || "OPENSPCOOP_ORG_431".equals(spcoopE.getCodiceEccezione())) {
                            imResponseContext.setEsito(EsitoIM.AUTENTICAZIONE_FALLITA);
                        } else if ("OPENSPCOOP_ORG_406".equals(spcoopE.getCodiceEccezione())) {
                            imResponseContext.setEsito(EsitoIM.MESSAGGI_NON_PRESENTI);
                        } else if ("OPENSPCOOP_ORG_404".equals(spcoopE.getCodiceEccezione())) {
                            imResponseContext.setEsito(EsitoIM.AUTORIZZAZIONE_FALLITA);
                        }
                    }
                    if (e instanceof SPCoopException) {
                        throw (SPCoopException)((Object)e);
                    }
                    msgDiag.logErroreGenerico(e, "deleteAllMessages(" + tipoOperazione + ")");
                    throw new SPCoopException("OPENSPCOOP_ORG_500", "Sistema non disponibile", servizio_applicativo);
                }
            }
            catch (Throwable throwable) {
                block34: {
                    Object var18_23 = null;
                    try {
                        if (stato != null) {
                            stato.releaseResource();
                        }
                    }
                    catch (Exception eClose) {
                        // empty catch block
                    }
                    imResponseContext.setDataCompletamentoOperazione(DateManager.getDate());
                    try {
                        GestoreHandlers.integrationManagerResponse(imResponseContext, msgDiag);
                    }
                    catch (Exception e) {
                        if (e instanceof HandlerException) {
                            msgDiag.logErroreGenerico(e, ((HandlerException)e).getIdentitaHandler());
                            break block34;
                        }
                        msgDiag.logErroreGenerico(e, "IntegrationManagerResponseHandler");
                    }
                }
                throw throwable;
            }
        }
    }

    private SPCoopMessage invocaPortaDelegata_engine(String tipoOperazione, String portaDelegata, SPCoopMessage msg, String idInvocazionePerRiferimento) throws SPCoopException {
        Long dimensioneMessaggio;
        Message axisMsgResponse;
        String errore;
        Esito esito;
        PdDContext pddContext;
        RicezioneContenutiApplicativiContext context;
        OpenSPCoopState stato;
        MsgDiagnostico msgDiag;
        Logger logCore;
        block90: {
            Timestamp dataIngressoMessaggio = DateManager.getTimestamp();
            logCore = OpenSPCoopLogger.getLoggerOpenSPCoopCore();
            if (logCore == null) {
                logCore = Logger.getLogger((String)ID_MODULO);
            }
            this.verificaRisorseSistema(logCore, tipoOperazione);
            msgDiag = this.getMsgDiagnostico();
            msgDiag.addKeyword("@TIPO_OPERAZIONE_IM@", tipoOperazione);
            MessageContext msgContext = MessageContext.getCurrentContext();
            PreInRequestContext preInRequestContext = new PreInRequestContext();
            preInRequestContext.setTipoPorta(TipoPdD.DELEGATA);
            Hashtable<String, Object> transportContext = new Hashtable<String, Object>();
            transportContext.put("CONTEXT", msgContext);
            preInRequestContext.setTransportContext(transportContext);
            preInRequestContext.setLogCore(logCore);
            GestoreHandlers.preInRequest(preInRequestContext, msgDiag);
            stato = null;
            context = null;
            try {
                context = new RicezioneContenutiApplicativiContext(dataIngressoMessaggio, this.propertiesReader.getIdentitaPortaDefault());
            }
            catch (Exception e) {
                msgDiag.logErroreGenerico(e, "invocaPortaDelegata_engine(" + tipoOperazione + ").newRicezioneContenutiApplicativiContext()");
                throw new SPCoopException("OPENSPCOOP_ORG_500", "Sistema non disponibile");
            }
            pddContext = new PdDContext();
            pddContext.addObject("ID", context.getPddContext().getObject("ID"));
            pddContext.addObject("TIPO_OPERAZIONE_IM", tipoOperazione.toString());
            pddContext.addObject("ID_EGOV", idInvocazionePerRiferimento);
            pddContext.addObject("PORTA_DELEGATA", portaDelegata);
            esito = null;
            errore = null;
            axisMsgResponse = null;
            dimensioneMessaggio = null;
            if ("invocaPortaDelegata".equals(tipoOperazione)) {
                if (msg == null || msg.getMessage() == null) {
                    msgDiag.logPersonalizzato("invocazionePortaDelegata.contenutoApplicativoNonPresente");
                    throw new SPCoopException("OPENSPCOOP_ORG_520", "Sistema non disponibile");
                }
            } else if ("invocaPortaDelegataPerRiferimento".equals(tipoOperazione)) {
                if (idInvocazionePerRiferimento == null) {
                    msgDiag.logPersonalizzato("invocazionePortaDelegataPerRiferimento.riferimentoMessaggioNonPresente");
                    throw new SPCoopException("OPENSPCOOP_ORG_520", "Sistema non disponibile");
                }
            } else if ("sendRispostaAsincronaSimmetrica".equals(tipoOperazione)) {
                if (msg == null || msg.getMessage() == null) {
                    msgDiag.logPersonalizzato("invocazionePortaDelegata.contenutoApplicativoNonPresente");
                    throw new SPCoopException("OPENSPCOOP_ORG_520", "Sistema non disponibile");
                }
                if (msg.getSpcoopHeaderInfo() == null || msg.getSpcoopHeaderInfo().getRiferimentoMessaggio() == null) {
                    msgDiag.logPersonalizzato("invocazionePortaDelegata.profiloAsincrono.riferimentoMessaggioNonPresente");
                    throw new SPCoopException("OPENSPCOOP_ORG_520", "Sistema non disponibile");
                }
            } else if ("sendRichiestaStatoAsincronaAsimmetrica".equals(tipoOperazione)) {
                if (msg == null || msg.getMessage() == null) {
                    msgDiag.logPersonalizzato("invocazionePortaDelegata.contenutoApplicativoNonPresente");
                    throw new SPCoopException("OPENSPCOOP_ORG_520", "Sistema non disponibile");
                }
                if (msg.getSpcoopHeaderInfo() == null || msg.getSpcoopHeaderInfo().getRiferimentoMessaggio() == null) {
                    msgDiag.logPersonalizzato("invocazionePortaDelegata.profiloAsincrono.riferimentoMessaggioNonPresente");
                    throw new SPCoopException("OPENSPCOOP_ORG_520", "Sistema non disponibile");
                }
            } else {
                throw new Exception("Tipo operazione [" + tipoOperazione + "] non gestita");
            }
            Credenziali credenziali = (Credenziali)msgContext.getProperty("openspcoop.credenziali");
            String credenzialiFornite = "";
            if (credenziali != null) {
                if (credenziali.getUsername() != null || credenziali.getSubject() != null) {
                    credenzialiFornite = "(";
                    if (credenziali.getUsername() != null) {
                        credenzialiFornite = credenzialiFornite + " Basic Username: " + credenziali.getUsername() + " ";
                    }
                    if (credenziali.getSubject() != null) {
                        credenzialiFornite = credenzialiFornite + " SSL Subject: " + credenziali.getSubject() + " ";
                    }
                    credenzialiFornite = credenzialiFornite + ") ";
                }
                msgDiag.addKeyword("@CREDENZIALI_SA_FRUITORE@", credenzialiFornite);
            }
            String invPerRiferimento = "";
            if (idInvocazionePerRiferimento != null) {
                invPerRiferimento = " idInvocazionePerRiferimento[" + idInvocazionePerRiferimento + "]";
            }
            String riferimentoMessaggio = "";
            if (msg.getSpcoopHeaderInfo() != null && msg.getSpcoopHeaderInfo().getRiferimentoMessaggio() != null) {
                riferimentoMessaggio = " riferimentoMessaggio[" + msg.getSpcoopHeaderInfo().getRiferimentoMessaggio() + "]";
            }
            String param = "PD[" + portaDelegata + "]" + credenzialiFornite + invPerRiferimento + riferimentoMessaggio;
            msgDiag.addKeyword("@PARAMETRI_OPERAZIONE_IM@", param);
            msgDiag.logPersonalizzato("logInvocazioneOperazione");
            Properties headerTrasporto = null;
            HttpServletRequest req = (HttpServletRequest)msgContext.getProperty(HTTPConstants.MC_HTTP_SERVLETREQUEST);
            if (this.propertiesReader.integrationManager_readInformazioniTrasporto()) {
                headerTrasporto = new Properties();
                Enumeration enTrasporto = req.getHeaderNames();
                while (enTrasporto.hasMoreElements()) {
                    String nomeProperty = (String)enTrasporto.nextElement();
                    headerTrasporto.setProperty(nomeProperty, req.getHeader(nomeProperty));
                }
            }
            ParametriPortaDelegata parPD = new ParametriPortaDelegata();
            parPD.setLocation(portaDelegata);
            parPD.setUrlInvocazione(portaDelegata);
            if (this.propertiesReader.integrationManager_readInformazioniTrasporto()) {
                parPD.setParametersTrasporto(headerTrasporto);
            }
            parPD.setNomePortaDelegataURLBased(this.propertiesReader.integrationManager_isNomePortaDelegataUrlBased());
            Message axisMsgRequest = null;
            if (idInvocazionePerRiferimento != null) {
                stato = new OpenSPCoopStateful();
                stato.initResource(this.propertiesReader.getIdentitaPortaDefault(), ID_MODULO);
                try {
                    GestoreMessaggi gestoreMessaggio = new GestoreMessaggi(stato, true, idInvocazionePerRiferimento, "INBOX", msgDiag);
                    axisMsgRequest = gestoreMessaggio.getMessage();
                }
                catch (Exception e) {
                    msgDiag.logErroreGenerico(e, "gestoreMessaggio.getMessagePerRiferimento(" + idInvocazionePerRiferimento + ")");
                    throw new SPCoopException("OPENSPCOOP_ORG_520", "Sistema non disponibile");
                }
                stato.releaseResource();
                stato = null;
            } else {
                try {
                    axisMsgRequest = SoapUtils.build((byte[])msg.getMessage(), (boolean)msg.getImbustamento(), (boolean)this.propertiesReader.isDeleteInstructionTargetMachineXml());
                }
                catch (Exception e) {
                    if (this.configurazionePdDReader.dumpMessaggi()) {
                        Dump dumpApplicativo = new Dump(this.propertiesReader.getIdentitaPortaDefault().getCodicePorta(), ID_MODULO, TipoPdD.DELEGATA, pddContext);
                        dumpApplicativo.dumpRichiestaIngresso(msg.getMessage(), this.buildInfoConnettoreIngresso(req, credenziali, parPD));
                    }
                    if (!msg.getImbustamento()) {
                        msgDiag.addKeyword("@ERRORE_PROCESSAMENTO@", e.getMessage());
                        msgDiag.logPersonalizzato("buildMsg.nonRiuscito");
                        throw new SPCoopException("OPENSPCOOP_ORG_421", "I byte inviati al servizio di ricezione contenuti applicativi non formano un messaggio soap: " + e.getMessage());
                    }
                    msgDiag.addKeyword("@ERRORE_PROCESSAMENTO@", e.getMessage());
                    msgDiag.logPersonalizzato("buildMsg.imbustamentoSOAP.nonRiuscito");
                    throw new SPCoopException("OPENSPCOOP_ORG_422", "I byte inviati al servizio di ricezione contenuti applicativi non sono utilizzabili per un imbustamento soap: " + e.getMessage());
                }
            }
            HeaderIntegrazione headerIntegrazioneRichiesta = new HeaderIntegrazione();
            SPCoopHeaderInfo spcoopHeaderInfo = msg.getSpcoopHeaderInfo();
            if (spcoopHeaderInfo != null) {
                if (spcoopHeaderInfo.getTipoMittente() != null && !"".equals(spcoopHeaderInfo.getTipoMittente())) {
                    headerIntegrazioneRichiesta.getEgov().setTipoMittente(spcoopHeaderInfo.getTipoMittente());
                }
                if (spcoopHeaderInfo.getMittente() != null && !"".equals(spcoopHeaderInfo.getMittente())) {
                    headerIntegrazioneRichiesta.getEgov().setMittente(spcoopHeaderInfo.getMittente());
                }
                if (spcoopHeaderInfo.getTipoDestinatario() != null && !"".equals(spcoopHeaderInfo.getTipoDestinatario())) {
                    headerIntegrazioneRichiesta.getEgov().setTipoDestinatario(spcoopHeaderInfo.getTipoDestinatario());
                }
                if (spcoopHeaderInfo.getDestinatario() != null && !"".equals(spcoopHeaderInfo.getDestinatario())) {
                    headerIntegrazioneRichiesta.getEgov().setDestinatario(spcoopHeaderInfo.getDestinatario());
                }
                if (spcoopHeaderInfo.getTipoServizio() != null && !"".equals(spcoopHeaderInfo.getTipoServizio())) {
                    headerIntegrazioneRichiesta.getEgov().setTipoServizio(spcoopHeaderInfo.getTipoServizio());
                }
                if (spcoopHeaderInfo.getServizio() != null && !"".equals(spcoopHeaderInfo.getServizio())) {
                    headerIntegrazioneRichiesta.getEgov().setServizio(spcoopHeaderInfo.getServizio());
                }
                if (spcoopHeaderInfo.getAzione() != null && !"".equals(spcoopHeaderInfo.getAzione())) {
                    headerIntegrazioneRichiesta.getEgov().setAzione(spcoopHeaderInfo.getAzione());
                }
                if (spcoopHeaderInfo.getID() != null && !"".equals(spcoopHeaderInfo.getID())) {
                    headerIntegrazioneRichiesta.getEgov().setID(spcoopHeaderInfo.getID());
                }
                if (spcoopHeaderInfo.getIdCollaborazione() != null && !"".equals(spcoopHeaderInfo.getIdCollaborazione())) {
                    headerIntegrazioneRichiesta.getEgov().setIdCollaborazione(spcoopHeaderInfo.getIdCollaborazione());
                }
                if (spcoopHeaderInfo.getRiferimentoMessaggio() != null && !"".equals(spcoopHeaderInfo.getRiferimentoMessaggio())) {
                    headerIntegrazioneRichiesta.getEgov().setRiferimentoMessaggio(spcoopHeaderInfo.getRiferimentoMessaggio());
                }
            }
            if (msg.getIDApplicativo() != null && !"".equals(msg.getIDApplicativo())) {
                headerIntegrazioneRichiesta.setIdApplicativo(msg.getIDApplicativo());
            }
            if (msg.getServizioApplicativo() != null && !"".equals(msg.getServizioApplicativo())) {
                headerIntegrazioneRichiesta.setServizioApplicativo(msg.getServizioApplicativo());
            }
            context.setTipoPorta(TipoPdD.DELEGATA);
            context.setCredenziali(credenziali);
            context.setIdModulo("RicezioneContenutiApplicativiIntegrationManager");
            context.setGestioneRisposta(true);
            context.setInvocazionePDPerRiferimento(idInvocazionePerRiferimento != null);
            context.setMessageRequest(axisMsgRequest);
            context.setParPD(parPD);
            context.setHeaderIntegrazioneRichiesta(headerIntegrazioneRichiesta);
            String protocollo = "http";
            if (credenziali.getSubject() != null) {
                protocollo = "https";
            }
            String ip = (String)msgContext.getProperty("openspcoop.remoteAddr");
            String port = (String)msgContext.getProperty("openspcoop.remotePort");
            String user = "";
            if (credenziali.getUsername() != null || credenziali.getSubject() != null) {
                user = ":";
                user = credenziali.getSubject() != null ? user + credenziali.getSubject() : user + credenziali.getUsername();
            }
            context.setFromLocation(protocollo + ":" + ip + ":" + port + user);
            RicezioneContenutiApplicativi gestoreRichiesta = new RicezioneContenutiApplicativi(context);
            gestoreRichiesta.process();
            axisMsgResponse = context.getMessageResponse();
            msgDiag = context.getMsgDiagnostico();
            if (axisMsgResponse == null) break block90;
            esito = Esito.getEsito(axisMsgResponse.getSOAPBody(), context.getProprietaErroreAppl());
            if (axisMsgResponse.getSOAPBody().hasFault()) {
                SPCoopException exc = null;
                try {
                    SOAPFault fault = axisMsgResponse.getSOAPBody().getFault();
                    if (fault.getFaultActor() != null && fault.getFaultActor().equals(context.getProprietaErroreAppl().getFaultActor())) {
                        if (this.propertiesReader.isErroreApplicativoIntoDetails()) {
                            AxisFault f = ((org.apache.axis.message.SOAPFault)fault).getFault();
                            Element[] el = f.getFaultDetails();
                            MessageElement prova = new MessageElement(el[0]);
                            String PROVA = prova.getAsString();
                            exc = ServicesUtils.mapXMLIntoSPCoopException(PROVA);
                        } else {
                            exc = ServicesUtils.mapXMLIntoSPCoopException(fault.getFaultString());
                        }
                        if (exc == null) {
                            throw new Exception("Costruzione Eccezione fallita: null");
                        }
                    }
                }
                catch (Exception e) {
                    msgDiag.logErroreGenerico(e, "buildSPCoopException(" + tipoOperazione + ")");
                    throw new SPCoopException("OPENSPCOOP_ORG_524", "Sistema non disponibile");
                }
                if (exc != null) {
                    exc.buildAxisFault();
                    throw exc;
                }
            }
            Properties headerIntegrazioneRisposta = context.getHeaderIntegrazioneRisposta();
            SPCoopHeaderInfo spcoopHeaderInfoResponse = null;
            if (headerIntegrazioneRisposta != null) {
                Properties keyValue = this.propertiesReader.getKeyValue_HeaderIntegrazioneTrasporto();
                spcoopHeaderInfoResponse = new SPCoopHeaderInfo();
                spcoopHeaderInfoResponse.setID(headerIntegrazioneRisposta.getProperty(keyValue.getProperty("idegov")));
                spcoopHeaderInfoResponse.setRiferimentoMessaggio(headerIntegrazioneRisposta.getProperty(keyValue.getProperty("riferimentoMessaggio")));
                spcoopHeaderInfoResponse.setIdCollaborazione(headerIntegrazioneRisposta.getProperty(keyValue.getProperty("idCollaborazione")));
                spcoopHeaderInfoResponse.setMittente(headerIntegrazioneRisposta.getProperty(keyValue.getProperty("mittente")));
                spcoopHeaderInfoResponse.setTipoMittente(headerIntegrazioneRisposta.getProperty(keyValue.getProperty("tipoMittente")));
                spcoopHeaderInfoResponse.setDestinatario(headerIntegrazioneRisposta.getProperty(keyValue.getProperty("destinatario")));
                spcoopHeaderInfoResponse.setTipoDestinatario(headerIntegrazioneRisposta.getProperty(keyValue.getProperty("tipoDestinatario")));
                spcoopHeaderInfoResponse.setServizio(headerIntegrazioneRisposta.getProperty(keyValue.getProperty("servizio")));
                spcoopHeaderInfoResponse.setTipoServizio(headerIntegrazioneRisposta.getProperty(keyValue.getProperty("tipoServizio")));
                spcoopHeaderInfoResponse.setAzione(headerIntegrazioneRisposta.getProperty(keyValue.getProperty("azione")));
            }
            SPCoopMessage msgReturn = null;
            try {
                msgReturn = new SPCoopMessage(axisMsgResponse, false, spcoopHeaderInfoResponse);
                dimensioneMessaggio = new Long(msgReturn.getMessage().length);
            }
            catch (Exception e) {
                msgDiag.logErroreGenerico(e, "buildSPCoopMessage_response(" + tipoOperazione + ")");
                throw new SPCoopException("OPENSPCOOP_ORG_523", "Sistema non disponibile");
            }
            SPCoopMessage sPCoopMessage = msgReturn;
            Object var41_47 = null;
            try {
                if (stato != null) {
                    stato.releaseResource();
                }
            }
            catch (Exception eClose) {
                // empty catch block
            }
            String location = "...";
            try {
                IConnettore c = null;
                if (context != null && context.getIdEGov() != null) {
                    c = RepositoryConnettori.removeConnettorePD(context.getIdEGov());
                }
                if (c != null) {
                    location = c.getLocation();
                    c.disconnect();
                }
            }
            catch (Exception e) {
                msgDiag.logDisconnectError(e, location);
            }
            PostOutResponseContext postOutResponseContext = new PostOutResponseContext(logCore);
            try {
                postOutResponseContext.setPddContext(pddContext);
                postOutResponseContext.setDataElaborazioneMessaggio(DateManager.getDate());
                postOutResponseContext.setEsito(esito);
                postOutResponseContext.setMessaggio(axisMsgResponse);
                postOutResponseContext.setDimensioneMessaggioBytes(dimensioneMessaggio);
                if (errore != null) {
                    postOutResponseContext.setReturnCode(500);
                } else {
                    postOutResponseContext.setReturnCode(200);
                }
                if (context != null) {
                    postOutResponseContext.setTipoPorta(context.getTipoPorta());
                    postOutResponseContext.setEgov(context.getEgov());
                    postOutResponseContext.setIntegrazione(context.getIntegrazione());
                } else {
                    postOutResponseContext.setTipoPorta(TipoPdD.DELEGATA);
                }
            }
            catch (Exception e) {
                msgDiag.logErroreGenerico(e, "postOutResponse, preparazione contesto");
            }
            GestoreHandlers.postOutResponse(postOutResponseContext, msgDiag);
            return sPCoopMessage;
        }
        try {
            try {
                msgDiag.logErroreGenerico("Risposta non presente", "gestioneRisposta(" + tipoOperazione + ")");
                throw new SPCoopException("OPENSPCOOP_ORG_511", "Sistema non disponibile");
            }
            catch (Exception e) {
                errore = e.getMessage();
                if (e instanceof SPCoopException) {
                    if (esito == null) {
                        esito = Esito.ERRORE_PROCESSAMENTO_PDD_5XX;
                    }
                    throw (SPCoopException)((Object)e);
                }
                msgDiag.logErroreGenerico(e, "invocaPortaDelegata(" + tipoOperazione + ")");
                esito = Esito.ERRORE_PROCESSAMENTO_PDD_5XX;
                throw new SPCoopException("OPENSPCOOP_ORG_500", "Sistema non disponibile");
            }
        }
        catch (Throwable throwable) {
            Object var41_48 = null;
            try {
                if (stato != null) {
                    stato.releaseResource();
                }
            }
            catch (Exception eClose) {
                // empty catch block
            }
            String location = "...";
            try {
                IConnettore c = null;
                if (context != null && context.getIdEGov() != null) {
                    c = RepositoryConnettori.removeConnettorePD(context.getIdEGov());
                }
                if (c != null) {
                    location = c.getLocation();
                    c.disconnect();
                }
            }
            catch (Exception e) {
                msgDiag.logDisconnectError(e, location);
            }
            PostOutResponseContext postOutResponseContext = new PostOutResponseContext(logCore);
            try {
                postOutResponseContext.setPddContext(pddContext);
                postOutResponseContext.setDataElaborazioneMessaggio(DateManager.getDate());
                postOutResponseContext.setEsito(esito);
                postOutResponseContext.setMessaggio(axisMsgResponse);
                postOutResponseContext.setDimensioneMessaggioBytes(dimensioneMessaggio);
                if (errore != null) {
                    postOutResponseContext.setReturnCode(500);
                } else {
                    postOutResponseContext.setReturnCode(200);
                }
                if (context != null) {
                    postOutResponseContext.setTipoPorta(context.getTipoPorta());
                    postOutResponseContext.setEgov(context.getEgov());
                    postOutResponseContext.setIntegrazione(context.getIntegrazione());
                } else {
                    postOutResponseContext.setTipoPorta(TipoPdD.DELEGATA);
                }
            }
            catch (Exception e) {
                msgDiag.logErroreGenerico(e, "postOutResponse, preparazione contesto");
            }
            GestoreHandlers.postOutResponse(postOutResponseContext, msgDiag);
            throw throwable;
        }
    }

    public SPCoopMessage invocaPortaDelegata(String portaDelegata, SPCoopMessage msg) throws SPCoopException {
        String tipoOperazione = "invocaPortaDelegata";
        return this.invocaPortaDelegata_engine(tipoOperazione, portaDelegata, msg, null);
    }

    public SPCoopMessage invocaPortaDelegataPerRiferimento(String portaDelegata, SPCoopMessage msg, String riferimentoMessaggio) throws SPCoopException {
        String tipoOperazione = "invocaPortaDelegataPerRiferimento";
        return this.invocaPortaDelegata_engine(tipoOperazione, portaDelegata, msg, riferimentoMessaggio);
    }

    public SPCoopMessage sendRispostaAsincronaSimmetrica(String portaDelegata, SPCoopMessage msg) throws SPCoopException {
        String tipoOperazione = "sendRispostaAsincronaSimmetrica";
        return this.invocaPortaDelegata_engine(tipoOperazione, portaDelegata, msg, null);
    }

    public SPCoopMessage sendRichiestaStatoAsincronaAsimmetrica(String portaDelegata, SPCoopMessage msg) throws SPCoopException {
        String tipoOperazione = "sendRichiestaStatoAsincronaAsimmetrica";
        return this.invocaPortaDelegata_engine(tipoOperazione, portaDelegata, msg, null);
    }
}

