/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop.pdd.services;

import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.soap.SOAPException;
import org.apache.axis.AxisFault;
import org.apache.axis.Message;
import org.apache.axis.encoding.Base64;
import org.apache.axis.message.SOAPBody;
import org.apache.axis.message.SOAPEnvelope;
import org.apache.axis.message.SOAPHeader;
import org.apache.axis.message.SOAPHeaderElement;
import org.openspcoop.dao.commons.TransferLengthModes;
import org.openspcoop.pdd.config.OpenSPCoopProperties;
import org.openspcoop.pdd.core.ParametriInvocazionePorta;
import org.openspcoop.pdd.core.ParametriPortaDelegata;
import org.openspcoop.pdd.core.autenticazione.Credenziali;
import org.openspcoop.utils.UtilsException;

public class ServletUtils {
    public static boolean isContentTypeSupported(String cType) {
        if (cType == null) {
            return false;
        }
        if (cType.trim().startsWith("text/xml")) {
            return true;
        }
        return cType.trim().startsWith("multipart/related");
    }

    public static String readContentTypeFromHeader(HttpServletRequest req) throws Exception {
        Enumeration enTrasporto = req.getHeaderNames();
        while (enTrasporto.hasMoreElements()) {
            String nomeProperty = (String)enTrasporto.nextElement();
            if (!"Content-Type".equalsIgnoreCase(nomeProperty)) continue;
            String ct = req.getHeader(nomeProperty);
            if (ct == null) {
                return "Non valorizzato (null)";
            }
            return ct;
        }
        return "Non presente";
    }

    public static Credenziali getCredenziali(HttpServletRequest req) throws Exception {
        X509Certificate[] certs;
        String decodeAuth;
        String[] decodeAuthSplit;
        Credenziali credenziali = new Credenziali();
        String auth = req.getHeader("Authorization");
        if (auth != null && (decodeAuthSplit = (decodeAuth = new String(Base64.decode((String)auth.substring(6)))).split(":")).length > 1) {
            credenziali.setUsername(decodeAuthSplit[0]);
            credenziali.setPassword(decodeAuthSplit[1]);
        }
        if ((certs = (X509Certificate[])req.getAttribute("javax.servlet.request.X509Certificate")) != null && certs.length > 0) {
            credenziali.setSubject(certs[0].getSubjectX500Principal().toString());
            credenziali.setCertificati(certs);
        }
        return credenziali;
    }

    public static Message cleanEmptyBodyFix(Message axisMsgRequest, String moduloInAttesa) throws SOAPException, AxisFault {
        if ("RicezioneBusteEGovWS".equals(moduloInAttesa) || "RicezioneContenutiApplicativiWS".equals(moduloInAttesa)) {
            SOAPBody body = (SOAPBody)axisMsgRequest.getSOAPBody();
            if (body.hasChildNodes() && "OpenSPCoop_Body_Vuoto".equals(body.getFirstChild().getLocalName())) {
                body.removeContents();
            }
            Object var2_2 = null;
        }
        return axisMsgRequest;
    }

    public static void checkAxisMessage(Message axisMsgRequest) throws AxisFault {
        SOAPEnvelope soapEnvelope = null;
        String tmp = null;
        try {
            try {
                soapEnvelope = axisMsgRequest.getSOAPEnvelope();
                tmp = soapEnvelope.getAsString();
            }
            catch (Exception ex) {
                throw new AxisFault(ex.toString());
            }
            Object var5_3 = null;
            soapEnvelope = null;
            tmp = null;
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            soapEnvelope = null;
            tmp = null;
            throw throwable;
        }
    }

    public static String getLocation(HttpServletRequest req, Credenziali credenziali) {
        String protocollo = "http";
        if (credenziali.getSubject() != null) {
            protocollo = "https";
        }
        String ip = req.getRemoteAddr();
        String port = "" + req.getRemotePort();
        String user = "";
        if (credenziali.getUsername() != null || credenziali.getSubject() != null) {
            user = ":";
            user = credenziali.getSubject() != null ? user + credenziali.getSubject() : user + credenziali.getUsername();
        }
        return protocollo + ":" + ip + ":" + port + user;
    }

    public static String getSoapAction(HttpServletRequest req) throws Exception {
        Enumeration enTrasporto = req.getHeaderNames();
        while (enTrasporto.hasMoreElements()) {
            String nomeProperty = (String)enTrasporto.nextElement();
            if (!"SOAPAction".equalsIgnoreCase(nomeProperty)) continue;
            String soapAction = req.getHeader(nomeProperty);
            if (soapAction == null) {
                throw new Exception("Header http 'SOAPAction' non valorizzato (null)");
            }
            return soapAction;
        }
        throw new Exception("Header http 'SOAPAction' non presente");
    }

    public static void checkSoapActionQuotedString(String soapAction) throws Exception {
        if (!soapAction.startsWith("\"") || !soapAction.endsWith("\"")) {
            throw new Exception("Header http 'SOAPAction' valorizzato tramite una stringa non quotata (WSI-BP-1.1 R1109)");
        }
    }

    public static ParametriPortaDelegata getParametriPortaDelegata(HttpServletRequest req) {
        String servletContext = req.getServletPath();
        return ServletUtils.getParametriPortaDelegata(req, servletContext);
    }

    public static ParametriPortaDelegata getParametriPortaDelegata(HttpServletRequest req, String servletContext) {
        String locationPD;
        String urlInvocazione;
        if (!servletContext.endsWith("/")) {
            servletContext = servletContext + "/";
        }
        if (!(urlInvocazione = req.getRequestURI()).endsWith("/")) {
            urlInvocazione = urlInvocazione + "/";
        }
        String identificazioneDinamicaPD = locationPD = urlInvocazione.substring(urlInvocazione.indexOf(servletContext) + servletContext.length());
        if (locationPD.indexOf(47) != -1) {
            identificazioneDinamicaPD = locationPD;
            locationPD = identificazioneDinamicaPD.substring(0, identificazioneDinamicaPD.indexOf(47));
        }
        Properties identificazionePDFormBased = new Properties();
        Enumeration en = req.getParameterNames();
        while (en.hasMoreElements()) {
            String nomeProperty = (String)en.nextElement();
            identificazionePDFormBased.setProperty(nomeProperty, req.getParameter(nomeProperty));
        }
        Properties headerTrasporto = new Properties();
        Enumeration enTrasporto = req.getHeaderNames();
        while (enTrasporto.hasMoreElements()) {
            String nomeProperty = (String)enTrasporto.nextElement();
            headerTrasporto.setProperty(nomeProperty, req.getHeader(nomeProperty));
        }
        ParametriPortaDelegata parPD = new ParametriPortaDelegata();
        parPD.setLocation(locationPD);
        parPD.setUrlInvocazione(identificazioneDinamicaPD);
        parPD.setParametersFormBased(identificazionePDFormBased);
        parPD.setParametersTrasporto(headerTrasporto);
        parPD.setNomePortaDelegataURLBased(true);
        return parPD;
    }

    public static ParametriInvocazionePorta getParametriInvocazionePorta(HttpServletRequest req) {
        String urlInvocazione = req.getRequestURI();
        if (!urlInvocazione.endsWith("/")) {
            urlInvocazione = urlInvocazione + "/";
        }
        Properties identificazionePDFormBased = new Properties();
        Enumeration en = req.getParameterNames();
        while (en.hasMoreElements()) {
            String nomeProperty = (String)en.nextElement();
            identificazionePDFormBased.setProperty(nomeProperty, req.getParameter(nomeProperty));
        }
        Properties headerTrasporto = new Properties();
        Enumeration enTrasporto = req.getHeaderNames();
        while (enTrasporto.hasMoreElements()) {
            String nomeProperty = (String)enTrasporto.nextElement();
            headerTrasporto.setProperty(nomeProperty, req.getHeader(nomeProperty));
        }
        ParametriInvocazionePorta parInvokePdD = new ParametriInvocazionePorta();
        parInvokePdD.setUrlInvocazione(urlInvocazione);
        parInvokePdD.setParametersFormBased(identificazionePDFormBased);
        parInvokePdD.setParametersTrasporto(headerTrasporto);
        return parInvokePdD;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String checkMustUnderstand(Message axisMessage) throws AxisFault {
        SOAPEnvelope envelope = null;
        SOAPHeader header = null;
        try {
            try {
                envelope = axisMessage.getSOAPEnvelope();
                header = (SOAPHeader)envelope.getHeader();
                OpenSPCoopProperties openspcoopProperties = OpenSPCoopProperties.getInstance();
                if (openspcoopProperties == null) return null;
                if (openspcoopProperties.isBypassFilterMustUnderstandEnabledForAllHeaders()) {
                    return null;
                }
                Properties filtri = openspcoopProperties.getBypassFilterMustUnderstandProperties();
                if (filtri == null) return null;
                if (filtri.size() <= 0) return null;
                return ServletUtils.checkMustUnderstandAxisHeaderElement(header, filtri);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new AxisFault("BypassMustUnderstand, errore durante il set processed degli header con mustUnderstand='1' e actor non presente: ", (Throwable)ex);
            }
        }
        catch (Throwable throwable) {
            Object var7_10 = null;
            header = null;
            envelope = null;
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String checkSOAPEnvelopeNamespace(Message axisMessage) throws AxisFault {
        SOAPEnvelope envelope = null;
        try {
            try {
                envelope = axisMessage.getSOAPEnvelope();
                if ("http://schemas.xmlsoap.org/soap/envelope/".equals(envelope.getNamespaceURI())) return null;
                return envelope.getNamespaceURI();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new AxisFault("CheckSoapEnvelopeNamespace, errore durante il controllo del namespace del soap envelope: ", (Throwable)ex);
            }
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            envelope = null;
            throw throwable;
        }
    }

    public static String checkMustUnderstandAxisHeaderElement(SOAPHeader header, Properties filtri) throws UtilsException {
        String error = null;
        try {
            Iterator it = header.getChildElements();
            while (it.hasNext()) {
                SOAPHeaderElement element = (SOAPHeaderElement)it.next();
                if (element.getActor() != null || !element.getMustUnderstand()) continue;
                boolean checked = false;
                Enumeration<Object> en = filtri.keys();
                while (en.hasMoreElements()) {
                    String key = (String)en.nextElement();
                    if (!key.equals(element.getLocalName()) || !filtri.get(key).equals(element.getNamespaceURI())) continue;
                    checked = true;
                    break;
                }
                if (checked) continue;
                if (error == null) {
                    error = element.getLocalName();
                    continue;
                }
                error = error + ", " + element.getLocalName();
            }
        }
        catch (Exception e) {
            throw new UtilsException("Utilities.bypassMustUnderstandAxisHeaderElement Riscontrato errore durante l'applicazione del bypassFilter: " + e.getMessage(), (Throwable)e);
        }
        return error;
    }

    public static boolean verificaRispostaRelazioneCodiceTrasporto202(OpenSPCoopProperties openSPCoopProperties, Message responseAxisMessage, boolean gestioneLatoPortaDelegata) throws Exception {
        if (responseAxisMessage == null) {
            return false;
        }
        boolean rispostaPresente = true;
        if (openSPCoopProperties.isHttpEmptyResponseOneWay()) {
            javax.xml.soap.SOAPBody b = responseAxisMessage.getSOAPBody();
            SOAPBody body = null;
            if (b != null) {
                body = (SOAPBody)b;
            }
            javax.xml.soap.SOAPHeader h = null;
            SOAPHeader header = null;
            if (b == null || body == null || body.getChildNodes().getLength() == 0) {
                h = responseAxisMessage.getSOAPHeader();
                if (h != null) {
                    header = (SOAPHeader)h;
                }
                if (h == null || header == null || header.getChildNodes().getLength() == 0) {
                    rispostaPresente = false;
                } else if (gestioneLatoPortaDelegata && !openSPCoopProperties.isHttpOneWay_PD_HTTPEmptyResponse()) {
                    rispostaPresente = false;
                }
            }
            body = null;
            b = null;
            header = null;
            h = null;
        }
        return rispostaPresente;
    }

    public static void setTransferLength(TransferLengthModes transferLengthMode, HttpServletRequest req, HttpServletResponse res, Long responseLength) {
        String requestProtocoll = req.getProtocol();
        if (requestProtocoll != null && requestProtocoll.endsWith("1.1")) {
            if (TransferLengthModes.TRANSFER_ENCODING_CHUNKED.equals(transferLengthMode)) {
                res.setHeader("Transfer-Encoding", "chunked");
            } else if (TransferLengthModes.CONTENT_LENGTH.equals(transferLengthMode) && responseLength != null && responseLength > 0L) {
                res.setContentLength(responseLength.intValue());
            }
        }
    }
}

