/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop.pdd.services;

import java.sql.Timestamp;
import java.util.Hashtable;
import javax.xml.soap.SOAPBody;
import org.apache.axis.AxisFault;
import org.apache.axis.Message;
import org.apache.axis.MessageContext;
import org.apache.axis.message.SOAPEnvelope;
import org.apache.log4j.Logger;
import org.openspcoop.dao.commons.TipoPdD;
import org.openspcoop.pdd.config.OpenSPCoopProperties;
import org.openspcoop.pdd.core.Esito;
import org.openspcoop.pdd.core.ParametriPortaDelegata;
import org.openspcoop.pdd.core.autenticazione.Credenziali;
import org.openspcoop.pdd.core.connettori.IConnettore;
import org.openspcoop.pdd.core.connettori.RepositoryConnettori;
import org.openspcoop.pdd.core.handlers.GestoreHandlers;
import org.openspcoop.pdd.core.handlers.PostOutResponseContext;
import org.openspcoop.pdd.core.handlers.PreInRequestContext;
import org.openspcoop.pdd.logger.MsgDiagnostico;
import org.openspcoop.pdd.logger.OpenSPCoopLogger;
import org.openspcoop.pdd.services.RicezioneContenutiApplicativi;
import org.openspcoop.pdd.services.RicezioneContenutiApplicativiContext;
import org.openspcoop.utils.SoapUtils;
import org.openspcoop.utils.date.DateManager;

public class RicezioneContenutiApplicativiWS {
    public static final String ID_MODULO = "RicezioneContenutiApplicativiWS";

    public void OpenSPCoop_PD(SOAPEnvelope req, SOAPEnvelope res) throws AxisFault {
        OpenSPCoopProperties openSPCoopProperties;
        Timestamp dataIngressoMessaggio = DateManager.getTimestamp();
        MessageContext msgContext = MessageContext.getCurrentContext();
        Logger logCore = OpenSPCoopLogger.getLoggerOpenSPCoopCore();
        if (logCore == null) {
            logCore = Logger.getLogger((String)ID_MODULO);
        }
        if ((openSPCoopProperties = OpenSPCoopProperties.getInstance()) == null) {
            logCore.error((Object)"Inizializzazione di OpenSPCoop non correttamente effettuata: OpenSPCoopProperties");
            try {
                Message msg = new Message((Object)new AxisFault("ErroreInizializzazioneOpenSPCoopProperties"));
                msgContext.setResponseMessage(msg);
                return;
            }
            catch (Exception e) {
                logCore.error((Object)"Errore generazione SOAPFault", (Throwable)e);
                throw new AxisFault("Inizializzazione di OpenSPCoop non correttamente effettuata: OpenSPCoopProperties");
            }
        }
        MsgDiagnostico msgDiag = new MsgDiagnostico(ID_MODULO);
        msgDiag.setPrefixMsgPersonalizzati("ricezioneContenutiApplicativi.");
        PreInRequestContext preInRequestContext = new PreInRequestContext();
        preInRequestContext.setTipoPorta(TipoPdD.DELEGATA);
        Hashtable<String, Object> transportContext = new Hashtable<String, Object>();
        transportContext.put("CONTEXT", msgContext);
        preInRequestContext.setTransportContext(transportContext);
        preInRequestContext.setLogCore(logCore);
        GestoreHandlers.preInRequest(preInRequestContext, msgDiag);
        Message requestAxisMessage = msgContext.getRequestMessage();
        ParametriPortaDelegata parPD = (ParametriPortaDelegata)msgContext.getProperty("openspcoop.pd.parametri");
        parPD.setNomePortaDelegataURLBased(true);
        Credenziali credenziali = (Credenziali)msgContext.getProperty("openspcoop.credenziali");
        RicezioneContenutiApplicativiContext context = null;
        try {
            context = new RicezioneContenutiApplicativiContext(dataIngressoMessaggio, openSPCoopProperties.getIdentitaPortaDefault());
        }
        catch (Exception e) {
            throw new AxisFault("Creazione contesto RicezioneContenutiApplicativi non riuscita");
        }
        context.setTipoPorta(TipoPdD.DELEGATA);
        context.setCredenziali(credenziali);
        context.setIdModulo(ID_MODULO);
        context.setGestioneRisposta(true);
        context.setInvocazionePDPerRiferimento(false);
        context.setMessageRequest(requestAxisMessage);
        context.setParPD(parPD);
        context.setMsgDiagnostico(msgDiag);
        String protocollo = "http";
        if (credenziali.getSubject() != null) {
            protocollo = "https";
        }
        String ip = (String)msgContext.getProperty("openspcoop.remoteAddr");
        String port = (String)msgContext.getProperty("openspcoop.remotePort");
        String user = "";
        if (credenziali.getUsername() != null || credenziali.getSubject() != null) {
            user = ":";
            user = credenziali.getSubject() != null ? user + credenziali.getSubject() : user + credenziali.getUsername();
        }
        context.setFromLocation(protocollo + ":" + ip + ":" + port + user);
        context.setSoapAction(msgContext.getSOAPActionURI());
        RicezioneContenutiApplicativi gestoreRichiesta = new RicezioneContenutiApplicativi(context);
        gestoreRichiesta.process();
        msgContext.setResponseMessage(context.getMessageResponse());
        if (context.getHeaderIntegrazioneRisposta() != null) {
            msgContext.setProperty("HEADER_INTEGRAZIONE", (Object)context.getHeaderIntegrazioneRisposta());
        }
        msgContext.setProperty("GESTIONE_ESITO", (Object)context.getProprietaErroreAppl());
        msgContext.setProperty("GESTIONE_ESITO_MODULO_FUNZIONALE", (Object)"RicezioneContenutiApplicativi");
        if (context.getContentLengthResponse() != null) {
            msgContext.setProperty("RESPONSE_LENGTH_AXIS", (Object)context.getContentLengthResponse());
        }
        String location = "...";
        try {
            IConnettore c = null;
            if (context.getIdEGov() != null) {
                c = RepositoryConnettori.removeConnettorePD(context.getIdEGov());
            }
            if (c != null) {
                location = c.getLocation();
                c.disconnect();
            }
        }
        catch (Exception e) {
            msgDiag.logDisconnectError(e, location);
        }
        PostOutResponseContext postOutResponseContext = new PostOutResponseContext(logCore);
        try {
            postOutResponseContext.setPddContext(context.getPddContext());
            postOutResponseContext.setDataElaborazioneMessaggio(DateManager.getDate());
            if (msgContext.getResponseMessage() != null) {
                SOAPBody body = msgContext.getResponseMessage().getSOAPBody();
                postOutResponseContext.setEsito(Esito.getEsito(body, context.getProprietaErroreAppl()));
                if (body == null) {
                    postOutResponseContext.setReturnCode(202);
                } else if (body.hasFault()) {
                    postOutResponseContext.setReturnCode(500);
                } else {
                    postOutResponseContext.setReturnCode(200);
                }
                if (context.getContentLengthResponse() != null) {
                    postOutResponseContext.setDimensioneMessaggioBytes(context.getContentLengthResponse());
                } else {
                    postOutResponseContext.setDimensioneMessaggioBytes(SoapUtils.getLength((Message)msgContext.getResponseMessage(), (boolean)false));
                }
            } else {
                postOutResponseContext.setEsito(Esito.OK);
                postOutResponseContext.setReturnCode(202);
            }
            postOutResponseContext.setEgov(context.getEgov());
            postOutResponseContext.setIntegrazione(context.getIntegrazione());
            postOutResponseContext.setTipoPorta(context.getTipoPorta());
            postOutResponseContext.setMessaggio(msgContext.getResponseMessage());
        }
        catch (Exception e) {
            msgDiag.logErroreGenerico(e, "postOutResponse, preparazione contesto");
        }
        GestoreHandlers.postOutResponse(postOutResponseContext, msgDiag);
    }
}

