/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop.pdd.services;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.sql.Timestamp;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import javax.xml.soap.AttachmentPart;
import org.apache.axis.AxisFault;
import org.apache.axis.Message;
import org.apache.axis.message.SOAPEnvelope;
import org.apache.log4j.Logger;
import org.openspcoop.dao.commons.IDSoggetto;
import org.openspcoop.dao.commons.TipoPdD;
import org.openspcoop.dao.config.driver.DriverConfigurazioneNotFound;
import org.openspcoop.dao.config.driver.IDPortaDelegata;
import org.openspcoop.dao.registry.driver.DriverRegistroServiziAzioneNotFound;
import org.openspcoop.dao.registry.driver.DriverRegistroServiziCorrelatoNotFound;
import org.openspcoop.dao.registry.driver.DriverRegistroServiziNotFound;
import org.openspcoop.dao.registry.driver.DriverRegistroServiziPortTypeNotFound;
import org.openspcoop.dao.registry.driver.IDServizio;
import org.openspcoop.egov.EGovException;
import org.openspcoop.egov.Integrazione;
import org.openspcoop.egov.ProprietaErroreApplicativo;
import org.openspcoop.egov.RepositoryEGov;
import org.openspcoop.egov.ValidazioneSintattica;
import org.openspcoop.egov.XMLBuilder;
import org.openspcoop.pdd.config.ClassNameProperties;
import org.openspcoop.pdd.config.ConfigurazionePdDReader;
import org.openspcoop.pdd.config.OpenSPCoopProperties;
import org.openspcoop.pdd.config.RichiestaDelegata;
import org.openspcoop.pdd.core.EGovContext;
import org.openspcoop.pdd.core.GestoreCorrelazioneApplicativa;
import org.openspcoop.pdd.core.GestoreMessaggi;
import org.openspcoop.pdd.core.GestoreMessaggiException;
import org.openspcoop.pdd.core.IdentificazionePortaDelegata;
import org.openspcoop.pdd.core.IntegrationContext;
import org.openspcoop.pdd.core.PdDContext;
import org.openspcoop.pdd.core.ValidatoreMessaggiApplicativi;
import org.openspcoop.pdd.core.ValidatoreMessaggiApplicativiException;
import org.openspcoop.pdd.core.autenticazione.Credenziali;
import org.openspcoop.pdd.core.autenticazione.GestoreCredenzialiConfigurationException;
import org.openspcoop.pdd.core.autenticazione.IAutenticazione;
import org.openspcoop.pdd.core.autenticazione.IGestoreCredenziali;
import org.openspcoop.pdd.core.autorizzazione.IAutorizzazione;
import org.openspcoop.pdd.core.autorizzazione.IAutorizzazioneContenuto;
import org.openspcoop.pdd.core.connettori.InfoConnettoreIngresso;
import org.openspcoop.pdd.core.handlers.GestoreHandlers;
import org.openspcoop.pdd.core.handlers.HandlerException;
import org.openspcoop.pdd.core.handlers.InRequestContext;
import org.openspcoop.pdd.core.handlers.InRequestEGovContext;
import org.openspcoop.pdd.core.handlers.OutResponseContext;
import org.openspcoop.pdd.core.integrazione.HeaderIntegrazione;
import org.openspcoop.pdd.core.integrazione.IGestoreIntegrazionePD;
import org.openspcoop.pdd.core.integrazione.IGestoreIntegrazionePDSoap;
import org.openspcoop.pdd.core.node.INodeReceiver;
import org.openspcoop.pdd.core.node.INodeSender;
import org.openspcoop.pdd.core.node.NodeTimeoutException;
import org.openspcoop.pdd.core.state.IOpenSPCoopState;
import org.openspcoop.pdd.core.state.OpenSPCoopState;
import org.openspcoop.pdd.core.state.OpenSPCoopStateful;
import org.openspcoop.pdd.core.state.OpenSPCoopStateless;
import org.openspcoop.pdd.logger.Dump;
import org.openspcoop.pdd.logger.MsgDiagnostico;
import org.openspcoop.pdd.logger.OpenSPCoopLogger;
import org.openspcoop.pdd.logger.Tracciamento;
import org.openspcoop.pdd.logger.TracciamentoException;
import org.openspcoop.pdd.mdb.EsitoLib;
import org.openspcoop.pdd.mdb.Imbustamento;
import org.openspcoop.pdd.mdb.ImbustamentoMessage;
import org.openspcoop.pdd.mdb.InoltroBusteEGov;
import org.openspcoop.pdd.mdb.SbustamentoRisposte;
import org.openspcoop.pdd.services.OpenSPCoopStartup;
import org.openspcoop.pdd.services.RicezioneContenutiApplicativiContext;
import org.openspcoop.pdd.services.RicezioneContenutiApplicativiGestioneRisposta;
import org.openspcoop.pdd.services.RicezioneContenutiApplicativiMessage;
import org.openspcoop.pdd.services.ServletUtils;
import org.openspcoop.pdd.timers.TimerMonitoraggioRisorse;
import org.openspcoop.pdd.timers.TimerThreshold;
import org.openspcoop.registry.RegistroServiziReader;
import org.openspcoop.utils.Loader;
import org.openspcoop.utils.SoapUtils;
import org.openspcoop.utils.date.DateManager;

public class RicezioneContenutiApplicativi {
    public static final String ID_MODULO = "RicezioneContenutiApplicativi";
    public static boolean initializeService = false;
    private static INodeSender nodeSender = null;
    private static INodeReceiver nodeReceiver = null;
    private static Hashtable<String, IGestoreIntegrazionePD> gestoriIntegrazionePD = new Hashtable();
    private static String[] defaultGestoriIntegrazionePD = null;
    private static Hashtable<String, IAutorizzazione> gestoriAutorizzazione = new Hashtable();
    private static Hashtable<String, IAutorizzazioneContenuto> gestoriAutorizzazioneContenuto = new Hashtable();
    private static Hashtable<String, IGestoreCredenziali> gestoriCredenziali = new Hashtable();
    private static String[] tipiGestoriCredenziali = null;
    private RicezioneContenutiApplicativiContext msgContext;
    boolean responseAsByte = false;

    protected static synchronized void initializeService(ClassNameProperties className, OpenSPCoopProperties propertiesReader, Logger logCore) throws Exception {
        int i;
        if (initializeService) {
            return;
        }
        Loader loader = Loader.getInstance();
        String classTypeNodeSender = className.getNodeSender(propertiesReader.getNodeSender());
        try {
            nodeSender = (INodeSender)loader.newInstance(classTypeNodeSender);
            logCore.info((Object)("Inizializzazione gestore NodeSender di tipo " + classTypeNodeSender + " effettuata."));
        }
        catch (Exception e) {
            throw new Exception("Riscontrato errore durante il caricamento della classe [" + classTypeNodeSender + "] da utilizzare per la spedizione nell'infrastruttura: " + e.getMessage());
        }
        String classType = className.getNodeReceiver(propertiesReader.getNodeReceiver());
        try {
            nodeReceiver = (INodeReceiver)loader.newInstance(classType);
            logCore.info((Object)("Inizializzazione gestore NodeReceiver di tipo " + classType + " effettuata."));
        }
        catch (Exception e) {
            throw new Exception("Riscontrato errore durante il caricamento della classe [" + classType + "] da utilizzare per la ricezione dall'infrastruttura: " + e.getMessage());
        }
        defaultGestoriIntegrazionePD = propertiesReader.getTipoIntegrazionePD();
        for (i = 0; i < defaultGestoriIntegrazionePD.length; ++i) {
            classType = className.getIntegrazionePortaDelegata(defaultGestoriIntegrazionePD[i]);
            try {
                gestoriIntegrazionePD.put(defaultGestoriIntegrazionePD[i], (IGestoreIntegrazionePD)loader.newInstance(classType));
                logCore.info((Object)("Inizializzazione gestore integrazione servizioApplicativo->PdD di tipo " + defaultGestoriIntegrazionePD[i] + " effettuata."));
                continue;
            }
            catch (Exception e) {
                throw new Exception("Riscontrato errore durante il caricamento della classe [" + classType + "] da utilizzare per la gestione dell'integrazione di tipo [" + defaultGestoriIntegrazionePD[i] + "]: " + e.getMessage());
            }
        }
        tipiGestoriCredenziali = propertiesReader.getTipoGestoreCredenzialiPD();
        if (tipiGestoriCredenziali != null) {
            for (i = 0; i < tipiGestoriCredenziali.length; ++i) {
                classType = className.getGestoreCredenziali(tipiGestoriCredenziali[i]);
                try {
                    IGestoreCredenziali gestore = (IGestoreCredenziali)loader.newInstance(classType);
                    gestoriCredenziali.put(tipiGestoriCredenziali[i], gestore);
                    continue;
                }
                catch (Exception e) {
                    throw new Exception("Riscontrato errore durante il caricamento della classe [" + classType + "] da utilizzare per la gestione delle credenziali di tipo [" + tipiGestoriCredenziali[i] + "]: " + e.getMessage());
                }
            }
        }
        initializeService = true;
    }

    private static synchronized void aggiornaListaGestoreIntegrazione(String newTipo, ClassNameProperties className, OpenSPCoopProperties propertiesReader, Logger logCore) throws Exception {
        if (gestoriIntegrazionePD.contains(newTipo)) {
            return;
        }
        Loader loader = Loader.getInstance();
        String classType = className.getIntegrazionePortaDelegata(newTipo);
        try {
            gestoriIntegrazionePD.put(newTipo, (IGestoreIntegrazionePD)loader.newInstance(classType));
            logCore.info((Object)("Inizializzazione gestore integrazione servizioApplicativo->PdD di tipo " + newTipo + " effettuata."));
        }
        catch (Exception e) {
            throw new Exception("Riscontrato errore durante il caricamento della classe [" + classType + "] da utilizzare per la gestione dell'integrazione di tipo [" + newTipo + "]: " + e.getMessage());
        }
    }

    private static synchronized void aggiornaListaGestoreAutorizzazione(String newTipo, ClassNameProperties className, OpenSPCoopProperties propertiesReader, Logger logCore) throws Exception {
        if (gestoriAutorizzazione.contains(newTipo)) {
            return;
        }
        Loader loader = Loader.getInstance();
        String classType = className.getAutorizzazione(newTipo);
        try {
            gestoriAutorizzazione.put(newTipo, (IAutorizzazione)loader.newInstance(classType));
            logCore.info((Object)("Inizializzazione gestore autorizzazione di tipo " + newTipo + " effettuata."));
        }
        catch (Exception e) {
            throw new Exception("Riscontrato errore durante il caricamento della classe [" + classType + "] da utilizzare per la gestione dell'autorizzazione di tipo [" + newTipo + "]: " + e.getMessage());
        }
    }

    private static synchronized void aggiornaListaGestoreAutorizzazioneContenuto(String newTipo, ClassNameProperties className, OpenSPCoopProperties propertiesReader, Logger logCore) throws Exception {
        if (gestoriAutorizzazioneContenuto.contains(newTipo)) {
            return;
        }
        Loader loader = Loader.getInstance();
        String classType = className.getAutorizzazioneContenuto(newTipo);
        try {
            gestoriAutorizzazioneContenuto.put(newTipo, (IAutorizzazioneContenuto)loader.newInstance(classType));
            logCore.info((Object)("Inizializzazione gestore autorizzazione contenuto di tipo " + newTipo + " effettuata."));
        }
        catch (Exception e) {
            throw new Exception("Riscontrato errore durante il caricamento della classe [" + classType + "] da utilizzare per la gestione dell'autorizzazione contenuto di tipo [" + newTipo + "]: " + e.getMessage());
        }
    }

    public RicezioneContenutiApplicativi(RicezioneContenutiApplicativiContext context) {
        this.msgContext = context;
    }

    public void process() {
        Logger logCore = OpenSPCoopLogger.getLoggerOpenSPCoopCore();
        if (logCore == null) {
            logCore = Logger.getLogger((String)ID_MODULO);
        }
        MsgDiagnostico msgDiag = this.msgContext.getMsgDiagnostico();
        Message requestMessage = this.msgContext.getMessageRequest();
        if (requestMessage == null) {
            try {
                requestMessage = this.msgContext.getMessageRequestFromByte();
                this.responseAsByte = true;
            }
            catch (Exception e) {
                this.setSOAPFault(logCore, msgDiag, e, "LetturaMessaggioRichiesta");
                return;
            }
        }
        Long dimesioneIngressoMessaggio = null;
        try {
            dimesioneIngressoMessaggio = this.msgContext.getContentLengthRequest() != null ? this.msgContext.getContentLengthRequest() : Long.valueOf(SoapUtils.getLength((Message)requestMessage, (boolean)true));
        }
        catch (Exception e) {
            this.setSOAPFault(logCore, msgDiag, e, "CalcoloDimensioneRichiesta");
            return;
        }
        InRequestContext inRequestContext = new InRequestContext(logCore);
        inRequestContext.setTipoPorta(TipoPdD.DELEGATA);
        InfoConnettoreIngresso connettore = new InfoConnettoreIngresso();
        connettore.setCredenziali(this.msgContext.getCredenziali());
        if (this.msgContext.getParPD() != null) {
            connettore.setParametersFormBased(this.msgContext.getParPD().getParametersFormBased());
            connettore.setParametersTrasporto(this.msgContext.getParPD().getParametersTrasporto());
            connettore.setUrlInvocazione(this.msgContext.getParPD().getUrlInvocazione_formBased());
        }
        connettore.setSoapAction(this.msgContext.getSoapAction());
        connettore.setFromLocation(this.msgContext.getFromLocation());
        inRequestContext.setConnettore(connettore);
        inRequestContext.setDataElaborazioneMessaggio(this.msgContext.getDataIngressoRichiesta());
        inRequestContext.setPddContext(this.msgContext.getPddContext());
        inRequestContext.setMessaggio(requestMessage);
        inRequestContext.setDimensioneMessaggioBytes(dimesioneIngressoMessaggio);
        try {
            GestoreHandlers.inRequest(inRequestContext, msgDiag);
        }
        catch (HandlerException e) {
            this.setSOAPFault(logCore, msgDiag, e, e.getIdentitaHandler());
            return;
        }
        catch (Exception e) {
            this.setSOAPFault(logCore, msgDiag, e, "InvocazioneInRequestHandler");
            return;
        }
        try {
            this.process_engine(inRequestContext);
        }
        catch (TracciamentoException e) {
            this.setSOAPFault(logCore, msgDiag, e, "TracciamentoNonRiuscito");
            return;
        }
        OutResponseContext outResponseContext = new OutResponseContext(logCore);
        outResponseContext.setTipoPorta(this.msgContext.getTipoPorta());
        outResponseContext.setDataElaborazioneMessaggio(DateManager.getDate());
        outResponseContext.setPddContext(inRequestContext.getPddContext());
        outResponseContext.setEgov(this.msgContext.getEgov());
        outResponseContext.setIntegrazione(this.msgContext.getIntegrazione());
        outResponseContext.setPropertiesRispostaTrasporto(this.msgContext.getHeaderIntegrazioneRisposta());
        Long dimesioneUscitaMessaggio = null;
        Message msgResponse = this.msgContext.getMessageResponse();
        try {
            dimesioneUscitaMessaggio = this.msgContext.getContentLengthResponse() != null ? this.msgContext.getContentLengthResponse() : Long.valueOf(SoapUtils.getLength((Message)msgResponse, (boolean)false));
        }
        catch (Exception e) {
            this.setSOAPFault(logCore, msgDiag, e, "CalcoloDimensioneRisposta");
            return;
        }
        outResponseContext.setDimensioneMessaggioBytes(dimesioneUscitaMessaggio);
        outResponseContext.setMessaggio(msgResponse);
        try {
            GestoreHandlers.outResponse(outResponseContext, msgDiag);
        }
        catch (HandlerException e) {
            this.setSOAPFault(logCore, msgDiag, e, e.getIdentitaHandler());
            return;
        }
        catch (Exception e) {
            this.setSOAPFault(logCore, msgDiag, e, "InvocazioneOutResponseHandler");
            return;
        }
        Message msgRisposta = null;
        try {
            msgRisposta = outResponseContext.getMessaggio();
            boolean rispostaPresente = true;
            OpenSPCoopProperties properties = OpenSPCoopProperties.getInstance();
            if (properties != null) {
                rispostaPresente = ServletUtils.verificaRispostaRelazioneCodiceTrasporto202(OpenSPCoopProperties.getInstance(), msgRisposta, true);
            }
            if (rispostaPresente) {
                if (this.responseAsByte) {
                    this.msgContext.setMessageResponseAsByte(msgRisposta);
                } else {
                    this.msgContext.setMessageResponse(msgRisposta);
                    this.msgContext.setContentLengthResponse(outResponseContext.getDimensioneMessaggioBytes());
                }
            } else {
                this.msgContext.setContentLengthResponse(null);
                this.msgContext.setMessageResponse(null);
                msgRisposta = null;
            }
        }
        catch (Exception e) {
            this.setSOAPFault(logCore, msgDiag, e, "FineGestioneRicezioneContenutiApplicativi");
            return;
        }
        if (Dump.sistemaDumpDisponibile) {
            try {
                ConfigurazionePdDReader configurazionePdDReader = ConfigurazionePdDReader.getInstance();
                if (configurazionePdDReader.dumpMessaggi() && msgRisposta != null) {
                    EGovContext egov = this.msgContext.getEgov();
                    Dump dumpApplicativo = null;
                    dumpApplicativo = egov != null ? new Dump(egov.getIdentificativoPorta(), this.msgContext.getIdModulo(), egov.getIdRichiesta(), egov.getFruitore(), new IDServizio(egov.getErogatore(), egov.getTipoServizio(), egov.getServizio(), egov.getAzione()), this.msgContext.getTipoPorta(), this.msgContext.getPddContext()) : new Dump(null, this.msgContext.getIdModulo(), this.msgContext.getTipoPorta(), this.msgContext.getPddContext());
                    dumpApplicativo.dumpRispostaUscita(msgRisposta, inRequestContext.getConnettore(), outResponseContext.getPropertiesRispostaTrasporto());
                }
            }
            catch (TracciamentoException e) {
                this.setSOAPFault(logCore, msgDiag, e, "TracciamentoNonRiuscito");
                return;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    private void setSOAPFault(Logger logCore, MsgDiagnostico msgDiag, Exception e, String posizione) {
        if (msgDiag != null) {
            msgDiag.logErroreGenerico(e, posizione);
        } else {
            logCore.error((Object)(posizione + ": " + e.getMessage()), (Throwable)e);
        }
        if (this.msgContext.isGestioneRisposta()) {
            AxisFault fault = new AxisFault(posizione);
            Message messageFault = new Message((Object)fault);
            if (this.responseAsByte) {
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                try {
                    messageFault.writeTo((OutputStream)out);
                }
                catch (Exception eWriteTo) {
                    msgDiag.logErroreGenerico(e, "GenerazioneFaultAsBytes");
                }
                this.msgContext.setMessageRequestAsByte(out.toByteArray());
            } else {
                this.msgContext.setMessageResponse(messageFault);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void process_engine(InRequestContext inRequestContext) throws TracciamentoException {
        block305: {
            block302: {
                block300: {
                    block299: {
                        block297: {
                            block298: {
                                requestMessage = inRequestContext.getMessaggio();
                                logCore = inRequestContext.getLogCore();
                                dataIngressoMessaggio = new Timestamp(this.msgContext.getDataIngressoRichiesta().getTime());
                                parPD = this.msgContext.getParPD();
                                credenziali = this.msgContext.getCredenziali();
                                className = ClassNameProperties.getInstance();
                                propertiesReader = OpenSPCoopProperties.getInstance();
                                if (propertiesReader == null) {
                                    logCore.error((Object)"Inizializzazione di OpenSPCoop non correttamente effettuata: OpenSPCoopProperties");
                                    if (this.msgContext.isGestioneRisposta()) {
                                        this.msgContext.setMessageResponse(new Message((Object)new AxisFault("ErroreInizializzazioneOpenSPCoop")));
                                    }
                                    return;
                                }
                                configurazionePdDReader = ConfigurazionePdDReader.getInstance();
                                registroServiziReader = RegistroServiziReader.getInstance();
                                identitaPdD = propertiesReader.getIdentitaPortaDefault();
                                xmlBuilder = new XMLBuilder();
                                proprietaErroreAppl = propertiesReader.getProprietaGestioneErrorePD();
                                proprietaErroreAppl.setDominio(identitaPdD.getCodicePorta());
                                proprietaErroreAppl.setIdModulo(this.msgContext.getIdModulo());
                                if (this.msgContext.isForceFaultAsXML()) {
                                    proprietaErroreAppl.setFaultAsXML(true);
                                }
                                this.msgContext.setProprietaErroreAppl(proprietaErroreAppl);
                                openspcoopstate = null;
                                imbustamentoMSG = new ImbustamentoMessage();
                                this.msgContext.setEgov(new EGovContext());
                                this.msgContext.setIntegrazione(new IntegrationContext());
                                if (!OpenSPCoopStartup.initialize) {
                                    logCore.error((Object)"[RicezioneContenutiApplicativi]  Inizializzazione di OpenSPCoop non correttamente effettuata");
                                    if (this.msgContext.isGestioneRisposta()) {
                                        this.msgContext.setMessageResponse(xmlBuilder.msgErroreApplicativo_Processamento(proprietaErroreAppl, "OPENSPCOOP_ORG_501", "Sistema non disponibile", identitaPdD, this.msgContext.getIdModulo()));
                                    }
                                    return;
                                }
                                if (!TimerMonitoraggioRisorse.risorseDisponibili) {
                                    logCore.error((Object)("[RicezioneContenutiApplicativi]  Risorse di sistema non disponibili: " + TimerMonitoraggioRisorse.risorsaNonDisponibile.getMessage()), (Throwable)TimerMonitoraggioRisorse.risorsaNonDisponibile);
                                    if (this.msgContext.isGestioneRisposta()) {
                                        this.msgContext.setMessageResponse(xmlBuilder.msgErroreApplicativo_Processamento(proprietaErroreAppl, "OPENSPCOOP_ORG_532", "Sistema non disponibile", identitaPdD, this.msgContext.getIdModulo()));
                                    }
                                    return;
                                }
                                if (!TimerThreshold.freeSpace) {
                                    logCore.error((Object)"[RicezioneContenutiApplicativi]  Non sono disponibili abbastanza risorse per la gestione della richiesta");
                                    if (this.msgContext.isGestioneRisposta()) {
                                        this.msgContext.setMessageResponse(xmlBuilder.msgErroreApplicativo_Processamento(proprietaErroreAppl, "OPENSPCOOP_ORG_533", "Sistema non disponibile", identitaPdD, this.msgContext.getIdModulo()));
                                    }
                                    return;
                                }
                                if (!Tracciamento.tracciamentoDisponibile) {
                                    logCore.error((Object)("[RicezioneContenutiApplicativi]  Tracciatura e-Gov non disponibile: " + Tracciamento.motivoMalfunzionamentoTracciamento.getMessage()), (Throwable)Tracciamento.motivoMalfunzionamentoTracciamento);
                                    if (this.msgContext.isGestioneRisposta()) {
                                        this.msgContext.setMessageResponse(xmlBuilder.msgErroreApplicativo_Processamento(proprietaErroreAppl, "OPENSPCOOP_ORG_545", "Sistema non disponibile", identitaPdD, this.msgContext.getIdModulo()));
                                    }
                                    return;
                                }
                                if (!MsgDiagnostico.gestoreDiagnosticaDisponibile) {
                                    logCore.error((Object)("[RicezioneContenutiApplicativi]  Sistema di diagnostica non disponibile: " + MsgDiagnostico.motivoMalfunzionamentoDiagnostici.getMessage()), (Throwable)MsgDiagnostico.motivoMalfunzionamentoDiagnostici);
                                    if (this.msgContext.isGestioneRisposta()) {
                                        this.msgContext.setMessageResponse(xmlBuilder.msgErroreApplicativo_Processamento(proprietaErroreAppl, "OPENSPCOOP_ORG_546", "Sistema non disponibile", identitaPdD, this.msgContext.getIdModulo()));
                                    }
                                    return;
                                }
                                if (!Dump.sistemaDumpDisponibile) {
                                    logCore.error((Object)("[RicezioneContenutiApplicativi]  Sistema di dump dei contenuti applicativi non disponibile: " + Dump.motivoMalfunzionamentoDump.getMessage()), (Throwable)Dump.motivoMalfunzionamentoDump);
                                    if (this.msgContext.isGestioneRisposta()) {
                                        this.msgContext.setMessageResponse(xmlBuilder.msgErroreApplicativo_Processamento(proprietaErroreAppl, "OPENSPCOOP_ORG_547", "Sistema non disponibile", identitaPdD, this.msgContext.getIdModulo()));
                                    }
                                    return;
                                }
                                try {
                                    configurazionePdDReader.verificaConsistenzaConfigurazione();
                                }
                                catch (Exception e) {
                                    logCore.error((Object)"[RicezioneContenutiApplicativi]  Riscontrato errore durante la verifica della consistenza della configurazione PdD", (Throwable)e);
                                    if (this.msgContext.isGestioneRisposta()) {
                                        this.msgContext.setMessageResponse(xmlBuilder.msgErroreApplicativo_Processamento(proprietaErroreAppl, "OPENSPCOOP_ORG_536", "Sistema non disponibile", identitaPdD, this.msgContext.getIdModulo()));
                                    }
                                    return;
                                }
                                try {
                                    registroServiziReader.verificaConsistenzaRegistroServizi();
                                }
                                catch (Exception e) {
                                    logCore.error((Object)"[RicezioneContenutiApplicativi]  Riscontrato errore durante la verifica del registro dei servizi", (Throwable)e);
                                    if (this.msgContext.isGestioneRisposta()) {
                                        this.msgContext.setMessageResponse(xmlBuilder.msgErroreApplicativo_Processamento(proprietaErroreAppl, "OPENSPCOOP_ORG_534", "Sistema non disponibile", identitaPdD, this.msgContext.getIdModulo()));
                                    }
                                    return;
                                }
                                msgDiag = new MsgDiagnostico(identitaPdD.getCodicePorta(), this.msgContext.getIdModulo());
                                this.msgContext.setMsgDiagnostico(msgDiag);
                                msgDiag.setPddContext(inRequestContext.getPddContext());
                                msgDiag.setPrefixMsgPersonalizzati("ricezioneContenutiApplicativi.");
                                msgDiag.setDelegata(true);
                                msgDiag.setPorta(parPD.getLocation() + "_urlInvocazione(" + parPD.getUrlInvocazione() + ")");
                                this.setCredenziali(credenziali, msgDiag);
                                try {
                                    if (!RicezioneContenutiApplicativi.initializeService) {
                                        msgDiag.mediumDebug("Inizializzazione risorse statiche...");
                                        RicezioneContenutiApplicativi.initializeService(className, propertiesReader, logCore);
                                    }
                                }
                                catch (Exception e) {
                                    msgDiag.logErroreGenerico(e, "InizializzazioneRisorseServizioRicezioneContenutiApplicativi");
                                    if (this.msgContext.isGestioneRisposta()) {
                                        this.msgContext.setMessageResponse(xmlBuilder.msgErroreApplicativo_Processamento(proprietaErroreAppl, "OPENSPCOOP_ORG_501", "Sistema non disponibile", identitaPdD, this.msgContext.getIdModulo(), e));
                                    }
                                    return;
                                }
                                loader = Loader.getInstance();
                                if (configurazionePdDReader.dumpMessaggi()) {
                                    dumpApplicativo = new Dump(identitaPdD.getCodicePorta(), this.msgContext.getIdModulo(), this.msgContext.getTipoPorta(), inRequestContext.getPddContext());
                                    dumpApplicativo.dumpRichiestaIngresso(requestMessage, inRequestContext.getConnettore());
                                }
                                msgDiag.mediumDebug("Controllo non esistenza di una busta eGov...");
                                validatoreSintattico = new ValidazioneSintattica(requestMessage);
                                try {
                                    if (!validatoreSintattico.existsHeaderEGov()) break block297;
                                    msgDiag.logPersonalizzato("richiestaContenenteBustaEGov");
                                    if (this.msgContext.isGestioneRisposta()) {
                                        this.msgContext.setMessageResponse(xmlBuilder.msgErroreApplicativo_Processamento(proprietaErroreAppl, "OPENSPCOOP_ORG_420", "Il messaggio Soap inviato al servizio di ricezione contenuti applicativi presenta nell'header una busta eGov", identitaPdD, this.msgContext.getIdModulo()));
                                    }
                                    var20_22 = null;
                                    if (validatoreSintattico == null) break block298;
                                }
                                catch (Throwable var19_25) {
                                    var20_24 = null;
                                    if (validatoreSintattico != null) {
                                        validatoreSintattico.setHeaderSOAP(null);
                                    }
                                    validatoreSintattico = null;
                                    throw var19_25;
                                }
                                validatoreSintattico.setHeaderSOAP(null);
                            }
                            validatoreSintattico = null;
                            return;
                        }
                        var20_23 = null;
                        if (validatoreSintattico != null) {
                            validatoreSintattico.setHeaderSOAP(null);
                        }
                        validatoreSintattico = null;
                        msgDiag.mediumDebug("Identificazione porta delegata e soggetto fruitore...");
                        identificazione = new IdentificazionePortaDelegata(parPD);
                        if (!identificazione.process()) {
                            msgDiag.addKeyword("@ERRORE_PROCESSAMENTO@", identificazione.getMessaggioErrore());
                            msgDiag.logPersonalizzato("portaDelegataNonEsistente");
                            if (this.msgContext.isGestioneRisposta()) {
                                this.msgContext.setMessageResponse(xmlBuilder.msgErroreApplicativo_Processamento(proprietaErroreAppl, identificazione.getCodiceErrore(), identificazione.getMessaggioErrore(), identitaPdD, this.msgContext.getIdModulo()));
                            }
                            return;
                        }
                        parPD.setLocation(identificazione.getNomePDIndivituata());
                        soggettoFruitore = identificazione.getSoggettoSPCoop();
                        pd = identificazione.getPd();
                        identitaPdD = soggettoFruitore;
                        this.msgContext.getEgov().setIdentificativoPorta(identitaPdD.getCodicePorta());
                        idPD = new IDPortaDelegata();
                        idPD.setLocationPD(parPD.getLocation());
                        idPD.setSoggettoFruitore(soggettoFruitore);
                        msgDiag.setDominioSPCoop(identitaPdD.getCodicePorta());
                        msgDiag.setFruitore(soggettoFruitore);
                        msgDiag.addKeyword("@PORTA_DELEGATA@", identificazione.getNomePDIndivituata());
                        msgDiag.addKeywords(soggettoFruitore);
                        proprietaErroreAppl.setDominio(identitaPdD.getCodicePorta());
                        this.msgContext.setProprietaErroreAppl(proprietaErroreAppl);
                        msgDiag.mediumDebug("Lettura header di integrazione...");
                        headerIntegrazioneRichiesta = null;
                        headerIntegrazioneRichiesta = this.msgContext.getHeaderIntegrazioneRichiesta() != null ? this.msgContext.getHeaderIntegrazioneRichiesta() : new HeaderIntegrazione();
                        headerIntegrazioneRisposta = null;
                        tipiIntegrazionePD = null;
                        try {
                            tipiIntegrazionePD = configurazionePdDReader.getTipiIntegrazione(pd);
                        }
                        catch (Exception e) {
                            msgDiag.logErroreGenerico(e, "getTipiIntegrazione(pd)");
                            if (this.msgContext.isGestioneRisposta()) {
                                this.msgContext.setMessageResponse(xmlBuilder.msgErroreApplicativo_Processamento(proprietaErroreAppl, "OPENSPCOOP_ORG_536", "Sistema non disponibile", identitaPdD, this.msgContext.getIdModulo(), e));
                            }
                            return;
                        }
                        if (tipiIntegrazionePD == null) {
                            tipiIntegrazionePD = RicezioneContenutiApplicativi.defaultGestoriIntegrazionePD;
                        }
                        for (i = 0; i < tipiIntegrazionePD.length; ++i) {
                            try {
                                if (!RicezioneContenutiApplicativi.gestoriIntegrazionePD.containsKey(tipiIntegrazionePD[i])) {
                                    RicezioneContenutiApplicativi.aggiornaListaGestoreIntegrazione(tipiIntegrazionePD[i], className, propertiesReader, logCore);
                                }
                                if ((gestore = RicezioneContenutiApplicativi.gestoriIntegrazionePD.get(tipiIntegrazionePD[i])) != null) {
                                    gestore.readHeader(headerIntegrazioneRichiesta, requestMessage, parPD);
                                    continue;
                                }
                                msgDiag.logErroreGenerico("Lettura Gestore header di integrazione [" + tipiIntegrazionePD[i] + "]  non riuscita: non inizializzato", "gestoriIntegrazionePD.get(" + tipiIntegrazionePD[i] + ")");
                                continue;
                            }
                            catch (Exception e) {
                                logCore.debug((Object)("Errore durante la lettura dell'header di integrazione [" + tipiIntegrazionePD[i] + "]: " + e.getMessage()), (Throwable)e);
                                msgDiag.addKeyword("@TIPO_HEADER_INTEGRAZIONE@", tipiIntegrazionePD[i]);
                                msgDiag.addKeyword("@ERRORE_PROCESSAMENTO@", e.toString());
                                msgDiag.logPersonalizzato("headerIntegrazione.letturaFallita");
                            }
                        }
                        if (RicezioneContenutiApplicativi.tipiGestoriCredenziali != null) {
                            msgDiag.mediumDebug("Gestione personalizzata delle credenziali...");
                            for (i = 0; i < RicezioneContenutiApplicativi.tipiGestoriCredenziali.length; ++i) {
                                try {
                                    gestore = RicezioneContenutiApplicativi.gestoriCredenziali.get(RicezioneContenutiApplicativi.tipiGestoriCredenziali[i]);
                                    if (gestore != null) {
                                        credenzialiRitornate = gestore.elaborazioneCredenziali(inRequestContext.getConnettore(), requestMessage);
                                        if (credenzialiRitornate == null) {
                                            throw new Exception("Credenziali non ritornate");
                                        }
                                        if (!inRequestContext.getConnettore().getCredenziali().equals(credenzialiRitornate)) {
                                            nuoveCredenziali = credenzialiRitornate.toString();
                                            nuoveCredenziali = nuoveCredenziali.substring(0, nuoveCredenziali.length() - 1);
                                            msgDiag.addKeyword("@NUOVE_CREDENZIALI@", nuoveCredenziali);
                                            identita = gestore.getIdentitaGestoreCredenziali();
                                            if (identita == null) {
                                                identita = "Gestore delle credenziali di tipo " + RicezioneContenutiApplicativi.tipiGestoriCredenziali[i];
                                            }
                                            msgDiag.addKeyword("@IDENTITA_GESTORE_CREDENZIALI@", identita);
                                            msgDiag.logPersonalizzato("gestoreCredenziali.nuoveCredenziali");
                                            inRequestContext.getConnettore().setCredenziali(credenzialiRitornate);
                                            credenziali = credenzialiRitornate;
                                            this.setCredenziali(credenziali, msgDiag);
                                        }
                                        continue;
                                    }
                                    throw new Exception("non inizializzato");
                                }
                                catch (Exception e) {
                                    logCore.error((Object)("Errore durante l'identificazione delle credenziali [" + RicezioneContenutiApplicativi.tipiGestoriCredenziali[i] + "]: " + e.getMessage()), (Throwable)e);
                                    msgDiag.addKeyword("@TIPO_GESTORE_CREDENZIALI@", RicezioneContenutiApplicativi.tipiGestoriCredenziali[i]);
                                    msgDiag.addKeyword("@ERRORE_PROCESSAMENTO@", e.getMessage());
                                    msgDiag.logPersonalizzato("gestoreCredenziali.errore");
                                    codiceErrore = null;
                                    messaggioErrore = null;
                                    if (e instanceof GestoreCredenzialiConfigurationException) {
                                        codiceErrore = "OPENSPCOOP_ORG_431";
                                        messaggioErrore = "Riscontrato errore durante la gestione delle credenziali effettuata tramite il gestore [#MSG_431_GESTORE_KEY#]: ".replace("#MSG_431_GESTORE_KEY#", RicezioneContenutiApplicativi.tipiGestoriCredenziali[i]) + e.getMessage();
                                    } else {
                                        codiceErrore = "OPENSPCOOP_ORG_548";
                                        messaggioErrore = "Sistema non disponibile";
                                    }
                                    if (this.msgContext.isGestioneRisposta()) {
                                        this.msgContext.setMessageResponse(xmlBuilder.msgErroreApplicativo_Processamento(proprietaErroreAppl, codiceErrore, messaggioErrore, identitaPdD, this.msgContext.getIdModulo(), e));
                                    }
                                    return;
                                }
                            }
                        }
                        msgDiag.mediumDebug("Autenticazione del servizio applicativo...");
                        tipoAutenticazione = identificazione.getTipoAutenticazione();
                        servizioApplicativo = "Anonimo";
                        if ("none".equalsIgnoreCase(tipoAutenticazione)) {
                            if (headerIntegrazioneRichiesta.getServizioApplicativo() != null) {
                                servizioApplicativo = headerIntegrazioneRichiesta.getServizioApplicativo();
                                existsServizioApplicativo = false;
                                try {
                                    existsServizioApplicativo = configurazionePdDReader.existsServizioApplicativo(idPD, servizioApplicativo);
                                }
                                catch (Exception e) {
                                    msgDiag.logErroreGenerico(e, "existsServizioApplicativo(idPD," + servizioApplicativo + ")");
                                    if (this.msgContext.isGestioneRisposta()) {
                                        this.msgContext.setMessageResponse(xmlBuilder.msgErroreApplicativo_Processamento(proprietaErroreAppl, "OPENSPCOOP_ORG_536", "Sistema non disponibile", identitaPdD, this.msgContext.getIdModulo(), e));
                                    }
                                    return;
                                }
                                if (!existsServizioApplicativo) {
                                    msgDiag.addKeyword("@SERVIZIO_APPLICATIVO_FRUITORE@", servizioApplicativo);
                                    msgDiag.logPersonalizzato("servizioApplicativoFruitore.identificazioneTramiteInfoIntegrazioneNonRiuscita");
                                    if (this.msgContext.isGestioneRisposta()) {
                                        this.msgContext.setMessageResponse(xmlBuilder.msgErroreApplicativo_Processamento(proprietaErroreAppl, "OPENSPCOOP_ORG_402", "L'identit\u00e0 del servizio applicativo fornita non esiste nella configurazione della Porta di Dominio: " + servizioApplicativo, identitaPdD, this.msgContext.getIdModulo()));
                                    }
                                    return;
                                }
                            }
                        } else {
                            authClass = className.getAutenticazione(tipoAutenticazione);
                            auth = null;
                            try {
                                auth = (IAutenticazione)loader.newInstance(authClass);
                            }
                            catch (Exception e) {
                                msgDiag.logErroreGenerico(e, "Autenticazione(" + tipoAutenticazione + ") Class.forName(" + authClass + ")");
                                if (this.msgContext.isGestioneRisposta()) {
                                    this.msgContext.setMessageResponse(xmlBuilder.msgErroreApplicativo_Processamento(proprietaErroreAppl, "OPENSPCOOP_ORG_503", "Sistema non disponibile", identitaPdD, this.msgContext.getIdModulo(), e));
                                }
                                return;
                            }
                            if (!auth.process(credenziali, soggettoFruitore, parPD.getLocation())) {
                                msgDiag.addKeyword("@ERRORE_PROCESSAMENTO@", auth.getMsgError());
                                if (credenziali.getUsername() != null && credenziali.getUsername() != null && credenziali.getPassword() != null && !"".equals(credenziali.getPassword())) {
                                    credenzialiFornite = "(";
                                    credenzialiFornite = credenzialiFornite + " Basic Username: [" + credenziali.getUsername() + "]  Basic Password: [" + credenziali.getPassword() + "]";
                                    credenzialiFornite = credenzialiFornite + ") ";
                                    msgDiag.addKeyword("@CREDENZIALI_SA_FRUITORE@", credenzialiFornite);
                                }
                                msgDiag.logPersonalizzato("servizioApplicativoFruitore.identificazioneTramiteCredenziali");
                                if (this.msgContext.isGestioneRisposta()) {
                                    this.msgContext.setMessageResponse(xmlBuilder.msgErroreApplicativo_Processamento(proprietaErroreAppl, auth.getCodiceErrore(), msgDiag.getMessaggio_replaceKeywords("servizioApplicativoFruitore.identificazioneTramiteCredenziali"), identitaPdD, this.msgContext.getIdModulo(), auth.getException()));
                                }
                                return;
                            }
                            servizioApplicativo = auth.getServizioApplicativo();
                        }
                        msgDiag.setPorta(parPD.getLocation());
                        msgDiag.setServizioApplicativo(servizioApplicativo);
                        msgDiag.addKeyword("@SERVIZIO_APPLICATIVO_FRUITORE@", servizioApplicativo);
                        if (!"Anonimo".equals(servizioApplicativo)) {
                            this.msgContext.getIntegrazione().setServizioApplicativoFruitore(servizioApplicativo);
                        }
                        msgDiag.mediumDebug("Get servizio applicativo...");
                        sa = null;
                        try {
                            sa = configurazionePdDReader.getServizioApplicativo(idPD, servizioApplicativo);
                        }
                        catch (Exception e) {
                            if (e instanceof DriverConfigurazioneNotFound && "Anonimo".equals(servizioApplicativo)) break block299;
                            msgDiag.logErroreGenerico(e, "getServizioApplicativo(idPD," + servizioApplicativo + ")");
                            if (this.msgContext.isGestioneRisposta()) {
                                this.msgContext.setMessageResponse(xmlBuilder.msgErroreApplicativo_Processamento(proprietaErroreAppl, "OPENSPCOOP_ORG_536", "Sistema non disponibile", identitaPdD, this.msgContext.getIdModulo(), e));
                            }
                            return;
                        }
                    }
                    msgDiag.mediumDebug("Aggiornamento gestione errore del servizio applicativo...");
                    try {
                        configurazionePdDReader.aggiornaProprietaGestioneErrorePD(proprietaErroreAppl, sa);
                        if (this.msgContext.isForceFaultAsXML()) {
                            proprietaErroreAppl.setFaultAsXML(true);
                        }
                    }
                    catch (Exception e) {
                        msgDiag.logErroreGenerico(e, "aggiornaProprietaGestioneErrorePD(proprietaErroreAppl," + servizioApplicativo + ")");
                        if (this.msgContext.isGestioneRisposta()) {
                            this.msgContext.setMessageResponse(xmlBuilder.msgErroreApplicativo_Processamento(proprietaErroreAppl, "OPENSPCOOP_ORG_536", "Sistema non disponibile", identitaPdD, this.msgContext.getIdModulo(), e));
                        }
                        return;
                    }
                    this.msgContext.setProprietaErroreAppl(proprietaErroreAppl);
                    msgDiag.mediumDebug("Lettura servizio SPCoop associato alla PD invocata...");
                    idModuloInAttesa = null;
                    if (this.msgContext.isGestioneRisposta()) {
                        idModuloInAttesa = this.msgContext.getIdModulo();
                    }
                    richiestaDelegata = new RichiestaDelegata(soggettoFruitore, parPD.getLocation(), servizioApplicativo, idModuloInAttesa, proprietaErroreAppl, identitaPdD);
                    try {
                        if (configurazionePdDReader.identificazioneContentBased(pd)) {
                            soapEnvelopeRequest = requestMessage.getSOAPEnvelope();
                            richiestaDelegata.setIdServizio(configurazionePdDReader.getIDServizio(pd, parPD, soapEnvelopeRequest, headerIntegrazioneRichiesta, this.msgContext.getIdModulo().endsWith("IntegrationManager"), this.msgContext.getSoapAction()));
                        } else {
                            richiestaDelegata.setIdServizio(configurazionePdDReader.getIDServizio(pd, parPD, null, headerIntegrazioneRichiesta, this.msgContext.getIdModulo().endsWith("IntegrationManager"), this.msgContext.getSoapAction()));
                        }
                        if (richiestaDelegata.getIdServizio() == null) {
                            throw new DriverConfigurazioneNotFound("Identificazione Servizio non riuscita");
                        }
                        if (richiestaDelegata.getIdServizio().getSoggettoErogatore() == null || richiestaDelegata.getIdServizio().getSoggettoErogatore().getNome() == null || richiestaDelegata.getIdServizio().getSoggettoErogatore().getTipo() == null) {
                            throw new DriverConfigurazioneNotFound("Identificazione SoggettoErogatore non riuscita");
                        }
                        if (richiestaDelegata.getIdServizio().getTipoServizio() == null || richiestaDelegata.getIdServizio().getServizio() == null) {
                            throw new DriverConfigurazioneNotFound("Identificazione Servizio (tipo/nome) non riuscita");
                        }
                        headerIntegrazioneRisposta = new HeaderIntegrazione();
                        headerIntegrazioneRisposta.getEgov().setTipoMittente(soggettoFruitore.getTipo());
                        headerIntegrazioneRisposta.getEgov().setMittente(soggettoFruitore.getNome());
                        headerIntegrazioneRisposta.getEgov().setTipoDestinatario(richiestaDelegata.getIdServizio().getSoggettoErogatore().getTipo());
                        headerIntegrazioneRisposta.getEgov().setDestinatario(richiestaDelegata.getIdServizio().getSoggettoErogatore().getNome());
                        headerIntegrazioneRisposta.getEgov().setTipoServizio(richiestaDelegata.getIdServizio().getTipoServizio());
                        headerIntegrazioneRisposta.getEgov().setServizio(richiestaDelegata.getIdServizio().getServizio());
                        headerIntegrazioneRisposta.getEgov().setAzione(richiestaDelegata.getIdServizio().getAzione());
                        if (headerIntegrazioneRichiesta.getEgov() != null && headerIntegrazioneRichiesta.getEgov().getRiferimentoMessaggio() != null) {
                            headerIntegrazioneRisposta.getEgov().setRiferimentoMessaggio(headerIntegrazioneRichiesta.getEgov().getRiferimentoMessaggio());
                        }
                    }
                    catch (DriverConfigurazioneNotFound e) {
                        msgDiag.addKeyword("@ERRORE_PROCESSAMENTO@", e.getMessage());
                        msgDiag.logPersonalizzato("identificazioneDinamicaServizioSPCoopNonRiuscita");
                        if (this.msgContext.isGestioneRisposta()) {
                            this.msgContext.setMessageResponse(xmlBuilder.msgErroreApplicativo_Processamento(proprietaErroreAppl, "OPENSPCOOP_ORG_403", "Riscontrato errore durante l'identificazione del servizio SPCoop associato alla porta delegata, utilizzando il pattern specificato nella configurazione", identitaPdD, this.msgContext.getIdModulo(), (Exception)e));
                        }
                        return;
                    }
                    catch (Exception e) {
                        msgDiag.addKeyword("@ERRORE_PROCESSAMENTO@", e.getMessage());
                        msgDiag.logPersonalizzato("identificazioneDinamicaServizioSPCoopNonRiuscita");
                        logCore.error((Object)msgDiag.getMessaggio_replaceKeywords("identificazioneDinamicaServizioSPCoopNonRiuscita"), (Throwable)e);
                        if (this.msgContext.isGestioneRisposta()) {
                            this.msgContext.setMessageResponse(xmlBuilder.msgErroreApplicativo_Processamento(proprietaErroreAppl, "OPENSPCOOP_ORG_536", "Sistema non disponibile", identitaPdD, this.msgContext.getIdModulo(), e));
                        }
                        return;
                    }
                    msgDiag.setServizio(richiestaDelegata.getIdServizio());
                    msgDiag.addKeywords(richiestaDelegata.getIdServizio());
                    idEGovRequest = null;
                    msgDiag.mediumDebug("Inizializzazione connessione al database...");
                    try {
                        openspcoopstate = new OpenSPCoopStateful();
                        openspcoopstate.initResource(identitaPdD, this.msgContext.getIdModulo());
                    }
                    catch (Exception e) {
                        msgDiag.logErroreGenerico(e, "openspcoopstate.initResource()");
                        openspcoopstate.releaseResource();
                        if (this.msgContext.isGestioneRisposta()) {
                            this.msgContext.setMessageResponse(xmlBuilder.msgErroreApplicativo_Processamento(proprietaErroreAppl, "OPENSPCOOP_ORG_505", "Sistema non disponibile", identitaPdD, this.msgContext.getIdModulo(), e));
                        }
                        return;
                    }
                    msgDiag.mediumDebug("Gestione correlazione applicativa...");
                    correlazionePD = null;
                    try {
                        correlazionePD = configurazionePdDReader.getCorrelazioneApplicativa(pd);
                    }
                    catch (Exception e) {
                        msgDiag.logErroreGenerico(e, "getCorrelazioneApplicativa(pd)");
                        openspcoopstate.releaseResource();
                        if (this.msgContext.isGestioneRisposta()) {
                            this.msgContext.setMessageResponse(xmlBuilder.msgErroreApplicativo_Processamento(proprietaErroreAppl, "OPENSPCOOP_ORG_536", "Sistema non disponibile", identitaPdD, this.msgContext.getIdModulo(), e));
                        }
                        return;
                    }
                    correlazioneApplicativa = new GestoreCorrelazioneApplicativa(openspcoopstate.getStatoRichiesta(), logCore, richiestaDelegata.getSoggettoFruitore(), richiestaDelegata.getIdServizio(), servizioApplicativo, propertiesReader.getRepositoryIntervalloScadenzaMessaggi());
                    correlazioneEsistente = false;
                    idCorrelazioneApplicativa = null;
                    if (correlazionePD != null) {
                        try {
                            soapEnvelopeRequest = requestMessage.getSOAPEnvelope();
                            correlazioneEsistente = correlazioneApplicativa.verificaCorrelazione(correlazionePD, parPD.getUrlInvocazione_formBased(), soapEnvelopeRequest, headerIntegrazioneRichiesta, this.msgContext.getIdModulo().endsWith("IntegrationManager"));
                            idCorrelazioneApplicativa = correlazioneApplicativa.getIdCorrelazione();
                            if (correlazioneEsistente) {
                                idEGovRequest = correlazioneApplicativa.getIdEGovCorrelato();
                                msgDiag.setIdEGovRichiesta(idEGovRequest);
                                msgDiag.addKeyword("@ID_CORRELAZIONE_APPLICATIVA@", idCorrelazioneApplicativa);
                                msgDiag.addKeyword("@ID_EGOV_RICHIESTA@", idEGovRequest);
                                msgDiag.logPersonalizzato("correlazioneApplicativaEsistente");
                            }
                        }
                        catch (Exception e) {
                            msgDiag.logErroreGenerico(e, "CorrelazioneApplicativa");
                            logCore.error((Object)("Riscontrato errore durante il controllo di correlazione applicativa: " + e.getMessage()), (Throwable)e);
                            codiceErrore = correlazioneApplicativa.getCodiceErrore();
                            if (codiceErrore == null) {
                                codiceErrore = "OPENSPCOOP_ORG_529";
                            }
                            if ((msgErrore = correlazioneApplicativa.getMsgErrore()) == null) {
                                msgErrore = "Sistema non disponibile";
                            }
                            openspcoopstate.releaseResource();
                            if (this.msgContext.isGestioneRisposta()) {
                                this.msgContext.setMessageResponse(xmlBuilder.msgErroreApplicativo_Processamento(proprietaErroreAppl, codiceErrore, msgErrore, identitaPdD, this.msgContext.getIdModulo(), e));
                            }
                            return;
                        }
                    }
                    if (!correlazioneEsistente) {
                        msgDiag.mediumDebug("Costruzione identificativo eGov...");
                        try {
                            imbustatore = new org.openspcoop.egov.Imbustamento();
                            idEGovRequest = imbustatore.buildID_eGov(identitaPdD.getCodicePorta(), identitaPdD.getNome());
                            if (idEGovRequest == null) {
                                throw new Exception("Identificativo eGov non costruito.");
                            }
                            msgDiag.setIdEGovRichiesta(idEGovRequest);
                        }
                        catch (Exception e) {
                            msgDiag.logErroreGenerico(e, "imbustatore.buildID_eGov(idEGovRequest)");
                            openspcoopstate.releaseResource();
                            if (this.msgContext.isGestioneRisposta()) {
                                this.msgContext.setMessageResponse(xmlBuilder.msgErroreApplicativo_Processamento(proprietaErroreAppl, "OPENSPCOOP_ORG_507", "Sistema non disponibile", identitaPdD, this.msgContext.getIdModulo(), e));
                            }
                            return;
                        }
                        msgDiag.addKeyword("@ID_EGOV_RICHIESTA@", idEGovRequest);
                        if (correlazionePD != null && idCorrelazioneApplicativa != null && correlazioneApplicativa.isRiusoIDEGov()) {
                            msgDiag.mediumDebug("Applicazione correlazione applicativa...");
                            try {
                                correlazioneApplicativa.applicaCorrelazione(correlazionePD, idCorrelazioneApplicativa, idEGovRequest);
                                msgDiag.addKeyword("@ID_CORRELAZIONE_APPLICATIVA@", idCorrelazioneApplicativa);
                                msgDiag.logPersonalizzato("correlazioneApplicativaInstaurata");
                            }
                            catch (Exception e) {
                                msgDiag.logErroreGenerico(e, "CreazioneCorrelazioneApplicativa");
                                codiceErrore = correlazioneApplicativa.getCodiceErrore();
                                if (codiceErrore == null) {
                                    codiceErrore = "OPENSPCOOP_ORG_529";
                                }
                                if ((msgErrore = correlazioneApplicativa.getMsgErrore()) == null) {
                                    msgErrore = "Sistema non disponibile";
                                }
                                openspcoopstate.releaseResource();
                                if (this.msgContext.isGestioneRisposta()) {
                                    this.msgContext.setMessageResponse(xmlBuilder.msgErroreApplicativo_Processamento(proprietaErroreAppl, codiceErrore, msgErrore, identitaPdD, this.msgContext.getIdModulo()));
                                }
                                return;
                            }
                        }
                    }
                    richiestaDelegata.setIdCorrelazioneApplicativa(idCorrelazioneApplicativa);
                    msgDiag.setIdCorrelazioneApplicativa(idCorrelazioneApplicativa);
                    this.msgContext.getIntegrazione().setIdCorrelazioneApplicativa(idCorrelazioneApplicativa);
                    this.msgContext.setIdEGov(idEGovRequest);
                    this.msgContext.getEgov().setIdRichiesta(idEGovRequest);
                    msgDiag.mediumDebug("Gestione header integrazione della risposta...");
                    headerIntegrazioneRisposta.getEgov().setID(idEGovRequest);
                    if (RicezioneContenutiApplicativi.gestoriIntegrazionePD.containsKey("trasporto") || this.msgContext.getIdModulo().startsWith("RicezioneContenutiApplicativiIntegrationManager")) {
                        try {
                            propertiesIntegrazioneRisposta = new Properties();
                            gestore = RicezioneContenutiApplicativi.gestoriIntegrazionePD.get("trasporto");
                            if (gestore != null) {
                                gestore.setResponseHeader(headerIntegrazioneRisposta, null, propertiesIntegrazioneRisposta);
                                this.msgContext.setHeaderIntegrazioneRisposta(propertiesIntegrazioneRisposta);
                            }
                        }
                        catch (Exception e) {
                            msgDiag.logErroreGenerico(e, "setHeaderIntegrazioneRisposta");
                        }
                    }
                    msgDiag.logCorrelazione();
                    msgDiag.logCorrelazioneServizioApplicativo();
                    idServizio = richiestaDelegata.getIdServizio();
                    this.msgContext.getEgov().setFruitore(soggettoFruitore);
                    this.msgContext.getEgov().setErogatore(idServizio.getSoggettoErogatore());
                    this.msgContext.getEgov().setTipoServizio(idServizio.getTipoServizio());
                    this.msgContext.getEgov().setServizio(idServizio.getServizio());
                    this.msgContext.getEgov().setAzione(idServizio.getAzione());
                    this.msgContext.getEgov().setIdRichiesta(idEGovRequest);
                    try {
                        inRequestEGovContext = new InRequestEGovContext(inRequestContext);
                        if (inRequestEGovContext.getConnettore() != null) {
                            inRequestEGovContext.getConnettore().setCredenziali(credenziali);
                        }
                        inRequestEGovContext.setEgov(this.msgContext.getEgov());
                        inRequestEGovContext.setIntegrazione(this.msgContext.getIntegrazione());
                        GestoreHandlers.inRequestEGov(inRequestEGovContext, msgDiag);
                    }
                    catch (Exception e) {
                        if (e instanceof HandlerException) {
                            he = (HandlerException)e;
                            msgDiag.logErroreGenerico(e, he.getIdentitaHandler());
                            logCore.error((Object)("Gestione InRequestEGovHandler non riuscita (" + he.getIdentitaHandler() + "): " + he));
                        } else {
                            msgDiag.logErroreGenerico(e, "InvocazioneInRequestHandler");
                            logCore.error((Object)("Gestione InRequestEGovHandler non riuscita: " + e));
                        }
                        openspcoopstate.releaseResource();
                        if (this.msgContext.isGestioneRisposta()) {
                            this.msgContext.setMessageResponse(xmlBuilder.msgErroreApplicativo_Processamento(proprietaErroreAppl, "OPENSPCOOP_ORG_536", "Sistema non disponibile", identitaPdD, this.msgContext.getIdModulo(), e));
                        }
                        return;
                    }
                    msgDiag.mediumDebug("Autorizzazione del servizio applicativo...");
                    tipoAutorizzazione = identificazione.getTipoAutorizzazione();
                    if (!"none".equalsIgnoreCase(tipoAutorizzazione)) {
                        msgErroreAutorizzazione = null;
                        codiceErroreAutorizzazione = null;
                        eAutorizzazione = null;
                        try {
                            if (!RicezioneContenutiApplicativi.gestoriAutorizzazione.containsKey(tipoAutorizzazione)) {
                                RicezioneContenutiApplicativi.aggiornaListaGestoreAutorizzazione(tipoAutorizzazione, className, propertiesReader, logCore);
                            }
                            if ((auth = RicezioneContenutiApplicativi.gestoriAutorizzazione.get(tipoAutorizzazione)) != null) {
                                esito = auth.process(servizioApplicativo, soggettoFruitore, parPD.getLocation(), richiestaDelegata.getIdServizio(), pd);
                                if (!esito.isServizioAutorizzato()) {
                                    msgErroreAutorizzazione = esito.getMsgErrore();
                                    codiceErroreAutorizzazione = esito.getCodiceErrore();
                                    eAutorizzazione = esito.getEccezioneProcessamento();
                                }
                            } else {
                                msgErroreAutorizzazione = "gestore [" + tipoAutorizzazione + "] non inizializzato";
                                codiceErroreAutorizzazione = "OPENSPCOOP_ORG_504";
                            }
                        }
                        catch (Exception e) {
                            msgErroreAutorizzazione = "processo di autorizzazione [" + tipoAutorizzazione + "] fallito, " + e.getMessage();
                            codiceErroreAutorizzazione = "OPENSPCOOP_ORG_504";
                            eAutorizzazione = e;
                            logCore.error((Object)msgErroreAutorizzazione, (Throwable)e);
                        }
                        if (msgErroreAutorizzazione != null) {
                            msgDiag.addKeyword("@ERRORE_PROCESSAMENTO@", msgErroreAutorizzazione);
                            msgDiag.logPersonalizzato("servizioApplicativoFruitore.nonAutorizzato");
                            openspcoopstate.releaseResource();
                            if (this.msgContext.isGestioneRisposta()) {
                                this.msgContext.setMessageResponse(xmlBuilder.msgErroreApplicativo_Processamento(proprietaErroreAppl, codiceErroreAutorizzazione, msgDiag.getMessaggio_replaceKeywords("servizioApplicativoFruitore.nonAutorizzato"), identitaPdD, this.msgContext.getIdModulo(), eAutorizzazione));
                            }
                            return;
                        }
                    }
                    infoSearch = idServizio.getTipoServizio() + "/" + idServizio.getServizio() + " erogato dal Soggetto " + idServizio.getSoggettoErogatore().getTipo() + "/" + idServizio.getSoggettoErogatore().getNome();
                    if (idServizio.getAzione() != null) {
                        infoSearch = infoSearch + " azione " + idServizio.getAzione();
                    }
                    riferimentoServizioCorrelato = null;
                    if (headerIntegrazioneRichiesta.getEgov() != null && headerIntegrazioneRichiesta.getEgov().getRiferimentoMessaggio() != null) {
                        riferimentoServizioCorrelato = headerIntegrazioneRichiesta.getEgov().getRiferimentoMessaggio();
                    }
                    infoSearch = riferimentoServizioCorrelato != null ? "Servizio correlato " + infoSearch : "Servizio " + infoSearch;
                    infoSearch = "Ricerca nel registro dei servizi di: " + infoSearch;
                    if (riferimentoServizioCorrelato != null) {
                        infoSearch = infoSearch + " (idServizioCorrelato: " + riferimentoServizioCorrelato + ")";
                    }
                    msgDiag.addKeyword("@INFO_SERVIZIO_SPCOOP@", infoSearch);
                    msgDiag.logPersonalizzato("imbustamentoBustaEGov.", "registroServizi.ricercaServizioInCorso");
                    msgDiag.mediumDebug("Ricerca nome registro...");
                    nomeRegistroForSearch = null;
                    try {
                        nomeRegistroForSearch = configurazionePdDReader.getRegistroForImbustamento(soggettoFruitore, idServizio, false);
                    }
                    catch (Exception e) {
                        msgDiag.addKeyword("@ERRORE_PROCESSAMENTO@", "connettore associato al servizio non trovato, " + e.getMessage());
                        msgDiag.logPersonalizzato("imbustamentoBustaEGov.", "registroServizi.ricercaServizioFallita");
                        openspcoopstate.releaseResource();
                        if (this.msgContext.isGestioneRisposta()) {
                            this.msgContext.setMessageResponse(xmlBuilder.msgErroreApplicativo_Processamento(proprietaErroreAppl, "OPENSPCOOP_ORG_514", "Sistema non disponibile", identitaPdD, this.msgContext.getIdModulo(), e));
                        }
                        return;
                    }
                    isServizioCorrelato = false;
                    invocazioneAzioneErrata = null;
                    portTypeErrato = null;
                    ricercaConErrore = false;
                    servizioCorrelatoNonTrovato = false;
                    servizioNonTrovato = false;
                    infoServizio = null;
                    eServiceNotFound = null;
                    try {
                        if (riferimentoServizioCorrelato != null) {
                            erroreRicerca = null;
                            msgDiag.mediumDebug("Ricerca servizio correlato ...");
                            try {
                                infoServizio = registroServiziReader.getInfoServizioCorrelato(soggettoFruitore, idServizio, nomeRegistroForSearch);
                                isServizioCorrelato = true;
                            }
                            catch (DriverRegistroServiziAzioneNotFound e) {
                                invocazioneAzioneErrata = e.getMessage();
                                throw e;
                            }
                            catch (DriverRegistroServiziNotFound e) {
                                erroreRicerca = "\nRicerca come servizio correlato-> " + e.getMessage();
                            }
                            if (infoServizio == null && idServizio.getAzione() != null) {
                                msgDiag.mediumDebug("Ricerca servizio con azione correlata...");
                                try {
                                    infoServizio = registroServiziReader.getInfoServizioAzioneCorrelata(soggettoFruitore, idServizio, nomeRegistroForSearch);
                                    isServizioCorrelato = true;
                                }
                                catch (DriverRegistroServiziAzioneNotFound e) {
                                    invocazioneAzioneErrata = e.getMessage();
                                    throw e;
                                }
                                catch (DriverRegistroServiziNotFound e) {
                                    erroreRicerca = erroreRicerca + "\nRicerca come servizio correlato -> " + e.getMessage();
                                }
                            }
                            if (infoServizio == null && erroreRicerca == null) {
                                throw new DriverRegistroServiziNotFound("Servizio Correlato non trovato ne tramite la normale ricerca, ne tramite la ricerca per azione correlata (solo se profilo e' asincrono asimmetrico)");
                            }
                            if (infoServizio == null) {
                                throw new DriverRegistroServiziNotFound(erroreRicerca);
                            }
                            break block300;
                        }
                        erroreRicerca = null;
                        msgDiag.mediumDebug("Ricerca servizio ...");
                        try {
                            infoServizio = registroServiziReader.getInfoServizio(soggettoFruitore, idServizio, nomeRegistroForSearch, true);
                        }
                        catch (DriverRegistroServiziAzioneNotFound e) {
                            invocazioneAzioneErrata = e.getMessage();
                            throw e;
                        }
                        catch (DriverRegistroServiziNotFound e) {
                            erroreRicerca = "\nRicerca come servizio -> " + e.getMessage();
                        }
                        if (infoServizio == null) {
                            msgDiag.mediumDebug("Ricerca servizio correlato...");
                            try {
                                infoServizio = registroServiziReader.getInfoServizioCorrelato(soggettoFruitore, idServizio, nomeRegistroForSearch);
                                isServizioCorrelato = true;
                            }
                            catch (DriverRegistroServiziAzioneNotFound e) {
                                invocazioneAzioneErrata = e.getMessage();
                                throw e;
                            }
                            catch (DriverRegistroServiziNotFound e) {
                                erroreRicerca = erroreRicerca + "\nRicerca come servizio correlato -> " + e.getMessage();
                            }
                        }
                        if (infoServizio == null && erroreRicerca == null) {
                            throw new DriverRegistroServiziNotFound("Servizio non trovato ne tramite la normale ricerca, ne tramite la ricerca per servizio correlato");
                        }
                        if (infoServizio == null) {
                            throw new DriverRegistroServiziNotFound(erroreRicerca);
                        }
                    }
                    catch (DriverRegistroServiziNotFound e) {
                        eServiceNotFound = e;
                        msgDiag.addKeyword("@ERRORE_PROCESSAMENTO@", e.getMessage());
                        msgDiag.logPersonalizzato("imbustamentoBustaEGov.", "registroServizi.ricercaServizioFallita");
                        servizioNonTrovato = true;
                    }
                    catch (DriverRegistroServiziAzioneNotFound e) {
                        eServiceNotFound = e;
                        msgDiag.addKeyword("@ERRORE_PROCESSAMENTO@", e.getMessage());
                        msgDiag.logPersonalizzato("imbustamentoBustaEGov.", "registroServizi.ricercaServizioFallita");
                    }
                    catch (DriverRegistroServiziPortTypeNotFound e) {
                        eServiceNotFound = e;
                        msgDiag.addKeyword("@ERRORE_PROCESSAMENTO@", "configurazione registro dei servizi errata, " + e.getMessage());
                        msgDiag.logPersonalizzato("imbustamentoBustaEGov.", "registroServizi.ricercaServizioFallita");
                        portTypeErrato = "Configurazione del registro dei Servizi errata: " + e.getMessage();
                    }
                    catch (DriverRegistroServiziCorrelatoNotFound e) {
                        eServiceNotFound = e;
                        msgDiag.addKeyword("@ERRORE_PROCESSAMENTO@", "correlazione asincrona non rilevata, " + e.getMessage());
                        msgDiag.logPersonalizzato("imbustamentoBustaEGov.", "registroServizi.ricercaServizioFallita");
                        servizioCorrelatoNonTrovato = true;
                    }
                    catch (Exception e) {
                        eServiceNotFound = e;
                        msgDiag.addKeyword("@ERRORE_PROCESSAMENTO@", "errore generale, " + e.getMessage());
                        msgDiag.logPersonalizzato("imbustamentoBustaEGov.", "registroServizi.ricercaServizioFallita");
                        logCore.error((Object)"Ricerca servizio fallita", (Throwable)e);
                        ricercaConErrore = true;
                    }
                }
                if (infoServizio == null) {
                    if (!(servizioNonTrovato || ricercaConErrore || servizioCorrelatoNonTrovato || invocazioneAzioneErrata != null)) {
                        msgDiag.addKeyword("@ERRORE_PROCESSAMENTO@", "servizio non esistente");
                        msgDiag.logPersonalizzato("imbustamentoBustaEGov.", "registroServizi.ricercaServizioFallita");
                        servizioNonTrovato = true;
                    }
                    codiceErrore = null;
                    msgErrore = null;
                    if (invocazioneAzioneErrata != null) {
                        codiceErrore = "OPENSPCOOP_ORG_423";
                        msgErrore = "Azione utilizzata con il Servizio SPCoop richiesto con la porta delegata non corretta:  (azione:" + idServizio.getAzione() + ") " + invocazioneAzioneErrata;
                    } else if (portTypeErrato != null) {
                        codiceErrore = "OPENSPCOOP_ORG_540";
                        msgErrore = portTypeErrato;
                    } else if (servizioNonTrovato) {
                        codiceErrore = "OPENSPCOOP_ORG_405";
                        msgErrore = "Servizio SPCoop richiesto con la porta delegata non trovato nel registro dei servizi di OpenSPCoop";
                    } else if (ricercaConErrore) {
                        codiceErrore = "OPENSPCOOP_ORG_534";
                        msgErrore = "Sistema non disponibile";
                    } else if (servizioCorrelatoNonTrovato) {
                        codiceErrore = "OPENSPCOOP_ORG_408";
                        msgErrore = "Servizio correlato (o azione correlata), associato al servizio SPCoop richiesto con la porta delegata, non trovato nel registro dei servizi di OpenSPCoop";
                    } else {
                        codiceErrore = "OPENSPCOOP_ORG_533";
                        msgErrore = "Sistema non disponibile";
                    }
                    openspcoopstate.releaseResource();
                    if (this.msgContext.isGestioneRisposta()) {
                        this.msgContext.setMessageResponse(xmlBuilder.msgErroreApplicativo_Processamento(proprietaErroreAppl, codiceErrore, msgErrore, identitaPdD, this.msgContext.getIdModulo(), (Exception)eServiceNotFound));
                    }
                    return;
                }
                infoServizio.setCorrelato(isServizioCorrelato);
                this.msgContext.getEgov().setProfiloCollaborazione(infoServizio.getProfiloDiCollaborazione());
                msgDiag.addKeyword("@PROFILO_COLLABORAZIONE@", infoServizio.getProfiloDiCollaborazione());
                try {
                    profiloGestione = registroServiziReader.getProfiloGestioneFruizioneServizio(idServizio, nomeRegistroForSearch);
                    richiestaDelegata.setProfiloGestione(profiloGestione);
                    msgDiag.mediumDebug("Profilo di gestione [RicezioneContenutiApplicativi] della busta: " + profiloGestione);
                }
                catch (Exception e) {
                    msgDiag.addKeyword("@ERRORE_PROCESSAMENTO@", "analisi del profilo di gestione fallita, " + e.getMessage());
                    msgDiag.logPersonalizzato("imbustamentoBustaEGov.", "registroServizi.ricercaServizioFallita");
                    openspcoopstate.releaseResource();
                    if (this.msgContext.isGestioneRisposta()) {
                        this.msgContext.setMessageResponse(xmlBuilder.msgErroreApplicativo_Processamento(proprietaErroreAppl, "OPENSPCOOP_ORG_525", "Sistema non disponibile", identitaPdD, this.msgContext.getIdModulo(), e));
                    }
                    return;
                }
                msgDiag.logPersonalizzato("imbustamentoBustaEGov.", "registroServizi.ricercaServizioEffettuata");
                implementazionePdDMittente = null;
                implementazionePdDDestinatario = null;
                msgDiag.mediumDebug("Ricerca implementazione della porta di dominio dei soggetti...");
                try {
                    implementazionePdDMittente = registroServiziReader.getImplementazionePdD(soggettoFruitore, null);
                    implementazionePdDDestinatario = registroServiziReader.getImplementazionePdD(idServizio.getSoggettoErogatore(), null);
                }
                catch (Exception e) {
                    msgDiag.logErroreGenerico(e, "ricercaImplementazioniPdD");
                    openspcoopstate.releaseResource();
                    if (this.msgContext.isGestioneRisposta()) {
                        this.msgContext.setMessageResponse(xmlBuilder.msgErroreApplicativo_Processamento(proprietaErroreAppl, "OPENSPCOOP_ORG_534", "Sistema non disponibile", identitaPdD, this.msgContext.getIdModulo(), e));
                    }
                    return;
                }
                msgDiag.mediumDebug("ImplementazionePdD soggetto (" + soggettoFruitore.toString() + ") e' [" + implementazionePdDMittente + "], soggetto (" + idServizio.getSoggettoErogatore().toString() + ") e' [" + implementazionePdDDestinatario + "]");
                msgDiag.mediumDebug("Controllo validazione xsd abilitata/disabilitata...");
                validazioneContenutoApplicativoApplicativo = null;
                try {
                    validazioneContenutoApplicativoApplicativo = configurazionePdDReader.getTipoValidazioneContenutoApplicativo(pd, implementazionePdDDestinatario);
                }
                catch (Exception e) {
                    msgDiag.logErroreGenerico(e, "getTipoValidazioneContenutoApplicativo(pd," + implementazionePdDDestinatario + ")");
                    openspcoopstate.releaseResource();
                    if (this.msgContext.isGestioneRisposta()) {
                        this.msgContext.setMessageResponse(xmlBuilder.msgErroreApplicativo_Processamento(proprietaErroreAppl, "OPENSPCOOP_ORG_536", "Sistema non disponibile", identitaPdD, this.msgContext.getIdModulo(), e));
                    }
                    return;
                }
                if ("abilitato".equals(validazioneContenutoApplicativoApplicativo.getStato()) || "warningOnly".equals(validazioneContenutoApplicativoApplicativo.getStato())) {
                    binXSD = null;
                    try {
                        block301: {
                            msgDiag.mediumDebug("Validatore contenuti applicativi della richiesta...");
                            readWSDL = "wsdl".equals(validazioneContenutoApplicativoApplicativo.getTipo());
                            validatoreMessaggiApplicativi = new ValidatoreMessaggiApplicativi(registroServiziReader, richiestaDelegata.getIdServizio(), requestMessage.getSOAPBody(), readWSDL);
                            checkStyle = false;
                            if (richiestaDelegata.getIdServizio().getAzione() != null && (readWSDL || "openspcoop".equals(validazioneContenutoApplicativoApplicativo.getTipo()))) {
                                checkStyle = true;
                            }
                            msgDiag.mediumDebug("Validazione xsd della richiesta (validazione)...");
                            validatoreMessaggiApplicativi.validateWithWsdlDefinitorio(true, checkStyle);
                            if (richiestaDelegata.getIdServizio().getAzione() == null || !"wsdl".equals(validazioneContenutoApplicativoApplicativo.getTipo()) && !"openspcoop".equals(validazioneContenutoApplicativoApplicativo.getTipo())) break block301;
                            msgDiag.mediumDebug("Validazione wsdl della richiesta ...");
                            validatoreMessaggiApplicativi.validateWithWsdlLogicoImplementativo(true, this.msgContext.getSoapAction());
                        }
                        var57_114 = null;
                        ** if (binXSD == null) goto lbl-1000
                    }
                    catch (Throwable var56_124) {
                        var57_117 = null;
                        if (binXSD != null) {
                            try {
                                binXSD.close();
                            }
                            catch (Exception e) {
                                // empty catch block
                            }
                        }
                        throw var56_124;
                    }
lbl-1000:
                    // 1 sources

                    {
                        try {
                            binXSD.close();
                        }
                        catch (Exception e) {}
                    }
lbl-1000:
                    // 2 sources

                    {
                        break block302;
                        catch (ValidatoreMessaggiApplicativiException ex) {
                            msgDiag.addKeyword("@ERRORE_PROCESSAMENTO@", ex.getMessage());
                            msgDiag.logPersonalizzato("validazioneContenutiApplicativiNonRiuscita");
                            if (!"warningOnly".equals(validazioneContenutoApplicativoApplicativo.getStato())) {
                                openspcoopstate.releaseResource();
                                if (this.msgContext.isGestioneRisposta()) {
                                    this.msgContext.setMessageResponse(xmlBuilder.msgErroreApplicativo_Processamento(proprietaErroreAppl, ex.getCodiceErrore(), ex.getMsgErrore(), identitaPdD, this.msgContext.getIdModulo(), (Exception)ex));
                                }
                                var57_115 = null;
                                if (binXSD != null) {
                                    try {
                                        binXSD.close();
                                    }
                                    catch (Exception e) {
                                        // empty catch block
                                    }
                                }
                                return;
                            }
                            var57_114 = null;
                            if (binXSD != null) {
                                try {
                                    binXSD.close();
                                }
                                catch (Exception e) {}
                            }
                            break block302;
                        }
                        catch (Exception ex) {
                            msgDiag.addKeyword("@ERRORE_PROCESSAMENTO@", ex.getMessage());
                            msgDiag.logPersonalizzato("validazioneContenutiApplicativiNonRiuscita");
                            logCore.error((Object)"Riscontrato errore durante la validazione xsd della richiesta applicativa", (Throwable)ex);
                            if (!"warningOnly".equals(validazioneContenutoApplicativoApplicativo.getStato())) {
                                openspcoopstate.releaseResource();
                                if (this.msgContext.isGestioneRisposta()) {
                                    this.msgContext.setMessageResponse(xmlBuilder.msgErroreApplicativo_Processamento(proprietaErroreAppl, "OPENSPCOOP_ORG_531", "Sistema non disponibile", identitaPdD, this.msgContext.getIdModulo(), ex));
                                }
                                var57_116 = null;
                                if (binXSD != null) {
                                    try {
                                        binXSD.close();
                                    }
                                    catch (Exception e) {
                                        // empty catch block
                                    }
                                }
                                return;
                            }
                            var57_114 = null;
                            if (binXSD != null) {
                                try {
                                    binXSD.close();
                                }
                                catch (Exception e) {}
                            }
                        }
                    }
                }
            }
            msgDiag.mediumDebug("Autorizzazione del servizio applicativo...");
            tipoAutorizzazioneContenuto = identificazione.getTipoAutorizzazioneContenuto();
            if (!"none".equalsIgnoreCase(tipoAutorizzazioneContenuto)) {
                msgErroreAutorizzazione = null;
                codiceErroreAutorizzazione = null;
                eAutorizzazione = null;
                try {
                    if (!RicezioneContenutiApplicativi.gestoriAutorizzazioneContenuto.containsKey(tipoAutorizzazioneContenuto)) {
                        RicezioneContenutiApplicativi.aggiornaListaGestoreAutorizzazioneContenuto(tipoAutorizzazioneContenuto, className, propertiesReader, logCore);
                    }
                    if ((auth = RicezioneContenutiApplicativi.gestoriAutorizzazioneContenuto.get(tipoAutorizzazioneContenuto)) != null) {
                        esito = auth.process(servizioApplicativo, soggettoFruitore, parPD.getLocation(), richiestaDelegata.getIdServizio(), pd, requestMessage);
                        if (!esito.isServizioAutorizzato()) {
                            msgErroreAutorizzazione = esito.getMsgErrore();
                            codiceErroreAutorizzazione = esito.getCodiceErrore();
                            eAutorizzazione = esito.getEccezioneProcessamento();
                        }
                    } else {
                        msgErroreAutorizzazione = "gestore [" + tipoAutorizzazioneContenuto + "] non inizializzato";
                        codiceErroreAutorizzazione = "OPENSPCOOP_ORG_542";
                    }
                }
                catch (Exception e) {
                    msgErroreAutorizzazione = "processo di autorizzazione [" + tipoAutorizzazioneContenuto + "] fallito, " + e.getMessage();
                    codiceErroreAutorizzazione = "OPENSPCOOP_ORG_542";
                    eAutorizzazione = e;
                    logCore.error((Object)msgErroreAutorizzazione, (Throwable)e);
                }
                if (msgErroreAutorizzazione != null) {
                    msgDiag.addKeyword("@ERRORE_PROCESSAMENTO@", msgErroreAutorizzazione);
                    msgDiag.logPersonalizzato("servizioApplicativoFruitore.contenuto.nonAutorizzato");
                    openspcoopstate.releaseResource();
                    if (this.msgContext.isGestioneRisposta()) {
                        this.msgContext.setMessageResponse(xmlBuilder.msgErroreApplicativo_Processamento(proprietaErroreAppl, codiceErroreAutorizzazione, msgDiag.getMessaggio_replaceKeywords("servizioApplicativoFruitore.contenuto.nonAutorizzato"), identitaPdD, this.msgContext.getIdModulo(), eAutorizzazione));
                    }
                    return;
                }
            }
            msgDiag.mediumDebug("Controllo tipo di invocazione (riferimento/normale)...");
            invocazionePDPerRiferimento = false;
            try {
                invocazionePDPerRiferimento = configurazionePdDReader.invocazionePortaDelegataPerRiferimento(sa);
            }
            catch (Exception e) {
                msgDiag.logErroreGenerico(e, "invocazionePortaDelegataPerRiferimento(sa)");
                openspcoopstate.releaseResource();
                if (this.msgContext.isGestioneRisposta()) {
                    this.msgContext.setMessageResponse(xmlBuilder.msgErroreApplicativo_Processamento(proprietaErroreAppl, "OPENSPCOOP_ORG_536", "Sistema non disponibile", identitaPdD, this.msgContext.getIdModulo(), e));
                }
                return;
            }
            if (invocazionePDPerRiferimento) {
                if (!this.msgContext.isInvocazionePDPerRiferimento()) {
                    msgDiag.logPersonalizzato("portaDelegataInvocabilePerRiferimento.riferimentoNonPresente");
                    openspcoopstate.releaseResource();
                    if (this.msgContext.isGestioneRisposta()) {
                        this.msgContext.setMessageResponse(xmlBuilder.msgErroreApplicativo_Processamento(proprietaErroreAppl, "OPENSPCOOP_ORG_412", "Il servizio applicativo \u00e8 autorizzato ad invocare la porta delegata solo attraverso una invocazione per riferimento, effettuabile tramite il servizio IntegrationManager", identitaPdD, this.msgContext.getIdModulo()));
                    }
                    return;
                }
            } else if (this.msgContext.isInvocazionePDPerRiferimento()) {
                msgDiag.logPersonalizzato("portaDelegataInvocabileNormalmente.riferimentoPresente");
                openspcoopstate.releaseResource();
                if (this.msgContext.isGestioneRisposta()) {
                    this.msgContext.setMessageResponse(xmlBuilder.msgErroreApplicativo_Processamento(proprietaErroreAppl, "OPENSPCOOP_ORG_413", "Il servizio applicativo non \u00e8 autorizzato ad invocare la porta delegata tramite una invocazione per riferimento effettuata attraverso il servizio IntegrationManager", identitaPdD, this.msgContext.getIdModulo()));
                }
                return;
            }
            msgDiag.logPersonalizzato("ricevutaRichiestaApplicativa");
            for (i = 0; i < tipiIntegrazionePD.length; ++i) {
                try {
                    gestore = RicezioneContenutiApplicativi.gestoriIntegrazionePD.get(tipiIntegrazionePD[i]);
                    if (gestore == null || !(gestore instanceof IGestoreIntegrazionePDSoap)) continue;
                    if (propertiesReader.deleteHeaderIntegrazionePD()) {
                        ((IGestoreIntegrazionePDSoap)gestore).deleteHeader(requestMessage);
                        continue;
                    }
                    servizioApplicativoDaInserireHeader = null;
                    if (!"Anonimo".equals(servizioApplicativo)) {
                        servizioApplicativoDaInserireHeader = servizioApplicativo;
                    }
                    ((IGestoreIntegrazionePDSoap)gestore).updateHeader(requestMessage, soggettoFruitore, idServizio, idEGovRequest, servizioApplicativoDaInserireHeader, idCorrelazioneApplicativa);
                    continue;
                }
                catch (Exception e) {
                    if (propertiesReader.deleteHeaderIntegrazionePD()) {
                        msgDiag.logErroreGenerico(e, "deleteHeaderIntegrazione(" + tipiIntegrazionePD[i] + ")");
                    } else {
                        msgDiag.logErroreGenerico(e, "updateHeaderIntegrazione(" + tipiIntegrazionePD[i] + ")");
                    }
                    openspcoopstate.releaseResource();
                    if (this.msgContext.isGestioneRisposta()) {
                        this.msgContext.setMessageResponse(xmlBuilder.msgErroreApplicativo_Processamento(proprietaErroreAppl, "OPENSPCOOP_ORG_541", "Sistema non disponibile", identitaPdD, this.msgContext.getIdModulo(), e));
                    }
                    return;
                }
            }
            allegaBody = false;
            scartaBody = false;
            try {
                allegaBody = configurazionePdDReader.isAllegaBody(pd);
                scartaBody = configurazionePdDReader.isScartaBody(pd);
            }
            catch (Exception e) {
                msgDiag.logErroreGenerico(e, "configurazionePdDReader.isAllega/ScartaBody(pd)");
                openspcoopstate.releaseResource();
                if (this.msgContext.isGestioneRisposta()) {
                    this.msgContext.setMessageResponse(xmlBuilder.msgErroreApplicativo_Processamento(proprietaErroreAppl, "OPENSPCOOP_ORG_536", "Sistema non disponibile", identitaPdD, this.msgContext.getIdModulo(), e));
                }
                return;
            }
            if (scartaBody) {
                try {
                    if (requestMessage.countAttachments() <= 0) {
                        throw new Exception("La funzionalita' e' permessa solo per messaggi SOAP With Attachments");
                    }
                }
                catch (Exception e) {
                    msgDiag.addKeyword("@ERRORE_PROCESSAMENTO@", e.getMessage());
                    msgDiag.logPersonalizzato("funzionalitaScartaBodyNonEffettuabile");
                    openspcoopstate.releaseResource();
                    if (this.msgContext.isGestioneRisposta()) {
                        this.msgContext.setMessageResponse(xmlBuilder.msgErroreApplicativo_Processamento(proprietaErroreAppl, "OPENSPCOOP_ORG_425", "Funzionalit\u00e0 'scarta body' non \u00e8 riuscito ad utilizzare il messaggio inviato dal client: " + e.getMessage(), identitaPdD, this.msgContext.getIdModulo(), e));
                    }
                    return;
                }
            }
            if (allegaBody) {
                try {
                    if (requestMessage.countAttachments() > 0) {
                        throw new Exception("La funzionalita' non e' permessa per messaggi SOAP With Attachments");
                    }
                    body = SoapUtils.sbustamentoSOAPEnvelope((SOAPEnvelope)requestMessage.getSOAPEnvelope());
                    ap = (org.apache.axis.attachments.AttachmentPart)requestMessage.createAttachmentPart();
                    isContent = new ByteArrayInputStream(body);
                    ap.setContent((Object)isContent, "text/xml");
                    requestMessage.addAttachmentPart((AttachmentPart)ap);
                    requestMessage.getSOAPBody().removeContents();
                }
                catch (Exception e) {
                    msgDiag.addKeyword("@ERRORE_PROCESSAMENTO@", e.getMessage());
                    msgDiag.logPersonalizzato("funzionalitaAllegaBodyNonEffettuabile");
                    openspcoopstate.releaseResource();
                    if (this.msgContext.isGestioneRisposta()) {
                        this.msgContext.setMessageResponse(xmlBuilder.msgErroreApplicativo_Processamento(proprietaErroreAppl, "OPENSPCOOP_ORG_424", "Funzionalit\u00e0 'allega body' non \u00e8 riuscito ad utilizzare il messaggio inviato dal client: " + e.getMessage(), identitaPdD, this.msgContext.getIdModulo(), e));
                    }
                    return;
                }
            }
            oneWayStateless = false;
            oneWayVersione11 = false;
            sincronoStateless = false;
            asincronoStateless = false;
            portaStateless = false;
            try {
                if (!propertiesReader.isServerJ2EE()) {
                    oneWayStateless = true;
                    sincronoStateless = true;
                    asincronoStateless = true;
                } else if ("EGOV_IT_MessaggioSingoloOneWay".equals(infoServizio.getProfiloDiCollaborazione())) {
                    oneWayStateless = configurazionePdDReader.isModalitaStateless(pd, infoServizio.getProfiloDiCollaborazione());
                } else if ("EGOV_IT_ServizioSincrono".equals(infoServizio.getProfiloDiCollaborazione())) {
                    sincronoStateless = configurazionePdDReader.isModalitaStateless(pd, infoServizio.getProfiloDiCollaborazione());
                } else if ("EGOV_IT_ServizioAsincronoSimmetrico".equals(infoServizio.getProfiloDiCollaborazione()) || "EGOV_IT_ServizioAsincronoAsimmetrico".equals(infoServizio.getProfiloDiCollaborazione())) {
                    asincronoStateless = configurazionePdDReader.isModalitaStateless(pd, infoServizio.getProfiloDiCollaborazione());
                }
                v0 = oneWayVersione11 = propertiesReader.isGestioneOnewayStateful_1_1() != false && "EGOV_IT_MessaggioSingoloOneWay".equals(infoServizio.getProfiloDiCollaborazione()) != false && oneWayStateless == false;
                if (oneWayStateless || sincronoStateless || asincronoStateless || oneWayVersione11) {
                    openspcoopstate = OpenSPCoopState.toStateless((OpenSPCoopStateful)openspcoopstate, true);
                    portaStateless = true;
                    if (!oneWayVersione11) {
                        this.msgContext.getIntegrazione().setGestioneStateless(true);
                    } else {
                        this.msgContext.getIntegrazione().setGestioneStateless(false);
                    }
                } else {
                    this.msgContext.getIntegrazione().setGestioneStateless(false);
                }
            }
            catch (Exception e) {
                msgDiag.logErroreGenerico(e, "GestioneStatelessStateful");
                logCore.error((Object)("Analisi modalita di gestione STATEFUL/STATELESS non riuscita: " + e));
                openspcoopstate.releaseResource();
                if (this.msgContext.isGestioneRisposta()) {
                    this.msgContext.setMessageResponse(xmlBuilder.msgErroreApplicativo_Processamento(proprietaErroreAppl, "OPENSPCOOP_ORG_536", "Sistema non disponibile", identitaPdD, this.msgContext.getIdModulo(), e));
                }
                return;
            }
            msgDiag.mediumDebug("Controllo presenza del messaggio gia' in gestione...");
            msgRequest = new GestoreMessaggi(openspcoopstate, true, idEGovRequest, "OUTBOX", msgDiag);
            msgRequest.setOneWayVersione11(oneWayVersione11);
            try {
                if (!msgRequest.existsMessage_noCache()) break block305;
                proprietarioMessaggio = msgRequest.getProprietario(this.msgContext.getIdModulo());
                if ("GestoreMessaggi".equals(proprietarioMessaggio)) {
                    msgDiag.logPersonalizzato("messaggioInGestione.marcatoDaEliminare");
                    msgRequest.deleteMessage();
                    break block305;
                }
                msgDiag.addKeyword("@PROPRIETARIO_MESSAGGIO@", proprietarioMessaggio);
                msgDiag.logPersonalizzato("messaggioInGestione");
                openspcoopstate.releaseResource();
                if (this.msgContext.isGestioneRisposta()) {
                    this.msgContext.setMessageResponse(xmlBuilder.msgErroreApplicativo_Processamento(proprietaErroreAppl, "OPENSPCOOP_ORG_537", "La richiesta assegnata alla busta SPCoop con ID=XXX \u00e8 gi\u00e0 stata ricevuta e risulta ancora in processamento".replace("XXX", idEGovRequest), identitaPdD, this.msgContext.getIdModulo()));
                }
                return;
            }
            catch (Exception e) {
                msgDiag.logErroreGenerico(e, "ControlloPresenzaMessaggioGiaInGestione");
                logCore.error((Object)"Controllo/gestione presenza messaggio gia in gestione non riuscito", (Throwable)e);
                openspcoopstate.releaseResource();
                if (this.msgContext.isGestioneRisposta()) {
                    this.msgContext.setMessageResponse(xmlBuilder.msgErroreApplicativo_Processamento(proprietaErroreAppl, "OPENSPCOOP_ORG_537", "Sistema non disponibile", identitaPdD, this.msgContext.getIdModulo(), e));
                }
                return;
            }
        }
        msgDiag.mediumDebug("Registrazione messaggio di richiesta nel RepositoryMessaggi...");
        richiestaAsincronaSimmetricaStateless = false;
        try {
            if ("EGOV_IT_ServizioAsincronoSimmetrico".equals(infoServizio.getProfiloDiCollaborazione()) && portaStateless) {
                richiestaAsincronaSimmetricaStateless = "eGov1.1-lineeGuida1.1".equalsIgnoreCase(richiestaDelegata.getProfiloGestione()) ? (headerIntegrazioneRichiesta.getEgov().getRiferimentoMessaggio() != null ? false : headerIntegrazioneRichiesta.getEgov().getIdCollaborazione() == null) : headerIntegrazioneRichiesta.getEgov().getRiferimentoMessaggio() == null;
            }
            msgRequest.registraMessaggio(requestMessage, dataIngressoMessaggio, oneWayStateless != false || sincronoStateless != false || asincronoStateless != false, idCorrelazioneApplicativa, inRequestContext.getPddContext());
            msgRequest.aggiornaProprietarioMessaggio("Imbustamento");
            if (richiestaAsincronaSimmetricaStateless) {
                msgRequest.registraInformazioniMessaggio_statelessEngine(dataIngressoMessaggio, "Imbustamento", idCorrelazioneApplicativa, inRequestContext.getPddContext());
            }
        }
        catch (GestoreMessaggiException e) {
            msgDiag.logErroreGenerico(e, "msgRequest.aggiornaProprietarioMessaggio");
            msgRequest.deleteMessageFromFileSystem();
            openspcoopstate.releaseResource();
            if (this.msgContext.isGestioneRisposta()) {
                this.msgContext.setMessageResponse(xmlBuilder.msgErroreApplicativo_Processamento(proprietaErroreAppl, "OPENSPCOOP_ORG_508", "Sistema non disponibile", identitaPdD, this.msgContext.getIdModulo(), (Exception)e));
            }
            return;
        }
        msgDiag.mediumDebug("Registrazione busta eGov di richiesta nel RepositoryEGov...");
        repositoryEGov = new RepositoryEGov(openspcoopstate.getStatoRichiesta(), true);
        try {
            if (!portaStateless || oneWayVersione11) {
                if (repositoryEGov.isRegistrataIntoOutBox(idEGovRequest)) {
                    repositoryEGov.aggiornaBustaIntoOutBox(idEGovRequest, soggettoFruitore, richiestaDelegata.getIdServizio(), propertiesReader.getRepositoryIntervalloScadenzaMessaggi(), infoServizio.getProfiloDiCollaborazione(), infoServizio.getConfermaRicezione(), infoServizio.getInoltro());
                    repositoryEGov.impostaUtilizzoPdDIntoOutBox(idEGovRequest);
                } else {
                    repositoryEGov.registraBustaIntoOutBox(idEGovRequest, soggettoFruitore, richiestaDelegata.getIdServizio(), propertiesReader.getRepositoryIntervalloScadenzaMessaggi(), infoServizio.getProfiloDiCollaborazione(), infoServizio.getConfermaRicezione(), infoServizio.getInoltro());
                }
                infoIntegrazione = new Integrazione();
                infoIntegrazione.setIdModuloInAttesa(this.msgContext.getIdModulo());
                infoIntegrazione.setLocationPD(richiestaDelegata.getLocationPD());
                infoIntegrazione.setServizioApplicativo(richiestaDelegata.getServizioApplicativo());
                repositoryEGov.aggiornaInfoIntegrazioneIntoOutBox(idEGovRequest, infoIntegrazione);
            }
        }
        catch (EGovException e) {
            msgDiag.logErroreGenerico(e, "registrazioneAggiornamentoBusta");
            msgRequest.deleteMessageFromFileSystem();
            openspcoopstate.releaseResource();
            if (this.msgContext.isGestioneRisposta()) {
                this.msgContext.setMessageResponse(xmlBuilder.msgErroreApplicativo_Processamento(proprietaErroreAppl, "OPENSPCOOP_ORG_525", "Sistema non disponibile", identitaPdD, this.msgContext.getIdModulo(), (Exception)e));
            }
            return;
        }
        msgDiag.mediumDebug("Invio messaggio al modulo di Imbustamento...");
        try {
            msgDiag.highDebug("Creazione ObjectMessage for send nell'infrastruttura.");
            imbustamentoMSG.setRichiestaDelegata(richiestaDelegata);
            imbustamentoMSG.setInfoServizio(infoServizio);
            imbustamentoMSG.setOneWayVersione11(oneWayVersione11);
            if (headerIntegrazioneRichiesta.getEgov() != null) {
                if ("eGov1.1-lineeGuida1.1".equalsIgnoreCase(richiestaDelegata.getProfiloGestione())) {
                    if (headerIntegrazioneRichiesta.getEgov().getRiferimentoMessaggio() != null) {
                        imbustamentoMSG.setRiferimentoServizioCorrelato(headerIntegrazioneRichiesta.getEgov().getRiferimentoMessaggio());
                    } else if (headerIntegrazioneRichiesta.getEgov().getIdCollaborazione() != null) {
                        imbustamentoMSG.setRiferimentoServizioCorrelato(headerIntegrazioneRichiesta.getEgov().getIdCollaborazione());
                    }
                } else {
                    imbustamentoMSG.setRiferimentoServizioCorrelato(headerIntegrazioneRichiesta.getEgov().getRiferimentoMessaggio());
                }
                if (headerIntegrazioneRichiesta.getEgov().getIdCollaborazione() != null) {
                    imbustamentoMSG.setIdCollaborazione(headerIntegrazioneRichiesta.getEgov().getIdCollaborazione());
                }
            }
            imbustamentoMSG.setImplementazionePdDSoggettoMittente(implementazionePdDMittente);
            imbustamentoMSG.setImplementazionePdDSoggettoDestinatario(implementazionePdDDestinatario);
            imbustamentoMSG.setPddContext(inRequestContext.getPddContext());
            if (!portaStateless) {
                logCore.debug((Object)"RicezioneContenutiApplicativi :eseguo send a imbustamento...");
                RicezioneContenutiApplicativi.nodeSender.send(imbustamentoMSG, "Imbustamento", msgDiag, identitaPdD.getCodicePorta(), this.msgContext.getIdModulo(), idEGovRequest, msgRequest);
                logCore.debug((Object)"RicezioneContenutiApplicativi :send a imbustamento effettuata");
            }
        }
        catch (Exception e) {
            logCore.error((Object)"Spedizione->Imbustamento non riuscita", (Throwable)e);
            msgDiag.logErroreGenerico(e, "GenericLib.nodeSender.send(Imbustamento)");
            msgRequest.deleteMessageFromFileSystem();
            openspcoopstate.releaseResource();
            if (this.msgContext.isGestioneRisposta()) {
                this.msgContext.setMessageResponse(xmlBuilder.msgErroreApplicativo_Processamento(proprietaErroreAppl, "OPENSPCOOP_ORG_512", "Sistema non disponibile", identitaPdD, this.msgContext.getIdModulo(), e));
            }
            return;
        }
        msgDiag.mediumDebug("Commit delle operazioni per la gestione della richiesta...");
        try {
            openspcoopstate.commit();
            logCore.debug((Object)"RicezioneContenutiApplicativi :RicezioneContenutiApplicativi commit eseguito");
        }
        catch (Exception e) {
            msgDiag.logErroreGenerico(e, "openspcoopstate.commit");
            msgRequest.deleteMessageFromFileSystem();
            openspcoopstate.releaseResource();
            if (this.msgContext.isGestioneRisposta()) {
                this.msgContext.setMessageResponse(xmlBuilder.msgErroreApplicativo_Processamento(proprietaErroreAppl, "OPENSPCOOP_ORG_506", "Sistema non disponibile", identitaPdD, this.msgContext.getIdModulo(), e));
            }
            return;
        }
        if (!portaStateless) {
            if (msgRequest != null) {
                msgRequest.addMessaggiIntoCache_readFromTable("RicezioneContenutiApplicativi", "richiesta");
            }
            if (msgRequest != null) {
                msgRequest.addProprietariIntoCache_readFromTable("RicezioneContenutiApplicativi", "richiesta", null, false);
            }
            msgDiag.mediumDebug("Commit delle operazioni per la gestione della richiesta effettuato, rilascio della connessione...");
            openspcoopstate.releaseResource();
        }
        parametriGestioneRisposta = new RicezioneContenutiApplicativiGestioneRisposta();
        parametriGestioneRisposta.setOpenspcoopstate(openspcoopstate);
        parametriGestioneRisposta.setMsgDiag(msgDiag);
        parametriGestioneRisposta.setLogCore(logCore);
        parametriGestioneRisposta.setPropertiesReader(propertiesReader);
        parametriGestioneRisposta.setXmlBuilder(xmlBuilder);
        parametriGestioneRisposta.setIdentitaPdD(identitaPdD);
        parametriGestioneRisposta.setIdEGovRequest(idEGovRequest);
        parametriGestioneRisposta.setHeaderIntegrazioneRichiesta(headerIntegrazioneRichiesta);
        parametriGestioneRisposta.setHeaderIntegrazioneRisposta(headerIntegrazioneRisposta);
        parametriGestioneRisposta.setTipiIntegrazionePD(tipiIntegrazionePD);
        parametriGestioneRisposta.setProprietaErroreAppl(proprietaErroreAppl);
        parametriGestioneRisposta.setServizioApplicativo(servizioApplicativo);
        parametriGestioneRisposta.setMsgRequest(msgRequest);
        parametriGestioneRisposta.setRepositoryEGov(repositoryEGov);
        parametriGestioneRisposta.setPortaStateless(portaStateless);
        parametriGestioneRisposta.setOneWayVers11(oneWayVersione11);
        parametriGestioneRisposta.setRichiestaAsincronaSimmetricaStateless(richiestaAsincronaSimmetricaStateless);
        if (portaStateless) {
            ((OpenSPCoopStateless)openspcoopstate).setUseConnection(false);
            result = this.comportamentoStateless(parametriGestioneRisposta, imbustamentoMSG);
            if (!result) {
                openspcoopstate.releaseResource();
                return;
            }
            ((OpenSPCoopStateless)openspcoopstate).setUseConnection(true);
        }
        msgDiag.mediumDebug("Gestione risposta...");
        if (!this.msgContext.isGestioneRisposta()) {
            if (portaStateless) {
                openspcoopstate.releaseResource();
            }
            return;
        }
        this.gestioneRisposta(parametriGestioneRisposta);
        msgDiag.mediumDebug("Lavoro Terminato.");
    }

    private void setCredenziali(Credenziali credenziali, MsgDiagnostico msgDiag) {
        if (credenziali != null) {
            if (credenziali.getUsername() != null) {
                msgDiag.setServizioApplicativo("username(" + credenziali.getUsername() + ")");
            } else if (credenziali.getSubject() != null) {
                msgDiag.setServizioApplicativo("subject(" + credenziali.getSubject() + ")");
            } else {
                msgDiag.setServizioApplicativo(null);
            }
        }
        String credenzialiFornite = "";
        if (credenziali.getUsername() != null || credenziali.getSubject() != null) {
            credenzialiFornite = "(";
            if (credenziali.getUsername() != null) {
                credenzialiFornite = credenziali.getPassword() == null || "".equals(credenziali.getPassword()) ? credenzialiFornite + " Basic Username: [" + credenziali.getUsername() + "]  Basic Password: non definita" : credenzialiFornite + " Basic Username: [" + credenziali.getUsername() + "] ";
            }
            if (credenziali.getSubject() != null) {
                credenzialiFornite = credenzialiFornite + " SSL Subject: [" + credenziali.getSubject() + "] ";
            }
            credenzialiFornite = credenzialiFornite + ") ";
        }
        msgDiag.addKeyword("@CREDENZIALI_SA_FRUITORE@", credenzialiFornite);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private boolean comportamentoStateless(RicezioneContenutiApplicativiGestioneRisposta parametriGestioneRisposta, ImbustamentoMessage imbustamentoMSG) {
        EsitoLib esito;
        OpenSPCoopStateless openspcoopstate;
        block32: {
            openspcoopstate = (OpenSPCoopStateless)parametriGestioneRisposta.getOpenspcoopstate();
            MsgDiagnostico msgDiag = parametriGestioneRisposta.getMsgDiag();
            Logger logCore = parametriGestioneRisposta.getLogCore();
            XMLBuilder xmlBuilder = parametriGestioneRisposta.getXmlBuilder();
            OpenSPCoopProperties propertiesReader = parametriGestioneRisposta.getPropertiesReader();
            String idEGovRequest = parametriGestioneRisposta.getIdEGovRequest();
            ProprietaErroreApplicativo proprietaErroreAppl = parametriGestioneRisposta.getProprietaErroreAppl();
            GestoreMessaggi msgRequest = parametriGestioneRisposta.getMsgRequest();
            IDSoggetto identitaPdD = parametriGestioneRisposta.getIdentitaPdD();
            parametriGestioneRisposta.setPortaStateless(true);
            boolean rinegoziamentoConnessione = propertiesReader.isRinegoziamentoConnessione(this.msgContext.getEgov().getProfiloCollaborazione()) && !parametriGestioneRisposta.isOneWayVers11();
            Imbustamento imbustamentoLib = new Imbustamento(logCore);
            openspcoopstate.setMessageLib(imbustamentoMSG);
            openspcoopstate.setIDEgovSessione(idEGovRequest);
            try {
                esito = imbustamentoLib.onMessage(openspcoopstate);
                if (esito.getStatoInvocazione() == 3) {
                    if (esito.getErroreNonGestito() != null) {
                        throw esito.getErroreNonGestito();
                    }
                    throw new Exception("Errore non gestito");
                }
            }
            catch (Exception e) {
                msgDiag.logErroreGenerico(e, "Stateless.Imbustamento");
                logCore.error((Object)("Errore Generale durante la gestione stateless: " + e.getMessage()), (Throwable)e);
                msgRequest.deleteMessageFromFileSystem();
                openspcoopstate.setUseConnection(true);
                openspcoopstate.releaseResource();
                if (this.msgContext.isGestioneRisposta()) {
                    this.msgContext.setMessageResponse(xmlBuilder.msgErroreApplicativo_Processamento(proprietaErroreAppl, "OPENSPCOOP_ORG_500", "Sistema non disponibile", identitaPdD, this.msgContext.getIdModulo(), e));
                }
                return false;
            }
            if (esito.getStatoInvocazione() != 1) {
                openspcoopstate.setUseConnection(true);
                this.gestioneRisposta(parametriGestioneRisposta);
                return false;
            }
            if (openspcoopstate.getDestinatarioResponseMsgLib() != null && openspcoopstate.getDestinatarioResponseMsgLib().startsWith(ID_MODULO) && propertiesReader.isGestioneOnewayStateful_1_1()) {
                return true;
            }
            if (rinegoziamentoConnessione) {
                openspcoopstate.setUseConnection(true);
                try {
                    openspcoopstate.commit();
                }
                catch (Exception e) {
                    // empty catch block
                }
                openspcoopstate.releaseResource();
                openspcoopstate.setUseConnection(false);
            }
            InoltroBusteEGov inoltroBusteLib = new InoltroBusteEGov(logCore);
            try {
                esito = inoltroBusteLib.onMessage(openspcoopstate);
                if (esito.getStatoInvocazione() == 3) {
                    if (esito.getErroreNonGestito() != null) {
                        throw esito.getErroreNonGestito();
                    }
                    throw new Exception("Errore non gestito");
                }
            }
            catch (Exception e) {
                msgDiag.logErroreGenerico(e, "Stateless.InoltroBusteEGov");
                logCore.error((Object)("Errore Generale durante la gestione stateless: " + e.getMessage()), (Throwable)e);
                msgRequest.deleteMessageFromFileSystem();
                openspcoopstate.setUseConnection(true);
                openspcoopstate.releaseResource();
                if (this.msgContext.isGestioneRisposta()) {
                    this.msgContext.setMessageResponse(xmlBuilder.msgErroreApplicativo_Processamento(proprietaErroreAppl, "OPENSPCOOP_ORG_500", "Sistema non disponibile", identitaPdD, this.msgContext.getIdModulo(), e));
                }
                return false;
            }
            if (esito.getStatoInvocazione() != 1) {
                openspcoopstate.setUseConnection(true);
                this.gestioneRisposta(parametriGestioneRisposta);
                return false;
            }
            if (openspcoopstate.getDestinatarioResponseMsgLib() != null && openspcoopstate.getDestinatarioResponseMsgLib().startsWith(ID_MODULO)) {
                return true;
            }
            SbustamentoRisposte sbustamentoRisposteLib = new SbustamentoRisposte(logCore);
            boolean erroreSbustamentoRisposta = false;
            if (rinegoziamentoConnessione && openspcoopstate.resourceReleased()) {
                openspcoopstate.setUseConnection(true);
                openspcoopstate.initResource(parametriGestioneRisposta.getIdentitaPdD(), "SbustamentoRisposte");
                openspcoopstate.setUseConnection(false);
            }
            if ((esito = sbustamentoRisposteLib.onMessage(openspcoopstate)).getStatoInvocazione() == 3) {
                if (esito.getErroreNonGestito() != null) {
                    throw esito.getErroreNonGestito();
                }
                throw new Exception("Errore non gestito");
            }
            Object var21_21 = null;
            if (!rinegoziamentoConnessione || erroreSbustamentoRisposta) break block32;
            openspcoopstate.setUseConnection(true);
            try {
                openspcoopstate.commit();
            }
            catch (Exception e2) {
                // empty catch block
            }
            openspcoopstate.releaseResource();
            openspcoopstate.setUseConnection(false);
            {
                break block32;
                catch (Exception e) {
                    erroreSbustamentoRisposta = true;
                    msgDiag.logErroreGenerico(e, "Stateless.SbustamentoRisposte");
                    logCore.error((Object)("Errore Generale durante la gestione stateless: " + e.getMessage()), (Throwable)e);
                    msgRequest.deleteMessageFromFileSystem();
                    openspcoopstate.setUseConnection(true);
                    openspcoopstate.releaseResource();
                    if (this.msgContext.isGestioneRisposta()) {
                        this.msgContext.setMessageResponse(xmlBuilder.msgErroreApplicativo_Processamento(proprietaErroreAppl, "OPENSPCOOP_ORG_500", "Sistema non disponibile", identitaPdD, this.msgContext.getIdModulo(), e));
                    }
                    boolean bl = false;
                    Object var21_22 = null;
                    if (rinegoziamentoConnessione && !erroreSbustamentoRisposta) {
                        openspcoopstate.setUseConnection(true);
                        try {
                            openspcoopstate.commit();
                        }
                        catch (Exception e2) {
                            // empty catch block
                        }
                        openspcoopstate.releaseResource();
                        openspcoopstate.setUseConnection(false);
                    }
                    return bl;
                }
            }
            catch (Throwable throwable) {
                Object var21_23 = null;
                if (rinegoziamentoConnessione && !erroreSbustamentoRisposta) {
                    openspcoopstate.setUseConnection(true);
                    try {
                        openspcoopstate.commit();
                    }
                    catch (Exception e2) {
                        // empty catch block
                    }
                    openspcoopstate.releaseResource();
                    openspcoopstate.setUseConnection(false);
                }
                throw throwable;
            }
        }
        if (esito.getStatoInvocazione() != 1) {
            openspcoopstate.setUseConnection(true);
            this.gestioneRisposta(parametriGestioneRisposta);
            return false;
        }
        return true;
    }

    private void gestioneRisposta(RicezioneContenutiApplicativiGestioneRisposta parametriGestioneRisposta) {
        IGestoreIntegrazionePD gestore;
        Message responseMessage;
        String profiloCollaborazione;
        String idCollaborazioneResponse;
        String idEGovResponse;
        boolean richiestaAsincronaSimmetricaStateless;
        boolean oneWayVers11;
        boolean portaStateless;
        GestoreMessaggi msgRequest;
        String[] tipiIntegrazionePD;
        HeaderIntegrazione headerIntegrazioneRisposta;
        HeaderIntegrazione headerIntegrazioneRichiesta;
        String servizioApplicativo;
        ProprietaErroreApplicativo proprietaErroreAppl;
        String idEGovRequest;
        IDSoggetto identitaPdD;
        XMLBuilder xmlBuilder;
        Logger logCore;
        MsgDiagnostico msgDiag;
        IOpenSPCoopState openspcoopstate;
        block45: {
            openspcoopstate = parametriGestioneRisposta.getOpenspcoopstate();
            msgDiag = parametriGestioneRisposta.getMsgDiag();
            logCore = parametriGestioneRisposta.getLogCore();
            OpenSPCoopProperties propertiesReader = parametriGestioneRisposta.getPropertiesReader();
            xmlBuilder = parametriGestioneRisposta.getXmlBuilder();
            identitaPdD = parametriGestioneRisposta.getIdentitaPdD();
            idEGovRequest = parametriGestioneRisposta.getIdEGovRequest();
            proprietaErroreAppl = parametriGestioneRisposta.getProprietaErroreAppl();
            servizioApplicativo = parametriGestioneRisposta.getServizioApplicativo();
            headerIntegrazioneRichiesta = parametriGestioneRisposta.getHeaderIntegrazioneRichiesta();
            headerIntegrazioneRisposta = parametriGestioneRisposta.getHeaderIntegrazioneRisposta();
            tipiIntegrazionePD = parametriGestioneRisposta.getTipiIntegrazionePD();
            msgRequest = parametriGestioneRisposta.getMsgRequest();
            portaStateless = parametriGestioneRisposta.isPortaStateless();
            oneWayVers11 = parametriGestioneRisposta.isOneWayVers11();
            richiestaAsincronaSimmetricaStateless = parametriGestioneRisposta.isRichiestaAsincronaSimmetricaStateless();
            idEGovResponse = null;
            idCollaborazioneResponse = null;
            profiloCollaborazione = null;
            responseMessage = null;
            try {
                RicezioneContenutiApplicativiMessage ricezioneContenutiApplicativiMSG;
                if (portaStateless || oneWayVers11) {
                    ricezioneContenutiApplicativiMSG = (RicezioneContenutiApplicativiMessage)((OpenSPCoopStateless)openspcoopstate).getMessageLib();
                    idEGovResponse = ricezioneContenutiApplicativiMSG.getIdEGovRisposta();
                    idCollaborazioneResponse = ricezioneContenutiApplicativiMSG.getIdCollaborazione();
                    profiloCollaborazione = ricezioneContenutiApplicativiMSG.getProfiloCollaborazione();
                    responseMessage = ((OpenSPCoopStateless)openspcoopstate).getRispostaMsg();
                    if (!"EGOV_IT_MessaggioSingoloOneWay".equals(profiloCollaborazione)) {
                        this.msgContext.getEgov().setIdRisposta(idEGovResponse);
                    }
                    this.msgContext.getEgov().setCollaborazione(idCollaborazioneResponse);
                    msgDiag.setIdEGovRisposta(idEGovResponse);
                    msgDiag.addKeyword("@ID_EGOV_RISPOSTA@", idEGovResponse);
                    break block45;
                }
                try {
                    responseMessage = SoapUtils.build_Soap_Empty();
                    msgDiag.mediumDebug("Attesa/lettura risposta...");
                    ricezioneContenutiApplicativiMSG = (RicezioneContenutiApplicativiMessage)nodeReceiver.receive(msgDiag, identitaPdD.getCodicePorta(), this.msgContext.getIdModulo(), idEGovRequest, propertiesReader.getNodeReceiverTimeoutRicezioneContenutiApplicativi(), propertiesReader.getNodeReceiverCheckInterval());
                    idEGovResponse = ricezioneContenutiApplicativiMSG.getIdEGovRisposta();
                    idCollaborazioneResponse = ricezioneContenutiApplicativiMSG.getIdCollaborazione();
                    profiloCollaborazione = ricezioneContenutiApplicativiMSG.getProfiloCollaborazione();
                    PdDContext pddContext = ricezioneContenutiApplicativiMSG.getPddContext();
                    if (pddContext != null) {
                        Enumeration<String> enumPddContext = pddContext.keys();
                        while (enumPddContext.hasMoreElements()) {
                            String key = enumPddContext.nextElement();
                            this.msgContext.getPddContext().addObject(key, pddContext.getObject(key));
                        }
                    }
                    if (!"EGOV_IT_MessaggioSingoloOneWay".equals(profiloCollaborazione)) {
                        this.msgContext.getEgov().setIdRisposta(idEGovResponse);
                    }
                    this.msgContext.getEgov().setCollaborazione(idCollaborazioneResponse);
                }
                catch (Exception e) {
                    logCore.error((Object)("Gestione risposta (" + this.msgContext.getIdModulo() + ") con errore"), (Throwable)e);
                    msgDiag.logErroreGenerico(e, "GestioneRispostaErroreGenerale");
                    if (e instanceof NodeTimeoutException) {
                        try {
                            openspcoopstate.updateResource();
                        }
                        catch (Exception eDB) {
                            msgDiag.logErroreGenerico(e, "openspcoopstate.updateResource()");
                            this.msgContext.setMessageResponse(xmlBuilder.msgErroreApplicativo_Processamento(proprietaErroreAppl, "OPENSPCOOP_ORG_505", "Sistema non disponibile", identitaPdD, this.msgContext.getIdModulo(), eDB));
                            return;
                        }
                        try {
                            msgDiag.logPersonalizzato("timeoutRicezioneRisposta");
                            msgRequest.aggiornaProprietarioMessaggio("GestoreMessaggi");
                            openspcoopstate.commit();
                        }
                        catch (Exception eDel) {
                            msgDiag.logErroreGenerico(eDel, "EliminazioneMessaggioScadutoTimeoutRicezioneRisposta");
                        }
                        openspcoopstate.releaseResource();
                    }
                    this.msgContext.setMessageResponse(xmlBuilder.msgErroreApplicativo_Processamento(proprietaErroreAppl, "OPENSPCOOP_ORG_513", "Sistema non disponibile", identitaPdD, this.msgContext.getIdModulo(), e));
                    return;
                }
                msgDiag.setIdEGovRisposta(idEGovResponse);
                msgDiag.addKeyword("@ID_EGOV_RISPOSTA@", idEGovResponse);
                msgDiag.mediumDebug("Richiesta connessione al database per la gestione della risposta...");
                try {
                    openspcoopstate.updateResource();
                }
                catch (Exception e) {
                    msgDiag.logErroreGenerico(e, "openspcoopstate.updateResource()");
                    this.msgContext.setMessageResponse(xmlBuilder.msgErroreApplicativo_Processamento(proprietaErroreAppl, "OPENSPCOOP_ORG_505", "Sistema non disponibile", identitaPdD, this.msgContext.getIdModulo(), e));
                    return;
                }
                msgRequest.updateOpenSPCoopState(openspcoopstate);
                msgDiag.mediumDebug("Lettura messaggio di risposta...");
                GestoreMessaggi msgResponse = new GestoreMessaggi(openspcoopstate, false, idEGovResponse, "INBOX", msgDiag);
                try {
                    responseMessage = msgResponse.getMessage();
                }
                catch (GestoreMessaggiException e) {
                    msgDiag.logErroreGenerico(e, "msgResponse.getMessage()");
                    openspcoopstate.releaseResource();
                    this.msgContext.setMessageResponse(xmlBuilder.msgErroreApplicativo_Processamento(proprietaErroreAppl, "OPENSPCOOP_ORG_511", "Sistema non disponibile", identitaPdD, this.msgContext.getIdModulo(), (Exception)e));
                    return;
                }
            }
            catch (Exception e) {
                logCore.error((Object)"ErroreGenerale", (Throwable)e);
                msgDiag.logErroreGenerico(e, "ErroreGenerale");
                openspcoopstate.releaseResource();
                this.msgContext.setMessageResponse(xmlBuilder.msgErroreApplicativo_Processamento(proprietaErroreAppl, "OPENSPCOOP_ORG_500", "Sistema non disponibile", identitaPdD, this.msgContext.getIdModulo(), e));
            }
        }
        msgDiag.mediumDebug("Gestione header di integrazione messaggio di risposta...");
        headerIntegrazioneRisposta.getEgov().setIdCollaborazione(idCollaborazioneResponse);
        headerIntegrazioneRisposta.getEgov().setProfiloDiCollaborazione(profiloCollaborazione);
        headerIntegrazioneRisposta.getEgov().setID(idEGovRequest);
        if (gestoriIntegrazionePD.containsKey("trasporto") || this.msgContext.getIdModulo().startsWith("RicezioneContenutiApplicativiIntegrationManager")) {
            try {
                Properties propertiesIntegrazioneRisposta = new Properties();
                gestore = gestoriIntegrazionePD.get("trasporto");
                if (gestore != null) {
                    gestore.setResponseHeader(headerIntegrazioneRisposta, null, propertiesIntegrazioneRisposta);
                    this.msgContext.setHeaderIntegrazioneRisposta(propertiesIntegrazioneRisposta);
                }
            }
            catch (Exception e) {
                msgDiag.logErroreGenerico(e, "setHeaderIntegrazioneRisposta");
            }
        }
        for (int i = 0; i < tipiIntegrazionePD.length; ++i) {
            try {
                gestore = gestoriIntegrazionePD.get(tipiIntegrazionePD[i]);
                if (gestore != null) {
                    gestore.setResponseHeader(headerIntegrazioneRisposta, responseMessage, new Properties());
                    continue;
                }
                msgDiag.logErroreGenerico("Creazione header di integrazione [" + tipiIntegrazionePD[i] + "] non riuscito, gestore non inzializzato", "setHeaderIntegrazioneRisposta");
                continue;
            }
            catch (Exception e) {
                logCore.error((Object)("Errore durante la creazione dell'header di integrazione [" + tipiIntegrazionePD[i] + "]: " + e.getMessage()), (Throwable)e);
                msgDiag.logErroreGenerico(e, "setHeaderIntegrazioneRisposta(" + tipiIntegrazionePD[i] + ")");
            }
        }
        if (!portaStateless) {
            this.eliminaSIL((OpenSPCoopStateful)openspcoopstate, msgDiag, idEGovRequest, idEGovResponse, servizioApplicativo);
        }
        if (portaStateless && !oneWayVers11) {
            msgDiag.mediumDebug("Aggiorno proprietario messaggio richiesta ...");
            try {
                if (richiestaAsincronaSimmetricaStateless) {
                    boolean resourceReleased = openspcoopstate.resourceReleased();
                    if (resourceReleased) {
                        ((OpenSPCoopStateless)openspcoopstate).setUseConnection(true);
                        openspcoopstate.updateResource();
                    }
                    GestoreMessaggi msgResponse = new GestoreMessaggi(openspcoopstate, false, idEGovResponse, "INBOX", msgDiag);
                    msgResponse.setReadyForDrop(true);
                    msgResponse.aggiornaProprietarioMessaggio("GestoreMessaggi");
                    msgResponse.setReadyForDrop(false);
                    msgRequest.updateOpenSPCoopState(openspcoopstate);
                    msgRequest.setReadyForDrop(true);
                    msgRequest.aggiornaProprietarioMessaggio("GestoreMessaggi");
                    msgRequest.setReadyForDrop(false);
                }
                openspcoopstate.commit();
            }
            catch (Exception e) {
                logCore.error((Object)"Errore durante l'aggiornamento del proprietario al GestoreMessaggi (Stateless)", (Throwable)e);
                msgDiag.logErroreGenerico(e, "openspcoopstate.commit(stateless risposta)");
                openspcoopstate.releaseResource();
                this.msgContext.setMessageResponse(xmlBuilder.msgErroreApplicativo_Processamento(proprietaErroreAppl, "OPENSPCOOP_ORG_500", "Sistema non disponibile", identitaPdD, this.msgContext.getIdModulo(), e));
            }
        }
        if (oneWayVers11) {
            msgDiag.mediumDebug("Commit della gestione oneWay stateful/stateless...");
            try {
                openspcoopstate.commit();
            }
            catch (Exception e) {
                logCore.error((Object)"Riscontrato errore durante il commit della gestione oneWay stateful/stateless", (Throwable)e);
                msgDiag.logErroreGenerico(e, "openspcoopstate.commit(oneway1.1 risposta)");
                openspcoopstate.releaseResource();
                this.msgContext.setMessageResponse(xmlBuilder.msgErroreApplicativo_Processamento(proprietaErroreAppl, "OPENSPCOOP_ORG_500", "Sistema non disponibile", identitaPdD, this.msgContext.getIdModulo(), e));
            }
        }
        msgDiag.mediumDebug("Rilascio connessione al database...");
        openspcoopstate.releaseResource();
        if (profiloCollaborazione != null) {
            if (profiloCollaborazione.equals("EGOV_IT_ServizioSincrono")) {
                msgDiag.addKeyword("@TIPOLOGIA_RISPOSTA_APPLICATIVA@", "risposta sincrona");
                msgDiag.logPersonalizzato("consegnaRispostaApplicativa");
            } else if (profiloCollaborazione.equals("EGOV_IT_ServizioAsincronoSimmetrico")) {
                if (headerIntegrazioneRichiesta != null && headerIntegrazioneRichiesta.getEgov() != null && headerIntegrazioneRichiesta.getEgov().getRiferimentoMessaggio() != null) {
                    msgDiag.addKeyword("@TIPOLOGIA_RISPOSTA_APPLICATIVA@", "ricevuta di una risposta asincrona simmetrica");
                } else {
                    msgDiag.addKeyword("@TIPOLOGIA_RISPOSTA_APPLICATIVA@", "ricevuta di una richiesta asincrona simmetrica");
                }
                msgDiag.logPersonalizzato("consegnaRispostaApplicativa");
            } else if (profiloCollaborazione.equals("EGOV_IT_ServizioAsincronoAsimmetrico")) {
                if (headerIntegrazioneRichiesta != null && headerIntegrazioneRichiesta.getEgov() != null && headerIntegrazioneRichiesta.getEgov().getRiferimentoMessaggio() != null) {
                    msgDiag.addKeyword("@TIPOLOGIA_RISPOSTA_APPLICATIVA@", "ricevuta di una risposta asincrona asimmetrica");
                } else {
                    msgDiag.addKeyword("@TIPOLOGIA_RISPOSTA_APPLICATIVA@", "ricevuta di una richiesta asincrona asimmetrica");
                }
                msgDiag.logPersonalizzato("consegnaRispostaApplicativa");
            }
        }
        msgDiag.mediumDebug("Imposto risposta nel context...");
        this.msgContext.setMessageResponse(responseMessage);
    }

    private void eliminaSIL(OpenSPCoopStateful openspcoopstate, MsgDiagnostico msgDiag, String idEGovRequest, String idEGovResponse, String servizioApplicativo) {
        msgDiag.mediumDebug("Eliminazione SIL destinatario del messaggio nella tabelle MSG_SERVIZI_APPLICATIVI...");
        if (openspcoopstate.getConnectionDB() != null) {
            try {
                GestoreMessaggi gestoreEliminazioneDestinatario = new GestoreMessaggi(openspcoopstate, false, idEGovResponse, "INBOX", msgDiag);
                gestoreEliminazioneDestinatario.eliminaDestinatarioMessaggio(servizioApplicativo, idEGovRequest);
            }
            catch (Exception e) {
                msgDiag.logErroreGenerico(e, "gestoreEliminazioneDestinatario.eliminaDestinatarioMessaggio(" + servizioApplicativo + ")");
            }
        } else {
            msgDiag.logErroreGenerico("Connessione non disponibile", "gestoreEliminazioneDestinatario.eliminaDestinatarioMessaggio(" + servizioApplicativo + ")");
        }
    }
}

