/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop.pdd.services;

import java.sql.Timestamp;
import java.util.Hashtable;
import javax.xml.soap.SOAPBody;
import org.apache.axis.AxisFault;
import org.apache.axis.Message;
import org.apache.axis.MessageContext;
import org.apache.axis.message.SOAPEnvelope;
import org.apache.log4j.Logger;
import org.openspcoop.dao.commons.TipoPdD;
import org.openspcoop.pdd.config.OpenSPCoopProperties;
import org.openspcoop.pdd.core.Esito;
import org.openspcoop.pdd.core.ParametriInvocazionePorta;
import org.openspcoop.pdd.core.autenticazione.Credenziali;
import org.openspcoop.pdd.core.connettori.IConnettore;
import org.openspcoop.pdd.core.connettori.RepositoryConnettori;
import org.openspcoop.pdd.core.handlers.GestoreHandlers;
import org.openspcoop.pdd.core.handlers.PostOutResponseContext;
import org.openspcoop.pdd.core.handlers.PreInRequestContext;
import org.openspcoop.pdd.logger.MsgDiagnostico;
import org.openspcoop.pdd.logger.OpenSPCoopLogger;
import org.openspcoop.pdd.services.RicezioneBusteEGov;
import org.openspcoop.pdd.services.RicezioneBusteEGovContext;
import org.openspcoop.utils.SoapUtils;
import org.openspcoop.utils.date.DateManager;

public class RicezioneBusteEGovWS {
    public static final String ID_MODULO = "RicezioneBusteEGovWS";

    public void OpenSPCoop_PA(SOAPEnvelope req, SOAPEnvelope res) throws AxisFault {
        OpenSPCoopProperties openSPCoopProperties;
        Timestamp dataIngressoMessaggio = DateManager.getTimestamp();
        MessageContext msgContext = MessageContext.getCurrentContext();
        Logger logCore = OpenSPCoopLogger.getLoggerOpenSPCoopCore();
        if (logCore == null) {
            logCore = Logger.getLogger((String)ID_MODULO);
        }
        if ((openSPCoopProperties = OpenSPCoopProperties.getInstance()) == null) {
            logCore.error((Object)"Inizializzazione di OpenSPCoop non correttamente effettuata: OpenSPCoopProperties");
            try {
                Message msg = new Message((Object)new AxisFault("ErroreInizializzazioneOpenSPCoopProperties"));
                msgContext.setResponseMessage(msg);
                return;
            }
            catch (Exception e) {
                logCore.error((Object)"Errore generazione SOAPFault", (Throwable)e);
                throw new AxisFault("Inizializzazione di OpenSPCoop non correttamente effettuata: OpenSPCoopProperties");
            }
        }
        MsgDiagnostico msgDiag = new MsgDiagnostico(ID_MODULO);
        msgDiag.setPrefixMsgPersonalizzati("ricezioneContenutiApplicativi.");
        PreInRequestContext preInRequestContext = new PreInRequestContext();
        preInRequestContext.setTipoPorta(TipoPdD.APPLICATIVA);
        Hashtable<String, Object> transportContext = new Hashtable<String, Object>();
        transportContext.put("CONTEXT", msgContext);
        preInRequestContext.setTransportContext(transportContext);
        preInRequestContext.setLogCore(logCore);
        GestoreHandlers.preInRequest(preInRequestContext, msgDiag);
        Message requestAxisMessage = msgContext.getRequestMessage();
        ParametriInvocazionePorta parInvokePdD = (ParametriInvocazionePorta)msgContext.getProperty("openspcoop.pa.parametri");
        Credenziali credenziali = (Credenziali)msgContext.getProperty("openspcoop.credenziali");
        RicezioneBusteEGovContext context = null;
        try {
            context = new RicezioneBusteEGovContext(dataIngressoMessaggio, openSPCoopProperties.getIdentitaPortaDefault());
        }
        catch (Exception e) {
            throw new AxisFault("Creazione contesto RicezioneBusteEGovContext non riuscita");
        }
        context.setTipoPorta(TipoPdD.APPLICATIVA);
        context.setIdModulo(ID_MODULO);
        context.setGestioneRisposta(true);
        context.setMessageRequest(requestAxisMessage);
        context.setTracciamentoAbilitato(true);
        context.setCredenziali(credenziali);
        context.setMsgDiagnostico(msgDiag);
        String protocollo = "http";
        if (credenziali.getSubject() != null) {
            protocollo = "https";
        }
        String ip = (String)msgContext.getProperty("openspcoop.remoteAddr");
        String port = (String)msgContext.getProperty("openspcoop.remotePort");
        String user = "";
        if (credenziali.getUsername() != null || credenziali.getSubject() != null) {
            user = ":";
            user = credenziali.getSubject() != null ? user + credenziali.getSubject() : user + credenziali.getUsername();
        }
        context.setFromLocation(protocollo + ":" + ip + ":" + port + user);
        context.setSoapAction(msgContext.getSOAPActionURI());
        context.setParametriInvocazionePorta(parInvokePdD);
        RicezioneBusteEGov gestoreRichiesta = new RicezioneBusteEGov(context);
        gestoreRichiesta.process();
        msgContext.setResponseMessage(context.getMessageResponse());
        if (context.getHeaderIntegrazioneRisposta() != null) {
            msgContext.setProperty("HEADER_INTEGRAZIONE", (Object)context.getHeaderIntegrazioneRisposta());
        }
        msgContext.setProperty("GESTIONE_ESITO_MODULO_FUNZIONALE", (Object)"RicezioneBusteEGov");
        if (context.getContentLengthResponse() != null) {
            msgContext.setProperty("RESPONSE_LENGTH_AXIS", (Object)context.getContentLengthResponse());
        }
        String location = "...";
        try {
            IConnettore c = null;
            if (context.getIdEGov() != null) {
                c = RepositoryConnettori.removeConnettorePA(context.getIdEGov());
            }
            if (c != null) {
                location = c.getLocation();
                c.disconnect();
            }
        }
        catch (Exception e) {
            msgDiag.logDisconnectError(e, location);
        }
        PostOutResponseContext postOutResponseContext = new PostOutResponseContext(logCore);
        try {
            postOutResponseContext.setPddContext(context.getPddContext());
            postOutResponseContext.setDataElaborazioneMessaggio(DateManager.getDate());
            if (msgContext.getResponseMessage() != null) {
                SOAPBody body = msgContext.getResponseMessage().getSOAPBody();
                postOutResponseContext.setEsito(Esito.getEsito(body));
                if (body == null) {
                    postOutResponseContext.setReturnCode(202);
                } else if (body.hasFault()) {
                    postOutResponseContext.setReturnCode(500);
                } else {
                    postOutResponseContext.setReturnCode(200);
                }
                if (context.getContentLengthResponse() != null) {
                    postOutResponseContext.setDimensioneMessaggioBytes(context.getContentLengthResponse());
                } else {
                    postOutResponseContext.setDimensioneMessaggioBytes(SoapUtils.getLength((Message)msgContext.getResponseMessage(), (boolean)false));
                }
            } else {
                postOutResponseContext.setEsito(Esito.OK);
                postOutResponseContext.setReturnCode(202);
            }
            postOutResponseContext.setEgov(context.getEgov());
            postOutResponseContext.setIntegrazione(context.getIntegrazione());
            postOutResponseContext.setTipoPorta(context.getTipoPorta());
            postOutResponseContext.setMessaggio(msgContext.getResponseMessage());
        }
        catch (Exception e) {
            msgDiag.logErroreGenerico(e, "postOutResponse, preparazione contesto");
        }
        GestoreHandlers.postOutResponse(postOutResponseContext, msgDiag);
    }
}

