/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop.pdd.services;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.sql.Timestamp;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import org.apache.axis.AxisFault;
import org.apache.axis.Message;
import org.apache.log4j.Logger;
import org.openspcoop.dao.commons.IDSoggetto;
import org.openspcoop.dao.commons.TipoPdD;
import org.openspcoop.dao.config.driver.DriverConfigurazioneException;
import org.openspcoop.dao.config.driver.DriverConfigurazioneNotFound;
import org.openspcoop.dao.config.driver.IDPortaApplicativa;
import org.openspcoop.dao.config.driver.IDPortaDelegata;
import org.openspcoop.dao.eccezione.driver.XMLUtils;
import org.openspcoop.dao.registry.driver.IDServizio;
import org.openspcoop.dao.state.IState;
import org.openspcoop.dao.state.StateMessage;
import org.openspcoop.dao.state.StatelessMessage;
import org.openspcoop.egov.Busta;
import org.openspcoop.egov.Configurazione;
import org.openspcoop.egov.EGovException;
import org.openspcoop.egov.Eccezione;
import org.openspcoop.egov.Imbustamento;
import org.openspcoop.egov.Integrazione;
import org.openspcoop.egov.ProfiloDiCollaborazione;
import org.openspcoop.egov.ProprietaValidazione;
import org.openspcoop.egov.RepositoryEGov;
import org.openspcoop.egov.Riscontro;
import org.openspcoop.egov.RuoloBustaEGov;
import org.openspcoop.egov.Trasmissione;
import org.openspcoop.egov.ValidatoreSPCoop;
import org.openspcoop.pdd.config.ClassNameProperties;
import org.openspcoop.pdd.config.ConfigurazionePdDReader;
import org.openspcoop.pdd.config.OpenSPCoopProperties;
import org.openspcoop.pdd.config.RichiestaApplicativa;
import org.openspcoop.pdd.config.RichiestaDelegata;
import org.openspcoop.pdd.core.EGovContext;
import org.openspcoop.pdd.core.EJBUtils;
import org.openspcoop.pdd.core.GestoreCorrelazioneApplicativa;
import org.openspcoop.pdd.core.GestoreMessaggi;
import org.openspcoop.pdd.core.IntegrationContext;
import org.openspcoop.pdd.core.ValidatoreMessaggiApplicativi;
import org.openspcoop.pdd.core.ValidatoreMessaggiApplicativiException;
import org.openspcoop.pdd.core.autenticazione.Credenziali;
import org.openspcoop.pdd.core.autenticazione.GestoreCredenzialiConfigurationException;
import org.openspcoop.pdd.core.autenticazione.IGestoreCredenziali;
import org.openspcoop.pdd.core.autorizzazione.GestoreAutorizzazioneSPCoop;
import org.openspcoop.pdd.core.autorizzazione.IAutorizzazioneContenutoSPCoop;
import org.openspcoop.pdd.core.connettori.InfoConnettoreIngresso;
import org.openspcoop.pdd.core.handlers.GestoreHandlers;
import org.openspcoop.pdd.core.handlers.HandlerException;
import org.openspcoop.pdd.core.handlers.InRequestContext;
import org.openspcoop.pdd.core.handlers.InRequestEGovContext;
import org.openspcoop.pdd.core.handlers.OutResponseContext;
import org.openspcoop.pdd.core.integrazione.HeaderIntegrazione;
import org.openspcoop.pdd.core.integrazione.IGestoreIntegrazionePA;
import org.openspcoop.pdd.core.integrazione.IGestoreIntegrazionePASoap;
import org.openspcoop.pdd.core.integrazione.UtilitiesIntegrazione;
import org.openspcoop.pdd.core.node.INodeReceiver;
import org.openspcoop.pdd.core.node.INodeSender;
import org.openspcoop.pdd.core.node.NodeTimeoutException;
import org.openspcoop.pdd.core.state.IOpenSPCoopState;
import org.openspcoop.pdd.core.state.OpenSPCoopState;
import org.openspcoop.pdd.core.state.OpenSPCoopStateException;
import org.openspcoop.pdd.core.state.OpenSPCoopStateful;
import org.openspcoop.pdd.core.state.OpenSPCoopStateless;
import org.openspcoop.pdd.logger.Dump;
import org.openspcoop.pdd.logger.MsgDiagnostico;
import org.openspcoop.pdd.logger.OpenSPCoopLogger;
import org.openspcoop.pdd.logger.Tracciamento;
import org.openspcoop.pdd.logger.TracciamentoException;
import org.openspcoop.pdd.mdb.ConsegnaContenutiApplicativi;
import org.openspcoop.pdd.mdb.EsitoLib;
import org.openspcoop.pdd.mdb.ImbustamentoRisposte;
import org.openspcoop.pdd.mdb.InoltroBusteEGov;
import org.openspcoop.pdd.mdb.InoltroBusteEGovMessage;
import org.openspcoop.pdd.mdb.InoltroRisposteEGov;
import org.openspcoop.pdd.mdb.Sbustamento;
import org.openspcoop.pdd.mdb.SbustamentoMessage;
import org.openspcoop.pdd.services.OpenSPCoopStartup;
import org.openspcoop.pdd.services.RicezioneBusteEGovContext;
import org.openspcoop.pdd.services.RicezioneBusteEGovMessage;
import org.openspcoop.pdd.services.RicezioneBusteEGovParametriGenerazioneSPCoopErrore;
import org.openspcoop.pdd.services.RicezioneBusteEGovParametriInvioSPCoopErrore;
import org.openspcoop.pdd.services.ServletUtils;
import org.openspcoop.pdd.timers.TimerMonitoraggioRisorse;
import org.openspcoop.pdd.timers.TimerThreshold;
import org.openspcoop.registry.RegistroServiziReader;
import org.openspcoop.utils.Loader;
import org.openspcoop.utils.SoapUtils;
import org.openspcoop.utils.date.DateManager;
import org.openspcoop.wssecurity.WSSBaseUtils;
import org.openspcoop.wssecurity.WSSReceiver;
import org.openspcoop.wssecurity.WSSSender;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RicezioneBusteEGov {
    public static final String ID_MODULO = "RicezioneBusteEGov";
    public static boolean initializeService = false;
    private static INodeSender nodeSender = null;
    private static INodeReceiver nodeReceiver = null;
    private static Hashtable<String, IGestoreIntegrazionePASoap> gestoriIntegrazionePASoap = new Hashtable();
    private static Vector<String> gestoriIntegrazionePANonSOAP = new Vector();
    private static String[] defaultGestoriIntegrazionePA = null;
    private static Hashtable<String, IAutorizzazioneContenutoSPCoop> gestoriAutorizzazioneContenutoSPCoop = new Hashtable();
    private static Hashtable<String, IGestoreCredenziali> gestoriCredenziali = new Hashtable();
    private static String[] tipiGestoriCredenziali = null;
    private RicezioneBusteEGovContext msgContext;
    boolean responseAsByte = false;

    protected static synchronized void initializeService(ClassNameProperties className, OpenSPCoopProperties propertiesReader, Logger logCore) throws Exception {
        int i;
        if (initializeService) {
            return;
        }
        Loader loader = Loader.getInstance();
        String classTypeNodeSender = className.getNodeSender(propertiesReader.getNodeSender());
        try {
            nodeSender = (INodeSender)loader.newInstance(classTypeNodeSender);
            logCore.info((Object)("Inizializzazione gestore NodeSender di tipo " + classTypeNodeSender + " effettuata."));
        }
        catch (Exception e) {
            throw new Exception("Riscontrato errore durante il caricamento della classe [" + classTypeNodeSender + "] da utilizzare per la spedizione nell'infrastruttura: " + e.getMessage());
        }
        String classType = className.getNodeReceiver(propertiesReader.getNodeReceiver());
        try {
            nodeReceiver = (INodeReceiver)loader.newInstance(classType);
            logCore.info((Object)("Inizializzazione gestore NodeReceiver di tipo " + classType + " effettuata."));
        }
        catch (Exception e) {
            throw new Exception("Riscontrato errore durante il caricamento della classe [" + classType + "] da utilizzare per la ricezione dall'infrastruttura: " + e.getMessage());
        }
        if (propertiesReader.isAbilitataCacheAutorizzazioneSPCoop()) {
            GestoreAutorizzazioneSPCoop.initialize(propertiesReader.getTipoAutorizzazioneSPCoop(), propertiesReader.getDimensioneCacheAutorizzazioneSPCoop(), propertiesReader.getAlgoritmoCacheAutorizzazioneSPCoop(), propertiesReader.getItemIdleTimeCacheAutorizzazioneSPCoop(), propertiesReader.getItemLifeSecondCacheAutorizzazioneSPCoop(), logCore);
        } else {
            GestoreAutorizzazioneSPCoop.initialize(propertiesReader.getTipoAutorizzazioneSPCoop(), logCore);
        }
        String[] tipiIntegrazioneDefault = propertiesReader.getTipoIntegrazionePA();
        Vector<IGestoreIntegrazionePASoap> v = new Vector<IGestoreIntegrazionePASoap>();
        Vector<String> s = new Vector<String>();
        for (i = 0; i < tipiIntegrazioneDefault.length; ++i) {
            classType = className.getIntegrazionePortaApplicativa(tipiIntegrazioneDefault[i]);
            try {
                IGestoreIntegrazionePA test = (IGestoreIntegrazionePA)loader.newInstance(classType);
                if (test instanceof IGestoreIntegrazionePASoap) {
                    v.add((IGestoreIntegrazionePASoap)test);
                    s.add(tipiIntegrazioneDefault[i]);
                    logCore.info((Object)("Inizializzazione gestore per lettura integrazione PA di tipo " + tipiIntegrazioneDefault[i] + " effettuata."));
                    continue;
                }
                gestoriIntegrazionePANonSOAP.add(tipiIntegrazioneDefault[i]);
                continue;
            }
            catch (Exception e) {
                throw new Exception("Riscontrato errore durante il caricamento della classe [" + classType + "] da utilizzare per la gestione dell'integrazione di tipo [" + tipiIntegrazioneDefault[i] + "]: " + e.getMessage());
            }
        }
        if (s.size() > 0) {
            defaultGestoriIntegrazionePA = s.toArray(new String[1]);
            gestoriIntegrazionePASoap = new Hashtable();
            while (s.size() > 0) {
                gestoriIntegrazionePASoap.put((String)s.remove(0), (IGestoreIntegrazionePASoap)v.remove(0));
            }
        }
        if ((tipiGestoriCredenziali = propertiesReader.getTipoGestoreCredenzialiPA()) != null) {
            for (i = 0; i < tipiGestoriCredenziali.length; ++i) {
                classType = className.getGestoreCredenziali(tipiGestoriCredenziali[i]);
                try {
                    IGestoreCredenziali gestore = (IGestoreCredenziali)loader.newInstance(classType);
                    gestoriCredenziali.put(tipiGestoriCredenziali[i], gestore);
                    continue;
                }
                catch (Exception e) {
                    throw new Exception("Riscontrato errore durante il caricamento della classe [" + classType + "] da utilizzare per la gestione delle credenziali di tipo [" + tipiGestoriCredenziali[i] + "]: " + e.getMessage());
                }
            }
        }
        initializeService = true;
    }

    private static synchronized boolean aggiornaListaGestoreIntegrazione(String newTipo, ClassNameProperties className, OpenSPCoopProperties propertiesReader, Logger logCore) throws Exception {
        if (gestoriIntegrazionePASoap.contains(newTipo)) {
            return true;
        }
        if (gestoriIntegrazionePANonSOAP.contains(newTipo)) {
            return false;
        }
        Loader loader = Loader.getInstance();
        String classType = className.getIntegrazionePortaApplicativa(newTipo);
        try {
            IGestoreIntegrazionePA test = (IGestoreIntegrazionePA)loader.newInstance(classType);
            if (test instanceof IGestoreIntegrazionePASoap) {
                gestoriIntegrazionePASoap.put(newTipo, (IGestoreIntegrazionePASoap)test);
                logCore.info((Object)("Inizializzazione gestore per lettura integrazione PA di tipo " + newTipo + " effettuata."));
                return true;
            }
            gestoriIntegrazionePANonSOAP.add(newTipo);
            return false;
        }
        catch (Exception e) {
            throw new Exception("Riscontrato errore durante il caricamento della classe [" + classType + "] da utilizzare per la gestione dell'integrazione di tipo [" + newTipo + "]: " + e.getMessage());
        }
    }

    private static synchronized void aggiornaListaGestoreAutorizzazioneContenutoSPCoop(String newTipo, ClassNameProperties className, OpenSPCoopProperties propertiesReader, Logger logCore) throws Exception {
        if (gestoriAutorizzazioneContenutoSPCoop.contains(newTipo)) {
            return;
        }
        Loader loader = Loader.getInstance();
        String classType = className.getAutorizzazioneContenutoSPCoop(newTipo);
        try {
            gestoriAutorizzazioneContenutoSPCoop.put(newTipo, (IAutorizzazioneContenutoSPCoop)loader.newInstance(classType));
            logCore.info((Object)("Inizializzazione gestore autorizzazione contenuto spcoop di tipo " + newTipo + " effettuata."));
        }
        catch (Exception e) {
            throw new Exception("Riscontrato errore durante il caricamento della classe [" + classType + "] da utilizzare per la gestione dell'autorizzazione contenuto spcoop di tipo [" + newTipo + "]: " + e.getMessage());
        }
    }

    public RicezioneBusteEGov(RicezioneBusteEGovContext context) {
        this.msgContext = context;
    }

    public void process() {
        Logger logCore = OpenSPCoopLogger.getLoggerOpenSPCoopCore();
        if (logCore == null) {
            logCore = Logger.getLogger((String)ID_MODULO);
        }
        MsgDiagnostico msgDiag = this.msgContext.getMsgDiagnostico();
        Message requestMessage = this.msgContext.getMessageRequest();
        if (requestMessage == null) {
            try {
                requestMessage = this.msgContext.getMessageRequestFromByte();
                this.responseAsByte = true;
            }
            catch (Exception e) {
                this.setSOAPFault_processamento(logCore, msgDiag, e, "LetturaMessaggioRichiesta");
                return;
            }
        }
        Long dimesioneIngressoMessaggio = null;
        try {
            dimesioneIngressoMessaggio = this.msgContext.getContentLengthRequest() != null ? this.msgContext.getContentLengthRequest() : Long.valueOf(SoapUtils.getLength((Message)requestMessage, (boolean)true));
        }
        catch (Exception e) {
            this.setSOAPFault_processamento(logCore, msgDiag, e, "CalcoloDimensioneRichiesta");
            return;
        }
        InRequestContext inRequestContext = new InRequestContext(logCore);
        inRequestContext.setTipoPorta(TipoPdD.APPLICATIVA);
        InfoConnettoreIngresso connettore = new InfoConnettoreIngresso();
        connettore.setCredenziali(this.msgContext.getCredenziali());
        if (this.msgContext.getParametriInvocazionePorta() != null) {
            connettore.setParametersFormBased(this.msgContext.getParametriInvocazionePorta().getParametersFormBased());
            connettore.setParametersTrasporto(this.msgContext.getParametriInvocazionePorta().getParametersTrasporto());
            connettore.setUrlInvocazione(this.msgContext.getParametriInvocazionePorta().getUrlInvocazione_formBased());
        }
        connettore.setSoapAction(this.msgContext.getSoapAction());
        connettore.setFromLocation(this.msgContext.getFromLocation());
        inRequestContext.setConnettore(connettore);
        inRequestContext.setDataElaborazioneMessaggio(this.msgContext.getDataIngressoRichiesta());
        inRequestContext.setPddContext(this.msgContext.getPddContext());
        inRequestContext.setMessaggio(requestMessage);
        inRequestContext.setDimensioneMessaggioBytes(dimesioneIngressoMessaggio);
        try {
            GestoreHandlers.inRequest(inRequestContext, msgDiag);
        }
        catch (HandlerException e) {
            this.setSOAPFault_processamento(logCore, msgDiag, e, e.getIdentitaHandler());
            return;
        }
        catch (Exception e) {
            this.setSOAPFault_processamento(logCore, msgDiag, e, "InvocazioneInRequestHandler");
            return;
        }
        try {
            this.process_engine(inRequestContext);
        }
        catch (TracciamentoException tracciamentoException) {
            this.setSOAPFault_processamento(logCore, msgDiag, tracciamentoException, "TracciamentoNonRiuscito");
            return;
        }
        OutResponseContext outResponseContext = new OutResponseContext(logCore);
        outResponseContext.setTipoPorta(this.msgContext.getTipoPorta());
        outResponseContext.setDataElaborazioneMessaggio(DateManager.getDate());
        outResponseContext.setPddContext(inRequestContext.getPddContext());
        outResponseContext.setEgov(this.msgContext.getEgov());
        outResponseContext.setIntegrazione(this.msgContext.getIntegrazione());
        outResponseContext.setPropertiesRispostaTrasporto(this.msgContext.getHeaderIntegrazioneRisposta());
        Long dimesioneUscitaMessaggio = null;
        Message msgResponse = this.msgContext.getMessageResponse();
        try {
            dimesioneUscitaMessaggio = this.msgContext.getContentLengthResponse() != null ? this.msgContext.getContentLengthResponse() : Long.valueOf(SoapUtils.getLength((Message)msgResponse, (boolean)false));
        }
        catch (Exception e) {
            this.setSOAPFault_processamento(logCore, msgDiag, e, "CalcoloDimensioneRisposta");
            return;
        }
        outResponseContext.setDimensioneMessaggioBytes(dimesioneUscitaMessaggio);
        outResponseContext.setMessaggio(msgResponse);
        try {
            GestoreHandlers.outResponse(outResponseContext, msgDiag);
        }
        catch (HandlerException e) {
            this.setSOAPFault_processamento(logCore, msgDiag, e, e.getIdentitaHandler());
            return;
        }
        catch (Exception e) {
            this.setSOAPFault_processamento(logCore, msgDiag, e, "InvocazioneOutResponseHandler");
            return;
        }
        Message msgRisposta = null;
        try {
            msgRisposta = outResponseContext.getMessaggio();
            boolean rispostaPresente = true;
            OpenSPCoopProperties properties = OpenSPCoopProperties.getInstance();
            if (properties != null) {
                rispostaPresente = ServletUtils.verificaRispostaRelazioneCodiceTrasporto202(OpenSPCoopProperties.getInstance(), msgRisposta, true);
            }
            if (rispostaPresente) {
                if (this.responseAsByte) {
                    this.msgContext.setMessageResponseAsByte(msgRisposta);
                } else {
                    this.msgContext.setMessageResponse(msgRisposta);
                    this.msgContext.setContentLengthResponse(outResponseContext.getDimensioneMessaggioBytes());
                }
            } else {
                this.msgContext.setContentLengthResponse(null);
                this.msgContext.setMessageResponse(null);
                msgRisposta = null;
            }
        }
        catch (Exception e) {
            this.setSOAPFault_processamento(logCore, msgDiag, e, "FineGestioneRicezioneBusteEGov");
            return;
        }
        if (Dump.sistemaDumpDisponibile) {
            try {
                ConfigurazionePdDReader configurazionePdDReader = ConfigurazionePdDReader.getInstance();
                if (configurazionePdDReader.dumpMessaggi() && msgRisposta != null) {
                    EGovContext egov = this.msgContext.getEgov();
                    Dump dumpApplicativo = null;
                    dumpApplicativo = egov != null ? new Dump(egov.getIdentificativoPorta(), this.msgContext.getIdModulo(), egov.getIdRichiesta(), egov.getFruitore(), new IDServizio(egov.getErogatore(), egov.getTipoServizio(), egov.getServizio(), egov.getAzione()), this.msgContext.getTipoPorta(), this.msgContext.getPddContext()) : new Dump(null, this.msgContext.getIdModulo(), this.msgContext.getTipoPorta(), this.msgContext.getPddContext());
                    dumpApplicativo.dumpRispostaUscita(msgRisposta, inRequestContext.getConnettore(), outResponseContext.getPropertiesRispostaTrasporto());
                }
            }
            catch (TracciamentoException tracciamentoException) {
                this.setSOAPFault_processamento(logCore, msgDiag, tracciamentoException, "TracciamentoNonRiuscito");
                return;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    private void setSOAPFault_processamento(Logger logCore, MsgDiagnostico msgDiag, Exception e, String posizione) {
        this.setSOAPFault_engine(logCore, msgDiag, e, null, posizione, false);
    }

    private void setSOAPFault_processamento(String posizione) {
        this.setSOAPFault_engine(null, null, null, null, posizione, false);
    }

    private void setSOAPFault_intestazione(String codiceErrore, String posizione) {
        this.setSOAPFault_engine(null, null, null, codiceErrore, posizione, true);
    }

    private void setSOAPFault_engine(Logger logCore, MsgDiagnostico msgDiag, Exception e, String codiceErrore, String posizioneErrore, boolean validazione) {
        if (e != null) {
            if (!posizioneErrore.endsWith(":")) {
                posizioneErrore = posizioneErrore + ": ";
            }
            if (!posizioneErrore.endsWith(" ")) {
                posizioneErrore = posizioneErrore + " ";
            }
        }
        if (msgDiag != null) {
            msgDiag.logErroreGenerico(e, posizioneErrore);
        } else if (logCore != null) {
            logCore.error((Object)(posizioneErrore + e.getMessage()), (Throwable)e);
        }
        if (this.msgContext.isGestioneRisposta()) {
            Imbustamento imbustamento = null;
            imbustamento = logCore != null ? new Imbustamento(logCore) : new Imbustamento();
            Message messageFault = null;
            messageFault = validazione ? imbustamento.buildSPCoopSoapFault_intestazione(this.msgContext.getIdentitaPdD(), this.msgContext.getIdModulo(), codiceErrore, posizioneErrore) : (e != null ? imbustamento.buildSPCoopSoapFault_processamento(this.msgContext.getIdentitaPdD(), this.msgContext.getIdModulo(), "OPENSPCOOP_ORG_500", posizioneErrore, e) : imbustamento.buildSPCoopSoapFault_processamento(this.msgContext.getIdentitaPdD(), this.msgContext.getIdModulo(), "OPENSPCOOP_ORG_500", posizioneErrore));
            if (this.responseAsByte) {
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                try {
                    messageFault.writeTo((OutputStream)out);
                }
                catch (Exception eWriteTo) {
                    msgDiag.logErroreGenerico(e, "GenerazioneFaultAsBytes");
                }
                this.msgContext.setMessageRequestAsByte(out.toByteArray());
            }
            this.msgContext.setMessageResponse(messageFault);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void process_engine(InRequestContext inRequestContext) throws TracciamentoException {
        block413: {
            requestMessage = inRequestContext.getMessaggio();
            logCore = inRequestContext.getLogCore();
            dataIngressoMessaggio = new Timestamp(this.msgContext.getDataIngressoRichiesta().getTime());
            if (!OpenSPCoopStartup.initialize) {
                logCore.error((Object)"[RicezioneBusteEGov]  Inizializzazione di OpenSPCoop non correttamente effettuata");
                this.setSOAPFault_processamento("ErroreInizializzazioneOpenSPCoop");
                return;
            }
            if (!TimerMonitoraggioRisorse.risorseDisponibili) {
                logCore.error((Object)("[RicezioneBusteEGov]  Risorse di sistema non disponibili: " + TimerMonitoraggioRisorse.risorsaNonDisponibile.getMessage()), (Throwable)TimerMonitoraggioRisorse.risorsaNonDisponibile);
                this.setSOAPFault_processamento("RisorseSistemaNonDisponibili");
                return;
            }
            if (!TimerThreshold.freeSpace) {
                logCore.error((Object)"[RicezioneBusteEGov]  Non sono disponibili abbastanza risorse per la gestione della richiesta");
                this.setSOAPFault_processamento("RisorseSistemaLivelloCritico");
                return;
            }
            if (!Tracciamento.tracciamentoDisponibile) {
                logCore.error((Object)("[RicezioneBusteEGov]  Tracciatura e-Gov non disponibile: " + Tracciamento.motivoMalfunzionamentoTracciamento.getMessage()), (Throwable)Tracciamento.motivoMalfunzionamentoTracciamento);
                this.setSOAPFault_processamento("TracciaturaEGovNonDisponibile");
                return;
            }
            if (!MsgDiagnostico.gestoreDiagnosticaDisponibile) {
                logCore.error((Object)("[RicezioneBusteEGov]  Sistema di diagnostica non disponibile: " + MsgDiagnostico.motivoMalfunzionamentoDiagnostici.getMessage()), (Throwable)MsgDiagnostico.motivoMalfunzionamentoDiagnostici);
                this.setSOAPFault_processamento("DiagnosticaNonDisponibile");
                return;
            }
            if (!Dump.sistemaDumpDisponibile) {
                logCore.error((Object)("[RicezioneBusteEGov]  Sistema di dump dei contenuti applicativi non disponibile: " + Dump.motivoMalfunzionamentoDump.getMessage()), (Throwable)Dump.motivoMalfunzionamentoDump);
                this.setSOAPFault_processamento("SistemaDumpNonDisponibile");
                return;
            }
            configurazionePdDReader = ConfigurazionePdDReader.getInstance();
            try {
                configurazionePdDReader.verificaConsistenzaConfigurazione();
            }
            catch (Exception e) {
                logCore.error((Object)"[RicezioneBusteEGov]  Riscontrato errore durante la verifica della consistenza della configurazione PdD");
                this.setSOAPFault_processamento("RefreshConfigurazioneNonRiuscito");
                return;
            }
            registroServiziReader = RegistroServiziReader.getInstance();
            try {
                registroServiziReader.verificaConsistenzaRegistroServizi();
            }
            catch (Exception e) {
                logCore.error((Object)"[RicezioneBusteEGov]  Riscontrato errore durante la verifica del registro dei servizi", (Throwable)e);
                this.setSOAPFault_processamento("RefreshRegistroServiziNonRiuscito");
                return;
            }
            credenziali = this.msgContext.getCredenziali();
            propertiesReader = OpenSPCoopProperties.getInstance();
            className = ClassNameProperties.getInstance();
            identitaPdD = propertiesReader.getIdentitaPortaDefault();
            msgDiag = new MsgDiagnostico(identitaPdD.getCodicePorta(), this.msgContext.getIdModulo());
            this.msgContext.setMsgDiagnostico(msgDiag);
            msgDiag.setPddContext(inRequestContext.getPddContext());
            msgDiag.setPrefixMsgPersonalizzati("ricezioneBusteEGov.");
            this.setCredenziali(credenziali, msgDiag);
            imbustatore = new Imbustamento();
            try {
                if (!RicezioneBusteEGov.initializeService) {
                    msgDiag.mediumDebug("Inizializzazione risorse statiche...");
                    RicezioneBusteEGov.initializeService(className, propertiesReader, logCore);
                }
            }
            catch (Exception e) {
                this.setSOAPFault_processamento(logCore, msgDiag, e, "InizializzazioneRisorseServizioRicezioneBusteEGov");
                return;
            }
            headerRisposta = new Properties();
            utilitiesHttp = new UtilitiesIntegrazione();
            try {
                utilitiesHttp.setResponseTransportProperties(null, headerRisposta);
            }
            catch (Exception e) {
                this.setSOAPFault_processamento(logCore, msgDiag, e, "InizializzazioneHeaderRisposta");
                return;
            }
            this.msgContext.setHeaderIntegrazioneRisposta(headerRisposta);
            openspcoopstate = null;
            sbustamentoMSG = new SbustamentoMessage();
            inoltroMSG = new InoltroBusteEGovMessage();
            this.msgContext.setEgov(new EGovContext());
            this.msgContext.setIntegrazione(new IntegrationContext());
            msgDiag.mediumDebug("Richiesta connessione al database...");
            try {
                openspcoopstate = new OpenSPCoopStateful();
                openspcoopstate.initResource(identitaPdD, this.msgContext.getIdModulo());
            }
            catch (Exception e) {
                this.setSOAPFault_processamento(logCore, msgDiag, e, "initDatabaseResource");
                return;
            }
            servizioApplicativoFruitore = null;
            correlazioneApplicativa = null;
            if (!this.msgContext.isTracciamentoAbilitato()) {
                servizioApplicativoFruitore = this.msgContext.getIdentitaServizioApplicativoFruitore();
                correlazioneApplicativa = this.msgContext.getIdCorrelazioneApplicativa();
                msgDiag.addKeyword("@SERVIZIO_APPLICATIVO_FRUITORE@", servizioApplicativoFruitore);
                msgDiag.addKeyword("@ID_CORRELAZIONE_APPLICATIVA@", correlazioneApplicativa);
            }
            parametriGenerazioneSPCoopErrore = new RicezioneBusteEGovParametriGenerazioneSPCoopErrore();
            parametriGenerazioneSPCoopErrore.setOpenspcoop(openspcoopstate);
            parametriGenerazioneSPCoopErrore.setIdentitaPdD(identitaPdD);
            parametriGenerazioneSPCoopErrore.setMsgDiag(msgDiag);
            parametriGenerazioneSPCoopErrore.setPropertiesReader(propertiesReader);
            parametriGenerazioneSPCoopErrore.setLogCore(logCore);
            parametriGenerazioneSPCoopErrore.setCorrelazioneApplicativa(correlazioneApplicativa);
            parametriGenerazioneSPCoopErrore.setServizioApplicativoFruitore(servizioApplicativoFruitore);
            parametriGenerazioneSPCoopErrore.setImplementazionePdDMittente("standard");
            parametriGenerazioneSPCoopErrore.setImplementazionePdDDestinatario("standard");
            parametriGenerazioneSPCoopErrore.setImbustatore(imbustatore);
            parametriInvioSPCoopErrore = new RicezioneBusteEGovParametriInvioSPCoopErrore();
            parametriInvioSPCoopErrore.setOpenspcoop(openspcoopstate);
            parametriInvioSPCoopErrore.setIdentitaPdD(identitaPdD);
            parametriInvioSPCoopErrore.setMsgDiag(msgDiag);
            parametriInvioSPCoopErrore.setPropertiesReader(propertiesReader);
            parametriInvioSPCoopErrore.setLogCore(logCore);
            parametriInvioSPCoopErrore.setCorrelazioneApplicativa(correlazioneApplicativa);
            parametriInvioSPCoopErrore.setServizioApplicativoFruitore(servizioApplicativoFruitore);
            parametriInvioSPCoopErrore.setImplementazionePdDMittente("standard");
            parametriInvioSPCoopErrore.setImplementazionePdDDestinatario("standard");
            parametriInvioSPCoopErrore.setNewConnectionForResponse(false);
            parametriInvioSPCoopErrore.setUtilizzoIndirizzoTelematico(false);
            parametriInvioSPCoopErrore.setFunctionAsRouter(false);
            parametriInvioSPCoopErrore.setOnewayVersione11(false);
            parametriInvioSPCoopErrore.setPddContext(inRequestContext.getPddContext());
            if (configurazionePdDReader.dumpMessaggi()) {
                dumpApplicativo = new Dump(identitaPdD.getCodicePorta(), this.msgContext.getIdModulo(), this.msgContext.getTipoPorta(), inRequestContext.getPddContext());
                dumpApplicativo.dumpRichiestaIngresso(requestMessage, inRequestContext.getConnettore());
            }
            msgDiag.mediumDebug("Validazione busta eGov ricevuta in corso...");
            properties = new ProprietaValidazione();
            readQualifiedAttribute = propertiesReader.isReadQualifiedAttribute("standard");
            validatoreSPCoop = new ValidatoreSPCoop(requestMessage, properties, openspcoopstate.getStatoRichiesta(), readQualifiedAttribute);
            msgDiag.mediumDebug("Validazione sintattica busta eGov richiesta...");
            if (!validatoreSPCoop.validazioneSintattica()) {
                erroreIntestazione = null;
                setDestinatarioDefault = true;
                if (validatoreSPCoop.getBustaErroreHeaderIntestazione() != null) {
                    erroreIntestazione = validatoreSPCoop.getBustaErroreHeaderIntestazione();
                    if (!Configurazione.getConfigurazioneGenerazioneBusta().getKeywordMittenteSconosciuto().equals(erroreIntestazione.getDestinatario()) && !Configurazione.getConfigurazioneGenerazioneBusta().getKeywordTipoMittenteSconosciuto().equals(erroreIntestazione.getTipoDestinatario())) {
                        try {
                            dominioTmp = configurazionePdDReader.getDominio(new IDSoggetto(erroreIntestazione.getTipoDestinatario(), erroreIntestazione.getDestinatario()));
                            if (dominioTmp != null) {
                                identitaPdD.setCodicePorta(dominioTmp);
                                identitaPdD.setTipo(erroreIntestazione.getTipoDestinatario());
                                identitaPdD.setNome(erroreIntestazione.getDestinatario());
                                setDestinatarioDefault = false;
                                parametriGenerazioneSPCoopErrore.setIdentitaPdD(identitaPdD);
                                parametriInvioSPCoopErrore.setIdentitaPdD(identitaPdD);
                            }
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                }
                try {
                    if (erroreIntestazione != null) {
                        msgDiag.addKeywords(erroreIntestazione, true);
                        msgDiag.logPersonalizzato("ricezioneMessaggioSPCoop");
                    }
                    tracciamento = new Tracciamento(identitaPdD.getCodicePorta(), this.msgContext.getIdModulo(), inRequestContext.getPddContext());
                    if (this.msgContext.isTracciamentoAbilitato() && erroreIntestazione != null) {
                        msgDiag.mediumDebug("Tracciamento busta eGov di richiesta...");
                        eccezioniRiscontrate = erroreIntestazione.cloneEccezioni();
                        while (erroreIntestazione.sizeListaEccezioni() > 0) {
                            erroreIntestazione.removeEccezione(0);
                        }
                        tracciamento.registraRichiesta(openspcoopstate.getConnectionDB(), validatoreSPCoop.getHeaderEGov_senzaControlli(), erroreIntestazione, Tracciamento.createLocationString(true, this.msgContext.getFromLocation()), correlazioneApplicativa, servizioApplicativoFruitore);
                        while (eccezioniRiscontrate.size() > 0) {
                            erroreIntestazione.addEccezione((Eccezione)eccezioniRiscontrate.remove(0));
                        }
                    }
                }
                catch (Exception e) {
                    msgDiag.logErroreGenerico(e, "TracciamentoBustaEGovMalformata");
                    logCore.error((Object)"Riscontrato errore durante il tracciamento della busta eGov malformata ricevuta", (Throwable)e);
                }
                if (erroreIntestazione != null) {
                    msgDiag.addKeyword("@ECCEZIONI@", erroreIntestazione.toStringListaEccezioni());
                    msgDiag.logPersonalizzato("sbustamentoBustaEGov.", "validazioneSintatticaNonRiuscita");
                    if (this.msgContext.isGestioneRisposta()) {
                        if (setDestinatarioDefault) {
                            erroreIntestazione.setDestinatario(identitaPdD.getNome());
                            erroreIntestazione.setTipoDestinatario(identitaPdD.getTipo());
                        }
                        tracciamento = new Tracciamento(identitaPdD.getCodicePorta(), this.msgContext.getIdModulo(), inRequestContext.getPddContext());
                        parametriGenerazioneSPCoopErrore.setTracciamento(tracciamento);
                        parametriGenerazioneSPCoopErrore.setBusta(erroreIntestazione);
                        parametriGenerazioneSPCoopErrore.setError(erroreIntestazione.cloneEccezioni());
                        errorAxisMsg = this.generaSPCoopErroreValidazione(parametriGenerazioneSPCoopErrore);
                        parametriInvioSPCoopErrore.setAxisMsg(errorAxisMsg);
                        parametriInvioSPCoopErrore.setBusta(parametriGenerazioneSPCoopErrore.getBusta());
                        this.sendRispostaSPCoopErrore(parametriInvioSPCoopErrore);
                    }
                } else {
                    msgDiag.addKeyword("@ECCEZIONI@", validatoreSPCoop.getMsgErrore());
                    msgDiag.logPersonalizzato("sbustamentoBustaEGov.", "validazioneSintatticaNonRiuscita");
                    this.setSOAPFault_intestazione(validatoreSPCoop.getCodiceErrore(), validatoreSPCoop.getMsgErrore());
                }
                openspcoopstate.releaseResource();
                return;
            }
            soggettoFruitore = validatoreSPCoop.getSoggettoMittente();
            idServizio = validatoreSPCoop.getIDServizio();
            msgDiag.setIdEGovRichiesta(validatoreSPCoop.getBusta().getID());
            this.msgContext.setIdEGov(validatoreSPCoop.getBusta().getID());
            msgDiag.setFruitore(soggettoFruitore);
            msgDiag.setServizio(idServizio);
            msgDiag.setDelegata(false);
            msgDiag.addKeywords(validatoreSPCoop.getBusta(), true);
            parametriGenerazioneSPCoopErrore.setMsgDiag(msgDiag);
            parametriInvioSPCoopErrore.setMsgDiag(msgDiag);
            functionAsRouter = false;
            msgDiag.mediumDebug("Esamina modalita' di ricezione (PdD/Router)...");
            existsSoggetto = false;
            try {
                existsSoggetto = configurazionePdDReader.existsSoggetto(idServizio.getSoggettoErogatore());
            }
            catch (Exception e) {
                openspcoopstate.releaseResource();
                this.setSOAPFault_processamento(logCore, msgDiag, e, "existsSoggetto(" + idServizio.getSoggettoErogatore().toString() + ")");
                return;
            }
            if (!existsSoggetto) {
                msgDiag.mediumDebug("Raccolta identita router...");
                routerFunctionActive = false;
                try {
                    routerFunctionActive = configurazionePdDReader.routerFunctionActive();
                }
                catch (Exception e) {
                    openspcoopstate.releaseResource();
                    this.setSOAPFault_processamento(logCore, msgDiag, e, "ErroreCheckFunzionalitaRouterAttiva");
                    return;
                }
                if (routerFunctionActive) {
                    functionAsRouter = true;
                    try {
                        identitaPdD = configurazionePdDReader.getRouterIdentity();
                    }
                    catch (Exception e) {
                        openspcoopstate.releaseResource();
                        this.setSOAPFault_processamento(logCore, msgDiag, e, "ErroreRiconoscimentoIdentitaRouter");
                        return;
                    }
                }
            } else {
                msgDiag.mediumDebug("Raccolta identita porta di dominio...");
                dominio = null;
                try {
                    dominio = configurazionePdDReader.getDominio(idServizio.getSoggettoErogatore());
                    if (dominio == null) {
                        throw new Exception("Dominio is null");
                    }
                }
                catch (Exception e) {
                    openspcoopstate.releaseResource();
                    this.setSOAPFault_processamento(logCore, msgDiag, e, "ErroreRiconoscimentoIdentitaPdD");
                    return;
                }
                identitaPdD = new IDSoggetto(idServizio.getSoggettoErogatore().getTipo(), idServizio.getSoggettoErogatore().getNome(), dominio);
            }
            if (functionAsRouter) {
                this.msgContext.setTipoPorta(TipoPdD.ROUTER);
            }
            parametriGenerazioneSPCoopErrore.setIdentitaPdD(identitaPdD);
            parametriInvioSPCoopErrore.setIdentitaPdD(identitaPdD);
            parametriInvioSPCoopErrore.setFunctionAsRouter(functionAsRouter);
            msgDiag.setDominioSPCoop(identitaPdD.getCodicePorta());
            parametriGenerazioneSPCoopErrore.setMsgDiag(msgDiag);
            parametriInvioSPCoopErrore.setMsgDiag(msgDiag);
            tracciamento = new Tracciamento(identitaPdD.getCodicePorta(), this.msgContext.getIdModulo(), inRequestContext.getPddContext());
            parametriGenerazioneSPCoopErrore.setTracciamento(tracciamento);
            bustaRichiesta = validatoreSPCoop.getBusta();
            idEGovRequest = bustaRichiesta.getID();
            tipoPorta = TipoPdD.APPLICATIVA;
            if (functionAsRouter) {
                tipoPorta = TipoPdD.ROUTER;
            }
            this.msgContext.getEgov().setIdentificativoPorta(identitaPdD.getCodicePorta());
            this.msgContext.setTipoPorta(tipoPorta);
            this.msgContext.getEgov().setFruitore(soggettoFruitore);
            this.msgContext.getEgov().setErogatore(idServizio.getSoggettoErogatore());
            this.msgContext.getEgov().setTipoServizio(idServizio.getTipoServizio());
            this.msgContext.getEgov().setServizio(idServizio.getServizio());
            this.msgContext.getEgov().setAzione(idServizio.getAzione());
            this.msgContext.getEgov().setIdRichiesta(idEGovRequest);
            this.msgContext.getEgov().setProfiloCollaborazione(bustaRichiesta.getProfiloDiCollaborazione());
            this.msgContext.getEgov().setCollaborazione(bustaRichiesta.getCollaborazione());
            idModuloInAttesa = null;
            if (this.msgContext.isGestioneRisposta()) {
                idModuloInAttesa = this.msgContext.getIdModulo();
            }
            richiestaApplicativa = new RichiestaApplicativa(soggettoFruitore, idServizio, idModuloInAttesa, identitaPdD);
            richiestaApplicativa.setFiltroProprietaPorteApplicative(this.msgContext.getProprietaFiltroPortaApplicativa());
            wssReceiver = null;
            baseWSS = null;
            wssPropertiesRequest = null;
            wssPropertiesResponse = null;
            newConnectionForResponse = false;
            utilizzoIndirizzoTelematico = false;
            ruoloBustaEgovRicevuta = null;
            if (!functionAsRouter) {
                if ("EGOV_IT_ServizioAsincronoAsimmetrico".equals(bustaRichiesta.getProfiloDiCollaborazione()) || "EGOV_IT_ServizioAsincronoSimmetrico".equals(bustaRichiesta.getProfiloDiCollaborazione())) {
                    newConnectionForResponse = configurazionePdDReader.newConnectionForResponseSPCoop();
                    utilizzoIndirizzoTelematico = configurazionePdDReader.isUtilizzoIndirizzoTelematico();
                    parametriInvioSPCoopErrore.setNewConnectionForResponse(newConnectionForResponse);
                    parametriInvioSPCoopErrore.setUtilizzoIndirizzoTelematico(utilizzoIndirizzoTelematico);
                }
                if (!validatoreSPCoop.isSPCoopErrore() && !validatoreSPCoop.isBustaDiServizio()) {
                    try {
                        scadenzaControllo = DateManager.getTimeMillis() + propertiesReader.getTimeoutBustaRispostaAsincrona();
                        checkIntervalControllo = propertiesReader.getCheckIntervalBustaRispostaAsincrona();
                        attendiTerminazioneRichiesta = this.gestioneRispostaAsincrona_checkPresenzaRichiesta(scadenzaControllo, checkIntervalControllo, bustaRichiesta, openspcoopstate, msgDiag, newConnectionForResponse);
                        attendiTerminazioneRicevutaRichiesta = this.gestioneRispostaAsincrona_checkPresenzaRicevutaRichiesta(scadenzaControllo, checkIntervalControllo, bustaRichiesta, openspcoopstate, msgDiag, newConnectionForResponse);
                        codiceErrore = null;
                        motivoErrore = null;
                        if (attendiTerminazioneRichiesta) {
                            msgDiag.logPersonalizzato("attesaFineProcessamento.richiestaAsincrona.timeoutScaduto");
                            codiceErrore = "OPENSPCOOP_ORG_538";
                            motivoErrore = "Busta asincrona non gestibile poich\u00e8 risulta ancora in gestione nella porta la precedente richiesta.";
                        } else if (attendiTerminazioneRicevutaRichiesta) {
                            msgDiag.logPersonalizzato("attesaFineProcessamento.ricevutaRichiestaAsincrona.timeoutScaduto");
                            codiceErrore = "OPENSPCOOP_ORG_539";
                            motivoErrore = "Busta asincrona non gestibile poich\u00e8 risulta ancora in gestione nella porta la precedente ricevuta alla richiesta.";
                        }
                        if (attendiTerminazioneRichiesta || attendiTerminazioneRicevutaRichiesta) {
                            if (this.msgContext.isTracciamentoAbilitato()) {
                                tracciamento.registraRichiesta(openspcoopstate.getConnectionDB(), bustaRichiesta, Tracciamento.createLocationString(true, this.msgContext.getFromLocation()), correlazioneApplicativa, servizioApplicativoFruitore);
                            }
                            if (this.msgContext.isGestioneRisposta()) {
                                parametriGenerazioneSPCoopErrore.setBusta(bustaRichiesta);
                                parametriGenerazioneSPCoopErrore.setMessaggioErrore(motivoErrore);
                                parametriGenerazioneSPCoopErrore.setCodiceErrore(codiceErrore);
                                errorAxisMsg = this.generaSPCoopErroreProcessamento(parametriGenerazioneSPCoopErrore, null);
                                parametriInvioSPCoopErrore.setAxisMsg(errorAxisMsg);
                                parametriInvioSPCoopErrore.setBusta(parametriGenerazioneSPCoopErrore.getBusta());
                                this.sendRispostaSPCoopErrore(parametriInvioSPCoopErrore);
                            }
                            openspcoopstate.releaseResource();
                            return;
                        }
                    }
                    catch (Exception e) {
                        msgDiag.logPersonalizzato("ricezioneMessaggioSPCoop");
                        msgDiag.logErroreGenerico(e, "checkPresenzaRichiestaRicevutaAsincronaAncoraInGestione");
                        logCore.error((Object)"Controllo presenza richieste/ricevuteRichieste ancora in gestione correlate alla risposta/richiesta-stato asincrona simmetrica/asimmetrica arrivata, non riuscito", (Throwable)e);
                        if (this.msgContext.isTracciamentoAbilitato()) {
                            tracciamento.registraRichiesta(openspcoopstate.getConnectionDB(), bustaRichiesta, Tracciamento.createLocationString(true, this.msgContext.getFromLocation()), correlazioneApplicativa, servizioApplicativoFruitore);
                        }
                        if (this.msgContext.isGestioneRisposta()) {
                            parametriGenerazioneSPCoopErrore.setBusta(bustaRichiesta);
                            parametriGenerazioneSPCoopErrore.setMessaggioErrore("Sistema non disponibile");
                            parametriGenerazioneSPCoopErrore.setCodiceErrore("OPENSPCOOP_ORG_536");
                            errorAxisMsg = this.generaSPCoopErroreProcessamento(parametriGenerazioneSPCoopErrore, e);
                            parametriInvioSPCoopErrore.setAxisMsg(errorAxisMsg);
                            parametriInvioSPCoopErrore.setBusta(parametriGenerazioneSPCoopErrore.getBusta());
                            this.sendRispostaSPCoopErrore(parametriInvioSPCoopErrore);
                        }
                        openspcoopstate.releaseResource();
                        return;
                    }
                }
                try {
                    ruoloBustaEgovRicevuta = validatoreSPCoop.getRuoloBustaEgovRicevuta(false);
                }
                catch (Exception e) {
                    msgDiag.logErroreGenerico(e, "validator.getRuoloBustaEgovRicevuta(false)");
                }
            }
            implementazionePdDMittente = null;
            implementazionePdDDestinatario = null;
            msgDiag.mediumDebug("Ricerca implementazione della porta di dominio dei soggetti...");
            proprietaManifestAttachments = null;
            validazioneIDEGovCompleta = true;
            try {
                implementazionePdDMittente = registroServiziReader.getImplementazionePdD(soggettoFruitore, null);
                implementazionePdDDestinatario = registroServiziReader.getImplementazionePdD(idServizio.getSoggettoErogatore(), null);
                parametriGenerazioneSPCoopErrore.setImplementazionePdDMittente(implementazionePdDMittente);
                parametriGenerazioneSPCoopErrore.setImplementazionePdDDestinatario(implementazionePdDDestinatario);
                parametriInvioSPCoopErrore.setImplementazionePdDMittente(implementazionePdDMittente);
                parametriInvioSPCoopErrore.setImplementazionePdDDestinatario(implementazionePdDDestinatario);
                properties.setValidazioneConSchema(configurazionePdDReader.isLivelloValidazioneRigido(implementazionePdDMittente));
                properties.setValidazioneProfiloCollaborazione(configurazionePdDReader.isValidazioneProfiloCollaborazione(implementazionePdDMittente));
                validatoreSPCoop.setProprietaValidazione(properties);
                baseWSS = new WSSBaseUtils(SoapUtils.getAxisServer(), propertiesReader.isGenerazioneActorDefault(implementazionePdDMittente), propertiesReader.getActorDefault(implementazionePdDMittente), logCore, propertiesReader.getPrefixWsuId());
                parametriGenerazioneSPCoopErrore.setBaseWSS(baseWSS);
                proprietaManifestAttachments = propertiesReader.getProprietaManifestAttachments(implementazionePdDMittente);
                readQualifiedAttribute = propertiesReader.isReadQualifiedAttribute(implementazionePdDMittente);
                validazioneIDEGovCompleta = propertiesReader.isValidazioneIDEgovCompleta(implementazionePdDMittente);
            }
            catch (Exception e) {
                msgDiag.logErroreGenerico(e, "ricercaImplementazionePdDSoggettiBusta");
                if (this.msgContext.isTracciamentoAbilitato()) {
                    tracciamento.registraRichiesta(openspcoopstate.getConnectionDB(), bustaRichiesta, Tracciamento.createLocationString(true, this.msgContext.getFromLocation()), correlazioneApplicativa, servizioApplicativoFruitore);
                }
                if (this.msgContext.isGestioneRisposta()) {
                    parametriGenerazioneSPCoopErrore.setBusta(bustaRichiesta);
                    parametriGenerazioneSPCoopErrore.setMessaggioErrore("Sistema non disponibile");
                    parametriGenerazioneSPCoopErrore.setCodiceErrore("OPENSPCOOP_ORG_536");
                    errorAxisMsg = this.generaSPCoopErroreProcessamento(parametriGenerazioneSPCoopErrore, e);
                    parametriInvioSPCoopErrore.setAxisMsg(errorAxisMsg);
                    parametriInvioSPCoopErrore.setBusta(parametriGenerazioneSPCoopErrore.getBusta());
                    this.sendRispostaSPCoopErrore(parametriInvioSPCoopErrore);
                }
                openspcoopstate.releaseResource();
                return;
            }
            msgDiag.mediumDebug("ImplementazionePdD soggetto (" + soggettoFruitore.toString() + ") e' [" + implementazionePdDMittente + "], soggetto (" + idServizio.getSoggettoErogatore().toString() + ") e' [" + implementazionePdDDestinatario + "]");
            pa = null;
            pd = null;
            servizioApplicativoErogatoreAsincronoSimmetricoRisposta = null;
            if (!functionAsRouter) {
                msgDiag.mediumDebug("Lettura porta applicativa/delegata...");
                try {
                    if (("EGOV_IT_ServizioAsincronoSimmetrico".equals(bustaRichiesta.getProfiloDiCollaborazione()) || "EGOV_IT_ServizioAsincronoAsimmetrico".equals(bustaRichiesta.getProfiloDiCollaborazione())) && !RuoloBustaEGov.RICHIESTA.equals(ruoloBustaEgovRicevuta.toString())) {
                        msgDiag.mediumDebug("Richiesta asincrona...");
                        profiloCollaborazione = new ProfiloDiCollaborazione(openspcoopstate.getStatoRichiesta());
                        if ("EGOV_IT_ServizioAsincronoSimmetrico".equals(bustaRichiesta.getProfiloDiCollaborazione())) {
                            repository = new RepositoryEGov(openspcoopstate.getStatoRichiesta(), true);
                            integrazione = null;
                            integrazione = bustaRichiesta.getRiferimentoMessaggio() != null ? repository.getInfoIntegrazioneFromOutBox(bustaRichiesta.getRiferimentoMessaggio()) : repository.getInfoIntegrazioneFromOutBox(bustaRichiesta.getCollaborazione());
                            servizioApplicativoErogatoreAsincronoSimmetricoRisposta = integrazione.getServizioApplicativo();
                            idPD = new IDPortaDelegata();
                            idPD.setLocationPD(integrazione.getLocationPD());
                            idPD.setSoggettoFruitore(new IDSoggetto(bustaRichiesta.getTipoDestinatario(), bustaRichiesta.getDestinatario()));
                            pd = configurazionePdDReader.getPortaDelegata_SafeMethod(idPD);
                        } else if ("EGOV_IT_ServizioAsincronoAsimmetrico".equals(bustaRichiesta.getProfiloDiCollaborazione())) {
                            if (RuoloBustaEGov.RISPOSTA.equals(ruoloBustaEgovRicevuta.toString())) {
                                idServizioOriginale = null;
                                idServizioOriginale = bustaRichiesta.getRiferimentoMessaggio() != null ? profiloCollaborazione.asincronoAsimmetrico_getDatiConsegnaRisposta(bustaRichiesta.getRiferimentoMessaggio()) : profiloCollaborazione.asincronoAsimmetrico_getDatiConsegnaRisposta(bustaRichiesta.getCollaborazione());
                                idServizioOriginale.setSoggettoErogatore(richiestaApplicativa.getIDServizio().getSoggettoErogatore());
                                ra = new RichiestaApplicativa(richiestaApplicativa.getSoggettoFruitore(), idServizioOriginale, richiestaApplicativa.getDominio());
                                pa = configurazionePdDReader.getPortaApplicativa_SafeMethod(ra.getIdPortaApplicativa(), this.msgContext.getProprietaFiltroPortaApplicativa());
                            } else if (RuoloBustaEGov.RICEVUTA_RICHIESTA.equals(ruoloBustaEgovRicevuta.toString()) || RuoloBustaEGov.RICEVUTA_RISPOSTA.equals(ruoloBustaEgovRicevuta.toString())) {
                                repository = new RepositoryEGov(openspcoopstate.getStatoRichiesta(), true);
                                integrazione = null;
                                integrazione = bustaRichiesta.getRiferimentoMessaggio() != null ? repository.getInfoIntegrazioneFromOutBox(bustaRichiesta.getRiferimentoMessaggio()) : repository.getInfoIntegrazioneFromOutBox(bustaRichiesta.getCollaborazione());
                                idPD = new IDPortaDelegata();
                                idPD.setLocationPD(integrazione.getLocationPD());
                                idPD.setSoggettoFruitore(new IDSoggetto(bustaRichiesta.getTipoDestinatario(), bustaRichiesta.getDestinatario()));
                                pd = configurazionePdDReader.getPortaDelegata_SafeMethod(idPD);
                            }
                        }
                        ((StateMessage)openspcoopstate.getStatoRichiesta()).closePreparedStatement();
                    } else {
                        pa = configurazionePdDReader.getPortaApplicativa_SafeMethod(richiestaApplicativa.getIdPortaApplicativa(), this.msgContext.getProprietaFiltroPortaApplicativa());
                    }
                    properties.setValidazioneManifestAttachments(configurazionePdDReader.isValidazioneManifestAttachments(implementazionePdDMittente) != false && configurazionePdDReader.isGestioneManifestAttachments(pa) != false);
                }
                catch (Exception e) {
                    if (e instanceof DriverConfigurazioneNotFound) break block413;
                    msgDiag.logErroreGenerico(e, "letturaPorta");
                    if (this.msgContext.isTracciamentoAbilitato()) {
                        tracciamento.registraRichiesta(openspcoopstate.getConnectionDB(), bustaRichiesta, Tracciamento.createLocationString(true, this.msgContext.getFromLocation()), correlazioneApplicativa, servizioApplicativoFruitore);
                    }
                    if (this.msgContext.isGestioneRisposta()) {
                        parametriGenerazioneSPCoopErrore.setBusta(bustaRichiesta);
                        parametriGenerazioneSPCoopErrore.setMessaggioErrore("Sistema non disponibile");
                        parametriGenerazioneSPCoopErrore.setCodiceErrore("OPENSPCOOP_ORG_536");
                        errorAxisMsg = this.generaSPCoopErroreProcessamento(parametriGenerazioneSPCoopErrore, e);
                        parametriInvioSPCoopErrore.setAxisMsg(errorAxisMsg);
                        parametriInvioSPCoopErrore.setBusta(parametriGenerazioneSPCoopErrore.getBusta());
                        this.sendRispostaSPCoopErrore(parametriInvioSPCoopErrore);
                    }
                    openspcoopstate.releaseResource();
                    return;
                }
            }
        }
        if (pa != null) {
            for (i = 0; i < pa.sizeServizioApplicativoList(); ++i) {
                this.msgContext.getIntegrazione().addServizioApplicativoErogatore(pa.getServizioApplicativo(i).getNome());
            }
        } else if (servizioApplicativoErogatoreAsincronoSimmetricoRisposta != null) {
            this.msgContext.getIntegrazione().addServizioApplicativoErogatore(servizioApplicativoErogatoreAsincronoSimmetricoRisposta);
        }
        tipiIntegrazionePA = null;
        if (propertiesReader.processHeaderIntegrazionePA()) {
            if (functionAsRouter) {
                tipiIntegrazionePA = RicezioneBusteEGov.defaultGestoriIntegrazionePA;
            } else {
                if (pa != null && this.msgContext.isTracciamentoAbilitato()) {
                    msgDiag.mediumDebug("Lettura header di integrazione...");
                    try {
                        tipiIntegrazionePA = configurazionePdDReader.getTipiIntegrazione(pa);
                    }
                    catch (Exception e) {
                        msgDiag.logErroreGenerico(e, "configurazionePdDReader.getTipiIntegrazione(pa)");
                        if (this.msgContext.isTracciamentoAbilitato()) {
                            tracciamento.registraRichiesta(openspcoopstate.getConnectionDB(), bustaRichiesta, Tracciamento.createLocationString(true, this.msgContext.getFromLocation()), correlazioneApplicativa, servizioApplicativoFruitore);
                        }
                        if (this.msgContext.isGestioneRisposta()) {
                            parametriGenerazioneSPCoopErrore.setBusta(bustaRichiesta);
                            parametriGenerazioneSPCoopErrore.setMessaggioErrore("Sistema non disponibile");
                            parametriGenerazioneSPCoopErrore.setCodiceErrore("OPENSPCOOP_ORG_536");
                            errorAxisMsg = this.generaSPCoopErroreProcessamento(parametriGenerazioneSPCoopErrore, e);
                            parametriInvioSPCoopErrore.setAxisMsg(errorAxisMsg);
                            parametriInvioSPCoopErrore.setBusta(parametriGenerazioneSPCoopErrore.getBusta());
                            this.sendRispostaSPCoopErrore(parametriInvioSPCoopErrore);
                        }
                        openspcoopstate.releaseResource();
                        return;
                    }
                }
                if (tipiIntegrazionePA == null) {
                    tipiIntegrazionePA = RicezioneBusteEGov.defaultGestoriIntegrazionePA;
                }
            }
        }
        if (tipiIntegrazionePA != null) {
            headerIntegrazioneRichiesta = new HeaderIntegrazione();
            for (i = 0; i < tipiIntegrazionePA.length; ++i) {
                try {
                    integrazioneSOAP = false;
                    integrazioneSOAP = RicezioneBusteEGov.gestoriIntegrazionePASoap.containsKey(tipiIntegrazionePA[i]) == false && RicezioneBusteEGov.gestoriIntegrazionePANonSOAP.contains(tipiIntegrazionePA[i]) == false ? RicezioneBusteEGov.aggiornaListaGestoreIntegrazione(tipiIntegrazionePA[i], className, propertiesReader, logCore) : RicezioneBusteEGov.gestoriIntegrazionePASoap.containsKey(tipiIntegrazionePA[i]);
                    if (!integrazioneSOAP) continue;
                    gestore = RicezioneBusteEGov.gestoriIntegrazionePASoap.get(tipiIntegrazionePA[i]);
                    if (gestore != null) {
                        gestore.readHeader(headerIntegrazioneRichiesta, requestMessage);
                        if (!propertiesReader.deleteHeaderIntegrazionePA(functionAsRouter)) continue;
                        gestore.deleteHeader(requestMessage);
                        continue;
                    }
                    msgDiag.logErroreGenerico("Gestore [" + tipiIntegrazionePA[i] + "], per la lettura dell'header di integrazione, non inizializzato", "gestoriIntegrazionePASoap.get(" + tipiIntegrazionePA[i] + ")");
                    continue;
                }
                catch (Exception e) {
                    msgDiag.addKeyword("@TIPO_HEADER_INTEGRAZIONE@", tipiIntegrazionePA[i]);
                    msgDiag.addKeyword("@ERRORE_PROCESSAMENTO@", e.toString());
                    msgDiag.logPersonalizzato("headerIntegrazione.letturaFallita");
                }
            }
            if (headerIntegrazioneRichiesta != null) {
                servizioApplicativoFruitore = this.msgContext.getIdentitaServizioApplicativoFruitore() != null ? this.msgContext.getIdentitaServizioApplicativoFruitore() : headerIntegrazioneRichiesta.getServizioApplicativo();
                parametriGenerazioneSPCoopErrore.setServizioApplicativoFruitore(servizioApplicativoFruitore);
                parametriInvioSPCoopErrore.setServizioApplicativoFruitore(servizioApplicativoFruitore);
                correlazioneApplicativa = this.msgContext.getIdCorrelazioneApplicativa() != null ? this.msgContext.getIdCorrelazioneApplicativa() : headerIntegrazioneRichiesta.getIdApplicativo();
                parametriGenerazioneSPCoopErrore.setCorrelazioneApplicativa(correlazioneApplicativa);
                parametriInvioSPCoopErrore.setCorrelazioneApplicativa(correlazioneApplicativa);
                msgDiag.addKeyword("@SERVIZIO_APPLICATIVO_FRUITORE@", servizioApplicativoFruitore);
                msgDiag.addKeyword("@ID_CORRELAZIONE_APPLICATIVA@", correlazioneApplicativa);
                this.msgContext.getIntegrazione().setIdCorrelazioneApplicativa(correlazioneApplicativa);
                this.msgContext.getIntegrazione().setServizioApplicativoFruitore(servizioApplicativoFruitore);
            }
        }
        if (RicezioneBusteEGov.tipiGestoriCredenziali != null) {
            msgDiag.mediumDebug("Gestione personalizzata delle credenziali...");
            for (i = 0; i < RicezioneBusteEGov.tipiGestoriCredenziali.length; ++i) {
                try {
                    gestore = RicezioneBusteEGov.gestoriCredenziali.get(RicezioneBusteEGov.tipiGestoriCredenziali[i]);
                    if (gestore != null) {
                        credenzialiRitornate = gestore.elaborazioneCredenziali(inRequestContext.getConnettore(), requestMessage);
                        if (credenzialiRitornate == null) {
                            throw new Exception("Credenziali non ritornate");
                        }
                        if (!inRequestContext.getConnettore().getCredenziali().equals(credenzialiRitornate)) {
                            nuoveCredenziali = credenzialiRitornate.toString();
                            nuoveCredenziali = nuoveCredenziali.substring(0, nuoveCredenziali.length() - 1);
                            msgDiag.addKeyword("@NUOVE_CREDENZIALI@", nuoveCredenziali);
                            identita = gestore.getIdentitaGestoreCredenziali();
                            if (identita == null) {
                                identita = "Gestore delle credenziali di tipo " + RicezioneBusteEGov.tipiGestoriCredenziali[i];
                            }
                            msgDiag.addKeyword("@IDENTITA_GESTORE_CREDENZIALI@", identita);
                            msgDiag.logPersonalizzato("gestoreCredenziali.nuoveCredenziali");
                            inRequestContext.getConnettore().setCredenziali(credenzialiRitornate);
                            credenziali = credenzialiRitornate;
                            this.setCredenziali(credenziali, msgDiag);
                        }
                        continue;
                    }
                    throw new Exception("non inizializzato");
                }
                catch (Exception e) {
                    logCore.error((Object)("Errore durante l'identificazione delle credenziali [" + RicezioneBusteEGov.tipiGestoriCredenziali[i] + "]: " + e.getMessage()), (Throwable)e);
                    msgDiag.addKeyword("@TIPO_GESTORE_CREDENZIALI@", RicezioneBusteEGov.tipiGestoriCredenziali[i]);
                    msgDiag.addKeyword("@ERRORE_PROCESSAMENTO@", e.getMessage());
                    msgDiag.logPersonalizzato("gestoreCredenziali.errore");
                    codiceErrore = null;
                    messaggioErrore = null;
                    if (e instanceof GestoreCredenzialiConfigurationException) {
                        codiceErrore = "OPENSPCOOP_ORG_431";
                        messaggioErrore = "Riscontrato errore durante la gestione delle credenziali effettuata tramite il gestore [#MSG_431_GESTORE_KEY#]: ".replace("#MSG_431_GESTORE_KEY#", RicezioneBusteEGov.tipiGestoriCredenziali[i]) + e.getMessage();
                    } else {
                        codiceErrore = "OPENSPCOOP_ORG_548";
                        messaggioErrore = "Sistema non disponibile";
                    }
                    if (this.msgContext.isTracciamentoAbilitato()) {
                        tracciamento.registraRichiesta(openspcoopstate.getConnectionDB(), bustaRichiesta, Tracciamento.createLocationString(true, this.msgContext.getFromLocation()), correlazioneApplicativa, servizioApplicativoFruitore);
                    }
                    if (this.msgContext.isGestioneRisposta()) {
                        parametriGenerazioneSPCoopErrore.setBusta(bustaRichiesta);
                        parametriGenerazioneSPCoopErrore.setMessaggioErrore(messaggioErrore);
                        parametriGenerazioneSPCoopErrore.setCodiceErrore(codiceErrore);
                        errorAxisMsg = this.generaSPCoopErroreProcessamento(parametriGenerazioneSPCoopErrore, e);
                        parametriInvioSPCoopErrore.setAxisMsg(errorAxisMsg);
                        parametriInvioSPCoopErrore.setBusta(parametriGenerazioneSPCoopErrore.getBusta());
                        this.sendRispostaSPCoopErrore(parametriInvioSPCoopErrore);
                    }
                    openspcoopstate.releaseResource();
                    return;
                }
            }
        }
        oneWayStateless = false;
        oneWayVersione11 = false;
        sincronoStateless = false;
        asincronoStateless = false;
        portaStateless = false;
        routingStateless = false;
        try {
            if (!functionAsRouter) {
                if (!propertiesReader.isServerJ2EE()) {
                    oneWayStateless = true;
                    sincronoStateless = true;
                    asincronoStateless = true;
                } else if ("EGOV_IT_MessaggioSingoloOneWay".equals(bustaRichiesta.getProfiloDiCollaborazione())) {
                    oneWayStateless = configurazionePdDReader.isModalitaStateless(pa, bustaRichiesta.getProfiloDiCollaborazione());
                } else if ("EGOV_IT_ServizioSincrono".equals(bustaRichiesta.getProfiloDiCollaborazione())) {
                    sincronoStateless = configurazionePdDReader.isModalitaStateless(pa, bustaRichiesta.getProfiloDiCollaborazione());
                } else if (("EGOV_IT_ServizioAsincronoSimmetrico".equals(bustaRichiesta.getProfiloDiCollaborazione()) || "EGOV_IT_ServizioAsincronoAsimmetrico".equals(bustaRichiesta.getProfiloDiCollaborazione())) && !RuoloBustaEGov.RICEVUTA_RICHIESTA.equals(ruoloBustaEgovRicevuta.toString()) && !RuoloBustaEGov.RICEVUTA_RISPOSTA.equals(ruoloBustaEgovRicevuta.toString())) {
                    asincronoStateless = "EGOV_IT_ServizioAsincronoSimmetrico".equals(bustaRichiesta.getProfiloDiCollaborazione()) != false && pd != null ? configurazionePdDReader.isModalitaStateless(pd, bustaRichiesta.getProfiloDiCollaborazione()) : configurazionePdDReader.isModalitaStateless(pa, bustaRichiesta.getProfiloDiCollaborazione());
                }
                v0 = oneWayVersione11 = propertiesReader.isGestioneOnewayStateful_1_1() != false && "EGOV_IT_MessaggioSingoloOneWay".equals(bustaRichiesta.getProfiloDiCollaborazione()) != false && oneWayStateless == false;
                if (oneWayStateless || sincronoStateless || asincronoStateless || oneWayVersione11) {
                    portaStateless = true;
                    if (!oneWayVersione11) {
                        this.msgContext.getIntegrazione().setGestioneStateless(true);
                    } else {
                        this.msgContext.getIntegrazione().setGestioneStateless(false);
                    }
                } else {
                    this.msgContext.getIntegrazione().setGestioneStateless(false);
                }
            } else {
                routingStateless = "abilitato".equals(propertiesReader.getStatelessRouting());
                this.msgContext.getIntegrazione().setGestioneStateless(routingStateless);
            }
            parametriInvioSPCoopErrore.setOnewayVersione11(oneWayVersione11);
        }
        catch (Exception e) {
            msgDiag.logErroreGenerico(e, "AnalisiModalitaGestioneStatefulStateless");
            logCore.error((Object)("Analisi modalita di gestione STATEFUL/STATELESS non riuscita: " + e));
            if (this.msgContext.isGestioneRisposta()) {
                parametriGenerazioneSPCoopErrore.setBusta(bustaRichiesta);
                parametriGenerazioneSPCoopErrore.setMessaggioErrore("Sistema non disponibile");
                parametriGenerazioneSPCoopErrore.setCodiceErrore("OPENSPCOOP_ORG_536");
                errorAxisMsg = this.generaSPCoopErroreProcessamento(parametriGenerazioneSPCoopErrore, e);
                parametriInvioSPCoopErrore.setAxisMsg(errorAxisMsg);
                parametriInvioSPCoopErrore.setBusta(parametriGenerazioneSPCoopErrore.getBusta());
                this.sendRispostaSPCoopErrore(parametriInvioSPCoopErrore);
            }
            openspcoopstate.releaseResource();
            return;
        }
        if (!("EGOV_IT_ServizioSincrono".equals(bustaRichiesta.getProfiloDiCollaborazione()) || oneWayStateless || sincronoStateless || asincronoStateless || routingStateless)) {
            newConnectionForResponse = configurazionePdDReader.newConnectionForResponseSPCoop();
        }
        parametriInvioSPCoopErrore.setNewConnectionForResponse(newConnectionForResponse);
        if (!(oneWayStateless || sincronoStateless || asincronoStateless || routingStateless)) {
            utilizzoIndirizzoTelematico = configurazionePdDReader.isUtilizzoIndirizzoTelematico();
        }
        parametriInvioSPCoopErrore.setUtilizzoIndirizzoTelematico(utilizzoIndirizzoTelematico);
        if (routingStateless) {
            openspcoopstate.releaseResource();
        }
        try {
            inRequestEGovContext = new InRequestEGovContext(inRequestContext);
            if (inRequestEGovContext.getConnettore() != null) {
                inRequestEGovContext.getConnettore().setCredenziali(credenziali);
            }
            inRequestEGovContext.setEgov(this.msgContext.getEgov());
            inRequestEGovContext.setIntegrazione(this.msgContext.getIntegrazione());
            GestoreHandlers.inRequestEGov(inRequestEGovContext, msgDiag);
        }
        catch (Exception e) {
            if (e instanceof HandlerException) {
                he = (HandlerException)e;
                msgDiag.logErroreGenerico(e, he.getIdentitaHandler());
                logCore.error((Object)("Gestione InRequestEGovHandler non riuscita (" + he.getIdentitaHandler() + "): " + he));
            } else {
                msgDiag.logErroreGenerico(e, "InvocazioneInRequestHandler");
                logCore.error((Object)("Gestione InRequestEGovHandler non riuscita: " + e));
            }
            if (this.msgContext.isGestioneRisposta()) {
                parametriGenerazioneSPCoopErrore.setBusta(bustaRichiesta);
                parametriGenerazioneSPCoopErrore.setMessaggioErrore("Sistema non disponibile");
                parametriGenerazioneSPCoopErrore.setCodiceErrore("OPENSPCOOP_ORG_536");
                errorAxisMsg = this.generaSPCoopErroreProcessamento(parametriGenerazioneSPCoopErrore, e);
                parametriInvioSPCoopErrore.setAxisMsg(errorAxisMsg);
                parametriInvioSPCoopErrore.setBusta(parametriGenerazioneSPCoopErrore.getBusta());
                this.sendRispostaSPCoopErrore(parametriInvioSPCoopErrore);
            }
            openspcoopstate.releaseResource();
            return;
        }
        if (!functionAsRouter) {
            msgDiag.mediumDebug("Raccolta WSS proprieta...");
            try {
                wssPropertiesRequest = this.getWSSPropertiesRequest(bustaRichiesta, configurazionePdDReader, (StateMessage)openspcoopstate.getStatoRichiesta(), msgDiag, logCore, propertiesReader, ruoloBustaEgovRicevuta, implementazionePdDMittente);
                wssPropertiesResponse = this.getWSSPropertiesResponse(bustaRichiesta, configurazionePdDReader, (StateMessage)openspcoopstate.getStatoRichiesta(), msgDiag, logCore, propertiesReader, ruoloBustaEgovRicevuta, implementazionePdDMittente);
                parametriGenerazioneSPCoopErrore.setWssPropertiesResponse(wssPropertiesResponse);
            }
            catch (Exception e) {
                msgDiag.logPersonalizzato("ricezioneMessaggioSPCoop");
                msgDiag.logErroreGenerico(e, "RaccoltaWSSecurityProperties");
                if (this.msgContext.isTracciamentoAbilitato()) {
                    tracciamento.registraRichiesta(openspcoopstate.getConnectionDB(), bustaRichiesta, Tracciamento.createLocationString(true, this.msgContext.getFromLocation()), correlazioneApplicativa, servizioApplicativoFruitore);
                }
                if (this.msgContext.isGestioneRisposta()) {
                    parametriGenerazioneSPCoopErrore.setBusta(bustaRichiesta);
                    parametriGenerazioneSPCoopErrore.setMessaggioErrore("Sistema non disponibile");
                    parametriGenerazioneSPCoopErrore.setCodiceErrore("OPENSPCOOP_ORG_536");
                    errorAxisMsg = this.generaSPCoopErroreProcessamento(parametriGenerazioneSPCoopErrore, e);
                    parametriInvioSPCoopErrore.setAxisMsg(errorAxisMsg);
                    parametriInvioSPCoopErrore.setBusta(parametriGenerazioneSPCoopErrore.getBusta());
                    this.sendRispostaSPCoopErrore(parametriInvioSPCoopErrore);
                }
                openspcoopstate.releaseResource();
                return;
            }
            if (wssPropertiesRequest != null && wssPropertiesRequest.size() > 0) {
                wssReceiver = new WSSReceiver(wssPropertiesRequest, baseWSS);
            }
            msgDiag.mediumDebug("Validazione semantica della busta eGov di richiesta...");
            if (!validatoreSPCoop.validazioneSemantica(wssReceiver, false, null, proprietaManifestAttachments, validazioneIDEGovCompleta)) {
                msgDiag.logPersonalizzato("ricezioneMessaggioSPCoop");
                msgDiag.addKeyword("@ECCEZIONI@", validatoreSPCoop.getMsgErrore());
                msgDiag.logPersonalizzato("sbustamentoBustaEGov.", "validazioneSintatticaNonRiuscita");
                if (this.msgContext.isTracciamentoAbilitato()) {
                    tracciamento.registraRichiesta(openspcoopstate.getConnectionDB(), bustaRichiesta, Tracciamento.createLocationString(true, this.msgContext.getFromLocation()), correlazioneApplicativa, servizioApplicativoFruitore);
                }
                if (this.msgContext.isGestioneRisposta()) {
                    parametriGenerazioneSPCoopErrore.setBusta(bustaRichiesta);
                    parametriGenerazioneSPCoopErrore.setMessaggioErrore("Sistema non disponibile");
                    parametriGenerazioneSPCoopErrore.setCodiceErrore("OPENSPCOOP_ORG_525");
                    errorAxisMsg = this.generaSPCoopErroreProcessamento(parametriGenerazioneSPCoopErrore, validatoreSPCoop.getEccezioneProcessamentoValidazioneSemantica());
                    parametriInvioSPCoopErrore.setAxisMsg(errorAxisMsg);
                    parametriInvioSPCoopErrore.setBusta(parametriGenerazioneSPCoopErrore.getBusta());
                    this.sendRispostaSPCoopErrore(parametriInvioSPCoopErrore);
                }
                openspcoopstate.releaseResource();
                return;
            }
        }
        erroriValidazione = validatoreSPCoop.getEccezioniValidazione();
        erroriProcessamento = validatoreSPCoop.getEccezioniProcessamento();
        isMessaggioSPCoopErrore = validatoreSPCoop.isSPCoopErrore();
        if (isMessaggioSPCoopErrore) {
            idServizio.setServizio(null);
            idServizio.setTipoServizio(null);
            idServizio.setAzione(null);
        }
        bustaDiServizio = validatoreSPCoop.isBustaDiServizio();
        if (!(functionAsRouter || isMessaggioSPCoopErrore || erroriProcessamento.size() != 0 || erroriValidazione.size() != 0 || bustaDiServizio || pa == null || pa.getCorrelazioneApplicativa() == null)) {
            try {
                soapEnvelopeRequest = requestMessage.getSOAPEnvelope();
                gestoreCorrelazioneApplicativa = new GestoreCorrelazioneApplicativa(openspcoopstate.getStatoRichiesta(), logCore, soggettoFruitore, idServizio, servizioApplicativoFruitore, propertiesReader.getRepositoryIntervalloScadenzaMessaggi());
                gestoreCorrelazioneApplicativa.verificaCorrelazione(pa.getCorrelazioneApplicativa(), null, soapEnvelopeRequest, null, false);
                if (gestoreCorrelazioneApplicativa.getIdCorrelazione() != null) {
                    correlazioneApplicativa = gestoreCorrelazioneApplicativa.getIdCorrelazione();
                }
            }
            catch (Exception e) {
                msgDiag.logErroreGenerico(e, "CorrelazioneApplicativa(" + bustaRichiesta.getID() + ")");
                logCore.error((Object)("Riscontrato errore durante la correlazione applicativa [" + bustaRichiesta.getID() + "]"), (Throwable)e);
                if (this.msgContext.isGestioneRisposta()) {
                    parametriGenerazioneSPCoopErrore.setBusta(bustaRichiesta);
                    parametriGenerazioneSPCoopErrore.setMessaggioErrore("Sistema non disponibile");
                    parametriGenerazioneSPCoopErrore.setCodiceErrore("OPENSPCOOP_ORG_529");
                    errorAxisMsg = this.generaSPCoopErroreProcessamento(parametriGenerazioneSPCoopErrore, e);
                    parametriInvioSPCoopErrore.setAxisMsg(errorAxisMsg);
                    parametriInvioSPCoopErrore.setBusta(parametriGenerazioneSPCoopErrore.getBusta());
                    this.sendRispostaSPCoopErrore(parametriInvioSPCoopErrore);
                }
                openspcoopstate.releaseResource();
                return;
            }
        }
        msgDiag.setIdCorrelazioneApplicativa(correlazioneApplicativa);
        if (this.msgContext.getIntegrazione() != null) {
            this.msgContext.getIntegrazione().setIdCorrelazioneApplicativa(correlazioneApplicativa);
        }
        parametriGenerazioneSPCoopErrore.setMsgDiag(msgDiag);
        parametriInvioSPCoopErrore.setMsgDiag(msgDiag);
        msgDiag.logCorrelazione();
        dettaglioEccezione = null;
        if (isMessaggioSPCoopErrore) {
            if (validatoreSPCoop.isMessaggioSPCoopErroreIntestazione()) {
                msgDiag.addKeyword("@TIPO_ERRORE_SPCOOP@", "Intestazione");
            } else {
                msgDiag.addKeyword("@TIPO_ERRORE_SPCOOP@", "Processamento");
            }
            msgDiag.logPersonalizzato("ricezioneMessaggioSPCoopErrore");
            try {
                dettaglioEccezione = XMLUtils.getDettaglioEccezione((Message)requestMessage);
            }
            catch (Exception e) {
                logCore.error((Object)"Errore durante l'analisi del dettaglio dell'eccezione", (Throwable)e);
            }
        } else {
            msgDiag.logPersonalizzato("ricezioneMessaggioSPCoop");
        }
        profiloGestione = validatoreSPCoop.getProfiloGestione();
        msgDiag.mediumDebug("Profilo di gestione [RicezioneBusteEGov] della busta: " + profiloGestione);
        richiestaApplicativa.setProfiloGestione(profiloGestione);
        parametriGenerazioneSPCoopErrore.setProfiloGestione(profiloGestione);
        if (!functionAsRouter && "eGov1.1-lineeGuida1.1".equals(profiloGestione) && "EGOV_IT_ServizioSincrono".equals(bustaRichiesta.getProfiloDiCollaborazione()) && bustaRichiesta.getRiferimentoMessaggio() != null) {
            ecc = new Eccezione();
            ecc.setContestoCodifica("ErroreIntestazioneMessaggioSPCoop");
            ecc.setCodiceEccezione("EGOV_IT_111");
            ecc.setRilevanza("GRAVE");
            ecc.setPosizione("Messaggio/RiferimentoMessaggio");
            erroriValidazione.add(ecc);
        }
        msgDiag.mediumDebug("Gestione errori...");
        if (erroriProcessamento.size() > 0 || functionAsRouter && erroriValidazione.size() > 0) {
            errore = new StringBuffer();
            for (k = 0; k < erroriProcessamento.size(); ++k) {
                errore.append("Processamento[" + ((Eccezione)erroriProcessamento.get(k)).getCodiceEccezione() + "] " + ((Eccezione)erroriProcessamento.get(k)).getPosizione() + "\n");
            }
            for (k = 0; k < erroriValidazione.size(); ++k) {
                errore.append("Validazione[" + ((Eccezione)erroriValidazione.get(k)).getCodiceEccezione() + "] " + ((Eccezione)erroriValidazione.get(k)).getPosizione() + "\n");
            }
            msgDiag.addKeyword("@ECCEZIONI@", errore.toString());
            msgDiag.addKeyword("@NUMERO_ECCEZIONI@", erroriProcessamento.size() + erroriValidazione.size() + "");
            msgDiag.logPersonalizzato("sbustamentoBustaEGov.", "validazioneBusta.bustaNonCorretta");
            if (this.msgContext.isTracciamentoAbilitato()) {
                tracciamento.registraRichiesta(openspcoopstate.getConnectionDB(), bustaRichiesta, Tracciamento.createLocationString(true, this.msgContext.getFromLocation()), correlazioneApplicativa, servizioApplicativoFruitore);
            }
            if (this.msgContext.isGestioneRisposta()) {
                errorAxisMsg = null;
                parametriGenerazioneSPCoopErrore.setBusta(bustaRichiesta);
                if (erroriProcessamento.size() > 0) {
                    for (j = 0; j < erroriValidazione.size(); ++j) {
                        erroriProcessamento.add(erroriValidazione.get(j));
                    }
                    parametriGenerazioneSPCoopErrore.setError(erroriProcessamento);
                    errorAxisMsg = this.generaSPCoopErroreProcessamento(parametriGenerazioneSPCoopErrore, null);
                } else {
                    parametriGenerazioneSPCoopErrore.setError(erroriValidazione);
                    errorAxisMsg = this.generaSPCoopErroreValidazione(parametriGenerazioneSPCoopErrore);
                }
                parametriInvioSPCoopErrore.setAxisMsg(errorAxisMsg);
                parametriInvioSPCoopErrore.setBusta(parametriGenerazioneSPCoopErrore.getBusta());
                this.sendRispostaSPCoopErrore(parametriInvioSPCoopErrore);
            }
            openspcoopstate.releaseResource();
            return;
        }
        msgDiag.mediumDebug("Sbustamento busta eGov di richiesta...");
        gestioneManifest = false;
        headerSPCoopRichiesta = null;
        try {
            if (!functionAsRouter) {
                if (richiestaApplicativa.getIdPortaApplicativa() != null && richiestaApplicativa.getIdPortaApplicativa().getIDServizio() != null && richiestaApplicativa.getIdPortaApplicativa().getIDServizio().getTipoServizio() != null && richiestaApplicativa.getIdPortaApplicativa().getIDServizio().getServizio() != null) {
                    gestioneManifest = configurazionePdDReader.isGestioneManifestAttachments(pa);
                }
                sbustamentoManifest = gestioneManifest;
                posizioneAssente = "SOAPBody/Descrizione/DescrizioneMessaggio/Riferimento/role (@RICHIESTA@/@RISPOSTA@) non esistente";
                posizioneAssente = posizioneAssente.replace("@RICHIESTA@", proprietaManifestAttachments.getRoleRichiesta());
                posizioneAssente = posizioneAssente.replace("@RISPOSTA@", proprietaManifestAttachments.getRoleRisposta());
                posizioneDuplicato = "SOAPBody/Descrizione/DescrizioneMessaggio/Riferimento/role (@RICHIESTA@/@RISPOSTA@) non univoco";
                posizioneDuplicato = posizioneDuplicato.replace("@RICHIESTA@", proprietaManifestAttachments.getRoleRichiesta());
                posizioneDuplicato = posizioneDuplicato.replace("@RISPOSTA@", proprietaManifestAttachments.getRoleRisposta());
                for (k = 0; k < erroriValidazione.size(); ++k) {
                    er = (Eccezione)erroriValidazione.get(k);
                    if ((!posizioneAssente.equals(er.getPosizione()) || !"EGOV_IT_003".equals(er.getCodiceEccezione())) && (!posizioneDuplicato.equals(er.getPosizione()) || !"EGOV_IT_003".equals(er.getCodiceEccezione()))) continue;
                    sbustamentoManifest = false;
                    break;
                }
                sbustatore = new org.openspcoop.egov.Sbustamento();
                headerSPCoopRichiesta = sbustatore.sbustamentoEGov(requestMessage, sbustamentoManifest, proprietaManifestAttachments);
            } else {
                headerSPCoopRichiesta = validatoreSPCoop.getHeaderEGov();
            }
        }
        catch (Exception e) {
            if (!functionAsRouter) {
                msgDiag.logErroreGenerico(e, "sbustatore.sbustamentoEGov(" + idEGovRequest + ")");
            } else {
                msgDiag.logErroreGenerico(e, "validator.getHeaderEGov(" + idEGovRequest + ")");
            }
            if (this.msgContext.isTracciamentoAbilitato()) {
                tracciamento.registraRichiesta(openspcoopstate.getConnectionDB(), bustaRichiesta, Tracciamento.createLocationString(true, this.msgContext.getFromLocation()), correlazioneApplicativa, servizioApplicativoFruitore);
            }
            if (this.msgContext.isGestioneRisposta()) {
                parametriGenerazioneSPCoopErrore.setBusta(bustaRichiesta);
                parametriGenerazioneSPCoopErrore.setMessaggioErrore("Sistema non disponibile");
                parametriGenerazioneSPCoopErrore.setCodiceErrore("OPENSPCOOP_ORG_527");
                errorAxisMsg = this.generaSPCoopErroreProcessamento(parametriGenerazioneSPCoopErrore, e);
                parametriInvioSPCoopErrore.setAxisMsg(errorAxisMsg);
                parametriInvioSPCoopErrore.setBusta(parametriGenerazioneSPCoopErrore.getBusta());
                this.sendRispostaSPCoopErrore(parametriInvioSPCoopErrore);
            }
            openspcoopstate.releaseResource();
            return;
        }
        if (this.msgContext.isTracciamentoAbilitato()) {
            msgDiag.mediumDebug("Tracciamento busta eGov di richiesta...");
            tracciamento.registraRichiesta(openspcoopstate.getConnectionDB(), headerSPCoopRichiesta, bustaRichiesta, Tracciamento.createLocationString(true, this.msgContext.getFromLocation()), correlazioneApplicativa, servizioApplicativoFruitore);
        }
        msgDiag.mediumDebug("Controllo mittente/destinatario/servizio (se sconosciuto, risposta immediata sulla connessione)...");
        for (k = 0; k < erroriValidazione.size(); ++k) {
            er = (Eccezione)erroriValidazione.get(k);
            if (!"EGOV_IT_101".equals(er.getCodiceEccezione()) && !"EGOV_IT_102".equals(er.getCodiceEccezione()) && !"EGOV_IT_105".equals(er.getCodiceEccezione()) && !"EGOV_IT_107".equals(er.getCodiceEccezione()) && !"EGOV_IT_110".equals(er.getCodiceEccezione()) || !functionAsRouter && "eGov1.1-lineeGuida1.1".equals(profiloGestione) && "INFO".equals(er.getRilevanza())) continue;
            eccBuffer = new StringBuffer();
            for (j = 0; j < erroriValidazione.size(); ++j) {
                if (j > 0) {
                    eccBuffer.append("\n");
                }
                eccBuffer.append(((Eccezione)erroriValidazione.get(j)).toString());
            }
            msgDiag.addKeyword("@ECCEZIONI@", eccBuffer.toString());
            msgDiag.addKeyword("@NUMERO_ECCEZIONI@", erroriValidazione.size() + "");
            msgDiag.logPersonalizzato("sbustamentoBustaEGov.", "validazioneBusta.bustaNonCorretta");
            if (this.msgContext.isGestioneRisposta()) {
                parametriGenerazioneSPCoopErrore.setBusta(bustaRichiesta);
                errs = new Vector<Eccezione>();
                errs.add(er);
                parametriGenerazioneSPCoopErrore.setError(errs);
                errorAxisMsg = this.generaSPCoopErroreValidazione(parametriGenerazioneSPCoopErrore);
                parametriInvioSPCoopErrore.setUtilizzoIndirizzoTelematico(false);
                parametriInvioSPCoopErrore.setNewConnectionForResponse(false);
                parametriInvioSPCoopErrore.setAxisMsg(errorAxisMsg);
                parametriInvioSPCoopErrore.setBusta(parametriGenerazioneSPCoopErrore.getBusta());
                this.sendRispostaSPCoopErrore(parametriInvioSPCoopErrore);
            }
            openspcoopstate.releaseResource();
            return;
        }
        eccezioniValidazioni = false;
        for (k = 0; k < erroriValidazione.size(); ++k) {
            er = (Eccezione)erroriValidazione.get(k);
            if (!functionAsRouter && "eGov1.1-lineeGuida1.1".equals(profiloGestione) && "INFO".equals(er.getRilevanza())) continue;
            eccezioniValidazioni = true;
            break;
        }
        if (GestoreAutorizzazioneSPCoop.isAttivoAutorizzazioneSPCoop() && !isMessaggioSPCoopErrore && !bustaDiServizio && !eccezioniValidazioni) {
            try {
                msgDiag.mediumDebug("Autorizzazione SPCoop di tipo [" + propertiesReader.getTipoAutorizzazioneSPCoop() + "]...");
                identitaPdDMittente = null;
                if (credenziali != null && credenziali.getSubject() != null) {
                    identitaPdDMittente = credenziali.getSubject();
                }
                subjectWSS = null;
                if (wssReceiver != null) {
                    subjectWSS = wssReceiver.getSubject();
                }
                idServizioPerAutorizzazione = this.getIdServizioPerAutorizzazione(idServizio, soggettoFruitore, functionAsRouter, bustaRichiesta, ruoloBustaEgovRicevuta);
                soggettoMittentePerAutorizzazione = this.getIDSoggettoMittentePerAutorizzazione(idServizio, soggettoFruitore, functionAsRouter, bustaRichiesta, ruoloBustaEgovRicevuta);
                tipoMessaggio = "messaggio SPCoop";
                if (ruoloBustaEgovRicevuta != null && (RuoloBustaEGov.RICEVUTA_RICHIESTA.equals(ruoloBustaEgovRicevuta.toString()) || RuoloBustaEGov.RICEVUTA_RISPOSTA.equals(ruoloBustaEgovRicevuta.toString()))) {
                    tipoMessaggio = "ricevuta asincrona";
                }
                msgDiag.addKeyword("@TIPO_AUTORIZZAZIONE_SPCOOP@", propertiesReader.getTipoAutorizzazioneSPCoop());
                msgDiag.addKeyword("@TIPO_MESSAGGIO_SPCOOP@", tipoMessaggio);
                msgDiag.addKeyword("@MITTENTE_E_SERVIZIO_DA_AUTORIZZARE@", "FR[" + soggettoMittentePerAutorizzazione.toString() + "]->ER[" + idServizioPerAutorizzazione.toString() + "]");
                if (identitaPdDMittente != null) {
                    msgDiag.addKeyword("@IDENTITA_PDD_MITTENTE_MSG@", " inviato da una PdD mittente [" + identitaPdDMittente + "]");
                } else {
                    msgDiag.addKeyword("@IDENTITA_PDD_MITTENTE_MSG@", "");
                }
                if (servizioApplicativoFruitore != null) {
                    msgDiag.addKeyword("@SERVIZIO_APPLICATIVO_FRUITORE_MSG@", " identitaServizioApplicativoFruitore [" + servizioApplicativoFruitore + "]");
                } else {
                    msgDiag.addKeyword("@SERVIZIO_APPLICATIVO_FRUITORE_MSG@", "");
                }
                if (subjectWSS != null) {
                    msgDiag.addKeyword("@SUBJECT_WSSECURITY_MSG@", " subjectWSSecurity [" + subjectWSS + "]");
                } else {
                    msgDiag.addKeyword("@SUBJECT_WSSECURITY_MSG@", "");
                }
                msgDiag.logPersonalizzato("autorizzazioneSPCoopInCorso");
                esito = GestoreAutorizzazioneSPCoop.verificaAutorizzazioneSPCoop(identitaPdDMittente, servizioApplicativoFruitore, subjectWSS, soggettoMittentePerAutorizzazione, idServizioPerAutorizzazione);
                if (!esito.isServizioAutorizzato()) {
                    msgDiag.addKeyword("@ERRORE_PROCESSAMENTO@", esito.getMsgErrore());
                    msgDiag.addKeyword("@POSIZIONE_ERRORE@", esito.getCodiceErrore());
                    msgDiag.logPersonalizzato("autorizzazioneSPCoopFallita");
                    if (this.msgContext.isGestioneRisposta()) {
                        errorAxisMsg = null;
                        parametriGenerazioneSPCoopErrore.setBusta(bustaRichiesta);
                        parametriGenerazioneSPCoopErrore.setMessaggioErrore(esito.getMsgErrore());
                        parametriGenerazioneSPCoopErrore.setCodiceErrore(esito.getCodiceErrore());
                        errorAxisMsg = "EGOV_IT_201".equals(esito.getCodiceErrore()) != false ? this.generaSPCoopErroreValidazione(parametriGenerazioneSPCoopErrore) : this.generaSPCoopErroreProcessamento(parametriGenerazioneSPCoopErrore, esito.getEccezioneProcessamento());
                        parametriInvioSPCoopErrore.setAxisMsg(errorAxisMsg);
                        parametriInvioSPCoopErrore.setBusta(parametriGenerazioneSPCoopErrore.getBusta());
                        this.sendRispostaSPCoopErrore(parametriInvioSPCoopErrore);
                    }
                    openspcoopstate.releaseResource();
                    return;
                }
                if (esito.getDetails() == null) {
                    msgDiag.addKeyword("@DETAILS@", "");
                } else {
                    msgDiag.addKeyword("@DETAILS@", " (" + esito.getDetails() + ")");
                }
                msgDiag.logPersonalizzato("autorizzazioneSPCoopEffettuata");
            }
            catch (Exception e) {
                msgDiag.logErroreGenerico(e, "AutorizzazioneMessaggioSPCoop(" + bustaRichiesta.getID() + ")");
                logCore.error((Object)("Riscontrato errore durante il processo di Autorizzazione per il messaggio SPCoop con identificativo [" + bustaRichiesta.getID() + "]"), (Throwable)e);
                if (this.msgContext.isGestioneRisposta()) {
                    parametriGenerazioneSPCoopErrore.setBusta(bustaRichiesta);
                    parametriGenerazioneSPCoopErrore.setMessaggioErrore("Sistema non disponibile");
                    parametriGenerazioneSPCoopErrore.setCodiceErrore("OPENSPCOOP_ORG_504");
                    errorAxisMsg = this.generaSPCoopErroreProcessamento(parametriGenerazioneSPCoopErrore, e);
                    parametriInvioSPCoopErrore.setAxisMsg(errorAxisMsg);
                    parametriInvioSPCoopErrore.setBusta(parametriGenerazioneSPCoopErrore.getBusta());
                    this.sendRispostaSPCoopErrore(parametriInvioSPCoopErrore);
                }
                openspcoopstate.releaseResource();
                return;
            }
        }
        validazioneContenutoApplicativoApplicativo = null;
        tipoAutorizzazionePerContenuto = null;
        if (!(functionAsRouter || isMessaggioSPCoopErrore || erroriProcessamento.size() != 0 || erroriValidazione.size() != 0 || bustaDiServizio || pa == null)) {
            block415: {
                msgDiag.mediumDebug("Controllo abilitazione validazione XSD della richiesta...");
                isRicevutaAsincrona_modalitaAsincrona = false;
                try {
                    if (("EGOV_IT_ServizioAsincronoSimmetrico".equals(bustaRichiesta.getProfiloDiCollaborazione()) || "EGOV_IT_ServizioAsincronoAsimmetrico".equals(bustaRichiesta.getProfiloDiCollaborazione())) && bustaRichiesta.getRiferimentoMessaggio() != null) {
                        msgDiag.mediumDebug("Controllo abilitazione validazione XSD della richiesta (check asincrono)...");
                        if ("EGOV_IT_ServizioAsincronoSimmetrico".equals(bustaRichiesta.getProfiloDiCollaborazione())) {
                            if (bustaRichiesta.getRiferimentoMessaggio() == null) {
                                validazioneContenutoApplicativoApplicativo = configurazionePdDReader.getTipoValidazioneContenutoApplicativo(pa, implementazionePdDMittente);
                                tipoAutorizzazionePerContenuto = configurazionePdDReader.getAutorizzazioneContenuto(pa);
                            } else if (RuoloBustaEGov.RISPOSTA.equals(ruoloBustaEgovRicevuta.toString())) {
                                validazioneContenutoApplicativoApplicativo = configurazionePdDReader.getTipoValidazioneContenutoApplicativo(pd, implementazionePdDMittente);
                                tipoAutorizzazionePerContenuto = configurazionePdDReader.getAutorizzazioneContenuto(pd);
                            } else if (RuoloBustaEGov.RICEVUTA_RICHIESTA.equals(ruoloBustaEgovRicevuta.toString()) || RuoloBustaEGov.RICEVUTA_RISPOSTA.equals(ruoloBustaEgovRicevuta.toString())) {
                                if (configurazionePdDReader.ricevutaAsincronaSimmetricaAbilitata(pd)) {
                                    isRicevutaAsincrona_modalitaAsincrona = true;
                                } else {
                                    validazioneContenutoApplicativoApplicativo = configurazionePdDReader.getTipoValidazioneContenutoApplicativo(pd, implementazionePdDMittente);
                                    tipoAutorizzazionePerContenuto = configurazionePdDReader.getAutorizzazioneContenuto(pd);
                                }
                            }
                        } else if ("EGOV_IT_ServizioAsincronoAsimmetrico".equals(bustaRichiesta.getProfiloDiCollaborazione())) {
                            if (bustaRichiesta.getRiferimentoMessaggio() == null) {
                                validazioneContenutoApplicativoApplicativo = configurazionePdDReader.getTipoValidazioneContenutoApplicativo(pa, implementazionePdDMittente);
                                tipoAutorizzazionePerContenuto = configurazionePdDReader.getAutorizzazioneContenuto(pa);
                            } else if (RuoloBustaEGov.RISPOSTA.equals(ruoloBustaEgovRicevuta.toString())) {
                                validazioneContenutoApplicativoApplicativo = configurazionePdDReader.getTipoValidazioneContenutoApplicativo(pa, implementazionePdDMittente);
                                tipoAutorizzazionePerContenuto = configurazionePdDReader.getAutorizzazioneContenuto(pa);
                            } else if (RuoloBustaEGov.RICEVUTA_RICHIESTA.equals(ruoloBustaEgovRicevuta.toString()) || RuoloBustaEGov.RICEVUTA_RISPOSTA.equals(ruoloBustaEgovRicevuta.toString())) {
                                if (configurazionePdDReader.ricevutaAsincronaAsimmetricaAbilitata(pd)) {
                                    isRicevutaAsincrona_modalitaAsincrona = true;
                                } else {
                                    validazioneContenutoApplicativoApplicativo = configurazionePdDReader.getTipoValidazioneContenutoApplicativo(pd, implementazionePdDMittente);
                                    tipoAutorizzazionePerContenuto = configurazionePdDReader.getAutorizzazioneContenuto(pd);
                                }
                            }
                        }
                        ((StateMessage)openspcoopstate.getStatoRichiesta()).closePreparedStatement();
                    } else {
                        msgDiag.mediumDebug("Controllo abilitazione validazione dei contenuti applicativi della richiesta...");
                        validazioneContenutoApplicativoApplicativo = configurazionePdDReader.getTipoValidazioneContenutoApplicativo(pa, implementazionePdDMittente);
                        tipoAutorizzazionePerContenuto = configurazionePdDReader.getAutorizzazioneContenuto(pa);
                    }
                }
                catch (Exception e) {
                    msgDiag.logErroreGenerico(e, "getTipoValidazione/Autorizzazione ContenutoApplicativo");
                    if (this.msgContext.isGestioneRisposta()) {
                        parametriGenerazioneSPCoopErrore.setBusta(bustaRichiesta);
                        parametriGenerazioneSPCoopErrore.setMessaggioErrore("Sistema non disponibile");
                        parametriGenerazioneSPCoopErrore.setCodiceErrore("OPENSPCOOP_ORG_536");
                        errorAxisMsg = this.generaSPCoopErroreProcessamento(parametriGenerazioneSPCoopErrore, e);
                        parametriInvioSPCoopErrore.setAxisMsg(errorAxisMsg);
                        parametriInvioSPCoopErrore.setBusta(parametriGenerazioneSPCoopErrore.getBusta());
                        this.sendRispostaSPCoopErrore(parametriInvioSPCoopErrore);
                    }
                    openspcoopstate.releaseResource();
                    return;
                }
                if (!isRicevutaAsincrona_modalitaAsincrona) {
                    binXSD = null;
                    try {
                        block414: {
                            if (!"abilitato".equals(validazioneContenutoApplicativoApplicativo.getStato()) && !"warningOnly".equals(validazioneContenutoApplicativoApplicativo.getStato())) break block414;
                            msgDiag.mediumDebug("Validatore contenuti applicativi della richiesta...");
                            readWSDL = "wsdl".equals(validazioneContenutoApplicativoApplicativo.getTipo());
                            validatoreMessaggiApplicativi = new ValidatoreMessaggiApplicativi(registroServiziReader, idServizio, requestMessage.getSOAPBody(), readWSDL);
                            checkStyle = false;
                            if (idServizio.getAzione() != null && (readWSDL || "openspcoop".equals(validazioneContenutoApplicativoApplicativo.getTipo()))) {
                                checkStyle = true;
                            }
                            msgDiag.mediumDebug("Validazione xsd della richiesta (validazione)...");
                            validatoreMessaggiApplicativi.validateWithWsdlDefinitorio(true, checkStyle);
                            if (idServizio.getAzione() == null || !"wsdl".equals(validazioneContenutoApplicativoApplicativo.getTipo()) && !"openspcoop".equals(validazioneContenutoApplicativoApplicativo.getTipo())) break block414;
                            msgDiag.mediumDebug("Validazione wsdl della richiesta ...");
                            validatoreMessaggiApplicativi.validateWithWsdlLogicoImplementativo(true, this.msgContext.getSoapAction());
                        }
                        var73_165 = null;
                        ** if (binXSD == null) goto lbl-1000
                    }
                    catch (Throwable var72_175) {
                        var73_168 = null;
                        if (binXSD != null) {
                            try {
                                binXSD.close();
                            }
                            catch (Exception e) {
                                // empty catch block
                            }
                        }
                        throw var72_175;
                    }
lbl-1000:
                    // 1 sources

                    {
                        try {
                            binXSD.close();
                        }
                        catch (Exception e) {}
                    }
lbl-1000:
                    // 2 sources

                    {
                        break block415;
                        catch (ValidatoreMessaggiApplicativiException ex) {
                            msgDiag.addKeyword("@ERRORE_PROCESSAMENTO@", ex.getMessage());
                            msgDiag.logPersonalizzato("validazioneContenutiApplicativiNonRiuscita");
                            if (!"warningOnly".equals(validazioneContenutoApplicativoApplicativo.getStato())) {
                                if (this.msgContext.isGestioneRisposta()) {
                                    parametriGenerazioneSPCoopErrore.setBusta(bustaRichiesta);
                                    parametriGenerazioneSPCoopErrore.setMessaggioErrore(ex.getMsgErrore());
                                    parametriGenerazioneSPCoopErrore.setCodiceErrore(ex.getCodiceErrore());
                                    errorAxisMsg = this.generaSPCoopErroreProcessamento(parametriGenerazioneSPCoopErrore, ex);
                                    parametriInvioSPCoopErrore.setAxisMsg(errorAxisMsg);
                                    parametriInvioSPCoopErrore.setBusta(parametriGenerazioneSPCoopErrore.getBusta());
                                    this.sendRispostaSPCoopErrore(parametriInvioSPCoopErrore);
                                }
                                openspcoopstate.releaseResource();
                                var73_166 = null;
                                if (binXSD != null) {
                                    try {
                                        binXSD.close();
                                    }
                                    catch (Exception e) {
                                        // empty catch block
                                    }
                                }
                                return;
                            }
                            var73_165 = null;
                            if (binXSD != null) {
                                try {
                                    binXSD.close();
                                }
                                catch (Exception e) {}
                            }
                            break block415;
                        }
                        catch (Exception ex) {
                            msgDiag.addKeyword("@ERRORE_PROCESSAMENTO@", ex.getMessage());
                            msgDiag.logPersonalizzato("validazioneContenutiApplicativiNonRiuscita");
                            logCore.error((Object)"Riscontrato errore durante la validazione dei contenuti applicativi (richiesta applicativa)", (Throwable)ex);
                            if (!"warningOnly".equals(validazioneContenutoApplicativoApplicativo.getStato())) {
                                if (this.msgContext.isGestioneRisposta()) {
                                    parametriGenerazioneSPCoopErrore.setBusta(bustaRichiesta);
                                    parametriGenerazioneSPCoopErrore.setMessaggioErrore("Sistema non disponibile");
                                    parametriGenerazioneSPCoopErrore.setCodiceErrore("OPENSPCOOP_ORG_531");
                                    errorAxisMsg = this.generaSPCoopErroreProcessamento(parametriGenerazioneSPCoopErrore, ex);
                                    parametriInvioSPCoopErrore.setAxisMsg(errorAxisMsg);
                                    parametriInvioSPCoopErrore.setBusta(parametriGenerazioneSPCoopErrore.getBusta());
                                    this.sendRispostaSPCoopErrore(parametriInvioSPCoopErrore);
                                }
                                openspcoopstate.releaseResource();
                                var73_167 = null;
                                if (binXSD != null) {
                                    try {
                                        binXSD.close();
                                    }
                                    catch (Exception e) {
                                        // empty catch block
                                    }
                                }
                                return;
                            }
                            var73_165 = null;
                            if (binXSD != null) {
                                try {
                                    binXSD.close();
                                }
                                catch (Exception e) {}
                            }
                        }
                    }
                }
            }
            if (!"none".equalsIgnoreCase(tipoAutorizzazionePerContenuto)) {
                try {
                    if (!RicezioneBusteEGov.gestoriAutorizzazioneContenutoSPCoop.containsKey(tipoAutorizzazionePerContenuto)) {
                        RicezioneBusteEGov.aggiornaListaGestoreAutorizzazioneContenutoSPCoop(tipoAutorizzazionePerContenuto, className, propertiesReader, logCore);
                    }
                    if ((auth = RicezioneBusteEGov.gestoriAutorizzazioneContenutoSPCoop.get(tipoAutorizzazionePerContenuto)) != null) {
                        identitaPdDMittente = null;
                        if (credenziali != null && credenziali.getSubject() != null) {
                            identitaPdDMittente = credenziali.getSubject();
                        }
                        subjectWSS = null;
                        if (wssReceiver != null) {
                            subjectWSS = wssReceiver.getSubject();
                        }
                        idServizioPerAutorizzazione = this.getIdServizioPerAutorizzazione(idServizio, soggettoFruitore, functionAsRouter, bustaRichiesta, ruoloBustaEgovRicevuta);
                        soggettoMittentePerAutorizzazione = this.getIDSoggettoMittentePerAutorizzazione(idServizio, soggettoFruitore, functionAsRouter, bustaRichiesta, ruoloBustaEgovRicevuta);
                        tipoMessaggio = "messaggio SPCoop";
                        if (RuoloBustaEGov.RICEVUTA_RICHIESTA.equals(ruoloBustaEgovRicevuta.toString()) || RuoloBustaEGov.RICEVUTA_RISPOSTA.equals(ruoloBustaEgovRicevuta.toString())) {
                            tipoMessaggio = "ricevuta asincrona";
                        }
                        msgDiag.addKeyword("@TIPO_AUTORIZZAZIONE_SPCOOP@", "AutorizzazioneContenuto(" + tipoAutorizzazionePerContenuto + ")");
                        msgDiag.addKeyword("@TIPO_MESSAGGIO_SPCOOP@", tipoMessaggio);
                        msgDiag.addKeyword("@MITTENTE_E_SERVIZIO_DA_AUTORIZZARE@", "FR[" + soggettoMittentePerAutorizzazione.toString() + "]->ER[" + idServizioPerAutorizzazione.toString() + "]");
                        if (identitaPdDMittente != null) {
                            msgDiag.addKeyword("@IDENTITA_PDD_MITTENTE_MSG@", " inviato da una PdD mittente [" + identitaPdDMittente + "]");
                        } else {
                            msgDiag.addKeyword("@IDENTITA_PDD_MITTENTE_MSG@", "");
                        }
                        if (servizioApplicativoFruitore != null) {
                            msgDiag.addKeyword("@SERVIZIO_APPLICATIVO_FRUITORE_MSG@", " identitaServizioApplicativoFruitore [" + servizioApplicativoFruitore + "]");
                        } else {
                            msgDiag.addKeyword("@SERVIZIO_APPLICATIVO_FRUITORE_MSG@", "");
                        }
                        if (subjectWSS != null) {
                            msgDiag.addKeyword("@SUBJECT_WSSECURITY_MSG@", " subjectWSSecurity [" + subjectWSS + "]");
                        } else {
                            msgDiag.addKeyword("@SUBJECT_WSSECURITY_MSG@", "");
                        }
                        msgDiag.logPersonalizzato("autorizzazioneSPCoopInCorso");
                        esito = auth.process(identitaPdDMittente, servizioApplicativoFruitore, subjectWSS, soggettoMittentePerAutorizzazione, idServizioPerAutorizzazione, ruoloBustaEgovRicevuta, requestMessage);
                        if (!esito.isServizioAutorizzato()) {
                            msgDiag.addKeyword("@ERRORE_PROCESSAMENTO@", esito.getMsgErrore());
                            msgDiag.addKeyword("@POSIZIONE_ERRORE@", esito.getCodiceErrore());
                            msgDiag.logPersonalizzato("autorizzazioneSPCoopFallita");
                            if (this.msgContext.isGestioneRisposta()) {
                                errorAxisMsg = null;
                                parametriGenerazioneSPCoopErrore.setBusta(bustaRichiesta);
                                parametriGenerazioneSPCoopErrore.setMessaggioErrore(esito.getMsgErrore());
                                parametriGenerazioneSPCoopErrore.setCodiceErrore(esito.getCodiceErrore());
                                errorAxisMsg = "EGOV_IT_201".equals(esito.getCodiceErrore()) != false ? this.generaSPCoopErroreValidazione(parametriGenerazioneSPCoopErrore) : this.generaSPCoopErroreProcessamento(parametriGenerazioneSPCoopErrore, esito.getEccezioneProcessamento());
                                parametriInvioSPCoopErrore.setAxisMsg(errorAxisMsg);
                                parametriInvioSPCoopErrore.setBusta(parametriGenerazioneSPCoopErrore.getBusta());
                                this.sendRispostaSPCoopErrore(parametriInvioSPCoopErrore);
                            }
                            openspcoopstate.releaseResource();
                            return;
                        }
                        if (esito.getDetails() == null) {
                            msgDiag.addKeyword("@DETAILS@", "");
                        } else {
                            msgDiag.addKeyword("@DETAILS@", " (" + esito.getDetails() + ")");
                        }
                    } else {
                        throw new Exception("gestore [" + tipoAutorizzazionePerContenuto + "] non inizializzato");
                    }
                    msgDiag.logPersonalizzato("autorizzazioneSPCoopEffettuata");
                }
                catch (Exception ex) {
                    msgDiag.logErroreGenerico(ex, "AutorizzazioneContenuto MessaggioSPCoop(" + bustaRichiesta.getID() + ")");
                    logCore.error((Object)("Riscontrato errore durante il processo di Autorizzazione del Contenuto per il messaggio SPCoop con identificativo [" + bustaRichiesta.getID() + "]"), (Throwable)ex);
                    if (this.msgContext.isGestioneRisposta()) {
                        parametriGenerazioneSPCoopErrore.setBusta(bustaRichiesta);
                        parametriGenerazioneSPCoopErrore.setMessaggioErrore("Sistema non disponibile");
                        parametriGenerazioneSPCoopErrore.setCodiceErrore("OPENSPCOOP_ORG_542");
                        errorAxisMsg = this.generaSPCoopErroreProcessamento(parametriGenerazioneSPCoopErrore, ex);
                        parametriInvioSPCoopErrore.setAxisMsg(errorAxisMsg);
                        parametriInvioSPCoopErrore.setBusta(parametriGenerazioneSPCoopErrore.getBusta());
                        this.sendRispostaSPCoopErrore(parametriInvioSPCoopErrore);
                    }
                    openspcoopstate.releaseResource();
                    return;
                }
            }
        }
        try {
            if (oneWayStateless || sincronoStateless || asincronoStateless || oneWayVersione11 || routingStateless) {
                openspcoopstate = OpenSPCoopState.toStateless((OpenSPCoopStateful)openspcoopstate, true);
                parametriGenerazioneSPCoopErrore.setOpenspcoop(openspcoopstate);
                parametriInvioSPCoopErrore.setOpenspcoop(openspcoopstate);
            }
        }
        catch (Exception e) {
            msgDiag.logErroreGenerico(e, "OpenSPCoopState.toStateless");
            logCore.error((Object)("Creazione stato STATEFUL/STATELESS non riuscita: " + e));
            if (this.msgContext.isGestioneRisposta()) {
                parametriGenerazioneSPCoopErrore.setBusta(bustaRichiesta);
                parametriGenerazioneSPCoopErrore.setMessaggioErrore("Sistema non disponibile");
                parametriGenerazioneSPCoopErrore.setCodiceErrore("OPENSPCOOP_ORG_536");
                errorAxisMsg = this.generaSPCoopErroreProcessamento(parametriGenerazioneSPCoopErrore, e);
                parametriInvioSPCoopErrore.setAxisMsg(errorAxisMsg);
                parametriInvioSPCoopErrore.setBusta(parametriGenerazioneSPCoopErrore.getBusta());
                this.sendRispostaSPCoopErrore(parametriInvioSPCoopErrore);
            }
            openspcoopstate.releaseResource();
            return;
        }
        tipoMsg = "INBOX";
        if (functionAsRouter) {
            tipoMsg = "OUTBOX";
        }
        msgRequest = new GestoreMessaggi(openspcoopstate, true, idEGovRequest, tipoMsg, msgDiag);
        msgRequest.setOneWayVersione11(oneWayVersione11);
        msgRequest.setRoutingStateless(routingStateless);
        repositoryEGov = new RepositoryEGov(openspcoopstate.getStatoRichiesta(), true);
        msgDiag.mediumDebug("Controllo presenza del messaggio gia' in gestione...");
        if (!functionAsRouter || !routingStateless) {
            try {
                if (msgRequest.existsMessage_noCache()) {
                    proprietarioMessaggio = msgRequest.getProprietario(this.msgContext.getIdModulo());
                    if ("GestoreMessaggi".equals(proprietarioMessaggio)) {
                        msgDiag.logPersonalizzato("messaggioInGestione.marcatoDaEliminare");
                        msgRequest.deleteMessage();
                    } else {
                        v1 = rispostaModalitaSincrona = "EGOV_IT_ServizioSincrono".equals(bustaRichiesta.getProfiloDiCollaborazione()) != false || "EGOV_IT_ServizioAsincronoSimmetrico".equals(bustaRichiesta.getProfiloDiCollaborazione()) != false && configurazionePdDReader.ricevutaAsincronaSimmetricaAbilitata(pa) != false || "EGOV_IT_ServizioAsincronoAsimmetrico".equals(bustaRichiesta.getProfiloDiCollaborazione()) != false && configurazionePdDReader.ricevutaAsincronaAsimmetricaAbilitata(pa) != false;
                        if (rispostaModalitaSincrona) {
                            msgDiag.addKeyword("@PROPRIETARIO_MESSAGGIO@", proprietarioMessaggio);
                            msgDiag.logPersonalizzato("messaggioInGestione.gestioneSincrona");
                            if (this.msgContext.isGestioneRisposta()) {
                                parametriGenerazioneSPCoopErrore.setBusta(bustaRichiesta);
                                parametriGenerazioneSPCoopErrore.setMessaggioErrore("La richiesta assegnata alla busta SPCoop con ID=XXX \u00e8 gi\u00e0 stata ricevuta e risulta ancora in processamento".replace("XXX", idEGovRequest));
                                parametriGenerazioneSPCoopErrore.setCodiceErrore("OPENSPCOOP_ORG_537");
                                errorAxisMsg = this.generaSPCoopErroreProcessamento(parametriGenerazioneSPCoopErrore, null);
                                parametriInvioSPCoopErrore.setAxisMsg(errorAxisMsg);
                                parametriInvioSPCoopErrore.setBusta(parametriGenerazioneSPCoopErrore.getBusta());
                                this.sendRispostaSPCoopErrore(parametriInvioSPCoopErrore);
                            }
                            openspcoopstate.releaseResource();
                            return;
                        }
                        msgDiag.addKeyword("@PROPRIETARIO_MESSAGGIO@", proprietarioMessaggio);
                        msgDiag.logPersonalizzato("messaggioInGestione.gestioneAsincrona");
                        scadenzaWhile = DateManager.getTimeMillis() + propertiesReader.getMsgGiaInProcessamento_AttesaAttiva();
                        isErrore_MsgGiaRicevuto = true;
                        msgAttesaFineProcessamento = false;
                        while (DateManager.getTimeMillis() < scadenzaWhile) {
                            proprietarioMessaggio = msgRequest.getProprietario(this.msgContext.getIdModulo());
                            if ("EGOV_IT_ALPIUUNAVOLTA".equals(bustaRichiesta.getInoltro()) || this.msgContext.isForzaFiltroDuplicati_msgGiaInProcessamento()) {
                                if ("ConsegnaContenutiApplicativi".equals(proprietarioMessaggio) || "GestoreMessaggi".equals(proprietarioMessaggio) || !msgRequest.existsMessage_noCache()) {
                                    if (this.msgContext.isGestioneRisposta()) {
                                        this.msgContext.setMessageResponse(this.generaRisposta_msgGiaRicevuto(this.msgContext.isForzaFiltroDuplicati_msgGiaInProcessamento() == false, bustaRichiesta, msgDiag, openspcoopstate, logCore, configurazionePdDReader, propertiesReader, profiloGestione, ruoloBustaEgovRicevuta, implementazionePdDMittente));
                                    }
                                    openspcoopstate.releaseResource();
                                    return;
                                }
                                if (!msgAttesaFineProcessamento) {
                                    msgDiag.addKeyword("@TIMEOUT@", "" + propertiesReader.getMsgGiaInProcessamento_AttesaAttiva() / 1000L);
                                    msgDiag.logPersonalizzato("messaggioInGestione.attesaFineProcessamento.filtroDuplicatiAbilitato");
                                    msgAttesaFineProcessamento = true;
                                }
                            } else {
                                if (!msgAttesaFineProcessamento) {
                                    msgDiag.addKeyword("@TIMEOUT@", "" + propertiesReader.getMsgGiaInProcessamento_AttesaAttiva() / 1000L);
                                    msgDiag.logPersonalizzato("messaggioInGestione.attesaFineProcessamento.filtroDuplicatiDisabilitato");
                                    msgAttesaFineProcessamento = true;
                                }
                                if (!(existsMessage = msgRequest.existsMessage_noCache())) {
                                    msgDiag.logPersonalizzato("messaggioInGestione.attesaFineProcessamento.filtroDuplicatiDisabilitato.attesaTerminata");
                                    isErrore_MsgGiaRicevuto = false;
                                    break;
                                }
                                if ("GestoreMessaggi".equals(proprietarioMessaggio)) {
                                    msgDiag.logPersonalizzato("messaggioInGestione.attesaFineProcessamento.filtroDuplicatiDisabilitato.forzoEliminazione");
                                    msgRequest.deleteMessage();
                                    isErrore_MsgGiaRicevuto = false;
                                    break;
                                }
                            }
                            try {
                                Thread.sleep(propertiesReader.getMsgGiaInProcessamento_CheckInterval());
                            }
                            catch (Exception eRandom) {}
                        }
                        if (isErrore_MsgGiaRicevuto) {
                            msgDiag.logPersonalizzato("messaggioInGestione.attesaFineProcessamento.timeoutScaduto");
                            if (this.msgContext.isGestioneRisposta()) {
                                parametriGenerazioneSPCoopErrore.setBusta(bustaRichiesta);
                                parametriGenerazioneSPCoopErrore.setMessaggioErrore("La richiesta assegnata alla busta SPCoop con ID=XXX \u00e8 gi\u00e0 stata ricevuta e risulta ancora in processamento".replace("XXX", idEGovRequest));
                                parametriGenerazioneSPCoopErrore.setCodiceErrore("OPENSPCOOP_ORG_537");
                                errorAxisMsg = this.generaSPCoopErroreProcessamento(parametriGenerazioneSPCoopErrore, null);
                                parametriInvioSPCoopErrore.setAxisMsg(errorAxisMsg);
                                parametriInvioSPCoopErrore.setBusta(parametriGenerazioneSPCoopErrore.getBusta());
                                this.sendRispostaSPCoopErrore(parametriInvioSPCoopErrore);
                            }
                            openspcoopstate.releaseResource();
                            return;
                        }
                    }
                }
            }
            catch (Exception e) {
                msgDiag.logErroreGenerico(e, "ControlloPresenzaMessaggioGiaInGestione");
                logCore.error((Object)"Controllo/gestione presenza messaggio gia in gestione non riuscito", (Throwable)e);
                if (this.msgContext.isGestioneRisposta()) {
                    parametriGenerazioneSPCoopErrore.setBusta(bustaRichiesta);
                    parametriGenerazioneSPCoopErrore.setMessaggioErrore("Sistema non disponibile");
                    parametriGenerazioneSPCoopErrore.setCodiceErrore("OPENSPCOOP_ORG_536");
                    errorAxisMsg = this.generaSPCoopErroreProcessamento(parametriGenerazioneSPCoopErrore, e);
                    parametriInvioSPCoopErrore.setAxisMsg(errorAxisMsg);
                    parametriInvioSPCoopErrore.setBusta(parametriGenerazioneSPCoopErrore.getBusta());
                    this.sendRispostaSPCoopErrore(parametriInvioSPCoopErrore);
                }
                openspcoopstate.releaseResource();
                return;
            }
        }
        msgDiag.mediumDebug("Registrazione messaggio di richiesta nel RepositoryMessaggi...");
        try {
            msgRequest.registraMessaggio(requestMessage, dataIngressoMessaggio, oneWayStateless != false || sincronoStateless != false || asincronoStateless != false || routingStateless != false, correlazioneApplicativa, inRequestContext.getPddContext());
        }
        catch (Exception e) {
            msgDiag.logErroreGenerico(e, "msgRequest.registraMessaggio");
            if (this.msgContext.isGestioneRisposta()) {
                parametriGenerazioneSPCoopErrore.setBusta(bustaRichiesta);
                parametriGenerazioneSPCoopErrore.setMessaggioErrore("Sistema non disponibile");
                parametriGenerazioneSPCoopErrore.setCodiceErrore("OPENSPCOOP_ORG_508");
                errorAxisMsg = this.generaSPCoopErroreProcessamento(parametriGenerazioneSPCoopErrore, e);
                parametriInvioSPCoopErrore.setAxisMsg(errorAxisMsg);
                parametriInvioSPCoopErrore.setBusta(parametriGenerazioneSPCoopErrore.getBusta());
                this.sendRispostaSPCoopErrore(parametriInvioSPCoopErrore);
            }
            msgRequest.deleteMessageFromFileSystem();
            openspcoopstate.releaseResource();
            return;
        }
        msgDiag.mediumDebug("Registrazione busta eGov di richiesta nel RepositoryEGov...");
        try {
            if (!(oneWayStateless || sincronoStateless || asincronoStateless || routingStateless)) {
                if (repositoryEGov.isRegistrata(bustaRichiesta.getID(), tipoMsg)) {
                    repositoryEGov.aggiornaBusta(bustaRichiesta, tipoMsg, propertiesReader.getRepositoryIntervalloScadenzaMessaggi(), erroriValidazione);
                    repositoryEGov.impostaUtilizzoPdD(bustaRichiesta.getID(), tipoMsg);
                } else {
                    repositoryEGov.registraBusta(bustaRichiesta, tipoMsg, erroriValidazione, propertiesReader.getRepositoryIntervalloScadenzaMessaggi());
                }
                infoIntegrazione = new Integrazione();
                infoIntegrazione.setIdModuloInAttesa(this.msgContext.getIdModulo());
                repositoryEGov.aggiornaInfoIntegrazione(bustaRichiesta.getID(), tipoMsg, infoIntegrazione);
            } else {
                ((StatelessMessage)openspcoopstate.getStatoRichiesta()).setBusta(bustaRichiesta);
            }
        }
        catch (Exception e) {
            msgDiag.logErroreGenerico(e, "repositoryEGov.registraBusta");
            if (this.msgContext.isGestioneRisposta()) {
                parametriGenerazioneSPCoopErrore.setBusta(bustaRichiesta);
                parametriGenerazioneSPCoopErrore.setMessaggioErrore("Sistema non disponibile");
                parametriGenerazioneSPCoopErrore.setCodiceErrore("OPENSPCOOP_ORG_525");
                errorAxisMsg = this.generaSPCoopErroreProcessamento(parametriGenerazioneSPCoopErrore, e);
                parametriInvioSPCoopErrore.setAxisMsg(errorAxisMsg);
                parametriInvioSPCoopErrore.setBusta(parametriGenerazioneSPCoopErrore.getBusta());
                this.sendRispostaSPCoopErrore(parametriInvioSPCoopErrore);
            }
            msgRequest.deleteMessageFromFileSystem();
            openspcoopstate.releaseResource();
            return;
        }
        try {
            if (functionAsRouter) {
                msgDiag.mediumDebug("Invio messaggio al modulo di InoltroBusteEGov (router)...");
                msgRequest.aggiornaProprietarioMessaggio("InoltroBusteEGov");
                msgDiag.highDebug("Creazione ObjectMessage for send nell'infrastruttura.");
                inoltroMSG.setBusta(bustaRichiesta);
                rd = new RichiestaDelegata(soggettoFruitore);
                rd.setDominio(identitaPdD);
                rd.setIdModuloInAttesa(this.msgContext.getIdModulo());
                rd.setIdServizio(idServizio);
                rd.setIdCorrelazioneApplicativa(correlazioneApplicativa);
                rd.setServizioApplicativo(servizioApplicativoFruitore);
                inoltroMSG.setRichiestaDelegata(rd);
                inoltroMSG.setImplementazionePdDSoggettoMittente(implementazionePdDMittente);
                inoltroMSG.setImplementazionePdDSoggettoDestinatario(implementazionePdDDestinatario);
                inoltroMSG.setPddContext(inRequestContext.getPddContext());
                if (!routingStateless) {
                    RicezioneBusteEGov.nodeSender.send(inoltroMSG, "InoltroBusteEGov", msgDiag, identitaPdD.getCodicePorta(), this.msgContext.getIdModulo(), idEGovRequest, msgRequest);
                }
            } else {
                msgDiag.mediumDebug("Invio messaggio al modulo di Sbustamento...");
                msgRequest.aggiornaProprietarioMessaggio("Sbustamento");
                msgDiag.highDebug("Creazione ObjectMessage for send nell'infrastruttura.");
                richiestaApplicativa.setIdCorrelazioneApplicativa(correlazioneApplicativa);
                richiestaApplicativa.setIdentitaServizioApplicativoFruitore(servizioApplicativoFruitore);
                sbustamentoMSG.setRichiestaApplicativa(richiestaApplicativa);
                sbustamentoMSG.setBusta(bustaRichiesta);
                sbustamentoMSG.setErrors(erroriValidazione);
                sbustamentoMSG.setIsSPCoopErrore(isMessaggioSPCoopErrore);
                sbustamentoMSG.setIsBustaDiServizio(bustaDiServizio);
                sbustamentoMSG.setServizioCorrelato(validatoreSPCoop.getServizioCorrelato());
                sbustamentoMSG.setTipoServizioCorrelato(validatoreSPCoop.getTipoServizioCorrelato());
                sbustamentoMSG.setRuoloBustaEgovRicevuta(ruoloBustaEgovRicevuta);
                sbustamentoMSG.setOneWayVersione11(oneWayVersione11);
                sbustamentoMSG.setStateless(oneWayStateless != false || sincronoStateless != false || asincronoStateless != false);
                sbustamentoMSG.setImplementazionePdDSoggettoMittente(implementazionePdDMittente);
                sbustamentoMSG.setImplementazionePdDSoggettoDestinatario(implementazionePdDDestinatario);
                sbustamentoMSG.setPddContext(inRequestContext.getPddContext());
                sbustamentoMSG.setDettaglioEccezione(dettaglioEccezione);
                if (validatoreSPCoop.getInfoServizio() != null) {
                    sbustamentoMSG.setFiltroDuplicatiRichiestoAccordo("EGOV_IT_ALPIUUNAVOLTA".equals(validatoreSPCoop.getInfoServizio().getInoltro()));
                    if (!"eGov1.1-lineeGuida1.1".equals(profiloGestione)) {
                        sbustamentoMSG.setConfermaRicezioneRichiestoAccordo(validatoreSPCoop.getInfoServizio().getConfermaRicezione());
                        sbustamentoMSG.setConsegnaOrdineRichiestoAccordo(validatoreSPCoop.getInfoServizio().getOrdineConsegna());
                    }
                }
                if (!portaStateless) {
                    logCore.debug((Object)"RicezioneBusteEGov :eseguo send a sbustamento");
                    RicezioneBusteEGov.nodeSender.send(sbustamentoMSG, "Sbustamento", msgDiag, identitaPdD.getCodicePorta(), this.msgContext.getIdModulo(), idEGovRequest, msgRequest);
                    logCore.debug((Object)"RicezioneBusteEGov :send a sbustamento eseguita");
                }
            }
        }
        catch (Exception e) {
            if (functionAsRouter) {
                logCore.error((Object)"Spedizione->InoltroBusteEGov(router) non riuscita", (Throwable)e);
                msgDiag.logErroreGenerico(e, "GenericLib.nodeSender.send(InoltroBusteEGov)");
            } else {
                logCore.error((Object)"Spedizione->Sbustamento non riuscita", (Throwable)e);
                msgDiag.logErroreGenerico(e, "GenericLib.nodeSender.send(Sbustamento)");
            }
            if (this.msgContext.isGestioneRisposta()) {
                parametriGenerazioneSPCoopErrore.setBusta(bustaRichiesta);
                parametriGenerazioneSPCoopErrore.setMessaggioErrore("Sistema non disponibile");
                parametriGenerazioneSPCoopErrore.setCodiceErrore("OPENSPCOOP_ORG_512");
                errorAxisMsg = this.generaSPCoopErroreProcessamento(parametriGenerazioneSPCoopErrore, e);
                parametriInvioSPCoopErrore.setAxisMsg(errorAxisMsg);
                parametriInvioSPCoopErrore.setBusta(parametriGenerazioneSPCoopErrore.getBusta());
                this.sendRispostaSPCoopErrore(parametriInvioSPCoopErrore);
            }
            msgRequest.deleteMessageFromFileSystem();
            openspcoopstate.releaseResource();
            return;
        }
        msgDiag.mediumDebug("Commit delle operazioni per la gestione della richiesta...");
        try {
            openspcoopstate.commit();
            logCore.debug((Object)"RicezioneBusteEGov :RicezioneBusteEGov commit eseguito");
        }
        catch (Exception e) {
            msgDiag.logErroreGenerico(e, "openspcoopstate.commit()");
            if (this.msgContext.isGestioneRisposta()) {
                parametriGenerazioneSPCoopErrore.setBusta(bustaRichiesta);
                parametriGenerazioneSPCoopErrore.setMessaggioErrore("Sistema non disponibile");
                parametriGenerazioneSPCoopErrore.setCodiceErrore("OPENSPCOOP_ORG_506");
                errorAxisMsg = this.generaSPCoopErroreProcessamento(parametriGenerazioneSPCoopErrore, e);
                parametriInvioSPCoopErrore.setAxisMsg(errorAxisMsg);
                parametriInvioSPCoopErrore.setBusta(parametriGenerazioneSPCoopErrore.getBusta());
                this.sendRispostaSPCoopErrore(parametriInvioSPCoopErrore);
            }
            msgRequest.deleteMessageFromFileSystem();
            openspcoopstate.releaseResource();
            return;
        }
        if (validatoreSPCoop != null) {
            if (validatoreSPCoop.getValidatoreSintattico() != null) {
                validatoreSPCoop.getValidatoreSintattico().setHeaderSOAP(null);
            }
            validatoreSPCoop.setValidatoreSintattico(null);
        }
        validatoreSPCoop = null;
        if (!portaStateless && !routingStateless) {
            if (msgRequest != null) {
                msgRequest.addMessaggiIntoCache_readFromTable("RicezioneBusteEGov", "richiesta");
            }
            if (msgRequest != null) {
                msgRequest.addProprietariIntoCache_readFromTable("RicezioneBusteEGov", "richiesta", null, functionAsRouter);
            }
            msgDiag.mediumDebug("Commit delle operazioni per la gestione della richiesta effettuato, rilascio della connessione...");
            openspcoopstate.releaseResource();
        }
        if (routingStateless) {
            ((OpenSPCoopStateless)openspcoopstate).setMessageLib(inoltroMSG);
            ((OpenSPCoopStateless)openspcoopstate).setIDEgovSessione(idEGovRequest);
            ((OpenSPCoopStateless)openspcoopstate).setUseConnection(false);
            lib = new InoltroBusteEGov(logCore);
            try {
                esito = lib.onMessage(openspcoopstate);
                if (esito.getStatoInvocazione() == 1 || esito.getStatoInvocazione() == 2) {
                    msgDiag.mediumDebug("Invocazione libreria InoltroBusteEGov riuscito con esito: " + esito.getStatoInvocazione());
                } else if (esito.getStatoInvocazione() == 3) {
                    throw new Exception("Errore non gestito dalla libreria");
                }
            }
            catch (Exception e) {
                msgDiag.logErroreGenerico(e, "GestioneRoutingStateless");
                logCore.error((Object)("Errore Generale durante la gestione del routing stateless: " + e.getMessage()), (Throwable)e);
                parametriGenerazioneSPCoopErrore.setBusta(bustaRichiesta);
                parametriGenerazioneSPCoopErrore.setMessaggioErrore("Sistema non disponibile");
                parametriGenerazioneSPCoopErrore.setCodiceErrore("OPENSPCOOP_ORG_500");
                errorAxisMsg = this.generaSPCoopErroreProcessamento(parametriGenerazioneSPCoopErrore, e);
                ((OpenSPCoopStateless)openspcoopstate).setUseConnection(true);
                parametriInvioSPCoopErrore.setAxisMsg(errorAxisMsg);
                parametriInvioSPCoopErrore.setBusta(parametriGenerazioneSPCoopErrore.getBusta());
                this.sendRispostaSPCoopErrore(parametriInvioSPCoopErrore);
                openspcoopstate.releaseResource();
                return;
            }
            ((OpenSPCoopStateless)openspcoopstate).setUseConnection(true);
        }
        if (portaStateless) {
            ((OpenSPCoopStateless)openspcoopstate).setMessageLib(sbustamentoMSG);
            ((OpenSPCoopStateless)openspcoopstate).setIDEgovSessione(idEGovRequest);
            ((OpenSPCoopStateless)openspcoopstate).setUseConnection(false);
            esito = new EsitoLib();
            try {
                ((OpenSPCoopStateless)openspcoopstate).setDestinatarioResponseMsgLib("");
                while (!((OpenSPCoopStateless)openspcoopstate).getDestinatarioResponseMsgLib().startsWith("RicezioneBusteEGov")) {
                    libreriaSbustamento = false;
                    if (((OpenSPCoopStateless)openspcoopstate).getDestinatarioRequestMsgLib().startsWith("Sbustamento")) {
                        libreriaSbustamento = true;
                    }
                    if (((OpenSPCoopStateless)openspcoopstate).getDestinatarioResponseMsgLib().startsWith("ImbustamentoRisposte") && propertiesReader.isRinegoziamentoConnessione(bustaRichiesta.getProfiloDiCollaborazione()) && (oneWayStateless || sincronoStateless || asincronoStateless) && openspcoopstate.resourceReleased()) {
                        ((OpenSPCoopStateless)openspcoopstate).setUseConnection(true);
                        ((OpenSPCoopStateless)openspcoopstate).initResource(identitaPdD, "ImbustamentoRisposte");
                        ((OpenSPCoopStateless)openspcoopstate).setUseConnection(false);
                    }
                    esito = this.chiamaLibreria((OpenSPCoopStateless)openspcoopstate, logCore);
                    if (oneWayVersione11 && newConnectionForResponse && esito.getStatoInvocazione() == 1 && libreriaSbustamento) {
                        ((OpenSPCoopStateless)openspcoopstate).setDestinatarioResponseMsgLib("RicezioneBusteEGov");
                        ((OpenSPCoopStateless)openspcoopstate).setUseConnection(true);
                        openspcoopstate.commit();
                        ((OpenSPCoopStateless)openspcoopstate).setUseConnection(false);
                    }
                    if (esito.getStatoInvocazione() == 2) {
                        if (oneWayVersione11 && newConnectionForResponse && libreriaSbustamento) {
                            ((OpenSPCoopStateless)openspcoopstate).setUseConnection(true);
                            openspcoopstate.commit();
                            ((OpenSPCoopStateless)openspcoopstate).setUseConnection(false);
                        }
                        break;
                    }
                    if (esito.getStatoInvocazione() == 3) {
                        throw new Exception("Errore non gestito dalla libreria");
                    }
                    if (!libreriaSbustamento || !propertiesReader.isRinegoziamentoConnessione(bustaRichiesta.getProfiloDiCollaborazione()) || !oneWayStateless && !sincronoStateless && !asincronoStateless) continue;
                    ((OpenSPCoopStateless)openspcoopstate).setUseConnection(true);
                    openspcoopstate.commit();
                    openspcoopstate.releaseResource();
                    ((OpenSPCoopStateless)openspcoopstate).setUseConnection(false);
                }
            }
            catch (Exception e) {
                msgDiag.logErroreGenerico(e, "GestioneStateless");
                logCore.error((Object)("Errore Generale durante la gestione stateless: " + e.getMessage()), (Throwable)e);
                parametriGenerazioneSPCoopErrore.setBusta(bustaRichiesta);
                parametriGenerazioneSPCoopErrore.setMessaggioErrore("Sistema non disponibile");
                parametriGenerazioneSPCoopErrore.setCodiceErrore("OPENSPCOOP_ORG_500");
                errorAxisMsg = this.generaSPCoopErroreProcessamento(parametriGenerazioneSPCoopErrore, e);
                ((OpenSPCoopStateless)openspcoopstate).setUseConnection(true);
                parametriInvioSPCoopErrore.setAxisMsg(errorAxisMsg);
                parametriInvioSPCoopErrore.setBusta(parametriGenerazioneSPCoopErrore.getBusta());
                this.sendRispostaSPCoopErrore(parametriInvioSPCoopErrore);
                openspcoopstate.releaseResource();
                return;
            }
            ((OpenSPCoopStateless)openspcoopstate).setUseConnection(true);
        }
        msgDiag.mediumDebug("Gestione risposta...");
        if (!this.msgContext.isGestioneRisposta()) {
            if (portaStateless) {
                openspcoopstate.releaseResource();
            }
            return;
        }
        richiestaRispostaSPCoop = true;
        if (functionAsRouter) {
            if (!"EGOV_IT_ServizioSincrono".equals(bustaRichiesta.getProfiloDiCollaborazione()) && newConnectionForResponse) {
                this.msgContext.setMessageResponse(SoapUtils.build_Soap_Empty());
                return;
            }
            richiestaRispostaSPCoop = false;
        } else {
            if (!(!utilizzoIndirizzoTelematico || bustaRichiesta.getIndirizzoTelematicoMittente() == null || "eGov1.1-lineeGuida1.1".equals(profiloGestione) || oneWayStateless || sincronoStateless || asincronoStateless)) {
                this.msgContext.setMessageResponse(SoapUtils.build_Soap_Empty());
                if (portaStateless) {
                    openspcoopstate.releaseResource();
                }
                return;
            }
            if (!("EGOV_IT_ServizioSincrono".equals(bustaRichiesta.getProfiloDiCollaborazione()) || !newConnectionForResponse || oneWayStateless || sincronoStateless || asincronoStateless)) {
                this.msgContext.setMessageResponse(SoapUtils.build_Soap_Empty());
                if (portaStateless) {
                    openspcoopstate.releaseResource();
                }
                return;
            }
            if (isMessaggioSPCoopErrore) {
                richiestaRispostaSPCoop = false;
            } else if (bustaDiServizio) {
                richiestaRispostaSPCoop = false;
            } else if ("eGov1.1-lineeGuida1.1".equals(profiloGestione) || !propertiesReader.isGestioneRiscontri(implementazionePdDMittente) || "EGOV_IT_MessaggioSingoloOneWay".equals(bustaRichiesta.getProfiloDiCollaborazione()) && !bustaRichiesta.getConfermaRicezione()) {
                richiestaRispostaSPCoop = false;
            } else if ("EGOV_IT_ServizioAsincronoSimmetrico".equals(bustaRichiesta.getProfiloDiCollaborazione()) || "EGOV_IT_ServizioAsincronoAsimmetrico".equals(bustaRichiesta.getProfiloDiCollaborazione())) {
                richiestaRispostaSPCoop = false;
            }
        }
        msgResponse = null;
        responseMessage = SoapUtils.build_Soap_Empty();
        bustaRisposta = null;
        idMessaggioSblocco = null;
        contenutoRispostaPresente = false;
        try {
            ricezioneBusteEGovMSG = null;
            try {
                msgDiag.mediumDebug("Attesa/lettura risposta...");
                if (!portaStateless && !routingStateless) {
                    ricezioneBusteEGovMSG = (RicezioneBusteEGovMessage)RicezioneBusteEGov.nodeReceiver.receive(msgDiag, identitaPdD.getCodicePorta(), this.msgContext.getIdModulo(), idEGovRequest, propertiesReader.getNodeReceiverTimeoutRicezioneBusteEgov(), propertiesReader.getNodeReceiverCheckInterval());
                    pddContext = ricezioneBusteEGovMSG.getPddContext();
                    if (pddContext != null) {
                        enumPddContext = pddContext.keys();
                        while (enumPddContext.hasMoreElements()) {
                            key = enumPddContext.nextElement();
                            this.msgContext.getPddContext().addObject(key, pddContext.getObject(key));
                        }
                    }
                } else {
                    ricezioneBusteEGovMSG = (RicezioneBusteEGovMessage)openspcoopstate.getMessageLib();
                }
                v2 = contenutoRispostaPresente = ricezioneBusteEGovMSG.getBustaRisposta() != null;
                if (richiestaRispostaSPCoop && !contenutoRispostaPresente) {
                    throw new Exception("Risposta SPCoop attesa e non ritornata: ErroreInterno");
                }
                if (contenutoRispostaPresente) {
                    bustaRisposta = ricezioneBusteEGovMSG.getBustaRisposta();
                    this.msgContext.getEgov().setIdRisposta(bustaRisposta.getID());
                    this.msgContext.getEgov().setCollaborazione(bustaRisposta.getCollaborazione());
                } else {
                    idMessaggioSblocco = ricezioneBusteEGovMSG.getIdMessaggioSblocco();
                }
            }
            catch (Exception e) {
                msgDiag.logErroreGenerico(e, "GestioneRisposta(" + this.msgContext.getIdModulo() + ")");
                logCore.error((Object)("Gestione risposta (" + this.msgContext.getIdModulo() + ") con errore"), (Throwable)e);
                if (!portaStateless && !routingStateless) {
                    try {
                        msgDiag.mediumDebug("Richiesta connessione al database per la gestione della risposta...");
                        openspcoopstate.updateResource();
                    }
                    catch (Exception eDB) {
                        this.setSOAPFault_processamento(logCore, msgDiag, eDB, "openspcoopstate.updateDatabaseResource");
                        return;
                    }
                }
                if (e instanceof NodeTimeoutException) {
                    try {
                        msgDiag.logPersonalizzato("timeoutRicezioneRisposta");
                        msgRequest.aggiornaProprietarioMessaggio("GestoreMessaggi");
                        openspcoopstate.commit();
                    }
                    catch (Exception eDel) {
                        msgDiag.logErroreGenerico(eDel.getMessage(), "EliminazioneMessaggioScadutoTimeoutRicezioneRisposta");
                    }
                }
                parametriGenerazioneSPCoopErrore.setBusta(bustaRichiesta);
                parametriGenerazioneSPCoopErrore.setMessaggioErrore("Sistema non disponibile");
                parametriGenerazioneSPCoopErrore.setCodiceErrore("OPENSPCOOP_ORG_513");
                errorAxisMsg = this.generaSPCoopErroreProcessamento(parametriGenerazioneSPCoopErrore, e);
                parametriInvioSPCoopErrore.setAxisMsg(errorAxisMsg);
                parametriInvioSPCoopErrore.setBusta(parametriGenerazioneSPCoopErrore.getBusta());
                this.sendRispostaSPCoopErrore(parametriInvioSPCoopErrore);
                openspcoopstate.releaseResource();
                return;
            }
            if (contenutoRispostaPresente) {
                msgDiag.setIdEGovRisposta(bustaRisposta.getID());
                msgDiag.addKeywords(bustaRisposta, false);
            } else {
                msgDiag.setIdEGovRisposta(idMessaggioSblocco);
            }
            parametriGenerazioneSPCoopErrore.setMsgDiag(msgDiag);
            parametriInvioSPCoopErrore.setMsgDiag(msgDiag);
            if (!portaStateless && !routingStateless) {
                try {
                    msgDiag.mediumDebug("Richiesta connessione al database per la gestione della risposta...");
                    openspcoopstate.updateResource();
                }
                catch (Exception e) {
                    this.setSOAPFault_processamento(logCore, msgDiag, e, "openspcoopstate.updateDatabaseResource");
                    return;
                }
                msgResponse = contenutoRispostaPresente != false ? new GestoreMessaggi(openspcoopstate, false, bustaRisposta.getID(), "OUTBOX", msgDiag) : new GestoreMessaggi(openspcoopstate, false, idMessaggioSblocco, "OUTBOX", msgDiag);
                if (contenutoRispostaPresente || functionAsRouter) {
                    msgDiag.mediumDebug("Lettura messaggio di risposta...");
                    try {
                        responseMessage = msgResponse.getMessage();
                    }
                    catch (Exception e) {
                        if (functionAsRouter && !contenutoRispostaPresente) ** GOTO lbl1576
                        msgDiag.logErroreGenerico(e, "msgResponse.getMessage()");
                        parametriGenerazioneSPCoopErrore.setBusta(bustaRichiesta);
                        parametriGenerazioneSPCoopErrore.setMessaggioErrore("Sistema non disponibile");
                        parametriGenerazioneSPCoopErrore.setCodiceErrore("OPENSPCOOP_ORG_511");
                        errorAxisMsg = this.generaSPCoopErroreProcessamento(parametriGenerazioneSPCoopErrore, e);
                        parametriInvioSPCoopErrore.setAxisMsg(errorAxisMsg);
                        parametriInvioSPCoopErrore.setBusta(parametriGenerazioneSPCoopErrore.getBusta());
                        this.sendRispostaSPCoopErrore(parametriInvioSPCoopErrore);
                        openspcoopstate.releaseResource();
                        return;
                    }
                }
            } else {
                responseMessage = ((OpenSPCoopStateless)openspcoopstate).getRispostaMsg();
            }
lbl1576:
            // 4 sources

            if (contenutoRispostaPresente) {
                tras = null;
                if (propertiesReader.isGenerazioneListaTrasmissioni(implementazionePdDMittente)) {
                    msgDiag.mediumDebug("Impostazione trasmissione nella busta eGov di risposta...");
                    tras = new Trasmissione();
                    tras.setOrigine(identitaPdD.getNome());
                    tras.setTipoOrigine(identitaPdD.getTipo());
                    for (i = 0; i < bustaRichiesta.sizeListaTrasmissioni(); ++i) {
                        if (!identitaPdD.getTipo().equals(bustaRichiesta.getTrasmissione(i).getTipoDestinazione()) || !identitaPdD.getNome().equals(bustaRichiesta.getTrasmissione(i).getDestinazione())) continue;
                        tras.setDestinazione(bustaRichiesta.getTrasmissione(i).getOrigine());
                        tras.setTipoDestinazione(bustaRichiesta.getTrasmissione(i).getTipoOrigine());
                    }
                    if (tras.getDestinazione() == null || tras.getTipoDestinazione() == null) {
                        tras.setDestinazione(bustaRisposta.getDestinatario());
                        tras.setTipoDestinazione(bustaRisposta.getTipoDestinatario());
                    }
                    tras.setOraRegistrazione(bustaRisposta.getOraRegistrazione());
                    tras.setTempo(propertiesReader.getTipoTempoEGov(implementazionePdDMittente));
                    bustaRisposta.addTrasmissione(tras);
                }
                scartaBody = false;
                if (!functionAsRouter) {
                    allegaBody = configurazionePdDReader.isAllegaBody(pa);
                    scartaBody = allegaBody != false ? true : configurazionePdDReader.isScartaBody(pa);
                }
                if (!functionAsRouter && bustaRisposta.sizeListaEccezioni() == 0 && "eGov1.1-lineeGuida1.1".equals(profiloGestione)) {
                    for (i = 0; i < erroriValidazione.size(); ++i) {
                        ec = (Eccezione)erroriValidazione.get(i);
                        if (!"INFO".equals(ec.getRilevanza())) continue;
                        bustaRisposta.addEccezione(ec);
                    }
                }
                msgDiag.mediumDebug("Imbustamento eGov della risposta...");
                try {
                    gestioneManifestRisposta = false;
                    onlyRefreshIdManifestAttachments = false;
                    if (functionAsRouter) {
                        onlyRefreshIdManifestAttachments = true;
                        gestioneManifestRisposta = configurazionePdDReader.isGestioneManifestAttachments();
                    } else {
                        gestioneManifestRisposta = configurazionePdDReader.isGestioneManifestAttachments(pa);
                    }
                    if (!(!functionAsRouter || identitaPdD.getTipo().equals(bustaRisposta.getTipoMittente()) && identitaPdD.getNome().equals(bustaRisposta.getMittente()))) {
                        if (propertiesReader.isGenerazioneListaTrasmissioni(implementazionePdDMittente)) {
                            imbustatore.addTrasmissione(responseMessage, tras, readQualifiedAttribute);
                        }
                    } else {
                        imbustatore.imbustamentoEGov(responseMessage, bustaRisposta, gestioneManifestRisposta, false, scartaBody, onlyRefreshIdManifestAttachments, proprietaManifestAttachments);
                    }
                }
                catch (Exception e) {
                    if (!(!functionAsRouter || identitaPdD.getTipo().equals(bustaRisposta.getTipoMittente()) && identitaPdD.getNome().equals(bustaRisposta.getMittente()))) {
                        msgDiag.logErroreGenerico(e, "imbustatore.addTrasmissione(risposta)");
                    } else {
                        msgDiag.logErroreGenerico(e, "imbustatore.imbustamentoEGov(risposta)");
                    }
                    parametriGenerazioneSPCoopErrore.setBusta(bustaRichiesta);
                    parametriGenerazioneSPCoopErrore.setMessaggioErrore("Sistema non disponibile");
                    parametriGenerazioneSPCoopErrore.setCodiceErrore("OPENSPCOOP_ORG_526");
                    errorAxisMsg = this.generaSPCoopErroreProcessamento(parametriGenerazioneSPCoopErrore, e);
                    parametriInvioSPCoopErrore.setAxisMsg(errorAxisMsg);
                    parametriInvioSPCoopErrore.setBusta(parametriGenerazioneSPCoopErrore.getBusta());
                    this.sendRispostaSPCoopErrore(parametriInvioSPCoopErrore);
                    openspcoopstate.releaseResource();
                    return;
                }
                if (!functionAsRouter) {
                    msgDiag.mediumDebug("Applicazione WSSecurity alla risposta...");
                    if (wssPropertiesResponse != null && wssPropertiesResponse.size() > 0 && !(wssSender = new WSSSender(wssPropertiesResponse, baseWSS)).process(responseMessage)) {
                        msgDiag.logErroreGenerico(wssSender.getMsgErrore(), "Costruzione header WSS Risposta");
                        parametriGenerazioneSPCoopErrore.setBusta(bustaRichiesta);
                        parametriGenerazioneSPCoopErrore.setMessaggioErrore(wssSender.getMsgErrore());
                        parametriGenerazioneSPCoopErrore.setCodiceErrore(wssSender.getCodiceErrore());
                        errorAxisMsg = this.generaSPCoopErroreValidazione(parametriGenerazioneSPCoopErrore);
                        parametriInvioSPCoopErrore.setAxisMsg(errorAxisMsg);
                        parametriInvioSPCoopErrore.setBusta(parametriGenerazioneSPCoopErrore.getBusta());
                        this.sendRispostaSPCoopErrore(parametriInvioSPCoopErrore);
                        openspcoopstate.releaseResource();
                        return;
                    }
                }
                msgDiag.mediumDebug("Tracciamento busta eGov di risposta...");
                if (this.msgContext.isTracciamentoAbilitato()) {
                    tracciamento.registraRisposta(openspcoopstate.getConnectionDB(), bustaRisposta, Tracciamento.createLocationString(false, this.msgContext.getFromLocation()), correlazioneApplicativa, servizioApplicativoFruitore);
                }
                if (ValidatoreSPCoop.isBustaSPCoopErrore((Busta)bustaRisposta, (String)profiloGestione, (Message)responseMessage)) {
                    msgDiag.logPersonalizzato("generazioneMessaggioSPCoopErroreRisposta");
                } else {
                    msgDiag.logPersonalizzato("generazioneMessaggioSPCoopRisposta");
                }
                msgDiag.mediumDebug("Eliminazione accesso da PdD...");
                repositoryEGov.eliminaUtilizzoPdDFromOutBox(bustaRisposta.getID());
            }
            if (oneWayStateless || sincronoStateless || asincronoStateless) {
                msgDiag.mediumDebug("Aggiorno proprietario messaggio richiesta ...");
                try {
                    openspcoopstate.commit();
                }
                catch (Exception e) {
                    logCore.error((Object)"Riscontrato errore durante l'aggiornamento proprietario messaggio", (Throwable)e);
                    msgDiag.logErroreGenerico(e, "openspcoopstate.commit(stateless risposta)");
                    parametriGenerazioneSPCoopErrore.setBusta(bustaRichiesta);
                    parametriGenerazioneSPCoopErrore.setMessaggioErrore("Sistema non disponibile");
                    parametriGenerazioneSPCoopErrore.setCodiceErrore("OPENSPCOOP_ORG_500");
                    errorAxisMsg = this.generaSPCoopErroreProcessamento(parametriGenerazioneSPCoopErrore, e);
                    parametriInvioSPCoopErrore.setAxisMsg(errorAxisMsg);
                    parametriInvioSPCoopErrore.setBusta(parametriGenerazioneSPCoopErrore.getBusta());
                    this.sendRispostaSPCoopErrore(parametriInvioSPCoopErrore);
                    openspcoopstate.releaseResource();
                    return;
                }
            }
            if (oneWayVersione11) {
                msgDiag.mediumDebug("Commit della gestione oneWay stateful/stateless ibrido ...");
                try {
                    openspcoopstate.commit();
                }
                catch (Exception e) {
                    logCore.error((Object)"Riscontrato errore durante il commit della gestione oneWay stateful/stateless ibrido", (Throwable)e);
                    msgDiag.logErroreGenerico(e, "openspcoopstate.commit(oneway1.1 risposta)");
                    parametriGenerazioneSPCoopErrore.setBusta(bustaRichiesta);
                    parametriGenerazioneSPCoopErrore.setMessaggioErrore("Sistema non disponibile");
                    parametriGenerazioneSPCoopErrore.setCodiceErrore("OPENSPCOOP_ORG_500");
                    errorAxisMsg = this.generaSPCoopErroreProcessamento(parametriGenerazioneSPCoopErrore, e);
                    parametriInvioSPCoopErrore.setAxisMsg(errorAxisMsg);
                    parametriInvioSPCoopErrore.setBusta(parametriGenerazioneSPCoopErrore.getBusta());
                    this.sendRispostaSPCoopErrore(parametriInvioSPCoopErrore);
                    openspcoopstate.releaseResource();
                    return;
                }
            }
            if (!portaStateless && !routingStateless) {
                msgDiag.mediumDebug("Aggiornamento proprietario messaggio...");
                msgResponse.aggiornaProprietarioMessaggio("GestoreMessaggi");
                msgDiag.mediumDebug("Commit delle operazioni per la gestione della risposta...");
                openspcoopstate.commit();
                if (msgResponse != null) {
                    msgResponse.addMessaggiIntoCache_readFromTable("RicezioneBusteEGov", "risposta");
                }
                if (msgResponse != null) {
                    msgResponse.addProprietariIntoCache_readFromTable("RicezioneBusteEGov", "risposta", idEGovRequest, functionAsRouter);
                }
            }
            msgDiag.mediumDebug("Commit delle operazioni per la gestione della richiesta effettuato, rilascio della connessione...");
            openspcoopstate.releaseResource();
            msgDiag.mediumDebug("Imposto risposta nel context...");
            this.msgContext.setMessageResponse(responseMessage);
            msgDiag.mediumDebug("Lavoro Terminato.");
        }
        catch (Exception e) {
            logCore.error((Object)"ErroreGenerale", (Throwable)e);
            msgDiag.logErroreGenerico(e, "Generale");
            parametriGenerazioneSPCoopErrore.setBusta(bustaRichiesta);
            parametriGenerazioneSPCoopErrore.setMessaggioErrore("Sistema non disponibile");
            parametriGenerazioneSPCoopErrore.setCodiceErrore("OPENSPCOOP_ORG_500");
            errorAxisMsg = this.generaSPCoopErroreProcessamento(parametriGenerazioneSPCoopErrore, e);
            parametriInvioSPCoopErrore.setAxisMsg(errorAxisMsg);
            parametriInvioSPCoopErrore.setBusta(parametriGenerazioneSPCoopErrore.getBusta());
            this.sendRispostaSPCoopErrore(parametriInvioSPCoopErrore);
            openspcoopstate.releaseResource();
            return;
        }
    }

    private void setCredenziali(Credenziali credenziali, MsgDiagnostico msgDiag) {
        String credenzialiFornite = "";
        if (credenziali != null && (credenziali.getUsername() != null || credenziali.getSubject() != null)) {
            credenzialiFornite = "(";
            if (credenziali.getUsername() != null) {
                credenzialiFornite = credenziali.getPassword() == null || "".equals(credenziali.getPassword()) ? credenzialiFornite + " Basic Username: " + credenziali.getUsername() + "  Basic Password: non definita" : credenzialiFornite + " Basic Username: " + credenziali.getUsername() + " ";
            }
            if (credenziali.getSubject() != null) {
                credenzialiFornite = credenzialiFornite + " SSL Subject: " + credenziali.getSubject() + " ";
            }
            credenzialiFornite = credenzialiFornite + ")";
        }
        msgDiag.addKeyword("@CREDENZIALI@", credenzialiFornite);
    }

    private Message generaSPCoopErroreProcessamento(RicezioneBusteEGovParametriGenerazioneSPCoopErrore parametriGenerazioneSPCoopErrore, Exception e) {
        parametriGenerazioneSPCoopErrore.setErroreProcessamento(true);
        parametriGenerazioneSPCoopErrore.setEccezioneProcessamento(e);
        return this.generaSPCoopErrore(parametriGenerazioneSPCoopErrore);
    }

    private Message generaSPCoopErroreValidazione(RicezioneBusteEGovParametriGenerazioneSPCoopErrore parametriGenerazioneSPCoopErrore) {
        parametriGenerazioneSPCoopErrore.setErroreProcessamento(false);
        return this.generaSPCoopErrore(parametriGenerazioneSPCoopErrore);
    }

    private Message generaSPCoopErrore(RicezioneBusteEGovParametriGenerazioneSPCoopErrore parametriGenerazioneSPCoopErrore) {
        try {
            Message responseErrorMessage = null;
            String messaggioErrore = parametriGenerazioneSPCoopErrore.getMessaggioErrore();
            String codiceErrore = parametriGenerazioneSPCoopErrore.getCodiceErrore();
            Vector<Eccezione> error = parametriGenerazioneSPCoopErrore.getError();
            Imbustamento imbustatore = parametriGenerazioneSPCoopErrore.getImbustatore();
            IOpenSPCoopState state = parametriGenerazioneSPCoopErrore.getOpenspcoop();
            IDSoggetto identitaPdD = parametriGenerazioneSPCoopErrore.getIdentitaPdD();
            Hashtable<?, ?> wssPropertiesResponse = parametriGenerazioneSPCoopErrore.getWssPropertiesResponse();
            WSSBaseUtils baseWSS = parametriGenerazioneSPCoopErrore.getBaseWSS();
            OpenSPCoopProperties propertiesReader = parametriGenerazioneSPCoopErrore.getPropertiesReader();
            String profiloGestione = parametriGenerazioneSPCoopErrore.getProfiloGestione();
            String implementazionePdDMittente = parametriGenerazioneSPCoopErrore.getImplementazionePdDMittente();
            Tracciamento tracciamento = parametriGenerazioneSPCoopErrore.getTracciamento();
            MsgDiagnostico msgDiag = parametriGenerazioneSPCoopErrore.getMsgDiag();
            responseErrorMessage = parametriGenerazioneSPCoopErrore.isErroreProcessamento() ? (messaggioErrore != null && codiceErrore != null ? imbustatore.msgErroreProcessamentoSPCoop(identitaPdD, this.msgContext.getIdModulo(), parametriGenerazioneSPCoopErrore.getBusta(), messaggioErrore, codiceErrore, wssPropertiesResponse, baseWSS, propertiesReader.getGestioneSerializableDB_AttesaAttiva(), propertiesReader.getGestioneSerializableDB_CheckInterval(), profiloGestione, propertiesReader.getTipoTempoEGov(implementazionePdDMittente), propertiesReader.isGenerazioneListaTrasmissioni(implementazionePdDMittente), parametriGenerazioneSPCoopErrore.getEccezioneProcessamento()) : imbustatore.msgErroreProcessamentoSPCoop(identitaPdD, this.msgContext.getIdModulo(), parametriGenerazioneSPCoopErrore.getBusta(), error, wssPropertiesResponse, baseWSS, propertiesReader.getGestioneSerializableDB_AttesaAttiva(), propertiesReader.getGestioneSerializableDB_CheckInterval(), profiloGestione, propertiesReader.getTipoTempoEGov(implementazionePdDMittente), propertiesReader.isGenerazioneListaTrasmissioni(implementazionePdDMittente), parametriGenerazioneSPCoopErrore.getEccezioneProcessamento())) : (messaggioErrore != null && codiceErrore != null ? imbustatore.msgErroreValidazioneSPCoop(identitaPdD, this.msgContext.getIdModulo(), parametriGenerazioneSPCoopErrore.getBusta(), messaggioErrore, codiceErrore, wssPropertiesResponse, baseWSS, propertiesReader.getGestioneSerializableDB_AttesaAttiva(), propertiesReader.getGestioneSerializableDB_CheckInterval(), profiloGestione, propertiesReader.getTipoTempoEGov(implementazionePdDMittente), propertiesReader.isGenerazioneListaTrasmissioni(implementazionePdDMittente)) : imbustatore.msgErroreValidazioneSPCoop(identitaPdD, this.msgContext.getIdModulo(), parametriGenerazioneSPCoopErrore.getBusta(), error, wssPropertiesResponse, baseWSS, propertiesReader.getGestioneSerializableDB_AttesaAttiva(), propertiesReader.getGestioneSerializableDB_CheckInterval(), profiloGestione, propertiesReader.getTipoTempoEGov(implementazionePdDMittente), propertiesReader.isGenerazioneListaTrasmissioni(implementazionePdDMittente)));
            if (this.msgContext.isTracciamentoAbilitato()) {
                tracciamento.registraRisposta(((OpenSPCoopState)state).getConnectionDB(), parametriGenerazioneSPCoopErrore.getBusta(), Tracciamento.createLocationString(false, this.msgContext.getFromLocation()), parametriGenerazioneSPCoopErrore.getCorrelazioneApplicativa(), parametriGenerazioneSPCoopErrore.getServizioApplicativoFruitore());
            }
            msgDiag.addKeywords(parametriGenerazioneSPCoopErrore.getBusta(), false);
            if (!Configurazione.getConfigurazioneGenerazioneBusta().getKeywordMittenteSconosciuto().equals(parametriGenerazioneSPCoopErrore.getBusta().getDestinatario()) && !Configurazione.getConfigurazioneGenerazioneBusta().getKeywordTipoMittenteSconosciuto().equals(parametriGenerazioneSPCoopErrore.getBusta().getTipoDestinatario())) {
                msgDiag.logPersonalizzato("generazioneMessaggioSPCoopErroreRisposta");
            } else {
                msgDiag.logPersonalizzato("generazioneMessaggioSPCoopErroreRisposta.destinatarioSconosciuto");
            }
            return responseErrorMessage;
        }
        catch (Exception e) {
            return new Message((Object)new AxisFault("ErroreBuildSPCoopErrore: " + e.getMessage()));
        }
    }

    private void sendRispostaSPCoopErrore(RicezioneBusteEGovParametriInvioSPCoopErrore parametriInvioSPCoopErrore) {
        GestoreMessaggi msgResponse = null;
        RepositoryEGov repositoryEGov = null;
        boolean httpReply = true;
        IOpenSPCoopState openspcoop = parametriInvioSPCoopErrore.getOpenspcoop();
        Busta bustaRisposta = parametriInvioSPCoopErrore.getBusta();
        MsgDiagnostico msgDiag = parametriInvioSPCoopErrore.getMsgDiag();
        Logger logCore = parametriInvioSPCoopErrore.getLogCore();
        try {
            if (parametriInvioSPCoopErrore.isOnewayVersione11()) {
                GestoreMessaggi msgRichiesta = new GestoreMessaggi(openspcoop, true, bustaRisposta.getRiferimentoMessaggio(), "INBOX", logCore, msgDiag);
                msgRichiesta.setReadyForDrop(true);
                msgRichiesta.aggiornaProprietarioMessaggio("GestoreMessaggi");
                RepositoryEGov repositoryEGovRichiesta = new RepositoryEGov(openspcoop.getStatoRichiesta(), true);
                repositoryEGovRichiesta.eliminaBustaStatelessFromInBox(bustaRisposta.getRiferimentoMessaggio());
            }
            if (parametriInvioSPCoopErrore.isNewConnectionForResponse()) {
                httpReply = false;
            }
            if (bustaRisposta.getIndirizzoTelematicoDestinatario() != null && parametriInvioSPCoopErrore.isUtilizzoIndirizzoTelematico()) {
                httpReply = false;
            }
            if (!httpReply) {
                repositoryEGov = new RepositoryEGov(openspcoop.getStatoRisposta(), false);
                repositoryEGov.registraBustaIntoOutBox(bustaRisposta, parametriInvioSPCoopErrore.getPropertiesReader().getRepositoryIntervalloScadenzaMessaggi());
                Integrazione infoIntegrazione = new Integrazione();
                repositoryEGov.aggiornaInfoIntegrazioneIntoOutBox(bustaRisposta.getID(), infoIntegrazione);
                msgResponse = new GestoreMessaggi(openspcoop, true, bustaRisposta.getID(), "OUTBOX", msgDiag);
                msgResponse.setOneWayVersione11(parametriInvioSPCoopErrore.isOnewayVersione11());
                msgResponse.registraMessaggio(parametriInvioSPCoopErrore.getAxisMsg(), parametriInvioSPCoopErrore.getCorrelazioneApplicativa(), parametriInvioSPCoopErrore.getPddContext());
                msgResponse.aggiornaRiferimentoMessaggio(bustaRisposta.getRiferimentoMessaggio());
                msgResponse.aggiornaProprietarioMessaggio("InoltroRisposteEGov");
                EJBUtils ejb = new EJBUtils(parametriInvioSPCoopErrore.getIdentitaPdD(), this.msgContext.getIdModulo(), bustaRisposta.getRiferimentoMessaggio(), bustaRisposta.getID(), "OUTBOX", openspcoop, msgDiag, parametriInvioSPCoopErrore.isFunctionAsRouter(), parametriInvioSPCoopErrore.getImplementazionePdDMittente(), parametriInvioSPCoopErrore.getImplementazionePdDDestinatario(), parametriInvioSPCoopErrore.getPddContext());
                ejb.sendToInoltroRisposteEGov(bustaRisposta, false, null, msgResponse, parametriInvioSPCoopErrore.getCorrelazioneApplicativa(), parametriInvioSPCoopErrore.getServizioApplicativoFruitore(), false);
                Message soapBodyEmpty = SoapUtils.build_Soap_Empty();
                this.msgContext.setMessageResponse(soapBodyEmpty);
            } else {
                Message risposta = parametriInvioSPCoopErrore.getAxisMsg();
                this.msgContext.setMessageResponse(risposta);
            }
            openspcoop.commit();
            if (msgResponse != null) {
                msgResponse.addMessaggiIntoCache_readFromTable(ID_MODULO, "risposta verso nuova connessione");
            }
            if (msgResponse != null) {
                msgResponse.addProprietariIntoCache_readFromTable(ID_MODULO, "risposta verso nuova connessione", bustaRisposta.getRiferimentoMessaggio(), parametriInvioSPCoopErrore.isFunctionAsRouter());
            }
        }
        catch (Exception e) {
            msgDiag.logErroreGenerico(e, "sendRispostaSPCoopErrore");
            try {
                Imbustamento imbustatore = new Imbustamento();
                this.msgContext.setMessageResponse(imbustatore.buildSPCoopSoapFault_processamento(this.msgContext.getIdentitaPdD(), this.msgContext.getIdModulo(), "OPENSPCOOP_ORG_500", e));
            }
            catch (Exception eSPCoopErrore) {
                this.msgContext.setMessageResponse(new Message((Object)new AxisFault("ErroreSendSPCoopErrore: " + e.getMessage())));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Hashtable<?, ?> getWSSPropertiesRequest(Busta bustaRichiesta, ConfigurazionePdDReader configurazionePdDReader, StateMessage state, MsgDiagnostico msgDiag, Logger logCore, OpenSPCoopProperties properties, RuoloBustaEGov ruoloBustaEgovRicevuta, String implementazionePdDMittente) throws DriverConfigurazioneException {
        Hashtable<String, String> wssPropertiesRequest = null;
        ProfiloDiCollaborazione profiloCollaborazione = null;
        try {
            block16: {
                try {
                    IDPortaApplicativa idPA;
                    IDPortaDelegata idPD;
                    RepositoryEGov repository;
                    Integrazione integrazione;
                    if (bustaRichiesta.getProfiloDiCollaborazione() == null && bustaRichiesta.sizeListaRiscontri() > 0 && properties.isGestioneRiscontri(implementazionePdDMittente) && (integrazione = (repository = new RepositoryEGov((IState)state, true)).getInfoIntegrazioneFromOutBox(bustaRichiesta.getRiscontro(0).getID())).getLocationPD() != null) {
                        idPD = new IDPortaDelegata();
                        idPD.setLocationPD(integrazione.getLocationPD());
                        idPD.setSoggettoFruitore(new IDSoggetto(bustaRichiesta.getTipoDestinatario(), bustaRichiesta.getDestinatario()));
                        wssPropertiesRequest = configurazionePdDReader.getPD_WSSForReceiver(configurazionePdDReader.getPortaDelegata_SafeMethod(idPD));
                    }
                    if ("EGOV_IT_MessaggioSingoloOneWay".equals(bustaRichiesta.getProfiloDiCollaborazione()) || "EGOV_IT_ServizioSincrono".equals(bustaRichiesta.getProfiloDiCollaborazione())) {
                        if (bustaRichiesta.getRiferimentoMessaggio() == null) {
                            idPA = new IDPortaApplicativa();
                            idPA.setIDServizio(new IDServizio(bustaRichiesta.getTipoDestinatario(), bustaRichiesta.getDestinatario(), bustaRichiesta.getTipoServizio(), bustaRichiesta.getServizio(), bustaRichiesta.getAzione()));
                            wssPropertiesRequest = configurazionePdDReader.getPA_WSSForReceiver(configurazionePdDReader.getPortaApplicativa_SafeMethod(idPA, this.msgContext.getProprietaFiltroPortaApplicativa()));
                            break block16;
                        } else {
                            repository = new RepositoryEGov((IState)state, false);
                            integrazione = repository.getInfoIntegrazioneFromOutBox(bustaRichiesta.getRiferimentoMessaggio());
                            idPD = new IDPortaDelegata();
                            idPD.setLocationPD(integrazione.getLocationPD());
                            idPD.setSoggettoFruitore(new IDSoggetto(bustaRichiesta.getTipoDestinatario(), bustaRichiesta.getDestinatario()));
                            wssPropertiesRequest = configurazionePdDReader.getPD_WSSForReceiver(configurazionePdDReader.getPortaDelegata_SafeMethod(idPD));
                        }
                        break block16;
                    }
                    if ("EGOV_IT_ServizioAsincronoSimmetrico".equals(bustaRichiesta.getProfiloDiCollaborazione())) {
                        if (bustaRichiesta.getRiferimentoMessaggio() == null) {
                            idPA = new IDPortaApplicativa();
                            idPA.setIDServizio(new IDServizio(bustaRichiesta.getTipoDestinatario(), bustaRichiesta.getDestinatario(), bustaRichiesta.getTipoServizio(), bustaRichiesta.getServizio(), bustaRichiesta.getAzione()));
                            wssPropertiesRequest = configurazionePdDReader.getPA_WSSForReceiver(configurazionePdDReader.getPortaApplicativa_SafeMethod(idPA, this.msgContext.getProprietaFiltroPortaApplicativa()));
                            break block16;
                        }
                        if (RuoloBustaEGov.RISPOSTA.equals(ruoloBustaEgovRicevuta.toString())) {
                            repository = new RepositoryEGov((IState)state, false);
                            integrazione = repository.getInfoIntegrazioneFromOutBox(bustaRichiesta.getRiferimentoMessaggio());
                            idPD = new IDPortaDelegata();
                            idPD.setLocationPD(integrazione.getLocationPD());
                            idPD.setSoggettoFruitore(new IDSoggetto(bustaRichiesta.getTipoDestinatario(), bustaRichiesta.getDestinatario()));
                            wssPropertiesRequest = configurazionePdDReader.getPD_WSSForSender(configurazionePdDReader.getPortaDelegata_SafeMethod(idPD));
                            break block16;
                        }
                        if (RuoloBustaEGov.RICEVUTA_RICHIESTA.equals(ruoloBustaEgovRicevuta.toString())) {
                            repository = new RepositoryEGov((IState)state, true);
                            integrazione = repository.getInfoIntegrazioneFromOutBox(bustaRichiesta.getRiferimentoMessaggio());
                            idPD = new IDPortaDelegata();
                            idPD.setLocationPD(integrazione.getLocationPD());
                            idPD.setSoggettoFruitore(new IDSoggetto(bustaRichiesta.getTipoDestinatario(), bustaRichiesta.getDestinatario()));
                            wssPropertiesRequest = configurazionePdDReader.getPD_WSSForReceiver(configurazionePdDReader.getPortaDelegata_SafeMethod(idPD));
                            break block16;
                        }
                        if (RuoloBustaEGov.RICEVUTA_RISPOSTA.equals(ruoloBustaEgovRicevuta.toString())) {
                            repository = new RepositoryEGov((IState)state, false);
                            integrazione = repository.getInfoIntegrazioneFromOutBox(bustaRichiesta.getRiferimentoMessaggio());
                            idPD = new IDPortaDelegata();
                            idPD.setLocationPD(integrazione.getLocationPD());
                            idPD.setSoggettoFruitore(new IDSoggetto(bustaRichiesta.getTipoDestinatario(), bustaRichiesta.getDestinatario()));
                            wssPropertiesRequest = configurazionePdDReader.getPD_WSSForReceiver(configurazionePdDReader.getPortaDelegata_SafeMethod(idPD));
                        }
                        break block16;
                    }
                    if (!"EGOV_IT_ServizioAsincronoAsimmetrico".equals(bustaRichiesta.getProfiloDiCollaborazione())) break block16;
                    if (bustaRichiesta.getRiferimentoMessaggio() == null) {
                        idPA = new IDPortaApplicativa();
                        idPA.setIDServizio(new IDServizio(bustaRichiesta.getTipoDestinatario(), bustaRichiesta.getDestinatario(), bustaRichiesta.getTipoServizio(), bustaRichiesta.getServizio(), bustaRichiesta.getAzione()));
                        wssPropertiesRequest = configurazionePdDReader.getPA_WSSForReceiver(configurazionePdDReader.getPortaApplicativa_SafeMethod(idPA, this.msgContext.getProprietaFiltroPortaApplicativa()));
                        break block16;
                    }
                    profiloCollaborazione = new ProfiloDiCollaborazione((IState)state);
                    if (RuoloBustaEGov.RISPOSTA.equals(ruoloBustaEgovRicevuta.toString())) {
                        idPA = new IDPortaApplicativa();
                        IDServizio idServizioOriginale = profiloCollaborazione.asincronoAsimmetrico_getDatiConsegnaRisposta(bustaRichiesta.getRiferimentoMessaggio());
                        idPA.setIDServizio(new IDServizio(bustaRichiesta.getTipoDestinatario(), bustaRichiesta.getDestinatario(), idServizioOriginale.getTipoServizio(), idServizioOriginale.getServizio(), idServizioOriginale.getAzione()));
                        wssPropertiesRequest = configurazionePdDReader.getPA_WSSForReceiver(configurazionePdDReader.getPortaApplicativa_SafeMethod(idPA, this.msgContext.getProprietaFiltroPortaApplicativa()));
                        break block16;
                    }
                    if (RuoloBustaEGov.RICEVUTA_RICHIESTA.equals(ruoloBustaEgovRicevuta.toString())) {
                        repository = new RepositoryEGov((IState)state, true);
                        integrazione = repository.getInfoIntegrazioneFromOutBox(bustaRichiesta.getRiferimentoMessaggio());
                        idPD = new IDPortaDelegata();
                        idPD.setLocationPD(integrazione.getLocationPD());
                        idPD.setSoggettoFruitore(new IDSoggetto(bustaRichiesta.getTipoDestinatario(), bustaRichiesta.getDestinatario()));
                        wssPropertiesRequest = configurazionePdDReader.getPD_WSSForReceiver(configurazionePdDReader.getPortaDelegata_SafeMethod(idPD));
                        break block16;
                    }
                    if (!RuoloBustaEGov.RICEVUTA_RISPOSTA.equals(ruoloBustaEgovRicevuta.toString())) break block16;
                    repository = new RepositoryEGov((IState)state, false);
                    integrazione = repository.getInfoIntegrazioneFromOutBox(bustaRichiesta.getRiferimentoMessaggio());
                    idPD = new IDPortaDelegata();
                    idPD.setLocationPD(integrazione.getLocationPD());
                    idPD.setSoggettoFruitore(new IDSoggetto(bustaRichiesta.getTipoDestinatario(), bustaRichiesta.getDestinatario()));
                    wssPropertiesRequest = configurazionePdDReader.getPD_WSSForReceiver(configurazionePdDReader.getPortaDelegata_SafeMethod(idPD));
                }
                catch (Exception e) {
                    msgDiag.logErroreGenerico(e, "letturaWSSecurityRequestProperties");
                    logCore.error((Object)"Lettura dati WS-Security per la ricezione del messaggio SPCoop non riuscita", (Throwable)e);
                    Object var15_16 = null;
                    if (profiloCollaborazione == null) return wssPropertiesRequest;
                    state.closePreparedStatement();
                    return wssPropertiesRequest;
                }
            }
            Object var15_15 = null;
            if (profiloCollaborazione == null) return wssPropertiesRequest;
            state.closePreparedStatement();
            return wssPropertiesRequest;
        }
        catch (Throwable throwable) {
            Object var15_17 = null;
            if (profiloCollaborazione == null) throw throwable;
            state.closePreparedStatement();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Hashtable<?, ?> getWSSPropertiesResponse(Busta bustaRichiesta, ConfigurazionePdDReader configurazionePdDReader, StateMessage state, MsgDiagnostico msgDiag, Logger logCore, OpenSPCoopProperties properties, RuoloBustaEGov ruoloBustaEgovRicevuta, String implementazionePdDMittente) throws DriverConfigurazioneException {
        Hashtable<String, String> wssPropertiesRequest = null;
        ProfiloDiCollaborazione profiloCollaborazione = null;
        try {
            block11: {
                try {
                    if (bustaRichiesta.getProfiloDiCollaborazione() == null && bustaRichiesta.sizeListaRiscontri() > 0 && properties.isGestioneRiscontri(implementazionePdDMittente)) {
                        if (bustaRichiesta.getTipoServizio() != null && bustaRichiesta.getServizio() != null) {
                            IDPortaApplicativa idPA = new IDPortaApplicativa();
                            idPA.setIDServizio(new IDServizio(bustaRichiesta.getTipoDestinatario(), bustaRichiesta.getDestinatario(), bustaRichiesta.getTipoServizio(), bustaRichiesta.getServizio(), bustaRichiesta.getAzione()));
                            wssPropertiesRequest = configurazionePdDReader.getPA_WSSForSender(configurazionePdDReader.getPortaApplicativa_SafeMethod(idPA, this.msgContext.getProprietaFiltroPortaApplicativa()));
                        }
                        break block11;
                    }
                    if ("EGOV_IT_MessaggioSingoloOneWay".equals(bustaRichiesta.getProfiloDiCollaborazione()) || "EGOV_IT_ServizioSincrono".equals(bustaRichiesta.getProfiloDiCollaborazione())) {
                        IDPortaApplicativa idPA = new IDPortaApplicativa();
                        idPA.setIDServizio(new IDServizio(bustaRichiesta.getTipoDestinatario(), bustaRichiesta.getDestinatario(), bustaRichiesta.getTipoServizio(), bustaRichiesta.getServizio(), bustaRichiesta.getAzione()));
                        wssPropertiesRequest = configurazionePdDReader.getPA_WSSForSender(configurazionePdDReader.getPortaApplicativa_SafeMethod(idPA, this.msgContext.getProprietaFiltroPortaApplicativa()));
                        break block11;
                    }
                    if ("EGOV_IT_ServizioAsincronoSimmetrico".equals(bustaRichiesta.getProfiloDiCollaborazione())) {
                        if (bustaRichiesta.getRiferimentoMessaggio() == null) {
                            IDPortaApplicativa idPA = new IDPortaApplicativa();
                            idPA.setIDServizio(new IDServizio(bustaRichiesta.getTipoDestinatario(), bustaRichiesta.getDestinatario(), bustaRichiesta.getTipoServizio(), bustaRichiesta.getServizio(), bustaRichiesta.getAzione()));
                            wssPropertiesRequest = configurazionePdDReader.getPA_WSSForSender(configurazionePdDReader.getPortaApplicativa_SafeMethod(idPA, this.msgContext.getProprietaFiltroPortaApplicativa()));
                            break block11;
                        }
                        if (RuoloBustaEGov.RISPOSTA.equals(ruoloBustaEgovRicevuta.toString())) {
                            RepositoryEGov repository = new RepositoryEGov((IState)state, false);
                            Integrazione integrazione = repository.getInfoIntegrazioneFromOutBox(bustaRichiesta.getRiferimentoMessaggio());
                            IDPortaDelegata idPD = new IDPortaDelegata();
                            idPD.setLocationPD(integrazione.getLocationPD());
                            idPD.setSoggettoFruitore(new IDSoggetto(bustaRichiesta.getTipoDestinatario(), bustaRichiesta.getDestinatario()));
                            wssPropertiesRequest = configurazionePdDReader.getPD_WSSForSender(configurazionePdDReader.getPortaDelegata_SafeMethod(idPD));
                        }
                        break block11;
                    }
                    if (!"EGOV_IT_ServizioAsincronoAsimmetrico".equals(bustaRichiesta.getProfiloDiCollaborazione())) break block11;
                    profiloCollaborazione = new ProfiloDiCollaborazione((IState)state);
                    if (bustaRichiesta.getRiferimentoMessaggio() == null) {
                        IDPortaApplicativa idPA = new IDPortaApplicativa();
                        idPA.setIDServizio(new IDServizio(bustaRichiesta.getTipoDestinatario(), bustaRichiesta.getDestinatario(), bustaRichiesta.getTipoServizio(), bustaRichiesta.getServizio(), bustaRichiesta.getAzione()));
                        wssPropertiesRequest = configurazionePdDReader.getPA_WSSForSender(configurazionePdDReader.getPortaApplicativa_SafeMethod(idPA, this.msgContext.getProprietaFiltroPortaApplicativa()));
                        break block11;
                    }
                    if (!RuoloBustaEGov.RISPOSTA.equals(ruoloBustaEgovRicevuta.toString())) break block11;
                    IDPortaApplicativa idPA = new IDPortaApplicativa();
                    IDServizio idServizioOriginale = profiloCollaborazione.asincronoAsimmetrico_getDatiConsegnaRisposta(bustaRichiesta.getRiferimentoMessaggio());
                    idPA.setIDServizio(new IDServizio(bustaRichiesta.getTipoDestinatario(), bustaRichiesta.getDestinatario(), idServizioOriginale.getTipoServizio(), idServizioOriginale.getServizio(), idServizioOriginale.getAzione()));
                    wssPropertiesRequest = configurazionePdDReader.getPA_WSSForSender(configurazionePdDReader.getPortaApplicativa_SafeMethod(idPA, this.msgContext.getProprietaFiltroPortaApplicativa()));
                }
                catch (Exception e) {
                    msgDiag.logErroreGenerico(e, "letturaWSSecurityResponseProperties");
                    logCore.error((Object)"Lettura dati WS-Security per la spedizione del messaggio SPCoop di risposta non riuscita", (Throwable)e);
                    Object var15_22 = null;
                    if (profiloCollaborazione == null) return wssPropertiesRequest;
                    state.closePreparedStatement();
                    return wssPropertiesRequest;
                }
            }
            Object var15_21 = null;
            if (profiloCollaborazione == null) return wssPropertiesRequest;
            state.closePreparedStatement();
            return wssPropertiesRequest;
        }
        catch (Throwable throwable) {
            Object var15_23 = null;
            if (profiloCollaborazione == null) throw throwable;
            state.closePreparedStatement();
            throw throwable;
        }
    }

    private boolean gestioneRispostaAsincrona_checkPresenzaRichiesta(long scadenzaControllo, int checkInterval, Busta bustaRichiesta, IOpenSPCoopState openspcoopstate, MsgDiagnostico msgDiag, boolean newConnectionForResponse) throws Exception {
        boolean attendiTerminazioneRichiesta = false;
        boolean isRicevutaRichiesta = false;
        boolean isRicevutaRisposta = false;
        if (newConnectionForResponse && ("EGOV_IT_ServizioAsincronoSimmetrico".equals(bustaRichiesta.getProfiloDiCollaborazione()) || "EGOV_IT_ServizioAsincronoAsimmetrico".equals(bustaRichiesta.getProfiloDiCollaborazione())) && bustaRichiesta.getRiferimentoMessaggio() != null) {
            ProfiloDiCollaborazione profiloCollaborazione = new ProfiloDiCollaborazione(openspcoopstate.getStatoRichiesta());
            isRicevutaRichiesta = profiloCollaborazione.asincrono_isRicevutaRichiesta(bustaRichiesta.getRiferimentoMessaggio());
            isRicevutaRisposta = profiloCollaborazione.asincrono_isRicevutaRisposta(bustaRichiesta.getRiferimentoMessaggio());
        }
        while (DateManager.getTimeMillis() < scadenzaControllo) {
            GestoreMessaggi checkRichiesta;
            String idRichiesta;
            msgDiag.mediumDebug("RICHIESTA  NOW[" + DateManager.getTimeMillis() + "] < SCADENZA[" + scadenzaControllo + "]");
            if ("EGOV_IT_ServizioAsincronoSimmetrico".equals(bustaRichiesta.getProfiloDiCollaborazione())) {
                if (bustaRichiesta.getRiferimentoMessaggio() == null && (bustaRichiesta.getCollaborazione() == null || bustaRichiesta.getCollaborazione().equals(bustaRichiesta.getID())) || newConnectionForResponse && (!newConnectionForResponse || isRicevutaRichiesta || isRicevutaRisposta)) break;
                idRichiesta = bustaRichiesta.getRiferimentoMessaggio();
                if (idRichiesta == null) {
                    idRichiesta = bustaRichiesta.getCollaborazione();
                }
                if (!(attendiTerminazioneRichiesta = (checkRichiesta = new GestoreMessaggi(openspcoopstate, false, idRichiesta, "OUTBOX", msgDiag)).existsMessageInProcessamento())) {
                    break;
                }
            } else {
                if (!"EGOV_IT_ServizioAsincronoAsimmetrico".equals(bustaRichiesta.getProfiloDiCollaborazione()) || bustaRichiesta.getRiferimentoMessaggio() == null && (bustaRichiesta.getCollaborazione() == null || bustaRichiesta.getCollaborazione().equals(bustaRichiesta.getID())) || newConnectionForResponse && (!newConnectionForResponse || isRicevutaRichiesta || isRicevutaRisposta)) break;
                idRichiesta = bustaRichiesta.getRiferimentoMessaggio();
                if (idRichiesta == null) {
                    idRichiesta = bustaRichiesta.getCollaborazione();
                }
                if (!(attendiTerminazioneRichiesta = (checkRichiesta = new GestoreMessaggi(openspcoopstate, false, idRichiesta, "INBOX", msgDiag)).existsMessageInProcessamento())) break;
            }
            msgDiag.mediumDebug("Busta di risposta con profilo [" + bustaRichiesta.getProfiloDiCollaborazione() + "] non gestibile, si attende il completamento" + " della gestione della richiesta");
            try {
                Thread.sleep(checkInterval);
            }
            catch (Exception eRandom) {}
        }
        return attendiTerminazioneRichiesta;
    }

    private boolean gestioneRispostaAsincrona_checkPresenzaRicevutaRichiesta(long scadenzaControllo, int checkInterval, Busta bustaRichiesta, IOpenSPCoopState openspcoopstate, MsgDiagnostico msgDiag, boolean newConnectionForResponse) throws Exception {
        boolean attendiTerminazioneRicevutaRichiesta = false;
        boolean isRicevutaRichiesta = false;
        boolean isRicevutaRisposta = false;
        if (newConnectionForResponse && ("EGOV_IT_ServizioAsincronoSimmetrico".equals(bustaRichiesta.getProfiloDiCollaborazione()) || "EGOV_IT_ServizioAsincronoAsimmetrico".equals(bustaRichiesta.getProfiloDiCollaborazione())) && bustaRichiesta.getRiferimentoMessaggio() != null) {
            ProfiloDiCollaborazione profiloCollaborazione = new ProfiloDiCollaborazione(openspcoopstate.getStatoRichiesta());
            isRicevutaRichiesta = profiloCollaborazione.asincrono_isRicevutaRichiesta(bustaRichiesta.getRiferimentoMessaggio());
            isRicevutaRisposta = profiloCollaborazione.asincrono_isRicevutaRisposta(bustaRichiesta.getRiferimentoMessaggio());
        }
        while (DateManager.getTimeMillis() < scadenzaControllo) {
            GestoreMessaggi checkRicevutaRichiesta;
            String idRicevutaRichiesta;
            msgDiag.mediumDebug("RICEVUTA RICHIESTA  NOW[" + DateManager.getTimeMillis() + "] < SCADENZA[" + scadenzaControllo + "]");
            if ("EGOV_IT_ServizioAsincronoSimmetrico".equals(bustaRichiesta.getProfiloDiCollaborazione())) {
                if (bustaRichiesta.getRiferimentoMessaggio() == null && (bustaRichiesta.getCollaborazione() == null || bustaRichiesta.getCollaborazione().equals(bustaRichiesta.getID())) || newConnectionForResponse && (!newConnectionForResponse || isRicevutaRichiesta || isRicevutaRisposta)) break;
                idRicevutaRichiesta = bustaRichiesta.getRiferimentoMessaggio();
                if (idRicevutaRichiesta == null) {
                    idRicevutaRichiesta = bustaRichiesta.getCollaborazione();
                }
                if (!(attendiTerminazioneRicevutaRichiesta = (checkRicevutaRichiesta = new GestoreMessaggi(openspcoopstate, false, idRicevutaRichiesta, "INBOX", msgDiag)).existsMessageInProcessamentoByReference())) {
                    break;
                }
            } else {
                if (!"EGOV_IT_ServizioAsincronoAsimmetrico".equals(bustaRichiesta.getProfiloDiCollaborazione()) || bustaRichiesta.getRiferimentoMessaggio() == null && (bustaRichiesta.getCollaborazione() == null || bustaRichiesta.getCollaborazione().equals(bustaRichiesta.getID())) || newConnectionForResponse && (!newConnectionForResponse || isRicevutaRichiesta || isRicevutaRisposta)) break;
                idRicevutaRichiesta = bustaRichiesta.getRiferimentoMessaggio();
                if (idRicevutaRichiesta == null) {
                    idRicevutaRichiesta = bustaRichiesta.getCollaborazione();
                }
                if (!(attendiTerminazioneRicevutaRichiesta = (checkRicevutaRichiesta = new GestoreMessaggi(openspcoopstate, false, idRicevutaRichiesta, "OUTBOX", msgDiag)).existsMessageInProcessamentoByReference())) break;
            }
            msgDiag.mediumDebug("Busta di risposta con profilo [" + bustaRichiesta.getProfiloDiCollaborazione() + "] non gestibile, si attende il completamento" + " della gestione della ricevuta alla richiesta");
            try {
                Thread.sleep(checkInterval);
            }
            catch (Exception eRandom) {}
        }
        return attendiTerminazioneRicevutaRichiesta;
    }

    private Message generaRisposta_msgGiaRicevuto(boolean printMsg, Busta bustaRichiesta, MsgDiagnostico msgDiag, IOpenSPCoopState openspcoopstate, Logger log, ConfigurazionePdDReader config, OpenSPCoopProperties properties, String profiloGestione, RuoloBustaEGov ruoloBustaEgovRicevuta, String implementazionePdDMittente) throws EGovException {
        RepositoryEGov repositoryEGov = new RepositoryEGov(openspcoopstate.getStatoRichiesta(), true);
        Busta bustaHTTPReply = null;
        if (printMsg) {
            msgDiag.logPersonalizzato("sbustamentoBustaEGov.", "ricezioneBustaDuplicata");
        }
        if ("EGOV_IT_MessaggioSingoloOneWay".equals(bustaRichiesta.getProfiloDiCollaborazione()) && bustaRichiesta.getConfermaRicezione() && !"eGov1.1-lineeGuida1.1".equals(profiloGestione) && properties.isGestioneRiscontri(implementazionePdDMittente)) {
            msgDiag.logPersonalizzato("generazioneRiscontro");
            bustaHTTPReply = bustaRichiesta.invertiBusta(properties.getTipoTempoEGov(implementazionePdDMittente));
            Riscontro r = new Riscontro();
            r.setID(bustaHTTPReply.getID());
            r.setOraRegistrazione(DateManager.getDate());
            r.setTipoOraRegistrazione(properties.getTipoTempoEGov(implementazionePdDMittente));
            bustaHTTPReply.addRiscontro(r);
        } else if ("EGOV_IT_ServizioAsincronoSimmetrico".equals(bustaRichiesta.getProfiloDiCollaborazione()) || "EGOV_IT_ServizioAsincronoAsimmetrico".equals(bustaRichiesta.getProfiloDiCollaborazione())) {
            String ricevuta = null;
            if ("EGOV_IT_ServizioAsincronoSimmetrico".equals(bustaRichiesta.getProfiloDiCollaborazione())) {
                if (bustaRichiesta.getRiferimentoMessaggio() == null) {
                    ricevuta = "ricevuta di una richiesta asincrona simmetrica";
                } else if (ruoloBustaEgovRicevuta != null && RuoloBustaEGov.RISPOSTA.equals(ruoloBustaEgovRicevuta.toString())) {
                    ricevuta = "ricevuta di una risposta asincrona simmetrica";
                }
            } else if (bustaRichiesta.getRiferimentoMessaggio() == null) {
                ricevuta = "ricevuta di una richiesta asincrona asimmetrica";
            } else if (ruoloBustaEgovRicevuta != null && RuoloBustaEGov.RISPOSTA.equals(ruoloBustaEgovRicevuta.toString())) {
                ricevuta = "ricevuta di una risposta asincrona asimmetrica";
            }
            if (ricevuta != null) {
                msgDiag.addKeyword("@TIPO_RICEVUTA_ASINCRONA@", ricevuta);
                msgDiag.logPersonalizzato("generazioneRicevutaAsincrona");
                bustaHTTPReply = bustaRichiesta.invertiBusta(properties.getTipoTempoEGov(implementazionePdDMittente));
                bustaHTTPReply.setServizio(bustaRichiesta.getServizio());
                bustaHTTPReply.setTipoServizio(bustaRichiesta.getTipoServizio());
                bustaHTTPReply.setAzione(bustaRichiesta.getAzione());
                bustaHTTPReply.setProfiloDiCollaborazione("EGOV_IT_ServizioAsincronoSimmetrico");
                bustaHTTPReply.setRiferimentoMessaggio(bustaRichiesta.getID());
                if (properties.isGestioneElementoCollaborazione(implementazionePdDMittente)) {
                    bustaHTTPReply.setCollaborazione(bustaRichiesta.getCollaborazione());
                }
            }
        }
        try {
            repositoryEGov.aggiornaDuplicatiIntoInBox(bustaRichiesta.getID());
            openspcoopstate.commit();
        }
        catch (Exception e) {
            log.error((Object)("Aggiornamento numero duplicati per busta [" + bustaRichiesta.getID() + "] non riuscito: " + e.getMessage()));
        }
        if (bustaHTTPReply == null) {
            return SoapUtils.build_Soap_Empty();
        }
        Imbustamento imbustatore = new Imbustamento(log);
        Message msg = SoapUtils.build_Soap_Empty();
        imbustatore.imbustamentoEGov(msg, bustaHTTPReply, false, false, false, false, null);
        return msg;
    }

    private EsitoLib chiamaLibreria(OpenSPCoopStateless openspcoopstate, Logger log) throws OpenSPCoopStateException {
        if (openspcoopstate.getDestinatarioRequestMsgLib().startsWith("Sbustamento")) {
            Sbustamento lib = new Sbustamento(log);
            return lib.onMessage(openspcoopstate);
        }
        if (openspcoopstate.getDestinatarioRequestMsgLib().startsWith("ConsegnaContenutiApplicativi")) {
            ConsegnaContenutiApplicativi lib = new ConsegnaContenutiApplicativi(log);
            EsitoLib result = lib.onMessage(openspcoopstate);
            if (result.getStatoInvocazione() == 1) {
                openspcoopstate.setDestinatarioRequestMsgLib("");
            }
            return result;
        }
        if (openspcoopstate.getDestinatarioResponseMsgLib().startsWith("ImbustamentoRisposte")) {
            ImbustamentoRisposte lib = new ImbustamentoRisposte(log);
            return lib.onMessage(openspcoopstate);
        }
        if (openspcoopstate.getDestinatarioResponseMsgLib().startsWith("InoltroRisposteEGov")) {
            InoltroRisposteEGov lib = new InoltroRisposteEGov(log);
            return lib.onMessage(openspcoopstate);
        }
        throw new OpenSPCoopStateException("RicezioneBusteEGov.chiamaLibreria: nome libreria non valido");
    }

    private IDServizio getIdServizioPerAutorizzazione(IDServizio idServizio, IDSoggetto soggettoFruitore, boolean functionAsRouter, Busta bustaRichiesta, RuoloBustaEGov ruoloBustaEgovRicevuta) {
        IDServizio idServizioPerAutorizzazione = new IDServizio();
        idServizioPerAutorizzazione.setServizio(idServizio.getServizio());
        idServizioPerAutorizzazione.setTipoServizio(idServizio.getTipoServizio());
        idServizioPerAutorizzazione.setUriAccordo(idServizio.getUriAccordo());
        idServizioPerAutorizzazione.setAzione(idServizio.getAzione());
        idServizioPerAutorizzazione.setCorrelato(idServizio.isCorrelato());
        IDSoggetto soggettoDestinatarioPerAutorizzazione = null;
        soggettoDestinatarioPerAutorizzazione = functionAsRouter ? new IDSoggetto(idServizio.getSoggettoErogatore().getTipo(), idServizio.getSoggettoErogatore().getNome()) : ("EGOV_IT_MessaggioSingoloOneWay".equals(bustaRichiesta.getProfiloDiCollaborazione()) || "EGOV_IT_ServizioSincrono".equals(bustaRichiesta.getProfiloDiCollaborazione()) ? new IDSoggetto(idServizio.getSoggettoErogatore().getTipo(), idServizio.getSoggettoErogatore().getNome()) : ("EGOV_IT_ServizioAsincronoSimmetrico".equals(bustaRichiesta.getProfiloDiCollaborazione()) ? (ruoloBustaEgovRicevuta == null ? new IDSoggetto(idServizio.getSoggettoErogatore().getTipo(), idServizio.getSoggettoErogatore().getNome()) : (RuoloBustaEGov.RICHIESTA.equals(ruoloBustaEgovRicevuta.toString()) || RuoloBustaEGov.RISPOSTA.equals(ruoloBustaEgovRicevuta.toString()) ? new IDSoggetto(idServizio.getSoggettoErogatore().getTipo(), idServizio.getSoggettoErogatore().getNome()) : new IDSoggetto(soggettoFruitore.getTipo(), soggettoFruitore.getNome()))) : ("EGOV_IT_ServizioAsincronoAsimmetrico".equals(bustaRichiesta.getProfiloDiCollaborazione()) ? (ruoloBustaEgovRicevuta == null ? new IDSoggetto(idServizio.getSoggettoErogatore().getTipo(), idServizio.getSoggettoErogatore().getNome()) : (RuoloBustaEGov.RICHIESTA.equals(ruoloBustaEgovRicevuta.toString()) || RuoloBustaEGov.RISPOSTA.equals(ruoloBustaEgovRicevuta.toString()) ? new IDSoggetto(idServizio.getSoggettoErogatore().getTipo(), idServizio.getSoggettoErogatore().getNome()) : new IDSoggetto(soggettoFruitore.getTipo(), soggettoFruitore.getNome()))) : new IDSoggetto(idServizio.getSoggettoErogatore().getTipo(), idServizio.getSoggettoErogatore().getNome()))));
        idServizioPerAutorizzazione.setSoggettoErogatore(soggettoDestinatarioPerAutorizzazione);
        return idServizioPerAutorizzazione;
    }

    private IDSoggetto getIDSoggettoMittentePerAutorizzazione(IDServizio idServizio, IDSoggetto soggettoFruitore, boolean functionAsRouter, Busta bustaRichiesta, RuoloBustaEGov ruoloBustaEgovRicevuta) {
        IDSoggetto soggettoMittentePerAutorizzazione = null;
        soggettoMittentePerAutorizzazione = functionAsRouter ? new IDSoggetto(soggettoFruitore.getTipo(), soggettoFruitore.getNome()) : ("EGOV_IT_MessaggioSingoloOneWay".equals(bustaRichiesta.getProfiloDiCollaborazione()) || "EGOV_IT_ServizioSincrono".equals(bustaRichiesta.getProfiloDiCollaborazione()) ? new IDSoggetto(soggettoFruitore.getTipo(), soggettoFruitore.getNome()) : ("EGOV_IT_ServizioAsincronoSimmetrico".equals(bustaRichiesta.getProfiloDiCollaborazione()) ? (ruoloBustaEgovRicevuta == null ? new IDSoggetto(soggettoFruitore.getTipo(), soggettoFruitore.getNome()) : (RuoloBustaEGov.RICHIESTA.equals(ruoloBustaEgovRicevuta.toString()) || RuoloBustaEGov.RISPOSTA.equals(ruoloBustaEgovRicevuta.toString()) ? new IDSoggetto(soggettoFruitore.getTipo(), soggettoFruitore.getNome()) : new IDSoggetto(idServizio.getSoggettoErogatore().getTipo(), idServizio.getSoggettoErogatore().getNome()))) : ("EGOV_IT_ServizioAsincronoAsimmetrico".equals(bustaRichiesta.getProfiloDiCollaborazione()) ? (ruoloBustaEgovRicevuta == null ? new IDSoggetto(soggettoFruitore.getTipo(), soggettoFruitore.getNome()) : (RuoloBustaEGov.RICHIESTA.equals(ruoloBustaEgovRicevuta.toString()) || RuoloBustaEGov.RISPOSTA.equals(ruoloBustaEgovRicevuta.toString()) ? new IDSoggetto(soggettoFruitore.getTipo(), soggettoFruitore.getNome()) : new IDSoggetto(idServizio.getSoggettoErogatore().getTipo(), idServizio.getSoggettoErogatore().getNome()))) : new IDSoggetto(soggettoFruitore.getTipo(), soggettoFruitore.getNome()))));
        return soggettoMittentePerAutorizzazione;
    }
}

