/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop.pdd.services;

import java.rmi.RemoteException;
import java.util.Properties;
import java.util.Random;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.sql.DataSource;
import org.apache.log4j.Logger;
import org.openspcoop.dao.commons.DBUtils;
import org.openspcoop.dao.commons.IDSoggetto;
import org.openspcoop.dao.config.AccessoConfigurazionePdD;
import org.openspcoop.dao.config.AccessoRegistro;
import org.openspcoop.dao.config.AccessoRegistroRegistro;
import org.openspcoop.egov.Configurazione;
import org.openspcoop.egov.ConfigurazioneGenerazioneBusta;
import org.openspcoop.egov.IGestoreRepositoryEGov;
import org.openspcoop.egov.ValidazioneConSchemaSPCoop;
import org.openspcoop.pdd.config.ClassNameProperties;
import org.openspcoop.pdd.config.ConfigurazionePdDReader;
import org.openspcoop.pdd.config.DBManager;
import org.openspcoop.pdd.config.GeneralInstanceProperties;
import org.openspcoop.pdd.config.MailcapActivationReader;
import org.openspcoop.pdd.config.OpenSPCoopProperties;
import org.openspcoop.pdd.config.PddProperties;
import org.openspcoop.pdd.config.QueueManager;
import org.openspcoop.pdd.core.GestoreMessaggi;
import org.openspcoop.pdd.core.PdDContext;
import org.openspcoop.pdd.core.handlers.ExitContext;
import org.openspcoop.pdd.core.handlers.GeneratoreCasualeDate;
import org.openspcoop.pdd.core.handlers.GestoreHandlers;
import org.openspcoop.pdd.core.handlers.HandlerException;
import org.openspcoop.pdd.core.handlers.InitContext;
import org.openspcoop.pdd.core.jmx.GestoreRisorseJMX;
import org.openspcoop.pdd.logger.MsgDiagnosticiProperties;
import org.openspcoop.pdd.logger.MsgDiagnostico;
import org.openspcoop.pdd.logger.OpenSPCoopLogger;
import org.openspcoop.pdd.services.RicezioneBusteEGov;
import org.openspcoop.pdd.services.RicezioneContenutiApplicativi;
import org.openspcoop.pdd.services.ServicesUtils;
import org.openspcoop.pdd.timers.TimerGestoreBusteNonRiscontrate;
import org.openspcoop.pdd.timers.TimerGestoreMessaggi;
import org.openspcoop.pdd.timers.TimerGestoreMessaggiThread;
import org.openspcoop.pdd.timers.TimerGestorePuliziaMessaggiAnomali;
import org.openspcoop.pdd.timers.TimerGestorePuliziaMessaggiAnomaliThread;
import org.openspcoop.pdd.timers.TimerGestoreRepositoryEGov;
import org.openspcoop.pdd.timers.TimerGestoreRepositoryEGovThread;
import org.openspcoop.pdd.timers.TimerMonitoraggioRisorse;
import org.openspcoop.pdd.timers.TimerThreshold;
import org.openspcoop.registry.RegistroServiziReader;
import org.openspcoop.utils.GestoreJNDI;
import org.openspcoop.utils.Loader;
import org.openspcoop.utils.SoapUtils;
import org.openspcoop.utils.date.DateManager;
import org.openspcoop.utils.id.UniqueIdentifierManager;
import org.openspcoop.utils.xml.XMLUtils;

public class OpenSPCoopStartup
implements ServletContextListener {
    private static Logger log = Logger.getLogger((String)"openspcoop.startup");
    private static final String ID_MODULO = "InizializzazioneRisorse";
    ServletContext servletContext;
    public static boolean initialize = false;
    private TimerGestoreBusteNonRiscontrate timerRiscontri;
    private TimerGestoreMessaggi timerEliminazioneMsg;
    private TimerGestoreMessaggiThread threadEliminazioneMsg;
    private TimerGestorePuliziaMessaggiAnomali timerPuliziaMsgAnomali;
    private TimerGestorePuliziaMessaggiAnomaliThread threadPuliziaMsgAnomali;
    private TimerGestoreRepositoryEGov timerRepositoryEGov;
    private TimerGestoreRepositoryEGovThread threadRepositoryEGov;
    private TimerThreshold timerThreshold = null;
    private TimerMonitoraggioRisorse timerMonitoraggioRisorse = null;
    private GestoreRisorseJMX gestoreRisorseJMX = null;
    private boolean serverJ2EE = false;
    protected long startDate;
    private PdDContext pddContext = new PdDContext();
    private OpenSPCoopStartupThread th;

    public void contextInitialized(ServletContextEvent sce) {
        this.startDate = System.currentTimeMillis();
        this.servletContext = sce.getServletContext();
        this.th = new OpenSPCoopStartupThread();
        new Thread(this.th).start();
    }

    public void contextDestroyed(ServletContextEvent sce) {
        try {
            ExitContext context = new ExitContext();
            context.setPddContext(this.pddContext);
            context.setLogConsole(log);
            context.setLogCore(OpenSPCoopLogger.getLoggerOpenSPCoopCore());
            GestoreHandlers.exit(context);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (this.serverJ2EE) {
            try {
                if (this.timerRiscontri != null) {
                    this.timerRiscontri.stop();
                }
            }
            catch (RemoteException e) {
                // empty catch block
            }
            try {
                if (this.timerEliminazioneMsg != null) {
                    this.timerEliminazioneMsg.stop();
                }
            }
            catch (RemoteException e) {
                // empty catch block
            }
            try {
                if (this.timerPuliziaMsgAnomali != null) {
                    this.timerPuliziaMsgAnomali.stop();
                }
            }
            catch (RemoteException e) {
                // empty catch block
            }
            try {
                if (this.timerRepositoryEGov != null) {
                    this.timerRepositoryEGov.stop();
                }
            }
            catch (RemoteException e) {}
        } else {
            try {
                if (this.threadEliminazioneMsg != null) {
                    this.threadEliminazioneMsg.setStop(true);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                if (this.threadPuliziaMsgAnomali != null) {
                    this.threadPuliziaMsgAnomali.setStop(true);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                if (this.threadRepositoryEGov != null) {
                    this.threadRepositoryEGov.setStop(true);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        try {
            if (this.timerMonitoraggioRisorse != null) {
                this.timerMonitoraggioRisorse.setStop(true);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            if (this.timerThreshold != null) {
                this.timerThreshold.setStop(true);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.gestoreRisorseJMX != null) {
            this.gestoreRisorseJMX.unregisterMBeans();
        }
        DateManager.close();
    }

    class OpenSPCoopStartupThread
    implements Runnable {
        public void run() {
            boolean isInitializeValidatoreEGovXSD;
            MsgDiagnosticiProperties msgDiagProperties;
            if (!OpenSPCoopLogger.initializeLogConsole(log)) {
                return;
            }
            if (!ClassNameProperties.initialize()) {
                log.error((Object)"Riscontrato errore durante l'inizializzazione del reader di 'className.properties'");
                return;
            }
            ClassNameProperties classNameReader = ClassNameProperties.getInstance();
            GeneralInstanceProperties instanceProperties = new GeneralInstanceProperties();
            Object[] o = null;
            Properties openspcoopP = null;
            Properties classNameP = null;
            Properties loggerP = null;
            Properties localConfig = null;
            try {
                o = instanceProperties.reads(log);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                if (o != null) {
                    Loader.initialize((ClassLoader)((ClassLoader)o[0]));
                    try {
                        openspcoopP = (Properties)o[1];
                        classNameP = (Properties)o[2];
                        loggerP = (Properties)o[4];
                        localConfig = (Properties)o[5];
                    }
                    catch (Exception e) {}
                } else {
                    Loader.initialize();
                }
            }
            catch (Exception e) {
                log.error((Object)("Loader non istanziato: " + e.getMessage()));
                return;
            }
            if (!OpenSPCoopProperties.initialize(openspcoopP)) {
                log.error((Object)"Riscontrato errore durante l'inizializzazione del reader di 'openspcoop.properties'");
                return;
            }
            OpenSPCoopProperties propertiesReader = OpenSPCoopProperties.getInstance();
            classNameReader.refreshLocalProperties(classNameP, propertiesReader.getRootDirectory());
            if (o != null ? !propertiesReader.validaConfigurazione((ClassLoader)o[0]) : !propertiesReader.validaConfigurazione(null)) {
                return;
            }
            OpenSPCoopStartup.this.serverJ2EE = propertiesReader.isServerJ2EE();
            if (propertiesReader.getClassLoader() != null) {
                try {
                    Loader.update((String)propertiesReader.getClassLoader());
                }
                catch (Exception e) {
                    log.error((Object)("Loader non aggiornato: " + e.getMessage()));
                    return;
                }
            }
            Loader loader = Loader.getInstance();
            boolean isInitializeLogger = false;
            isInitializeLogger = OpenSPCoopLogger.initialize(log, propertiesReader.getRootDirectory(), loggerP);
            if (!isInitializeLogger) {
                return;
            }
            Logger logCore = OpenSPCoopLogger.getLoggerOpenSPCoopCore();
            String locationPddProperties = null;
            if (propertiesReader.getLocationPddProperties() != null) {
                locationPddProperties = propertiesReader.getLocationPddProperties();
            }
            if (!PddProperties.initialize(locationPddProperties, propertiesReader.getRootDirectory())) {
                log.error((Object)"Riscontrato errore durante l'inizializzazione del reader di 'pdd.properties'");
                return;
            }
            if (o != null) {
                try {
                    PddProperties.updateLocalImplementation((Properties)o[3]);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            try {
                OpenSPCoopProperties.updatePddPropertiesReader(PddProperties.getInstance());
            }
            catch (Exception e) {
                log.error((Object)("Riscontrato errore durante l'assegnamento del pddPropertiesReader a OpenSPCoopPropertiesReader: " + e.getMessage()));
                return;
            }
            if (!MsgDiagnosticiProperties.initialize(null, propertiesReader.getRootDirectory())) {
                log.error((Object)"Riscontrato errore durante l'inizializzazione del reader di 'msgDiagnostici.properties'");
                return;
            }
            if (o != null) {
                try {
                    MsgDiagnosticiProperties.updateLocalImplementation((Properties)o[6]);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (!(msgDiagProperties = MsgDiagnosticiProperties.getInstance()).initializeMsgDiagnosticiPersonalizzati()) {
                return;
            }
            try {
                XMLUtils.initBuilder();
                XMLUtils.initTransformer();
                SoapUtils.initSoapFactory();
                SoapUtils.initMessageFactory();
            }
            catch (Exception e) {
                log.error((Object)("Inizializzazione Message/DOM/SOAP: " + e.getMessage()));
                return;
            }
            try {
                String tipoClass = classNameReader.getDateManager(propertiesReader.getTipoDateManager());
                DateManager.initializeDataManager((String)propertiesReader.getTipoTempoEGov("standard"), (String)tipoClass, (Properties)propertiesReader.getDateManagerProperties(), (Logger)logCore);
            }
            catch (Exception e) {
                log.error((Object)("Riscontrato errore durante l'inizializzazione del DataManager: " + e.getMessage()));
                return;
            }
            String erroreDB = null;
            try {
                DBManager.initialize(propertiesReader.getJNDIName_DataSource(), propertiesReader.getJNDIContext_DataSource());
            }
            catch (Exception e) {
                erroreDB = e.getMessage();
                log.info((Object)"Datasource non inizializzato... riprovo");
            }
            int count = 0;
            boolean trovato = DBManager.isInitialized();
            while (!trovato && count < 600000) {
                try {
                    DBManager.initialize(propertiesReader.getJNDIName_DataSource(), propertiesReader.getJNDIContext_DataSource());
                }
                catch (Exception e) {
                    erroreDB = e.getMessage();
                    log.info((Object)("Attendo inizializzazione del Datasource ... " + erroreDB));
                }
                if (DBManager.isInitialized()) {
                    trovato = true;
                    continue;
                }
                count += 10000;
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException ie) {}
            }
            if (!DBManager.isInitialized()) {
                log.fatal((Object)"Inizializzazione DBManager non effettuata", (Throwable)new Exception(erroreDB));
                return;
            }
            log.info((Object)"Inizializzazione DBManager effettuata con successo.");
            if (DBManager.getTransactionIsolationLevel() == 0) {
                log.info((Object)"Database TransactionLevel is NONE");
            } else if (DBManager.getTransactionIsolationLevel() == 2) {
                log.info((Object)"Database TransactionLevel is READ_COMMITTED");
            } else if (DBManager.getTransactionIsolationLevel() == 1) {
                log.info((Object)"Database TransactionLevel is READ_UNCOMMITTED");
            } else if (DBManager.getTransactionIsolationLevel() == 4) {
                log.info((Object)"Database TransactionLevel is REPEATABLE_READ");
            } else if (DBManager.getTransactionIsolationLevel() == 8) {
                log.info((Object)"Database TransactionLevel is SERIALIZABLE");
            } else {
                log.fatal((Object)"TransactionLevel associato alla connessione non conosciuto");
                return;
            }
            try {
                Configurazione.setDatasourcePdD((DataSource)DBManager.getInstance().getDataSource());
            }
            catch (Exception e) {
                log.fatal((Object)"Inizializzazione datasource libreria e-Gov", (Throwable)e);
                return;
            }
            try {
                String tipoGeneratoreClusterID = propertiesReader.getTipoIDManager();
                String classClusterID = null;
                if ("none".equals(tipoGeneratoreClusterID)) {
                    String clusterID = propertiesReader.getClusterId();
                    if (clusterID != null) {
                        classClusterID = "org.openspcoop.utils.id.ClusterIdentifierGenerator";
                    }
                } else {
                    classClusterID = classNameReader.getUniqueIdentifier(tipoGeneratoreClusterID);
                }
                if (classClusterID == null) {
                    UniqueIdentifierManager.disabilitaGenerazioneUID();
                } else {
                    UniqueIdentifierManager.inizializzaUniqueIdentifierManager((String)classClusterID, (Object[])new Object[]{propertiesReader.getClusterId()});
                    if (propertiesReader.generazioneDateCasualiLogAbilitato()) {
                        GeneratoreCasualeDate.init(OpenSPCoopProperties.getGenerazioneDateCasualiLog_dataInizioIntervallo(), OpenSPCoopProperties.getGenerazioneDateCasualiLog_dataFineIntervallo(), log);
                    }
                }
            }
            catch (Exception e) {
                log.error((Object)("Riscontrato errore durante l'inizializzazione del generatore di identificatori unici: " + e.getMessage()));
                return;
            }
            AccessoConfigurazionePdD accessoConfigurazione = null;
            try {
                accessoConfigurazione = propertiesReader.getAccessoConfigurazionePdD();
            }
            catch (Exception e) {
                log.error((Object)("Riscontrato errore durante la lettura della modalita' di accesso alla configurazione di OpenSPCoop: " + e.getMessage()));
                return;
            }
            boolean isInitializeConfig = ConfigurazionePdDReader.initialize(accessoConfigurazione, logCore, log, localConfig);
            if (!isInitializeConfig) {
                log.error((Object)"Riscontrato errore durante l'inizializzazione della configurazione di OpenSPCoop.");
                return;
            }
            ConfigurazionePdDReader configurazionePdDReader = ConfigurazionePdDReader.getInstance();
            if (!msgDiagProperties.checkValoriFiltriMsgDiagnostici(log)) {
                return;
            }
            try {
                String tipoClass = classNameReader.getRepositoryEGov(propertiesReader.getGestoreRepositoryEGov());
                IGestoreRepositoryEGov repository = (IGestoreRepositoryEGov)loader.newInstance(tipoClass);
                boolean filtroDateFuture = false;
                long intervalloTolleranzaDateFuture = -1L;
                if (propertiesReader.getIntervalloMinutiTolleranzaDateFuture() > 0) {
                    filtroDateFuture = true;
                    intervalloTolleranzaDateFuture = propertiesReader.getIntervalloMinutiTolleranzaDateFuture();
                }
                ConfigurazioneGenerazioneBusta configurazioneGenerazioneBusta = new ConfigurazioneGenerazioneBusta(propertiesReader.isGenerazioneSPCoopErrore_strutturaMalformataHeaderEGov(), propertiesReader.isGenerazioneSPCoopErrore_actorScorretto(), propertiesReader.isGenerazioneElementiNonValidabiliRispettoXSD(), propertiesReader.getKeywordTipoMittenteSconosciuto(), propertiesReader.getKeywordMittenteSconosciuto(), propertiesReader.isGenerazioneDetailsSOAPFaultValidazione(), propertiesReader.isGenerazioneDetailsSOAPFaultProcessamento(), propertiesReader.isGenerazioneListaEccezioniErroreProcessamento(), propertiesReader.isGenerazioneDetailsSOAPFaultSPCoopWithStackTrace(), propertiesReader.isGenerazioneDetailsSOAPFaultSPCoopConInformazioniGeneriche());
                Configurazione.init((long)propertiesReader.getGestioneSerializableDB_AttesaAttiva(), (int)propertiesReader.getGestioneSerializableDB_CheckInterval(), (String)propertiesReader.getTipoSeriale_IdentificativoEGov(), (int)propertiesReader.getPrefissoSeriale_IdentificativoEGov(), (IGestoreRepositoryEGov)repository, (String)propertiesReader.getDatabaseType(), (Logger)logCore, (IDSoggetto)propertiesReader.getIdentitaPortaDefault(), propertiesReader.getTipiSoggetti(), propertiesReader.getTipiServizi(), (boolean)propertiesReader.isIgnoraEccezioniNonGravi(), (long)propertiesReader.getRepositoryIntervalloScadenzaMessaggi(), (boolean)propertiesReader.isRepositoryEGovFiltraBusteScaduteRispettoOraRegistrazione(), (boolean)filtroDateFuture, (long)intervalloTolleranzaDateFuture, (ConfigurazioneGenerazioneBusta)configurazioneGenerazioneBusta, (boolean)propertiesReader.isGenerazioneDetailsIntegrazioneSOAPFaultServerError(), (boolean)propertiesReader.isGenerazioneDetailsIntegrazioneSOAPFaultClientError(), (boolean)propertiesReader.isGenerazioneDetailsIntegrazioneSOAPFaultWithStackTrace());
            }
            catch (Exception e) {
                log.error((Object)("Riscontrato errore durante l'inizializzazione della libreria egov: " + e.getMessage()));
                logCore.error((Object)("Riscontrato errore durante l'inizializzazione della libreria egov: " + e.getMessage()), (Throwable)e);
                return;
            }
            MsgDiagnostico msgDiag = new MsgDiagnostico(OpenSPCoopStartup.ID_MODULO);
            boolean isInitializeAppender = false;
            isInitializeAppender = OpenSPCoopLogger.initializeMsgDiagnosticiOpenSPCoopAppender(configurazionePdDReader.getOpenSPCoopAppender_MsgDiagnostici());
            if (!isInitializeAppender) {
                return;
            }
            isInitializeAppender = OpenSPCoopLogger.initializeTracciamentoOpenSPCoopAppender(configurazionePdDReader.getOpenSPCoopAppender_Tracciamento());
            if (!isInitializeAppender) {
                return;
            }
            isInitializeAppender = OpenSPCoopLogger.initializeDumpOpenSPCoopAppender(configurazionePdDReader.getOpenSPCoopAppender_Tracciamento());
            if (!isInitializeAppender) {
                return;
            }
            if (OpenSPCoopStartup.this.serverJ2EE && ("jms".equals(propertiesReader.getNodeReceiver()) || "jms".equals(propertiesReader.getNodeSender()))) {
                try {
                    QueueManager.initialize(propertiesReader.getJNDIName_ConnectionFactory(), propertiesReader.getJNDIContext_ConnectionFactory());
                }
                catch (Exception e) {
                    msgDiag.logStartupError(e, "QueueManager.initConnectionFactory");
                    return;
                }
                log.info((Object)("Inizializzazione connectionFactoryJMS [" + propertiesReader.getJNDIName_ConnectionFactory() + "] effettuata."));
                if ("jms".equals(propertiesReader.getNodeReceiver())) {
                    try {
                        QueueManager.initializeQueueNodeReceiver(propertiesReader.getJNDIContext_CodeInterne());
                    }
                    catch (Exception e) {
                        msgDiag.logStartupError(e, "QueueManager.initQueueNodeReceiver");
                        return;
                    }
                    log.info((Object)"Inizializzazione code JMS per la ricezione di messaggi nell'infrastruttura di OpenSPCoop, effettuata.");
                }
                try {
                    QueueManager.initializeQueueNodeSender(propertiesReader.getJNDIContext_CodeInterne());
                }
                catch (Exception e) {
                    msgDiag.logStartupError(e, "QueueManager.initQueueNodeSender");
                    return;
                }
                log.info((Object)"Inizializzazione code JMS per la spedizione di messaggi nell'infrastruttura di OpenSPCoop, effettuata.");
            }
            if (!(isInitializeValidatoreEGovXSD = ValidazioneConSchemaSPCoop.initializeSchema((Logger)logCore, (String[])propertiesReader.getSchemiXSDImportatiValidazioneXSDBusta()))) {
                msgDiag.logStartupError("Riscontrato errore durante l'inizializzazione dello schema xsd validator di OpenSPCoop", "initSchema_validazioneXsdBusta");
                return;
            }
            if (configurazionePdDReader.getAccessoRegistroServizi() == null) {
                msgDiag.logStartupError("Riscontrato errore durante la lettura dei valori associati al registro dei servizi di OpenSPCoop.", "Lettura configurazione PdD");
                return;
            }
            AccessoRegistro accessoRegistro = configurazionePdDReader.getAccessoRegistroServizi();
            for (int i = 0; i < accessoRegistro.sizeRegistroList(); ++i) {
                AccessoRegistroRegistro registro = accessoRegistro.getRegistro(i);
                if (!"db".equalsIgnoreCase(registro.getTipo())) continue;
                if (registro.getLocation().indexOf("@") != -1) {
                    try {
                        String tipoDatabase = DBUtils.estraiTipoDatabaseFromLocation((String)registro.getLocation());
                        String location = registro.getLocation().substring(registro.getLocation().indexOf("@") + 1);
                        accessoRegistro.getRegistro(i).setLocation(location);
                        accessoRegistro.getRegistro(i).setTipoDatabase(tipoDatabase);
                        continue;
                    }
                    catch (Exception e) {
                        msgDiag.logStartupError(e, "Inizializzazione registro dei servizi di OpenSPCoop [" + registro.getNome() + "]; analisi del tipo di database (tipoDatabase@datasource)");
                        return;
                    }
                }
                if (propertiesReader.getDatabaseType() == null) {
                    msgDiag.logStartupError("Il Registro dei Servizi di tipo [db] richiede la definizione del tipo di database indicato o come prefisso della location (tipoDB@datasource) o attraverso la proprieta' 'org.openspcoop.pdd.repository.tipoDatabase' della porta di dominio", "Inizializzazione registro dei servizi di OpenSPCoop [" + registro.getNome() + "]; analisi del tipo di database");
                    return;
                }
                accessoRegistro.getRegistro(i).setTipoDatabase(propertiesReader.getDatabaseType());
            }
            boolean isInitializeRegistro = RegistroServiziReader.initialize((AccessoRegistro)accessoRegistro, (Logger)logCore, (Logger)log, (boolean)propertiesReader.isControlloRisorseRegistriRaggiungibilitaTotale(), (boolean)propertiesReader.isReadObjectStatoBozza());
            if (!isInitializeRegistro) {
                msgDiag.logStartupError("Inizializzazione fallita", "Accesso registro/i dei servizi");
                return;
            }
            try {
                configurazionePdDReader.initializeRegistroServiziReader();
            }
            catch (Exception e) {
                msgDiag.logStartupError(e, "Inizializzazione Reader per il registro dei servizi utilizzato nella configurazione");
                return;
            }
            boolean validazioneSemanticaConfigurazione = false;
            validazioneSemanticaConfigurazione = "xml".equalsIgnoreCase(accessoConfigurazione.getTipo()) ? propertiesReader.isValidazioneSemanticaConfigurazioneStartupXML() : propertiesReader.isValidazioneSemanticaConfigurazioneStartup();
            if (validazioneSemanticaConfigurazione) {
                try {
                    ConfigurazionePdDReader.getInstance().validazioneSemantica(classNameReader.getConnettore(), classNameReader.getMsgDiagnosticoOpenSPCoopAppender(), classNameReader.getTracciamentoOpenSPCoopAppender(), classNameReader.getAutenticazione(), classNameReader.getAutorizzazione(), classNameReader.getAutorizzazioneContenuto(), classNameReader.getAutorizzazioneContenutoSPCoop(), classNameReader.getIntegrazionePortaDelegata(), classNameReader.getIntegrazionePortaApplicativa(), propertiesReader.isValidazioneSemanticaConfigurazioneStartupXML(), propertiesReader.isValidazioneSemanticaConfigurazioneStartup(), true, log);
                    if (propertiesReader.isValidazioneSemanticaConfigurazioneStartupXML()) {
                        ConfigurazionePdDReader.getInstance().setValidazioneSemanticaModificaConfigurazionePdDXML(classNameReader.getConnettore(), classNameReader.getMsgDiagnosticoOpenSPCoopAppender(), classNameReader.getTracciamentoOpenSPCoopAppender(), classNameReader.getAutenticazione(), classNameReader.getAutorizzazione(), classNameReader.getAutorizzazioneContenuto(), classNameReader.getAutorizzazioneContenutoSPCoop(), classNameReader.getIntegrazionePortaDelegata(), classNameReader.getIntegrazionePortaApplicativa());
                    }
                }
                catch (Exception e) {
                    msgDiag.logStartupError(e, "Validazione semantica della configurazione");
                    return;
                }
            }
            try {
                RegistroServiziReader.getInstance().validazioneSemantica(true, propertiesReader.isValidazioneSemanticaRegistroServiziCheckURI(), classNameReader.getConnettore(), propertiesReader.isValidazioneSemanticaRegistroServiziStartupXML(), propertiesReader.isValidazioneSemanticaRegistroServiziStartup(), log);
                if (propertiesReader.isValidazioneSemanticaRegistroServiziStartupXML()) {
                    RegistroServiziReader.getInstance().setValidazioneSemanticaModificaRegistroServiziXML(propertiesReader.isValidazioneSemanticaRegistroServiziCheckURI(), classNameReader.getConnettore());
                }
            }
            catch (Exception e) {
                msgDiag.logStartupError(e, "Validazione semantica del registro dei servizi");
                return;
            }
            try {
                GestoreMessaggi.initialize();
            }
            catch (Exception e) {
                msgDiag.logStartupError(e, "Cache GestoreMessaggi");
                return;
            }
            try {
                SoapUtils.initMessageContext();
            }
            catch (Exception e) {
                msgDiag.logStartupError(e, "Inizializzazione AxisMessageContext");
                return;
            }
            try {
                SoapUtils.initAxisServer();
            }
            catch (Exception e) {
                msgDiag.logStartupError(e, "Inizializzazione AxisServer");
                return;
            }
            try {
                SoapUtils.initAxisClient();
            }
            catch (Exception e) {
                msgDiag.logStartupError(e, "Inizializzazione AxisClient");
                return;
            }
            try {
                RicezioneContenutiApplicativi.initializeService(classNameReader, propertiesReader, logCore);
            }
            catch (Exception e) {
                msgDiag.logStartupError(e, "Inizializzazione servizio RicezioneContenutiApplicativi");
                return;
            }
            try {
                RicezioneBusteEGov.initializeService(classNameReader, propertiesReader, logCore);
            }
            catch (Exception e) {
                msgDiag.logStartupError(e, "Inizializzazione servizio RicezioneBusteEGov");
                return;
            }
            try {
                MailcapActivationReader.initDataContentHandler(log);
            }
            catch (Exception e) {
                msgDiag.logStartupError(e, "Inizializzazione DataContentHandler (MET-INF/mailcap)");
                return;
            }
            try {
                if (propertiesReader.isRisorseJMXAbilitate()) {
                    if (propertiesReader.getJNDIName_MBeanServer() != null) {
                        OpenSPCoopStartup.this.gestoreRisorseJMX = new GestoreRisorseJMX(propertiesReader.getJNDIName_MBeanServer(), propertiesReader.getJNDIContext_MBeanServer());
                    } else {
                        OpenSPCoopStartup.this.gestoreRisorseJMX = new GestoreRisorseJMX();
                    }
                }
            }
            catch (Exception e) {
                msgDiag.logStartupError(e, "Gestore Risorse JMX");
            }
            if (OpenSPCoopStartup.this.gestoreRisorseJMX != null) {
                try {
                    OpenSPCoopStartup.this.gestoreRisorseJMX.registerMBeanConfigurazionePdD();
                }
                catch (Exception e) {
                    msgDiag.logStartupError(e, "RisorsaJMX - configurazione della Porta di Dominio");
                }
                try {
                    OpenSPCoopStartup.this.gestoreRisorseJMX.registerMBeanAccessoRegistroServizi();
                }
                catch (Exception e) {
                    msgDiag.logStartupError(e, "RisorsaJMX - accesso al Registro dei Servizi");
                }
                try {
                    OpenSPCoopStartup.this.gestoreRisorseJMX.registerMBeanMonitoraggioRisorse();
                }
                catch (Exception e) {
                    msgDiag.logStartupError(e, "RisorsaJMX - monitoraggio delle Risorse");
                }
                try {
                    OpenSPCoopStartup.this.gestoreRisorseJMX.registerMBeanAutorizzazioneSPCoop();
                }
                catch (Exception e) {
                    msgDiag.logStartupError(e, "RisorsaJMX - autorizzazione SPCoop");
                }
                try {
                    OpenSPCoopStartup.this.gestoreRisorseJMX.registerMBeanRepositoryMessaggi();
                }
                catch (Exception e) {
                    msgDiag.logStartupError(e, "RisorsaJMX - repository dei messaggi");
                }
            }
            try {
                InitContext initContext = new InitContext();
                initContext.setLogCore(logCore);
                initContext.setLogConsole(log);
                initContext.setPddContext(OpenSPCoopStartup.this.pddContext);
                GestoreHandlers.init(initContext, msgDiag);
            }
            catch (HandlerException e) {
                msgDiag.logStartupError(e, e.getIdentitaHandler());
                return;
            }
            catch (Exception e) {
                msgDiag.logStartupError(e, "InitHandler");
                return;
            }
            try {
                if (propertiesReader.isAbilitatoControlloRisorseConfigurazione() || propertiesReader.isAbilitatoControlloValidazioneSemanticaConfigurazione() || propertiesReader.isAbilitatoControlloRisorseDB() || propertiesReader.isAbilitatoControlloRisorseJMS() || propertiesReader.isAbilitatoControlloRisorseMsgDiagnosticiPersonalizzati() || propertiesReader.isAbilitatoControlloRisorseRegistriServizi() || propertiesReader.isAbilitatoControlloValidazioneSemanticaRegistriServizi() || propertiesReader.isAbilitatoControlloRisorseTracciamentiPersonalizzati()) {
                    OpenSPCoopStartup.this.timerMonitoraggioRisorse = new TimerMonitoraggioRisorse();
                    OpenSPCoopStartup.this.timerMonitoraggioRisorse.start();
                    log.info((Object)"Inizializzo Timer per il Monitoraggio delle Risorse");
                }
            }
            catch (Exception e) {
                msgDiag.logStartupError(e, "TimerMonitoraggioRisorse");
                return;
            }
            try {
                String[] tipiThreshold = propertiesReader.getRepositoryThresholdTypes();
                if (tipiThreshold != null) {
                    OpenSPCoopStartup.this.timerThreshold = new TimerThreshold();
                    OpenSPCoopStartup.this.timerThreshold.start();
                    log.info((Object)"Inizializzo Timer per il Controllo dei Threshold sulle risorse");
                }
            }
            catch (Exception e) {
                msgDiag.logStartupError(e, "TimerThreshold");
                return;
            }
            initialize = true;
            boolean gestoreBusteNonRiscontrate = false;
            boolean gestoreMessaggi = false;
            boolean gestorePuliziaMessaggiAnomali = false;
            boolean gestoreRepository = false;
            if (OpenSPCoopStartup.this.serverJ2EE) {
                long scadenzaWhile = System.currentTimeMillis() + propertiesReader.getTimerEJBDeployTimeout();
                GestoreJNDI jndi = null;
                jndi = propertiesReader.getJNDIContext_TimerEJB() == null ? new GestoreJNDI() : new GestoreJNDI(propertiesReader.getJNDIContext_TimerEJB());
                while (!(System.currentTimeMillis() >= scadenzaWhile || gestoreBusteNonRiscontrate && gestoreMessaggi && gestorePuliziaMessaggiAnomali && gestoreRepository)) {
                    String nomeJNDI;
                    block212: {
                        block211: {
                            block210: {
                                gestoreBusteNonRiscontrate = false;
                                gestoreMessaggi = false;
                                gestorePuliziaMessaggiAnomali = false;
                                gestoreRepository = false;
                                if (propertiesReader.isTimerGestoreRiscontriRicevuteAbilitato()) {
                                    try {
                                        nomeJNDI = propertiesReader.getJNDITimerEJBName().get("GestoreBusteNonRiscontrate");
                                        log.info((Object)("Inizializzo EJB gestore riscontri [" + nomeJNDI + "]"));
                                        jndi.lookup(nomeJNDI);
                                        gestoreBusteNonRiscontrate = true;
                                        break block210;
                                    }
                                    catch (Exception e) {
                                        log.error((Object)("Search EJB gestore riscontri non trovato: " + e.getMessage()));
                                        try {
                                            Thread.sleep(new Random().nextInt(propertiesReader.getTimerEJBDeployCheckInterval()));
                                        }
                                        catch (Exception eRandom) {}
                                        continue;
                                    }
                                }
                                gestoreBusteNonRiscontrate = true;
                            }
                            if (propertiesReader.isTimerGestoreMessaggiAbilitato()) {
                                try {
                                    nomeJNDI = propertiesReader.getJNDITimerEJBName().get("GestoreMessaggi");
                                    log.info((Object)("Inizializzo EJB gestore messaggi [" + nomeJNDI + "]"));
                                    jndi.lookup(nomeJNDI);
                                    gestoreMessaggi = true;
                                    break block211;
                                }
                                catch (Exception e) {
                                    log.error((Object)("Search EJB gestore messaggi non trovato: " + e.getMessage()));
                                    try {
                                        Thread.sleep(new Random().nextInt(propertiesReader.getTimerEJBDeployCheckInterval()));
                                    }
                                    catch (Exception eRandom) {}
                                    continue;
                                }
                            }
                            gestoreMessaggi = true;
                        }
                        if (propertiesReader.isTimerGestorePuliziaMessaggiAnomaliAbilitato()) {
                            try {
                                nomeJNDI = propertiesReader.getJNDITimerEJBName().get("GestoreConsistenzaDatabase");
                                log.info((Object)("Inizializzo EJB gestore pulizia messaggi anomali [" + nomeJNDI + "]"));
                                jndi.lookup(nomeJNDI);
                                gestorePuliziaMessaggiAnomali = true;
                                break block212;
                            }
                            catch (Exception e) {
                                log.error((Object)("Search EJB pulizia messaggi anomali non trovato: " + e.getMessage()));
                                try {
                                    Thread.sleep(new Random().nextInt(propertiesReader.getTimerEJBDeployCheckInterval()));
                                }
                                catch (Exception eRandom) {}
                                continue;
                            }
                        }
                        gestorePuliziaMessaggiAnomali = true;
                    }
                    if (propertiesReader.isTimerGestoreRepositoryEGovAbilitato()) {
                        try {
                            nomeJNDI = propertiesReader.getJNDITimerEJBName().get("GestoreRepositoryEGov");
                            log.info((Object)("Inizializzo EJB gestore repository [" + nomeJNDI + "]"));
                            jndi.lookup(nomeJNDI);
                            gestoreRepository = true;
                        }
                        catch (Exception e) {
                            log.error((Object)("Search EJB gestore repository non trovato: " + e.getMessage()));
                            try {
                                Thread.sleep(new Random().nextInt(propertiesReader.getTimerEJBDeployCheckInterval()));
                            }
                            catch (Exception eRandom) {}
                        }
                        continue;
                    }
                    gestoreRepository = true;
                }
            }
            if (OpenSPCoopStartup.this.serverJ2EE) {
                if (propertiesReader.isTimerGestoreRiscontriRicevuteAbilitato()) {
                    if (gestoreBusteNonRiscontrate) {
                        try {
                            OpenSPCoopStartup.this.timerRiscontri = ServicesUtils.createTimerGestoreBusteNonRiscontrate();
                        }
                        catch (Exception e) {
                            msgDiag.logStartupError(e, "Creazione timer 'GestoreBusteNonRiscontrate'");
                        }
                        if (OpenSPCoopStartup.this.timerRiscontri != null) {
                            try {
                                OpenSPCoopStartup.this.timerRiscontri.start();
                            }
                            catch (RemoteException e) {
                                msgDiag.logStartupError(e, "Avvio timer 'GestoreBusteNonRiscontrate'");
                            }
                        } else {
                            msgDiag.logStartupError("timer is null", "Avvio timer 'GestoreBusteNonRiscontrate'");
                        }
                    } else {
                        msgDiag.logStartupError("timer non esiste nell'application server", "Avvio timer 'GestoreBusteNonRiscontrate'");
                    }
                } else {
                    msgDiag.setPrefixMsgPersonalizzati("timerGestoreRiscontriRicevute.");
                    msgDiag.addKeyword("@ID_TIMER_GESTORE_MESSAGGI@", "GestoreBusteNonRiscontrate");
                    msgDiag.logPersonalizzato("disabilitato");
                    msgDiag.setPrefixMsgPersonalizzati(null);
                }
            }
            if (propertiesReader.isTimerGestoreMessaggiAbilitato()) {
                if (OpenSPCoopStartup.this.serverJ2EE) {
                    if (gestoreMessaggi) {
                        try {
                            OpenSPCoopStartup.this.timerEliminazioneMsg = ServicesUtils.createTimerGestoreMessaggi();
                        }
                        catch (Exception e) {
                            msgDiag.logStartupError(e, "Creazione timer 'GestoreMessaggi'");
                        }
                        if (OpenSPCoopStartup.this.timerEliminazioneMsg != null) {
                            try {
                                OpenSPCoopStartup.this.timerEliminazioneMsg.start();
                            }
                            catch (RemoteException e) {
                                msgDiag.logStartupError(e, "Avvio timer 'GestoreMessaggi'");
                            }
                        } else {
                            msgDiag.logStartupError("timer is null", "Avvio timer 'GestoreMessaggi'");
                        }
                    } else {
                        msgDiag.logStartupError("timer non esiste nell'application server", "Avvio timer 'GestoreMessaggi'");
                    }
                } else {
                    try {
                        OpenSPCoopStartup.this.threadEliminazioneMsg = new TimerGestoreMessaggiThread();
                        OpenSPCoopStartup.this.threadEliminazioneMsg.start();
                    }
                    catch (Exception e) {
                        msgDiag.logStartupError(e, "Avvio timer (thread) 'GestoreMessaggi'");
                    }
                }
            } else {
                msgDiag.setPrefixMsgPersonalizzati("timerGestoreMessaggi.");
                msgDiag.addKeyword("@ID_TIMER_GESTORE_MESSAGGI@", "GestoreMessaggi");
                msgDiag.logPersonalizzato("disabilitato");
                msgDiag.setPrefixMsgPersonalizzati(null);
            }
            if (propertiesReader.isTimerGestorePuliziaMessaggiAnomaliAbilitato()) {
                if (OpenSPCoopStartup.this.serverJ2EE) {
                    if (gestorePuliziaMessaggiAnomali) {
                        try {
                            OpenSPCoopStartup.this.timerPuliziaMsgAnomali = ServicesUtils.createTimerGestorePuliziaMessaggiAnomali();
                        }
                        catch (Exception e) {
                            msgDiag.logStartupError(e, "Creazione timer 'GestoreConsistenzaDatabase'");
                        }
                        if (OpenSPCoopStartup.this.timerPuliziaMsgAnomali != null) {
                            try {
                                OpenSPCoopStartup.this.timerPuliziaMsgAnomali.start();
                            }
                            catch (RemoteException e) {
                                msgDiag.logStartupError(e, "Avvio timer 'GestoreConsistenzaDatabase'");
                            }
                        } else {
                            msgDiag.logStartupError("timer is null", "Avvio timer 'GestoreConsistenzaDatabase'");
                        }
                    } else {
                        msgDiag.logStartupError("timer non esiste nell'application server", "Avvio timer 'GestoreConsistenzaDatabase'");
                    }
                } else {
                    try {
                        OpenSPCoopStartup.this.threadPuliziaMsgAnomali = new TimerGestorePuliziaMessaggiAnomaliThread();
                        OpenSPCoopStartup.this.threadPuliziaMsgAnomali.start();
                    }
                    catch (Exception e) {
                        msgDiag.logStartupError(e, "Avvio timer (thread) 'GestoreConsistenzaDatabase'");
                    }
                }
            } else {
                msgDiag.setPrefixMsgPersonalizzati("timerGestoreMessaggiInconsistenti.");
                msgDiag.addKeyword("@ID_TIMER_GESTORE_MESSAGGI_INCONSISTENTI@", "GestoreConsistenzaDatabase");
                msgDiag.logPersonalizzato("disabilitato");
                msgDiag.setPrefixMsgPersonalizzati(null);
            }
            if (propertiesReader.isTimerGestoreRepositoryEGovAbilitato()) {
                if (OpenSPCoopStartup.this.serverJ2EE) {
                    if (gestoreRepository) {
                        try {
                            OpenSPCoopStartup.this.timerRepositoryEGov = ServicesUtils.createTimerGestoreRepositoryEGov();
                        }
                        catch (Exception e) {
                            msgDiag.logStartupError(e, "Creazione timer 'GestoreRepositoryEGov'");
                        }
                        if (OpenSPCoopStartup.this.timerRepositoryEGov != null) {
                            try {
                                OpenSPCoopStartup.this.timerRepositoryEGov.start();
                            }
                            catch (RemoteException e) {
                                msgDiag.logStartupError(e, "Avvio timer 'GestoreRepositoryEGov'");
                            }
                        } else {
                            msgDiag.logStartupError("timer is null", "Avvio timer 'GestoreRepositoryEGov'");
                        }
                    } else {
                        msgDiag.logStartupError("timer non esiste nell'application server", "Avvio timer 'GestoreRepositoryEGov'");
                    }
                } else {
                    try {
                        OpenSPCoopStartup.this.threadRepositoryEGov = new TimerGestoreRepositoryEGovThread();
                        OpenSPCoopStartup.this.threadRepositoryEGov.start();
                    }
                    catch (Exception e) {
                        msgDiag.logStartupError(e, "Avvio timer (thread) 'GestoreRepositoryEGov'");
                    }
                }
            } else {
                msgDiag.setPrefixMsgPersonalizzati("timerGestoreRepositoryEGov.");
                msgDiag.addKeyword("@ID_TIMER_GESTORE_REPOSITORY_EGOV@", "GestoreRepositoryEGov");
                msgDiag.logPersonalizzato("disabilitato");
                msgDiag.setPrefixMsgPersonalizzati(null);
            }
            long endDate = System.currentTimeMillis();
            long secondStarter = (endDate - OpenSPCoopStartup.this.startDate) / 1000L;
            msgDiag.setPrefixMsgPersonalizzati("openspcoopStartup.");
            msgDiag.addKeyword("@VERSIONE@", propertiesReader.getFullVersion());
            msgDiag.addKeyword("@TEMPO_DI_AVVIO@", secondStarter + " secondi");
            log.info((Object)("Porta di Dominio " + propertiesReader.getFullVersion() + " avviata correttamente in " + secondStarter + " secondi."));
            msgDiag.logPersonalizzato("pdd");
            MsgDiagnostico msgIM = new MsgDiagnostico("IntegrationManager");
            msgIM.setPrefixMsgPersonalizzati("openspcoopStartup.");
            msgIM.addKeyword("@VERSIONE@", propertiesReader.getFullVersion());
            msgIM.addKeyword("@TEMPO_DI_AVVIO@", secondStarter + " secondi");
            msgIM.logPersonalizzato("IntegrationManager");
        }
    }
}

