/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop.pdd.services;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.openspcoop.pdd.logger.Dump;
import org.openspcoop.pdd.logger.MsgDiagnostico;
import org.openspcoop.pdd.logger.OpenSPCoopLogger;
import org.openspcoop.pdd.logger.Tracciamento;
import org.openspcoop.pdd.services.OpenSPCoopStartup;
import org.openspcoop.pdd.timers.TimerMonitoraggioRisorse;
import org.openspcoop.pdd.timers.TimerThreshold;

public class CheckStatoPdD
extends HttpServlet {
    private static final long serialVersionUID = 1L;

    public void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        Logger log = OpenSPCoopLogger.getLoggerOpenSPCoopCore();
        if (log == null) {
            log = Logger.getLogger((String)"CheckStatoPdD");
        }
        if (!OpenSPCoopStartup.initialize) {
            String msg = "Porta di dominio OpenSPCoop non inzializzata";
            log.error((Object)("[CheckStatoPdD] " + msg));
            res.setStatus(500);
            res.getOutputStream().write(msg.getBytes());
        } else if (!TimerMonitoraggioRisorse.risorseDisponibili) {
            String msg = "Risorse di sistema non disponibili: " + TimerMonitoraggioRisorse.risorsaNonDisponibile.getMessage();
            log.error((Object)("[CheckStatoPdD] " + msg), (Throwable)TimerMonitoraggioRisorse.risorsaNonDisponibile);
            res.setStatus(500);
            res.getOutputStream().write(msg.getBytes());
        } else if (!TimerThreshold.freeSpace) {
            String msg = "Non sono disponibili abbastanza risorse per la gestione della richiesta";
            log.error((Object)("[CheckStatoPdD] " + msg));
            res.setStatus(500);
            res.getOutputStream().write(msg.getBytes());
        } else if (!Tracciamento.tracciamentoDisponibile) {
            String msg = "Tracciatura e-Gov non disponibile: " + Tracciamento.motivoMalfunzionamentoTracciamento.getMessage();
            log.error((Object)("[CheckStatoPdD] " + msg), (Throwable)Tracciamento.motivoMalfunzionamentoTracciamento);
            res.setStatus(500);
            res.getOutputStream().write(msg.getBytes());
        } else if (!MsgDiagnostico.gestoreDiagnosticaDisponibile) {
            String msg = "Sistema di diagnostica non disponibile: " + MsgDiagnostico.motivoMalfunzionamentoDiagnostici.getMessage();
            log.error((Object)("[CheckStatoPdD] " + msg), (Throwable)MsgDiagnostico.motivoMalfunzionamentoDiagnostici);
            res.setStatus(500);
            res.getOutputStream().write(msg.getBytes());
        } else if (!Dump.sistemaDumpDisponibile) {
            String msg = "Sistema di dump dei contenuti applicativi non disponibile: " + Dump.motivoMalfunzionamentoDump.getMessage();
            log.error((Object)("[CheckStatoPdD] " + msg), (Throwable)Dump.motivoMalfunzionamentoDump);
            res.setStatus(500);
            res.getOutputStream().write(msg.getBytes());
        }
    }

    public void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        this.doGet(req, res);
    }
}

