/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop.pdd.services;

import java.security.cert.X509Certificate;
import javax.servlet.http.HttpServletRequest;
import org.apache.axis.AxisFault;
import org.apache.axis.MessageContext;
import org.apache.axis.handlers.BasicHandler;
import org.apache.axis.transport.http.HTTPConstants;
import org.apache.log4j.Logger;
import org.openspcoop.pdd.core.autenticazione.Credenziali;
import org.openspcoop.pdd.logger.OpenSPCoopLogger;

public class AuthenticationHandler
extends BasicHandler {
    private static final long serialVersionUID = 1L;
    private static Logger log = OpenSPCoopLogger.getLoggerOpenSPCoopCore();

    public void invoke(MessageContext msgContext) throws AxisFault {
        Credenziali credenziali = new Credenziali();
        credenziali.setUsername(msgContext.getUsername());
        credenziali.setPassword(msgContext.getPassword());
        try {
            X509Certificate[] certs;
            HttpServletRequest req = (HttpServletRequest)msgContext.getProperty(HTTPConstants.MC_HTTP_SERVLETREQUEST);
            if (req != null && (certs = (X509Certificate[])req.getAttribute("javax.servlet.request.X509Certificate")) != null && certs.length > 0) {
                credenziali.setSubject(certs[0].getSubjectX500Principal().toString());
                credenziali.setCertificati(certs);
            }
        }
        catch (Exception e) {
            log.error((Object)("Riscontrato errore duranta l'analisi delle credenziali [" + e.getMessage() + "]"));
        }
        msgContext.setProperty("openspcoop.credenziali", (Object)credenziali);
    }

    public void generateWSDL(MessageContext msgContext) throws AxisFault {
        this.invoke(msgContext);
    }
}

