/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop.pdd.services;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Date;
import java.util.Properties;
import org.apache.axis.Message;
import org.openspcoop.dao.commons.IDSoggetto;
import org.openspcoop.dao.commons.TipoPdD;
import org.openspcoop.pdd.config.OpenSPCoopProperties;
import org.openspcoop.pdd.core.EGovContext;
import org.openspcoop.pdd.core.IntegrationContext;
import org.openspcoop.pdd.core.PdDContext;
import org.openspcoop.pdd.core.autenticazione.Credenziali;
import org.openspcoop.pdd.logger.MsgDiagnostico;
import org.openspcoop.utils.SoapUtils;
import org.openspcoop.utils.id.UniqueIdentifierException;
import org.openspcoop.utils.id.UniqueIdentifierManager;

public abstract class AbstractContext
implements Serializable {
    private static final OpenSPCoopProperties openspcoopProperties = OpenSPCoopProperties.getInstance();
    private static final long serialVersionUID = 1L;
    private Date dataIngressoRichiesta;
    private PdDContext pddContext = new PdDContext();
    private String idEGov;
    private String idModulo;
    private IDSoggetto identitaPdD;
    private Message messageRequest;
    private byte[] messageRequest_ByteArray;
    private Long contentLengthRequest;
    private Message messageResponse;
    private byte[] messageResponse_ByteArray;
    private boolean gestioneRisposta;
    private Long contentLengthResponse;
    private Credenziali credenziali;
    private String fromLocation;
    private String soapAction = null;
    private EGovContext egov;
    private IntegrationContext integrazione;
    private TipoPdD tipoPorta;
    private MsgDiagnostico msgDiagnostico;
    private Properties headerIntegrazioneRisposta;

    public Date getDataIngressoRichiesta() {
        return this.dataIngressoRichiesta;
    }

    public PdDContext getPddContext() {
        return this.pddContext;
    }

    public AbstractContext(Date dataIngressoRichiesta, IDSoggetto identitaPdD) throws UniqueIdentifierException {
        this.pddContext.addObject("ID", UniqueIdentifierManager.newUniqueIdentifier().getAsString());
        this.dataIngressoRichiesta = dataIngressoRichiesta;
        this.identitaPdD = identitaPdD;
    }

    public String getIdModulo() {
        return this.idModulo;
    }

    public void setIdModulo(String idModulo) {
        this.idModulo = idModulo;
    }

    public Message getMessageRequest() {
        return this.messageRequest;
    }

    public Message getMessageResponse() {
        return this.messageResponse;
    }

    public void setMessageRequest(Message message) {
        this.messageRequest = message;
    }

    public void setMessageResponse(Message messageResponse) {
        this.messageResponse = messageResponse;
    }

    public Credenziali getCredenziali() {
        return this.credenziali;
    }

    public void setCredenziali(Credenziali credenziali) {
        this.credenziali = credenziali;
    }

    public boolean isGestioneRisposta() {
        return this.gestioneRisposta;
    }

    public void setGestioneRisposta(boolean gestioneRisposta) {
        this.gestioneRisposta = gestioneRisposta;
    }

    public Message getMessageRequestFromByte() throws Exception {
        Message requestAxisMessage = null;
        try {
            requestAxisMessage = SoapUtils.build((byte[])this.messageRequest_ByteArray, (boolean)false, (boolean)openspcoopProperties.isDeleteInstructionTargetMachineXml());
            return requestAxisMessage;
        }
        catch (Exception e) {
            throw new Exception("Struttura del messaggio di richiesta Soap, per la ricostruzione, non valida: " + e.getMessage());
        }
    }

    public byte[] getMessageRequestAsByte() throws Exception {
        return this.messageRequest_ByteArray;
    }

    public void setMessageRequestAsByte(byte[] messageRequestByte) {
        this.messageRequest_ByteArray = messageRequestByte;
    }

    public void setMessageRequestAsByte(Message messageRequestByte) throws Exception {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            messageRequestByte.writeTo((OutputStream)out);
            this.messageRequest_ByteArray = out.toByteArray();
        }
        catch (Exception e) {
            throw new Exception("Struttura del messaggio di richiesta Soap, per il salvataggio, non valida: " + e.getMessage());
        }
    }

    public Message getMessageResponseFromByte() throws Exception {
        Message requestAxisMessage = null;
        try {
            requestAxisMessage = SoapUtils.build((byte[])this.messageResponse_ByteArray, (boolean)false, (boolean)openspcoopProperties.isDeleteInstructionTargetMachineXml());
            return requestAxisMessage;
        }
        catch (Exception e) {
            throw new Exception("Struttura del messaggio di risposta Soap, per la ricostruzione non valida: " + e.getMessage());
        }
    }

    public byte[] getMessageResponseAsByte() throws Exception {
        return this.messageResponse_ByteArray;
    }

    public void setMessageResponseAsByte(byte[] messageResponseByte) {
        this.messageResponse_ByteArray = messageResponseByte;
    }

    public void setMessageResponseAsByte(Message messageResponseByte) throws Exception {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            messageResponseByte.writeTo((OutputStream)out);
            this.messageResponse_ByteArray = out.toByteArray();
            this.contentLengthResponse = new Long(this.messageResponse_ByteArray.length);
        }
        catch (Exception e) {
            throw new Exception("Struttura del messaggio di risposta Soap, per il salvataggio, non valida: " + e.getMessage());
        }
    }

    public String getFromLocation() {
        return this.fromLocation;
    }

    public void setFromLocation(String fromLocation) {
        this.fromLocation = fromLocation;
    }

    public String getSoapAction() {
        return this.soapAction;
    }

    public void setSoapAction(String soapAction) {
        this.soapAction = soapAction;
    }

    public MsgDiagnostico getMsgDiagnostico() {
        return this.msgDiagnostico;
    }

    public void setMsgDiagnostico(MsgDiagnostico msgDiagnostico) {
        this.msgDiagnostico = msgDiagnostico;
    }

    public Long getContentLengthRequest() {
        return this.contentLengthRequest;
    }

    public void setContentLengthRequest(Long contentLengthRequest) {
        this.contentLengthRequest = contentLengthRequest;
    }

    public Long getContentLengthResponse() {
        return this.contentLengthResponse;
    }

    public void setContentLengthResponse(Long contentLengthResponse) {
        this.contentLengthResponse = contentLengthResponse;
    }

    public String getIdEGov() {
        return this.idEGov;
    }

    public void setIdEGov(String idEGov) {
        this.idEGov = idEGov;
    }

    public EGovContext getEgov() {
        return this.egov;
    }

    public void setEgov(EGovContext egov) {
        this.egov = egov;
    }

    public IntegrationContext getIntegrazione() {
        return this.integrazione;
    }

    public void setIntegrazione(IntegrationContext integrazione) {
        this.integrazione = integrazione;
    }

    public TipoPdD getTipoPorta() {
        return this.tipoPorta;
    }

    public void setTipoPorta(TipoPdD tipoPorta) {
        this.tipoPorta = tipoPorta;
    }

    public Properties getHeaderIntegrazioneRisposta() {
        return this.headerIntegrazioneRisposta;
    }

    public void setHeaderIntegrazioneRisposta(Properties headerIntegrazione) {
        this.headerIntegrazioneRisposta = headerIntegrazione;
    }

    public IDSoggetto getIdentitaPdD() {
        return this.identitaPdD;
    }

    public void setIdentitaPdD(IDSoggetto identitaPdD) {
        this.identitaPdD = identitaPdD;
    }
}

