/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop.pdd.mdb;

import javax.ejb.EJBException;
import javax.ejb.MessageDrivenBean;
import javax.ejb.MessageDrivenContext;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.ObjectMessage;
import org.apache.log4j.Logger;
import org.openspcoop.pdd.core.PdDContext;
import org.openspcoop.pdd.core.node.TransactionManager;
import org.openspcoop.pdd.core.state.OpenSPCoopState;
import org.openspcoop.pdd.core.state.OpenSPCoopStateful;
import org.openspcoop.pdd.core.state.OpenSPCoopStateless;
import org.openspcoop.pdd.logger.Dump;
import org.openspcoop.pdd.logger.MsgDiagnostico;
import org.openspcoop.pdd.logger.OpenSPCoopLogger;
import org.openspcoop.pdd.logger.Tracciamento;
import org.openspcoop.pdd.mdb.EsitoLib;
import org.openspcoop.pdd.mdb.InoltroBusteEGov;
import org.openspcoop.pdd.mdb.InoltroBusteEGovMessage;
import org.openspcoop.pdd.services.OpenSPCoopStartup;
import org.openspcoop.pdd.timers.TimerMonitoraggioRisorse;

public class InoltroBusteEGovMDB
implements MessageDrivenBean,
MessageListener {
    private static final long serialVersionUID = 1L;
    private MessageDrivenContext ctxMDB;
    private Logger log = null;

    public void setMessageDrivenContext(MessageDrivenContext mdc) throws EJBException {
        this.ctxMDB = mdc;
    }

    public void ejbCreate() {
    }

    public void ejbRemove() {
    }

    public void onMessage(Message message) {
        if (message instanceof ObjectMessage) {
            InoltroBusteEGov lib;
            if (!OpenSPCoopStartup.initialize) {
                this.ctxMDB.setRollbackOnly();
                return;
            }
            if (!TimerMonitoraggioRisorse.risorseDisponibili) {
                this.log.error((Object)("[InoltroBusteEGov] Risorse di sistema non disponibili: " + TimerMonitoraggioRisorse.risorsaNonDisponibile.getMessage()), (Throwable)TimerMonitoraggioRisorse.risorsaNonDisponibile);
                this.ctxMDB.setRollbackOnly();
                return;
            }
            if (!Tracciamento.tracciamentoDisponibile) {
                this.log.error((Object)("[InoltroBusteEGov] Tracciatura e-Gov non disponibile: " + Tracciamento.motivoMalfunzionamentoTracciamento.getMessage()), (Throwable)Tracciamento.motivoMalfunzionamentoTracciamento);
                this.ctxMDB.setRollbackOnly();
                return;
            }
            if (!MsgDiagnostico.gestoreDiagnosticaDisponibile) {
                this.log.error((Object)("[InoltroBusteEGov] Sistema di diagnostica non disponibile: " + MsgDiagnostico.motivoMalfunzionamentoDiagnostici.getMessage()), (Throwable)MsgDiagnostico.motivoMalfunzionamentoDiagnostici);
                this.ctxMDB.setRollbackOnly();
                return;
            }
            if (!Dump.sistemaDumpDisponibile) {
                this.log.error((Object)("[InoltroBusteEGov] Sistema di dump dei contenuti applicativi non disponibile: " + Dump.motivoMalfunzionamentoDump.getMessage()), (Throwable)Dump.motivoMalfunzionamentoDump);
                this.ctxMDB.setRollbackOnly();
                return;
            }
            this.log = OpenSPCoopLogger.getLoggerOpenSPCoopCore();
            if (this.log == null) {
                System.out.println("Logger nullo");
            }
            if (!(lib = new InoltroBusteEGov(this.log)).getInizializzazioneUltimata()) {
                this.log = Logger.getLogger((String)"OpenSPCoop.InoltroBusteEGov");
                this.log.error((Object)"[InoltroBusteEGov] Inizializzazione non riuscita");
                this.ctxMDB.setRollbackOnly();
                return;
            }
            MsgDiagnostico msgDiag = new MsgDiagnostico("InoltroBusteEGov");
            msgDiag.mediumDebug("Ricezione richiesta (InoltroBusteEGovMessage)...");
            ObjectMessage received = (ObjectMessage)message;
            InoltroBusteEGovMessage inoltroBusteEGovMsg = null;
            try {
                inoltroBusteEGovMsg = (InoltroBusteEGovMessage)received.getObject();
            }
            catch (JMSException e) {
                msgDiag.logErroreGenerico(e, "received.getObject(InoltroBusteEGovMessage)");
                return;
            }
            PdDContext pddContext = inoltroBusteEGovMsg.getPddContext();
            msgDiag.setPddContext(pddContext);
            String idEGovRequest = null;
            try {
                idEGovRequest = received.getStringProperty("ID");
            }
            catch (JMSException e) {
                msgDiag.logErroreGenerico(e, "received.getStringProperty(ID)");
                return;
            }
            msgDiag.mediumDebug("Transaction Manager...");
            try {
                if (!TransactionManager.validityCheck(msgDiag, "InoltroBusteEGov", idEGovRequest, "OUTBOX", received.getJMSMessageID())) {
                    msgDiag.addKeyword("@ID_MESSAGGIO_TRANSACTION_MANAGER@", idEGovRequest);
                    msgDiag.addKeyword("@PROPRIETARIO_MESSAGGIO@", "InoltroBusteEGov");
                    msgDiag.logPersonalizzato("all.", "transactionManager.validityCheckError");
                    return;
                }
            }
            catch (Exception e) {
                msgDiag.logErroreGenerico(e, "TransactionManager.validityCheck");
                this.ctxMDB.setRollbackOnly();
                return;
            }
            EsitoLib esito = null;
            OpenSPCoopState stato = null;
            try {
                if (inoltroBusteEGovMsg.getOpenspcoopstate() != null) {
                    stato = inoltroBusteEGovMsg.getOpenspcoopstate();
                    ((OpenSPCoopStateless)stato).setUseConnection(true);
                    stato.setMessageLib(inoltroBusteEGovMsg);
                    ((OpenSPCoopStateless)stato).setIDEgovSessione(idEGovRequest);
                } else {
                    stato = new OpenSPCoopStateful();
                    ((OpenSPCoopStateful)stato).setIDEgovSessione(idEGovRequest);
                    ((OpenSPCoopStateful)stato).setMessageLib(inoltroBusteEGovMsg);
                }
                esito = lib.onMessage(stato);
            }
            catch (Exception e) {
                this.log.error((Object)"[InoltroBusteEGov] Invocazione della libreria non riuscita (verr\u00e0 effettuato un rollback sulla coda JMS)", (Throwable)e);
                this.ctxMDB.setRollbackOnly();
                return;
            }
            if (!esito.isEsitoInvocazione()) {
                this.log.info((Object)"[InoltroBusteEGov] Invocazione della libreria terminata con esito negativo, verr\u00e0 effettuato un rollback sulla coda JMS");
                this.ctxMDB.setRollbackOnly();
                return;
            }
            this.log.debug((Object)"[InoltroBusteEGov] Invocazione della libreria terminata correttamente");
        }
    }
}

