/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop.pdd.mdb;

import javax.ejb.EJBException;
import javax.ejb.MessageDrivenBean;
import javax.ejb.MessageDrivenContext;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.ObjectMessage;
import org.apache.log4j.Logger;
import org.openspcoop.pdd.core.PdDContext;
import org.openspcoop.pdd.core.node.TransactionManager;
import org.openspcoop.pdd.core.state.OpenSPCoopStateful;
import org.openspcoop.pdd.logger.Dump;
import org.openspcoop.pdd.logger.MsgDiagnostico;
import org.openspcoop.pdd.logger.OpenSPCoopLogger;
import org.openspcoop.pdd.logger.Tracciamento;
import org.openspcoop.pdd.mdb.EsitoLib;
import org.openspcoop.pdd.mdb.ImbustamentoRisposte;
import org.openspcoop.pdd.mdb.ImbustamentoRisposteMessage;
import org.openspcoop.pdd.services.OpenSPCoopStartup;
import org.openspcoop.pdd.timers.TimerMonitoraggioRisorse;

public class ImbustamentoRisposteMDB
implements MessageDrivenBean,
MessageListener {
    private static final long serialVersionUID = 1L;
    private Logger log = null;
    private MessageDrivenContext ctxMDB;

    public void setMessageDrivenContext(MessageDrivenContext mdc) throws EJBException {
        this.ctxMDB = mdc;
    }

    public void ejbCreate() {
    }

    public void ejbRemove() {
    }

    public void onMessage(Message message) {
        if (message instanceof ObjectMessage) {
            if (!OpenSPCoopStartup.initialize) {
                this.ctxMDB.setRollbackOnly();
                return;
            }
            this.log = OpenSPCoopLogger.getLoggerOpenSPCoopCore();
            if (this.log == null) {
                System.out.println("[ImbustamentoRisposte] Logger nullo. MDB abortito");
                return;
            }
            if (!TimerMonitoraggioRisorse.risorseDisponibili) {
                this.log.error((Object)("[ImbustamentoRisposte] Risorse di sistema non disponibili: " + TimerMonitoraggioRisorse.risorsaNonDisponibile.getMessage()), (Throwable)TimerMonitoraggioRisorse.risorsaNonDisponibile);
                this.ctxMDB.setRollbackOnly();
                return;
            }
            if (!Tracciamento.tracciamentoDisponibile) {
                this.log.error((Object)("[ImbustamentoRisposte] Tracciatura e-Gov non disponibile: " + Tracciamento.motivoMalfunzionamentoTracciamento.getMessage()), (Throwable)Tracciamento.motivoMalfunzionamentoTracciamento);
                this.ctxMDB.setRollbackOnly();
                return;
            }
            if (!MsgDiagnostico.gestoreDiagnosticaDisponibile) {
                this.log.error((Object)("[ImbustamentoRisposte] Sistema di diagnostica non disponibile: " + MsgDiagnostico.motivoMalfunzionamentoDiagnostici.getMessage()), (Throwable)MsgDiagnostico.motivoMalfunzionamentoDiagnostici);
                this.ctxMDB.setRollbackOnly();
                return;
            }
            if (!Dump.sistemaDumpDisponibile) {
                this.log.error((Object)("[ImbustamentoRisposte] Sistema di dump dei contenuti applicativi non disponibile: " + Dump.motivoMalfunzionamentoDump.getMessage()), (Throwable)Dump.motivoMalfunzionamentoDump);
                this.ctxMDB.setRollbackOnly();
                return;
            }
            ImbustamentoRisposte lib = new ImbustamentoRisposte(this.log);
            if (!lib.inizializzazioneUltimata) {
                this.log = Logger.getLogger((String)"OpenSPCoop.ImbustamentoRisposte");
                this.log.error((Object)"[ImbustamentoRisposte] Inizializzazione MDB non riuscita");
                this.ctxMDB.setRollbackOnly();
                return;
            }
            MsgDiagnostico msgDiag = new MsgDiagnostico("ImbustamentoRisposte");
            msgDiag.mediumDebug("Ricezione richiesta (ImbustamentoRisposteMessage)...");
            ObjectMessage received = (ObjectMessage)message;
            ImbustamentoRisposteMessage imbustamentoRisposteMsg = null;
            try {
                imbustamentoRisposteMsg = (ImbustamentoRisposteMessage)received.getObject();
            }
            catch (JMSException e) {
                msgDiag.logErroreGenerico(e, "received.getObject(ImbustamentoRisposteMessage)");
                return;
            }
            PdDContext pddContext = imbustamentoRisposteMsg.getPddContext();
            msgDiag.setPddContext(pddContext);
            String idEGovRequest = null;
            try {
                idEGovRequest = received.getStringProperty("ID");
            }
            catch (JMSException e) {
                msgDiag.logErroreGenerico(e, "received.getStringProperty(ID)");
                return;
            }
            String idEGovResponse = imbustamentoRisposteMsg.getIDEGovResponse();
            msgDiag.mediumDebug("Transaction Manager...");
            try {
                if (!TransactionManager.validityCheck(msgDiag, "ImbustamentoRisposte", idEGovResponse, "OUTBOX", received.getJMSMessageID())) {
                    msgDiag.addKeyword("@ID_MESSAGGIO_TRANSACTION_MANAGER@", idEGovRequest);
                    msgDiag.addKeyword("@PROPRIETARIO_MESSAGGIO@", "ImbustamentoRisposte");
                    msgDiag.logPersonalizzato("all.", "transactionManager.validityCheckError");
                    return;
                }
            }
            catch (Exception e) {
                msgDiag.logErroreGenerico(e, "TransactionManager.validityCheck");
                this.ctxMDB.setRollbackOnly();
                return;
            }
            EsitoLib esito = null;
            try {
                OpenSPCoopStateful stato = new OpenSPCoopStateful();
                stato.setIDEgovSessione(idEGovRequest);
                stato.setMessageLib(imbustamentoRisposteMsg);
                esito = lib.onMessage(stato);
            }
            catch (Exception e) {
                this.log.error((Object)"[ImbustamentoRisposte] Invocazione della libreria non riuscita (verr\u00e0 effettuato un rollback sulla coda JMS)", (Throwable)e);
                this.ctxMDB.setRollbackOnly();
                return;
            }
            if (!esito.isEsitoInvocazione()) {
                this.log.info((Object)"[ImbustamentoRisposte] Invocazione della libreria terminata con esito negativo, verr\u00e0 effettuato un rollback sulla coda JMS");
                this.ctxMDB.setRollbackOnly();
                return;
            }
            this.log.debug((Object)"[ImbustamentoRisposte] Invocazione della libreria terminata correttamente");
        }
    }
}

