/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop.pdd.mdb;

import org.apache.log4j.Logger;
import org.openspcoop.pdd.config.ConfigurazionePdDReader;
import org.openspcoop.pdd.config.OpenSPCoopProperties;
import org.openspcoop.pdd.core.EJBUtils;
import org.openspcoop.pdd.core.node.INodeSender;
import org.openspcoop.pdd.core.state.IOpenSPCoopState;
import org.openspcoop.pdd.core.state.OpenSPCoopStateException;
import org.openspcoop.pdd.logger.MsgDiagnostico;
import org.openspcoop.pdd.mdb.EsitoLib;
import org.openspcoop.pdd.mdb.GenericLibException;
import org.openspcoop.registry.RegistroServiziReader;
import org.openspcoop.utils.Loader;

public class GenericLib {
    protected Logger log = null;
    protected OpenSPCoopProperties propertiesReader;
    protected RegistroServiziReader registroServiziReader;
    protected ConfigurazionePdDReader configurazionePdDReader;
    protected Loader loader;
    protected static INodeSender nodeSender;
    protected String idModulo;
    protected MsgDiagnostico msgDiag;
    protected boolean inizializzazioneUltimata = false;

    public boolean getInizializzazioneUltimata() {
        return this.inizializzazioneUltimata;
    }

    protected synchronized void inizializza() {
        if (!this.inizializzazioneUltimata) {
            this.propertiesReader = OpenSPCoopProperties.getInstance();
            this.registroServiziReader = RegistroServiziReader.getInstance();
            this.configurazionePdDReader = ConfigurazionePdDReader.getInstance();
            this.loader = Loader.getInstance();
            try {
                this.initMsgDiagnostico();
            }
            catch (Exception e) {
                e.printStackTrace();
                return;
            }
            boolean error = false;
            if (nodeSender == null) {
                try {
                    nodeSender = EJBUtils.getNodeSender(this.propertiesReader, this.log);
                }
                catch (Exception e) {
                    System.out.println("inizializza " + e);
                    error = true;
                }
            }
            this.inizializzazioneUltimata = !error;
        }
    }

    public GenericLib(String idModulo, Logger log) {
        this.idModulo = idModulo;
        this.log = log;
    }

    protected void initMsgDiagnostico() throws GenericLibException {
        try {
            this.msgDiag = new MsgDiagnostico(this.idModulo);
        }
        catch (Exception e) {
            this.log.error((Object)"Riscontrato Errore durante l'inizializzazione del MsgDiagnostico", (Throwable)e);
            throw new GenericLibException("Riscontrato Errore durante l'inizializzazione del MsgDiagnostico");
        }
    }

    public EsitoLib onMessage(IOpenSPCoopState openspcoop_state) throws OpenSPCoopStateException {
        return null;
    }
}

