/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop.pdd.logger;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.math.BigInteger;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggingEvent;
import org.jibx.runtime.BindingDirectory;
import org.jibx.runtime.IBindingFactory;
import org.jibx.runtime.IUnmarshallingContext;
import org.jibx.runtime.JiBXException;
import org.openspcoop.dao.busta.Destinatario;
import org.openspcoop.dao.busta.Destinazione;
import org.openspcoop.dao.busta.Eccezione;
import org.openspcoop.dao.busta.IdentificativoParte;
import org.openspcoop.dao.busta.Intestazione;
import org.openspcoop.dao.busta.IntestazioneMessaggio;
import org.openspcoop.dao.busta.ListaEccezioni;
import org.openspcoop.dao.busta.ListaRiscontri;
import org.openspcoop.dao.busta.ListaTrasmissioni;
import org.openspcoop.dao.busta.Messaggio;
import org.openspcoop.dao.busta.Mittente;
import org.openspcoop.dao.busta.OraRegistrazione;
import org.openspcoop.dao.busta.Origine;
import org.openspcoop.dao.busta.ProfiloCollaborazione;
import org.openspcoop.dao.busta.ProfiloTrasmissione;
import org.openspcoop.dao.busta.Riscontro;
import org.openspcoop.dao.busta.Sequenza;
import org.openspcoop.dao.busta.Servizio;
import org.openspcoop.dao.busta.Trasmissione;
import org.openspcoop.dao.tracciamento.Traccia;
import org.openspcoop.pdd.logger.OpenSPCoopLogger;
import org.openspcoop.utils.GestoreJNDI;
import org.openspcoop.utils.Loader;
import org.openspcoop.utils.jdbc.JDBCUtilities;
import org.openspcoop.utils.sql.TipiDatabase;

public class TracciamentoLog4JAppender
extends AppenderSkeleton {
    private static final String TRACCIAMENTO = "tracce";
    private static final String TRACCIAMENTO_LISTA_ECCEZIONI = "tracce_eccezioni";
    private static final String TRACCIAMENTO_LISTA_RISCONTRI = "tracce_riscontri";
    private static final String TRACCIAMENTO_LISTA_TRASMISSIONI = "tracce_trasmissioni";
    private IUnmarshallingContext uctx = null;
    private PrintStream ps = null;
    private DataSource ds = null;
    private String dburl = "";
    private String dbuser = "";
    private String dbpw = "";
    private String filerej = "tracce.rejected";
    private String dbdriver = "";
    private String dataSource = null;
    private String provider = null;
    private String tipoDatabase = null;

    public void setDBUrl(String dburl) {
        this.dburl = dburl;
    }

    public String getDBUrl() {
        return this.dburl;
    }

    public void setDBUser(String dbuser) {
        this.dbuser = dbuser;
    }

    public String getDBUser() {
        return this.dbuser;
    }

    public void setDBPwd(String dbpw) {
        this.dbpw = dbpw;
    }

    public String getDBPwd() {
        return this.dbpw;
    }

    public void setDBDriver(String dbdriver) {
        this.dbdriver = dbdriver;
    }

    public String getDBDriver() {
        return this.dbdriver;
    }

    public void setDataSource(String dataSource) {
        this.dataSource = dataSource;
    }

    public String getDataSource() {
        return this.dataSource;
    }

    public void setProvider(String provider) {
        this.provider = provider;
    }

    public String getProvider() {
        return this.provider;
    }

    public void setFileRejected(String filerej) {
        this.filerej = filerej;
    }

    public String getFileRejected() {
        return this.filerej;
    }

    public boolean requiresLayout() {
        return true;
    }

    public void activateOptions() {
        try {
            IBindingFactory bfact = BindingDirectory.getFactory(Traccia.class);
            this.uctx = bfact.createUnmarshallingContext();
        }
        catch (JiBXException e) {
            System.err.println("[TracciamentoAppender] Riscontrato errore durante la creazione del contesto di unmarshall:\n" + e.getMessage());
        }
        try {
            this.ps = new PrintStream(this.filerej);
        }
        catch (IOException ioe) {
            System.err.println("[TracciamentoAppender] IOException: " + ioe.getMessage());
        }
        if (this.dataSource != null) {
            try {
                Properties context = new Properties();
                if (this.provider != null) {
                    context.put("java.naming.provider.url", this.provider);
                }
                GestoreJNDI jndi = new GestoreJNDI(context);
                this.ds = (DataSource)jndi.lookup(this.dataSource);
            }
            catch (Exception e) {
                System.err.println("[TracciamentoAppender] Lookup DataSource Exception: " + e.getMessage());
            }
        } else {
            try {
                Loader.getInstance().newInstance(this.dbdriver);
            }
            catch (Exception ex) {
                System.err.println("[TracciamentoAppender] ClassNotFoundException: " + ex.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void append(LoggingEvent event) {
        block74: {
            Connection con;
            Logger log;
            block72: {
                ListaEccezioni listaEcc;
                ListaTrasmissioni listaTrasm;
                Sequenza classSeq;
                Servizio classServ;
                ProfiloCollaborazione classPC;
                log = OpenSPCoopLogger.getLoggerOpenSPCoopCore();
                String singleTrace = (String)event.getMessage();
                boolean procedi = true;
                if (singleTrace == null) break block74;
                ByteArrayInputStream sbis = null;
                Traccia tracciaXML = null;
                try {
                    sbis = new ByteArrayInputStream(singleTrace.getBytes());
                    tracciaXML = (Traccia)this.uctx.unmarshalDocument((InputStream)sbis, null);
                    try {
                        sbis.close();
                    }
                    catch (IOException ioe) {}
                }
                catch (Exception e) {
                    try {
                        sbis.close();
                    }
                    catch (IOException ioe) {
                        // empty catch block
                    }
                    if (singleTrace != null && !singleTrace.equals("") && !singleTrace.equals(" ")) {
                        log.error((Object)("[TracciamentoAppender] Riscontrato errore durante l'unmarshall del file di configurazione:\n" + e.getMessage()), (Throwable)e);
                        this.ps.println(singleTrace);
                    }
                    procedi = false;
                }
                con = null;
                if (procedi) {
                    try {
                        con = this.ds != null ? this.ds.getConnection() : DriverManager.getConnection(this.dburl, this.dbuser, this.dbpw);
                        if (con == null) {
                            throw new Exception("Connection is null");
                        }
                    }
                    catch (Exception ex) {
                        log.error((Object)("[TracciamentoAppender] GetConnection, SQLException: " + ex.getMessage()), (Throwable)ex);
                        this.ps.println(singleTrace);
                        procedi = false;
                    }
                }
                if (!procedi) break block74;
                Statement stmt = null;
                ResultSet rs = null;
                con.setAutoCommit(false);
                Date gdo = null;
                Date oramess = null;
                Date scadenzamess = null;
                boolean confric = false;
                BigInteger numprog = BigInteger.ZERO;
                String idporta = "";
                String tipomess = "";
                String mittente = "";
                String tipomitt = "";
                String indtelmitt = "";
                String destinatario = "";
                String tipodest = "";
                String indteldest = "";
                String profcoll = "";
                String servcorrprofcoll = "";
                String tipoprofcoll = "";
                String collaborazione = "";
                String servizio = "";
                String tiposerv = "";
                String azione = "";
                String messaggio = "";
                String tempomess = "";
                String riferimentomess = "";
                String inoltro = "";
                gdo = tracciaXML.getGDO();
                idporta = tracciaXML.getIdentificativoPorta();
                tipomess = tracciaXML.getTipoMessaggio();
                Intestazione intestazione = tracciaXML.getIntestazione();
                IntestazioneMessaggio intestazioneMsg = intestazione.getIntestazioneMessaggio();
                Mittente classMitt = intestazioneMsg.getMittente();
                IdentificativoParte idMittente = classMitt.getIdentificativoParte(0);
                mittente = idMittente.getBase();
                tipomitt = idMittente.getTipo();
                indtelmitt = idMittente.getIndirizzoTelematico();
                if (indtelmitt == null) {
                    indtelmitt = "";
                }
                Destinatario classDest = intestazioneMsg.getDestinatario();
                IdentificativoParte idDest = classDest.getIdentificativoParte();
                destinatario = idDest.getBase();
                tipodest = idDest.getTipo();
                indteldest = idDest.getIndirizzoTelematico();
                if (indteldest == null) {
                    indteldest = "";
                }
                if ((classPC = intestazioneMsg.getProfiloCollaborazione()) != null) {
                    profcoll = classPC.getBase();
                    servcorrprofcoll = classPC.getServizioCorrelato();
                    if (servcorrprofcoll == null) {
                        servcorrprofcoll = "";
                    }
                    if ((tipoprofcoll = classPC.getTipo()) == null) {
                        tipoprofcoll = "";
                    }
                }
                if ((collaborazione = intestazioneMsg.getCollaborazione()) == null) {
                    collaborazione = "";
                }
                if ((classServ = intestazioneMsg.getServizio()) != null) {
                    servizio = classServ.getBase();
                    tiposerv = classServ.getTipo();
                }
                if ((azione = intestazioneMsg.getAzione()) == null) {
                    azione = "";
                }
                Messaggio classMess = intestazioneMsg.getMessaggio();
                messaggio = classMess.getIdentificatore();
                OraRegistrazione orareg = classMess.getOraRegistrazione();
                oramess = orareg.getBase();
                tempomess = orareg.getTempo();
                riferimentomess = classMess.getRiferimentoMessaggio();
                if (riferimentomess == null) {
                    riferimentomess = "";
                }
                scadenzamess = classMess.getScadenza();
                ProfiloTrasmissione classPT = intestazioneMsg.getProfiloTrasmissione();
                if (classPT != null) {
                    inoltro = classPT.getInoltro();
                    confric = classPT.getConfermaRicezione();
                }
                if ((classSeq = intestazioneMsg.getSequenza()) != null) {
                    numprog = classSeq.getNumeroProgressivo();
                }
                int idtraccia = 0;
                String generazioneID_nomeColonnaSQL = "";
                String generazioneID_valoreColonnaSQL = "";
                if (TipiDatabase.POSTGRESQL.equals(this.tipoDatabase) || TipiDatabase.ORACLE.equals(this.tipoDatabase)) {
                    String sequenceQuery = null;
                    sequenceQuery = TipiDatabase.POSTGRESQL.equals(this.tipoDatabase) ? "select nextval('tracce_id_seq'::text) as nextval" : "select tracce_sequence.nextval as nextval from dual";
                    stmt = con.prepareStatement(sequenceQuery);
                    rs = stmt.executeQuery();
                    if (!rs.next()) {
                        throw new Exception("ID autoincrementale non ottenuto via Sequence");
                    }
                    idtraccia = rs.getInt("nextval");
                    if (idtraccia < 0) {
                        throw new Exception("ID autoincrementale non ottenuto: is null?");
                    }
                    rs.close();
                    stmt.close();
                    generazioneID_nomeColonnaSQL = ",id";
                    generazioneID_valoreColonnaSQL = ",?";
                }
                stmt = null;
                String updateString = "INSERT INTO tracce (gdo, gdo_int,idporta, tipo_messaggio, mittente, tipo_mittente, indtelematico_mitt, destinatario, tipo_destinatario, indtelematico_dest, profilo_collaborazione, servizio_correlato,tipo_servizio_correlato , collaborazione, servizio, tipo_servizio, azione, id_egov, ora_registrazione, tipo_ora_reg, rif_messaggio, scadenza, inoltro, conferma_ricezione, sequenza" + generazioneID_nomeColonnaSQL + ") VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ? , ?" + generazioneID_valoreColonnaSQL + ")";
                if (TipiDatabase.POSTGRESQL.equals(this.tipoDatabase) || TipiDatabase.ORACLE.equals(this.tipoDatabase)) {
                    stmt = con.prepareStatement(updateString);
                } else if (TipiDatabase.DEFAULT.equals(this.tipoDatabase) || TipiDatabase.MYSQL.equals(this.tipoDatabase)) {
                    stmt = con.prepareStatement(updateString, 1);
                } else {
                    throw new Exception("Tipo di database non definito/gestito: " + this.tipoDatabase);
                }
                Timestamp gdoT = new Timestamp(gdo.getTime() - 0x6DDD00L);
                stmt.setTimestamp(1, gdoT);
                stmt.setLong(2, gdoT.getTime());
                JDBCUtilities.setSQLStringValue((PreparedStatement)stmt, (int)3, (String)idporta);
                JDBCUtilities.setSQLStringValue((PreparedStatement)stmt, (int)4, (String)tipomess);
                JDBCUtilities.setSQLStringValue((PreparedStatement)stmt, (int)5, (String)mittente);
                JDBCUtilities.setSQLStringValue((PreparedStatement)stmt, (int)6, (String)tipomitt);
                JDBCUtilities.setSQLStringValue((PreparedStatement)stmt, (int)7, (String)indtelmitt);
                JDBCUtilities.setSQLStringValue((PreparedStatement)stmt, (int)8, (String)destinatario);
                JDBCUtilities.setSQLStringValue((PreparedStatement)stmt, (int)9, (String)tipodest);
                JDBCUtilities.setSQLStringValue((PreparedStatement)stmt, (int)10, (String)indteldest);
                JDBCUtilities.setSQLStringValue((PreparedStatement)stmt, (int)11, (String)profcoll);
                JDBCUtilities.setSQLStringValue((PreparedStatement)stmt, (int)12, (String)servcorrprofcoll);
                JDBCUtilities.setSQLStringValue((PreparedStatement)stmt, (int)13, (String)tipoprofcoll);
                JDBCUtilities.setSQLStringValue((PreparedStatement)stmt, (int)14, (String)collaborazione);
                JDBCUtilities.setSQLStringValue((PreparedStatement)stmt, (int)15, (String)servizio);
                JDBCUtilities.setSQLStringValue((PreparedStatement)stmt, (int)16, (String)tiposerv);
                JDBCUtilities.setSQLStringValue((PreparedStatement)stmt, (int)17, (String)azione);
                JDBCUtilities.setSQLStringValue((PreparedStatement)stmt, (int)18, (String)messaggio);
                if (oramess != null) {
                    stmt.setTimestamp(19, new Timestamp(oramess.getTime() - 0x6DDD00L));
                } else {
                    stmt.setTimestamp(19, null);
                }
                JDBCUtilities.setSQLStringValue((PreparedStatement)stmt, (int)20, (String)tempomess);
                JDBCUtilities.setSQLStringValue((PreparedStatement)stmt, (int)21, (String)riferimentomess);
                if (scadenzamess == null) {
                    stmt.setTimestamp(22, null);
                } else {
                    stmt.setTimestamp(22, new Timestamp(scadenzamess.getTime() - 0x6DDD00L));
                }
                JDBCUtilities.setSQLStringValue((PreparedStatement)stmt, (int)23, (String)inoltro);
                if (confric) {
                    stmt.setInt(24, 1);
                } else {
                    stmt.setInt(24, 0);
                }
                stmt.setInt(25, numprog.intValue());
                if (TipiDatabase.POSTGRESQL.equals(this.tipoDatabase) || TipiDatabase.ORACLE.equals(this.tipoDatabase)) {
                    stmt.setInt(26, idtraccia);
                }
                stmt.executeUpdate();
                if (TipiDatabase.DEFAULT.equals(this.tipoDatabase) || TipiDatabase.MYSQL.equals(this.tipoDatabase)) {
                    rs = stmt.getGeneratedKeys();
                    if (!rs.next()) {
                        throw new Exception("ID autoincrementale non ottenuto via JDBC3.0");
                    }
                    idtraccia = rs.getInt(1);
                    if (idtraccia < 0) {
                        throw new Exception("ID autoincrementale non ottenuto: is null?");
                    }
                    rs.close();
                }
                stmt.close();
                ListaRiscontri listaRisc = intestazione.getListaRiscontri();
                if (listaRisc != null) {
                    for (int i = 0; i < listaRisc.sizeRiscontroList(); ++i) {
                        Riscontro classRisc = listaRisc.getRiscontro(i);
                        String riscontro = classRisc.getIdentificatore();
                        OraRegistrazione orareg1 = classRisc.getOraRegistrazione();
                        Date orarisc = orareg1.getBase();
                        String temporisc = orareg1.getTempo();
                        updateString = "INSERT INTO tracce_riscontri (idtraccia, riscontro, ora_registrazione, tipo_ora_reg) VALUES (?, ?, ?, ?)";
                        stmt = con.prepareStatement(updateString);
                        stmt.setLong(1, idtraccia);
                        JDBCUtilities.setSQLStringValue((PreparedStatement)stmt, (int)2, (String)riscontro);
                        if (orarisc != null) {
                            stmt.setTimestamp(3, new Timestamp(orarisc.getTime() - 0x6DDD00L));
                        } else {
                            stmt.setTimestamp(3, null);
                        }
                        JDBCUtilities.setSQLStringValue((PreparedStatement)stmt, (int)4, (String)temporisc);
                        stmt.executeUpdate();
                        stmt.close();
                    }
                }
                if ((listaTrasm = intestazione.getListaTrasmissioni()) != null) {
                    for (int i = 0; i < listaTrasm.sizeTrasmissioneList(); ++i) {
                        Trasmissione classTrasm = listaTrasm.getTrasmissione(i);
                        Origine classOrig = classTrasm.getOrigine();
                        IdentificativoParte idOr = classOrig.getIdentificativoParte();
                        String origine = idOr.getBase();
                        String tipoorig = idOr.getTipo();
                        String indtelorig = idOr.getIndirizzoTelematico();
                        if (indtelorig == null) {
                            indtelorig = "";
                        }
                        Destinazione classD = classTrasm.getDestinazione();
                        IdentificativoParte idD = classD.getIdentificativoParte();
                        String destinazione = idD.getBase();
                        String tipod = idD.getTipo();
                        String indteld = idD.getIndirizzoTelematico();
                        if (indteld == null) {
                            indteld = "";
                        }
                        OraRegistrazione orareg2 = classTrasm.getOraRegistrazione();
                        Date oratrasm = orareg2.getBase();
                        String tempotrasm = orareg2.getTempo();
                        updateString = "INSERT INTO tracce_trasmissioni (idtraccia, origine,tipo_origine ,indtelematico_orig , destinazione, tipo_destinazione, indtel_destinazione, ora_registrazione, tipo_ora_registrazione) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)";
                        stmt = con.prepareStatement(updateString);
                        stmt.setLong(1, idtraccia);
                        JDBCUtilities.setSQLStringValue((PreparedStatement)stmt, (int)2, (String)origine);
                        JDBCUtilities.setSQLStringValue((PreparedStatement)stmt, (int)3, (String)tipoorig);
                        JDBCUtilities.setSQLStringValue((PreparedStatement)stmt, (int)4, (String)indtelorig);
                        JDBCUtilities.setSQLStringValue((PreparedStatement)stmt, (int)5, (String)destinazione);
                        JDBCUtilities.setSQLStringValue((PreparedStatement)stmt, (int)6, (String)tipod);
                        JDBCUtilities.setSQLStringValue((PreparedStatement)stmt, (int)7, (String)indteld);
                        if (oratrasm != null) {
                            stmt.setTimestamp(8, new Timestamp(oratrasm.getTime() - 0x6DDD00L));
                        } else {
                            stmt.setTimestamp(8, null);
                        }
                        JDBCUtilities.setSQLStringValue((PreparedStatement)stmt, (int)9, (String)tempotrasm);
                        stmt.executeUpdate();
                        stmt.close();
                    }
                }
                if ((listaEcc = intestazione.getListaEccezioni()) != null) {
                    for (int i = 0; i < listaEcc.sizeEccezioneList(); ++i) {
                        Eccezione classEcc = listaEcc.getEccezione(i);
                        String contcod = classEcc.getContestoCodifica();
                        String codecc = classEcc.getCodiceEccezione();
                        String rilevanza = classEcc.getRilevanza();
                        String posizione = classEcc.getPosizione();
                        updateString = "INSERT INTO tracce_eccezioni (idtraccia, contesto_codifica, codice_eccezione, rilevanza, posizione) VALUES (?, ?, ?, ?, ?)";
                        stmt = con.prepareStatement(updateString);
                        stmt.setLong(1, idtraccia);
                        JDBCUtilities.setSQLStringValue((PreparedStatement)stmt, (int)2, (String)contcod);
                        JDBCUtilities.setSQLStringValue((PreparedStatement)stmt, (int)3, (String)codecc);
                        JDBCUtilities.setSQLStringValue((PreparedStatement)stmt, (int)4, (String)rilevanza);
                        JDBCUtilities.setSQLStringValue((PreparedStatement)stmt, (int)5, (String)posizione);
                        stmt.executeUpdate();
                        stmt.close();
                    }
                }
                con.commit();
                con.setAutoCommit(true);
                Object var69_78 = null;
                try {
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                    break block72;
                }
                catch (Exception e) {}
                break block72;
                {
                    catch (Exception ex) {
                        log.error((Object)("[TracciamentoAppender] Gestione traccia: " + ex.getMessage()), (Throwable)ex);
                        this.ps.println(singleTrace);
                        Object var69_79 = null;
                        try {
                            if (rs != null) {
                                rs.close();
                            }
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                        try {
                            if (stmt != null) {
                                stmt.close();
                            }
                            break block72;
                        }
                        catch (Exception e) {}
                    }
                }
                catch (Throwable throwable) {
                    Object var69_80 = null;
                    try {
                        if (rs != null) {
                            rs.close();
                        }
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    try {
                        if (stmt != null) {
                            stmt.close();
                        }
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    throw throwable;
                }
            }
            try {
                con.close();
            }
            catch (SQLException ex) {
                log.error((Object)("[TracciamentoAppender] Exception closing connection to DB " + ex.getMessage()), (Throwable)ex);
            }
        }
    }

    public void close() {
        this.ps.close();
    }

    public String getTipoDatabase() {
        return this.tipoDatabase;
    }

    public void setTipoDatabase(String tipoDatabase) {
        this.tipoDatabase = tipoDatabase;
    }
}

