/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop.pdd.logger;

import java.sql.Connection;
import java.util.Date;
import java.util.Vector;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPHeaderElement;
import org.apache.log4j.Logger;
import org.openspcoop.egov.Busta;
import org.openspcoop.egov.XMLBuilder;
import org.openspcoop.pdd.config.ConfigurazionePdDReader;
import org.openspcoop.pdd.config.OpenSPCoopProperties;
import org.openspcoop.pdd.core.CostantiPdD;
import org.openspcoop.pdd.core.PdDContext;
import org.openspcoop.pdd.core.handlers.GeneratoreCasualeDate;
import org.openspcoop.pdd.logger.ITracciamentoOpenSPCoopAppender;
import org.openspcoop.pdd.logger.MsgDiagnostico;
import org.openspcoop.pdd.logger.OpenSPCoopLogger;
import org.openspcoop.pdd.logger.TracciamentoException;
import org.openspcoop.pdd.logger.dto.Traccia;
import org.openspcoop.utils.date.DateManager;

public class Tracciamento {
    public static boolean tracciamentoDisponibile = true;
    public static Exception motivoMalfunzionamentoTracciamento = null;
    protected Logger loggerTracciamento = null;
    private String dominioSPCoop;
    private PdDContext pddContext;
    private Vector<ITracciamentoOpenSPCoopAppender> loggerTracciamentoOpenSPCoopAppender = null;
    private Vector<String> tipoTracciamentoOpenSPCoopAppender = null;
    private ConfigurazionePdDReader configurazionePdDReader;
    private XMLBuilder xmlBuilder;
    private MsgDiagnostico msgDiagErroreTracciamento = null;
    private OpenSPCoopProperties openspcoopProperties = null;
    private GeneratoreCasualeDate generatoreDateCasuali = null;

    public static String createLocationString(boolean bustaRicevuta, String location) {
        if (bustaRicevuta) {
            return "IN:" + location;
        }
        return "OUT:" + location;
    }

    public Tracciamento(String dominio, String idFunzione, PdDContext pddContext) {
        this.dominioSPCoop = dominio;
        this.pddContext = pddContext;
        this.loggerTracciamento = OpenSPCoopLogger.loggerTracciamento;
        this.loggerTracciamentoOpenSPCoopAppender = OpenSPCoopLogger.loggerTracciamentoOpenSPCoopAppender;
        this.tipoTracciamentoOpenSPCoopAppender = OpenSPCoopLogger.tipoTracciamentoOpenSPCoopAppender;
        this.configurazionePdDReader = ConfigurazionePdDReader.getInstance();
        this.msgDiagErroreTracciamento = new MsgDiagnostico(dominio, idFunzione);
        this.msgDiagErroreTracciamento.setPrefixMsgPersonalizzati("tracciamento.");
        this.xmlBuilder = new XMLBuilder();
        this.openspcoopProperties = OpenSPCoopProperties.getInstance();
        if (this.openspcoopProperties.generazioneDateCasualiLogAbilitato()) {
            this.generatoreDateCasuali = GeneratoreCasualeDate.getGeneratoreCasualeDate();
        }
    }

    public Tracciamento(String idFunzione, PdDContext pddContext) {
        this(OpenSPCoopProperties.getInstance().getIdentificativoPortaDefault(), idFunzione, pddContext);
    }

    public void setDominioSPCoop(String dominio) {
        this.dominioSPCoop = dominio;
    }

    @Deprecated
    public String filter(String msg) {
        String xml = msg.replaceAll("&lt;", "<");
        xml = xml.replaceAll("&quot;", "\"");
        xml = xml.replaceAll("&gt;", ">");
        return xml;
    }

    public void registraRichiesta(Connection conOpenSPCoopPdD, Busta busta, String location) throws TracciamentoException {
        this.registraRichiesta(conOpenSPCoopPdD, busta, location, null, null);
    }

    public void registraRichiesta(Connection conOpenSPCoopPdD, Busta busta, String location, String idCorrelazioneApplicativa, String servizioApplicativo) throws TracciamentoException {
        if (this.configurazionePdDReader.tracciamentoBusteEGov()) {
            String xml = null;
            boolean erroreAppender = false;
            try {
                Date gdo = DateManager.getDate();
                if (this.openspcoopProperties.generazioneDateCasualiLogAbilitato() && this.pddContext != null && this.pddContext.getObject("ID") != null) {
                    gdo = this.generatoreDateCasuali.getProssimaData((String)this.pddContext.getObject("ID"));
                    busta.setOraRegistrazione(gdo);
                }
                if (OpenSPCoopLogger.loggerTracciamentoAbilitato) {
                    xml = this.xmlBuilder.buildString_Tracciamento(busta, this.dominioSPCoop, "Richiesta");
                    if (xml == null) {
                        throw new Exception("Traccia non costruita");
                    }
                    this.loggerTracciamento.info((Object)xml);
                }
                for (int i = 0; i < this.loggerTracciamentoOpenSPCoopAppender.size(); ++i) {
                    try {
                        Traccia traccia = this.getTraccia(gdo, "Richiesta", busta, location, idCorrelazioneApplicativa, servizioApplicativo);
                        this.loggerTracciamentoOpenSPCoopAppender.get(i).log(conOpenSPCoopPdD, traccia);
                        continue;
                    }
                    catch (Exception e) {
                        OpenSPCoopLogger.loggerOpenSPCoopResources.error((Object)("Errore durante il tracciamento personalizzato [" + this.tipoTracciamentoOpenSPCoopAppender.get(i) + "] della richiesta: " + e.getMessage() + ". Traccia non registrata:\n" + xml), (Throwable)e);
                        try {
                            this.msgDiagErroreTracciamento.addKeyword("@TIPO_TRACCIA@", "Richiesta");
                            this.msgDiagErroreTracciamento.addKeyword("@TRACCIA@", xml);
                            this.msgDiagErroreTracciamento.addKeyword("@TIPO_TRACCIAMENTO_PERSONALIZZATO@", this.tipoTracciamentoOpenSPCoopAppender.get(i));
                            this.msgDiagErroreTracciamento.addKeyword("@ERRORE_TRACCIAMENTO@", e.getMessage());
                            this.msgDiagErroreTracciamento.logPersonalizzato("registrazioneNonRiuscita.openspcoopAppender");
                        }
                        catch (Exception eMsg) {
                            // empty catch block
                        }
                        if (!this.openspcoopProperties.isTracciaturaFallita_BloccaCooperazioneInCorso()) continue;
                        erroreAppender = true;
                        throw e;
                    }
                }
            }
            catch (Exception e) {
                if (xml == null && !OpenSPCoopLogger.loggerTracciamentoAbilitato) {
                    try {
                        xml = this.xmlBuilder.buildString_Tracciamento(busta, this.dominioSPCoop, "Richiesta");
                    }
                    catch (Exception eBuild) {
                        // empty catch block
                    }
                }
                if (xml == null) {
                    OpenSPCoopLogger.loggerOpenSPCoopResources.error((Object)("Errore durante la costruzione della traccia: " + e.getMessage()), (Throwable)e);
                } else {
                    OpenSPCoopLogger.loggerOpenSPCoopResources.error((Object)("Errore durante il tracciamento della richiesta: " + e.getMessage() + ". Traccia non registrata:\n" + xml), (Throwable)e);
                    if (!erroreAppender) {
                        try {
                            this.msgDiagErroreTracciamento.addKeyword("@TIPO_TRACCIA@", "Richiesta");
                            this.msgDiagErroreTracciamento.addKeyword("@TRACCIA@", xml);
                            this.msgDiagErroreTracciamento.addKeyword("@ERRORE_TRACCIAMENTO@", e.getMessage());
                            this.msgDiagErroreTracciamento.logPersonalizzato("registrazioneNonRiuscita");
                        }
                        catch (Exception eMsg) {
                            // empty catch block
                        }
                    }
                }
                this.gestioneErroreTracciamento(e);
            }
        }
    }

    public void registraRichiesta(Connection conOpenSPCoopPdD, byte[] busta, Busta bustaObject, String location) throws TracciamentoException {
        this.registraRichiesta(conOpenSPCoopPdD, busta, bustaObject, location, null, null);
    }

    public void registraRichiesta(Connection conOpenSPCoopPdD, byte[] busta, Busta bustaObject, String location, String idCorrelazioneApplicativa, String servizioApplicativo) throws TracciamentoException {
        if (this.configurazionePdDReader.tracciamentoBusteEGov()) {
            String xml = null;
            boolean erroreAppender = false;
            try {
                Date gdo = DateManager.getDate();
                if (this.openspcoopProperties.generazioneDateCasualiLogAbilitato() && this.pddContext != null && this.pddContext.getObject("ID") != null) {
                    gdo = this.generatoreDateCasuali.getProssimaData((String)this.pddContext.getObject("ID"));
                    bustaObject.setOraRegistrazione(gdo);
                }
                if (OpenSPCoopLogger.loggerTracciamentoAbilitato) {
                    xml = this.xmlBuilder.buildString_Tracciamento(busta, this.dominioSPCoop, "Richiesta");
                    if (xml == null) {
                        throw new Exception("Traccia non costruita");
                    }
                    this.loggerTracciamento.info((Object)xml);
                }
                for (int i = 0; i < this.loggerTracciamentoOpenSPCoopAppender.size(); ++i) {
                    try {
                        Traccia traccia = this.getTraccia(gdo, "Richiesta", bustaObject, location, idCorrelazioneApplicativa, servizioApplicativo);
                        this.loggerTracciamentoOpenSPCoopAppender.get(i).log(conOpenSPCoopPdD, traccia);
                        continue;
                    }
                    catch (Exception e) {
                        OpenSPCoopLogger.loggerOpenSPCoopResources.error((Object)("Errore durante il tracciamento personalizzato [" + this.tipoTracciamentoOpenSPCoopAppender.get(i) + "] della richiesta: " + e.getMessage() + ". Traccia non registrata:\n" + xml), (Throwable)e);
                        try {
                            this.msgDiagErroreTracciamento.addKeyword("@TIPO_TRACCIA@", "Richiesta");
                            this.msgDiagErroreTracciamento.addKeyword("@TRACCIA@", xml);
                            this.msgDiagErroreTracciamento.addKeyword("@TIPO_TRACCIAMENTO_PERSONALIZZATO@", this.tipoTracciamentoOpenSPCoopAppender.get(i));
                            this.msgDiagErroreTracciamento.addKeyword("@ERRORE_TRACCIAMENTO@", e.getMessage());
                            this.msgDiagErroreTracciamento.logPersonalizzato("registrazioneNonRiuscita.openspcoopAppender");
                        }
                        catch (Exception eMsg) {
                            // empty catch block
                        }
                        if (!this.openspcoopProperties.isTracciaturaFallita_BloccaCooperazioneInCorso()) continue;
                        erroreAppender = true;
                        throw e;
                    }
                }
            }
            catch (Exception e) {
                if (xml == null && !OpenSPCoopLogger.loggerTracciamentoAbilitato) {
                    try {
                        xml = this.xmlBuilder.buildString_Tracciamento(busta, this.dominioSPCoop, "Richiesta");
                    }
                    catch (Exception eBuild) {
                        // empty catch block
                    }
                }
                if (xml == null) {
                    OpenSPCoopLogger.loggerOpenSPCoopResources.error((Object)("Errore durante la costruzione della traccia: " + e.getMessage()), (Throwable)e);
                } else {
                    OpenSPCoopLogger.loggerOpenSPCoopResources.error((Object)("Errore durante il tracciamento della richiesta: " + e.getMessage() + ". Traccia non registrata:\n" + xml), (Throwable)e);
                    if (!erroreAppender) {
                        try {
                            this.msgDiagErroreTracciamento.addKeyword("@TIPO_TRACCIA@", "Richiesta");
                            this.msgDiagErroreTracciamento.addKeyword("@TRACCIA@", xml);
                            this.msgDiagErroreTracciamento.addKeyword("@ERRORE_TRACCIAMENTO@", e.getMessage());
                            this.msgDiagErroreTracciamento.logPersonalizzato("registrazioneNonRiuscita");
                        }
                        catch (Exception eMsg) {
                            // empty catch block
                        }
                    }
                }
                this.gestioneErroreTracciamento(e);
            }
        }
    }

    public void registraRichiesta(Connection conOpenSPCoopPdD, SOAPHeaderElement busta, Busta bustaObject, String location) throws TracciamentoException {
        this.registraRichiesta(conOpenSPCoopPdD, busta, bustaObject, location, null, null);
    }

    public void registraRichiesta(Connection conOpenSPCoopPdD, SOAPHeaderElement busta, Busta bustaObject, String location, String idCorrelazioneApplicativa, String servizioApplicativo) throws TracciamentoException {
        if (this.configurazionePdDReader.tracciamentoBusteEGov()) {
            String xml = null;
            boolean erroreAppender = false;
            try {
                Date gdo = DateManager.getDate();
                if (this.openspcoopProperties.generazioneDateCasualiLogAbilitato() && this.pddContext != null && this.pddContext.getObject("ID") != null) {
                    gdo = this.generatoreDateCasuali.getProssimaData((String)this.pddContext.getObject("ID"));
                    bustaObject.setOraRegistrazione(gdo);
                }
                if (OpenSPCoopLogger.loggerTracciamentoAbilitato) {
                    xml = this.xmlBuilder.buildString_Tracciamento((SOAPElement)busta, this.dominioSPCoop, "Richiesta");
                    if (xml == null) {
                        throw new Exception("Traccia non costruita");
                    }
                    this.loggerTracciamento.info((Object)xml);
                }
                for (int i = 0; i < this.loggerTracciamentoOpenSPCoopAppender.size(); ++i) {
                    try {
                        Traccia traccia = this.getTraccia(gdo, "Richiesta", bustaObject, location, idCorrelazioneApplicativa, servizioApplicativo);
                        this.loggerTracciamentoOpenSPCoopAppender.get(i).log(conOpenSPCoopPdD, traccia);
                        continue;
                    }
                    catch (Exception e) {
                        OpenSPCoopLogger.loggerOpenSPCoopResources.error((Object)("Errore durante il tracciamento personalizzato [" + this.tipoTracciamentoOpenSPCoopAppender.get(i) + "] della richiesta: " + e.getMessage() + ". Traccia non registrata:\n" + xml), (Throwable)e);
                        try {
                            this.msgDiagErroreTracciamento.addKeyword("@TIPO_TRACCIA@", "Richiesta");
                            this.msgDiagErroreTracciamento.addKeyword("@TRACCIA@", xml);
                            this.msgDiagErroreTracciamento.addKeyword("@TIPO_TRACCIAMENTO_PERSONALIZZATO@", this.tipoTracciamentoOpenSPCoopAppender.get(i));
                            this.msgDiagErroreTracciamento.addKeyword("@ERRORE_TRACCIAMENTO@", e.getMessage());
                            this.msgDiagErroreTracciamento.logPersonalizzato("registrazioneNonRiuscita.openspcoopAppender");
                        }
                        catch (Exception eMsg) {
                            // empty catch block
                        }
                        if (!this.openspcoopProperties.isTracciaturaFallita_BloccaCooperazioneInCorso()) continue;
                        erroreAppender = true;
                        throw e;
                    }
                }
            }
            catch (Exception e) {
                if (xml == null && !OpenSPCoopLogger.loggerTracciamentoAbilitato) {
                    try {
                        xml = this.xmlBuilder.buildString_Tracciamento((SOAPElement)busta, this.dominioSPCoop, "Richiesta");
                    }
                    catch (Exception eBuild) {
                        // empty catch block
                    }
                }
                if (xml == null) {
                    OpenSPCoopLogger.loggerOpenSPCoopResources.error((Object)("Errore durante la costruzione della traccia: " + e.getMessage()), (Throwable)e);
                } else {
                    OpenSPCoopLogger.loggerOpenSPCoopResources.error((Object)("Errore durante il tracciamento della richiesta: " + e.getMessage() + ". Traccia non registrata:\n" + xml), (Throwable)e);
                    if (!erroreAppender) {
                        try {
                            this.msgDiagErroreTracciamento.addKeyword("@TIPO_TRACCIA@", "Richiesta");
                            this.msgDiagErroreTracciamento.addKeyword("@TRACCIA@", xml);
                            this.msgDiagErroreTracciamento.addKeyword("@ERRORE_TRACCIAMENTO@", e.getMessage());
                            this.msgDiagErroreTracciamento.logPersonalizzato("registrazioneNonRiuscita");
                        }
                        catch (Exception eMsg) {
                            // empty catch block
                        }
                    }
                }
                this.gestioneErroreTracciamento(e);
            }
        }
    }

    public void registraRisposta(Connection conOpenSPCoopPdD, Busta busta, String location) throws TracciamentoException {
        this.registraRisposta(conOpenSPCoopPdD, busta, location, null, null);
    }

    public void registraRisposta(Connection conOpenSPCoopPdD, Busta busta, String location, String idCorrelazioneApplicativa, String servizioApplicativo) throws TracciamentoException {
        if (this.configurazionePdDReader.tracciamentoBusteEGov()) {
            String xml = null;
            boolean erroreAppender = false;
            try {
                Date gdo = DateManager.getDate();
                if (this.openspcoopProperties.generazioneDateCasualiLogAbilitato() && this.pddContext != null && this.pddContext.getObject("ID") != null) {
                    gdo = this.generatoreDateCasuali.getProssimaData((String)this.pddContext.getObject("ID"));
                    busta.setOraRegistrazione(gdo);
                }
                if (OpenSPCoopLogger.loggerTracciamentoAbilitato) {
                    xml = this.xmlBuilder.buildString_Tracciamento(busta, this.dominioSPCoop, "Risposta");
                    if (xml == null) {
                        throw new Exception("Traccia non costruita");
                    }
                    this.loggerTracciamento.info((Object)xml);
                }
                for (int i = 0; i < this.loggerTracciamentoOpenSPCoopAppender.size(); ++i) {
                    try {
                        Traccia traccia = this.getTraccia(gdo, "Risposta", busta, location, idCorrelazioneApplicativa, servizioApplicativo);
                        this.loggerTracciamentoOpenSPCoopAppender.get(i).log(conOpenSPCoopPdD, traccia);
                        continue;
                    }
                    catch (Exception e) {
                        OpenSPCoopLogger.loggerOpenSPCoopResources.error((Object)("Errore durante il tracciamento personalizzato [" + this.tipoTracciamentoOpenSPCoopAppender.get(i) + "] della risposta: " + e.getMessage() + ". Traccia non registrata:\n" + xml), (Throwable)e);
                        try {
                            this.msgDiagErroreTracciamento.addKeyword("@TIPO_TRACCIA@", "Risposta");
                            this.msgDiagErroreTracciamento.addKeyword("@TRACCIA@", xml);
                            this.msgDiagErroreTracciamento.addKeyword("@TIPO_TRACCIAMENTO_PERSONALIZZATO@", this.tipoTracciamentoOpenSPCoopAppender.get(i));
                            this.msgDiagErroreTracciamento.addKeyword("@ERRORE_TRACCIAMENTO@", e.getMessage());
                            this.msgDiagErroreTracciamento.logPersonalizzato("registrazioneNonRiuscita.openspcoopAppender");
                        }
                        catch (Exception eMsg) {
                            // empty catch block
                        }
                        if (!this.openspcoopProperties.isTracciaturaFallita_BloccaCooperazioneInCorso()) continue;
                        erroreAppender = true;
                        throw e;
                    }
                }
            }
            catch (Exception e) {
                if (xml == null && !OpenSPCoopLogger.loggerTracciamentoAbilitato) {
                    try {
                        xml = this.xmlBuilder.buildString_Tracciamento(busta, this.dominioSPCoop, "Risposta");
                    }
                    catch (Exception eBuild) {
                        // empty catch block
                    }
                }
                if (xml == null) {
                    OpenSPCoopLogger.loggerOpenSPCoopResources.error((Object)("Errore durante la costruzione della traccia: " + e.getMessage()), (Throwable)e);
                } else {
                    OpenSPCoopLogger.loggerOpenSPCoopResources.error((Object)("Errore durante il tracciamento della risposta: " + e.getMessage() + ". Traccia non registrata:\n" + xml), (Throwable)e);
                    if (!erroreAppender) {
                        try {
                            this.msgDiagErroreTracciamento.addKeyword("@TIPO_TRACCIA@", "Risposta");
                            this.msgDiagErroreTracciamento.addKeyword("@TRACCIA@", xml);
                            this.msgDiagErroreTracciamento.addKeyword("@ERRORE_TRACCIAMENTO@", e.getMessage());
                            this.msgDiagErroreTracciamento.logPersonalizzato("registrazioneNonRiuscita");
                        }
                        catch (Exception eMsg) {
                            // empty catch block
                        }
                    }
                }
                this.gestioneErroreTracciamento(e);
            }
        }
    }

    public void registraRisposta(Connection conOpenSPCoopPdD, byte[] busta, Busta bustaObject, String location) throws TracciamentoException {
        this.registraRisposta(conOpenSPCoopPdD, busta, bustaObject, location, null, null);
    }

    public void registraRisposta(Connection conOpenSPCoopPdD, byte[] busta, Busta bustaObject, String location, String idCorrelazioneApplicativa, String servizioApplicativo) throws TracciamentoException {
        if (this.configurazionePdDReader.tracciamentoBusteEGov()) {
            String xml = null;
            boolean erroreAppender = false;
            try {
                Date gdo = DateManager.getDate();
                if (this.openspcoopProperties.generazioneDateCasualiLogAbilitato() && this.pddContext != null && this.pddContext.getObject("ID") != null) {
                    gdo = this.generatoreDateCasuali.getProssimaData((String)this.pddContext.getObject("ID"));
                    bustaObject.setOraRegistrazione(gdo);
                }
                if (OpenSPCoopLogger.loggerTracciamentoAbilitato) {
                    xml = this.xmlBuilder.buildString_Tracciamento(busta, this.dominioSPCoop, "Risposta");
                    if (xml == null) {
                        throw new Exception("Traccia non costruita");
                    }
                    this.loggerTracciamento.info((Object)xml);
                }
                for (int i = 0; i < this.loggerTracciamentoOpenSPCoopAppender.size(); ++i) {
                    try {
                        Traccia traccia = this.getTraccia(gdo, "Risposta", bustaObject, location, idCorrelazioneApplicativa, servizioApplicativo);
                        this.loggerTracciamentoOpenSPCoopAppender.get(i).log(conOpenSPCoopPdD, traccia);
                        continue;
                    }
                    catch (Exception e) {
                        OpenSPCoopLogger.loggerOpenSPCoopResources.error((Object)("Errore durante il tracciamento personalizzato [" + this.tipoTracciamentoOpenSPCoopAppender.get(i) + "] della risposta: " + e.getMessage() + ". Traccia non registrata:\n" + xml), (Throwable)e);
                        try {
                            this.msgDiagErroreTracciamento.addKeyword("@TIPO_TRACCIA@", "Risposta");
                            this.msgDiagErroreTracciamento.addKeyword("@TRACCIA@", xml);
                            this.msgDiagErroreTracciamento.addKeyword("@TIPO_TRACCIAMENTO_PERSONALIZZATO@", this.tipoTracciamentoOpenSPCoopAppender.get(i));
                            this.msgDiagErroreTracciamento.addKeyword("@ERRORE_TRACCIAMENTO@", e.getMessage());
                            this.msgDiagErroreTracciamento.logPersonalizzato("registrazioneNonRiuscita.openspcoopAppender");
                        }
                        catch (Exception eMsg) {
                            // empty catch block
                        }
                        if (!this.openspcoopProperties.isTracciaturaFallita_BloccaCooperazioneInCorso()) continue;
                        erroreAppender = true;
                        throw e;
                    }
                }
            }
            catch (Exception e) {
                if (xml == null && !OpenSPCoopLogger.loggerTracciamentoAbilitato) {
                    try {
                        xml = this.xmlBuilder.buildString_Tracciamento(busta, this.dominioSPCoop, "Risposta");
                    }
                    catch (Exception eBuild) {
                        // empty catch block
                    }
                }
                if (xml == null) {
                    OpenSPCoopLogger.loggerOpenSPCoopResources.error((Object)("Errore durante la costruzione della traccia: " + e.getMessage()), (Throwable)e);
                } else {
                    OpenSPCoopLogger.loggerOpenSPCoopResources.error((Object)("Errore durante il tracciamento della risposta: " + e.getMessage() + ". Traccia non registrata:\n" + xml), (Throwable)e);
                    if (!erroreAppender) {
                        try {
                            this.msgDiagErroreTracciamento.addKeyword("@TIPO_TRACCIA@", "Risposta");
                            this.msgDiagErroreTracciamento.addKeyword("@TRACCIA@", xml);
                            this.msgDiagErroreTracciamento.addKeyword("@ERRORE_TRACCIAMENTO@", e.getMessage());
                            this.msgDiagErroreTracciamento.logPersonalizzato("registrazioneNonRiuscita");
                        }
                        catch (Exception eMsg) {
                            // empty catch block
                        }
                    }
                }
                this.gestioneErroreTracciamento(e);
            }
        }
    }

    public void registraRisposta(Connection conOpenSPCoopPdD, SOAPHeaderElement busta, Busta bustaObject, String location) throws TracciamentoException {
        this.registraRisposta(conOpenSPCoopPdD, busta, bustaObject, location, null, null);
    }

    public void registraRisposta(Connection conOpenSPCoopPdD, SOAPHeaderElement busta, Busta bustaObject, String location, String idCorrelazioneApplicativa, String servizioApplicativo) throws TracciamentoException {
        if (this.configurazionePdDReader.tracciamentoBusteEGov()) {
            String xml = null;
            boolean erroreAppender = false;
            try {
                Date gdo = DateManager.getDate();
                if (this.openspcoopProperties.generazioneDateCasualiLogAbilitato() && this.pddContext != null && this.pddContext.getObject("ID") != null) {
                    gdo = this.generatoreDateCasuali.getProssimaData((String)this.pddContext.getObject("ID"));
                    bustaObject.setOraRegistrazione(gdo);
                }
                if (OpenSPCoopLogger.loggerTracciamentoAbilitato) {
                    xml = this.xmlBuilder.buildString_Tracciamento((SOAPElement)busta, this.dominioSPCoop, "Risposta");
                    if (xml == null) {
                        throw new Exception("Traccia non costruita");
                    }
                    this.loggerTracciamento.info((Object)xml);
                }
                for (int i = 0; i < this.loggerTracciamentoOpenSPCoopAppender.size(); ++i) {
                    try {
                        Traccia traccia = this.getTraccia(gdo, "Risposta", bustaObject, location, idCorrelazioneApplicativa, servizioApplicativo);
                        this.loggerTracciamentoOpenSPCoopAppender.get(i).log(conOpenSPCoopPdD, traccia);
                        continue;
                    }
                    catch (Exception e) {
                        OpenSPCoopLogger.loggerOpenSPCoopResources.error((Object)("Errore durante il tracciamento personalizzato [" + this.tipoTracciamentoOpenSPCoopAppender.get(i) + "] della risposta: " + e.getMessage() + ". Traccia non registrata:\n" + xml), (Throwable)e);
                        try {
                            this.msgDiagErroreTracciamento.addKeyword("@TIPO_TRACCIA@", "Risposta");
                            this.msgDiagErroreTracciamento.addKeyword("@TRACCIA@", xml);
                            this.msgDiagErroreTracciamento.addKeyword("@TIPO_TRACCIAMENTO_PERSONALIZZATO@", this.tipoTracciamentoOpenSPCoopAppender.get(i));
                            this.msgDiagErroreTracciamento.addKeyword("@ERRORE_TRACCIAMENTO@", e.getMessage());
                            this.msgDiagErroreTracciamento.logPersonalizzato("registrazioneNonRiuscita.openspcoopAppender");
                        }
                        catch (Exception eMsg) {
                            // empty catch block
                        }
                        if (!this.openspcoopProperties.isTracciaturaFallita_BloccaCooperazioneInCorso()) continue;
                        erroreAppender = true;
                        throw e;
                    }
                }
            }
            catch (Exception e) {
                if (xml == null && !OpenSPCoopLogger.loggerTracciamentoAbilitato) {
                    try {
                        xml = this.xmlBuilder.buildString_Tracciamento((SOAPElement)busta, this.dominioSPCoop, "Risposta");
                    }
                    catch (Exception eBuild) {
                        // empty catch block
                    }
                }
                if (xml == null) {
                    OpenSPCoopLogger.loggerOpenSPCoopResources.error((Object)("Errore durante la costruzione della traccia: " + e.getMessage()), (Throwable)e);
                } else {
                    OpenSPCoopLogger.loggerOpenSPCoopResources.error((Object)("Errore durante il tracciamento della risposta: " + e.getMessage() + ". Traccia non registrata:\n" + xml), (Throwable)e);
                    if (!erroreAppender) {
                        try {
                            this.msgDiagErroreTracciamento.addKeyword("@TIPO_TRACCIA@", "Risposta");
                            this.msgDiagErroreTracciamento.addKeyword("@TRACCIA@", xml);
                            this.msgDiagErroreTracciamento.addKeyword("@ERRORE_TRACCIAMENTO@", e.getMessage());
                            this.msgDiagErroreTracciamento.logPersonalizzato("registrazioneNonRiuscita");
                        }
                        catch (Exception eMsg) {
                            // empty catch block
                        }
                    }
                }
                this.gestioneErroreTracciamento(e);
            }
        }
    }

    private Traccia getTraccia(Date gdo, String tipoTraccia, Busta busta, String location, String idCorrelazioneApplicativa, String servizioApplicativo) {
        String[] key;
        Traccia traccia = new Traccia();
        traccia.setGdo(gdo);
        traccia.setIdporta(this.dominioSPCoop);
        traccia.setTipoMessaggio(tipoTraccia);
        traccia.setBusta(busta);
        traccia.setCorrelazioneApplicativa(idCorrelazioneApplicativa);
        traccia.setLocation(location);
        traccia.setServizioApplicativoFruitore(servizioApplicativo);
        if (this.pddContext != null && (key = CostantiPdD.CONTEXT_OBJECT) != null) {
            for (int j = 0; j < key.length; ++j) {
                Object o = this.pddContext.getObject(key[j]);
                if (o == null || !(o instanceof String)) continue;
                traccia.addProperty(key[j], (String)o);
            }
        }
        return traccia;
    }

    private void gestioneErroreTracciamento(Exception e) throws TracciamentoException {
        if (this.openspcoopProperties.isTracciaturaFallita_BloccoServiziPdD()) {
            tracciamentoDisponibile = false;
            motivoMalfunzionamentoTracciamento = e;
            try {
                this.msgDiagErroreTracciamento.logPersonalizzato("errore.bloccoServizi");
            }
            catch (Exception exception) {
                // empty catch block
            }
            OpenSPCoopLogger.loggerOpenSPCoopResources.error((Object)"Il Sistema di tracciamento ha rilevato un errore durante la registrazione di una traccia legale, tutti i servizi/moduli della porta di dominio sono sospesi. Si richiede un intervento sistemistico per la risoluzione del problema e il riavvio della Porta di Dominio. Errore rilevato: ", (Throwable)e);
        }
        if (this.openspcoopProperties.isTracciaturaFallita_BloccaCooperazioneInCorso()) {
            throw new TracciamentoException(e);
        }
    }
}

