/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop.pdd.logger;

import java.io.File;
import java.io.FileInputStream;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;
import org.openspcoop.dao.commons.IDSoggetto;
import org.openspcoop.dao.config.MessaggiDiagnostici;
import org.openspcoop.dao.config.Tracciamento;
import org.openspcoop.dao.registry.driver.IDServizio;
import org.openspcoop.egov.Imbustamento;
import org.openspcoop.pdd.config.ClassNameProperties;
import org.openspcoop.pdd.config.OpenSPCoopProperties;
import org.openspcoop.pdd.config.PropertiesUtilities;
import org.openspcoop.pdd.core.IPdDContextSerializer;
import org.openspcoop.pdd.logger.IDumpOpenSPCoopAppender;
import org.openspcoop.pdd.logger.IMsgDiagnosticoOpenSPCoopAppender;
import org.openspcoop.pdd.logger.ITracciamentoOpenSPCoopAppender;
import org.openspcoop.pdd.logger.LogLevels;
import org.openspcoop.pdd.logger.dto.MsgDiagnostico;
import org.openspcoop.utils.Loader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OpenSPCoopLogger {
    protected static Logger loggerTracciamento = null;
    protected static boolean loggerTracciamentoAbilitato = false;
    protected static Logger loggerMsgDiagnostico = null;
    protected static boolean loggerMsgDiagnosticoAbilitato = false;
    protected static Logger loggerOpenSPCoop = null;
    protected static boolean loggerMsgDiagnosticoReadableAbilitato = false;
    protected static Logger loggerIntegrationManager = null;
    protected static boolean loggerIntegrationManagerAbilitato = false;
    protected static Logger loggerDump = null;
    protected static boolean loggerDumpAbilitato = false;
    protected static Logger loggerOpenSPCoopConsole = Logger.getLogger((String)"openspcoop.startup");
    protected static Logger loggerOpenSPCoopCore = null;
    protected static Logger loggerOpenSPCoopResources = null;
    protected static Vector<IMsgDiagnosticoOpenSPCoopAppender> loggerMsgDiagnosticoOpenSPCoopAppender = new Vector();
    protected static Vector<String> tipoMsgDiagnosticoOpenSPCoopAppender = new Vector();
    protected static Vector<ITracciamentoOpenSPCoopAppender> loggerTracciamentoOpenSPCoopAppender = new Vector();
    protected static Vector<String> tipoTracciamentoOpenSPCoopAppender = new Vector();
    protected static Vector<IDumpOpenSPCoopAppender> loggerDumpOpenSPCoopAppender = new Vector();
    protected static Vector<String> tipoDumpOpenSPCoopAppender = new Vector();
    private static IPdDContextSerializer pddContextSerializer = null;

    public static boolean initializeLogConsole(Logger logConsole) {
        try {
            Properties loggerProperties = new Properties();
            if (OpenSPCoopLogger.class.getResourceAsStream("/logger.log4j.properties") != null) {
                loggerProperties.load(OpenSPCoopLogger.class.getResourceAsStream("/logger.log4j.properties"));
            }
            PropertyConfigurator.configure((Properties)loggerProperties);
            return true;
        }
        catch (Exception e) {
            loggerOpenSPCoopConsole.error((Object)("Riscontrato errore durante l'inizializzazione del sistema di logging di OpenSPCoop: " + e.getMessage()), (Throwable)e);
            return false;
        }
    }

    public static boolean initialize(Logger logConsole, String rootDirectory, Properties objectProperties) {
        try {
            String value;
            String key;
            Enumeration<Object> ridefinito;
            Properties loggerProperties = new Properties();
            File loggerFile = new File(rootDirectory + "logger.log4j.properties");
            if (!loggerFile.exists()) {
                loggerProperties.load(OpenSPCoopLogger.class.getResourceAsStream("/logger.log4j.properties"));
            } else {
                loggerProperties.load(new FileInputStream(loggerFile));
            }
            Properties loggerPropertiesRidefinito = PropertiesUtilities.searchLocalImplementation(logConsole, "OPENSPCOOP_LOGGER_PROPERTIES", "logger_local.properties", rootDirectory);
            if (loggerPropertiesRidefinito != null && loggerPropertiesRidefinito.size() > 0) {
                ridefinito = loggerPropertiesRidefinito.keys();
                while (ridefinito.hasMoreElements()) {
                    key = (String)ridefinito.nextElement();
                    value = (String)loggerPropertiesRidefinito.get(key);
                    if (loggerProperties.containsKey(key)) {
                        loggerProperties.remove(key);
                    }
                    loggerProperties.put(key, value);
                }
            }
            if (objectProperties != null && objectProperties.size() > 0) {
                ridefinito = objectProperties.keys();
                while (ridefinito.hasMoreElements()) {
                    key = (String)ridefinito.nextElement();
                    value = (String)objectProperties.get(key);
                    if (loggerProperties.containsKey(key)) {
                        loggerProperties.remove(key);
                    }
                    loggerProperties.put(key, value);
                }
            }
            PropertyConfigurator.configure((Properties)loggerProperties);
            loggerTracciamento = Logger.getLogger((String)"openspcoop.tracciamento");
            if (loggerTracciamento == null) {
                throw new Exception("Logger openspcoop.tracciamento non trovato");
            }
            String tmp = loggerProperties.getProperty("log4j.category.openspcoop.tracciamento");
            if (tmp != null) {
                tmp.trim();
                if (tmp.startsWith("OFF")) {
                    loggerOpenSPCoopConsole.info((Object)"Sistema di logging delle tracce disabilitato da log4j (OFF).");
                    loggerTracciamentoAbilitato = false;
                } else {
                    loggerTracciamentoAbilitato = true;
                }
            }
            if ((loggerMsgDiagnostico = Logger.getLogger((String)"openspcoop.msgDiagnostico")) == null) {
                throw new Exception("Logger openspcoop.msgDiagnostico non trovato");
            }
            tmp = loggerProperties.getProperty("log4j.category.openspcoop.msgDiagnostico");
            if (tmp != null) {
                tmp.trim();
                if (tmp.startsWith("OFF")) {
                    loggerOpenSPCoopConsole.info((Object)"Sistema di logging dei messaggi diagnostici disabilitato da log4j (OFF).");
                    loggerMsgDiagnosticoAbilitato = false;
                } else {
                    loggerMsgDiagnosticoAbilitato = true;
                }
            }
            if ((loggerOpenSPCoop = Logger.getLogger((String)"openspcoop.portaDiDominio")) == null) {
                throw new Exception("Logger openspcoop.portaDiDominio non trovato");
            }
            tmp = loggerProperties.getProperty("log4j.category.openspcoop.portaDiDominio");
            if (tmp != null) {
                tmp.trim();
                if (tmp.startsWith("OFF")) {
                    loggerOpenSPCoopConsole.info((Object)"Sistema di logging dei messaggi diagnostici 'readable' disabilitato da log4j (OFF).");
                    loggerMsgDiagnosticoReadableAbilitato = false;
                } else {
                    loggerMsgDiagnosticoReadableAbilitato = true;
                }
            }
            if ((loggerIntegrationManager = Logger.getLogger((String)"openspcoop.integrationManager")) == null) {
                throw new Exception("Logger openspcoop.integrationManager non trovato");
            }
            tmp = loggerProperties.getProperty("log4j.category.openspcoop.integrationManager");
            if (tmp != null) {
                tmp.trim();
                if (tmp.startsWith("OFF")) {
                    loggerOpenSPCoopConsole.info((Object)"Sistema di logging dei messaggi diagnostici 'readable' per il servizio di IntegrationManager disabilitato da log4j (OFF).");
                    loggerIntegrationManagerAbilitato = false;
                } else {
                    loggerIntegrationManagerAbilitato = true;
                }
            }
            if ((loggerDump = Logger.getLogger((String)"openspcoop.dump")) == null) {
                throw new Exception("Logger openspcoop.dump non trovato");
            }
            tmp = loggerProperties.getProperty("log4j.category.openspcoop.dump");
            if (tmp != null) {
                tmp.trim();
                if (tmp.startsWith("OFF")) {
                    loggerOpenSPCoopConsole.info((Object)"Sistema di logging dei contenuti applicativi (dump) disabilitato da log4j (OFF).");
                    loggerDumpAbilitato = false;
                } else {
                    loggerDumpAbilitato = true;
                }
            }
            if ((loggerOpenSPCoopCore = Logger.getLogger((String)"openspcoop.core")) == null) {
                throw new Exception("Logger openspcoop.core non trovato");
            }
            loggerOpenSPCoopResources = Logger.getLogger((String)"openspcoop.resources");
            if (loggerOpenSPCoopResources == null) {
                throw new Exception("Logger openspcoop.resources non trovato");
            }
            loggerOpenSPCoopConsole.info((Object)"Sistema di logging correttamente inizializzato.");
            OpenSPCoopProperties propertiesReader = OpenSPCoopProperties.getInstance();
            String pddContextSerializerClass = propertiesReader.getPddContextSerializer();
            if (pddContextSerializerClass != null && !"none".equals(pddContextSerializerClass)) {
                try {
                    pddContextSerializer = (IPdDContextSerializer)Loader.getInstance().newInstance(pddContextSerializerClass);
                }
                catch (Exception e) {
                    throw new Exception("Inizializzione IPdDContextSerializer non riuscita [" + pddContextSerializerClass + "]:" + e.getMessage(), e);
                }
            }
            return true;
        }
        catch (Exception e) {
            loggerOpenSPCoopConsole.error((Object)("Riscontrato errore durante l'inizializzazione del sistema di logging di OpenSPCoop: " + e.getMessage()), (Throwable)e);
            return false;
        }
    }

    public static boolean initializeMsgDiagnosticiOpenSPCoopAppender(MessaggiDiagnostici msgDiagConfig) {
        try {
            if (msgDiagConfig != null) {
                ClassNameProperties prop = ClassNameProperties.getInstance();
                for (int i = 0; i < msgDiagConfig.sizeOpenspcoopAppenderList(); ++i) {
                    String msgDiagAppenderClass = prop.getMsgDiagnosticoOpenSPCoopAppender(msgDiagConfig.getOpenspcoopAppender(i).getTipo());
                    if (msgDiagAppenderClass == null) {
                        throw new Exception("Riscontrato errore durante il caricamento del msg diagnostico appender [" + msgDiagConfig.getOpenspcoopAppender(i).getTipo() + "]: appender non registrato.");
                    }
                    IMsgDiagnosticoOpenSPCoopAppender appender = null;
                    try {
                        appender = (IMsgDiagnosticoOpenSPCoopAppender)Loader.getInstance().newInstance(msgDiagAppenderClass);
                        appender.initializeAppender(msgDiagConfig.getOpenspcoopAppender(i));
                    }
                    catch (ClassNotFoundException e) {
                        throw new Exception("Riscontrato errore durante il caricamento del msg diagnostico appender specificato [" + msgDiagConfig.getOpenspcoopAppender(i).getTipo() + "]: " + e.getMessage());
                    }
                    catch (Exception e) {
                        throw new Exception("Riscontrato errore durante l'inizializzazione del msg diagnostico appender specificato [" + msgDiagConfig.getOpenspcoopAppender(i).getTipo() + "]: " + e.getMessage());
                    }
                    loggerMsgDiagnosticoOpenSPCoopAppender.add(appender);
                    tipoMsgDiagnosticoOpenSPCoopAppender.add(msgDiagConfig.getOpenspcoopAppender(i).getTipo());
                    loggerOpenSPCoopConsole.info((Object)("Sistema di logging: MsgDiagnosticoOpenSPCoopAppender di tipo [" + msgDiagConfig.getOpenspcoopAppender(i).getTipo() + "] correttamente inizializzato."));
                }
            }
            return true;
        }
        catch (Exception e) {
            loggerMsgDiagnosticoOpenSPCoopAppender.clear();
            loggerOpenSPCoopConsole.error((Object)("Riscontrato errore durante l'inizializzazione degli appender personalizzati per msg diagnostici: " + e.getMessage()));
            return false;
        }
    }

    public static boolean initializeTracciamentoOpenSPCoopAppender(Tracciamento tracciamentoConfig) {
        try {
            if (tracciamentoConfig != null) {
                ClassNameProperties prop = ClassNameProperties.getInstance();
                for (int i = 0; i < tracciamentoConfig.sizeOpenspcoopAppenderList(); ++i) {
                    String tracciamentoAppenderClass = prop.getTracciamentoOpenSPCoopAppender(tracciamentoConfig.getOpenspcoopAppender(i).getTipo());
                    if (tracciamentoAppenderClass == null) {
                        throw new Exception("Riscontrato errore durante il caricamento del tracciamento appender [" + tracciamentoConfig.getOpenspcoopAppender(i).getTipo() + "]: appender non registrato.");
                    }
                    ITracciamentoOpenSPCoopAppender appender = null;
                    try {
                        Object o = Loader.getInstance().newInstance(tracciamentoAppenderClass);
                        if (o instanceof ITracciamentoOpenSPCoopAppender) {
                            appender = (ITracciamentoOpenSPCoopAppender)o;
                            appender.initializeAppender(tracciamentoConfig.getOpenspcoopAppender(i));
                        } else if (!(o instanceof IDumpOpenSPCoopAppender)) {
                            throw new Exception("OpenSPCoop Appender non \u00e8 compatibile ne per registrare le tracce, ne per registrare i contenuti applicativi");
                        }
                        if (appender == null) continue;
                        loggerTracciamentoOpenSPCoopAppender.add(appender);
                        tipoTracciamentoOpenSPCoopAppender.add(tracciamentoConfig.getOpenspcoopAppender(i).getTipo());
                        loggerOpenSPCoopConsole.info((Object)("Sistema di logging: TracciamentoOpenSPCoopAppender di tipo [" + tracciamentoConfig.getOpenspcoopAppender(i).getTipo() + "] correttamente inizializzato."));
                        continue;
                    }
                    catch (ClassNotFoundException e) {
                        throw new Exception("Riscontrato errore durante il caricamento del tracciamento appender specificato [" + tracciamentoConfig.getOpenspcoopAppender(i).getTipo() + "]: " + e.getMessage());
                    }
                    catch (Exception e) {
                        throw new Exception("Riscontrato errore durante l'inizializzazione del tracciamento appender specificato [" + tracciamentoConfig.getOpenspcoopAppender(i).getTipo() + "]: " + e.getMessage());
                    }
                }
            }
            return true;
        }
        catch (Exception e) {
            loggerTracciamentoOpenSPCoopAppender.clear();
            loggerOpenSPCoopConsole.error((Object)("Riscontrato errore durante l'inizializzazione degli appender personalizzati per il tracciamento: " + e.getMessage()));
            return false;
        }
    }

    public static boolean initializeDumpOpenSPCoopAppender(Tracciamento tracciamentoConfig) {
        try {
            if (tracciamentoConfig != null) {
                ClassNameProperties prop = ClassNameProperties.getInstance();
                for (int i = 0; i < tracciamentoConfig.sizeOpenspcoopAppenderList(); ++i) {
                    String dumpAppenderClass = prop.getTracciamentoOpenSPCoopAppender(tracciamentoConfig.getOpenspcoopAppender(i).getTipo());
                    if (dumpAppenderClass == null) {
                        throw new Exception("Riscontrato errore durante il caricamento del tracciamento appender [" + tracciamentoConfig.getOpenspcoopAppender(i).getTipo() + "]: appender non registrato.");
                    }
                    IDumpOpenSPCoopAppender appender = null;
                    try {
                        Object o = Loader.getInstance().newInstance(dumpAppenderClass);
                        if (o instanceof IDumpOpenSPCoopAppender) {
                            appender = (IDumpOpenSPCoopAppender)o;
                            appender.initializeAppender(tracciamentoConfig.getOpenspcoopAppender(i));
                        } else if (!(o instanceof ITracciamentoOpenSPCoopAppender)) {
                            throw new Exception("OpenSPCoop Appender non \u00e8 compatibile ne per registrare le tracce, ne per registrare i contenuti applicativi");
                        }
                        if (appender == null) continue;
                        loggerDumpOpenSPCoopAppender.add(appender);
                        tipoDumpOpenSPCoopAppender.add(tracciamentoConfig.getOpenspcoopAppender(i).getTipo());
                        loggerOpenSPCoopConsole.info((Object)("Sistema di logging: DumpOpenSPCoopAppender di tipo [" + tracciamentoConfig.getOpenspcoopAppender(i).getTipo() + "] correttamente inizializzato."));
                        continue;
                    }
                    catch (ClassNotFoundException e) {
                        throw new Exception("Riscontrato errore durante il caricamento del dump appender specificato [" + tracciamentoConfig.getOpenspcoopAppender(i).getTipo() + "]: " + e.getMessage());
                    }
                    catch (Exception e) {
                        throw new Exception("Riscontrato errore durante l'inizializzazione del dump appender specificato [" + tracciamentoConfig.getOpenspcoopAppender(i).getTipo() + "]: " + e.getMessage());
                    }
                }
            }
            return true;
        }
        catch (Exception e) {
            loggerDumpOpenSPCoopAppender.clear();
            loggerOpenSPCoopConsole.error((Object)("Riscontrato errore durante l'inizializzazione degli appender personalizzati per il dump applicativo: " + e.getMessage()));
            return false;
        }
    }

    protected static String humanReadable(String xml, String idEGov) {
        int indexFinish;
        int indexStart = xml.indexOf("MessaggioDiagnostico");
        StringBuffer bf = new StringBuffer();
        for (int i = 1; i < indexStart; ++i) {
            bf.append(xml.charAt(i));
        }
        String xmnls = bf.toString();
        String livello = null;
        int valueLivello = -1;
        indexStart = xml.indexOf("<" + xmnls + "LivelloDiSeverita");
        if (indexStart != -1 && (indexFinish = xml.indexOf("</" + xmnls + "LivelloDiSeverita>")) != -1) {
            livello = xml.substring(indexStart + xmnls.length() + 19, indexFinish);
        }
        try {
            Integer test = new Integer(livello);
            valueLivello = test;
        }
        catch (Exception e) {
            String errorCompatibilitaAxis = " xmlns:xsi=\"http://www.w3.org/1999/XMLSchema-instance\"";
            indexStart = xml.indexOf("<" + xmnls + "LivelloDiSeverita");
            if (indexStart != -1 && (indexFinish = xml.indexOf("</" + xmnls + "LivelloDiSeverita>")) != -1) {
                livello = xml.substring(indexStart + xmnls.length() + 19 + errorCompatibilitaAxis.length(), indexFinish);
            }
            try {
                Integer test = new Integer(livello);
                valueLivello = test;
            }
            catch (Exception er) {
                valueLivello = -1;
            }
        }
        String ora = "N.D.";
        indexStart = xml.indexOf("<" + xmnls + "OraRegistrazione");
        if (indexStart != -1 && (indexFinish = xml.indexOf("</" + xmnls + "OraRegistrazione>")) != -1) {
            ora = xml.substring(indexStart + xmnls.length() + 20, indexStart + xmnls.length() + 20 + 19).replace('T', ' ');
        }
        String idPorta = "?PDD_Inesistente?";
        indexStart = xml.indexOf("<" + xmnls + "IdentificativoPorta");
        if (indexStart != -1 && (indexFinish = xml.indexOf("</" + xmnls + "IdentificativoPorta>")) != -1) {
            idPorta = xml.substring(indexStart + xmnls.length() + 21, indexFinish);
        }
        String idFunzione = "?Funzione_Inesistente?";
        indexStart = xml.indexOf("<" + xmnls + "IdentificativoFunzione");
        if (indexStart != -1 && (indexFinish = xml.indexOf("</" + xmnls + "IdentificativoFunzione>")) != -1) {
            idFunzione = xml.substring(indexStart + xmnls.length() + 24, indexFinish);
        }
        String text = "?N.D.?";
        indexStart = xml.indexOf("<" + xmnls + "TestoDiagnostico");
        if (indexStart != -1 && (indexFinish = xml.indexOf("</" + xmnls + "TestoDiagnostico>")) != -1) {
            text = xml.substring(indexStart + xmnls.length() + 18, indexFinish);
        }
        StringBuffer showMsg = new StringBuffer();
        showMsg.append(idPorta);
        showMsg.append(" <");
        showMsg.append(ora);
        showMsg.append("> ");
        showMsg.append("MsgDiagnostico(");
        showMsg.append(LogLevels.toOpenSPCoop(valueLivello).toString());
        showMsg.append(") [");
        showMsg.append(idFunzione);
        showMsg.append("] ");
        if (idEGov != null) {
            showMsg.append("\nID: ");
            showMsg.append(idEGov);
        }
        showMsg.append("\n");
        showMsg.append(text);
        showMsg.append("\n");
        return showMsg.toString();
    }

    protected static String humanReadable(MsgDiagnostico msgDiag, String idCorrelazioneApplicativa, String porta, boolean delegata, IDSoggetto fruitore, IDServizio servizio, String servizioApplicativo) {
        Hashtable<String, String> contextSerializerParameters;
        Date gdo = msgDiag.getGdo().getTime();
        String idPorta = msgDiag.getIdPorta();
        String idFunzione = msgDiag.getIdFunzione();
        int valueLivello = Integer.parseInt(msgDiag.getSeverita());
        String text = msgDiag.getMessaggio();
        String idEGov = msgDiag.getIdEgov();
        String codiceDiagnostico = msgDiag.getCodice();
        StringBuffer showMsg = new StringBuffer();
        if (pddContextSerializer != null && (contextSerializerParameters = pddContextSerializer.getLoggerKeywords()) != null && contextSerializerParameters.size() > 0) {
            Enumeration<String> keywordContext = contextSerializerParameters.keys();
            while (keywordContext.hasMoreElements()) {
                String keyword = keywordContext.nextElement();
                if (msgDiag.getPropertiesNames() == null) continue;
                String[] propertyNames = msgDiag.getPropertiesNames();
                for (int i = 0; i < propertyNames.length; ++i) {
                    if (!keyword.equals(propertyNames[i])) continue;
                    if (showMsg.length() > 0) {
                        showMsg.append(" ");
                    }
                    showMsg.append(propertyNames[i] + ":");
                    showMsg.append(msgDiag.getProperty(propertyNames[i]));
                }
            }
        }
        if (codiceDiagnostico != null) {
            if (showMsg.length() > 0) {
                showMsg.append(" ");
            }
            showMsg.append(codiceDiagnostico);
            showMsg.append(" ");
        }
        showMsg.append(idPorta);
        showMsg.append(".");
        showMsg.append(idFunzione);
        showMsg.append(" <");
        showMsg.append(Imbustamento.getDate_eGovFormat((Date)gdo));
        showMsg.append("> ");
        showMsg.append("(");
        showMsg.append(LogLevels.toOpenSPCoop(valueLivello).toString());
        showMsg.append(")");
        if (idEGov != null) {
            showMsg.append(" IDeGov:");
            showMsg.append(idEGov);
        }
        if (idCorrelazioneApplicativa != null) {
            showMsg.append(" IDApplicativo:");
            showMsg.append(idCorrelazioneApplicativa);
        }
        if (delegata) {
            if (porta != null) {
                showMsg.append(" PD:" + porta);
            } else {
                showMsg.append(" PA:" + porta);
            }
        }
        if (servizioApplicativo != null) {
            showMsg.append(" SA:" + servizioApplicativo);
        }
        if (fruitore != null) {
            showMsg.append(" FR:");
            showMsg.append(fruitore.toString());
        }
        if (fruitore != null && servizio != null) {
            showMsg.append(" -> ");
        }
        if (servizio != null) {
            if (servizio.getServizio() != null && servizio.getTipoServizio() != null && servizio.getSoggettoErogatore() != null) {
                showMsg.append(" S:");
                showMsg.append(servizio.toString());
            } else if (servizio.getSoggettoErogatore() != null) {
                showMsg.append(" ER:");
                showMsg.append(servizio.getSoggettoErogatore().toString());
            }
        }
        showMsg.append("\n");
        showMsg.append(text);
        showMsg.append("\n");
        return showMsg.toString();
    }

    public static Logger getLoggerOpenSPCoopConsole() {
        return loggerOpenSPCoopConsole;
    }

    public static Logger getLoggerOpenSPCoopCore() {
        return loggerOpenSPCoopCore;
    }

    public static Logger getLoggerOpenSPCoopResources() {
        return loggerOpenSPCoopResources;
    }

    public static Vector<IMsgDiagnosticoOpenSPCoopAppender> getLoggerMsgDiagnosticoOpenSPCoopAppender() {
        return loggerMsgDiagnosticoOpenSPCoopAppender;
    }

    public static Vector<String> getTipoMsgDiagnosticoOpenSPCoopAppender() {
        return tipoMsgDiagnosticoOpenSPCoopAppender;
    }

    public static Vector<ITracciamentoOpenSPCoopAppender> getLoggerTracciamentoOpenSPCoopAppender() {
        return loggerTracciamentoOpenSPCoopAppender;
    }

    public static Vector<String> getTipoTracciamentoOpenSPCoopAppender() {
        return tipoTracciamentoOpenSPCoopAppender;
    }
}

