/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop.pdd.logger;

import java.util.Calendar;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.openspcoop.dao.commons.IDSoggetto;
import org.openspcoop.dao.registry.driver.IDServizio;
import org.openspcoop.egov.Busta;
import org.openspcoop.egov.XMLBuilder;
import org.openspcoop.pdd.config.ConfigurazionePdDReader;
import org.openspcoop.pdd.config.OpenSPCoopProperties;
import org.openspcoop.pdd.core.CostantiPdD;
import org.openspcoop.pdd.core.PdDContext;
import org.openspcoop.pdd.core.handlers.GeneratoreCasualeDate;
import org.openspcoop.pdd.logger.IMsgDiagnosticoOpenSPCoopAppender;
import org.openspcoop.pdd.logger.LogLevels;
import org.openspcoop.pdd.logger.MsgDiagnosticiProperties;
import org.openspcoop.pdd.logger.OpenSPCoopLogger;
import org.openspcoop.pdd.logger.dto.Egov;
import org.openspcoop.pdd.logger.dto.MsgDiagnosticoCorrelazione;
import org.openspcoop.utils.date.DateManager;

public class MsgDiagnostico {
    public static boolean gestoreDiagnosticaDisponibile = true;
    public static Exception motivoMalfunzionamentoDiagnostici = null;
    private Logger loggerMsgDiagnostico = null;
    private Logger loggerOpenSPCoop = null;
    private Logger loggerIntegrationManager = null;
    private Logger loggerOpenSPCoopFatal = null;
    private Logger loggerOpenSPCoopCore = null;
    private Vector<IMsgDiagnosticoOpenSPCoopAppender> loggerMsgDiagnosticoOpenSPCoopAppender = null;
    private Vector<String> tipoMsgDiagnosticoOpenSPCoopAppender = null;
    private String dominioSPCoop;
    private String idModulo;
    private String idEGovRichiesta;
    private String idEGovRisposta;
    private PdDContext pddContext;
    private XMLBuilder xmlBuilder;
    private ConfigurazionePdDReader configurazionePdDReader;
    private MsgDiagnosticiProperties msgDiagPropertiesReader;
    private OpenSPCoopProperties openspcoopProperties = null;
    private GeneratoreCasualeDate generatoreDateCasuali = null;
    private Hashtable<String, String> keywordLogPersonalizzati = new Hashtable();
    private IDSoggetto fruitore;
    private IDServizio servizio;
    private String porta;
    private boolean delegata;
    private String servizioApplicativo;
    private String idCorrelazioneApplicativa;
    private String prefixMsgPersonalizzati = null;

    public MsgDiagnostico(String dominio, String modulo) {
        this.dominioSPCoop = dominio;
        this.idModulo = modulo;
        this.loggerMsgDiagnostico = OpenSPCoopLogger.loggerMsgDiagnostico;
        this.loggerOpenSPCoop = OpenSPCoopLogger.loggerOpenSPCoop;
        this.loggerIntegrationManager = OpenSPCoopLogger.loggerIntegrationManager;
        this.loggerOpenSPCoopFatal = OpenSPCoopLogger.loggerOpenSPCoopConsole;
        this.loggerMsgDiagnosticoOpenSPCoopAppender = OpenSPCoopLogger.loggerMsgDiagnosticoOpenSPCoopAppender;
        this.tipoMsgDiagnosticoOpenSPCoopAppender = OpenSPCoopLogger.tipoMsgDiagnosticoOpenSPCoopAppender;
        this.loggerOpenSPCoopCore = OpenSPCoopLogger.loggerOpenSPCoopCore;
        this.configurazionePdDReader = ConfigurazionePdDReader.getInstance();
        this.msgDiagPropertiesReader = MsgDiagnosticiProperties.getInstance();
        this.openspcoopProperties = OpenSPCoopProperties.getInstance();
        if (this.openspcoopProperties.generazioneDateCasualiLogAbilitato()) {
            this.generatoreDateCasuali = GeneratoreCasualeDate.getGeneratoreCasualeDate();
        }
        this.xmlBuilder = new XMLBuilder();
    }

    public MsgDiagnostico(String modulo) {
        this(OpenSPCoopProperties.getInstance().getIdentificativoPortaDefault(), modulo);
    }

    public MsgDiagnostico() {
        this.msgDiagPropertiesReader = MsgDiagnosticiProperties.getInstance();
    }

    public void setDominioSPCoop(String dominio) {
        this.dominioSPCoop = dominio;
    }

    public String getDominioSPCoop() {
        return this.dominioSPCoop;
    }

    public void setPddContext(PdDContext pddContext) {
        this.pddContext = pddContext;
    }

    public void setFunzione(String modulo) {
        this.idModulo = modulo;
    }

    public String getFunzione() {
        return this.idModulo;
    }

    public void setIdEGovRichiesta(String idEGov) {
        this.idEGovRichiesta = idEGov;
    }

    public void setIdEGovRisposta(String idEGov) {
        this.idEGovRisposta = idEGov;
    }

    public void aggiornaFiltri() {
    }

    @Deprecated
    public String filter(String msg) {
        String xml = msg.replaceAll("&lt;", "<");
        xml = xml.replaceAll("&quot;", "\"");
        xml = xml.replaceAll("&gt;", ">");
        return xml;
    }

    public void setFruitore(IDSoggetto fruitore) {
        this.fruitore = fruitore;
    }

    public void setServizio(IDServizio servizio) {
        this.servizio = servizio;
    }

    public void setPorta(String porta) {
        this.porta = porta;
    }

    public void setDelegata(boolean delegata) {
        this.delegata = delegata;
    }

    public void setServizioApplicativo(String servizioApplicativo) {
        this.servizioApplicativo = servizioApplicativo;
    }

    public void setIdCorrelazioneApplicativa(String idCorrelazioneApplicativa) {
        this.idCorrelazioneApplicativa = idCorrelazioneApplicativa;
    }

    public void addKeyword(String key, String value) {
        if (key != null) {
            String tmpValue = value;
            if (tmpValue == null) {
                tmpValue = "";
            }
            if (this.keywordLogPersonalizzati.containsKey(key)) {
                this.keywordLogPersonalizzati.remove(key);
            }
            this.keywordLogPersonalizzati.put(key, tmpValue);
        }
    }

    public void addKeywords(Busta busta, boolean richiesta) {
        if (busta != null) {
            if (richiesta) {
                if (busta.getID() != null) {
                    this.keywordLogPersonalizzati.put("@ID_EGOV_RICHIESTA@", busta.getID());
                } else {
                    this.keywordLogPersonalizzati.put("@ID_EGOV_RICHIESTA@", "N.D.");
                }
                if (busta.getProfiloDiCollaborazione() != null) {
                    this.keywordLogPersonalizzati.put("@PROFILO_COLLABORAZIONE@", busta.getProfiloDiCollaborazione());
                }
                if (busta.getTipoMittente() != null) {
                    this.keywordLogPersonalizzati.put("@TIPO_MITTENTE_BUSTA_RICHIESTA@", busta.getTipoMittente());
                }
                if (busta.getMittente() != null) {
                    this.keywordLogPersonalizzati.put("@MITTENTE_BUSTA_RICHIESTA@", busta.getMittente());
                }
                if (busta.getTipoDestinatario() != null) {
                    this.keywordLogPersonalizzati.put("@TIPO_DESTINATARIO_BUSTA_RICHIESTA@", busta.getTipoDestinatario());
                }
                if (busta.getDestinatario() != null) {
                    this.keywordLogPersonalizzati.put("@DESTINATARIO_BUSTA_RICHIESTA@", busta.getDestinatario());
                }
                if (busta.getTipoServizio() != null) {
                    this.keywordLogPersonalizzati.put("@TIPO_SERVIZIO_BUSTA_RICHIESTA@", busta.getTipoServizio());
                }
                if (busta.getServizio() != null) {
                    this.keywordLogPersonalizzati.put("@SERVIZIO_BUSTA_RICHIESTA@", busta.getServizio());
                }
                if (busta.getAzione() != null) {
                    this.keywordLogPersonalizzati.put("@AZIONE_BUSTA_RICHIESTA@", busta.getAzione());
                } else {
                    this.keywordLogPersonalizzati.put("@AZIONE_BUSTA_RICHIESTA@", "");
                }
                if (busta.getRiferimentoMessaggio() != null) {
                    this.keywordLogPersonalizzati.put("@RIFERIMENTO_MESSAGGIO_RICHIESTA@", busta.getRiferimentoMessaggio());
                }
                if (busta.getSequenza() > 0L) {
                    this.keywordLogPersonalizzati.put("@SEQUENZA@", busta.getSequenza() + "");
                }
                if (busta.getIndirizzoTelematicoMittente() != null) {
                    this.keywordLogPersonalizzati.put("@INDIRIZZO_TELEMATICO_MITTENTE_RICHIESTA@", busta.getIndirizzoTelematicoMittente());
                }
                if (busta.getIndirizzoTelematicoDestinatario() != null) {
                    this.keywordLogPersonalizzati.put("@INDIRIZZO_TELEMATICO_DESTINATARIO_RICHIESTA@", busta.getIndirizzoTelematicoDestinatario());
                }
                if (busta.getScadenza() != null) {
                    this.keywordLogPersonalizzati.put("@SCADENZA_BUSTA_RICHIESTA@", busta.getScadenza().toString());
                }
            } else {
                if (busta.getID() != null) {
                    this.keywordLogPersonalizzati.put("@ID_EGOV_RISPOSTA@", busta.getID());
                } else {
                    this.keywordLogPersonalizzati.put("@ID_EGOV_RISPOSTA@", "N.D.");
                }
                if (busta.getProfiloDiCollaborazione() != null) {
                    this.keywordLogPersonalizzati.put("@PROFILO_COLLABORAZIONE@", busta.getProfiloDiCollaborazione());
                }
                if (busta.getTipoMittente() != null) {
                    this.keywordLogPersonalizzati.put("@TIPO_MITTENTE_BUSTA_RISPOSTA@", busta.getTipoMittente());
                }
                if (busta.getMittente() != null) {
                    this.keywordLogPersonalizzati.put("@MITTENTE_BUSTA_RISPOSTA@", busta.getMittente());
                }
                if (busta.getTipoDestinatario() != null) {
                    this.keywordLogPersonalizzati.put("@TIPO_DESTINATARIO_BUSTA_RISPOSTA@", busta.getTipoDestinatario());
                }
                if (busta.getDestinatario() != null) {
                    this.keywordLogPersonalizzati.put("@DESTINATARIO_BUSTA_RISPOSTA@", busta.getDestinatario());
                }
                if (busta.getTipoServizio() != null) {
                    this.keywordLogPersonalizzati.put("@TIPO_SERVIZIO_BUSTA_RISPOSTA@", busta.getTipoServizio());
                }
                if (busta.getServizio() != null) {
                    this.keywordLogPersonalizzati.put("@SERVIZIO_BUSTA_RISPOSTA@", busta.getServizio());
                }
                if (busta.getAzione() != null) {
                    this.keywordLogPersonalizzati.put("@AZIONE_BUSTA_RISPOSTA@", busta.getAzione());
                } else {
                    this.keywordLogPersonalizzati.put("@AZIONE_BUSTA_RISPOSTA@", "");
                }
                if (busta.getRiferimentoMessaggio() != null) {
                    this.keywordLogPersonalizzati.put("@RIFERIMENTO_MESSAGGIO_RISPOSTA@", busta.getRiferimentoMessaggio());
                }
                if (busta.getSequenza() > 0L) {
                    this.keywordLogPersonalizzati.put("@SEQUENZA@", busta.getSequenza() + "");
                }
                if (busta.getIndirizzoTelematicoMittente() != null) {
                    this.keywordLogPersonalizzati.put("@INDIRIZZO_TELEMATICO_MITTENTE_RISPOSTA@", busta.getIndirizzoTelematicoMittente());
                }
                if (busta.getIndirizzoTelematicoDestinatario() != null) {
                    this.keywordLogPersonalizzati.put("@INDIRIZZO_TELEMATICO_DESTINATARIO_RISPOSTA@", busta.getIndirizzoTelematicoDestinatario());
                }
                if (busta.getScadenza() != null) {
                    this.keywordLogPersonalizzati.put("@SCADENZA_BUSTA_RISPOSTA@", busta.getScadenza().toString());
                }
            }
        }
    }

    public void addKeywords(IDSoggetto soggettoFruitore) {
        this.addKeywords(soggettoFruitore, null, null);
    }

    public void addKeywords(IDServizio idServizio) {
        this.addKeywords(null, idServizio, null);
    }

    public void addKeywords(IDSoggetto soggettoFruitore, IDServizio idServizio, String idEgov) {
        if (idEgov != null) {
            this.keywordLogPersonalizzati.put("@ID_EGOV_RICHIESTA@", idEgov);
        }
        if (soggettoFruitore != null) {
            this.keywordLogPersonalizzati.put("@TIPO_MITTENTE_BUSTA_RICHIESTA@", soggettoFruitore.getTipo());
            this.keywordLogPersonalizzati.put("@MITTENTE_BUSTA_RICHIESTA@", soggettoFruitore.getNome());
        }
        if (idServizio != null) {
            if (idServizio.getSoggettoErogatore() != null) {
                this.keywordLogPersonalizzati.put("@TIPO_DESTINATARIO_BUSTA_RICHIESTA@", idServizio.getSoggettoErogatore().getTipo());
                this.keywordLogPersonalizzati.put("@DESTINATARIO_BUSTA_RICHIESTA@", idServizio.getSoggettoErogatore().getNome());
            }
            this.keywordLogPersonalizzati.put("@TIPO_SERVIZIO_BUSTA_RICHIESTA@", idServizio.getTipoServizio());
            this.keywordLogPersonalizzati.put("@SERVIZIO_BUSTA_RICHIESTA@", idServizio.getServizio());
            if (idServizio.getAzione() != null) {
                this.keywordLogPersonalizzati.put("@AZIONE_BUSTA_RICHIESTA@", idServizio.getAzione());
            }
        }
    }

    public String replaceKeywords(String msg) {
        if (msg != null && msg.length() > 2) {
            int index1 = msg.indexOf("@");
            int index2 = msg.indexOf("@", index1 + 1);
            if (index1 < 0 || index2 < 0) {
                return msg;
            }
        }
        StringBuffer bf = new StringBuffer();
        StringBuffer keyword = new StringBuffer();
        boolean separator = false;
        char separatorChar = '@';
        for (int i = 0; i < msg.length(); ++i) {
            char ch = msg.charAt(i);
            if (separatorChar == ch) {
                if (!separator) {
                    keyword.append(separatorChar);
                    separator = true;
                    continue;
                }
                keyword.append(separatorChar);
                String valoreRimpiazzato = this.keywordLogPersonalizzati.get(keyword.toString());
                if (valoreRimpiazzato == null) {
                    bf.append(keyword.toString());
                } else {
                    bf.append(valoreRimpiazzato);
                }
                keyword.delete(0, keyword.length());
                separator = false;
                continue;
            }
            if (separator) {
                keyword.append(ch);
                continue;
            }
            bf.append(ch);
        }
        return bf.toString();
    }

    public void setPrefixMsgPersonalizzati(String v) {
        this.prefixMsgPersonalizzati = v;
    }

    public int getLivello(String keyLivelloPersonalizzato) {
        return this.getLivello(this.prefixMsgPersonalizzati, keyLivelloPersonalizzato);
    }

    public int getLivello(String prefix, String keyLivelloPersonalizzato) {
        Integer livello = this.msgDiagPropertiesReader.getLivello(prefix, keyLivelloPersonalizzato);
        if (livello != null) {
            return livello;
        }
        return -1;
    }

    public String getCodice(String keyCodicePersonalizzato) {
        return this.getCodice(this.prefixMsgPersonalizzati, keyCodicePersonalizzato);
    }

    public String getCodice(String prefix, String keyCodicePersonalizzato) {
        return this.msgDiagPropertiesReader.getCodice(prefix, keyCodicePersonalizzato);
    }

    public String getMessaggio(String keyMsgPersonalizzato) {
        return this.getMessaggio(this.prefixMsgPersonalizzati, keyMsgPersonalizzato, false);
    }

    public String getMessaggio(String prefix, String keyMsgPersonalizzato) {
        return this.getMessaggio(prefix, keyMsgPersonalizzato, false);
    }

    public String getMessaggio_replaceKeywords(String keyMsgPersonalizzato) {
        return this.getMessaggio(this.prefixMsgPersonalizzati, keyMsgPersonalizzato, true);
    }

    public String getMessaggio_replaceKeywords(String prefix, String keyMsgPersonalizzato) {
        return this.getMessaggio(prefix, keyMsgPersonalizzato, true);
    }

    private String getMessaggio(String prefix, String keyMsgPersonalizzato, boolean replaceKeywords) {
        String msgTmp = this.msgDiagPropertiesReader.getMessaggio(prefix, keyMsgPersonalizzato);
        if (msgTmp == null) {
            msgTmp = "Messaggio diagnostico [" + prefix + "." + keyMsgPersonalizzato + "] non definito nella configurazione della porta di dominio??";
        }
        if (replaceKeywords) {
            String msgReplaceKey = this.replaceKeywords(msgTmp);
            return msgReplaceKey;
        }
        return msgTmp;
    }

    public void logCorrelazione() {
        if (Integer.MIN_VALUE != this.configurazionePdDReader.getSeveritaSPCoop_msgDiagnostici()) {
            try {
                Date gdo = DateManager.getDate();
                if (this.openspcoopProperties.generazioneDateCasualiLogAbilitato() && this.pddContext != null && this.pddContext.getObject("ID") != null) {
                    gdo = this.generatoreDateCasuali.getProssimaData((String)this.pddContext.getObject("ID"));
                }
                for (int i = 0; i < this.loggerMsgDiagnosticoOpenSPCoopAppender.size(); ++i) {
                    try {
                        String[] key;
                        MsgDiagnosticoCorrelazione msgDiagCorrelazione = new MsgDiagnosticoCorrelazione();
                        msgDiagCorrelazione.setIdEgov(this.idEGovRichiesta);
                        Calendar c = Calendar.getInstance();
                        c.setTime(gdo);
                        msgDiagCorrelazione.setGdo(c);
                        msgDiagCorrelazione.setNomePorta(this.porta);
                        msgDiagCorrelazione.setDelegata(this.delegata);
                        if (this.fruitore != null || this.servizio != null) {
                            Egov informazioniEgov = new Egov();
                            informazioniEgov.setFruitore(this.fruitore);
                            informazioniEgov.setServizio(this.servizio);
                            if (this.servizio != null) {
                                informazioniEgov.setAzione(this.servizio.getAzione());
                                informazioniEgov.setErogatore(this.servizio.getSoggettoErogatore());
                            }
                            msgDiagCorrelazione.setInformazioniEgov(informazioniEgov);
                        }
                        msgDiagCorrelazione.setCorrelazioneApplicativa(this.idCorrelazioneApplicativa);
                        if (this.pddContext != null && (key = CostantiPdD.CONTEXT_OBJECT) != null) {
                            for (int j = 0; j < key.length; ++j) {
                                Object o = this.pddContext.getObject(key[j]);
                                if (!(o instanceof String)) continue;
                                msgDiagCorrelazione.addProperty(key[j], (String)o);
                            }
                        }
                        this.loggerMsgDiagnosticoOpenSPCoopAppender.get(i).logCorrelazione(msgDiagCorrelazione);
                        continue;
                    }
                    catch (Exception e) {
                        OpenSPCoopLogger.loggerOpenSPCoopResources.error((Object)("Errore durante l'emissione del msg diagnostico di correlazione [" + this.tipoMsgDiagnosticoOpenSPCoopAppender.get(i) + "]: " + e.getMessage()), (Throwable)e);
                        this.gestioneErroreDiagnostica(e);
                    }
                }
            }
            catch (Exception e) {
                OpenSPCoopLogger.loggerOpenSPCoopResources.error((Object)("MsgDiagnostico.logCorrelazione error " + e.getMessage()), (Throwable)e);
                this.gestioneErroreDiagnostica(e);
            }
        }
    }

    public void logCorrelazioneServizioApplicativo() {
        if (Integer.MIN_VALUE != this.configurazionePdDReader.getSeveritaSPCoop_msgDiagnostici()) {
            try {
                for (int i = 0; i < this.loggerMsgDiagnosticoOpenSPCoopAppender.size(); ++i) {
                    try {
                        this.loggerMsgDiagnosticoOpenSPCoopAppender.get(i).logCorrelazioneServizioApplicativo(this.idEGovRichiesta, this.delegata, this.servizioApplicativo);
                        continue;
                    }
                    catch (Exception e) {
                        OpenSPCoopLogger.loggerOpenSPCoopResources.error((Object)("Errore durante l'emissione del msg diagnostico di correlazione [" + this.tipoMsgDiagnosticoOpenSPCoopAppender.get(i) + "]: " + e.getMessage()), (Throwable)e);
                        this.gestioneErroreDiagnostica(e);
                    }
                }
            }
            catch (Exception e) {
                OpenSPCoopLogger.loggerOpenSPCoopResources.error((Object)("MsgDiagnostico.logCorrelazione error " + e.getMessage()), (Throwable)e);
                this.gestioneErroreDiagnostica(e);
            }
        }
    }

    public void logPersonalizzato(String idModuloFunzionale, String idDiagnostico) {
        this.logPersonalizzato(this.getMessaggio(idModuloFunzionale, idDiagnostico), this.getLivello(idModuloFunzionale, idDiagnostico), this.getCodice(idModuloFunzionale, idDiagnostico));
    }

    public void logPersonalizzato(String idDiagnostico) {
        this.logPersonalizzato(this.getMessaggio(idDiagnostico), this.getLivello(idDiagnostico), this.getCodice(idDiagnostico));
    }

    public void logPersonalizzato(String messaggio, int livelloLog, String codiceDiagnostico) {
        if (messaggio == null) {
            OpenSPCoopLogger.loggerOpenSPCoopResources.error((Object)"MsgDiagnostico.logPersonalizzato error, messaggio non definito.");
            return;
        }
        int severitaLogEmessoPerFiltro = livelloLog;
        int severitaLivelloCNIPA = LogLevels.toIntervalloCNIPA(livelloLog);
        if (severitaLivelloCNIPA < 0 || severitaLivelloCNIPA > 7) {
            OpenSPCoopLogger.loggerOpenSPCoopResources.error((Object)("MsgDiagnostico.logPersonalizzato error, conversione a livello CNIPA non riuscita [" + severitaLivelloCNIPA + "]"));
            return;
        }
        Level logLevelseveritaLivelloCNIPA = LogLevels.toOpenSPCoop(severitaLivelloCNIPA);
        int severitaSPCoopRichiestaPdD = this.msgDiagPropertiesReader.getFiltroMsgDiagnostico_CNIPA7();
        int severitaOpenSPCoopRichiestaPdD = this.msgDiagPropertiesReader.getFiltroMsgDiagnostico_CNIPA7();
        if (this.configurazionePdDReader != null) {
            severitaSPCoopRichiestaPdD = this.msgDiagPropertiesReader.getValoreFiltroFromValoreCNIPA(this.configurazionePdDReader.getSeveritaSPCoop_msgDiagnostici());
            severitaOpenSPCoopRichiestaPdD = this.msgDiagPropertiesReader.getValoreFiltroFromValoreCNIPA(this.configurazionePdDReader.getSeveritaOpenSPCoop_msgDiagnostici());
        }
        try {
            org.openspcoop.pdd.logger.dto.MsgDiagnostico msgDiag;
            Date gdo = DateManager.getDate();
            if (this.openspcoopProperties.generazioneDateCasualiLogAbilitato() && this.pddContext != null && this.pddContext.getObject("ID") != null) {
                gdo = this.generatoreDateCasuali.getProssimaData((String)this.pddContext.getObject("ID"));
            }
            String msgReplaceKey = null;
            if (severitaLogEmessoPerFiltro <= severitaSPCoopRichiestaPdD) {
                msgReplaceKey = this.replaceKeywords(messaggio);
                if (OpenSPCoopLogger.loggerMsgDiagnosticoAbilitato) {
                    String xml = this.xmlBuilder.buildString_Diagnostico(this.dominioSPCoop, this.idModulo, severitaLivelloCNIPA, msgReplaceKey);
                    try {
                        this.loggerMsgDiagnostico.log((Priority)logLevelseveritaLivelloCNIPA, (Object)xml);
                    }
                    catch (Exception e) {
                        OpenSPCoopLogger.loggerOpenSPCoopResources.error((Object)("Errore durante l'emissione del msg diagnostico 'spcoop': " + e.getMessage()), (Throwable)e);
                        this.gestioneErroreDiagnostica(e);
                    }
                }
                for (int i = 0; i < this.loggerMsgDiagnosticoOpenSPCoopAppender.size(); ++i) {
                    try {
                        msgDiag = this.getMsgDiagnostico(gdo, severitaLivelloCNIPA, msgReplaceKey, codiceDiagnostico);
                        this.loggerMsgDiagnosticoOpenSPCoopAppender.get(i).log(msgDiag);
                        continue;
                    }
                    catch (Exception e) {
                        OpenSPCoopLogger.loggerOpenSPCoopResources.error((Object)("Errore durante l'emissione del msg diagnostico personalizzato [" + this.tipoMsgDiagnosticoOpenSPCoopAppender.get(i) + "]: " + e.getMessage()), (Throwable)e);
                        this.gestioneErroreDiagnostica(e);
                    }
                }
            }
            boolean humanReadableAbilitato = false;
            humanReadableAbilitato = "IntegrationManager".equals(this.idModulo) ? OpenSPCoopLogger.loggerIntegrationManagerAbilitato : OpenSPCoopLogger.loggerMsgDiagnosticoReadableAbilitato;
            if (humanReadableAbilitato && severitaLogEmessoPerFiltro <= severitaOpenSPCoopRichiestaPdD) {
                if (msgReplaceKey == null) {
                    msgReplaceKey = this.replaceKeywords(messaggio);
                }
                msgDiag = this.getMsgDiagnostico(gdo, severitaLivelloCNIPA, msgReplaceKey, codiceDiagnostico);
                String message = OpenSPCoopLogger.humanReadable(msgDiag, this.idCorrelazioneApplicativa, this.porta, this.delegata, this.fruitore, this.servizio, this.servizioApplicativo);
                try {
                    if ("IntegrationManager".equals(this.idModulo)) {
                        this.loggerIntegrationManager.log((Priority)logLevelseveritaLivelloCNIPA, (Object)message);
                    } else {
                        this.loggerOpenSPCoop.log((Priority)logLevelseveritaLivelloCNIPA, (Object)message);
                    }
                }
                catch (Exception e) {
                    OpenSPCoopLogger.loggerOpenSPCoopResources.error((Object)("Errore durante l'emissione del msg diagnostico 'human readable': " + e.getMessage()), (Throwable)e);
                    this.gestioneErroreDiagnostica(e);
                }
            }
            if (msgReplaceKey != null && severitaLivelloCNIPA == 0) {
                this.loggerOpenSPCoopFatal.log((Priority)LogLevels.LOG_LEVEL_FATAL_OPENSPCOOP, (Object)msgReplaceKey);
            }
        }
        catch (Exception e) {
            OpenSPCoopLogger.loggerOpenSPCoopResources.error((Object)("MsgDiagnostico.logPersonalizzato error " + e.getMessage()), (Throwable)e);
            this.gestioneErroreDiagnostica(e);
        }
    }

    public void logErroreGenerico(Throwable e, String posizioneErrore) {
        String msg = null;
        msg = e instanceof NullPointerException ? "NullPointerException" : e.getMessage();
        this.logErroreGenerico(msg, posizioneErrore);
        if (this.loggerOpenSPCoopCore != null) {
            this.loggerOpenSPCoopCore.error((Object)(posizioneErrore + ": " + msg), e);
        }
    }

    public void logErroreGenerico(String message, String posizioneErrore) {
        this.addKeyword("@ERRORE_PROCESSAMENTO@", message);
        this.addKeyword("@POSIZIONE_ERRORE@", posizioneErrore);
        this.logPersonalizzato("all.", "erroreGenerico");
    }

    public void logFatalError(Exception e, String posizioneErrore) {
        String msg = null;
        msg = e instanceof NullPointerException ? "NullPointerException" : e.getMessage();
        this.logFatalError(msg, posizioneErrore);
        if (this.loggerOpenSPCoopCore != null) {
            this.loggerOpenSPCoopCore.fatal((Object)(posizioneErrore + ": " + msg), (Throwable)e);
        }
    }

    public void logFatalError(String message, String posizioneErrore) {
        this.addKeyword("@ERRORE_PROCESSAMENTO@", message);
        this.addKeyword("@POSIZIONE_ERRORE@", posizioneErrore);
        this.logPersonalizzato("all.", "erroreGenericoMalfunzionamentoPdD");
    }

    public void logStartupError(Exception e, String posizioneErrore) {
        String msg = null;
        msg = e instanceof NullPointerException ? "NullPointerException" : e.getMessage();
        this.logStartupError(msg, posizioneErrore);
        if (this.loggerOpenSPCoopCore != null) {
            this.loggerOpenSPCoopCore.fatal((Object)(posizioneErrore + ": " + msg), (Throwable)e);
        }
    }

    public void logStartupError(String message, String posizioneErrore) {
        this.addKeyword("@ERRORE_PROCESSAMENTO@", message);
        this.addKeyword("@POSIZIONE_ERRORE@", posizioneErrore);
        this.logPersonalizzato("openspcoopStartup.", "erroreGenerico");
    }

    public void logDisconnectError(Exception e, String url) {
        String msg = null;
        msg = e instanceof NullPointerException ? "NullPointerException" : e.getMessage();
        this.logDisconnectError(msg, url);
        if (this.loggerOpenSPCoopCore != null) {
            this.loggerOpenSPCoopCore.error((Object)(url + ": " + msg), (Throwable)e);
        }
    }

    public void logDisconnectError(String message, String url) {
        this.addKeyword("@ERRORE_PROCESSAMENTO@", message);
        this.addKeyword("@POSIZIONE_ERRORE@", url);
        this.logPersonalizzato("all.", "connessioneUscita.disconnectError");
    }

    @Deprecated
    public void fatalOpenSPCoop(String msg) {
        String codiceDiagnostico = null;
        int severitaLogEmessoPerFiltro = LogLevels.toIntervalloOpenSPCoop(0);
        int severitaSPCoopRichiestaPdD = this.msgDiagPropertiesReader.getFiltroMsgDiagnostico_CNIPA7();
        int severitaOpenSPCoopRichiestaPdD = this.msgDiagPropertiesReader.getFiltroMsgDiagnostico_CNIPA7();
        if (this.configurazionePdDReader != null) {
            severitaSPCoopRichiestaPdD = this.msgDiagPropertiesReader.getValoreFiltroFromValoreCNIPA(this.configurazionePdDReader.getSeveritaSPCoop_msgDiagnostici());
            severitaOpenSPCoopRichiestaPdD = this.msgDiagPropertiesReader.getValoreFiltroFromValoreCNIPA(this.configurazionePdDReader.getSeveritaOpenSPCoop_msgDiagnostici());
        }
        try {
            org.openspcoop.pdd.logger.dto.MsgDiagnostico msgDiag;
            Date gdo = DateManager.getDate();
            if (this.openspcoopProperties.generazioneDateCasualiLogAbilitato() && this.pddContext != null && this.pddContext.getObject("ID") != null) {
                gdo = this.generatoreDateCasuali.getProssimaData((String)this.pddContext.getObject("ID"));
            }
            if (severitaLogEmessoPerFiltro <= severitaSPCoopRichiestaPdD) {
                if (OpenSPCoopLogger.loggerMsgDiagnosticoAbilitato) {
                    String xml = this.xmlBuilder.buildString_Diagnostico(this.dominioSPCoop, this.idModulo, 0, msg);
                    try {
                        this.loggerMsgDiagnostico.log((Priority)LogLevels.LOG_LEVEL_FATAL_OPENSPCOOP, (Object)xml);
                    }
                    catch (Exception e) {
                        OpenSPCoopLogger.loggerOpenSPCoopResources.error((Object)("Errore durante l'emissione del msg diagnostico 'spcoop': " + e.getMessage()), (Throwable)e);
                        this.gestioneErroreDiagnostica(e);
                    }
                }
                for (int i = 0; i < this.loggerMsgDiagnosticoOpenSPCoopAppender.size(); ++i) {
                    try {
                        msgDiag = this.getMsgDiagnostico(gdo, 0, msg, codiceDiagnostico);
                        this.loggerMsgDiagnosticoOpenSPCoopAppender.get(i).log(msgDiag);
                        continue;
                    }
                    catch (Exception e) {
                        OpenSPCoopLogger.loggerOpenSPCoopResources.error((Object)("Errore durante l'emissione del msg diagnostico personalizzato [" + this.tipoMsgDiagnosticoOpenSPCoopAppender.get(i) + "]: " + e.getMessage()), (Throwable)e);
                        this.gestioneErroreDiagnostica(e);
                    }
                }
            }
            boolean humanReadableAbilitato = false;
            humanReadableAbilitato = "IntegrationManager".equals(this.idModulo) ? OpenSPCoopLogger.loggerIntegrationManagerAbilitato : OpenSPCoopLogger.loggerMsgDiagnosticoReadableAbilitato;
            if (humanReadableAbilitato && severitaLogEmessoPerFiltro <= severitaOpenSPCoopRichiestaPdD) {
                msgDiag = this.getMsgDiagnostico(gdo, 0, msg, codiceDiagnostico);
                String message = OpenSPCoopLogger.humanReadable(msgDiag, this.idCorrelazioneApplicativa, this.porta, this.delegata, this.fruitore, this.servizio, this.servizioApplicativo);
                try {
                    if ("IntegrationManager".equals(this.idModulo)) {
                        this.loggerIntegrationManager.log((Priority)LogLevels.LOG_LEVEL_FATAL_OPENSPCOOP, (Object)message);
                    } else {
                        this.loggerOpenSPCoop.log((Priority)LogLevels.LOG_LEVEL_FATAL_OPENSPCOOP, (Object)message);
                    }
                }
                catch (Exception e) {
                    OpenSPCoopLogger.loggerOpenSPCoopResources.error((Object)("Errore durante l'emissione del msg diagnostico 'human readable': " + e.getMessage()), (Throwable)e);
                    this.gestioneErroreDiagnostica(e);
                }
            }
            this.loggerOpenSPCoopFatal.log((Priority)LogLevels.LOG_LEVEL_FATAL_OPENSPCOOP, (Object)msg);
        }
        catch (Exception e) {
            OpenSPCoopLogger.loggerOpenSPCoopResources.error((Object)("MsgDiagnostico.fatalOpenSPCoop error " + e.getMessage()), (Throwable)e);
            this.gestioneErroreDiagnostica(e);
        }
    }

    @Deprecated
    public void errorSPCoop(String msg) {
        block14: {
            String codiceDiagnostico = null;
            int severitaLogEmessoPerFiltro = LogLevels.toIntervalloOpenSPCoop(1);
            int severitaSPCoopRichiestaPdD = this.msgDiagPropertiesReader.getFiltroMsgDiagnostico_CNIPA7();
            int severitaOpenSPCoopRichiestaPdD = this.msgDiagPropertiesReader.getFiltroMsgDiagnostico_CNIPA7();
            if (this.configurazionePdDReader != null) {
                severitaSPCoopRichiestaPdD = this.msgDiagPropertiesReader.getValoreFiltroFromValoreCNIPA(this.configurazionePdDReader.getSeveritaSPCoop_msgDiagnostici());
                severitaOpenSPCoopRichiestaPdD = this.msgDiagPropertiesReader.getValoreFiltroFromValoreCNIPA(this.configurazionePdDReader.getSeveritaOpenSPCoop_msgDiagnostici());
            }
            try {
                org.openspcoop.pdd.logger.dto.MsgDiagnostico msgDiag;
                Date gdo = DateManager.getDate();
                if (this.openspcoopProperties.generazioneDateCasualiLogAbilitato() && this.pddContext != null && this.pddContext.getObject("ID") != null) {
                    gdo = this.generatoreDateCasuali.getProssimaData((String)this.pddContext.getObject("ID"));
                }
                if (severitaLogEmessoPerFiltro <= severitaSPCoopRichiestaPdD) {
                    if (OpenSPCoopLogger.loggerMsgDiagnosticoAbilitato) {
                        String xml = this.xmlBuilder.buildString_Diagnostico(this.dominioSPCoop, this.idModulo, 1, msg);
                        try {
                            this.loggerMsgDiagnostico.log((Priority)LogLevels.LOG_LEVEL_ERROR_SPCOOP, (Object)xml);
                        }
                        catch (Exception e) {
                            OpenSPCoopLogger.loggerOpenSPCoopResources.error((Object)("Errore durante l'emissione del msg diagnostico 'spcoop': " + e.getMessage()), (Throwable)e);
                            this.gestioneErroreDiagnostica(e);
                        }
                    }
                    for (int i = 0; i < this.loggerMsgDiagnosticoOpenSPCoopAppender.size(); ++i) {
                        try {
                            msgDiag = this.getMsgDiagnostico(gdo, 1, msg, codiceDiagnostico);
                            this.loggerMsgDiagnosticoOpenSPCoopAppender.get(i).log(msgDiag);
                            continue;
                        }
                        catch (Exception e) {
                            OpenSPCoopLogger.loggerOpenSPCoopResources.error((Object)("Errore durante l'emissione del msg diagnostico personalizzato [" + this.tipoMsgDiagnosticoOpenSPCoopAppender.get(i) + "]: " + e.getMessage()), (Throwable)e);
                            this.gestioneErroreDiagnostica(e);
                        }
                    }
                }
                boolean humanReadableAbilitato = false;
                humanReadableAbilitato = "IntegrationManager".equals(this.idModulo) ? OpenSPCoopLogger.loggerIntegrationManagerAbilitato : OpenSPCoopLogger.loggerMsgDiagnosticoReadableAbilitato;
                if (!humanReadableAbilitato || severitaLogEmessoPerFiltro > severitaOpenSPCoopRichiestaPdD) break block14;
                msgDiag = this.getMsgDiagnostico(gdo, 1, msg, codiceDiagnostico);
                String message = OpenSPCoopLogger.humanReadable(msgDiag, this.idCorrelazioneApplicativa, this.porta, this.delegata, this.fruitore, this.servizio, this.servizioApplicativo);
                try {
                    if ("IntegrationManager".equals(this.idModulo)) {
                        this.loggerIntegrationManager.log((Priority)LogLevels.LOG_LEVEL_ERROR_SPCOOP, (Object)message);
                        break block14;
                    }
                    this.loggerOpenSPCoop.log((Priority)LogLevels.LOG_LEVEL_ERROR_SPCOOP, (Object)message);
                }
                catch (Exception e) {
                    OpenSPCoopLogger.loggerOpenSPCoopResources.error((Object)("Errore durante l'emissione del msg diagnostico 'human readable': " + e.getMessage()), (Throwable)e);
                    this.gestioneErroreDiagnostica(e);
                }
            }
            catch (Exception e) {
                OpenSPCoopLogger.loggerOpenSPCoopResources.error((Object)("MsgDiagnostico.errorSPCoop error " + e.getMessage()), (Throwable)e);
                this.gestioneErroreDiagnostica(e);
            }
        }
    }

    @Deprecated
    public void errorOpenSPCoop(String msg) {
        block14: {
            String codiceDiagnostico = null;
            int severitaLogEmessoPerFiltro = LogLevels.toIntervalloOpenSPCoop(2);
            int severitaSPCoopRichiestaPdD = this.msgDiagPropertiesReader.getFiltroMsgDiagnostico_CNIPA7();
            int severitaOpenSPCoopRichiestaPdD = this.msgDiagPropertiesReader.getFiltroMsgDiagnostico_CNIPA7();
            if (this.configurazionePdDReader != null) {
                severitaSPCoopRichiestaPdD = this.msgDiagPropertiesReader.getValoreFiltroFromValoreCNIPA(this.configurazionePdDReader.getSeveritaSPCoop_msgDiagnostici());
                severitaOpenSPCoopRichiestaPdD = this.msgDiagPropertiesReader.getValoreFiltroFromValoreCNIPA(this.configurazionePdDReader.getSeveritaOpenSPCoop_msgDiagnostici());
            }
            try {
                org.openspcoop.pdd.logger.dto.MsgDiagnostico msgDiag;
                Date gdo = DateManager.getDate();
                if (this.openspcoopProperties.generazioneDateCasualiLogAbilitato() && this.pddContext != null && this.pddContext.getObject("ID") != null) {
                    gdo = this.generatoreDateCasuali.getProssimaData((String)this.pddContext.getObject("ID"));
                }
                if (severitaLogEmessoPerFiltro <= severitaSPCoopRichiestaPdD) {
                    if (OpenSPCoopLogger.loggerMsgDiagnosticoAbilitato) {
                        String xml = this.xmlBuilder.buildString_Diagnostico(this.dominioSPCoop, this.idModulo, 2, msg);
                        try {
                            this.loggerMsgDiagnostico.log((Priority)LogLevels.LOG_LEVEL_ERROR_OPENSPCOOP, (Object)xml);
                        }
                        catch (Exception e) {
                            OpenSPCoopLogger.loggerOpenSPCoopResources.error((Object)("Errore durante l'emissione del msg diagnostico 'spcoop': " + e.getMessage()), (Throwable)e);
                            this.gestioneErroreDiagnostica(e);
                        }
                    }
                    for (int i = 0; i < this.loggerMsgDiagnosticoOpenSPCoopAppender.size(); ++i) {
                        try {
                            msgDiag = this.getMsgDiagnostico(gdo, 2, msg, codiceDiagnostico);
                            this.loggerMsgDiagnosticoOpenSPCoopAppender.get(i).log(msgDiag);
                            continue;
                        }
                        catch (Exception e) {
                            OpenSPCoopLogger.loggerOpenSPCoopResources.error((Object)("Errore durante l'emissione del msg diagnostico personalizzato [" + this.tipoMsgDiagnosticoOpenSPCoopAppender.get(i) + "]: " + e.getMessage()), (Throwable)e);
                            this.gestioneErroreDiagnostica(e);
                        }
                    }
                }
                boolean humanReadableAbilitato = false;
                humanReadableAbilitato = "IntegrationManager".equals(this.idModulo) ? OpenSPCoopLogger.loggerIntegrationManagerAbilitato : OpenSPCoopLogger.loggerMsgDiagnosticoReadableAbilitato;
                if (!humanReadableAbilitato || severitaLogEmessoPerFiltro > severitaOpenSPCoopRichiestaPdD) break block14;
                msgDiag = this.getMsgDiagnostico(gdo, 2, msg, codiceDiagnostico);
                String message = OpenSPCoopLogger.humanReadable(msgDiag, this.idCorrelazioneApplicativa, this.porta, this.delegata, this.fruitore, this.servizio, this.servizioApplicativo);
                try {
                    if ("IntegrationManager".equals(this.idModulo)) {
                        this.loggerIntegrationManager.log((Priority)LogLevels.LOG_LEVEL_ERROR_OPENSPCOOP, (Object)message);
                        break block14;
                    }
                    this.loggerOpenSPCoop.log((Priority)LogLevels.LOG_LEVEL_ERROR_OPENSPCOOP, (Object)message);
                }
                catch (Exception e) {
                    OpenSPCoopLogger.loggerOpenSPCoopResources.error((Object)("Errore durante l'emissione del msg diagnostico 'human readable': " + e.getMessage()), (Throwable)e);
                    this.gestioneErroreDiagnostica(e);
                }
            }
            catch (Exception e) {
                OpenSPCoopLogger.loggerOpenSPCoopResources.error((Object)("MsgDiagnostico.errorOpenSPCoop error " + e.getMessage()), (Throwable)e);
                this.gestioneErroreDiagnostica(e);
            }
        }
    }

    @Deprecated
    public void infoSPCoop(String msg) {
        block14: {
            String codiceDiagnostico = null;
            int severitaLogEmessoPerFiltro = LogLevels.toIntervalloOpenSPCoop(3);
            int severitaSPCoopRichiestaPdD = this.msgDiagPropertiesReader.getFiltroMsgDiagnostico_CNIPA7();
            int severitaOpenSPCoopRichiestaPdD = this.msgDiagPropertiesReader.getFiltroMsgDiagnostico_CNIPA7();
            if (this.configurazionePdDReader != null) {
                severitaSPCoopRichiestaPdD = this.msgDiagPropertiesReader.getValoreFiltroFromValoreCNIPA(this.configurazionePdDReader.getSeveritaSPCoop_msgDiagnostici());
                severitaOpenSPCoopRichiestaPdD = this.msgDiagPropertiesReader.getValoreFiltroFromValoreCNIPA(this.configurazionePdDReader.getSeveritaOpenSPCoop_msgDiagnostici());
            }
            try {
                org.openspcoop.pdd.logger.dto.MsgDiagnostico msgDiag;
                Date gdo = DateManager.getDate();
                if (this.openspcoopProperties.generazioneDateCasualiLogAbilitato() && this.pddContext != null && this.pddContext.getObject("ID") != null) {
                    gdo = this.generatoreDateCasuali.getProssimaData((String)this.pddContext.getObject("ID"));
                }
                if (severitaLogEmessoPerFiltro <= severitaSPCoopRichiestaPdD) {
                    if (OpenSPCoopLogger.loggerMsgDiagnosticoAbilitato) {
                        String xml = this.xmlBuilder.buildString_Diagnostico(this.dominioSPCoop, this.idModulo, 3, msg);
                        try {
                            this.loggerMsgDiagnostico.log((Priority)LogLevels.LOG_LEVEL_INFO_SPCOOP, (Object)xml);
                        }
                        catch (Exception e) {
                            OpenSPCoopLogger.loggerOpenSPCoopResources.error((Object)("Errore durante l'emissione del msg diagnostico 'spcoop': " + e.getMessage()), (Throwable)e);
                            this.gestioneErroreDiagnostica(e);
                        }
                    }
                    for (int i = 0; i < this.loggerMsgDiagnosticoOpenSPCoopAppender.size(); ++i) {
                        try {
                            msgDiag = this.getMsgDiagnostico(gdo, 3, msg, codiceDiagnostico);
                            this.loggerMsgDiagnosticoOpenSPCoopAppender.get(i).log(msgDiag);
                            continue;
                        }
                        catch (Exception e) {
                            OpenSPCoopLogger.loggerOpenSPCoopResources.error((Object)("Errore durante l'emissione del msg diagnostico personalizzato [" + this.tipoMsgDiagnosticoOpenSPCoopAppender.get(i) + "]: " + e.getMessage()), (Throwable)e);
                            this.gestioneErroreDiagnostica(e);
                        }
                    }
                }
                boolean humanReadableAbilitato = false;
                humanReadableAbilitato = "IntegrationManager".equals(this.idModulo) ? OpenSPCoopLogger.loggerIntegrationManagerAbilitato : OpenSPCoopLogger.loggerMsgDiagnosticoReadableAbilitato;
                if (!humanReadableAbilitato || severitaLogEmessoPerFiltro > severitaOpenSPCoopRichiestaPdD) break block14;
                msgDiag = this.getMsgDiagnostico(gdo, 3, msg, codiceDiagnostico);
                String message = OpenSPCoopLogger.humanReadable(msgDiag, this.idCorrelazioneApplicativa, this.porta, this.delegata, this.fruitore, this.servizio, this.servizioApplicativo);
                try {
                    if ("IntegrationManager".equals(this.idModulo)) {
                        this.loggerIntegrationManager.log((Priority)LogLevels.LOG_LEVEL_INFO_SPCOOP, (Object)message);
                        break block14;
                    }
                    this.loggerOpenSPCoop.log((Priority)LogLevels.LOG_LEVEL_INFO_SPCOOP, (Object)message);
                }
                catch (Exception e) {
                    OpenSPCoopLogger.loggerOpenSPCoopResources.error((Object)("Errore durante l'emissione del msg diagnostico 'human readable': " + e.getMessage()), (Throwable)e);
                    this.gestioneErroreDiagnostica(e);
                }
            }
            catch (Exception e) {
                OpenSPCoopLogger.loggerOpenSPCoopResources.error((Object)("MsgDiagnostico.infoSPCoop error " + e.getMessage()), (Throwable)e);
                this.gestioneErroreDiagnostica(e);
            }
        }
    }

    @Deprecated
    public void infoOpenSPCoop(String msg) {
        block14: {
            String codiceDiagnostico = null;
            int severitaLogEmessoPerFiltro = LogLevels.toIntervalloOpenSPCoop(4);
            int severitaSPCoopRichiestaPdD = this.msgDiagPropertiesReader.getFiltroMsgDiagnostico_CNIPA7();
            int severitaOpenSPCoopRichiestaPdD = this.msgDiagPropertiesReader.getFiltroMsgDiagnostico_CNIPA7();
            if (this.configurazionePdDReader != null) {
                severitaSPCoopRichiestaPdD = this.msgDiagPropertiesReader.getValoreFiltroFromValoreCNIPA(this.configurazionePdDReader.getSeveritaSPCoop_msgDiagnostici());
                severitaOpenSPCoopRichiestaPdD = this.msgDiagPropertiesReader.getValoreFiltroFromValoreCNIPA(this.configurazionePdDReader.getSeveritaOpenSPCoop_msgDiagnostici());
            }
            try {
                org.openspcoop.pdd.logger.dto.MsgDiagnostico msgDiag;
                Date gdo = DateManager.getDate();
                if (this.openspcoopProperties.generazioneDateCasualiLogAbilitato() && this.pddContext != null && this.pddContext.getObject("ID") != null) {
                    gdo = this.generatoreDateCasuali.getProssimaData((String)this.pddContext.getObject("ID"));
                }
                if (severitaLogEmessoPerFiltro <= severitaSPCoopRichiestaPdD) {
                    if (OpenSPCoopLogger.loggerMsgDiagnosticoAbilitato) {
                        String xml = this.xmlBuilder.buildString_Diagnostico(this.dominioSPCoop, this.idModulo, 4, msg);
                        try {
                            this.loggerMsgDiagnostico.log((Priority)LogLevels.LOG_LEVEL_INFO_OPENSPCOOP, (Object)xml);
                        }
                        catch (Exception e) {
                            OpenSPCoopLogger.loggerOpenSPCoopResources.error((Object)("Errore durante l'emissione del msg diagnostico 'spcoop': " + e.getMessage()), (Throwable)e);
                            this.gestioneErroreDiagnostica(e);
                        }
                    }
                    for (int i = 0; i < this.loggerMsgDiagnosticoOpenSPCoopAppender.size(); ++i) {
                        try {
                            msgDiag = this.getMsgDiagnostico(gdo, 4, msg, codiceDiagnostico);
                            this.loggerMsgDiagnosticoOpenSPCoopAppender.get(i).log(msgDiag);
                            continue;
                        }
                        catch (Exception e) {
                            OpenSPCoopLogger.loggerOpenSPCoopResources.error((Object)("Errore durante l'emissione del msg diagnostico personalizzato [" + this.tipoMsgDiagnosticoOpenSPCoopAppender.get(i) + "]: " + e.getMessage()), (Throwable)e);
                            this.gestioneErroreDiagnostica(e);
                        }
                    }
                }
                boolean humanReadableAbilitato = false;
                humanReadableAbilitato = "IntegrationManager".equals(this.idModulo) ? OpenSPCoopLogger.loggerIntegrationManagerAbilitato : OpenSPCoopLogger.loggerMsgDiagnosticoReadableAbilitato;
                if (!humanReadableAbilitato || severitaLogEmessoPerFiltro > severitaOpenSPCoopRichiestaPdD) break block14;
                msgDiag = this.getMsgDiagnostico(gdo, 4, msg, codiceDiagnostico);
                String message = OpenSPCoopLogger.humanReadable(msgDiag, this.idCorrelazioneApplicativa, this.porta, this.delegata, this.fruitore, this.servizio, this.servizioApplicativo);
                try {
                    if ("IntegrationManager".equals(this.idModulo)) {
                        this.loggerIntegrationManager.log((Priority)LogLevels.LOG_LEVEL_INFO_OPENSPCOOP, (Object)message);
                        break block14;
                    }
                    this.loggerOpenSPCoop.log((Priority)LogLevels.LOG_LEVEL_INFO_OPENSPCOOP, (Object)message);
                }
                catch (Exception e) {
                    OpenSPCoopLogger.loggerOpenSPCoopResources.error((Object)("Errore durante l'emissione del msg diagnostico 'human readable': " + e.getMessage()), (Throwable)e);
                    this.gestioneErroreDiagnostica(e);
                }
            }
            catch (Exception e) {
                OpenSPCoopLogger.loggerOpenSPCoopResources.error((Object)("MsgDiagnostico.infoOpenSPCoop error " + e.getMessage()), (Throwable)e);
                this.gestioneErroreDiagnostica(e);
            }
        }
    }

    @Deprecated
    public void lowDebug(String msg) {
        block14: {
            String codiceDiagnostico = null;
            int severitaLogEmessoPerFiltro = LogLevels.toIntervalloOpenSPCoop(5);
            int severitaSPCoopRichiestaPdD = this.msgDiagPropertiesReader.getFiltroMsgDiagnostico_CNIPA7();
            int severitaOpenSPCoopRichiestaPdD = this.msgDiagPropertiesReader.getFiltroMsgDiagnostico_CNIPA7();
            if (this.configurazionePdDReader != null) {
                severitaSPCoopRichiestaPdD = this.msgDiagPropertiesReader.getValoreFiltroFromValoreCNIPA(this.configurazionePdDReader.getSeveritaSPCoop_msgDiagnostici());
                severitaOpenSPCoopRichiestaPdD = this.msgDiagPropertiesReader.getValoreFiltroFromValoreCNIPA(this.configurazionePdDReader.getSeveritaOpenSPCoop_msgDiagnostici());
            }
            try {
                org.openspcoop.pdd.logger.dto.MsgDiagnostico msgDiag;
                Date gdo = DateManager.getDate();
                if (this.openspcoopProperties.generazioneDateCasualiLogAbilitato() && this.pddContext != null && this.pddContext.getObject("ID") != null) {
                    gdo = this.generatoreDateCasuali.getProssimaData((String)this.pddContext.getObject("ID"));
                }
                if (severitaLogEmessoPerFiltro <= severitaSPCoopRichiestaPdD) {
                    if (OpenSPCoopLogger.loggerMsgDiagnosticoAbilitato) {
                        String xml = this.xmlBuilder.buildString_Diagnostico(this.dominioSPCoop, this.idModulo, 5, msg);
                        try {
                            this.loggerMsgDiagnostico.log((Priority)LogLevels.LOG_LEVEL_DEBUG_LOW, (Object)xml);
                        }
                        catch (Exception e) {
                            OpenSPCoopLogger.loggerOpenSPCoopResources.error((Object)("Errore durante l'emissione del msg diagnostico 'spcoop': " + e.getMessage()), (Throwable)e);
                            this.gestioneErroreDiagnostica(e);
                        }
                    }
                    for (int i = 0; i < this.loggerMsgDiagnosticoOpenSPCoopAppender.size(); ++i) {
                        try {
                            msgDiag = this.getMsgDiagnostico(gdo, 5, msg, codiceDiagnostico);
                            this.loggerMsgDiagnosticoOpenSPCoopAppender.get(i).log(msgDiag);
                            continue;
                        }
                        catch (Exception e) {
                            OpenSPCoopLogger.loggerOpenSPCoopResources.error((Object)("Errore durante l'emissione del msg diagnostico personalizzato [" + this.tipoMsgDiagnosticoOpenSPCoopAppender.get(i) + "]: " + e.getMessage()), (Throwable)e);
                            this.gestioneErroreDiagnostica(e);
                        }
                    }
                }
                boolean humanReadableAbilitato = false;
                humanReadableAbilitato = "IntegrationManager".equals(this.idModulo) ? OpenSPCoopLogger.loggerIntegrationManagerAbilitato : OpenSPCoopLogger.loggerMsgDiagnosticoReadableAbilitato;
                if (!humanReadableAbilitato || severitaLogEmessoPerFiltro > severitaOpenSPCoopRichiestaPdD) break block14;
                msgDiag = this.getMsgDiagnostico(gdo, 5, msg, codiceDiagnostico);
                String message = OpenSPCoopLogger.humanReadable(msgDiag, this.idCorrelazioneApplicativa, this.porta, this.delegata, this.fruitore, this.servizio, this.servizioApplicativo);
                try {
                    if ("IntegrationManager".equals(this.idModulo)) {
                        this.loggerIntegrationManager.log((Priority)LogLevels.LOG_LEVEL_DEBUG_LOW, (Object)message);
                        break block14;
                    }
                    this.loggerOpenSPCoop.log((Priority)LogLevels.LOG_LEVEL_DEBUG_LOW, (Object)message);
                }
                catch (Exception e) {
                    OpenSPCoopLogger.loggerOpenSPCoopResources.error((Object)("Errore durante l'emissione del msg diagnostico 'human readable': " + e.getMessage()), (Throwable)e);
                    this.gestioneErroreDiagnostica(e);
                }
            }
            catch (Exception e) {
                OpenSPCoopLogger.loggerOpenSPCoopResources.error((Object)("MsgDiagnostico.lowDebug error " + e.getMessage()), (Throwable)e);
                this.gestioneErroreDiagnostica(e);
            }
        }
    }

    public void mediumDebug(String msg) {
        block14: {
            String codiceDiagnostico = null;
            int severitaLogEmessoPerFiltro = LogLevels.toIntervalloOpenSPCoop(6);
            int severitaSPCoopRichiestaPdD = this.msgDiagPropertiesReader.getFiltroMsgDiagnostico_CNIPA7();
            int severitaOpenSPCoopRichiestaPdD = this.msgDiagPropertiesReader.getFiltroMsgDiagnostico_CNIPA7();
            if (this.configurazionePdDReader != null) {
                severitaSPCoopRichiestaPdD = this.msgDiagPropertiesReader.getValoreFiltroFromValoreCNIPA(this.configurazionePdDReader.getSeveritaSPCoop_msgDiagnostici());
                severitaOpenSPCoopRichiestaPdD = this.msgDiagPropertiesReader.getValoreFiltroFromValoreCNIPA(this.configurazionePdDReader.getSeveritaOpenSPCoop_msgDiagnostici());
            }
            try {
                org.openspcoop.pdd.logger.dto.MsgDiagnostico msgDiag;
                Date gdo = DateManager.getDate();
                if (this.openspcoopProperties.generazioneDateCasualiLogAbilitato() && this.pddContext != null && this.pddContext.getObject("ID") != null) {
                    gdo = this.generatoreDateCasuali.getProssimaData((String)this.pddContext.getObject("ID"));
                }
                if (severitaLogEmessoPerFiltro <= severitaSPCoopRichiestaPdD) {
                    if (OpenSPCoopLogger.loggerMsgDiagnosticoAbilitato) {
                        String xml = this.xmlBuilder.buildString_Diagnostico(this.dominioSPCoop, this.idModulo, 6, msg);
                        try {
                            this.loggerMsgDiagnostico.log((Priority)LogLevels.LOG_LEVEL_DEBUG_MEDIUM, (Object)xml);
                        }
                        catch (Exception e) {
                            OpenSPCoopLogger.loggerOpenSPCoopResources.error((Object)("Errore durante l'emissione del msg diagnostico 'spcoop': " + e.getMessage()), (Throwable)e);
                            this.gestioneErroreDiagnostica(e);
                        }
                    }
                    for (int i = 0; i < this.loggerMsgDiagnosticoOpenSPCoopAppender.size(); ++i) {
                        try {
                            msgDiag = this.getMsgDiagnostico(gdo, 6, msg, codiceDiagnostico);
                            this.loggerMsgDiagnosticoOpenSPCoopAppender.get(i).log(msgDiag);
                            continue;
                        }
                        catch (Exception e) {
                            OpenSPCoopLogger.loggerOpenSPCoopResources.error((Object)("Errore durante l'emissione del msg diagnostico personalizzato [" + this.tipoMsgDiagnosticoOpenSPCoopAppender.get(i) + "]: " + e.getMessage()), (Throwable)e);
                            this.gestioneErroreDiagnostica(e);
                        }
                    }
                }
                boolean humanReadableAbilitato = false;
                humanReadableAbilitato = "IntegrationManager".equals(this.idModulo) ? OpenSPCoopLogger.loggerIntegrationManagerAbilitato : OpenSPCoopLogger.loggerMsgDiagnosticoReadableAbilitato;
                if (!humanReadableAbilitato || severitaLogEmessoPerFiltro > severitaOpenSPCoopRichiestaPdD) break block14;
                msgDiag = this.getMsgDiagnostico(gdo, 6, msg, codiceDiagnostico);
                String message = OpenSPCoopLogger.humanReadable(msgDiag, this.idCorrelazioneApplicativa, this.porta, this.delegata, this.fruitore, this.servizio, this.servizioApplicativo);
                try {
                    if ("IntegrationManager".equals(this.idModulo)) {
                        this.loggerIntegrationManager.log((Priority)LogLevels.LOG_LEVEL_DEBUG_MEDIUM, (Object)message);
                        break block14;
                    }
                    this.loggerOpenSPCoop.log((Priority)LogLevels.LOG_LEVEL_DEBUG_MEDIUM, (Object)message);
                }
                catch (Exception e) {
                    OpenSPCoopLogger.loggerOpenSPCoopResources.error((Object)("Errore durante l'emissione del msg diagnostico 'human readable': " + e.getMessage()), (Throwable)e);
                    this.gestioneErroreDiagnostica(e);
                }
            }
            catch (Exception e) {
                OpenSPCoopLogger.loggerOpenSPCoopResources.error((Object)("MsgDiagnostico.mediumDebug error " + e.getMessage()), (Throwable)e);
                this.gestioneErroreDiagnostica(e);
            }
        }
    }

    public void highDebug(String msg) {
        block14: {
            String codiceDiagnostico = null;
            int severitaLogEmessoPerFiltro = LogLevels.toIntervalloOpenSPCoop(7);
            int severitaSPCoopRichiestaPdD = this.msgDiagPropertiesReader.getFiltroMsgDiagnostico_CNIPA7();
            int severitaOpenSPCoopRichiestaPdD = this.msgDiagPropertiesReader.getFiltroMsgDiagnostico_CNIPA7();
            if (this.configurazionePdDReader != null) {
                severitaSPCoopRichiestaPdD = this.msgDiagPropertiesReader.getValoreFiltroFromValoreCNIPA(this.configurazionePdDReader.getSeveritaSPCoop_msgDiagnostici());
                severitaOpenSPCoopRichiestaPdD = this.msgDiagPropertiesReader.getValoreFiltroFromValoreCNIPA(this.configurazionePdDReader.getSeveritaOpenSPCoop_msgDiagnostici());
            }
            try {
                org.openspcoop.pdd.logger.dto.MsgDiagnostico msgDiag;
                Date gdo = DateManager.getDate();
                if (this.openspcoopProperties.generazioneDateCasualiLogAbilitato() && this.pddContext != null && this.pddContext.getObject("ID") != null) {
                    gdo = this.generatoreDateCasuali.getProssimaData((String)this.pddContext.getObject("ID"));
                }
                if (severitaLogEmessoPerFiltro <= severitaSPCoopRichiestaPdD) {
                    if (OpenSPCoopLogger.loggerMsgDiagnosticoAbilitato) {
                        String xml = this.xmlBuilder.buildString_Diagnostico(this.dominioSPCoop, this.idModulo, 7, msg);
                        try {
                            this.loggerMsgDiagnostico.log((Priority)LogLevels.LOG_LEVEL_DEBUG_HIGH, (Object)xml);
                        }
                        catch (Exception e) {
                            OpenSPCoopLogger.loggerOpenSPCoopResources.error((Object)("Errore durante l'emissione del msg diagnostico 'spcoop': " + e.getMessage()), (Throwable)e);
                            this.gestioneErroreDiagnostica(e);
                        }
                    }
                    for (int i = 0; i < this.loggerMsgDiagnosticoOpenSPCoopAppender.size(); ++i) {
                        try {
                            msgDiag = this.getMsgDiagnostico(gdo, 7, msg, codiceDiagnostico);
                            this.loggerMsgDiagnosticoOpenSPCoopAppender.get(i).log(msgDiag);
                            continue;
                        }
                        catch (Exception e) {
                            OpenSPCoopLogger.loggerOpenSPCoopResources.error((Object)("Errore durante l'emissione del msg diagnostico personalizzato [" + this.tipoMsgDiagnosticoOpenSPCoopAppender.get(i) + "]: " + e.getMessage()), (Throwable)e);
                            this.gestioneErroreDiagnostica(e);
                        }
                    }
                }
                boolean humanReadableAbilitato = false;
                humanReadableAbilitato = "IntegrationManager".equals(this.idModulo) ? OpenSPCoopLogger.loggerIntegrationManagerAbilitato : OpenSPCoopLogger.loggerMsgDiagnosticoReadableAbilitato;
                if (!humanReadableAbilitato || severitaLogEmessoPerFiltro > severitaOpenSPCoopRichiestaPdD) break block14;
                msgDiag = this.getMsgDiagnostico(gdo, 7, msg, codiceDiagnostico);
                String message = OpenSPCoopLogger.humanReadable(msgDiag, this.idCorrelazioneApplicativa, this.porta, this.delegata, this.fruitore, this.servizio, this.servizioApplicativo);
                try {
                    if ("IntegrationManager".equals(this.idModulo)) {
                        this.loggerIntegrationManager.log((Priority)LogLevels.LOG_LEVEL_DEBUG_HIGH, (Object)message);
                        break block14;
                    }
                    this.loggerOpenSPCoop.log((Priority)LogLevels.LOG_LEVEL_DEBUG_HIGH, (Object)message);
                }
                catch (Exception e) {
                    OpenSPCoopLogger.loggerOpenSPCoopResources.error((Object)("Errore durante l'emissione del msg diagnostico 'human readable': " + e.getMessage()), (Throwable)e);
                    this.gestioneErroreDiagnostica(e);
                }
            }
            catch (Exception e) {
                OpenSPCoopLogger.loggerOpenSPCoopResources.error((Object)("MsgDiagnostico.highDebug error " + e.getMessage()), (Throwable)e);
                this.gestioneErroreDiagnostica(e);
            }
        }
    }

    private org.openspcoop.pdd.logger.dto.MsgDiagnostico getMsgDiagnostico(Date gdo, int severitaLivelloCNIPA, String msg, String codiceDiagnostico) {
        String[] key;
        org.openspcoop.pdd.logger.dto.MsgDiagnostico msgDiagnostico = new org.openspcoop.pdd.logger.dto.MsgDiagnostico();
        Calendar c = Calendar.getInstance();
        c.setTime(gdo);
        msgDiagnostico.setGdo(c);
        msgDiagnostico.setIdPorta(this.dominioSPCoop);
        msgDiagnostico.setIdFunzione(this.idModulo);
        msgDiagnostico.setSeverita(severitaLivelloCNIPA + "");
        msgDiagnostico.setMessaggio(msg);
        msgDiagnostico.setIdEgov(this.idEGovRichiesta);
        msgDiagnostico.setIdEgovRisposta(this.idEGovRisposta);
        msgDiagnostico.setCodice(codiceDiagnostico);
        if (this.pddContext != null && (key = CostantiPdD.CONTEXT_OBJECT) != null) {
            for (int j = 0; j < key.length; ++j) {
                Object o = this.pddContext.getObject(key[j]);
                if (o == null || !(o instanceof String)) continue;
                msgDiagnostico.addProperty(key[j], (String)o);
            }
        }
        return msgDiagnostico;
    }

    private void gestioneErroreDiagnostica(Exception e) {
        if (this.openspcoopProperties.isRegistrazioneDiagnosticaFallita_BloccoServiziPdD()) {
            gestoreDiagnosticaDisponibile = false;
            motivoMalfunzionamentoDiagnostici = e;
            OpenSPCoopLogger.loggerOpenSPCoopResources.error((Object)"Il Sistema di gestione della diagnostica ha rilevato un errore durante la registrazione di un messaggio diagnostico, tutti i servizi/moduli della porta di dominio sono sospesi. Si richiede un intervento sistemistico per la risoluzione del problema e il riavvio della Porta di Dominio. Errore rilevato: ", (Throwable)e);
        }
    }
}

