/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop.pdd.logger;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.openspcoop.pdd.config.MsgDiagnosticiInstanceProperties;
import org.openspcoop.pdd.logger.LogLevels;
import org.openspcoop.pdd.logger.OpenSPCoopLogger;
import org.openspcoop.pdd.services.OpenSPCoopStartup;

public class MsgDiagnosticiProperties {
    private Logger log = OpenSPCoopStartup.initialize ? OpenSPCoopLogger.getLoggerOpenSPCoopCore() : Logger.getLogger((String)"InizializzatoreMessaggiDiagnostici");
    private MsgDiagnosticiInstanceProperties reader;
    private static MsgDiagnosticiProperties msgDiagnosticiProperties = null;
    private static Integer filtroMsgDiagnostico_CNIPA0 = null;
    private static Integer filtroMsgDiagnostico_CNIPA1 = null;
    private static Integer filtroMsgDiagnostico_CNIPA2 = null;
    private static Integer filtroMsgDiagnostico_CNIPA3 = null;
    private static Integer filtroMsgDiagnostico_CNIPA4 = null;
    private static Integer filtroMsgDiagnostico_CNIPA5 = null;
    private static Integer filtroMsgDiagnostico_CNIPA6 = null;
    private static Integer filtroMsgDiagnostico_CNIPA7 = null;
    private static Hashtable<String, Integer> livelliMsgDiagnosticiPersonalizzati = null;
    private static Hashtable<String, String> codiciMsgDiagnosticiPersonalizzati = null;
    private static Hashtable<String, String> codiciIdentificativiFunzione = null;
    private static Hashtable<String, String> messaggiMsgDiagnosticiPersonalizzati = null;
    private static Hashtable<String, String> mappingCodiceToKeywordMsgDiagnosticiPersonalizzati = null;
    public static final String MSG_DIAG_RICEZIONE_CONTENUTI_APPLICATIVI = "ricezioneContenutiApplicativi.";
    public static final String MSG_DIAG_IMBUSTAMENTO = "imbustamentoBustaEGov.";
    public static final String MSG_DIAG_IMBUSTAMENTO_RISPOSTE = "imbustamentoRispostaBustaEGov.";
    public static final String MSG_DIAG_INOLTRO_BUSTE_EGOV = "inoltroBusteEGov.";
    public static final String MSG_DIAG_RICEZIONE_BUSTE_EGOV = "ricezioneBusteEGov.";
    public static final String MSG_DIAG_SBUSTAMENTO = "sbustamentoBustaEGov.";
    public static final String MSG_DIAG_SBUSTAMENTO_RISPOSTE = "sbustamentoRispostaBustaEGov.";
    public static final String MSG_DIAG_CONSEGNA_CONTENUTI_APPLICATIVI = "consegnaContenutiApplicativi.";
    public static final String MSG_DIAG_INTEGRATION_MANAGER = "integrationManager.";
    public static final String MSG_DIAG_TRACCIAMENTO = "tracciamento.";
    public static final String MSG_DIAG_TIMER_GESTORE_RISCONTRI_RICEVUTE = "timerGestoreRiscontriRicevute.";
    public static final String MSG_DIAG_TIMER_GESTORE_MESSAGGI = "timerGestoreMessaggi.";
    public static final String MSG_DIAG_TIMER_GESTORE_MESSAGGI_INCONSISTENTI = "timerGestoreMessaggiInconsistenti.";
    public static final String MSG_DIAG_TIMER_GESTORE_REPOSITORY_EGOV = "timerGestoreRepositoryEGov.";
    public static final String MSG_DIAG_TIMER_MONITORAGGIO_RISORSE = "timerMonitoraggioRisorse.";
    public static final String MSG_DIAG_TIMER_THRESHOLD = "timerThreshold.";
    public static final String MSG_DIAG_OPENSPCOOP_STARTUP = "openspcoopStartup.";
    public static final String MSG_DIAG_ALL = "all.";
    private static final String[] MSG_DIAGNOSTICI_PERSONALIZZATI = new String[]{"ricezioneContenutiApplicativi.correlazioneApplicativaEsistente", "ricezioneContenutiApplicativi.correlazioneApplicativaInstaurata", "ricezioneContenutiApplicativi.ricevutaRichiestaApplicativa", "ricezioneContenutiApplicativi.consegnaRispostaApplicativa", "ricezioneContenutiApplicativi.consegnaRispostaApplicativaOkEffettuata", "ricezioneContenutiApplicativi.consegnaRispostaApplicativaKoEffettuata", "ricezioneContenutiApplicativi.consegnaRispostaApplicativaVuota", "ricezioneContenutiApplicativi.consegnaRispostaApplicativaFallita", "ricezioneContenutiApplicativi.timeoutRicezioneRisposta", "ricezioneContenutiApplicativi.richiestaContenenteBustaEGov", "ricezioneContenutiApplicativi.portaDelegataNonEsistente", "ricezioneContenutiApplicativi.servizioApplicativoFruitore.identificazioneTramiteInfoIntegrazioneNonRiuscita", "ricezioneContenutiApplicativi.servizioApplicativoFruitore.identificazioneTramiteCredenziali", "ricezioneContenutiApplicativi.identificazioneDinamicaServizioSPCoopNonRiuscita", "ricezioneContenutiApplicativi.servizioApplicativoFruitore.nonAutorizzato", "ricezioneContenutiApplicativi.servizioApplicativoFruitore.contenuto.nonAutorizzato", "ricezioneContenutiApplicativi.validazioneContenutiApplicativiNonRiuscita", "ricezioneContenutiApplicativi.portaDelegataInvocabilePerRiferimento.riferimentoNonPresente", "ricezioneContenutiApplicativi.portaDelegataInvocabileNormalmente.riferimentoPresente", "ricezioneContenutiApplicativi.funzionalitaScartaBodyNonEffettuabile", "ricezioneContenutiApplicativi.funzionalitaAllegaBodyNonEffettuabile", "ricezioneContenutiApplicativi.headerIntegrazione.letturaFallita", "ricezioneContenutiApplicativi.messaggioInGestione", "ricezioneContenutiApplicativi.messaggioInGestione.marcatoDaEliminare", "ricezioneContenutiApplicativi.mustUnderstand.unknown", "ricezioneContenutiApplicativi.contentType.unsupported", "ricezioneContenutiApplicativi.mustUnderstand.unknown", "ricezioneContenutiApplicativi.contentType.unsupported", "ricezioneContenutiApplicativi.soapEnvelopeNamespace.versionMismatch", "ricezioneContenutiApplicativi.gestoreCredenziali.errore", "ricezioneContenutiApplicativi.gestoreCredenziali.nuoveCredenziali", "ricezioneContenutiApplicativi.contentType.notDefined", "imbustamentoBustaEGov.registroServizi.ricercaServizioInCorso", "imbustamentoBustaEGov.registroServizi.ricercaServizioEffettuata", "imbustamentoBustaEGov.registroServizi.ricercaServizioFallita", "imbustamentoBustaEGov.consegnaAffidabile.salvataggioInformazioni", "imbustamentoBustaEGov.consegnaAffidabile.profiloNonOneway", "imbustamentoBustaEGov.consegnaInOrdine.profiloNonOneway", "imbustamentoBustaEGov.consegnaInOrdine.confermaRicezioneNonRichiesta", "imbustamentoBustaEGov.consegnaInOrdine.idCollaborazioneNonRichiesto", "imbustamentoBustaEGov.consegnaInOrdine.funzionalitaSPCoopMancanti", "imbustamentoBustaEGov.profiloAsincronoSimmetrico.saAnonimo", "imbustamentoBustaEGov.profiloAsincronoSimmetrico.saSenzaRispostaAsincrona", "imbustamentoBustaEGov.profiloAsincronoSimmetrico.servizioCorrelatoNonEsistente", "imbustamentoBustaEGov.profiloAsincronoSimmetrico.rispostaNonCorrelataRichiesta", "imbustamentoBustaEGov.profiloAsincronoAsimmetrico.richiestaStatoNonCorrelataRichiesta", "imbustamentoBustaEGov.profiloAsincronoSimmetrico.risposta.correlazioneRichiesta", "imbustamentoBustaEGov.profiloAsincronoAsimmetrico.richiestaStato.correlazioneRichiesta", "inoltroBusteEGov.routingTable.esaminaInCorso", "inoltroBusteEGov.routingTable.esaminaInCorsoFallita", "inoltroBusteEGov.routingTable.esaminaEffettuata", "inoltroBusteEGov.routingTable.utilizzoIndirizzoTelematico", "inoltroBusteEGov.routingTable.soggettoFruitoreNonGestito", "inoltroBusteEGov.inoltroInCorso", "inoltroBusteEGov.inoltroEffettuato", "inoltroBusteEGov.inoltroConErrore", "inoltroBusteEGov.ricezioneMessaggioSPCoop", "inoltroBusteEGov.ricezioneMessaggioSPCoopErrore", "inoltroBusteEGov.ricezioneMessaggioSPCoopErrore.rollback", "inoltroBusteEGov.inoltroBustaScaduta", "inoltroBusteEGov.ricezioneSoapFault", "inoltroBusteEGov.profiloSincrono.rispostaNonPervenuta", "inoltroBusteEGov.validazioneContenutiApplicativiNonRiuscita", "inoltroBusteEGov.ricezioneSoapMessage.headerEGovNonPresente", "inoltroBusteEGov.ricezioneSoapMessage.msgGiaPresente", "inoltroBusteEGov.riconsegnaMessaggioPrematura", "inoltroBusteEGov.rispostaRicevuta.messaggioSPCoop", "inoltroBusteEGov.rispostaRicevuta.messaggioSPCoopErrore", "inoltroBusteEGov.gestioneConsegnaTerminata", "ricezioneBusteEGov.ricezioneMessaggioSPCoop", "ricezioneBusteEGov.ricezioneMessaggioSPCoopErrore", "ricezioneBusteEGov.autorizzazioneSPCoopInCorso", "ricezioneBusteEGov.autorizzazioneSPCoopEffettuata", "ricezioneBusteEGov.autorizzazioneSPCoopFallita", "ricezioneBusteEGov.generazioneMessaggioSPCoopRisposta", "ricezioneBusteEGov.generazioneMessaggioSPCoopErroreRisposta", "ricezioneBusteEGov.generazioneMessaggioSPCoopErroreRisposta.destinatarioSconosciuto", "ricezioneBusteEGov.generazioneRiscontro", "ricezioneBusteEGov.generazioneRicevutaAsincrona", "ricezioneBusteEGov.consegnaMessaggioSPCoopOkEffettuata", "ricezioneBusteEGov.consegnaMessaggioSPCoopKoEffettuata", "ricezioneBusteEGov.consegnaMessaggioSPCoopNonPresente", "ricezioneBusteEGov.consegnaMessaggioSPCoopFallita", "ricezioneBusteEGov.timeoutRicezioneRisposta", "ricezioneBusteEGov.messaggioInGestione.marcatoDaEliminare", "ricezioneBusteEGov.messaggioInGestione.gestioneSincrona", "ricezioneBusteEGov.messaggioInGestione.gestioneAsincrona", "ricezioneBusteEGov.messaggioInGestione.attesaFineProcessamento.filtroDuplicatiAbilitato", "ricezioneBusteEGov.messaggioInGestione.attesaFineProcessamento.filtroDuplicatiDisabilitato", "ricezioneBusteEGov.messaggioInGestione.attesaFineProcessamento.filtroDuplicatiDisabilitato.attesaTerminata", "ricezioneBusteEGov.messaggioInGestione.attesaFineProcessamento.filtroDuplicatiDisabilitato.forzoEliminazione", "ricezioneBusteEGov.messaggioInGestione.attesaFineProcessamento.timeoutScaduto", "ricezioneBusteEGov.attesaFineProcessamento.richiestaAsincrona.timeoutScaduto", "ricezioneBusteEGov.attesaFineProcessamento.ricevutaRichiestaAsincrona.timeoutScaduto", "ricezioneBusteEGov.validazioneContenutiApplicativiNonRiuscita", "ricezioneBusteEGov.headerIntegrazione.letturaFallita", "ricezioneBusteEGov.mustUnderstand.unknown", "ricezioneBusteEGov.contentType.unsupported", "ricezioneBusteEGov.soapEnvelopeNamespace.versionMismatch", "ricezioneBusteEGov.gestoreCredenziali.errore", "ricezioneBusteEGov.gestoreCredenziali.nuoveCredenziali", "ricezioneBusteEGov.contentType.notDefined", "sbustamentoBustaEGov.ricezioneBustaErrore", "sbustamentoBustaEGov.ricezioneBusta.eccezioniNonGravi", "sbustamentoBustaEGov.validazioneSintatticaNonRiuscita", "sbustamentoBustaEGov.validazioneBustaErrore.listaEccezioniMalformata", "sbustamentoBustaEGov.validazioneBusta.bustaNonCorretta", "sbustamentoBustaEGov.validazioneBusta.eccezioniNonGravi", "sbustamentoBustaEGov.validazioneRicevutaAsincrona", "sbustamentoBustaEGov.ricezioneRiscontro", "sbustamentoBustaEGov.ricezioneBustaServizio", "sbustamentoBustaEGov.ricezioneBustaDuplicata", "sbustamentoBustaEGov.ricezioneBustaDuplicata.count", "sbustamentoBustaEGov.ricezioneBusta.registrazionePerFiltroDuplicati", "sbustamentoBustaEGov.funzionalitaRichiestaAccordo.confermaRicezioneNonPresente", "sbustamentoBustaEGov.funzionalitaRichiestaAccordo.consegnaInOrdineNonPresente", "sbustamentoBustaEGov.consegnaInOrdine.profiloDiversoOneway", "sbustamentoBustaEGov.soggettoDestinatarioNonGestito", "sbustamentoBustaEGov.portaApplicativaNonEsistente", "sbustamentoBustaEGov.ricezioneRispostaSincrona", "sbustamentoBustaEGov.profiloAsincrono.flussoRicevutaRichiestaRispostaNonCorretto", "sbustamentoBustaEGov.profiloAsincronoAsimmetrico.saSenzaRispostaAsincrona", "sbustamentoBustaEGov.profiloAsincronoAsimmetrico.servizioCorrelatoNonEsistente", "sbustamentoBustaEGov.ricezioneBustaErroreDetails", "sbustamentoRispostaBustaEGov.ricezioneBustaErrore", "sbustamentoRispostaBustaEGov.ricezioneBusta.eccezioniNonGravi", "sbustamentoRispostaBustaEGov.validazioneBustaErrore.listaEccezioniMalformata", "sbustamentoRispostaBustaEGov.validazioneBusta.eccezioniNonGravi", "sbustamentoRispostaBustaEGov.validazioneBusta.bustaNonCorretta", "sbustamentoRispostaBustaEGov.validazioneRicevutaAsincrona", "sbustamentoRispostaBustaEGov.ricezioneRiscontro", "sbustamentoRispostaBustaEGov.ricezioneBustaServizio", "sbustamentoRispostaBustaEGov.ricezioneBustaDuplicata", "sbustamentoRispostaBustaEGov.ricezioneBustaDuplicata.count", "sbustamentoRispostaBustaEGov.ricezioneBusta.registrazionePerFiltroDuplicati", "sbustamentoRispostaBustaEGov.rispostaOneway", "sbustamentoRispostaBustaEGov.soggettoDestinatarioNonGestito", "sbustamentoRispostaBustaEGov.profiloCollaborazioneRisposta.diversoScenarioGestito", "sbustamentoRispostaBustaEGov.riferimentoMessaggioNonValido", "sbustamentoRispostaBustaEGov.riferimentoMessaggioNonPresente", "sbustamentoRispostaBustaEGov.ricezioneBustaErroreDetails", "consegnaContenutiApplicativi.integrationManager.messaggioDisponibile", "consegnaContenutiApplicativi.consegnaNonDefinita", "consegnaContenutiApplicativi.trasmissioneSincrona.servizioNonUtilizzabile", "consegnaContenutiApplicativi.gestioneProfiloAsincrono.servizioNonUtilizzabile", "consegnaContenutiApplicativi.servizioApplicativoNonDefinito", "consegnaContenutiApplicativi.gestioneProfiloNonOneway.consegnaVersoNServiziApplicativi", "consegnaContenutiApplicativi.gestioneStateless.consegnaVersoNServiziApplicativi", "consegnaContenutiApplicativi.gestioneStateless.integrationManager", "consegnaContenutiApplicativi.consegnaInOrdine.messaggioFuoriOrdine", "consegnaContenutiApplicativi.consegnaInOrdine.messaggioGiaConsegnato", "consegnaContenutiApplicativi.consegnaInCorso", "consegnaContenutiApplicativi.consegnaEffettuata", "consegnaContenutiApplicativi.consegnaConErrore", "consegnaContenutiApplicativi.ricezioneSoapFault", "consegnaContenutiApplicativi.validazioneContenutiApplicativiNonRiuscita", "consegnaContenutiApplicativi.funzionalitaScartaBodyNonRiuscita", "consegnaContenutiApplicativi.funzionalitaAllegaBodyNonRiuscita", "consegnaContenutiApplicativi.riconsegnaMessaggioPrematura", "consegnaContenutiApplicativi.gestioneConsegnaTerminata", "integrationManager.logInvocazioneOperazione", "integrationManager.autenticazioneNonImpostata", "integrationManager.servizioApplicativo.identificazioneTramiteCredenziali", "integrationManager.servizioApplicativo.nonAutorizzato", "integrationManager.mappingRifMsgToIdEGov.nonRiuscito", "integrationManager.buildMsg.nonRiuscito", "integrationManager.buildMsg.imbustamentoSOAP.nonRiuscito", "integrationManager.invocazionePortaDelegata.contenutoApplicativoNonPresente", "integrationManager.invocazionePortaDelegata.profiloAsincrono.riferimentoMessaggioNonPresente", "integrationManager.invocazionePortaDelegataPerRiferimento.riferimentoMessaggioNonPresente", "integrationManager.messaggiNonPresenti", "integrationManager.messaggioNonTrovato", "integrationManager.gestoreCredenziali.errore", "integrationManager.gestoreCredenziali.nuoveCredenziali", "tracciamento.registrazioneNonRiuscita", "tracciamento.registrazioneNonRiuscita.openspcoopAppender", "tracciamento.dumpContenutiApplicativi.registrazioneNonRiuscita", "tracciamento.dumpContenutiApplicativi.registrazioneNonRiuscita.openspcoopAppender", "tracciamento.errore.bloccoServizi", "tracciamento.dumpContenutiApplicativi.errore.bloccoServizi", "timerGestoreRiscontriRicevute.avvioInCorso", "timerGestoreRiscontriRicevute.avvioEffettuato", "timerGestoreRiscontriRicevute.timerGiaAvviato", "timerGestoreRiscontriRicevute.disabilitato", "timerGestoreRiscontriRicevute.controlloInCorso", "timerGestoreRiscontriRicevute.bustaNonRiscontrata", "timerGestoreRiscontriRicevute.bustaNonRiscontrataScaduta", "timerGestoreRiscontriRicevute.bustaNonRiscontrata.messaggioNonEsistente", "timerGestoreRiscontriRicevute.ricevutaAsincronaNonRicevuta", "timerGestoreRiscontriRicevute.ricevutaAsincronaNonRicevuta.bustaScaduta", "timerGestoreRiscontriRicevute.ricevutaAsincronaNonRicevuta.messaggioNonEsistente", "timerGestoreRiscontriRicevute.precedenteEsecuzioneInCorso", "timerGestoreMessaggi.avvioInCorso", "timerGestoreMessaggi.avvioEffettuato", "timerGestoreMessaggi.timerGiaAvviato", "timerGestoreMessaggi.disabilitato", "timerGestoreMessaggi.controlloInCorso", "timerGestoreMessaggi.ricercaMessaggiDaEliminare", "timerGestoreMessaggi.eliminazioneMessaggio", "timerGestoreMessaggi.eliminazioneDestinatarioMessaggio", "timerGestoreMessaggi.messaggioNonConsumato.codaJMS", "timerGestoreMessaggi.ricercaCorrelazioniApplicativeScadute", "timerGestoreMessaggi.eliminazioneCorrelazioneApplicativaScaduta", "timerGestoreMessaggi.precedenteEsecuzioneInCorso", "timerGestoreMessaggi.connessioneScaduta.EliminazioneInCorso", "timerGestoreMessaggi.connessioneScaduta.EliminazioneEffettuata", "timerGestoreMessaggiInconsistenti.avvioInCorso", "timerGestoreMessaggiInconsistenti.avvioEffettuato", "timerGestoreMessaggiInconsistenti.timerGiaAvviato", "timerGestoreMessaggiInconsistenti.disabilitato", "timerGestoreMessaggiInconsistenti.controlloInCorso", "timerGestoreMessaggiInconsistenti.ricercaMessaggiDaEliminare", "timerGestoreMessaggiInconsistenti.eliminazioneMessaggio", "timerGestoreMessaggiInconsistenti.precedenteEsecuzioneInCorso", "timerGestoreRepositoryEGov.avvioInCorso", "timerGestoreRepositoryEGov.avvioEffettuato", "timerGestoreRepositoryEGov.timerGiaAvviato", "timerGestoreRepositoryEGov.disabilitato", "timerGestoreRepositoryEGov.controlloInCorso", "timerGestoreRepositoryEGov.ricercaMessaggiDaEliminare", "timerGestoreRepositoryEGov.eliminazioneMessaggio", "timerGestoreRepositoryEGov.precedenteEsecuzioneInCorso", "timerMonitoraggioRisorse.avvioEffettuato", "timerMonitoraggioRisorse.risorsaNonDisponibile", "timerMonitoraggioRisorse.validazioneSemanticaFallita", "timerMonitoraggioRisorse.risorsaRitornataDisponibile", "timerThreshold.avvioEffettuato", "timerThreshold.controlloInCorso", "timerThreshold.risorsaNonDisponibile", "timerThreshold.risorsaRitornataDisponibile", "openspcoopStartup.pdd", "openspcoopStartup.IntegrationManager", "openspcoopStartup.erroreGenerico", "all.erroreGenerico", "all.erroreGenericoMalfunzionamentoPdD", "all.transactionManager.validityCheckError", "all.connessioneUscita.disconnectError"};
    private static final String PREFIX_MSG_DIAGNOSTICO = "org.openspcoop.pdd.msgdiagnostico.";
    private static final String SUFFIX_LIVELLO_MSG_DIAGNOSTICO = ".livello";
    private static final String SUFFIX_CODICE_MSG_DIAGNOSTICO = ".codice";
    private static final String SUFFIX_MESSAGGIO_MSG_DIAGNOSTICO = ".messaggio";
    private static final String SUFFIX_CODICE_MODULO_MSG_DIAGNOSTICO = ".codiceModulo";

    public MsgDiagnosticiProperties(String location, String confDir) throws Exception {
        Properties propertiesReader = new Properties();
        InputStream properties = null;
        try {
            properties = location != null ? new FileInputStream(location) : MsgDiagnosticiProperties.class.getResourceAsStream("/msgDiagnostici.properties");
            propertiesReader.load(properties);
            properties.close();
        }
        catch (IOException e) {
            this.log.error((Object)("Riscontrato errore durante la lettura del file 'msgDiagnostici.properties': \n\n" + e.getMessage()));
            try {
                if (properties != null) {
                    properties.close();
                }
            }
            catch (Exception er) {
                // empty catch block
            }
            throw new Exception("MsgDiagnosticiProperties initialize error: " + e.getMessage());
        }
        this.reader = new MsgDiagnosticiInstanceProperties(propertiesReader, this.log, confDir);
    }

    public static boolean initialize(String location, String confDir) {
        try {
            msgDiagnosticiProperties = new MsgDiagnosticiProperties(location, confDir);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static MsgDiagnosticiProperties getInstance() {
        return msgDiagnosticiProperties;
    }

    public static void updateLocalImplementation(Properties prop) {
        MsgDiagnosticiProperties.msgDiagnosticiProperties.reader.setLocalObjectImplementation(prop);
    }

    public static boolean initialize() {
        try {
            msgDiagnosticiProperties = new MsgDiagnosticiProperties(null, null);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public int getFiltroMsgDiagnostico_CNIPA0() {
        if (filtroMsgDiagnostico_CNIPA0 == null) {
            try {
                String value = null;
                value = this.reader.getValue("filtroMsgDiagnostici.livelloCnipa.0");
                if (value == null) {
                    filtroMsgDiagnostico_CNIPA0 = LogLevels.toIntervalloOpenSPCoop(0);
                } else {
                    filtroMsgDiagnostico_CNIPA0 = Integer.parseInt(value.trim());
                    if (filtroMsgDiagnostico_CNIPA0 < 0 || filtroMsgDiagnostico_CNIPA0 > 9999) {
                        throw new Exception("Il valore della proprieta' deve essere compreso nell'intervallo [0,9999]");
                    }
                }
            }
            catch (Exception e) {
                this.log.error((Object)("Riscontrato errore durante la lettura della proprieta' 'filtroMsgDiagnostici.livelloCnipa.0': " + e.getMessage()));
                filtroMsgDiagnostico_CNIPA0 = LogLevels.toIntervalloOpenSPCoop(0);
            }
        }
        return filtroMsgDiagnostico_CNIPA0;
    }

    public int getFiltroMsgDiagnostico_CNIPA1() {
        if (filtroMsgDiagnostico_CNIPA1 == null) {
            try {
                String value = null;
                value = this.reader.getValue("filtroMsgDiagnostici.livelloCnipa.1");
                if (value == null) {
                    filtroMsgDiagnostico_CNIPA1 = LogLevels.toIntervalloOpenSPCoop(1);
                } else {
                    filtroMsgDiagnostico_CNIPA1 = Integer.parseInt(value.trim());
                    if (filtroMsgDiagnostico_CNIPA1 < 1 || filtroMsgDiagnostico_CNIPA1 > 19999) {
                        throw new Exception("Il valore della proprieta' deve essere compreso nell'intervallo [1,19999]");
                    }
                }
            }
            catch (Exception e) {
                this.log.error((Object)("Riscontrato errore durante la lettura della proprieta' 'filtroMsgDiagnostici.livelloCnipa.1': " + e.getMessage()));
                filtroMsgDiagnostico_CNIPA1 = LogLevels.toIntervalloOpenSPCoop(1);
            }
        }
        return filtroMsgDiagnostico_CNIPA1;
    }

    public int getFiltroMsgDiagnostico_CNIPA2() {
        if (filtroMsgDiagnostico_CNIPA2 == null) {
            try {
                String value = null;
                value = this.reader.getValue("filtroMsgDiagnostici.livelloCnipa.2");
                if (value == null) {
                    filtroMsgDiagnostico_CNIPA2 = LogLevels.toIntervalloOpenSPCoop(2);
                } else {
                    filtroMsgDiagnostico_CNIPA2 = Integer.parseInt(value.trim());
                    if (filtroMsgDiagnostico_CNIPA2 < 10001 || filtroMsgDiagnostico_CNIPA2 > 29999) {
                        throw new Exception("Il valore della proprieta' deve essere compreso nell'intervallo [10001,29999]");
                    }
                }
            }
            catch (Exception e) {
                this.log.error((Object)("Riscontrato errore durante la lettura della proprieta' 'filtroMsgDiagnostici.livelloCnipa.2': " + e.getMessage()));
                filtroMsgDiagnostico_CNIPA2 = LogLevels.toIntervalloOpenSPCoop(2);
            }
        }
        return filtroMsgDiagnostico_CNIPA2;
    }

    public int getFiltroMsgDiagnostico_CNIPA3() {
        if (filtroMsgDiagnostico_CNIPA3 == null) {
            try {
                String value = null;
                value = this.reader.getValue("filtroMsgDiagnostici.livelloCnipa.3");
                if (value == null) {
                    filtroMsgDiagnostico_CNIPA3 = LogLevels.toIntervalloOpenSPCoop(3);
                } else {
                    filtroMsgDiagnostico_CNIPA3 = Integer.parseInt(value.trim());
                    if (filtroMsgDiagnostico_CNIPA3 < 20001 || filtroMsgDiagnostico_CNIPA3 > 39999) {
                        throw new Exception("Il valore della proprieta' deve essere compreso nell'intervallo [20001,39999]");
                    }
                }
            }
            catch (Exception e) {
                this.log.error((Object)("Riscontrato errore durante la lettura della proprieta' 'filtroMsgDiagnostici.livelloCnipa.3': " + e.getMessage()));
                filtroMsgDiagnostico_CNIPA3 = LogLevels.toIntervalloOpenSPCoop(3);
            }
        }
        return filtroMsgDiagnostico_CNIPA3;
    }

    public int getFiltroMsgDiagnostico_CNIPA4() {
        if (filtroMsgDiagnostico_CNIPA4 == null) {
            try {
                String value = null;
                value = this.reader.getValue("filtroMsgDiagnostici.livelloCnipa.4");
                if (value == null) {
                    filtroMsgDiagnostico_CNIPA4 = LogLevels.toIntervalloOpenSPCoop(4);
                } else {
                    filtroMsgDiagnostico_CNIPA4 = Integer.parseInt(value.trim());
                    if (filtroMsgDiagnostico_CNIPA4 < 30001 || filtroMsgDiagnostico_CNIPA4 > 49999) {
                        throw new Exception("Il valore della proprieta' deve essere compreso nell'intervallo [30001,49999]");
                    }
                }
            }
            catch (Exception e) {
                this.log.error((Object)("Riscontrato errore durante la lettura della proprieta' 'filtroMsgDiagnostici.livelloCnipa.4': " + e.getMessage()));
                filtroMsgDiagnostico_CNIPA4 = LogLevels.toIntervalloOpenSPCoop(4);
            }
        }
        return filtroMsgDiagnostico_CNIPA4;
    }

    public int getFiltroMsgDiagnostico_CNIPA5() {
        if (filtroMsgDiagnostico_CNIPA5 == null) {
            try {
                String value = null;
                value = this.reader.getValue("filtroMsgDiagnostici.livelloCnipa.5");
                if (value == null) {
                    filtroMsgDiagnostico_CNIPA5 = LogLevels.toIntervalloOpenSPCoop(5);
                } else {
                    filtroMsgDiagnostico_CNIPA5 = Integer.parseInt(value.trim());
                    if (filtroMsgDiagnostico_CNIPA5 < 40001 || filtroMsgDiagnostico_CNIPA5 > 59999) {
                        throw new Exception("Il valore della proprieta' deve essere compreso nell'intervallo [40001,59999]");
                    }
                }
            }
            catch (Exception e) {
                this.log.error((Object)("Riscontrato errore durante la lettura della proprieta' 'filtroMsgDiagnostici.livelloCnipa.5': " + e.getMessage()));
                filtroMsgDiagnostico_CNIPA5 = LogLevels.toIntervalloOpenSPCoop(5);
            }
        }
        return filtroMsgDiagnostico_CNIPA5;
    }

    public int getFiltroMsgDiagnostico_CNIPA6() {
        if (filtroMsgDiagnostico_CNIPA6 == null) {
            try {
                String value = null;
                value = this.reader.getValue("filtroMsgDiagnostici.livelloCnipa.6");
                if (value == null) {
                    filtroMsgDiagnostico_CNIPA6 = LogLevels.toIntervalloOpenSPCoop(6);
                } else {
                    filtroMsgDiagnostico_CNIPA6 = Integer.parseInt(value.trim());
                    if (filtroMsgDiagnostico_CNIPA6 < 50001 || filtroMsgDiagnostico_CNIPA6 > 69999) {
                        throw new Exception("Il valore della proprieta' deve essere compreso nell'intervallo [50001,69999]");
                    }
                }
            }
            catch (Exception e) {
                this.log.error((Object)("Riscontrato errore durante la lettura della proprieta' 'filtroMsgDiagnostici.livelloCnipa.6': " + e.getMessage()));
                filtroMsgDiagnostico_CNIPA6 = LogLevels.toIntervalloOpenSPCoop(6);
            }
        }
        return filtroMsgDiagnostico_CNIPA6;
    }

    public int getFiltroMsgDiagnostico_CNIPA7() {
        if (filtroMsgDiagnostico_CNIPA7 == null) {
            try {
                String value = null;
                value = this.reader.getValue("filtroMsgDiagnostici.livelloCnipa.7");
                if (value == null) {
                    filtroMsgDiagnostico_CNIPA7 = LogLevels.toIntervalloOpenSPCoop(7);
                } else {
                    filtroMsgDiagnostico_CNIPA7 = Integer.parseInt(value.trim());
                    if (filtroMsgDiagnostico_CNIPA7 < 60001 || filtroMsgDiagnostico_CNIPA7 > 70000) {
                        throw new Exception("Il valore della proprieta' deve essere compreso nell'intervallo [60001,70000]");
                    }
                }
            }
            catch (Exception e) {
                this.log.error((Object)("Riscontrato errore durante la lettura della proprieta' 'filtroMsgDiagnostici.livelloCnipa.7': " + e.getMessage()));
                filtroMsgDiagnostico_CNIPA7 = LogLevels.toIntervalloOpenSPCoop(7);
            }
        }
        return filtroMsgDiagnostico_CNIPA7;
    }

    public int getValoreFiltroFromValoreCNIPA(int livello) {
        if (livello == 0) {
            return this.getFiltroMsgDiagnostico_CNIPA0();
        }
        if (livello == 1) {
            return this.getFiltroMsgDiagnostico_CNIPA1();
        }
        if (livello == 2) {
            return this.getFiltroMsgDiagnostico_CNIPA2();
        }
        if (livello == 3) {
            return this.getFiltroMsgDiagnostico_CNIPA3();
        }
        if (livello == 4) {
            return this.getFiltroMsgDiagnostico_CNIPA4();
        }
        if (livello == 5) {
            return this.getFiltroMsgDiagnostico_CNIPA5();
        }
        if (livello == 6) {
            return this.getFiltroMsgDiagnostico_CNIPA6();
        }
        if (livello == 7) {
            return this.getFiltroMsgDiagnostico_CNIPA7();
        }
        return livello;
    }

    public boolean checkValoriFiltriMsgDiagnostici(Logger log) {
        int cnipa7;
        int cnipa6;
        int cnipa5;
        int cnipa4;
        int cnipa3;
        int cnipa2;
        int cnipa1;
        int cnipa0 = this.getFiltroMsgDiagnostico_CNIPA0();
        if (cnipa0 != LogLevels.toIntervalloOpenSPCoop(0)) {
            log.info((Object)("Personalizzazione del livello di filtro dei messaggi diagnostici (CNIPA 0) al valore openspcoop: " + cnipa0));
        }
        if ((cnipa1 = this.getFiltroMsgDiagnostico_CNIPA1()) <= cnipa0) {
            log.error((Object)("Personalizzazione del livello di filtro dei messaggi diagnostici CNIPA 1 (valore: " + cnipa1 + ") deve essere maggiore del valore impostato per il livello CNIPA 0 (valore: " + cnipa0 + ")."));
            return false;
        }
        if (cnipa1 != LogLevels.toIntervalloOpenSPCoop(1)) {
            log.info((Object)("Personalizzazione del livello di filtro dei messaggi diagnostici (CNIPA 1) al valore openspcoop: " + cnipa1));
        }
        if ((cnipa2 = this.getFiltroMsgDiagnostico_CNIPA2()) <= cnipa1) {
            log.error((Object)("Personalizzazione del livello di filtro dei messaggi diagnostici CNIPA 2 (valore: " + cnipa2 + ") deve essere maggiore del valore impostato per il livello CNIPA 1 (valore: " + cnipa1 + ")."));
            return false;
        }
        if (cnipa2 != LogLevels.toIntervalloOpenSPCoop(2)) {
            log.info((Object)("Personalizzazione del livello di filtro dei messaggi diagnostici (CNIPA 2) al valore openspcoop: " + cnipa2));
        }
        if ((cnipa3 = this.getFiltroMsgDiagnostico_CNIPA3()) <= cnipa2) {
            log.error((Object)("Personalizzazione del livello di filtro dei messaggi diagnostici CNIPA 3 (valore: " + cnipa3 + ") deve essere maggiore del valore impostato per il livello CNIPA 2 (valore: " + cnipa2 + ")."));
            return false;
        }
        if (cnipa3 != LogLevels.toIntervalloOpenSPCoop(3)) {
            log.info((Object)("Personalizzazione del livello di filtro dei messaggi diagnostici (CNIPA 3) al valore openspcoop: " + cnipa3));
        }
        if ((cnipa4 = this.getFiltroMsgDiagnostico_CNIPA4()) <= cnipa3) {
            log.error((Object)("Personalizzazione del livello di filtro dei messaggi diagnostici CNIPA 4 (valore: " + cnipa4 + ") deve essere maggiore del valore impostato per il livello CNIPA 3 (valore: " + cnipa3 + ")."));
            return false;
        }
        if (cnipa4 != LogLevels.toIntervalloOpenSPCoop(4)) {
            log.info((Object)("Personalizzazione del livello di filtro dei messaggi diagnostici (CNIPA 4) al valore openspcoop: " + cnipa4));
        }
        if ((cnipa5 = this.getFiltroMsgDiagnostico_CNIPA5()) <= cnipa4) {
            log.error((Object)("Personalizzazione del livello di filtro dei messaggi diagnostici CNIPA 5 (valore: " + cnipa5 + ") deve essere maggiore del valore impostato per il livello CNIPA 4 (valore: " + cnipa4 + ")."));
            return false;
        }
        if (cnipa5 != LogLevels.toIntervalloOpenSPCoop(5)) {
            log.info((Object)("Personalizzazione del livello di filtro dei messaggi diagnostici (CNIPA 5) al valore openspcoop: " + cnipa5));
        }
        if ((cnipa6 = this.getFiltroMsgDiagnostico_CNIPA6()) <= cnipa5) {
            log.error((Object)("Personalizzazione del livello di filtro dei messaggi diagnostici CNIPA 6 (valore: " + cnipa6 + ") deve essere maggiore del valore impostato per il livello CNIPA 5 (valore: " + cnipa5 + ")."));
            return false;
        }
        if (cnipa6 != LogLevels.toIntervalloOpenSPCoop(6)) {
            log.info((Object)("Personalizzazione del livello di filtro dei messaggi diagnostici (CNIPA 6) al valore openspcoop: " + cnipa6));
        }
        if ((cnipa7 = this.getFiltroMsgDiagnostico_CNIPA7()) <= cnipa6) {
            log.error((Object)("Personalizzazione del livello di filtro dei messaggi diagnostici CNIPA 7 (valore: " + cnipa7 + ") deve essere maggiore del valore impostato per il livello CNIPA 6 (valore: " + cnipa6 + ")."));
            return false;
        }
        if (cnipa7 != LogLevels.toIntervalloOpenSPCoop(7)) {
            log.info((Object)("Personalizzazione del livello di filtro dei messaggi diagnostici (CNIPA 7) al valore openspcoop: " + cnipa7));
        }
        return true;
    }

    public synchronized boolean initializeMsgDiagnosticiPersonalizzati() {
        try {
            if (livelliMsgDiagnosticiPersonalizzati == null) {
                String key;
                livelliMsgDiagnosticiPersonalizzati = new Hashtable();
                codiciMsgDiagnosticiPersonalizzati = new Hashtable();
                messaggiMsgDiagnosticiPersonalizzati = new Hashtable();
                mappingCodiceToKeywordMsgDiagnosticiPersonalizzati = new Hashtable();
                codiciIdentificativiFunzione = new Hashtable();
                Properties msgDiagnostici = this.reader.readProperties(PREFIX_MSG_DIAGNOSTICO);
                Enumeration<Object> nomi = msgDiagnostici.keys();
                while (nomi.hasMoreElements()) {
                    key = (String)nomi.nextElement();
                    if (!key.endsWith(SUFFIX_CODICE_MODULO_MSG_DIAGNOSTICO)) continue;
                    String value = msgDiagnostici.getProperty(key);
                    String[] tmpSplit = key.split("\\.");
                    String modulo = tmpSplit[0].trim();
                    if (codiciIdentificativiFunzione.containsKey(modulo)) {
                        throw new Exception("Per Il modulo funzionale [" + modulo + "] sono stati definiti piu' codici??");
                    }
                    if (codiciIdentificativiFunzione.containsValue(value)) {
                        throw new Exception("Il codice fornito (" + modulo + "=" + value + ") e' gia' utilizzato da un altro modulo funzionale");
                    }
                    codiciIdentificativiFunzione.put(modulo, value);
                }
                msgDiagnostici = this.reader.readProperties(PREFIX_MSG_DIAGNOSTICO);
                nomi = msgDiagnostici.keys();
                while (nomi.hasMoreElements()) {
                    String valore;
                    String chiave;
                    key = (String)nomi.nextElement();
                    if (key.endsWith(SUFFIX_LIVELLO_MSG_DIAGNOSTICO)) {
                        chiave = key.substring(0, key.length() - SUFFIX_LIVELLO_MSG_DIAGNOSTICO.length());
                        valore = msgDiagnostici.getProperty(key);
                        try {
                            Integer v = Integer.parseInt(valore);
                            livelliMsgDiagnosticiPersonalizzati.put(chiave, v);
                            continue;
                        }
                        catch (Exception e) {
                            throw new Exception("Valore della proprieta' [" + key + "] non valido [" + valore + "]: " + e.getMessage());
                        }
                    }
                    if (key.endsWith(SUFFIX_CODICE_MSG_DIAGNOSTICO)) {
                        chiave = key.substring(0, key.length() - SUFFIX_CODICE_MSG_DIAGNOSTICO.length());
                        valore = msgDiagnostici.getProperty(key);
                        String[] tmp = chiave.split("\\.");
                        String moduloFunzionale = tmp[0].trim();
                        String codiceModuloFunzionale = codiciIdentificativiFunzione.get(moduloFunzionale);
                        if (codiceModuloFunzionale == null) {
                            throw new Exception("Per il modulo funzionale [" + moduloFunzionale + "] non e' stato definito il codice");
                        }
                        String codiceDefinitivo = codiceModuloFunzionale + valore;
                        if (codiciMsgDiagnosticiPersonalizzati.containsValue(codiceDefinitivo)) {
                            throw new Exception("Proprieta' " + chiave + " contiene un codice [" + valore + "] gia' definito per un altro messaggio diagnostico del modulo funzionale " + moduloFunzionale + " (" + codiceModuloFunzionale + ")");
                        }
                        codiciMsgDiagnosticiPersonalizzati.put(chiave, codiceDefinitivo);
                        mappingCodiceToKeywordMsgDiagnosticiPersonalizzati.put(codiceDefinitivo, chiave);
                        continue;
                    }
                    if (key.endsWith(SUFFIX_MESSAGGIO_MSG_DIAGNOSTICO)) {
                        chiave = key.substring(0, key.length() - SUFFIX_MESSAGGIO_MSG_DIAGNOSTICO.length());
                        valore = msgDiagnostici.getProperty(key);
                        messaggiMsgDiagnosticiPersonalizzati.put(chiave, valore);
                        continue;
                    }
                    if (key.endsWith(SUFFIX_CODICE_MODULO_MSG_DIAGNOSTICO)) continue;
                    throw new Exception("Proprieta' malformata [" + key + "]");
                }
                for (int i = 0; i < MSG_DIAGNOSTICI_PERSONALIZZATI.length; ++i) {
                    String prefix = PREFIX_MSG_DIAGNOSTICO + MSG_DIAGNOSTICI_PERSONALIZZATI[i];
                    String livello = prefix + SUFFIX_LIVELLO_MSG_DIAGNOSTICO;
                    String codice = prefix + SUFFIX_CODICE_MSG_DIAGNOSTICO;
                    String messaggio = prefix + SUFFIX_MESSAGGIO_MSG_DIAGNOSTICO;
                    if (!livelliMsgDiagnosticiPersonalizzati.containsKey(MSG_DIAGNOSTICI_PERSONALIZZATI[i])) {
                        throw new Exception("Proprieta' " + livello + " non definita");
                    }
                    if (!codiciMsgDiagnosticiPersonalizzati.containsKey(MSG_DIAGNOSTICI_PERSONALIZZATI[i])) {
                        throw new Exception("Proprieta' " + codice + " non definita");
                    }
                    if (messaggiMsgDiagnosticiPersonalizzati.containsKey(MSG_DIAGNOSTICI_PERSONALIZZATI[i])) continue;
                    throw new Exception("Proprieta' " + messaggio + " non definita");
                }
            }
            return true;
        }
        catch (Exception e) {
            this.log.error((Object)("Riscontrato errore durante la lettura dei messaggi diagnostici personalizzati: " + e.getMessage()));
            if (OpenSPCoopLogger.getLoggerOpenSPCoopCore() != null) {
                OpenSPCoopLogger.getLoggerOpenSPCoopCore().error((Object)("Riscontrato errore durante la lettura dei messaggi diagnostici personalizzati: " + e.getMessage()), (Throwable)e);
            }
            livelliMsgDiagnosticiPersonalizzati = null;
            messaggiMsgDiagnosticiPersonalizzati = null;
            return false;
        }
    }

    public int getLivello(String modulo, String keyLivelloPersonalizzato) {
        Integer livello = livelliMsgDiagnosticiPersonalizzati.get(modulo + keyLivelloPersonalizzato);
        if (livello != null) {
            return livello;
        }
        return -1;
    }

    public String getCodice(String modulo, String keyCodicePersonalizzato) {
        return codiciMsgDiagnosticiPersonalizzati.get(modulo + keyCodicePersonalizzato);
    }

    public String getMessaggio(String modulo, String keyMsgPersonalizzato) {
        return messaggiMsgDiagnosticiPersonalizzati.get(modulo + keyMsgPersonalizzato);
    }

    public String getKeyMessaggio(String codice) throws Exception {
        if (mappingCodiceToKeywordMsgDiagnosticiPersonalizzati.containsKey(codice)) {
            String keyword = mappingCodiceToKeywordMsgDiagnosticiPersonalizzati.get(codice);
            if (keyword == null) {
                throw new Exception("MsgDiagnostico con codice [" + codice + "] non registrato?");
            }
            return keyword;
        }
        throw new Exception("MsgDiagnostico con codice [" + codice + "] non registrato");
    }

    public String getModulo(String codice) throws Exception {
        Enumeration<String> moduli = codiciIdentificativiFunzione.keys();
        while (moduli.hasMoreElements()) {
            String modulo = moduli.nextElement();
            String codiceModulo = codiciIdentificativiFunzione.get(modulo);
            if (!codiceModulo.equals(codice)) continue;
            return modulo;
        }
        throw new Exception("Modulo con codice [" + codice + "] non registrato");
    }
}

