/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop.pdd.logger;

import org.apache.log4j.Level;

public class LogLevels
extends Level {
    private static final long serialVersionUID = 1L;
    public static final int COSTANTE_TRASFORMAZIONE_CNIPA_OPENSPCOOP = 10000;
    public static final int SEVERITA_OFF = Integer.MIN_VALUE;
    public static final int SEVERITA_FATAL_OPENSPCOOP = 0;
    public static final int SEVERITA_ERROR_SPCOOP = 1;
    public static final int SEVERITA_ERROR_OPENSPCOOP = 2;
    public static final int SEVERITA_INFO_SPCOOP = 3;
    public static final int SEVERITA_INFO_OPENSPCOOP = 4;
    public static final int SEVERITA_DEBUG_LOW = 5;
    public static final int SEVERITA_DEBUG_MEDIUM = 6;
    public static final int SEVERITA_DEBUG_HIGH = 7;
    public static final int SEVERITA_ALL = Integer.MAX_VALUE;
    public static final String LIVELLO_FATAL_OPENSPCOOP = "fatalOpenspcoop";
    public static final String LIVELLO_ERROR_SPCOOP = "errorSpcoop";
    public static final String LIVELLO_ERROR_OPENSPCOOP = "errorOpenspcoop";
    public static final String LIVELLO_INFO_SPCOOP = "infoSpcoop";
    public static final String LIVELLO_INFO_OPENSPCOOP = "infoOpenspcoop";
    public static final String LIVELLO_DEBUG_LOW = "debugLow";
    public static final String LIVELLO_DEBUG_MEDIUM = "debugMedium";
    public static final String LIVELLO_DEBUG_HIGH = "debugHigh";
    public static final String LIVELLO_OFF = "off";
    public static final String LIVELLO_ALL = "all";
    public static final Level LOG_LEVEL_FATAL_OPENSPCOOP = new LogLevels("fatalOpenspcoop", 50001);
    public static final Level LOG_LEVEL_ERROR_SPCOOP = new LogLevels("errorSpcoop", 40002);
    public static final Level LOG_LEVEL_ERROR_OPENSPCOOP = new LogLevels("errorOpenspcoop", 40001);
    public static final Level LOG_LEVEL_INFO_SPCOOP = new LogLevels("infoSpcoop", 20002);
    public static final Level LOG_LEVEL_INFO_OPENSPCOOP = new LogLevels("infoOpenspcoop", 20001);
    public static final Level LOG_LEVEL_DEBUG_LOW = new LogLevels("debugLow", 10003);
    public static final Level LOG_LEVEL_DEBUG_MEDIUM = new LogLevels("debugMedium", 10002);
    public static final Level LOG_LEVEL_DEBUG_HIGH = new LogLevels("debugHigh", 10001);

    public static int toIntervalloOpenSPCoop(int valore) {
        if (Integer.MIN_VALUE == valore) {
            return valore;
        }
        if (0 == valore) {
            return valore;
        }
        if (1 == valore) {
            return valore * 10000;
        }
        if (2 == valore) {
            return valore * 10000;
        }
        if (3 == valore) {
            return valore * 10000;
        }
        if (4 == valore) {
            return valore * 10000;
        }
        if (5 == valore) {
            return valore * 10000;
        }
        if (6 == valore) {
            return valore * 10000;
        }
        if (7 == valore) {
            return valore * 10000;
        }
        if (Integer.MAX_VALUE == valore) {
            return valore;
        }
        return -1;
    }

    public static int toIntervalloCNIPA(int valore) {
        int valoreCNIPA_resto = valore % 10000;
        int valoreCNIPA = valore / 10000;
        if (valoreCNIPA_resto > 0) {
            ++valoreCNIPA;
        }
        if (valoreCNIPA > 7) {
            return Integer.MAX_VALUE;
        }
        if (valoreCNIPA < 0) {
            return Integer.MIN_VALUE;
        }
        if (valoreCNIPA >= 0 && valoreCNIPA <= 7) {
            return valoreCNIPA;
        }
        return -1;
    }

    public LogLevels(String name, int value) {
        super(value, name, value);
    }

    public static Level toOpenSPCoop(int valueLivello) {
        if (valueLivello < 0 || valueLivello > 7) {
            return LOG_LEVEL_INFO_SPCOOP;
        }
        if (valueLivello == 0) {
            return LOG_LEVEL_FATAL_OPENSPCOOP;
        }
        if (valueLivello == 1) {
            return LOG_LEVEL_ERROR_SPCOOP;
        }
        if (valueLivello == 2) {
            return LOG_LEVEL_ERROR_OPENSPCOOP;
        }
        if (valueLivello == 3) {
            return LOG_LEVEL_INFO_SPCOOP;
        }
        if (valueLivello == 4) {
            return LOG_LEVEL_INFO_OPENSPCOOP;
        }
        if (valueLivello == 5) {
            return LOG_LEVEL_DEBUG_LOW;
        }
        if (valueLivello == 6) {
            return LOG_LEVEL_DEBUG_MEDIUM;
        }
        if (valueLivello == 7) {
            return LOG_LEVEL_DEBUG_HIGH;
        }
        return null;
    }

    public static Level toOpenSPCoop(String livello) {
        if (livello == null) {
            return LOG_LEVEL_INFO_SPCOOP;
        }
        if (livello.equalsIgnoreCase(LIVELLO_FATAL_OPENSPCOOP)) {
            return LOG_LEVEL_FATAL_OPENSPCOOP;
        }
        if (livello.equalsIgnoreCase(LIVELLO_ERROR_SPCOOP)) {
            return LOG_LEVEL_ERROR_SPCOOP;
        }
        if (livello.equalsIgnoreCase(LIVELLO_ERROR_OPENSPCOOP)) {
            return LOG_LEVEL_ERROR_OPENSPCOOP;
        }
        if (livello.equalsIgnoreCase(LIVELLO_INFO_SPCOOP)) {
            return LOG_LEVEL_INFO_SPCOOP;
        }
        if (livello.equalsIgnoreCase(LIVELLO_INFO_OPENSPCOOP)) {
            return LOG_LEVEL_INFO_OPENSPCOOP;
        }
        if (livello.equalsIgnoreCase(LIVELLO_DEBUG_LOW)) {
            return LOG_LEVEL_DEBUG_LOW;
        }
        if (livello.equalsIgnoreCase(LIVELLO_DEBUG_MEDIUM)) {
            return LOG_LEVEL_DEBUG_MEDIUM;
        }
        if (livello.equalsIgnoreCase(LIVELLO_DEBUG_HIGH)) {
            return LOG_LEVEL_DEBUG_HIGH;
        }
        if (livello.equalsIgnoreCase(LIVELLO_OFF)) {
            return Level.OFF;
        }
        if (livello.equalsIgnoreCase(LIVELLO_ALL)) {
            return Level.ALL;
        }
        return null;
    }

    public static int toSPCoop(String livello) {
        if (livello == null) {
            return 3;
        }
        if (livello.equalsIgnoreCase(LIVELLO_FATAL_OPENSPCOOP)) {
            return 0;
        }
        if (livello.equalsIgnoreCase(LIVELLO_ERROR_SPCOOP)) {
            return 1;
        }
        if (livello.equalsIgnoreCase(LIVELLO_ERROR_OPENSPCOOP)) {
            return 2;
        }
        if (livello.equalsIgnoreCase(LIVELLO_INFO_SPCOOP)) {
            return 3;
        }
        if (livello.equalsIgnoreCase(LIVELLO_INFO_OPENSPCOOP)) {
            return 4;
        }
        if (livello.equalsIgnoreCase(LIVELLO_DEBUG_LOW)) {
            return 5;
        }
        if (livello.equalsIgnoreCase(LIVELLO_DEBUG_MEDIUM)) {
            return 6;
        }
        if (livello.equalsIgnoreCase(LIVELLO_DEBUG_HIGH)) {
            return 7;
        }
        if (livello.equalsIgnoreCase(LIVELLO_OFF)) {
            return Integer.MIN_VALUE;
        }
        if (livello.equalsIgnoreCase(LIVELLO_ALL)) {
            return Integer.MAX_VALUE;
        }
        return Integer.MAX_VALUE;
    }

    public static String toStringValue(int valueLivello) {
        if (valueLivello == 0) {
            return LIVELLO_FATAL_OPENSPCOOP;
        }
        if (valueLivello == 1) {
            return LIVELLO_ERROR_SPCOOP;
        }
        if (valueLivello == 2) {
            return LIVELLO_ERROR_OPENSPCOOP;
        }
        if (valueLivello == 3) {
            return LIVELLO_INFO_SPCOOP;
        }
        if (valueLivello == 4) {
            return LIVELLO_INFO_OPENSPCOOP;
        }
        if (valueLivello == 5) {
            return LIVELLO_DEBUG_LOW;
        }
        if (valueLivello == 6) {
            return LIVELLO_DEBUG_MEDIUM;
        }
        if (valueLivello == 7) {
            return LIVELLO_DEBUG_HIGH;
        }
        return null;
    }
}

