/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop.pdd.logger;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import javax.activation.DataHandler;
import javax.xml.soap.SOAPException;
import javax.xml.transform.stream.StreamSource;
import org.apache.axis.Message;
import org.apache.axis.attachments.AttachmentPart;
import org.apache.log4j.Logger;
import org.openspcoop.dao.commons.IDSoggetto;
import org.openspcoop.dao.commons.TipoMessaggio;
import org.openspcoop.dao.commons.TipoPdD;
import org.openspcoop.dao.registry.driver.IDServizio;
import org.openspcoop.pdd.config.MailcapActivationReader;
import org.openspcoop.pdd.config.OpenSPCoopProperties;
import org.openspcoop.pdd.core.CostantiPdD;
import org.openspcoop.pdd.core.PdDContext;
import org.openspcoop.pdd.core.connettori.InfoConnettoreIngresso;
import org.openspcoop.pdd.core.connettori.InfoConnettoreUscita;
import org.openspcoop.pdd.logger.IDumpOpenSPCoopAppender;
import org.openspcoop.pdd.logger.MsgDiagnostico;
import org.openspcoop.pdd.logger.OpenSPCoopLogger;
import org.openspcoop.pdd.logger.TracciamentoException;
import org.openspcoop.pdd.logger.dto.Messaggio;
import org.openspcoop.utils.AttachmentsUtils;
import org.openspcoop.utils.date.DateManager;

public class Dump {
    public static boolean sistemaDumpDisponibile = true;
    public static Exception motivoMalfunzionamentoDump = null;
    private Logger loggerDump = null;
    private String dominioSPCoop;
    private String idModulo;
    private String idEGov;
    private IDSoggetto fruitore;
    private IDServizio servizio;
    private String signature;
    private Date gdo;
    private TipoPdD tipoPdD;
    private PdDContext pddContext;
    private OpenSPCoopProperties properties = null;
    private MsgDiagnostico msgDiagErroreDump = null;
    private Vector<IDumpOpenSPCoopAppender> loggerDumpOpenSPCoopAppender = null;
    private Vector<String> tipoDumpOpenSPCoopAppender = null;

    public Dump(String dominio, String modulo, TipoPdD tipoPdD, PdDContext pddContext) {
        this(dominio, modulo, null, null, null, tipoPdD, pddContext);
    }

    public Dump(String dominio, String modulo, String idEGov, IDSoggetto fruitore, IDServizio servizio, TipoPdD tipoPdD, PdDContext pddContext) {
        this.dominioSPCoop = dominio;
        this.idModulo = modulo;
        this.idEGov = idEGov;
        this.fruitore = fruitore;
        this.servizio = servizio;
        this.loggerDump = OpenSPCoopLogger.loggerDump;
        this.loggerDumpOpenSPCoopAppender = OpenSPCoopLogger.loggerDumpOpenSPCoopAppender;
        this.tipoDumpOpenSPCoopAppender = OpenSPCoopLogger.tipoDumpOpenSPCoopAppender;
        this.gdo = DateManager.getDate();
        this.signature = this.dominioSPCoop != null ? this.dominioSPCoop + " <" + this.gdo + "> " + this.idModulo + "\n" : "<" + this.gdo + "> " + this.idModulo + "\n";
        this.tipoPdD = tipoPdD;
        this.pddContext = pddContext;
        this.properties = OpenSPCoopProperties.getInstance();
        this.msgDiagErroreDump = new MsgDiagnostico(dominio, modulo);
        this.msgDiagErroreDump.setPrefixMsgPersonalizzati("tracciamento.");
        this.msgDiagErroreDump.setPddContext(pddContext);
    }

    @Deprecated
    public void dumpRichiestaMessage(byte[] msg) throws TracciamentoException {
        try {
            this.loggerDump.info((Object)(this.signature + "Messaggio di richiesta con identificativo [" + this.idEGov + "]:\n" + new String(msg)));
        }
        catch (Exception e) {
            this.loggerDump.error((Object)("Riscontrato errore durante il dump del messaggio con identificativo [" + this.idEGov + "]:" + e));
            this.gestioneErroreDump(e);
        }
    }

    @Deprecated
    public void dumpRichiestaMessage(Message msg) throws TracciamentoException {
        try {
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            msg.writeTo((OutputStream)stream);
            this.loggerDump.info((Object)(this.signature + "Messaggio di richiesta con identificativo [" + this.idEGov + "]:\n" + stream.toString()));
        }
        catch (Exception e) {
            this.loggerDump.error((Object)("Riscontrato errore durante il dump del messaggio con identificativo [" + this.idEGov + "]:" + e));
            this.gestioneErroreDump(e);
        }
    }

    public void dumpRichiestaIngresso(byte[] msg, InfoConnettoreIngresso infoConnettore) throws TracciamentoException {
        this.dump(TipoMessaggio.RICHIESTA_INGRESSO, null, msg, infoConnettore.getFromLocation(), infoConnettore.getParametersTrasporto());
    }

    public void dumpRichiestaIngresso(Message msg, InfoConnettoreIngresso infoConnettore) throws TracciamentoException {
        this.dump(TipoMessaggio.RICHIESTA_INGRESSO, msg, null, infoConnettore.getFromLocation(), infoConnettore.getParametersTrasporto());
    }

    public void dumpRichiestaUscita(byte[] msg, InfoConnettoreUscita infoConnettore) throws TracciamentoException {
        this.dump(TipoMessaggio.RICHIESTA_USCITA, null, msg, infoConnettore.getLocation(), infoConnettore.getPropertiesTrasporto());
    }

    public void dumpRichiestaUscita(Message msg, InfoConnettoreUscita infoConnettore) throws TracciamentoException {
        this.dump(TipoMessaggio.RICHIESTA_USCITA, msg, null, infoConnettore.getLocation(), infoConnettore.getPropertiesTrasporto());
    }

    @Deprecated
    public void dumpRispostaMessage(byte[] msg) {
        try {
            this.loggerDump.info((Object)(this.signature + "Messaggio di risposta relativa alla richiesta con identificativo [" + this.idEGov + "]:\n" + new String(msg)));
        }
        catch (Exception e) {
            this.loggerDump.error((Object)("Riscontrato errore durante il dump del messaggio con identificativo [" + this.idEGov + "]:" + e));
        }
    }

    @Deprecated
    public void dumpRispostaMessage(Message msg) {
        try {
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            msg.writeTo((OutputStream)stream);
            this.loggerDump.info((Object)(this.signature + "Messaggio di risposta relativa alla richiesta con identificativo [" + this.idEGov + "]:\n" + stream.toString()));
        }
        catch (Exception e) {
            this.loggerDump.error((Object)("Riscontrato errore durante il dump del messaggio con identificativo [" + this.idEGov + "]:" + e));
        }
    }

    public void dumpRispostaIngresso(byte[] msg, InfoConnettoreUscita infoConnettore, Properties transportHeaderRisposta) throws TracciamentoException {
        this.dump(TipoMessaggio.RISPOSTA_INGRESSO, null, msg, infoConnettore.getLocation(), transportHeaderRisposta);
    }

    public void dumpRispostaIngresso(Message msg, InfoConnettoreUscita infoConnettore, Properties transportHeaderRisposta) throws TracciamentoException {
        this.dump(TipoMessaggio.RISPOSTA_INGRESSO, msg, null, infoConnettore.getLocation(), transportHeaderRisposta);
    }

    public void dumpRispostaUscita(byte[] msg, InfoConnettoreIngresso infoConnettore, Properties transportHeaderRisposta) throws TracciamentoException {
        this.dump(TipoMessaggio.RISPOSTA_USCITA, null, msg, infoConnettore.getFromLocation(), transportHeaderRisposta);
    }

    public void dumpRispostaUscita(Message msg, InfoConnettoreIngresso infoConnettore, Properties transportHeaderRisposta) throws TracciamentoException {
        this.dump(TipoMessaggio.RISPOSTA_USCITA, msg, null, infoConnettore.getFromLocation(), transportHeaderRisposta);
    }

    public void dumpIntegrationManagerGetMessage(Message msg) throws TracciamentoException {
        this.dump(TipoMessaggio.INTEGRATION_MANAGER, msg, null, null, null);
    }

    private void dump(TipoMessaggio tipoMessaggio, Message msg, byte[] msgBytes, String location, Properties transportHeader) throws TracciamentoException {
        Object o;
        Object key;
        if (OpenSPCoopLogger.loggerDumpAbilitato) {
            try {
                StringBuffer out = new StringBuffer();
                out.append(this.signature);
                out.append("TipoMessaggio:" + tipoMessaggio.getTipo());
                if (this.idEGov != null) {
                    out.append(" idEGov:");
                    out.append(this.idEGov);
                }
                if (location != null) {
                    if (TipoMessaggio.RICHIESTA_INGRESSO.equals(tipoMessaggio) || TipoMessaggio.RISPOSTA_USCITA.equals(tipoMessaggio)) {
                        out.append(" source:");
                    } else {
                        out.append(" location:");
                    }
                    out.append(location);
                }
                if (this.fruitore != null) {
                    out.append(" FR:");
                    out.append(this.fruitore.toString());
                }
                if (this.fruitore != null && this.servizio != null) {
                    out.append(" -> ");
                }
                if (this.servizio != null) {
                    if (this.servizio.getServizio() != null && this.servizio.getTipoServizio() != null && this.servizio.getSoggettoErogatore() != null) {
                        out.append(" S:");
                        out.append(this.servizio.toString());
                    } else if (this.servizio.getSoggettoErogatore() != null) {
                        out.append(" ER:");
                        out.append(this.servizio.getSoggettoErogatore().toString());
                    }
                }
                out.append(" \n");
                if (transportHeader != null && transportHeader.size() > 0) {
                    Enumeration<Object> keys = transportHeader.keys();
                    out.append("------ Header di trasporto ------\n");
                    while (keys.hasMoreElements()) {
                        key = (String)keys.nextElement();
                        String value = transportHeader.getProperty((String)key);
                        if (value instanceof String) {
                            out.append((String)key + "=" + value + "\n");
                            continue;
                        }
                        out.append((String)key + "=ObjectType(" + value.getClass().getName() + ")\n");
                    }
                }
                if (msg != null) {
                    out.append("------ SOAPEnvelope ------\n");
                    out.append(msg.getSOAPEnvelope().getAsString());
                    Collection c = msg.getAttachmentsImpl().getAttachments();
                    for (AttachmentPart ap : c) {
                        if (ap.getContentId() != null) {
                            out.append("\n------ Attachment id[" + ap.getContentId() + "]------");
                        } else if (ap.getContentLocation() != null) {
                            out.append("\n------ Attachment location[" + ap.getContentLocation() + "]------");
                        }
                        out.append("\nId[" + ap.getContentId() + "] location[" + ap.getContentLocation() + "] type[" + ap.getContentType() + "]: ");
                        if (this.properties.isDumpAllAttachments()) {
                            out.append(this.dumpAttachment(ap));
                            continue;
                        }
                        o = ap.getDataHandler().getContent();
                        if ("application/openspcoop".equals(ap.getContentType())) {
                            this.rebuildAttachmentAsByteArray(ap);
                        }
                        if (o instanceof String) {
                            out.append((String)o);
                            continue;
                        }
                        out.append("Contenuto attachments non \u00e8 visualizzabile, tipo: " + o.getClass().getName());
                    }
                } else {
                    if (AttachmentsUtils.messageWithAttachment((byte[])msgBytes)) {
                        out.append("------ SOAPWithAttachments ------\n");
                    } else {
                        out.append("------ SOAPEnvelope ------\n");
                    }
                    out.append(new String(msgBytes));
                }
                this.loggerDump.info((Object)out.toString());
            }
            catch (Exception e) {
                try {
                    this.loggerDump.error((Object)("Riscontrato errore durante il dump del contenuto applicativo presente nel messaggio (" + tipoMessaggio.getTipo() + ") con identificativo [" + this.idEGov + "]:" + e.getMessage()));
                }
                catch (Exception eLog) {
                    // empty catch block
                }
                OpenSPCoopLogger.loggerOpenSPCoopResources.error((Object)("Errore durante il dump del contenuto applicativo presente nel messaggio (" + tipoMessaggio.getTipo() + ") con identificativo [" + this.idEGov + "]: " + e.getMessage()), (Throwable)e);
                try {
                    this.msgDiagErroreDump.addKeyword("@TIPO_TRACCIA@", tipoMessaggio.getTipo());
                    this.msgDiagErroreDump.addKeyword("@ERRORE_TRACCIAMENTO@", e.getMessage());
                    this.msgDiagErroreDump.logPersonalizzato("dumpContenutiApplicativi.registrazioneNonRiuscita");
                }
                catch (Exception eMsg) {
                    // empty catch block
                }
                this.gestioneErroreDump(e);
            }
        }
        for (int i = 0; i < this.loggerDumpOpenSPCoopAppender.size(); ++i) {
            try {
                Messaggio messaggioDump = new Messaggio();
                messaggioDump.setGdo(this.gdo);
                messaggioDump.setIdEGov(this.idEGov);
                messaggioDump.setIdPorta(this.dominioSPCoop);
                messaggioDump.setIdFunzione(this.idModulo);
                messaggioDump.setFruitore(this.fruitore);
                messaggioDump.setServizio(this.servizio);
                messaggioDump.setMsg(msg);
                messaggioDump.setLocation(location);
                messaggioDump.setTransportHeader(transportHeader);
                messaggioDump.setTipoPdD(this.tipoPdD);
                messaggioDump.setTipoMessaggio(tipoMessaggio);
                if (this.pddContext != null && (key = CostantiPdD.CONTEXT_OBJECT) != null) {
                    for (int j = 0; j < ((String[])key).length; ++j) {
                        o = this.pddContext.getObject(key[j]);
                        if (o == null || !(o instanceof String)) continue;
                        messaggioDump.addProperty(key[j], (String)o);
                    }
                }
                this.loggerDumpOpenSPCoopAppender.get(i).dump(messaggioDump);
                continue;
            }
            catch (Exception e) {
                OpenSPCoopLogger.loggerOpenSPCoopResources.error((Object)("Errore durante il dump personalizzato [" + this.tipoDumpOpenSPCoopAppender.get(i) + "] del contenuto applicativo presente nel messaggio (" + tipoMessaggio.getTipo() + ") con identificativo [" + this.idEGov + "]: " + e.getMessage()), (Throwable)e);
                try {
                    this.msgDiagErroreDump.addKeyword("@TIPO_TRACCIA@", tipoMessaggio.getTipo());
                    this.msgDiagErroreDump.addKeyword("@ERRORE_TRACCIAMENTO@", e.getMessage());
                    this.msgDiagErroreDump.addKeyword("@TIPO_TRACCIAMENTO_PERSONALIZZATO@", this.tipoDumpOpenSPCoopAppender.get(i));
                    this.msgDiagErroreDump.logPersonalizzato("dumpContenutiApplicativi.registrazioneNonRiuscita.openspcoopAppender");
                }
                catch (Exception eMsg) {
                    // empty catch block
                }
                this.gestioneErroreDump(e);
            }
        }
    }

    private String dumpAttachment(AttachmentPart ap) throws SOAPException, IOException {
        DataHandler dh = ap.getDataHandler();
        InputStream inputDH = dh.getInputStream();
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        byte[] readB = new byte[8192];
        int readByte = 0;
        while ((readByte = inputDH.read(readB)) != -1) {
            bout.write(readB, 0, readByte);
        }
        inputDH.close();
        bout.flush();
        bout.close();
        if (MailcapActivationReader.existsDataContentHandler(ap.getContentType())) {
            ap.setDataHandler(new DataHandler((Object)bout.toByteArray(), ap.getContentType()));
        }
        return bout.toString();
    }

    private void rebuildAttachmentAsByteArray(AttachmentPart ap) throws SOAPException, IOException {
        DataHandler dh = ap.getDataHandler();
        InputStream inputDH = dh.getInputStream();
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        byte[] readB = new byte[8192];
        int readByte = 0;
        while ((readByte = inputDH.read(readB)) != -1) {
            bout.write(readB, 0, readByte);
        }
        inputDH.close();
        bout.flush();
        bout.close();
        ap.setDataHandler(new DataHandler((Object)bout.toByteArray(), ap.getContentType()));
    }

    protected String dumpContenutoXML(StreamSource xml) throws SOAPException, IOException {
        InputStream inputXML = xml.getInputStream();
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        byte[] readB = new byte[8192];
        int readByte = 0;
        while ((readByte = inputXML.read(readB)) != -1) {
            bout.write(readB, 0, readByte);
        }
        inputXML.close();
        bout.flush();
        bout.close();
        xml.setInputStream(new ByteArrayInputStream(bout.toByteArray()));
        return bout.toString();
    }

    private void gestioneErroreDump(Exception e) throws TracciamentoException {
        if (this.properties.isDumpFallito_BloccoServiziPdD()) {
            sistemaDumpDisponibile = false;
            motivoMalfunzionamentoDump = e;
            try {
                this.msgDiagErroreDump.logPersonalizzato("dumpContenutiApplicativi.errore.bloccoServizi");
            }
            catch (Exception exception) {
                // empty catch block
            }
            OpenSPCoopLogger.loggerOpenSPCoopResources.error((Object)"Il Sistema di dump dei contenuti applicativi ha rilevato un errore durante la registrazione di un contenuto applicativo, tutti i servizi/moduli della porta di dominio sono sospesi. Si richiede un intervento sistemistico per la risoluzione del problema e il riavvio della Porta di Dominio. Errore rilevato: ", (Throwable)e);
        }
        if (this.properties.isDumpFallito_BloccaCooperazioneInCorso()) {
            throw new TracciamentoException(e);
        }
    }
}

