/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop.pdd.logger;

import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import javax.sql.DataSource;
import org.apache.log4j.Logger;
import org.openspcoop.egov.Busta;
import org.openspcoop.egov.Eccezione;
import org.openspcoop.egov.Riscontro;
import org.openspcoop.egov.Trasmissione;
import org.openspcoop.pdd.logger.DriverMSGDiagnosticiException;
import org.openspcoop.pdd.logger.DriverTracciamentoException;
import org.openspcoop.pdd.logger.DriverTracciamentoNotFoundException;
import org.openspcoop.pdd.logger.IDriverTracciamento;
import org.openspcoop.pdd.logger.dto.FiltroRicercaTracce;
import org.openspcoop.pdd.logger.dto.Traccia;
import org.openspcoop.utils.GestoreJNDI;
import org.openspcoop.utils.sql.ISQLQueryObject;
import org.openspcoop.utils.sql.SQLObjectFactory;
import org.openspcoop.utils.sql.SQLQueryObjectException;
import org.openspcoop.utils.sql.TipiDatabase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DriverTracciamento
implements IDriverTracciamento {
    DataSource datasource = null;
    Connection connection = null;
    String tipoDatabase = null;
    private Logger log = null;
    private Vector<String> properties;

    public void setProperties(Vector<String> properties) {
        this.properties = properties;
    }

    public DriverTracciamento(String nomeDataSource, String tipoDatabase, Properties prop) throws DriverMSGDiagnosticiException {
        this(nomeDataSource, tipoDatabase, prop, null);
    }

    public DriverTracciamento(String nomeDataSource, String tipoDatabase, Properties prop, Logger log) throws DriverMSGDiagnosticiException {
        try {
            this.log = log == null ? Logger.getLogger((String)"DRIVER_DB_LOGANALIZER") : log;
        }
        catch (Exception e) {
            throw new DriverMSGDiagnosticiException("Errore durante l'inizializzazione del logger...", e);
        }
        try {
            this.log.info((Object)"Inizializzo DriverLogAnalyzer...");
            GestoreJNDI gestoreJNDI = new GestoreJNDI(prop);
            this.datasource = (DataSource)gestoreJNDI.lookup(nomeDataSource);
            if (this.datasource == null) {
                throw new Exception("datasource is null");
            }
            this.log.info((Object)"Inizializzo DriverLogAnalyzer terminata.");
        }
        catch (Exception e) {
            this.log.error((Object)"Errore durante la ricerca del datasource...", (Throwable)e);
            throw new DriverMSGDiagnosticiException("Errore durante la ricerca del datasource...", e);
        }
        try {
            this.log.info((Object)"Inizializzo ISQLQueryObject...");
            if (!(TipiDatabase.POSTGRESQL.equals(tipoDatabase) || TipiDatabase.MYSQL.equals(tipoDatabase) || TipiDatabase.ORACLE.equals(tipoDatabase))) {
                throw new Exception("Tipo database non gestito");
            }
            this.tipoDatabase = tipoDatabase;
            this.log.info((Object)"Inizializzo ISQLQueryObject terminata.");
        }
        catch (Exception e) {
            this.log.error((Object)"Errore durante la ricerca del SQLQueryObject...", (Throwable)e);
            throw new DriverMSGDiagnosticiException("Errore durante la ricerca del SQLQueryObject...", e);
        }
    }

    public DriverTracciamento(Connection connection, String tipoDatabase, Logger log) throws DriverMSGDiagnosticiException {
        try {
            this.log = log;
        }
        catch (Exception e) {
            throw new DriverMSGDiagnosticiException("Errore durante l'inizializzazione del logger...", e);
        }
        this.connection = connection;
        try {
            this.log.info((Object)"Inizializzo ISQLQueryObject...");
            if (!(TipiDatabase.POSTGRESQL.equals(tipoDatabase) || TipiDatabase.MYSQL.equals(tipoDatabase) || TipiDatabase.ORACLE.equals(tipoDatabase))) {
                throw new Exception("Tipo database non gestito");
            }
            this.tipoDatabase = tipoDatabase;
            this.log.info((Object)"Inizializzo ISQLQueryObject terminata.");
        }
        catch (Exception e) {
            this.log.error((Object)"Errore durante la ricerca del SQLQueryObject...", (Throwable)e);
            throw new DriverMSGDiagnosticiException("Errore durante la ricerca del SQLQueryObject...", e);
        }
    }

    public ISQLQueryObject getSQLQueryObject() throws SQLQueryObjectException {
        ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDatabase);
        return sqlQueryObject;
    }

    @Override
    public Traccia getTraccia(String idEGov, String identificativoPorta) throws DriverTracciamentoException, DriverTracciamentoNotFoundException, SQLQueryObjectException {
        return this.getTraccia(idEGov, identificativoPorta, false);
    }

    @Override
    public Traccia getTracciaPerRiferimentoMessaggio(String riferimentoMessaggio, String identificativoPorta) throws DriverTracciamentoException, DriverTracciamentoNotFoundException, SQLQueryObjectException {
        return this.getTraccia(riferimentoMessaggio, identificativoPorta, true);
    }

    /*
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    private Traccia getTraccia(String idEGov, String identificativoPorta, boolean rifMsg) throws DriverTracciamentoException, DriverTracciamentoNotFoundException, SQLQueryObjectException {
        Connection connectionDB = null;
        Statement pstmt = null;
        ResultSet rs = null;
        Traccia tr = null;
        if (this.connection != null) {
            connectionDB = this.connection;
        } else {
            connectionDB = this.datasource.getConnection();
            if (connectionDB == null) {
                throw new Exception("Connection non ottenuta dal datasource[" + this.datasource + "]");
            }
        }
        ISQLQueryObject sqlQueryObject = this.getSQLQueryObject();
        sqlQueryObject.addFromTable("tracce");
        sqlQueryObject.addSelectField("id");
        if (rifMsg) {
            sqlQueryObject.addWhereCondition("rif_messaggio=?");
        } else {
            sqlQueryObject.addWhereCondition("id_egov=?");
        }
        sqlQueryObject.addWhereCondition("idporta=?");
        sqlQueryObject.setANDLogicOperator(true);
        pstmt = connectionDB.prepareStatement(sqlQueryObject.toString());
        pstmt.setString(1, idEGov);
        pstmt.setString(2, identificativoPorta);
        rs = pstmt.executeQuery();
        if (rs.next()) {
            Long id = rs.getLong("id");
            tr = this.getTraccia(id, connectionDB);
        }
        rs.close();
        pstmt.close();
        if (tr == null) {
            throw new DriverTracciamentoNotFoundException("Traccia non trovata (idegov:" + idEGov + ") (idporta:" + identificativoPorta + ") (rifmsg:" + rifMsg + ")");
        }
        Traccia traccia = tr;
        Object var11_12 = null;
        try {
            rs.close();
        }
        catch (Exception eClose) {
            // empty catch block
        }
        try {
            pstmt.close();
        }
        catch (Exception eClose) {
            // empty catch block
        }
        try {
            if (this.connection == null) {
                connectionDB.close();
            }
        }
        catch (Exception eClose) {
            // empty catch block
        }
        {
            return traccia;
            catch (DriverTracciamentoNotFoundException d) {
                throw d;
            }
            catch (Exception e) {
                throw new DriverTracciamentoException("Tracciamento exception: " + e.getMessage(), e);
            }
        }
        catch (Throwable throwable) {
            Object var11_13 = null;
            try {
                rs.close();
            }
            catch (Exception eClose) {
                // empty catch block
            }
            try {
                pstmt.close();
            }
            catch (Exception eClose) {
                // empty catch block
            }
            try {
                if (this.connection == null) {
                    connectionDB.close();
                }
            }
            catch (Exception eClose) {}
            throw throwable;
        }
    }

    @Override
    public Traccia getTracciaRichiestaByProperties(Hashtable<String, String> propertiesRicerca) throws DriverTracciamentoException, DriverTracciamentoNotFoundException, SQLQueryObjectException {
        return this.getTracciaByProperties(propertiesRicerca, true);
    }

    @Override
    public Traccia getTracciaRispostaByProperties(Hashtable<String, String> propertiesRicerca) throws DriverTracciamentoException, DriverTracciamentoNotFoundException, SQLQueryObjectException {
        return this.getTracciaByProperties(propertiesRicerca, false);
    }

    /*
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    private Traccia getTracciaByProperties(Hashtable<String, String> propertiesRicerca, boolean richiesta) throws DriverTracciamentoException, DriverTracciamentoNotFoundException, SQLQueryObjectException {
        Connection connectionDB = null;
        Statement pstmt = null;
        ResultSet rs = null;
        Traccia tr = null;
        String tipoTraccia = "Richiesta";
        if (!richiesta) {
            tipoTraccia = "Risposta";
        }
        if (this.connection != null) {
            connectionDB = this.connection;
        } else {
            connectionDB = this.datasource.getConnection();
            if (connectionDB == null) {
                throw new Exception("Connection non ottenuta dal datasource[" + this.datasource + "]");
            }
        }
        ISQLQueryObject sqlQueryObject = this.getSQLQueryObject();
        sqlQueryObject.addFromTable("tracce");
        sqlQueryObject.addSelectField("id");
        if (propertiesRicerca != null && propertiesRicerca.size() > 0) {
            Enumeration<String> keys = propertiesRicerca.keys();
            while (keys.hasMoreElements()) {
                sqlQueryObject.addWhereCondition(keys.nextElement() + "=?");
            }
        } else {
            throw new Exception("Properties di ricerca non fornite");
        }
        sqlQueryObject.addWhereCondition("tipo_messaggio=?");
        sqlQueryObject.setANDLogicOperator(true);
        pstmt = connectionDB.prepareStatement(sqlQueryObject.toString());
        int index = 1;
        Enumeration<String> keys = propertiesRicerca.keys();
        while (keys.hasMoreElements()) {
            String value = propertiesRicerca.get(keys.nextElement());
            pstmt.setString(index, value);
            ++index;
        }
        pstmt.setString(index, tipoTraccia);
        rs = pstmt.executeQuery();
        if (rs.next()) {
            Long id = rs.getLong("id");
            tr = this.getTraccia(id, connectionDB);
        }
        rs.close();
        pstmt.close();
        if (tr == null) {
            throw new DriverTracciamentoNotFoundException("Traccia non trovata (sizeProperties:" + propertiesRicerca.size() + ") (tipo:" + tipoTraccia + ")");
        }
        Traccia traccia = tr;
        Object var13_15 = null;
        try {
            rs.close();
        }
        catch (Exception eClose) {
            // empty catch block
        }
        try {
            pstmt.close();
        }
        catch (Exception eClose) {
            // empty catch block
        }
        try {
            if (this.connection == null) {
                connectionDB.close();
            }
        }
        catch (Exception eClose) {
            // empty catch block
        }
        {
            return traccia;
            catch (DriverTracciamentoNotFoundException d) {
                throw d;
            }
            catch (Exception e) {
                throw new DriverTracciamentoException("Tracciamento exception: " + e.getMessage(), e);
            }
        }
        catch (Throwable throwable) {
            Object var13_16 = null;
            try {
                rs.close();
            }
            catch (Exception eClose) {
                // empty catch block
            }
            try {
                pstmt.close();
            }
            catch (Exception eClose) {
                // empty catch block
            }
            try {
                if (this.connection == null) {
                    connectionDB.close();
                }
            }
            catch (Exception eClose) {}
            throw throwable;
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    private Traccia getTraccia(Long id, Connection con) throws DriverTracciamentoException, DriverTracciamentoNotFoundException, SQLQueryObjectException {
        Statement pstmt = null;
        ResultSet rs = null;
        Statement pstmtLista = null;
        ResultSet rsLista = null;
        Traccia tr = null;
        ISQLQueryObject sqlQueryObject = this.getSQLQueryObject();
        sqlQueryObject.addFromTable("tracce");
        sqlQueryObject.addSelectField("*");
        sqlQueryObject.addWhereCondition("id=?");
        pstmt = con.prepareStatement(sqlQueryObject.toString());
        pstmt.setLong(1, id);
        rs = pstmt.executeQuery();
        if (rs.next()) {
            tr = new Traccia();
            tr.setGdo(rs.getTimestamp("gdo"));
            tr.setIdporta(rs.getString("idporta"));
            tr.setTipoMessaggio(rs.getString("tipo_messaggio"));
            tr.setCorrelazioneApplicativa(rs.getString("correlazione_applicativa"));
            tr.setServizioApplicativoFruitore(rs.getString("sa_fruitore"));
            tr.setLocation(rs.getString("location"));
            if (this.properties != null) {
                for (int i = 0; i < this.properties.size(); ++i) {
                    String key = this.properties.get(i);
                    tr.addProperty(key, rs.getString(key));
                }
            }
            Busta busta = new Busta();
            if (rs.getString("tipo_mittente") != null && !"".equals(rs.getString("tipo_mittente"))) {
                busta.setTipoMittente(rs.getString("tipo_mittente"));
            }
            if (rs.getString("mittente") != null && !"".equals(rs.getString("mittente"))) {
                busta.setMittente(rs.getString("mittente"));
            }
            if (rs.getString("indtelematico_mitt") != null && !"".equals(rs.getString("indtelematico_mitt"))) {
                busta.setIndirizzoTelematicoMittente(rs.getString("indtelematico_mitt"));
            }
            if (rs.getString("tipo_destinatario") != null && !"".equals(rs.getString("tipo_destinatario"))) {
                busta.setTipoDestinatario(rs.getString("tipo_destinatario"));
            }
            if (rs.getString("destinatario") != null && !"".equals(rs.getString("destinatario"))) {
                busta.setDestinatario(rs.getString("destinatario"));
            }
            if (rs.getString("indtelematico_dest") != null && !"".equals(rs.getString("indtelematico_dest"))) {
                busta.setIndirizzoTelematicoDestinatario(rs.getString("indtelematico_dest"));
            }
            if (rs.getString("profilo_collaborazione") != null && !"".equals(rs.getString("profilo_collaborazione"))) {
                busta.setProfiloDiCollaborazione(rs.getString("profilo_collaborazione"));
            }
            if (rs.getString("servizio_correlato") != null && !"".equals(rs.getString("servizio_correlato"))) {
                busta.setServizioCorrelato(rs.getString("servizio_correlato"));
            }
            if (rs.getString("tipo_servizio_correlato") != null && !"".equals(rs.getString("tipo_servizio_correlato"))) {
                busta.setTipoServizioCorrelato(rs.getString("tipo_servizio_correlato"));
            }
            if (rs.getString("collaborazione") != null && !"".equals(rs.getString("collaborazione"))) {
                busta.setCollaborazione(rs.getString("collaborazione"));
            }
            if (rs.getString("servizio") != null && !"".equals(rs.getString("servizio"))) {
                busta.setServizio(rs.getString("servizio"));
            }
            if (rs.getString("tipo_servizio") != null && !"".equals(rs.getString("tipo_servizio"))) {
                busta.setTipoServizio(rs.getString("tipo_servizio"));
            }
            if (rs.getString("azione") != null && !"".equals(rs.getString("azione"))) {
                busta.setAzione(rs.getString("azione"));
            }
            if (rs.getString("id_egov") != null && !"".equals(rs.getString("id_egov"))) {
                busta.setID(rs.getString("id_egov"));
            }
            if (rs.getTimestamp("ora_registrazione") != null) {
                busta.setOraRegistrazione((java.util.Date)rs.getTimestamp("ora_registrazione"));
            }
            if (rs.getString("tipo_ora_reg") != null && !"".equals(rs.getString("tipo_ora_reg"))) {
                busta.setTipoOraRegistrazione(rs.getString("tipo_ora_reg"));
            }
            if (rs.getString("rif_messaggio") != null && !"".equals(rs.getString("rif_messaggio"))) {
                busta.setRiferimentoMessaggio(rs.getString("rif_messaggio"));
            }
            if (rs.getTimestamp("scadenza") != null) {
                busta.setScadenza((java.util.Date)rs.getTimestamp("scadenza"));
            }
            if (rs.getString("inoltro") != null && !"".equals(rs.getString("inoltro"))) {
                busta.setInoltro(rs.getString("inoltro"));
            }
            if (rs.getInt("conferma_ricezione") == 1) {
                busta.setConfermaRicezione(true);
            } else {
                busta.setConfermaRicezione(false);
            }
            if (rs.getLong("sequenza") > 0L) {
                busta.setSequenza(rs.getLong("sequenza"));
            }
            long idTraccia = rs.getLong("id");
            sqlQueryObject = this.getSQLQueryObject();
            sqlQueryObject.addFromTable("tracce_trasmissioni");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("idtraccia=?");
            sqlQueryObject.setANDLogicOperator(true);
            pstmtLista = con.prepareStatement(sqlQueryObject.toString());
            pstmtLista.setLong(1, idTraccia);
            rsLista = pstmtLista.executeQuery();
            while (rsLista.next()) {
                Trasmissione trtr = new Trasmissione();
                if (rsLista.getString("origine") != null && !"".equals(rsLista.getString("origine"))) {
                    trtr.setOrigine(rsLista.getString("origine"));
                }
                if (rsLista.getString("tipo_origine") != null && !"".equals(rsLista.getString("tipo_origine"))) {
                    trtr.setTipoOrigine(rsLista.getString("tipo_origine"));
                }
                if (rsLista.getString("indtelematico_orig") != null && !"".equals(rsLista.getString("indtelematico_orig"))) {
                    trtr.setIndirizzoTelematicoOrigine(rsLista.getString("indtelematico_orig"));
                }
                if (rsLista.getString("destinazione") != null && !"".equals(rsLista.getString("destinazione"))) {
                    trtr.setDestinazione(rsLista.getString("destinazione"));
                }
                if (rsLista.getString("tipo_destinazione") != null && !"".equals(rsLista.getString("tipo_destinazione"))) {
                    trtr.setTipoDestinazione(rsLista.getString("tipo_destinazione"));
                }
                if (rsLista.getString("indtel_destinazione") != null && !"".equals(rsLista.getString("indtel_destinazione"))) {
                    trtr.setIndirizzoTelematicoDestinazione(rsLista.getString("indtel_destinazione"));
                }
                if (rsLista.getTimestamp("ora_registrazione") != null) {
                    trtr.setOraRegistrazione((java.util.Date)rsLista.getTimestamp("ora_registrazione"));
                }
                if (rsLista.getString("tipo_ora_registrazione") != null && !"".equals(rsLista.getString("tipo_ora_registrazione"))) {
                    trtr.setTempo(rsLista.getString("tipo_ora_registrazione"));
                }
                busta.addTrasmissione(trtr);
            }
            rsLista.close();
            pstmtLista.close();
            sqlQueryObject = this.getSQLQueryObject();
            sqlQueryObject.addFromTable("tracce_eccezioni");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("idtraccia=?");
            sqlQueryObject.setANDLogicOperator(true);
            pstmtLista = con.prepareStatement(sqlQueryObject.toString());
            pstmtLista.setLong(1, idTraccia);
            rsLista = pstmtLista.executeQuery();
            while (rsLista.next()) {
                Eccezione trec = new Eccezione();
                if (rsLista.getString("contesto_codifica") != null && !"".equals(rsLista.getString("contesto_codifica"))) {
                    trec.setContestoCodifica(rsLista.getString("contesto_codifica"));
                }
                if (rsLista.getString("codice_eccezione") != null && !"".equals(rsLista.getString("codice_eccezione"))) {
                    trec.setCodiceEccezione(rsLista.getString("codice_eccezione"));
                }
                if (rsLista.getString("rilevanza") != null && !"".equals(rsLista.getString("rilevanza"))) {
                    trec.setRilevanza(rsLista.getString("rilevanza"));
                }
                if (rsLista.getString("posizione") != null && !"".equals(rsLista.getString("posizione"))) {
                    trec.setPosizione(rsLista.getString("posizione"));
                }
                busta.addEccezione(trec);
            }
            rsLista.close();
            pstmtLista.close();
            sqlQueryObject = this.getSQLQueryObject();
            sqlQueryObject.addFromTable("tracce_riscontri");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("idtraccia=?");
            sqlQueryObject.setANDLogicOperator(true);
            pstmtLista = con.prepareStatement(sqlQueryObject.toString());
            pstmtLista.setLong(1, idTraccia);
            rsLista = pstmtLista.executeQuery();
            while (rsLista.next()) {
                Riscontro trris = new Riscontro();
                if (rsLista.getString("riscontro") != null && !"".equals(rsLista.getString("riscontro"))) {
                    trris.setID(rsLista.getString("riscontro"));
                }
                if (rsLista.getTimestamp("ora_registrazione") != null) {
                    trris.setOraRegistrazione((java.util.Date)rsLista.getTimestamp("ora_registrazione"));
                }
                if (rsLista.getString("tipo_ora_reg") != null && !"".equals(rsLista.getString("tipo_ora_reg"))) {
                    trris.setTipoOraRegistrazione(rsLista.getString("tipo_ora_reg"));
                }
                busta.addRiscontro(trris);
            }
            rsLista.close();
            pstmtLista.close();
            tr.setBusta(busta);
        }
        rs.close();
        pstmt.close();
        if (tr == null) {
            throw new DriverTracciamentoNotFoundException("Traccia non trovata (id:" + id + ")");
        }
        Traccia traccia = tr;
        Object var14_16 = null;
        try {
            rsLista.close();
        }
        catch (Exception eClose) {
            // empty catch block
        }
        try {
            pstmtLista.close();
        }
        catch (Exception eClose) {
            // empty catch block
        }
        try {
            rs.close();
        }
        catch (Exception eClose) {
            // empty catch block
        }
        try {
            pstmt.close();
        }
        catch (Exception eClose) {
            // empty catch block
        }
        {
            return traccia;
            catch (DriverTracciamentoNotFoundException d) {
                throw d;
            }
            catch (Exception e) {
                throw new DriverTracciamentoException("Tracciamento exception: " + e.getMessage(), e);
            }
        }
        catch (Throwable throwable) {
            Object var14_17 = null;
            try {
                rsLista.close();
            }
            catch (Exception eClose) {
                // empty catch block
            }
            try {
                pstmtLista.close();
            }
            catch (Exception eClose) {
                // empty catch block
            }
            try {
                rs.close();
            }
            catch (Exception eClose) {
                // empty catch block
            }
            try {
                pstmt.close();
            }
            catch (Exception eClose) {}
            throw throwable;
        }
    }

    /*
     * Loose catch block
     */
    @Override
    public int countTracce(FiltroRicercaTracce filtro) throws DriverTracciamentoException, SQLQueryObjectException {
        Connection connectionDB = null;
        Statement pstmt = null;
        ResultSet rs = null;
        int contatore = 0;
        if (this.connection != null) {
            connectionDB = this.connection;
        } else {
            connectionDB = this.datasource.getConnection();
            if (connectionDB == null) {
                throw new Exception("Connection non ottenuta dal datasource[" + this.datasource + "]");
            }
        }
        ISQLQueryObject sqlQueryObject = this.getSQLQueryObject();
        sqlQueryObject.addFromTable("tracce");
        sqlQueryObject.addSelectField("id");
        this.addWhereConditions(sqlQueryObject, filtro);
        sqlQueryObject.setANDLogicOperator(true);
        this.log.debug((Object)("Query: " + sqlQueryObject.toString()));
        pstmt = connectionDB.prepareStatement(sqlQueryObject.toString());
        this.addWhereConditions((PreparedStatement)pstmt, filtro);
        rs = pstmt.executeQuery();
        while (rs.next()) {
            ++contatore;
        }
        rs.close();
        pstmt.close();
        int n = contatore;
        Object var9_9 = null;
        try {
            rs.close();
        }
        catch (Exception eClose) {
            // empty catch block
        }
        try {
            pstmt.close();
        }
        catch (Exception eClose) {
            // empty catch block
        }
        try {
            if (this.connection == null) {
                connectionDB.close();
            }
        }
        catch (Exception eClose) {
            // empty catch block
        }
        return n;
        catch (Exception e) {
            try {
                throw new DriverTracciamentoException("Tracciamento exception: " + e.getMessage(), e);
            }
            catch (Throwable throwable) {
                Object var9_10 = null;
                try {
                    rs.close();
                }
                catch (Exception eClose) {
                    // empty catch block
                }
                try {
                    pstmt.close();
                }
                catch (Exception eClose) {
                    // empty catch block
                }
                try {
                    if (this.connection == null) {
                        connectionDB.close();
                    }
                }
                catch (Exception eClose) {}
                throw throwable;
            }
        }
    }

    @Override
    public Traccia[] getTracce(FiltroRicercaTracce filtro) throws DriverTracciamentoException, DriverTracciamentoNotFoundException, SQLQueryObjectException {
        ResultSet rs;
        Statement pstmt;
        Connection connectionDB;
        block24: {
            connectionDB = null;
            pstmt = null;
            rs = null;
            Vector<Traccia> tracce = new Vector<Traccia>();
            if (this.connection != null) {
                connectionDB = this.connection;
            } else {
                connectionDB = this.datasource.getConnection();
                if (connectionDB == null) {
                    throw new Exception("Connection non ottenuta dal datasource[" + this.datasource + "]");
                }
            }
            ISQLQueryObject sqlQueryObject = this.getSQLQueryObject();
            sqlQueryObject.addFromTable("tracce");
            sqlQueryObject.addSelectField("id");
            sqlQueryObject.addSelectField("gdo");
            sqlQueryObject.addSelectField("tipo_messaggio");
            this.addWhereConditions(sqlQueryObject, filtro);
            if (filtro.getOffset() > -1 || filtro.getLimit() > 0) {
                if (filtro.getOffset() > -1) {
                    sqlQueryObject.setOffset(filtro.getOffset());
                }
                if (filtro.getLimit() > 0) {
                    sqlQueryObject.setLimit(filtro.getLimit());
                }
                sqlQueryObject.addOrderBy("gdo");
                sqlQueryObject.addOrderBy("tipo_messaggio");
            }
            sqlQueryObject.setANDLogicOperator(true);
            this.log.debug((Object)("Query: " + sqlQueryObject.toString()));
            pstmt = connectionDB.prepareStatement(sqlQueryObject.toString());
            this.addWhereConditions((PreparedStatement)pstmt, filtro);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                Long id = rs.getLong("id");
                tracce.add(this.getTraccia(id, connectionDB));
            }
            rs.close();
            pstmt.close();
            if (tracce.size() <= 0) break block24;
            Traccia[] tracciaArray = tracce.toArray(new Traccia[1]);
            Object var9_10 = null;
            try {
                rs.close();
            }
            catch (Exception eClose) {
                // empty catch block
            }
            try {
                pstmt.close();
            }
            catch (Exception eClose) {
                // empty catch block
            }
            try {
                if (this.connection == null) {
                    connectionDB.close();
                }
            }
            catch (Exception eClose) {
                // empty catch block
            }
            return tracciaArray;
        }
        try {
            try {
                throw new DriverTracciamentoNotFoundException("Non sono state trovate tracce che rispettano i criteri di ricerca impostati");
            }
            catch (DriverTracciamentoNotFoundException e) {
                throw e;
            }
            catch (Exception e) {
                throw new DriverTracciamentoException("Tracciamento exception: " + e.getMessage(), e);
            }
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            try {
                rs.close();
            }
            catch (Exception eClose) {
                // empty catch block
            }
            try {
                pstmt.close();
            }
            catch (Exception eClose) {
                // empty catch block
            }
            try {
                if (this.connection == null) {
                    connectionDB.close();
                }
            }
            catch (Exception eClose) {}
            throw throwable;
        }
    }

    /*
     * Loose catch block
     */
    @Override
    public int deleteTracce(FiltroRicercaTracce filter) throws DriverTracciamentoException {
        int n;
        Statement stmt;
        Connection con;
        int deleted;
        block19: {
            deleted = 0;
            con = this.getConnection();
            stmt = null;
            con.setAutoCommit(false);
            this.log.debug((Object)"Richiesta Delete Tracce");
            this.log.debug((Object)("Filtro Impostato: " + filter.toString()));
            Date data = new Date(filter.getMaxDate().getTime());
            ISQLQueryObject sqlQueryObjectINTO = SQLObjectFactory.createSQLQueryObject((String)this.tipoDatabase);
            sqlQueryObjectINTO.addSelectField("tracce.id");
            sqlQueryObjectINTO.addFromTable("tracce");
            sqlQueryObjectINTO.addWhereCondition("tracce.gdo<?");
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDatabase);
            sqlQueryObject.addDeleteTable("tracce_eccezioni");
            sqlQueryObject.addWhereINSelectSQLCondition(false, "tracce_eccezioni.idtraccia", sqlQueryObjectINTO);
            String sql = sqlQueryObject.createSQLDelete();
            this.log.debug((Object)("Eseguo query : " + sql.replace("?", data.toString())));
            try {
                stmt = con.prepareStatement(sql);
                stmt.setDate(1, data);
                deleted = stmt.executeUpdate();
            }
            catch (SQLException e) {
                throw new DriverTracciamentoException("[" + sql + "] " + e);
            }
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDatabase);
            sqlQueryObject.addDeleteTable("tracce_riscontri");
            sqlQueryObject.addWhereINSelectSQLCondition(false, "tracce_riscontri.idtraccia", sqlQueryObjectINTO);
            sql = sqlQueryObject.createSQLDelete();
            this.log.debug((Object)("Eseguo query : " + sql.replace("?", data.toString())));
            try {
                stmt = con.prepareStatement(sql);
                stmt.setDate(1, data);
                deleted = stmt.executeUpdate();
            }
            catch (SQLException e) {
                throw new DriverTracciamentoException("[" + sql + "] " + e);
            }
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDatabase);
            sqlQueryObject.addDeleteTable("tracce_trasmissioni");
            sqlQueryObject.addWhereINSelectSQLCondition(false, "tracce_trasmissioni.idtraccia", sqlQueryObjectINTO);
            sql = sqlQueryObject.createSQLDelete();
            this.log.debug((Object)("Eseguo query : " + sql.replace("?", data.toString())));
            try {
                stmt = con.prepareStatement(sql);
                stmt.setDate(1, data);
                deleted = stmt.executeUpdate();
            }
            catch (SQLException e) {
                throw new DriverTracciamentoException("[" + sql + "] " + e);
            }
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDatabase);
            sqlQueryObject.addDeleteTable("tracce");
            sqlQueryObject.addWhereCondition("tracce.gdo<?");
            sql = sqlQueryObject.createSQLDelete();
            this.log.debug((Object)("Eseguo query : " + sql.replace("?", data.toString())));
            try {
                stmt = con.prepareStatement(sql);
                stmt.setDate(1, data);
                deleted = stmt.executeUpdate();
            }
            catch (SQLException e) {
                throw new DriverTracciamentoException("[" + sql + "] " + e);
            }
            con.commit();
            con.setAutoCommit(true);
            n = deleted;
            Object var11_16 = null;
            if (stmt == null) break block19;
            try {
                stmt.close();
            }
            catch (SQLException e2) {
                // empty catch block
            }
        }
        this.releaseConnection(con);
        this.log.debug((Object)("Tracce Eliminate: " + deleted));
        return n;
        catch (Exception e) {
            try {
                if (con != null) {
                    try {
                        con.rollback();
                    }
                    catch (SQLException e1) {
                        // empty catch block
                    }
                }
                throw new DriverTracciamentoException(e);
            }
            catch (Throwable throwable) {
                Object var11_17 = null;
                if (stmt != null) {
                    try {
                        stmt.close();
                    }
                    catch (SQLException e2) {
                        // empty catch block
                    }
                }
                this.releaseConnection(con);
                this.log.debug((Object)("Tracce Eliminate: " + deleted));
                throw throwable;
            }
        }
    }

    private void addWhereConditions(ISQLQueryObject sqlQueryObject, FiltroRicercaTracce filtro) throws SQLQueryObjectException {
        if (filtro.getTipoSoggettoMittente() != null) {
            sqlQueryObject.addWhereCondition("tipo_mittente=?");
        }
        if (filtro.getNomeSoggettoMittente() != null) {
            sqlQueryObject.addWhereCondition("mittente=?");
        }
        if (filtro.getTipoSoggettoDestinatario() != null) {
            sqlQueryObject.addWhereCondition("tipo_destinatario=?");
        }
        if (filtro.getNomeSoggettoDestinatario() != null) {
            sqlQueryObject.addWhereCondition("destinatario=?");
        }
        if (filtro.getTipoServizio() != null) {
            sqlQueryObject.addWhereCondition("tipo_servizio=?");
        }
        if (filtro.getNomeServizio() != null) {
            sqlQueryObject.addWhereCondition("servizio=?");
        }
        if (filtro.getAzione() != null) {
            sqlQueryObject.addWhereCondition("azione=?");
        }
        if (filtro.getProfiloCollaborazione() != null) {
            sqlQueryObject.addWhereCondition("profilo_collaborazione=?");
        }
        if (filtro.getIdEGov() != null) {
            sqlQueryObject.addWhereCondition("id_egov=?");
        }
        if (filtro.getRifMessaggio() != null) {
            sqlQueryObject.addWhereCondition("rif_messaggio=?");
        }
        if (filtro.getIdCorrelazioneApplicativa() != null) {
            sqlQueryObject.addWhereCondition("correlazione_applicativa=?");
        }
        if (filtro.getTipoTraccia() != null) {
            sqlQueryObject.addWhereCondition("tipo_messaggio=?");
        }
        if (filtro.getIdentificativoPorta() != null) {
            sqlQueryObject.addWhereCondition("idporta=?");
        }
        if (filtro.getMinDate() != null) {
            sqlQueryObject.addWhereCondition("gdo>=?");
        }
        if (filtro.getMaxDate() != null) {
            sqlQueryObject.addWhereCondition("gdo<=?");
        }
        if (filtro.getSpcoopErrore()) {
            ISQLQueryObject sqlQueryObjectSPCoopErrore = this.getSQLQueryObject();
            sqlQueryObjectSPCoopErrore.addFromTable("tracce_eccezioni");
            sqlQueryObjectSPCoopErrore.addSelectField("idtraccia");
            sqlQueryObjectSPCoopErrore.addWhereCondition("tracce.id=tracce_eccezioni.idtraccia");
            sqlQueryObject.addWhereExistsCondition(false, sqlQueryObjectSPCoopErrore);
        }
        if (filtro.getPropertiesNames() != null && filtro.getPropertiesNames().length > 0) {
            String[] names = filtro.getPropertiesNames();
            for (int i = 0; i < names.length; ++i) {
                sqlQueryObject.addWhereCondition(names[i] + "=?");
            }
        }
    }

    private void addWhereConditions(PreparedStatement pstmt, FiltroRicercaTracce filtro) throws SQLException {
        int index = 0;
        if (filtro.getTipoSoggettoMittente() != null) {
            pstmt.setString(++index, filtro.getTipoSoggettoMittente());
        }
        if (filtro.getNomeSoggettoMittente() != null) {
            pstmt.setString(++index, filtro.getNomeSoggettoMittente());
        }
        if (filtro.getTipoSoggettoDestinatario() != null) {
            pstmt.setString(++index, filtro.getTipoSoggettoDestinatario());
        }
        if (filtro.getNomeSoggettoDestinatario() != null) {
            pstmt.setString(++index, filtro.getNomeSoggettoDestinatario());
        }
        if (filtro.getTipoServizio() != null) {
            pstmt.setString(++index, filtro.getTipoServizio());
        }
        if (filtro.getNomeServizio() != null) {
            pstmt.setString(++index, filtro.getNomeServizio());
        }
        if (filtro.getAzione() != null) {
            pstmt.setString(++index, filtro.getAzione());
        }
        if (filtro.getProfiloCollaborazione() != null) {
            pstmt.setString(++index, filtro.getProfiloCollaborazione());
        }
        if (filtro.getIdEGov() != null) {
            pstmt.setString(++index, filtro.getIdEGov());
        }
        if (filtro.getRifMessaggio() != null) {
            pstmt.setString(++index, filtro.getRifMessaggio());
        }
        if (filtro.getIdCorrelazioneApplicativa() != null) {
            pstmt.setString(++index, filtro.getIdCorrelazioneApplicativa());
        }
        if (filtro.getTipoTraccia() != null) {
            pstmt.setString(++index, filtro.getTipoTraccia());
        }
        if (filtro.getIdentificativoPorta() != null) {
            pstmt.setString(++index, filtro.getIdentificativoPorta());
        }
        if (filtro.getMinDate() != null) {
            pstmt.setTimestamp(++index, new Timestamp(filtro.getMinDate().getTime()));
        }
        if (filtro.getMaxDate() != null) {
            pstmt.setTimestamp(++index, new Timestamp(filtro.getMaxDate().getTime()));
        }
        if (filtro.getPropertiesNames() != null && filtro.getPropertiesNames().length > 0) {
            String[] names = filtro.getPropertiesNames();
            for (int i = 0; i < names.length; ++i) {
                String value = filtro.getProperty(names[i]);
                pstmt.setString(++index, value);
            }
        }
    }

    public Connection getConnection() {
        if (this.datasource == null) {
            return null;
        }
        Connection connectionDB = null;
        try {
            connectionDB = this.datasource.getConnection();
        }
        catch (Exception e) {
            return null;
        }
        return connectionDB;
    }

    public void releaseConnection(Connection connectionDB) {
        try {
            if (connectionDB != null) {
                connectionDB.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public String getTipoDatabase() {
        return this.tipoDatabase;
    }
}

