/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop.pdd.core.state;

import java.io.Serializable;
import java.util.Hashtable;
import org.apache.axis.Message;
import org.openspcoop.dao.state.IState;
import org.openspcoop.dao.state.StatelessMessage;
import org.openspcoop.egov.Busta;
import org.openspcoop.pdd.core.DimensioneMessaggiAttraversamentoPdD;
import org.openspcoop.pdd.core.PdDContext;
import org.openspcoop.pdd.core.TempiAttraversamentoPDD;
import org.openspcoop.pdd.core.state.OpenSPCoopState;
import org.openspcoop.utils.UtilsException;

public class OpenSPCoopStateless
extends OpenSPCoopState
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Message richiestaMsg = null;
    private Message rispostaMsg = null;
    private String destinatarioRequestMsgLib;
    private String destinatarioResponseMsgLib;
    private TempiAttraversamentoPDD tempiAttraversamentoPDD = null;
    private DimensioneMessaggiAttraversamentoPdD dimensioneMessaggiAttraversamentoPDD = null;
    private String idCorrelazioneApplicativa = null;
    private PdDContext pddContext = null;

    public OpenSPCoopStateless(StatelessMessage richiesta, Message richiestaMsg, StatelessMessage risposta, Message rispostaMsg) {
        this.richiestaStato = richiesta;
        this.richiestaMsg = richiestaMsg;
        this.rispostaStato = risposta;
        this.rispostaMsg = rispostaMsg;
        this.useConnection = false;
        this.tempiAttraversamentoPDD = new TempiAttraversamentoPDD();
        this.dimensioneMessaggiAttraversamentoPDD = new DimensioneMessaggiAttraversamentoPdD();
    }

    public OpenSPCoopStateless(StatelessMessage richiesta, Message richiestaMsg) {
        this.richiestaStato = richiesta;
        this.richiestaMsg = richiestaMsg;
        this.useConnection = false;
        this.tempiAttraversamentoPDD = new TempiAttraversamentoPDD();
        this.dimensioneMessaggiAttraversamentoPDD = new DimensioneMessaggiAttraversamentoPdD();
    }

    public OpenSPCoopStateless() {
        this.useConnection = false;
        this.tempiAttraversamentoPDD = new TempiAttraversamentoPDD();
        this.dimensioneMessaggiAttraversamentoPDD = new DimensioneMessaggiAttraversamentoPdD();
    }

    public void updateStatoRichiesta() throws UtilsException {
        Hashtable pstmt = null;
        Busta bustaTmp = null;
        Busta bustaCorrelataTmp = null;
        if (this.richiestaStato != null) {
            if (this.richiestaStato.getPreparedStatement() != null) {
                pstmt = this.richiestaStato.getPreparedStatement();
            }
            StatelessMessage statelessMessage = (StatelessMessage)this.richiestaStato;
            bustaTmp = statelessMessage.getBusta();
            bustaCorrelataTmp = statelessMessage.getBustaCorrelata();
        }
        this.richiestaStato = new StatelessMessage(this.connectionDB, this.logger);
        if (pstmt != null) {
            this.richiestaStato.addPreparedStatement(pstmt);
        }
        if (bustaTmp != null) {
            ((StatelessMessage)this.richiestaStato).setBusta(bustaTmp);
        }
        if (bustaCorrelataTmp != null) {
            ((StatelessMessage)this.richiestaStato).setBustaCorrelata(bustaCorrelataTmp);
        }
    }

    public void updateStatoRisposta() throws UtilsException {
        Hashtable pstmt = null;
        Busta bustaTmp = null;
        Busta bustaCorrelataTmp = null;
        if (this.rispostaStato != null) {
            if (this.rispostaStato.getPreparedStatement() != null) {
                pstmt = this.rispostaStato.getPreparedStatement();
            }
            StatelessMessage statelessMessage = (StatelessMessage)this.rispostaStato;
            bustaTmp = statelessMessage.getBusta();
            bustaCorrelataTmp = statelessMessage.getBustaCorrelata();
        }
        this.rispostaStato = new StatelessMessage(this.connectionDB, this.logger);
        if (pstmt != null) {
            this.rispostaStato.addPreparedStatement(pstmt);
        }
        if (bustaTmp != null) {
            ((StatelessMessage)this.rispostaStato).setBusta(bustaTmp);
        }
        if (bustaCorrelataTmp != null) {
            ((StatelessMessage)this.rispostaStato).setBustaCorrelata(bustaCorrelataTmp);
        }
    }

    public OpenSPCoopStateless rendiSerializzabile() {
        OpenSPCoopStateless stato = new OpenSPCoopStateless();
        StatelessMessage statoRichiesta = new StatelessMessage(null, null);
        StatelessMessage statoRisposta = new StatelessMessage(null, null);
        statoRichiesta.setBusta(((StatelessMessage)this.richiestaStato).getBusta());
        statoRisposta.setBusta(((StatelessMessage)this.rispostaStato).getBusta());
        stato.setStatoRichiesta((IState)statoRichiesta);
        stato.setStatoRisposta((IState)statoRisposta);
        stato.setTempiAttraversamentoPDD(this.getTempiAttraversamentoPDD());
        stato.setDimensioneMessaggiAttraversamentoPDD(this.getDimensioneMessaggiAttraversamentoPDD());
        return stato;
    }

    public void setDestinatarioRequestMsgLib(String nextLib) {
        this.destinatarioRequestMsgLib = nextLib;
    }

    public String getDestinatarioRequestMsgLib() {
        return this.destinatarioRequestMsgLib;
    }

    public String getDestinatarioResponseMsgLib() {
        return this.destinatarioResponseMsgLib;
    }

    public void setDestinatarioResponseMsgLib(String destinatarioResponseMsgLib) {
        this.destinatarioResponseMsgLib = destinatarioResponseMsgLib;
    }

    public void setRichiestaMsg(Message richiestaMsg) {
        this.richiestaMsg = richiestaMsg;
    }

    public Message getRichiestaMsg() {
        return this.richiestaMsg;
    }

    public void setRispostaMsg(Message rispostaMsg) {
        this.rispostaMsg = rispostaMsg;
    }

    public Message getRispostaMsg() {
        return this.rispostaMsg;
    }

    public TempiAttraversamentoPDD getTempiAttraversamentoPDD() {
        return this.tempiAttraversamentoPDD;
    }

    public void setTempiAttraversamentoPDD(TempiAttraversamentoPDD tempiAttraversamentoPDD) {
        this.tempiAttraversamentoPDD = tempiAttraversamentoPDD;
    }

    public DimensioneMessaggiAttraversamentoPdD getDimensioneMessaggiAttraversamentoPDD() {
        return this.dimensioneMessaggiAttraversamentoPDD;
    }

    public void setDimensioneMessaggiAttraversamentoPDD(DimensioneMessaggiAttraversamentoPdD dimensioneMessaggiAttraversamentoPDD) {
        this.dimensioneMessaggiAttraversamentoPDD = dimensioneMessaggiAttraversamentoPDD;
    }

    public boolean isUseConnection() {
        return this.useConnection;
    }

    public void setUseConnection(boolean useConnection) {
        this.useConnection = useConnection;
    }

    public String getIDCorrelazioneApplicativa() {
        return this.idCorrelazioneApplicativa;
    }

    public void setIDCorrelazioneApplicativa(String idCorrelazioneApplicativa) {
        this.idCorrelazioneApplicativa = idCorrelazioneApplicativa;
    }

    public PdDContext getPddContext() {
        return this.pddContext;
    }

    public void setPddContext(PdDContext pddContext) {
        this.pddContext = pddContext;
    }
}

